<?php
namespace YES4Trade\Model;

class groups extends \YES4Trade\Model\BaseType{
    const TABLE_NAME = 'groups';
    const TABLE_INDEX = 'groups_id';
    var $characteristics = [];
    private static $propertyTypes = [
        'groups_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'groups_id'
        ],
        'groups_title' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'groups_title'
        ],
        'groups_created' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'groups_created'
        ],
        'groups_last_changed' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'groups_last_changed'
        ],
        'visible' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'visible'
        ],
        'ebay_visible' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_visible'
        ]
    ];
    
    public function __construct( array $values = [] ){
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }

    public function create(){
        xtc_db_perform(sprintf("`%s`",self::TABLE_NAME), $this->toArray());
        \YES4Trade\Model\group_handler::clear_cache();
        return xtc_db_insert_id();
    }
    
    public function update(){
        $data = $this->toArray();
        unset($data[self::TABLE_INDEX]);
        $index = self::TABLE_INDEX;
        xtc_db_perform(sprintf("`%s`",self::TABLE_NAME), $data,'update',self::TABLE_INDEX."='".$this->$index."'");
        \YES4Trade\Model\group_handler::clear_cache();
    }
    
    public function get_characteristicsData( int $language_id = -1 ){
        return \YES4Trade\Model\groups_characteristic::get_by_groups_id($this->groups_id, $language_id);
    }
    
    public static function delete( int $index ){
        $allocs = \YES4Trade\Model\groups_products::get_by_groups_id($index);
        foreach($allocs as $c){
            \YES4Trade\Model\groups_products::delete($index, $c->products_id);
        }
        xtc_db_query(sprintf(
                "DELETE FROM %s WHERE %s='%d'",
                sprintf("`%s`",self::TABLE_NAME),self::TABLE_INDEX, $index
        ));
        $characteristics = \YES4Trade\Model\groups_characteristic::get_by_groups_id( $index );
        foreach($characteristics as $c){
            \YES4Trade\Model\groups_characteristic::delete( $c->products_characteristic_id );
        }
        foreach(\YES4Trade\Model\groups_categories::get_by_groups_id($index) as $gc){
            \YES4Trade\Model\groups_categories::delete($gc->categories_to_groups_id);
        }
        
        \YES4Trade\Model\group_handler::clear_cache();
    }
    
    public static function get_by_groups_id( int $index, int $language_id = -1 ){
        $record = yes_query(sprintf(
            "SELECT * FROM %s WHERE %s=:id",
                sprintf('`%s`',self::TABLE_NAME), self::TABLE_INDEX
            ),['id'=>$index],true
        );
        foreach($record as $k=>$v){
            switch($k){
                case 'groups_id':
                case 'visible':
                case 'ebay_visible':
                    $record[$k] = (int)$v;
                    break;
            }
        }
        return new self($record );
    }
    
    public function get_as_array(){
        yes_debug(gettype($this));
    }
    
}