<?php
namespace YES4Trade\Model;

class groups_categories_characteristics extends \YES4Trade\Model\BaseType{
    const TABLE_NAME = 'categories_to_groups_characteristics';
    const TABLE_INDEX = 'categories_to_groups_characteristics_id';
    private static $propertyTypes = [
        'categories_to_groups_characteristics_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'categories_to_groups_characteristics_id'
        ],
        'categories_to_groups_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'categories_to_groups_id'
        ],
        'characteristics_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'characteristics_id'
        ],
    ];
    
    public function __construct( array $values = [] ){
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }

    public function create(){
        $data = $this->toArray();
        unset($data['categories_to_groups_characteristics_id']);
        xtc_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }
    
   
    public static function delete( int $index ){
        xtc_db_query(sprintf(
                "DELETE FROM %s WHERE %s='%d'",
                self::TABLE_NAME,self::TABLE_INDEX, $index
        ));
    }
    
    public static function get_by_categories_to_groups_id( int $categories_to_groups_id ){
        $items = [];
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE categories_to_groups_id=:id",
                self::TABLE_NAME
            ),['id'=>$categories_to_groups_id]
        );
        foreach($query as $record){
            foreach($record as $k=>$v){
                $record[ $k ] = (int) $v;
            }
            $items[] = new self($record);
        }
        return $items;
    }
}