<?php
namespace YES4Trade\Model;

class manufacturers_info extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'manufacturers_info';

    private static $propertyTypes = [
        'manufacturers_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturers_id'
        ],
        'languages_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'languages_id'
        ],
        'manufacturers_meta_title' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturers_meta_title'
        ],
        'manufacturers_meta_description' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturers_meta_description'
        ],
        'manufacturers_meta_keywords' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturers_meta_keywords'
        ],
        'manufacturers_url' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'manufacturers_url'
        ],
        'url_clicked' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'url_clicked'
        ],
        'date_last_click' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'date_last_click'
        ],
    ];


    public function __construct(array $values = []) {
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);
        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }
        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }
        $this->setValues(__CLASS__, $childValues);
    }


    public function create() {
        $data = $this->toArray();
        yes_db_perform(self::TABLE_NAME, self::convert_values($data,self::$propertyTypes));
        return xtc_db_insert_id();
    }


    public function update() {
        $data = $this->toArray();
        if(!isset($data['manufacturers_id']) or !isset($data['languages_id'])){
            throw new Exception('manufacturers_info Update only with manufacturers_id and languages_id');
        }
        yes_db_perform(self::TABLE_NAME, self::convert_values($data,self::$propertyTypes),'update',[
            'manufacturers_id'=>(int)$data['manufacturers_id'],
            'languages_id'=>(int)$data['languages_id']
        ]);
    }


    public static function delete(int $manufacturers_id, int $languages_id) {
        yes_query(sprintf(
                "DELETE FROM %s WHERE manufacturers_id=:id AND languages_id=:languages_id",
                self::TABLE_NAME
           ),['id'=>$manufacturers_id,'languages_id'=>$languages_id]
        );
    }


    public static function get_by_manufacturers_id_and_language_id(int $manufacturers_id, int $languages_id) {
        global $InstanceCache;
        $key = 'manufacturers.info-id'.$manufacturers_id.'-lang'.$languages_id;
        $CachedString = $InstanceCache->getItem($key);
        if (!$CachedString->isHit()) {
            $record = yes_query(sprintf(
                "SELECT * FROM %s WHERE manufacturers_id=:id AND languages_id=:languages_id",
                   self::TABLE_NAME
                ),['id'=>$manufacturers_id,'languages_id'=>$languages_id],
                true
            );
            $CachedString->set($record)->expiresAfter(3600);//manufacturers.info-id*-lang*
            $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
        }else{
            $record = $CachedString->get();
        }
        
        if(!is_countable($record) or !sizeOf($record)){
            return null;
        }
        return new self(self::convert_values($record,self::$propertyTypes));
    }

}
