<?php    
namespace YES4Trade\Model;

use YES4Trade\Enums\ADR_Class;

class product_un_classification extends \YES4Trade\Model\BaseType{
    const TABLE_NAME = 'product_un_classification';
    const TABLE_INDEX = 'product_un_classification_id';
    private static $propertyTypes = [
        'product_un_classification_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'product_un_classification_id'
        ],
        'products_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_id'
        ],
        'un_classifications_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'un_classifications_id'
        ], 
        'ADR_Class' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ADR_Class',
        ], 
        'Packaging_Group' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'Packaging_Group',
        ], 
        'Bk' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'Bk',
        ], 
        'TUNNEL_CATEGORY'=>[
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'TUNNEL_CATEGORY',
        ], 
    ];
    
    public function __construct( array $values = [] ){
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }
    
    public function create(){
        $data = $this->toArray();
        xtc_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }
    
    public function update(){
        $data = $this->toArray();
        unset($data[self::TABLE_INDEX]);
        $index = self::TABLE_INDEX;
        xtc_db_perform(self::TABLE_NAME, $data,'update',self::TABLE_INDEX."='".$this->$index."'");
    }
    
    public static function delete( int $index ){
        xtc_db_query(sprintf(
                "DELETE FROM %s WHERE %s='%d'",
                self::TABLE_NAME,self::TABLE_INDEX, $index
        ));
    }
    
    public static function get_by_product_un_classification_id( int $product_un_classification_id, array $select_fields = [] ){
        if($product_un_classification_id < 1){
            return null;
        }
        $select_field_string = '*';
        if(sizeOf($select_fields)){
            $select_field_string = implode(',',$select_fields);
        }
        $query = yes_query(sprintf(
            "SELECT %s FROM %s WHERE %s=:id",
                $select_field_string,self::TABLE_NAME, self::TABLE_INDEX
            ),['id'=>$product_un_classification_id]
        );
        if(sizeOf($query)){
            $record = current($query);
            if(isset($record[self::TABLE_INDEX])){
                $record[self::TABLE_INDEX] = (int)$record[self::TABLE_INDEX];
            }
            return new self($record);
        }
        return null;
    }
    
    public static function get_by_products_id(int $products_id){
        if($products_id < 1){
            return null;
        }
        $record = yes_query(sprintf(
            "SELECT * FROM %s WHERE products_id=:id",
                self::TABLE_NAME
            ),['id'=>$products_id],
            true
        );
        if($record !== false){
            return new self($record);
        }
        return null;
    }
    
    public static function get_by_un_classifications_id(int $un_classifications_id):array{
        $return = [];
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE un_classifications_id=:value",
                self::TABLE_NAME
            ),['value'=>$un_classifications_id],
        );
        foreach($query as $record){
            $return[] = new self($record);
        }
        return $return;
    }

    public function get_un_classification_values(){
        $un = \YES4Trade\Model\un_classifications::get_by_un_classifications_id($this->un_classifications_id);
        $un_classification_title = $un->un_title;
        $adr = \YES4Trade\Enums\ADR_Class::fromName($this->ADR_Class);
        $adr_title = $adr->value;
        $packg = \YES4Trade\Enums\Packaging_Group::fromName($this->Packaging_Group);
        $packg_title = $packg->value;
        $bk = \YES4Trade\Enums\Bk::fromName($this->Bk);
        $bk_title = $bk->value;
        $tc = \YES4Trade\Enums\TUNNEL_CATEGORY::fromName($this->TUNNEL_CATEGORY);
        $tc_title = $tc->value;
        return [
            'UN_CLASSIFICATION'=>$un_classification_title,
            'ADR_Class'=>['title'=>constant('ADR_Class_TITLE'),'value'=>$adr_title],
            'Packaging_Group'=>['title'=>constant('Packaging_Group_TITLE'),'value'=>$packg_title],
            'Bk'=>['title'=>constant('Bk_TITLE'),'value'=>$bk_title],
            'TUNNEL'=>['title'=>constant('TUNNEL_CATEGORY'),'value'=>$tc_title],
        ];
    }

    public function get_un_classification_title(){
        $arr = $this->get_un_classification_values();
        return sprintf('%s (%s: %s / %s: %s / %s: %s / %s: %s)',
            $arr['UN_CLASSIFICATION'],
            $arr['ADR_Class']['title'],
            $arr['ADR_Class']['value'],
            $arr['Packaging_Group']['title'],
            $arr['Packaging_Group']['value'],

            $arr['Bk']['title'],
            $arr['Bk']['value'],

            $arr['TUNNEL']['title'],
            $arr['TUNNEL']['value'],
        );
    }
}