<?php

namespace YES4Trade\Model;

class products_meldebestand_customers extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'products_meldebestand_customers';
    const TABLE_INDEX = 'products_meldebestand_customers_id';

    private static $propertyTypes = [
        'products_meldebestand_customers_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_meldebestand_customers_id'
        ],
        'products_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_id'
        ],
        'customers_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_id'
        ],
    ];


	public function __construct(array $values = []) {
		list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
		parent::__construct($parentValues);
		if (!array_key_exists(__CLASS__, self::$properties)) {
			self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
		}
		if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
			self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
		}
		$this->setValues(__CLASS__, $childValues);
	}


	public function create() {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		yes_db_perform(self::TABLE_NAME, $data);
		return xtc_db_insert_id();
	}


	public function update() {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		unset($data[self::TABLE_INDEX]);
		$index = self::TABLE_INDEX;
		yes_db_perform(self::TABLE_NAME, $data,'update',[$index=>$this->$index]);
	}


	public static function delete(int $index) {
		yes_query(sprintf(
			"DELETE FROM %s WHERE %s=:id",
				self::TABLE_NAME,self::TABLE_INDEX
			),['id'=>$index]
		);
	}


	public static function get_by_products_meldebestand_customers_id(int $products_meldebestand_customers_id, array $select_fields = []) {
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s WHERE %s=:id",
				$select_field_string,self::TABLE_NAME, self::TABLE_INDEX
			),['id'=>$products_meldebestand_customers_id]
		);
		if(!sizeOf($query)){
			return null;
		}
		$record = current($query);
		return new self(self::convert_values($record,self::$propertyTypes));
	}
        
        public static function get_by_products_id(int $products_id):array{
            $items = [];
            $query = yes_query(sprintf(
                    "SELECT * FROM %s WHERE products_id=:id",
                        self::TABLE_NAME
                    ),['id'=>$products_id]
            );
            if(!sizeOf($query)){
                    return $items;
            }
            foreach($query as $record){
                $items[] = new self(self::convert_values($record,self::$propertyTypes));
            }
            return $items;
        }

        public static function get_by_customers_id_and_products_id(int $customers_id, int $products_id){
            $items = [];
            $query = yes_query(sprintf(
                    "SELECT * FROM %s WHERE products_id=:products_id AND customers_id=:customers_id",
                        self::TABLE_NAME
                    ),['products_id'=>$products_id,'customers_id'=>$customers_id]
            );
            if(!sizeOf($query)){
                    return $items;
            }
            foreach($query as $record){
                $items[] = new self(self::convert_values($record,self::$propertyTypes));
            }
            return $items;
        }
}
