<?php

namespace YES4Trade\Model;

class retoure_status_history extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'retoure_status_history';
    const TABLE_INDEX = 'retoure_status_history_id';
    public static $integerProperties = [
        'retoure_status_history_id',
        'retoure_id',
        'retoure_status_id',
        'customer_notified',
        'editor_id'
    ];
    private static $propertyTypes = [
        'retoure_status_history_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'retoure_status_history_id'
        ],
        'retoure_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'retoure_id'
        ],
        'retoure_status_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'retoure_status_id'
        ],
        'date_added' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'date_added'
        ],
        'customer_notified' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customer_notified'
        ],
        'comments' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'comments'
        ],
        'editor_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'editor_id'
        ],
    ];


public function __construct(array $values = []) {
    list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
    parent::__construct($parentValues);
    if (!array_key_exists(__CLASS__, self::$properties)) {
        self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
    }
    if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
        self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
    }
    $this->setValues(__CLASS__, $childValues);
    }


    public function create() {
        $data = $this->toArray();
        foreach($data as $k=>$v){
        	if(in_array($k,self::$integerProperties)){
        		$data[$k] = (int) $v;
        	}
        }
        xtc_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }


    public function update() {
        $data = $this->toArray();
        unset($data[self::TABLE_INDEX]);
        foreach($data as $k=>$v){
        	if(in_array($k,self::$integerProperties)){
        		$data[$k] = (int) $v;
        	}
        }
        $index = self::TABLE_INDEX;
        xtc_db_perform(self::TABLE_NAME, $data,'update',$index."='".$this->$index."'");
    }


    public static function delete(int $index) {
        xtc_db_query(sprintf(
                "DELETE FROM %s WHERE %s='%d'",
                self::TABLE_NAME,self::TABLE_INDEX, $index
        ));
    }


    public static function get_by_retoure_status_history_id(int $retoure_status_history_id) {
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE %s=:id",
                self::TABLE_NAME, self::TABLE_INDEX
            ),['id'=>$retoure_status_history_id]
        );
        if(!sizeOf($query)){
            return null;
        }
        $record = current($query);
        foreach($record as $k=>$v){
        	if(in_array($k,self::$integerProperties)){
        		$record[$k] = (int) $v;
        	}
        }
        return new self($record);
    }

    public static function get_by_retoure_id( int $retoure_id ){
        $items = [];
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE retoure_id=:id ORDER BY date_added DESC",
                self::TABLE_NAME
            ),['id'=>$retoure_id]
        );
        foreach($query as $record){
            foreach($record as $k=>$v){
                    if(in_array($k,self::$integerProperties)){
                            $record[$k] = (int) $v;
                    }
            }
            $items[] = new self($record);
        }
        return $items;
    }
}

