<?php

namespace YES4Trade\Model;

class wishlist_products extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'wishlist_products';
    const TABLE_INDEX = 'id';

    private static $propertyTypes = [
        'id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'id'
        ],
        'wishlist_customers_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'wishlist_customers_id'
        ],
        'products_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_id'
        ],
        'quantity' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'quantity'
        ],
        'memo' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'memo'
        ],
        'wishstatus' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'wishstatus'
        ],
        'ordered' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ordered'
        ],
        'create_date' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'create_date'
        ],
    ];


	public function __construct(array $values = []) {
		list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
		parent::__construct($parentValues);
		if (!array_key_exists(__CLASS__, self::$properties)) {
			self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
		}
		if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
			self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
		}
		$this->setValues(__CLASS__, $childValues);
	}


	public function create():int {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		yes_db_perform(self::TABLE_NAME, $data);
		return xtc_db_insert_id();
	}


	public function update():void {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		unset($data[self::TABLE_INDEX]);
		$index = self::TABLE_INDEX;
		yes_db_perform(self::TABLE_NAME, $data,'update',[$index=>$this->$index]);
	}


	public static function delete(int $index):void {
		yes_query(sprintf(
			"DELETE FROM %s WHERE %s=:id",
				self::TABLE_NAME,self::TABLE_INDEX
			),['id'=>$index]
		);
	}


	public static function get_by_id(int $id, array $select_fields = []) {
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s WHERE %s=:id",
				$select_field_string,self::TABLE_NAME, self::TABLE_INDEX
			),['id'=>$id]
		);
		if(!sizeOf($query)){
			return null;
		}
		$record = current($query);
		return new self(self::convert_values($record,self::$propertyTypes));
	}

	/**
	 * @param int $wishlist_customers_id
	 * @param array $select_fields
	 * 
	 * @return array
	 */
	public static function get_by_wishlist_customers_id(int $wishlist_customers_id, array $select_fields = []):array {
        $items = [];
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s WHERE wishlist_customers_id=:wcid",
				$select_field_string,self::TABLE_NAME
			),['wcid'=>$wishlist_customers_id]
		);
        foreach($query as $record){
		    $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
	}

	/**
	 * @param int $products_id
	 * @param array $select_fields
	 * 
	 * @return array
	 */
	public static function get_by_products_id(int $products_id, array $select_fields = []):array {
        $items = [];
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s WHERE products_id=:pid",
				$select_field_string,self::TABLE_NAME
			),['pid'=>$products_id]
		);
        foreach($query as $record){
		    $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
	}

}
