<?php
namespace YES4Trade\Model;
use basics, main;

class yes_boxes {
    const YES_BOXES_DIRECTORY = DIR_FS_CATALOG.'templates_scripts/boxes/';
    var $list, $configuration;
    public function __construct(){
        self::check_requirements();
        $list = [];
        foreach(self::read_directory() as $box_file){
            $list[] = new \YES4Trade\Model\yes_boxes_item( $box_file );
        }
        sort($list);
        $this->set_list($list);
        $this->set_configuration( new \YES4Trade\Model\yes_boxes_config() );
    }
    
    public function get_configuration() {
        return $this->configuration;
    }
    
    public function set_configuration( yes_boxes_config $configuration ){
        $this->configuration = $configuration;
    }
    
    public function get_list(){
        return $this->list;
    }
    
    public function set_list( $directory_content ){
        $this->list = $directory_content;
    }
    
    private static function check_requirements(){
        if(!is_dir(self::YES_BOXES_DIRECTORY) or !is_readable(self::YES_BOXES_DIRECTORY)){
            throw new Exception('Cant access boxes directory');
        }
    }
    
    public static function read_directory(){
        $files = [];
        foreach(scandir(self::YES_BOXES_DIRECTORY) as $file ){
            switch($file){
                case '.':
                case '..':
                    break;
                default:
                    if(strpos($file,'.php')>1){
                        $files[] = $file;
                    }
                    break;
            }
        }
        return $files;
    }
    
    public function get_config_string(){
        return $this->configuration->get_config_string();
    }
    
    public function load( $smarty, $page ){
        global $InstanceCache;
        foreach($this->get_list() as $box){
            if($box->get_active()===true && $box->allow_include( $page )){
                require_once(self::YES_BOXES_DIRECTORY.$box->get_id());
            }
        }
    }
}
