<?php
namespace YES4Trade\Model;
class yes_icon extends \YES4Trade\Model\BaseType{
    
    private static $propertyTypes = [
        'type' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'type'
        ],
        'class' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'class'
        ],
        'title' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'title'
        ],
    ];
    
    public function __construct( array $values = [] ){
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }

    public function parse(){
        switch($this->type){
            case 'edit':
                $text = IMAGE_EDIT;
                $icon = 'ui-icon-pencil';
                break;
            case 'add':
                $text = IMAGE_INSERT;
                $icon = 'ui-icon-circle-plus';
                break;
            case 'delete':
                $text = IMAGE_DELETE;
                $icon = 'ui-icon-trash';
                break;
            case 'info':
                $text = 'Info';
                $icon = 'ui-icon-info';
                break;
            case 'help':
                $text = 'Hilfe';
                $icon = 'ui-icon-help';
                break;
            case 'list':
                $text = 'Liste';
                $icon = 'ui-icon-circle-arrow-s';
                break;
            case 'print':
                $text = (defined('IMAGE_PRINT'))?IMAGE_PRINT:TEXT_PRINT;
                $icon = 'ui-icon-print';
                break;
            case 'date':
                $text = 'Kalender';
                $icon = 'ui-icon-calendar';
                break;
            case 'plus':
                $text = IMAGE_INSERT;
                $icon = 'ui-icon-plus';
                break;
            case 'minus':
                $text = IMAGE_DELETE;
                $icon = 'ui-icon-minus';
                break;
            case 'close':
                $text = IMAGE_CLOSE;
                $icon = 'ui-icon-close';
                break;
            case 'download':
                $text = 'Download';
                $icon = 'ui-icon-disk';
                break;
        }
        if(!empty($this->title)){
            $text = $this->title;
        }
        $class = $this->class;
        if(empty($class)){
            $class = 'ui-state-default';
        }
        return sprintf(
                '<button type="button" style="padding: 4px; " class="ui-button ui-widget ui-corner-all %s" title="%s"><span class="ui-icon %s" style="float:left;display: inline;"></span></button>',
                $class,$text,$icon
        );
        
    }
}
