<?php
/**
 * CreateScheduledPackagesRequest
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Easy Ship
 *
 * The Selling Partner API for Easy Ship helps you build applications that help sellers manage and ship Amazon Easy Ship orders. Your Easy Ship applications can: * Get available time slots for packages to be scheduled for delivery. * Schedule, reschedule, and cancel Easy Ship orders. * Print labels, invoices, and warranties. See the [Marketplace Support Table](https://developer-docs.amazon.com/sp-api/docs/easyship-api-v2022-03-23-use-case-guide#marketplace-support-table) for the differences in Easy Ship operations by marketplace.
 *
 * The version of the OpenAPI document: 2022-03-23
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\EasyShipV20220323;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;

/**
 * CreateScheduledPackagesRequest Class Doc Comment
 *
 * @category Class
 * @description The request body for the POST /easyShip/2022-03-23/packages/bulk API.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class CreateScheduledPackagesRequest extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CreateScheduledPackagesRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'marketplace_id' => 'string',
        'order_schedule_details_list' => '\SellingPartnerApi\Model\EasyShipV20220323\OrderScheduleDetails[]',
        'label_format' => '\SellingPartnerApi\Model\EasyShipV20220323\LabelFormat'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'marketplace_id' => null,
        'order_schedule_details_list' => null,
        'label_format' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'marketplace_id' => 'marketplaceId',
        'order_schedule_details_list' => 'orderScheduleDetailsList',
        'label_format' => 'labelFormat'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'marketplace_id' => 'setMarketplaceId',
        'order_schedule_details_list' => 'setOrderScheduleDetailsList',
        'label_format' => 'setLabelFormat'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'marketplace_id' => 'getMarketplaceId',
        'order_schedule_details_list' => 'getOrderScheduleDetailsList',
        'label_format' => 'getLabelFormat'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['marketplace_id'] = $data['marketplace_id'] ?? null;
        $this->container['order_schedule_details_list'] = $data['order_schedule_details_list'] ?? null;
        $this->container['label_format'] = $data['label_format'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['marketplace_id'] === null) {
            $invalidProperties[] = "'marketplace_id' can't be null";
        }
        if ((mb_strlen($this->container['marketplace_id']) > 255)) {
            $invalidProperties[] = "invalid value for 'marketplace_id', the character length must be smaller than or equal to 255.";
        }

        if ((mb_strlen($this->container['marketplace_id']) < 1)) {
            $invalidProperties[] = "invalid value for 'marketplace_id', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['order_schedule_details_list'] === null) {
            $invalidProperties[] = "'order_schedule_details_list' can't be null";
        }
        if ((count($this->container['order_schedule_details_list']) < 1)) {
            $invalidProperties[] = "invalid value for 'order_schedule_details_list', number of items must be greater than or equal to 1.";
        }

        if ($this->container['label_format'] === null) {
            $invalidProperties[] = "'label_format' can't be null";
        }
        return $invalidProperties;
    }


    /**
     * Gets marketplace_id
     *
     * @return string
     */
    public function getMarketplaceId()
    {
        return $this->container['marketplace_id'];
    }

    /**
     * Sets marketplace_id
     *
     * @param string $marketplace_id A string of up to 255 characters.
     *
     * @return self
     */
    public function setMarketplaceId($marketplace_id)
    {
        if ((mb_strlen($marketplace_id) > 255)) {
            throw new \InvalidArgumentException('invalid length for $marketplace_id when calling CreateScheduledPackagesRequest., must be smaller than or equal to 255.');
        }
        if ((mb_strlen($marketplace_id) < 1)) {
            throw new \InvalidArgumentException('invalid length for $marketplace_id when calling CreateScheduledPackagesRequest., must be bigger than or equal to 1.');
        }

        $this->container['marketplace_id'] = $marketplace_id;

        return $this;
    }
    /**
     * Gets order_schedule_details_list
     *
     * @return \SellingPartnerApi\Model\EasyShipV20220323\OrderScheduleDetails[]
     */
    public function getOrderScheduleDetailsList()
    {
        return $this->container['order_schedule_details_list'];
    }

    /**
     * Sets order_schedule_details_list
     *
     * @param \SellingPartnerApi\Model\EasyShipV20220323\OrderScheduleDetails[] $order_schedule_details_list An array allowing users to specify orders to be scheduled.
     *
     * @return self
     */
    public function setOrderScheduleDetailsList($order_schedule_details_list)
    {


        if ((count($order_schedule_details_list) < 1)) {
            throw new \InvalidArgumentException('invalid length for $order_schedule_details_list when calling CreateScheduledPackagesRequest., number of items must be greater than or equal to 1.');
        }
        $this->container['order_schedule_details_list'] = $order_schedule_details_list;

        return $this;
    }
    /**
     * Gets label_format
     *
     * @return \SellingPartnerApi\Model\EasyShipV20220323\LabelFormat
     */
    public function getLabelFormat()
    {
        return $this->container['label_format'];
    }

    /**
     * Sets label_format
     *
     * @param \SellingPartnerApi\Model\EasyShipV20220323\LabelFormat $label_format label_format
     *
     * @return self
     */
    public function setLabelFormat($label_format)
    {
        $this->container['label_format'] = $label_format;

        return $this;
    }
}


