<?php
/**
 * SellerReviewEnrollmentPaymentEvent
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Finances
 *
 * The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\FinancesV0;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;

/**
 * SellerReviewEnrollmentPaymentEvent Class Doc Comment
 *
 * @category Class
 * @description A fee payment event for the Early Reviewer Program.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class SellerReviewEnrollmentPaymentEvent extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'SellerReviewEnrollmentPaymentEvent';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'posted_date' => 'string',
        'enrollment_id' => 'string',
        'parent_asin' => 'string',
        'fee_component' => '\SellingPartnerApi\Model\FinancesV0\FeeComponent',
        'charge_component' => '\SellingPartnerApi\Model\FinancesV0\ChargeComponent',
        'total_amount' => '\SellingPartnerApi\Model\FinancesV0\Currency'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'posted_date' => null,
        'enrollment_id' => null,
        'parent_asin' => null,
        'fee_component' => null,
        'charge_component' => null,
        'total_amount' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'posted_date' => 'PostedDate',
        'enrollment_id' => 'EnrollmentId',
        'parent_asin' => 'ParentASIN',
        'fee_component' => 'FeeComponent',
        'charge_component' => 'ChargeComponent',
        'total_amount' => 'TotalAmount'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'posted_date' => 'setPostedDate',
        'enrollment_id' => 'setEnrollmentId',
        'parent_asin' => 'setParentAsin',
        'fee_component' => 'setFeeComponent',
        'charge_component' => 'setChargeComponent',
        'total_amount' => 'setTotalAmount'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'posted_date' => 'getPostedDate',
        'enrollment_id' => 'getEnrollmentId',
        'parent_asin' => 'getParentAsin',
        'fee_component' => 'getFeeComponent',
        'charge_component' => 'getChargeComponent',
        'total_amount' => 'getTotalAmount'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['posted_date'] = $data['posted_date'] ?? null;
        $this->container['enrollment_id'] = $data['enrollment_id'] ?? null;
        $this->container['parent_asin'] = $data['parent_asin'] ?? null;
        $this->container['fee_component'] = $data['fee_component'] ?? null;
        $this->container['charge_component'] = $data['charge_component'] ?? null;
        $this->container['total_amount'] = $data['total_amount'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        return $invalidProperties;
    }


    /**
     * Gets posted_date
     *
     * @return string|null
     */
    public function getPostedDate()
    {
        return $this->container['posted_date'];
    }

    /**
     * Sets posted_date
     *
     * @param string|null $posted_date A date string in ISO 8601 format.
     *
     * @return self
     */
    public function setPostedDate($posted_date)
    {
        $this->container['posted_date'] = $posted_date;

        return $this;
    }
    /**
     * Gets enrollment_id
     *
     * @return string|null
     */
    public function getEnrollmentId()
    {
        return $this->container['enrollment_id'];
    }

    /**
     * Sets enrollment_id
     *
     * @param string|null $enrollment_id An enrollment identifier.
     *
     * @return self
     */
    public function setEnrollmentId($enrollment_id)
    {
        $this->container['enrollment_id'] = $enrollment_id;

        return $this;
    }
    /**
     * Gets parent_asin
     *
     * @return string|null
     */
    public function getParentAsin()
    {
        return $this->container['parent_asin'];
    }

    /**
     * Sets parent_asin
     *
     * @param string|null $parent_asin The Amazon Standard Identification Number (ASIN) of the item that was enrolled in the Early Reviewer Program.
     *
     * @return self
     */
    public function setParentAsin($parent_asin)
    {
        $this->container['parent_asin'] = $parent_asin;

        return $this;
    }
    /**
     * Gets fee_component
     *
     * @return \SellingPartnerApi\Model\FinancesV0\FeeComponent|null
     */
    public function getFeeComponent()
    {
        return $this->container['fee_component'];
    }

    /**
     * Sets fee_component
     *
     * @param \SellingPartnerApi\Model\FinancesV0\FeeComponent|null $fee_component fee_component
     *
     * @return self
     */
    public function setFeeComponent($fee_component)
    {
        $this->container['fee_component'] = $fee_component;

        return $this;
    }
    /**
     * Gets charge_component
     *
     * @return \SellingPartnerApi\Model\FinancesV0\ChargeComponent|null
     */
    public function getChargeComponent()
    {
        return $this->container['charge_component'];
    }

    /**
     * Sets charge_component
     *
     * @param \SellingPartnerApi\Model\FinancesV0\ChargeComponent|null $charge_component charge_component
     *
     * @return self
     */
    public function setChargeComponent($charge_component)
    {
        $this->container['charge_component'] = $charge_component;

        return $this;
    }
    /**
     * Gets total_amount
     *
     * @return \SellingPartnerApi\Model\FinancesV0\Currency|null
     */
    public function getTotalAmount()
    {
        return $this->container['total_amount'];
    }

    /**
     * Sets total_amount
     *
     * @param \SellingPartnerApi\Model\FinancesV0\Currency|null $total_amount total_amount
     *
     * @return self
     */
    public function setTotalAmount($total_amount)
    {
        $this->container['total_amount'] = $total_amount;

        return $this;
    }
}


