<?php
/**
 * PreferredDeliveryTime
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Orders
 *
 * The Selling Partner API for Orders helps you programmatically retrieve order information. These APIs let you develop fast, flexible, custom applications in areas like order synchronization, order research, and demand-based decision support tools. The Orders API only supports orders that are less than two years old. Orders more than two years old will not show in the API response.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\OrdersV0;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;

/**
 * PreferredDeliveryTime Class Doc Comment
 *
 * @category Class
 * @description The time window when the delivery is preferred.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class PreferredDeliveryTime extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PreferredDeliveryTime';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'business_hours' => '\SellingPartnerApi\Model\OrdersV0\BusinessHours[]',
        'exception_dates' => '\SellingPartnerApi\Model\OrdersV0\ExceptionDates[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'business_hours' => null,
        'exception_dates' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'business_hours' => 'BusinessHours',
        'exception_dates' => 'ExceptionDates'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'business_hours' => 'setBusinessHours',
        'exception_dates' => 'setExceptionDates'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'business_hours' => 'getBusinessHours',
        'exception_dates' => 'getExceptionDates'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['business_hours'] = $data['business_hours'] ?? null;
        $this->container['exception_dates'] = $data['exception_dates'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        return $invalidProperties;
    }


    /**
     * Gets business_hours
     *
     * @return \SellingPartnerApi\Model\OrdersV0\BusinessHours[]|null
     */
    public function getBusinessHours()
    {
        return $this->container['business_hours'];
    }

    /**
     * Sets business_hours
     *
     * @param \SellingPartnerApi\Model\OrdersV0\BusinessHours[]|null $business_hours Business hours when the business is open for deliveries.
     *
     * @return self
     */
    public function setBusinessHours($business_hours)
    {
        $this->container['business_hours'] = $business_hours;

        return $this;
    }
    /**
     * Gets exception_dates
     *
     * @return \SellingPartnerApi\Model\OrdersV0\ExceptionDates[]|null
     */
    public function getExceptionDates()
    {
        return $this->container['exception_dates'];
    }

    /**
     * Sets exception_dates
     *
     * @param \SellingPartnerApi\Model\OrdersV0\ExceptionDates[]|null $exception_dates Dates when the business is closed in the next 30 days.
     *
     * @return self
     */
    public function setExceptionDates($exception_dates)
    {
        $this->container['exception_dates'] = $exception_dates;

        return $this;
    }
}


