<?php
/**
 * TrackingInformation
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Shipping
 *
 * Provides programmatic access to Amazon Shipping APIs.  **Note:** If you are new to the Amazon Shipping API, refer to the latest version of <a href=\"https://developer-docs.amazon.com/amazon-shipping/docs/shipping-api-v2-reference\">Amazon Shipping API (v2)</a> on the <a href=\"https://developer-docs.amazon.com/amazon-shipping/\">Amazon Shipping Developer Documentation</a> site.
 *
 * The version of the OpenAPI document: v1
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\ShippingV1;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;

/**
 * TrackingInformation Class Doc Comment
 *
 * @category Class
 * @description The payload schema for the getTrackingInformation operation.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class TrackingInformation extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'TrackingInformation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'tracking_id' => 'string',
        'summary' => '\SellingPartnerApi\Model\ShippingV1\TrackingSummary',
        'promised_delivery_date' => 'string',
        'event_history' => '\SellingPartnerApi\Model\ShippingV1\Event[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'tracking_id' => null,
        'summary' => null,
        'promised_delivery_date' => null,
        'event_history' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'tracking_id' => 'trackingId',
        'summary' => 'summary',
        'promised_delivery_date' => 'promisedDeliveryDate',
        'event_history' => 'eventHistory'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'tracking_id' => 'setTrackingId',
        'summary' => 'setSummary',
        'promised_delivery_date' => 'setPromisedDeliveryDate',
        'event_history' => 'setEventHistory'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'tracking_id' => 'getTrackingId',
        'summary' => 'getSummary',
        'promised_delivery_date' => 'getPromisedDeliveryDate',
        'event_history' => 'getEventHistory'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['tracking_id'] = $data['tracking_id'] ?? null;
        $this->container['summary'] = $data['summary'] ?? null;
        $this->container['promised_delivery_date'] = $data['promised_delivery_date'] ?? null;
        $this->container['event_history'] = $data['event_history'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['tracking_id'] === null) {
            $invalidProperties[] = "'tracking_id' can't be null";
        }
        if ((mb_strlen($this->container['tracking_id']) > 60)) {
            $invalidProperties[] = "invalid value for 'tracking_id', the character length must be smaller than or equal to 60.";
        }

        if ((mb_strlen($this->container['tracking_id']) < 1)) {
            $invalidProperties[] = "invalid value for 'tracking_id', the character length must be bigger than or equal to 1.";
        }

        if ($this->container['summary'] === null) {
            $invalidProperties[] = "'summary' can't be null";
        }
        if ($this->container['promised_delivery_date'] === null) {
            $invalidProperties[] = "'promised_delivery_date' can't be null";
        }
        if ($this->container['event_history'] === null) {
            $invalidProperties[] = "'event_history' can't be null";
        }
        return $invalidProperties;
    }


    /**
     * Gets tracking_id
     *
     * @return string
     */
    public function getTrackingId()
    {
        return $this->container['tracking_id'];
    }

    /**
     * Sets tracking_id
     *
     * @param string $tracking_id The tracking id generated to each shipment. It contains a series of letters or digits or both.
     *
     * @return self
     */
    public function setTrackingId($tracking_id)
    {
        if ((mb_strlen($tracking_id) > 60)) {
            throw new \InvalidArgumentException('invalid length for $tracking_id when calling TrackingInformation., must be smaller than or equal to 60.');
        }
        if ((mb_strlen($tracking_id) < 1)) {
            throw new \InvalidArgumentException('invalid length for $tracking_id when calling TrackingInformation., must be bigger than or equal to 1.');
        }

        $this->container['tracking_id'] = $tracking_id;

        return $this;
    }
    /**
     * Gets summary
     *
     * @return \SellingPartnerApi\Model\ShippingV1\TrackingSummary
     */
    public function getSummary()
    {
        return $this->container['summary'];
    }

    /**
     * Sets summary
     *
     * @param \SellingPartnerApi\Model\ShippingV1\TrackingSummary $summary summary
     *
     * @return self
     */
    public function setSummary($summary)
    {
        $this->container['summary'] = $summary;

        return $this;
    }
    /**
     * Gets promised_delivery_date
     *
     * @return string
     */
    public function getPromisedDeliveryDate()
    {
        return $this->container['promised_delivery_date'];
    }

    /**
     * Sets promised_delivery_date
     *
     * @param string $promised_delivery_date The promised delivery date and time of a shipment in ISO 8601 format.
     *
     * @return self
     */
    public function setPromisedDeliveryDate($promised_delivery_date)
    {
        $this->container['promised_delivery_date'] = $promised_delivery_date;

        return $this;
    }
    /**
     * Gets event_history
     *
     * @return \SellingPartnerApi\Model\ShippingV1\Event[]
     */
    public function getEventHistory()
    {
        return $this->container['event_history'];
    }

    /**
     * Sets event_history
     *
     * @param \SellingPartnerApi\Model\ShippingV1\Event[] $event_history A list of events of a shipment.
     *
     * @return self
     */
    public function setEventHistory($event_history)
    {
        $this->container['event_history'] = $event_history;

        return $this;
    }
}


