<?php
/**
 * CollectFreightPickupDetails
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Retail Procurement Shipments
 *
 * The Selling Partner API for Retail Procurement Shipments provides programmatic access to retail shipping data for vendors.
 *
 * The version of the OpenAPI document: v1
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\VendorShippingV1;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;

/**
 * CollectFreightPickupDetails Class Doc Comment
 *
 * @category Class
 * @description Transport Request pickup date from Vendor Warehouse by Buyer
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class CollectFreightPickupDetails extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'collectFreightPickupDetails';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'requested_pick_up' => 'string',
        'scheduled_pick_up' => 'string',
        'carrier_assignment_date' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'requested_pick_up' => null,
        'scheduled_pick_up' => null,
        'carrier_assignment_date' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'requested_pick_up' => 'requestedPickUp',
        'scheduled_pick_up' => 'scheduledPickUp',
        'carrier_assignment_date' => 'carrierAssignmentDate'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'requested_pick_up' => 'setRequestedPickUp',
        'scheduled_pick_up' => 'setScheduledPickUp',
        'carrier_assignment_date' => 'setCarrierAssignmentDate'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'requested_pick_up' => 'getRequestedPickUp',
        'scheduled_pick_up' => 'getScheduledPickUp',
        'carrier_assignment_date' => 'getCarrierAssignmentDate'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['requested_pick_up'] = $data['requested_pick_up'] ?? null;
        $this->container['scheduled_pick_up'] = $data['scheduled_pick_up'] ?? null;
        $this->container['carrier_assignment_date'] = $data['carrier_assignment_date'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        return $invalidProperties;
    }


    /**
     * Gets requested_pick_up
     *
     * @return string|null
     */
    public function getRequestedPickUp()
    {
        return $this->container['requested_pick_up'];
    }

    /**
     * Sets requested_pick_up
     *
     * @param string|null $requested_pick_up Date on which the items can be picked up from vendor warehouse by Buyer used for WePay/Collect vendors.
     *
     * @return self
     */
    public function setRequestedPickUp($requested_pick_up)
    {
        $this->container['requested_pick_up'] = $requested_pick_up;

        return $this;
    }
    /**
     * Gets scheduled_pick_up
     *
     * @return string|null
     */
    public function getScheduledPickUp()
    {
        return $this->container['scheduled_pick_up'];
    }

    /**
     * Sets scheduled_pick_up
     *
     * @param string|null $scheduled_pick_up Date on which the items are scheduled to be picked from vendor warehouse by Buyer used for WePay/Collect vendors.
     *
     * @return self
     */
    public function setScheduledPickUp($scheduled_pick_up)
    {
        $this->container['scheduled_pick_up'] = $scheduled_pick_up;

        return $this;
    }
    /**
     * Gets carrier_assignment_date
     *
     * @return string|null
     */
    public function getCarrierAssignmentDate()
    {
        return $this->container['carrier_assignment_date'];
    }

    /**
     * Sets carrier_assignment_date
     *
     * @param string|null $carrier_assignment_date Date on which the carrier is being scheduled to pickup items from vendor warehouse by Byer used for WePay/Collect vendors.
     *
     * @return self
     */
    public function setCarrierAssignmentDate($carrier_assignment_date)
    {
        $this->container['carrier_assignment_date'] = $carrier_assignment_date;

        return $this;
    }
}


