<?php
/**
 * Diese Klasse wird verwendet um Feeds aller Art von Amazon zu verarbeiten
 */
require_once(DIR_FS_INC.'yes_end_auction_add.inc.php');
class Feed
{
	var $NextToken;
	var $FeedType;
	var $FeedDate;
	var $import_filename; // fuer sync per Amazonexport Datei
	function getFeed($response){
		$getFeedListResult = $response->getGetFeedListResult();
		if($getFeedListResult->isSetHasNext() and $getFeedListResult->getHasNext() and $getFeedListResult->isSetNextToken()) {
			printf('<p><a href="%s"><code>Next Token</code></a></p>',
				'GetFeedListByNextTokenSample.php?NextToken='.urlencode($getFeedListResult->getNextToken())
			);
		}
	}

	function setNextToken($NextToken){
		$this->NextToken = $NextToken;
	}
	function getNextToken(){
		return $this->NextToken;
	}

	function getFeedType() {
		return $this->FeedType;
	}

	function setFeedType($FeedType) {
		$this->FeedType = $FeedType;
	}

	public function getFeedDate() {
		return $this->FeedDate;
	}

	public function setFeedDate($FeedDate) {
		$this->FeedDate = $FeedDate;
	}

	public function getFeedTypeTitle($FeedType) {
		switch($FeedType){
			case '_GET_FLAT_FILE_OPEN_LISTINGS_DATA_':
				return AMAZON_REPORT_TYPE_GET_FLAT_FILE_OPEN_LISTINGS_DATA;
				break;
			case '_GET_MERCHANT_LISTINGS_DATA_':
				return AMAZON_REPORT_TYPE_GET_MERCHANT_LISTINGS_DATA;
				break;
			case '_GET_FLAT_FILE_ORDERS_DATA_':
				return AMAZON_REPORT_TYPE_GET_FLAT_FILE_ORDERS_DATA;
				break;
			case '_GET_ORDERS_DATA_':
				return AMAZON_REPORT_TYPE_GET_ORDERS_DATA;
				break;
		}
		return $FeedType.' (add in amz_Feed.php)';
	}

	function get_message_feed_string($messageData){
		$results = '';
		$status = sprintf('<font color="#FF0000">%s</font>',$messageData['StatusCode']);
		if(!sizeOf($messageData['Results'])){
			if($messageData['StatusCode'] == 'Complete')
				$status = sprintf('<font color="#00FF00">%s</font>',$messageData['StatusCode']);
		}
		foreach($messageData['Results'] as $result){
			$results .= sprintf('<li><strong>%s (%s):</strong> %s',
				$result['ResultCode'],$result['ResultCode'],$result['ResultDescription']
			);
		}
		return sprintf(
			"<p>DocumentTransactionID: %s<br />StatusCode: %s<br />%s</p>",
				$messageData['DocumentTransactionID'],
				$status,
				$results
		);
	}

	function process_message($msg){
		$PR = $msg->ProcessingFeed;
		$results = array();
		$result = $PR->Result;
		foreach($result as $res){
			$results[] = array(
				'ResultCode' =>current($res->ResultCode),
				'ResultMessageCode' =>current($res->ResultMessageCode),
				'ResultDescription' =>current($res->ResultDescription)
			);
		}
		$data = array(
			'MessageID'=>current($msg->MessageID),
			'DocumentTransactionID'=>current($PR->DocumentTransactionID),
			'StatusCode'=>current($PR->StatusCode),
			'Results'=>$results
		);
		return $data;
	}


	function invokeGetFeed(MarketplaceWebService_Interface $service, $request, $from_import_file=false){
		global $basics;
                if($from_import_file){
			$content = file_get_contents( $this->import_filename );
                }else{
                    $filename = $request->Merchant.'_'.$request->FeedSubmissionId.'.xml';
                    if(!is_dir(AMAZON_SAVE_PATH.$this->FeedType)){
                            mkdir(AMAZON_SAVE_PATH.$this->FeedType);
                    }   
                    if(is_file(AMAZON_SAVE_PATH.$this->FeedType.'/'.$filename)){
                            $content = $basics->read_file_content(AMAZON_SAVE_PATH.$this->FeedType.'/'.$filename);
                    }else{
                            try {
                                    $response = $service->getFeedSubmissionResult($request);
                                    $handle = $request->getFeedSubmissionResult();
                                    $content = stream_get_contents($handle);
                                    $basics->create_file(AMAZON_SAVE_PATH.$this->FeedType.'/'.$filename,$content);
                            } catch (MarketplaceWebService_Exception $ex) {
                                    echo amazon_get_request_error_msg($ex);
                            }
                    }
                }
		switch($this->getFeedType()){
			case 'GetFeedSubmissionResult':
				$hist_array = array();
				$lines = explode(PHP_EOL,$content);
				$summary = '';
				foreach($lines as $nr => $line){
					$cols = explode("\t",$line);
					if(sizeOf($cols)<2){
						continue;
					}
					$pID = 0;
					if(sizeOf($cols)==4 and $cols[1] == 'Number of records processed'){
						$processed = $cols[3];
						continue;
					}elseif(sizeOf($cols)==4 and $cols[1] == 'Number of records successful'){
						$successful = $cols[3];
						continue;
					}else{
						if($cols[1] == 'sku') continue; // headerzeile
						switch($cols[3]){
							case 'Error':
								$pID = $cols[1];
								if(!isset($hist_array[$pID])) $hist_array[$pID] = array();
								$hist_array[$pID][] = sprintf('ErrorCode %s: %s',$cols[2],$cols[4]);
								break;
							case 'Info':
								$summary = sprintf('<a href="%s" target="_blank">Error Summary @ amazon</a>',$cols[4]);
								break;
							default:
								$pID = $cols[1];
								if(!isset($hist_array[$pID])) $hist_array[$pID] = array();
								$hist_array[$pID][] = sprintf('Type: %s / Code %s: %s',$cols[3],$cols[2],$cols[4]);
						}
					}
					if($pID > 0 and isset($hist_array[$pID]) and sizeOf($hist_array[$pID]) and $summary != ''){
						$hist_array[$pID][] = $summary;
					}
				}
				return array(
					'HISTORY'=>$hist_array,
					'PROCESSED'=>$processed,
					'SUCCESSFUL'=>$successful
				);
				break;
		}
		//return $items;
	}

	private function prepare_string($string){
		return yes_decode_string($string);
	}
}
