<?php
/**************************************************
 FILENAME: calendar_class.php
 PURPOSE: Define year, month, day, and calendar classes
 AUTHOR: Matthew Malenski
 DATE CREATED: Thu Jun 30 09:38:53 2005
**************************************************/
class year{
    var $year;
    var $months = array();
    function __construct($yr){
        $this->year = $yr;
        $this->init_year();
    }
    function init_year(){
        for($i=0; $i<12; $i++){
            $this->months[] = new month($this->year,$i);
        }
    }
}

class month{
    var $year;
    var $month;
    var $first; //--- index of first day of current month
    var $last;  //--- index of last day of current month
    var $days = array(); //--- array of days (includes last days of previous and next months)
    var $weeks = array(); //--- array of weeks containing indexes of days for that week
    
    function __construct($year,$month){
        //echo "months($year,$month)\n";
        $this->year = $year;
        $this->month = $month;
	$this->init_month();
    }
    function get_name(){
        return date('Y F',mktime(0,0,0,($this->month+1),1,$this->year));
    }
    function get_month_name(){
        return date('Y',mktime(0,0,0,($this->month+1),1,$this->year));
    }
    function get_year(){
        return date('F',mktime(0,0,0,($this->month+1),1,$this->year));
    }
    function init_month(){

	//--- Get the last days of the previous month to show if needed (start the week)
        $offset = -1 * date('w',mktime(0,0,0,($this->month+1),1,$this->year));
        for($i=$offset; $i<0; $i++){
            $timestamp = mktime(0,0,0,$this->month+1,($i+1),$this->year);
            $this->days[] = new day($timestamp);
        }
	
	//--- Get all the days of the current month
        $days_in_month = date('t',mktime(0,0,0,($this->month+1),1,$this->year));
        for($i=0; $i<$days_in_month; $i++){
            if($i==0) $this->first = count($this->days);
            $timestamp = mktime(0,0,0,($this->month+1),($i+1),$this->year);
            $this->days[] = new day($timestamp);
        }
        $this->last = (count($this->days)-1);

        //--- Get the first days of next month if needed (finish of the week)
        $offset = date('w',$this->days[$this->last]->timestamp)+1;
         for($i=1; $i<=(7-$offset); $i++){
            $timestamp = ($this->days[$this->last]->timestamp)+(24*60*60*$i);
            $this->days[] = new day($timestamp);
        }

        //--- Initialize $this->weeks[]
        //--- IF week ends/starts next/previous year the day('w') function returns wrong week
        //--- WE DO NOT want this so just use week of last/first day of current month

        for($i=0; $i < count($this->days); $i++){
            if($i < $this->first){
                $current_week = $this->days[$this->first]->week;
            }elseif($i > $this->last){
                $current_week = $this->days[$this->last]->week;
            }else{
                $current_week = $this->days[$i]->week;
            }
            $this->weeks[$current_week][] = $i;
        }
	
    }
    function get_month(){
        return sprintf("%02s",($this->month+1));
    }
}

class day{

    var $year;
    var $month;
    var $day;
    var $timestamp;
    var $name;
    var $week;
    function __construct($timestamp){
        $this->timestamp = $timestamp;
        $this->year = date('Y',$this->timestamp);
        $this->month = date('m',$this->timestamp);
        $this->day = date('d',$this->timestamp);
        $this->name = date('dMy',$this->timestamp);
        $this->week = week_of_year($this->timestamp);
	$this->termine = array();

	$date = date('Y-m-d',$this->timestamp);	
	$termine_query_raw = "SELECT s.date_termin,n.capt,n.id FROM Notice_status s,Notice_notes n WHERE s.date_termin>='".$date." 00:00:00' and s.date_termin<='".$date." 23:59:59' and n.id=s.notes_id and s.usr='".$_SESSION['customer_id']."' order by s.date_termin";
	$termine_query = xtc_db_query($termine_query_raw);
	while($termin = xtc_db_fetch_array($termine_query)){
		//$this->termine[ date('Y-m-d',strtotime($termin['date_termin'])) ][] = xtc_db_prepare_input($termin['capt']);
		$this->termine[] = array('id'=>$termin['id'],'capt'=>xtc_db_prepare_input($termin['capt']),'datum'=>date('H:i',strtotime($termin['date_termin'])));
	}
	
	// BOF - Liefertermine aus LB
	$query = xtc_db_query(sprintf(
		"SELECT distributor_name, distributor_orders_id,date_created FROM distributor_orders WHERE estimated_date_receipt >= '%s 00:00:00' AND estimated_date_receipt < '%s 23:59:59' AND orders_status IN(1,2)",
		$date,$date
	));
	while($record = xtc_db_fetch_array($query)){
	    $capt = sprintf('LB <a href="%s" target="_blank">#%s</a> Lieferant %s vom %s',
		    xtc_href_link('distributor_orders.php','action=edit&doID='.$record['distributor_orders_id']),
		    $record['distributor_orders_id'],xtc_db_prepare_input($record['distributor_name']),xtc_date_short($record['date_created']));
		$this->termine[] = array('id'=>0,'capt'=>$capt,'datum'=>date('H:i',strtotime($record['estimated_date_receipt'])));
	}
	// EOF - Liefertermine aus LB
	
    }
    function is_today(){
        return ($this->timestamp == mktime(0,0,0,date('m'),date('d'),date('Y')));
    }
    function is_weekend(){
        $day_of_week = date('w',$this->timestamp);
        return (($day_of_week=='0') || ($day_of_week=='6'));
    }

    function has_actions() {
	if(sizeOf($this->termine)>0)
		return 1;
	else
		return 0;
    }

    function count_actions() {
	return sizeOf($this->termine);
    }
}

class calendar{
    var $yr_id;
    var $mn_id;
    var $month;
    var $events;

    function __construct(){
        //--- FETCH posted year and month use current if none given
        $year  = html_get('year',date('Y'));
        $month = html_get('month',date('m'));

        //--- Validate month and year
        if(!(preg_match('/^20[0-9]{1,2}$/',$year))) $year = date('Y');
        if(!(preg_match('/^(0*)([1-9]|10|11|12)$/',$month))) $month = date('m');

        //--- Process action if any given
        $action = html_get('calaction');
        switch($action){
            case '+1':
                true;
                $time   = mktime(0,0,0,($month+1),1,$year);
                $year   = date('Y',$time);
                $month  = date('m',$time);
                break;
            case '-1':
                $time   = mktime(0,0,0,($month-1),1,$year);
                $year   = date('Y',$time);
                $month  = date('m',$time);
                break;
            default:
                break;
        }
        $this->set_year($year);
        $this->set_month($month);
        $this->init();
    }
    function set_year($yr){
        $this->yr_id = $yr;
    }
    function set_month($mn){
        $this->mn_id = ($mn - 1);
    }
    function init(){
        $this->month = new month($this->yr_id,$this->mn_id);
    }
    function month_view(){
    	global $_GET;
        $smarty = new yesSmarty;

        $smarty->assign('title',$this->get_title());
        $smarty->assign('month',$this->month);
        $smarty->assign('cal_months',$GLOBALS['cal_months']);
        $smarty->assign('cal_years',$GLOBALS['cal_years']);
	
	foreach($this->month->days as $day){
		if($day->is_today()){
			$smarty->assign('viewday',$day->day);
		}
	}
	if(isset($_GET['viewday']) and $_GET['viewday'] != '')
		$smarty->assign('viewday',$_GET['viewday']);

	$smarty->assign('subaction',@$_GET['subaction']);	
	$smarty->assign('action',@$_GET['action']);
	$smarty->assign('urlencode_calaction',urlencode(@$_GET['calaction']));
	$smarty->assign('get_month',@$_GET['month']);
	$smarty->assign('get_year',@$_GET['year']);
	$smarty->assign('EXT_POPUP_WIDTH',EXT_POPUP_WIDTH);
	$smarty->assign('EXT_POPUP_HEIGHT',EXT_POPUP_HEIGHT);
        $smarty->display('calendar.tpl');
    }
    function get_title(){
        $title = sprintf("PTO Calendar(%s)",date('F Y',mktime(0,0,0,($this->mn_id+1),1,$this->yr_id)));
        return $title;
    }
}
