<?php
class ebay_auction_variation extends ebay_item{
	var $ebay_auctions_variations_id;
	var $ebay_auctions_id;
	var $products_id;
	var $current_auctionprice;
	var $quantity_sold;
	var $sql_array;
	var $locked, $revise_counter;
        
        function getEbay_auctions_variations_id() {
            return $this->ebay_auctions_variations_id;
        }

        function getEbay_auctions_id() {
            return $this->ebay_auctions_id;
        }

        function setEbay_auctions_variations_id($ebay_auctions_variations_id) {
            $this->ebay_auctions_variations_id = $ebay_auctions_variations_id;
        }

        function setEbay_auctions_id($ebay_auctions_id) {
            $this->ebay_auctions_id = $ebay_auctions_id;
        }

    function __construct($ebay_auctions_variations_id){
            $eav = \YES4Trade\Model\ebay_auctions_variations::get_by_ebay_auctions_variations_id(intval($ebay_auctions_variations_id));
            if($eav === null){
                throw new Exception('Invalid ebay_auctions_variations_id '.$ebay_auctions_variations_id);
            }
		    $record = $eav->toArray();
            $this->setSQLArray($record);
            $this->setEbay_auctions_variations_id($ebay_auctions_variations_id);
            $this->setProductsId($record['products_id']);
            $this->setCurrentAuctionprice($record['price']);
            $this->setQuantitySold($record['quantity_sold']);
            $this->setQuantity($record['quantity']);
            $this->setEan($record['ean']);
            $this->setIsbn($record['isbn']);
            $this->setReviseCounter($record['revise_counter']);
            $this->setEbay_auctions_id($record['ebay_auctions_id']);
            $this->setSKU($record['sku']);
            $this->setProductReferenceID($record['ProductReferenceID']);
	}

	function setProductsId($value){
		$this->products_id = $value;
	}

	function getProductsId(){
		return $this->products_id;
	}

	function setCurrentAuctionprice($value){
		$this->current_auctionprice = $value;
	}

	function getCurrentAuctionprice(){
		return $this->current_auctionprice;
	}

	function setQuantitySold($value){
		$this->quantity_sold = $value;
	}

	function getQuantitySold(){
		return $this->quantity_sold;
	}

	function setReviseCounter($value){
		$this->revise_counter = $value;
	}

	function getReviseCounter(){
		return $this->revise_counter;
	}


	function setSQLArray($value){
		$this->sql_array = $value;
	}

	function getSQLArray(){
		return $this->sql_array;
	}

	function delete($auction_status){
        $log_qty = intval($this->getQuantity());
        \YES4Trade\Model\ebay_auctions_variations::delete(intval($this->getEbay_auctions_variations_id()));

        if(intval($auction_status) !== 0){
            return true;
        }
        $staffel_comment = '';
        if(defined('MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS') and MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS == 'True'){
            $ea = new ebay_auction($this->getEbay_auctions_id());
            if($ea->has_staffelpreise()){
                $log_qty = $log_qty*$ea->get_staffelpreis_quantity_from_sku($this->getSKU());
                $staffel_comment = ' Staffelpreis Menge: '.$ea->get_staffelpreis_quantity_from_sku($this->getSKU());
            }
        }

        yes_update_products_in_auction_quantity($this->getProductsId(),
            yes_products_calc_in_auction_quantity(intval($this->getProductsId())),
            sprintf('Variante SKU %s aus Auktion %s entfernt (%s Stk)%s.',
                $this->getSKU(),
                $this->getEbayID(),
                $log_qty,
                $staffel_comment
            ),
            true // overwrite!
        );
	}

        public function getEbayID(){
            $ea = \YES4Trade\Model\ebay_auctions::get_by_id( intval($this->getEbay_auctions_id()),['ebay_id'] );
            if($ea === null){
                return '';
            }
            return $ea->ebay_id;
        }
}
