<?php
if(!defined('DIR_FS_ADMIN')) define('DIR_FS_ADMIN',DIR_FS_CATALOG.'admin/');
require_once(DIR_FS_ADMIN.'includes/classes/class.basics.php');
class ebay_characteristics extends basics
{
	var $xsl_file = 'syi_attributes.xsl';
	var $category_id;
	var $category_number;
	var $attributeSetID;
	var $attributesCSXML;
	var $html;
	var $source;

	function __construct($ebay_user,$site_id,$category_id,$category_number,$source='post' ){
		$this->set_ebay_user($ebay_user);
		$this->set_site_id($site_id);
		$this->set_source($source);
		$this->set_category_id($category_id);
		$this->set_category_number($category_number);
	}

	function set_xsl_file($value){
		$this->xsl_file = $value;
	}

	function get_xsl_file(){
		return $this->xsl_file;
	}

	function set_category_id($value){
		$this->category_id = $value;
	}

	function get_category_id(){
		return $this->category_id;
	}

	function set_category_number($value){
		$this->category_number = $value;
	}

	function get_category_number(){
		return $this->category_number;
	}

	function set_attributeSetID($value){
		$this->attributeSetID = $value;
	}

	function get_attributeSetID(){
		return $this->attributeSetID;
	}

	function set_attributesCSXML($value,$id){
		$this->attributesCSXML[] = array('xml'=>$value,'attributeSetID'=>$id);
	}

	function get_attributesCSXML(){
		return $this->attributesCSXML;
	}

	function set_html($value){
		$this->html = $value;
	}

	function get_html(){
		$this->init_session($this->get_ebay_user(),$this->get_site_id());
		$this->get_category2cs();
		return $this->html;
	}

	function set_source($value){
		$this->source = $value;
	}

	function get_source(){
		return $this->source;
	}

	function get_xsl_string($xsl_file){
		return $this->read_file_content($xsl_file);
	}

	function _addAttribute($id,$attributeValue,&$attrSet){
		$attr = $attrSet->addChild('Attribute');
		$attr->addAttribute('id',$id);
		$attrValue = $attr->addChild('Value');
		$attrValue->addAttribute('id',$attributeValue);
	}

	function _addTextAttribute($id,$attributeValue,&$attrSet){
		$attr = $attrSet->addChild('Attribute');
		$attr->addAttribute('id',$id);
		$attrValue = $attr->addChild('Value');
		$attrValue->addChild('Name',$attributeValue);
		//$attrValue->addAttribute('id',$attributeValue);
	}

	function _addDateAttribute($id,$attributeValue,&$attrSet){
		$attr = $attrSet->addChild('Attribute');
		$attr->addAttribute('id',$id);
		$attrValue = $attr->addChild('Value');
		$attrValue->addChild('Year',$attributeValue['Year']);
		$attrValue->addChild('Month',$attributeValue['Month']);
		$attrValue->addChild('Day',$attributeValue['Day']);
	}

	function addSelectedAttributesFromPostToXML($attrSetID,&$attrSet){
		$rawpostdata = '';
		if (is_array($_POST) && sizeof($_POST) > 0) {
			foreach($_POST as $k=>$attributeValue){
				// Variable mit Attributwert
				if(strstr($k,'attr'.$attrSetID)){
					$attributeID = current(array_reverse(split('_',$k)));
					if(is_array($attributeValue)){
						foreach($attributeValue as $k=>$value){
							$this->_addAttribute($attributeID,$value,$attrSet);
						}
					}else{
						$this->_addAttribute($attributeID,$attributeValue,$attrSet);
					}
				}
				// Variable mit Attributwert - Text
				if(strstr($k,'attr_t'.$attrSetID)){
					$attributeID = current(array_reverse(split('_',$k)));
					$this->_addTextAttribute($attributeID,$attributeValue,$attrSet);
				}
				// Variable mit Attributwert - Date
				if(strstr($k,'attr_d'.$attrSetID)){
					$split = split('_',$k);
					$attributeID = $split[1];
					$this->_addTextAttribute($attributeID,$attributeValue,$attrSet);
				}
			}
		}

	}

	function addSelectedAttributesFromDBToXML($attrSetID,&$attrSet){
		$source = $this->get_source();
		$split = split('_',$source[1]);
		$table_id = $split[0];
		$key_id = $split[1];
		switch($table_id){
			case 'ep':
				$table = 'ebay_products_characteristics';
				$key = 'ebay_products_id';
				break;
			case 'ea':
				$table = 'ebay_auctions_characteristics';
				$key = 'ebay_auctions_id';
				break;
			case 'es':
				$table = 'ebay_sammler_characteristics';
				$key = 'ebay_sammler_id';
				break;
			case 'cf':
				$table = 'ebay_default_characteristics';
				$key = 'ebay_sammler_id';
				break;
		}

		$query_raw = "SELECT * FROM $table WHERE $key='$key_id' and category_number='".$this->get_category_number()."'";
		$query = xtc_db_query($query_raw);
		if(xtc_db_num_rows($query)){
			$dates = array();
			while($row = xtc_db_fetch_array($query)){
				switch($row['attribute_type']){
					case 'int':
						if(strstr($row['attribute_value'],','))
							$AttValue = explode(',',$row['attribute_value']);
						else
							$AttValue = array(0=>$row['attribute_value']);
						foreach($AttValue as $k=>$value){
							$this->_addAttribute($row['attribute_id'],$value,$attrSet);
						}
						break;
					case 'text':
						$this->_addTextAttribute($row['attribute_id'],$row['attribute_value'],$attrSet);
						break;
					case 'date_d':
						$dates[$row['attribute_id']]['Day'] = $row['attribute_value'];
						break;
					case 'date_m':
						$dates[$row['attribute_id']]['Month'] = $row['attribute_value'];
						break;
					case 'date_y':
						$dates[$row['attribute_id']]['Year'] = $row['attribute_value'];
						break;
				}
			}
			if(sizeOf($dates)>0){
				foreach($dates as $attribute_id=>$value_array){
					$this->_addDateAttribute($attribute_id,$value_array,$attrSet);
				}
			}
		}

	}

	function parseAttributeSet(){
		$html = '';
		foreach($this->get_attributesCSXML() as $k=>$attributesCSXML){
			$xml = new SimpleXMLElement( $attributesCSXML['xml'] );

			$overrides = $xml->addChild("API.XSL.Overrides");
			$overrides->addChild("Show");
			$overrides->Show->addChild("ItemSpecificsOnly");

			$overrides->addChild("Use");
			$overrides->Use->addChild("Form");
			$overrides->Use->Form->addAttribute("name","myform");  

			$selected = $xml->addChild("SelectedAttributes");
			$attrSet  = $selected->addChild("AttributeSet");
			$attrSet->addAttribute("id", $attributesCSXML['attributeSetID']);

			// XML um die gewaehlten Attribute erweitern
			$source = $this->get_source();
			if($source[0] == 'input'){
				$this->addSelectedAttributesFromPostToXML($attributesCSXML['attributeSetID'],$attrSet);
			}else{
				$this->addSelectedAttributesFromDBToXML($attributesCSXML['attributeSetID'],$attrSet);
			}

			$domxml = new DOMDocument();
			$domxml->load($this->get_xsl_file());

			$xslt = new XSLTProcessor();
			$xslt->importstyleSheet($domxml);

			// ALS DOMDOCUMENT WANDELN
			$new_domxml = new DOMDocument;
			$new_domxml->loadXML($xml->asXML());
			$html = @$xslt->transformToXML($new_domxml);
		}
		$this->set_html( $html );
		
	}

	function get_attributesCSXML_from_ebay(){
		$req = new GetAttributesCSRequestType();
		$req->setAttributeSetID( $this->get_attributeSetID() );
		$req->setDetailLevel('ReturnAll');

		$res = $this->cs->GetAttributesCS($req);
		if($this->cs->isGood($res)){
			$this->set_attributesCSXML( yes_encode_string($res->getAttributeData()),$this->get_attributeSetID() );
		}else{
			$this->draw_api_errors($res);
		}
	}

	function get_attributesetid_from_result($res){
		$attributesetid_array = array();

		$MCArray = $res->getMappedCategoryArray();
		if(is_array($MCArray) and sizeOf($MCArray)>0){
			foreach($MCArray as $k=>$Category){
				$CSets = $Category->getCharacteristicsSets();
				foreach($CSets as $ck=>$CSet){
					$attributesetid_array[] = $CSet->getAttributeSetID();
				}
			}
		}else{
			$SWCSets = $res->getSiteWideCharacteristicSets();
			if(is_array($SWCSets) and sizeOf($SWCSets)>0){
				foreach($SWCSets as $ck=>$SWCSet){
					$CSet = $SWCSet->getCharacteristicsSet();
					// MARIO
					$attributesetid_array[] = $CSet->getAttributeSetID();
				}
			}
		}
// MARIO
		if(sizeOf($attributesetid_array)>0){
			return $attributesetid_array;
		}
	}

	function get_category2cs(){
		// HOLE DIE KATEGORIECHARACTERISTICS
		$req = new GetCategory2CSRequestType();
		$req->setCategoryID($this->get_category_id());
		$req->setDetailLevel('ReturnAll');
		$res = $this->cs->GetCategory2CS($req);
		if($this->cs->isGood($res)){
			$attributeSetID = $this->get_attributesetid_from_result($res);
// MARIO
			foreach($attributeSetID as $k=>$ASID){
				$this->set_attributeSetID($ASID);

				$this->get_attributesCSXML_from_ebay();
			}
			$this->parseAttributeSet();

		}else{
			$this->draw_api_errors($res);
		}
	}

	function save_to_db(){
		$source = $this->get_source();
		$split = split('_',$source[1]);
		$table_id = $split[0];
		$key_id = $split[1];
		switch($table_id){
			case 'ep':
				$table = 'ebay_products_characteristics';
				$key = 'ebay_products_id';
				break;
			case 'ea':
				$table = 'ebay_auctions_characteristics';
				$key = 'ebay_auctions_id';
				break;
			case 'es':
				$table = 'ebay_sammler_characteristics';
				$key = 'ebay_sammler_id';
				break;
			case 'cf':
				$table = 'ebay_default_characteristics';
				$key = 'ebay_sammler_id';
				break;
		}
		$vcsID = $_POST['vcsid'];

		xtc_db_query(sprintf("DELETE FROM %s WHERE %s='%s' and category_number='%s'",$table,$key,$key_id,$this->get_category_number()));
		foreach($_POST as $k=>$v){
			if($v != ''){
				if(strstr($k,'attr')){
					$sql_insert_array = array();
					if(is_array($v)){
						$v = implode(',',$v);
					}
					$sql_insert_array = array(
						$key=>$key_id,
						'category_number'=>$this->get_category_number(),
						'attribute_set_id'=>$vcsID
					);
				
					// normaler INT Wert
					if(strstr($k,'attr'.$vcsID)){
						$attribute_id = current(array_reverse(split('attr'.$vcsID.'_',$k)));
						$sql_insert_array['attribute_type'] = 'int';
						$sql_insert_array['attribute_id'] = $attribute_id;
						$sql_insert_array['attribute_value'] = $v;
					}
					// Text Wert
					if(strstr($k,'attr_t'.$vcsID)){
						$v = str_replace('&','+',$v);
						$v = str_replace('|','/',$v);

						$attribute_id = current(array_reverse(split('attr_t'.$vcsID.'_',$k)));
						$sql_insert_array['attribute_type'] = 'text';
						$sql_insert_array['attribute_id'] = $attribute_id;
						$sql_insert_array['attribute_value'] = $v;
					}
					// Datum Wert
					if(strstr($k,'attr_d'.$vcsID)){
						$split = split('_',$k);
						$attribute_id = $split[2];
						$type = 'date_'.$split[3];
						$sql_insert_array['attribute_type'] = $type;
						$sql_insert_array['attribute_id'] = $attribute_id;
						$sql_insert_array['attribute_value'] = $v;
					}
					xtc_db_perform($table,$sql_insert_array);
				}
			}
		}
	}

	function get_additem_structure(&$asets){
		// DB Values auslesen und aufbereiten
		$source = $this->get_source();
		$split = split('_',$source[1]);
		$table_id = $split[0];
		$key_id = $split[1];
		switch($table_id){
			case 'ep':
				$table = 'ebay_products_characteristics';
				$key = 'ebay_products_id';
				break;
			case 'ea':
				$table = 'ebay_auctions_characteristics';
				$key = 'ebay_auctions_id';
				break;
			case 'es':
				$table = 'ebay_sammler_characteristics';
				$key = 'ebay_sammler_id';
				break;
			case 'cf':
				$table = 'ebay_default_characteristics';
				$key = 'ebay_sammler_id';
				break;
		}

		$saved_attributesets = array();
		$query_raw = sprintf("SELECT * FROM %s WHERE %s='%s' and category_number='%s'",$table,$key,$key_id,$this->get_category_number());
		$query = xtc_db_query($query_raw);
		while($row = xtc_db_fetch_array($query)){
			switch($row['attribute_type']){
				case 'int':
					if(strstr($row['attribute_value'],',')){
						$values = explode(',',$row['attribute_value']);
					}else{
						$values = array(0=>$row['attribute_value']);
					}
					foreach($values as $k=>$v){
						$saved_attributesets[ $row['attribute_set_id'] ][$row['attribute_id']][] = array(
							'attribute_type'=>'int',
							'attribute_value'=>$v
						);
					}
					break;
				case 'text':
					$saved_attributesets[ $row['attribute_set_id'] ][$row['attribute_id']][] = array(
						'attribute_type'=>'text',
						'attribute_value'=>$row['attribute_value']
					);
					break;
			}
		}
		if(sizeOf($saved_attributesets)>0){
			// WEISE TEXTVALUES DEN -6 ATTRIBUTEN ZU
			foreach($saved_attributesets as $attribute_set_id=>$attributes){
				foreach($attributes as $attributes_id=>$values){
					foreach($values as $vkey=>$value){
						switch($value['attribute_type']){
							case 'int':
								if($value['attribute_value'] == '-6'){
									$this->get_textvalue_for_attribute($vkey,$values);
									$saved_attributesets[$attribute_set_id][$attributes_id] = $values;
								}
								break;
						}
					}
				}
			}

			foreach($saved_attributesets as $attribute_set_id=>$attributes){
				foreach($attributes as $attributes_id=>$values){
					$att = new AttributeType();
					$att->setTypeAttribute('attributeID', $attributes_id);
					foreach($values as $vkey=>$value){
						switch($value['attribute_type']){
							case 'int':
								$attValue = new ValType();
								$attValue->setValueID($value['attribute_value']);
								if($value['attribute_value'] == -6){
									$attValue->setValueLiteral($value['text_value']);
								}
								break;
							case 'text':
								$attValue = new ValType();
								$attValue->setValueLiteral($value['attribute_value']);
								break;
						}
						$att->setValue($attValue,($vkey+1));
					}
					$asets[$attribute_set_id][] = $att;
				}
			}
		}
	}

	function get_textvalue_for_attribute($source_attribute_nr,&$values){
		$new_array = array();
		$text_value = '';
		foreach($values as $k=>$v){
			if($v['attribute_type'] == 'text'){
				// das ist der textvalue
				$text_value = $v['attribute_value'];
				unset($values[$k]);
			}
		}
		if($text_value != ''){
			$values[$source_attribute_nr]['text_value'] = $text_value;
		}
	}

	function draw_api_errors($res){
		$error_msg = '<b>Fehler:</b><br />';
		$errors = $res->getErrors();
		for($i=0;$i<sizeOf($errors);$i++){
			$error = $errors[$i];
			$error_msg .= htmlentities($error->getLongMessage());
		}
		die(yes_encode_string($error_msg));
	}
}
