<?php
class yes_file_editor
{
	var $directory, $max_filesize, $max_totalsize;
	var $exclude_directories = array('source','javascript','inc');
	var $allowed_filetypes = array('html','gif','js','png','jpg','jpeg','txt','css');

	function get_directory(){
		return $this->directory;
	}

	function set_directory($value){
		$this->directory = $value;
	}

	function get_exclude_directories(){
		return $this->exclude_directories;
	}

	function set_exclude_directories($value){
		$this->exclude_directories = $value;
	}

	function get_allowed_filetypes(){
		return $this->allowed_filetypes;
	}

	function set_allowed_filetypes($value){
		$this->allowed_filetypes = $value;
	}

	function get_max_filesize(){
		return $this->max_filesize;
	}

	function set_max_filesize($value){
		$this->max_filesize = $value;
	}

	function get_max_totalsize(){
		return $this->max_totalsize;
	}

	function set_max_totalsize($value){
		$this->max_totalsize = $value;
	}

	function get_dirsize($dirname,$formated = false) {
	    if (!is_dir($dirname) || !is_readable($dirname)) {
	        return false;
	    }

	    $dirname_stack[] = $dirname;
	    $size = 0;

	    do {
	        $dirname = array_shift($dirname_stack);
	        $handle = opendir($dirname);
	        while (false !== ($file = readdir($handle))) {
	            if ($file != '.' && $file != '..' && is_readable($dirname . DIRECTORY_SEPARATOR . $file)) {
	                if (is_dir($dirname . DIRECTORY_SEPARATOR . $file)) {
	                    $dirname_stack[] = $dirname . DIRECTORY_SEPARATOR . $file;
	                }
	                $size += filesize($dirname . DIRECTORY_SEPARATOR . $file);
	            }
	        }
	        closedir($handle);
	    } while (count($dirname_stack) > 0);
	    if(!$formated)
		return $size;
	    else
		return $this->size_readable($size);
	}

	function get_files_in_dir($dirname){
		$files = array();
		$dirname_act = current(array_reverse(explode('/',substr($dirname,0,(strlen($dirname)-1) )  ) ) );
		if (!is_dir($dirname) || !is_readable($dirname) || in_array($dirname_act,$this->get_exclude_directories() ) ) {
			return $files;
		}
		$handle = opendir($dirname);
		while (false !== ($file = readdir($handle))) {
		        if ($file != '.' && $file != '..' && is_readable($dirname . DIRECTORY_SEPARATOR . $file)) {
			        if (is_file($dirname . DIRECTORY_SEPARATOR . $file)) {
					$ftype = array_pop( explode( ".", strtolower( $file ) ) );
					if(in_array($ftype,$this->get_allowed_filetypes()))
				                $files[$file] = $file;
			        }
			}
		}
		closedir($handle);
		return $files;
	}

	function get_filesize($file,$formated = false){
		if(!is_file($file))
			return false;
	    if(!$formated)
		return filesize($file);
	    else
		return $this->size_readable(filesize($file));
	}

	function get_filedate($file){
		if(!is_file($file))
			return false;
		return date('d.m.Y H:i:s',filectime($file));
	}

	function size_readable($size, $retstring = null) {
	        // adapted from code at http://aidanlister.com/repos/v/function.size_readable.php
	        $sizes = array('B', 'kB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB');
	        if ($retstring === null) { $retstring = '%01.2f %s'; }
	        $lastsizestring = end($sizes);
	        foreach ($sizes as $sizestring) {
	                if ($size < 1024) { break; }
	                if ($sizestring != $lastsizestring) { $size /= 1024; }
	        }
	        if ($sizestring == $sizes[0]) { $retstring = '%01d %s'; } // Bytes aren't normally fractional
	        return sprintf($retstring, $size, $sizestring);
	}
	
	function dirTree($dir) {
	    if(!is_dir($dir)){
		return false;
	    }
	    $d = dir($dir);
	    while (false !== ($entry = $d->read())) {
		        if($entry != '.' && $entry != '..' && is_dir($dir.$entry) ){
				if($this->check_path_file($dir.$entry)){
			            	$arDir[$entry] = $this->dirTree($dir.$entry.'/');
				}
			}
	    }
	    $d->close();
	    return $arDir;
	}
	function deltree($path) {
	  if (is_dir($path)) {
	      if (version_compare(PHP_VERSION, '5.0.0') < 0) {
	        $entries = array();
	      if ($handle = opendir($path)) {
	        while (false !== ($file = readdir($handle))) $entries[] = $file;

	        closedir($handle);
	      }
	      } else {
	        $entries = scandir($path);
	        if ($entries === false) $entries = array(); // just in case scandir fail...
	      }

	    foreach ($entries as $entry) {
	      if ($entry != '.' && $entry != '..') {
	        $this->deltree($path.'/'.$entry);
	      }
	    }

	    return rmdir($path);
	  } else {
	      return unlink($path);
	  }
	}

	function get_folder_link($path){
		return xtc_href_link('yes_file_editor.php',xtc_get_all_get_params(array('tplpath','file')).'tplpath='.$path.'/');
	}

	function get_file_link($file){
		$ftype = array_pop( explode( ".", strtolower( $file ) ) );
		if($ftype == 'html' or $ftype == 'htm' or $ftype == 'js' or $ftype == 'txt')
			return xtc_href_link('yes_file_editor.php',xtc_get_all_get_params(array('file')).'file='.$file);
		else
			return false;
	}

	function htmlTree($array, $rpath, $level=0, $html = '') {
	    global $files_num;
	    if(sizeOf($array)>0){
		    foreach($array as $key => $value) {
			$bgcolor = ($key == $_GET['file']) ? '#CACACA' : '#DEDEDE';
			$hovercolor = ($key == $_GET['file']) ? '#CACACA' : '#FFFFFF';
			$font_weight = ($key == $_GET['file']) ? 'bold' : 'normal';

			$checkbox = '&nbsp;';
			if(is_dir($this->get_directory().'/'.$rpath.'/'.$key)){
				$div = "<div id=\"cont\" style=\"cursor:pointer;font-family:monospace;font-size:11px;font-weight:$font_weight;border-bottom:1px dotted #000000;width:300px;background-color:$bgcolor;\" onMouseOver=\"style.backgroundColor='$hovercolor';swap('folder$key','images/icons/current_folder.gif');\" onMouseOut=\"style.backgroundColor='$bgcolor';swap('folder$key','images/icons/folder.gif');\" onClick=\"%s\" title=\"%s\">";
				$action = '';
				// HAUPTVERZEICHNIS NICHT LOESCHBAR!
				if($rpath != '' and $rpath != '/')
					$action .= '<a href="'.xtc_href_link('yes_file_editor.php',xtc_get_all_get_params(array('diraction','dir')).'diraction=del&dir='.$key).'">'.xtc_image(DIR_WS_IMAGES.'icons/cross.gif','Verzeichnis samt Unterverzeichnissen und allen Dateien l&ouml;schen').'</a>';
				$action .= '<a href="'.xtc_href_link('yes_file_editor.php',xtc_get_all_get_params(array('diraction','dir')).'diraction=zip&dir='.$key).'">'.xtc_image(DIR_WS_IMAGES.'icons/icon_zip.gif','Verzeichnis Downloaden').'</a>&nbsp;';
				$img = 'folder.gif';
				$link = "window.location.href='".$this->get_folder_link($rpath.$key)."';";
				$title = 'Wechsel in dieses Verzeichnis';
				$img = '<img name="folder'.$key.'" src="'.DIR_WS_IMAGES.'icons/'.$img.'" title="'.$title.'" alt="'.$title.'" border="0">';
			}else{
				$files_num++;
				$div = "<div id=\"cont\" style=\"cursor:pointer;font-family:monospace;font-size:11px;font-weight:$font_weight;border-bottom:1px dotted #000000;width:300px;background-color:$bgcolor;\" onMouseOver=\"style.backgroundColor='$hovercolor';swap('file".$files_num."','images/icons/file_download.gif');\" onMouseOut=\"style.backgroundColor='$bgcolor';swap('file".$files_num."','images/icons/file.gif');\" onClick=\"%s\" title=\"%s\">";

				$img = 'file.gif';
				$link = $this->get_file_link($key);
				$action = '<input type="checkbox" name="tfile[]" value="'.$key.'">';
				if($link){
					$link = "window.location.href='".$link."';";
					$title = 'Diese Datei editieren';
				}else{
					$link = "window.open('".HTTP_SERVER."templates/".$rpath.$key."','popup','scrollbars=yes,resizable=yes,width=500,height=500');";
					$title = 'Keine editierbare Datei';
				}
				$img = '<img name="file'.$files_num.'" src="'.DIR_WS_IMAGES.'icons/'.$img.'" title="'.$title.'" alt="'.$title.'" border="0">';
			}
			$html .= '<table border="0" cellspacing="0" cellpadding="0"><tr><td width="40" align="right">'.$action.'</td><td>';
			if($link)
			        $html .= sprintf($div,$link,$title).$img.$key."</div>";
			else
			        $html .= sprintf($div,$link,$title).$img.$key."</div>";
			$html .= "</td></tr></table>\r\n";
/* NO RECURSION!		        if(is_array($value))
		            $this->htmlTree($value,$rpath, $level+1,$html);
*/
		    }
	    }
	    return $html;
	}

	function get_dir_html($path){
		$rpath = $this->get_directory().'/'.$path;
		if(!$this->check_path_file($rpath)){
			return false;
		}
		$arDirTree = $this->dirTree($rpath);
		$filesInDir = $this->get_files_in_dir($rpath);
		asort($filesInDir);
		$arDirTree = array_merge($arDirTree,$filesInDir);
		$html = $this->htmlTree($arDirTree,$path);
		return $html;
	}

	function get_click_path($path){
		if(!$this->check_path_file($this->get_directory().$path)){
			return false;
		}
		$string = ' <a href="'.$this->get_folder_link('').'" style="text-decoration:none;font-family:monospace; font-size:12px;font-weight:bold;background-color:#FFFFFF; border: 1px dotted #000000;padding:3px;" onMouseOver="style.backgroundColor=\'#CACACA\';" onMouseOut="style.backgroundColor=\'#FFFFFF\';">Templates</a> / ';
		$path_click = '';
		$path_split = explode('/',$path);
		for($i=0;$i<sizeOf($path_split);$i++){
			if($path_split[$i] != ''){
				$string .= ' <a href="'.$this->get_folder_link($path_click.$path_split[$i]).'" style="text-decoration:none;font-family:monospace; font-size:12px;font-weight:bold;background-color:#FFFFFF; border: 1px dotted #000000;padding:3px;" onMouseOver="style.backgroundColor=\'#CACACA\';" onMouseOut="style.backgroundColor=\'#FFFFFF\';">'.$path_split[$i].'</a> / ';
				$path_click .= $path_split[$i].'/';
			}
		}
		return $string;
	}
	
	function get_edit_field($path,$file){
		if(!$this->check_path_file($this->get_directory().$path,$file)){
			return false;
		}
		$avar = file($this->get_directory().$path.$file);
		$contents = htmlentities(implode($avar));
		return '<textarea name="contents" rows="40" wrap="off" style="width:100%;font-family:monospace;">'.$contents.'</textarea>';
	}

	function download_files($path,$files,$zip_file_content=''){
		foreach($files as $k=>$file){
			if( !$this->check_path_file($this->get_directory().$path,$file) ){
				return false;
			}
		}
		$zip = '';
		foreach($files as $k=>$file){
			$zip .= $this->get_directory().$path.$file.' ';
		}

		$zip_file = \main::get_exportdata_path()."YESFILE".date('Ymd_His').".zip";
		exec("zip -j $zip_file $zip");
		$zip_file_content = file_get_contents($zip_file);
		unlink($zip_file);
		return true;		
	}
	
	function download_dir($path,$dir,$zip_file_content=''){
		if( !$this->check_path_file($this->get_directory().$path.$dir) ){
			return false;
		}
		$to_zip_path = $dir;
		if($to_zip_path[0] == '/')
			$to_zip_path = substr($to_zip_path,1,strlen($to_zip_path));
		$types = $this->get_allowed_filetypes();
		$zip_include = ' -i \*.{';
		for($i=0;$i<sizeOf($types);$i++){
			$zip_include .= $types[$i].',';
		}
		$zip_include = substr($zip_include,0,strlen($zip_include)-1).'} ';
		$zip_file = \main::get_exportdata_path()."YESFILE".date('Ymd_His').".zip";
		@exec("cd ".$this->get_directory().$path." && zip -r $zip_file $to_zip_path $zip_include");
		$zip_file_content = @file_get_contents($zip_file);
		@unlink($zip_file);
		if(strlen($zip_file_content)==0)
			return false;
		return true;		
	}
	
	function delete_files($path,$files){
		foreach($files as $k=>$file){
			if( !$this->check_path_file($this->get_directory().$path,$file) ){
				return false;
			}
		}
		foreach($files as $k=>$file){
			unlink($this->get_directory().$path.$file);
		}
		return true;		
	}
	
	function delete_directory($path,$dir){
		if( !$this->check_path_file($this->get_directory().$path.$dir) ){
			return false;
		}
		$this->delTree($this->get_directory().$path.$dir);
		return true;		
	}
	
	function new_directory($path,$dir,$new_dir){
		if( !$this->check_path_file($this->get_directory().$path.$dir) ){
			return false;
		}
		if(strlen($new_dir)==0)
			return false;

		if( in_array($new_dir,$this->get_exclude_directories()) ){
			return false;
		}
		if (strpbrk($new_dir, "\\/?%*:|\"<>") === FALSE) {
		    mkdir($this->get_directory().$path.$dir.$new_dir,0755);
		    return true;		
		}else{
		    return false;
		}
	}
	
	function check_path_file($path,$file=false){
		if(!is_dir($path) or !strstr($path,$this->get_directory()) or strstr($path,'..') ){
			return false;
		}
		$path_array = explode('/',$path);
		for($a=0;$a<sizeOf($path_array);$a++){
			if(in_array($path_array[$a],$this->get_exclude_directories()))
				return false;
		}
		if($file){
			$ftype = array_pop( explode( ".", strtolower( $file ) ) );
			if(!in_array($ftype,$this->get_allowed_filetypes()) or strstr($file,'..'))
				return false;
		}
		return true;
	}

	function save_content_to_file($path,$file,$content){
		$rpath = $this->get_directory().'/'.$path;
		if(!$this->check_path_file($rpath,$file)){
			return false;
		}

		if (!$handle = fopen($rpath.$file, "w")) {
			print "Kann die Datei $rpath nicht oeffnen";
			exit;
		}
		
		// Schreibe $somecontent in die geöffnete Datei.
		if (!fwrite($handle, $content)) {
			print "Kann in die Datei $rpath nicht schreiben";
			exit;
		}
		fclose($handle);
	}

}
?>
