<?php
require_once(DIR_FS_ADMIN.'includes/classes/yes_lister_table_heading_sort.php');
class yes_lister
{
	var $listing_sql,$listing_table,$page_link,$select_field_array, $ajax_box, $split_string, $result_list = array(),$ajax_get_param_key,$ajax_link,$start_row_input;
	var $active_row = false;
	var $index_field;
	var $template_file = '';
	var $start_row_input_id = 'start_id';
	var $table_caption;
	var $smarty;
	var $list_actions = array();
	var $FormID = ''; // wird verwendet wenn eine FORM um die Items ist (benoetigt fuer JS Routine select_all)
	var $context_menu = '';
	var $edit_link_param = '';
        var $where_field_array, $ajax_get_param;
        
	
	function __construct($listing_sql,$listing_table,$page_link,$select_field_array = array(),$where_field_array=array(),$ajax_box = 0,$ajax_get_param='',$ajax_link = '',$template_file='yes_lister_item_table.html',$list_actions=array(),$edit_link_param='edit'){
		$this->listing_sql = $listing_sql;
		$this->listing_table = $listing_table;
		$this->select_field_array = $this->setSelectFieldArray($select_field_array);
		$this->where_field_array = $where_field_array;
		$this->page_link = $page_link;
		$this->ajax_box = $ajax_box;
		$this->ajax_get_param = $ajax_get_param;
		$this->ajax_link = $ajax_link;
		$this->template_file = $template_file;
		$this->list_actions = $list_actions;
		$this->setEdit_link_param($edit_link_param);
		$this->query();
	}

	function setSelectFieldArray($value){
		if(sizeOf($value)>0){
			foreach($value as $key=>$val){
				if(isset($val['index']) and $val['index'])
					$this->index_field = $key;
			}
		}
		return $value;
	}

	function query(){
		$listing_query = xtc_db_query($this->listing_sql);
		while ($listing = xtc_db_fetch_array($listing_query)) {
			$this->fetchResult($listing);
		}
	}

	function fetchField($field){
		foreach($this->select_field_array as $k=>$v){
			if($v['field'] == $field){
				return $k;
			}
		}
		return -1;
	}

	function fetchResult($row){
		global $_GET;
		if(sizeOf($row)>0){
			$res = array();
			$edit_link = '';
			$select_link = '';
			$selected = 0;
			$action = '';
			foreach($row as $key=>$value){
				$index = $this->fetchField($key);
				if($index >= 0){
					if(isset($this->select_field_array[$index]['index']) and $this->select_field_array[$index]['index'] and $this->select_field_array[$index]['index'] == true){
						$this->checkActiveRow($row,$this->select_field_array[$index]['field'],$value,$this->select_field_array[$index]['get_param']);
						if ( (is_object($this->active_row)) && ($value == $this->active_row->$key) ) {
							$selected = 1;
							$edit_link = xtc_href_link($this->page_link, 
									xtc_get_all_get_params(array($this->select_field_array[$index]['get_param'])).
									$this->select_field_array[$index]['get_param'].'=' . $this->active_row->$key . '&action='.$this->getEdit_link_param()
							);
							switch($this->getEdit_link_param()){
							    default:
								$action = xtc_image(DIR_WS_IMAGES . 'icon_info.gif', IMAGE_EDIT);
								break;
							    case 'delete_confirm':
								$action = xtc_image(DIR_WS_IMAGES . 'icons/cross.gif', IMAGE_DELETE);
								break;
							}
						}

					}
					$function = (isset($this->select_field_array[$index]['function'])) ? $this->select_field_array[$index]['function'] : '';
                                        
                                        // wird verwendet, wenn eine Funktion mehrere
                                        // parameter braucht. die parameter werden
                                        // dann als Array mitgegeben und entsprechen
                                        // jeweils der DB Spalte. also zb
                                        // ['rueckerstatten_id','type']
                                        $function_params = (isset($this->select_field_array[$index]['function_params'])) ? $this->select_field_array[$index]['function_params'] : [];
					$text_value = $this->formatOutput($value,$this->select_field_array[$index]['format'],$function,$row,$function_params);
					if($text_value != '::HIDE::'){
                                            $align = (isset($this->select_field_array[$index]['align'])) ? $this->select_field_array[$index]['align'] : '';
                                            $res[] = array(
                                                'field'=>$key,
                                                'align'=>$align,
                                                'value_plain'=>$value,
                                                'value'=>$text_value,
                                                'column'=>$this->select_field_array[$index]['column']
                                            );
					}
				}
			}

			$res = $this->record_sort($res,'column');
			if(sizeOf($res)>0){
				if($action == ''){
					$action = xtc_image(DIR_WS_IMAGES . 'icon_info.gif', IMAGE_ICON_INFO);
				}
				$ajax_key = $this->get_ajax_key($res);
				$this->result_list[] = array(
					'selected'=>$selected,
					'edit_link'=>$edit_link,
					'select_link'=>xtc_href_link($this->page_link, xtc_get_all_get_params(array($this->select_field_array[$this->index_field]['get_param'])).$this->select_field_array[$this->index_field]['get_param'].'=' . $res[$this->index_field]['value']),
					'action'=>$action,
					'ajax_key'=>$ajax_key,
					'data'=>$res,
				);
			}
		}
	}

	function get_ajax_key($res){
		if($this->ajax_box == 1){
			for($i=0;$i<sizeOf($res);$i++){
				$key = $this->select_field_array[$this->index_field]['field'];
				if($res[$i]['field'] == $key){
					return $res[$i]['value_plain'];
				}
			}
		}
		return '';
	}

	function checkActiveRow($row,$field,$value,$get_param){
		if(
			(
				(
					!isset($_GET[$get_param])
				) || (
					@$_GET[$get_param] == $value
				)
			) && (
				!$this->active_row
			) && (
				!isset($_GET['action']) or
				(isset($_GET['action']) and substr($_GET['action'], 0, 3) != 'new')
			)
		){
			$this->setActiveRow($row,$field,$value);
		}
	}

	function setActiveRow($row,$field,$value){
		$active_row_query = xtc_db_query(sprintf("select * from %s where %s = '%s'",$this->listing_table,$field,$value));
		$active_row = xtc_db_fetch_array($active_row_query);
		$active_array = xtc_array_merge($row, $active_row);
		$this->active_row = new objectInfo($active_array);
	}

	function setSmarty($value){
		$this->smarty = $value;
	}

	function display($navigation,$query_numrows,$view_limit){
		global $_GET;
		if($this->ajax_box == 1){
			$this->smarty->assign('ajax_box',1);
			$this->split_string  = $navigation->display_count($query_numrows, $view_limit, ((isset($_GET['page']))?$_GET['page']:1), TEXT_DISPLAY_NUMBER_OF_ITEMS,xtc_get_all_get_params(array('page', 'action')));
			$this->split_string .= '<br />'.$navigation->display_links($query_numrows, $view_limit, MAX_DISPLAY_PAGE_LINKS, ((isset($_GET['page']))?$_GET['page']:1), xtc_get_all_get_params(array('page')));
		}else{
			$this->smarty->assign('split_text',$navigation->display_count($query_numrows, $view_limit, ((isset($_GET['page']))?$_GET['page']:1), TEXT_DISPLAY_NUMBER_OF_ITEMS,xtc_get_all_get_params(array('page', 'action'))));
			$this->smarty->assign('split_navi',$navigation->display_links($query_numrows, $view_limit, MAX_DISPLAY_PAGE_LINKS, ((isset($_GET['page']))?$_GET['page']:1), xtc_get_all_get_params(array('page'))));
		}
		if($this->getTableCaption() != ''){
                    $this->smarty->assign('TABLE_CAPTION',$this->getTableCaption());
                }
		$this->smarty->assign('TEXT_SORT_ASC',TEXT_SORT_ASC);
		$this->smarty->assign('TEXT_SORT_DESC',TEXT_SORT_DESC);

		$YLTHS = new yes_lister_table_heading_sort( $this->select_field_array, $this->page_link);
		$this->smarty->assign('headings',$YLTHS->getHeadingRows());
		
		$this->smarty->assign('headings',$this->getHeadingRows());
		
		foreach($this->result_list as $rk=>$rl){
			if(!isset($rl['data']) or !sizeOf($rl['data'])){
				continue;
			}
			$id = $rl['data'][0]['value_plain'];
			if($this->context_menu != ''){
				$cm = new context_menu($this->context_menu,$id,$_SESSION['customer_id']);
				$this->result_list[$rk]['data'][0]['context_menu'] = $cm->get_default_element_html();
			}
		}
		$this->smarty->assign('TABLE_ID',$this->listing_table);
		$this->smarty->assign('listing',$this->result_list);
		$key = $this->select_field_array[$this->index_field]['field'];
		if($this->active_row){
			$this->smarty->assign('start_row_input',xtc_draw_hidden_field(
					$this->start_row_input_id,
					$this->active_row->$key
			));
			$this->start_row_input = xtc_draw_hidden_field($this->start_row_input_id,$this->active_row->$key);
		}
		$this->smarty->assign('AJAX_GET_PARAM_KEY',$this->ajax_get_param);
		$this->smarty->assign('AJAX_LINK',$this->ajax_link);
		$this->smarty->assign('FORM_ID',$this->getFormID());
		if(is_array($this->list_actions) and sizeOf($this->list_actions)){
			$this->smarty->assign('LIST_ACTIONS',$this->list_actions);
		}
		$this->smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
		
		if(isset($_REQUEST['order_by'])){
			$order_by_parts = explode(' ',$_REQUEST['order_by']);
			$this->smarty->assign('current_sort_row',$order_by_parts[0]);
			$this->smarty->assign('current_sort_dir',($order_by_parts[1] == 'DESC') ? 'DESC' : 'ASC');
		}
		return $this->smarty->fetch($this->template_file);
	}

	function getHeadingRows(){
		$headings = array();
		$rows = $this->select_field_array;

		// SORT DIRECTION SWITCH
		$current_sort_row = false;
		if(isset($_REQUEST['order_by'])){
			$order_by_parts = explode(' ',$_REQUEST['order_by']);
			$current_sort_row = $order_by_parts[0];
			$next_sort_direction = ($order_by_parts[1] == 'DESC') ? 'ASC' : 'DESC';
		}
		foreach($rows as $key=>$value){
			if(!isset($value['heading_hide']) or $value['heading_hide'] == 0){
				if(!$current_sort_row or $current_sort_row != $value['field']){
					$sort_href = xtc_href_link($this->page_link,xtc_get_all_get_params(array('order_by')).'order_by='.$value['field'].'%20DESC');
				}else{
					// SORT DIRECTION SWITCH
					$sort_href = xtc_href_link($this->page_link,xtc_get_all_get_params(array('order_by')).'order_by='.$value['field'].'%20'.$next_sort_direction);
				}

				$headings[] = array(
					'title'=>$value['heading'],
					'field'=>$value['field'],
					'sort'=>$value['sortable'],
					'column'=>$value['column'],
					'sort_href_asc'=>xtc_href_link($this->page_link,xtc_get_all_get_params(array('order_by')).'order_by='.$value['field'].'%20DESC'),
					'sort_href_desc'=>xtc_href_link($this->page_link,xtc_get_all_get_params(array('order_by')).'order_by='.$value['field'].'%20ASC'),
					'sort_href'=>$sort_href
				);
			}else{
				if($this->$value['heading_display_function']() == true){
					$headings[] = array(
						'title'=>$value['heading'],
						'sort'=>$value['sortable'],
						'field'=>$value['field'],
						'column'=>$value['column'],
						'sort_href_asc'=>xtc_href_link($this->page_link,xtc_get_all_get_params(array('order_by')).'order_by='.$value['field'].'%20DESC'),
						'sort_href_desc'=>xtc_href_link($this->page_link,xtc_get_all_get_params(array('order_by')).'order_by='.$value['field'].'%20ASC')
					);
				}
			}
		}
		return $this->record_sort($headings,'column');
	}

	function record_sort($records, $field, $reverse=false)
	{
	    $hash = array();
	   
	    foreach($records as $key => $record)
	    {
	        $hash[$record[$field].$key] = $record;
	    }
	   
	    ($reverse)? krsort($hash) : ksort($hash);
	   
	    $records = array();
	   
	    foreach($hash as $record)
	    {
	        $records []= $record;
	    }
	   
	    return $records;
	}

	function formatOutput($value,$class,$function,$row, array $function_params = []){
		if(xtc_not_null($function) and function_exists($function)){
                    if(is_countable($function_params) and sizeOf($function_params)){
                        $function_param_values = [];
                        foreach($function_params as $fp){
                            if(!isset($row[$fp])){
                                throw new Exception(sprintf(
                                        "Invalid Function parameter %s by calling %s()",
                                        $fp, $function
                                ));
                            }
                            $function_param_values[] = $row[$fp];
                        }
                        $value = call_user_func_array($function, $function_param_values);
                    }else{
                        $value = call_user_func($function,$value);
                    }
		}
		switch($class){
			case 'int':
				return (int) $value;
			case 'currency':
				return number_format($value,2,',','.').'&nbsp;';
			case 'string':
				return $value;
			case 'date':
				if($value > 0){
					return xtc_date_short($value);
				}
				return '';
		}
	}

	function setTableCaption($value){
		$this->table_caption = $value;
	}

	function getTableCaption(){
		return $this->table_caption;
	}

	public function getFormID() {
	 return $this->FormID;
	}

	public function setFormID($FormID) {
	 $this->FormID = $FormID;
	}
	
	public function getEdit_link_param() {
	    return $this->edit_link_param;
	}

	public function setEdit_link_param($edit_link_param) {
	    $this->edit_link_param = $edit_link_param;
	}
        
}
