<?php
/**
 * Email Mitarbeiter Zuweisungen
 * 
 * Zu Emails koennen Admin User zugewiesen werden. Ausserdem koennen Kommentare
 * verfasst werden. 
 * Es finden PUSH Benachrichtigungen statt (sofern der User email_staff bei den
 * Benachrichtigungen aktiviert hat und PUSH aktiviert hat)
 * 
 */
class email_staff_allocation {
    var  $email_staff_allocation_id, $email_id, $customers_id, $date_added;
    
    function getEmail_staff_allocation_id() {
        return $this->email_staff_allocation_id;
    }

    function getEmail_id() {
        return $this->email_id;
    }

    function getCustomers_id() {
        return $this->customers_id;
    }

    function getDate_added() {
        return $this->date_added;
    }

    function setEmail_staff_allocation_id($email_staff_allocation_id) {
        $this->email_staff_allocation_id = $email_staff_allocation_id;
    }

    function setEmail_id($email_id) {
        $this->email_id = $email_id;
    }

    function setCustomers_id($customers_id) {
        $this->customers_id = $customers_id;
    }

    function setDate_added($date_added) {
        $this->date_added = $date_added;
    }

    function __construct( $id = Null ){
        if($id !== Null){
            $query = xtc_db_query(sprintf(
                    "SELECT * FROM email_staff_allocation WHERE email_staff_allocation_id='%d'",
                    $id
            ));
            if(xtc_db_num_rows($query)){
                $this->setEmail_staff_allocation_id($id);
                $record = xtc_db_fetch_array($query);
                $this->setCustomers_id($record['customers_id']);
                $this->setDate_added($record['date_added']);
                $this->setEmail_id($record['email_id']);
            }
        }
    }
 
    /**
     * Gibt ein Array aller Admin User zurueck, ausser dem eigenen User.
     * 
     * Wird benoetigt um eine Auswahl der User anzuzeigen, dem man eine Email
     * zuweisen moechte.
     * 
     * @return array
     */
    public function get_customers(){
        $return = array();
        $query = xtc_db_query(sprintf(
                "SELECT customers_id, customers_firstname, customers_lastname FROM %s WHERE customers_status=0 AND customers_id!='%d' ORDER BY customers_lastname",
                TABLE_CUSTOMERS,$_SESSION['customer_id']
        ));
        while($record = xtc_db_fetch_array($query)){
            if(empty($record['customers_lastname'])){
                continue;
            }
            $return[] = array(
                'id'=>$record['customers_id'],
                'text'=>sprintf('(%d) %s, %s',
                        $record['customers_id'],
                        $record['customers_lastname'],
                        $record['customers_firstname']
                )
            );
        }
        return $return;
    }
    
    /**
     * Mitarbeiter Zuweisung loeschen
     * 
     * Loescht eine Adminuser Zuweisung
     * 
     * @return boolean
     */
    public function delete(){
        $this->add_history($this->getEmail_id(), sprintf(
                STAFF_ALLOCATION_HISTORY_DELETE,
                xtc_get_editor_name($this->getCustomers_id()),
                $this->getCustomers_id()
        ));
        xtc_db_query(sprintf(
                "DELETE FROM email_staff_allocation WHERE email_staff_allocation_id='%d'",
                $this->getEmail_staff_allocation_id()
        ));
        return true;
    }
    
    public function allocation_exists(int $email_id, int $customers_id){
        $query = xtc_db_query(sprintf(
                "SELECT email_staff_allocation_id FROM email_staff_allocation WHERE customers_id='%d' AND email_id='%d'",
                $customers_id, $email_id
        ));
        return (xtc_db_num_rows($query)>0) ? true : false;
    }
    
    /**
     * Speichert die Zuweisung eines Adminusers zu einer Email.
     * 
     * @param int $email_id
     * @param int $customers_id
     * @return boolean
     */
    public function add(int $email_id, int $customers_id){
        if($this->allocation_exists($email_id, $customers_id)){
            return false;
        }
        $insert_sql_array = array(
            'email_id'=>$email_id,
            'customers_id'=>$customers_id,
            'date_added'=>'now()'
        );
        xtc_db_perform('email_staff_allocation',$insert_sql_array);
        $this->add_history($email_id,sprintf(
                STAFF_ALLOCATION_HISTORY_ADD,
                xtc_get_editor_name($customers_id),
                $customers_id
        ));
        return true;
    }
    
    /**
     * Historie erzeugen
     * 
     * Fuegt der Emailzuweisung einen Historieneintrag hinzu.
     * 
     * @param int $email_id
     * @param string $comments
     * @return boolean
     */
    public static function add_history(int $email_id, string $comments){
        $recipients = self::get_recipients($email_id);
        foreach($recipients as $customers_id){
            $insert_sql_array = array(
                'email_id'=>$email_id,
                'customers_id'=>$customers_id,
                'sender_id'=>$_SESSION['customer_id'],
                'comments'=>$comments,
                'date_added'=>'now()',
                'read_status'=>0
            );
            xtc_db_perform('email_staff_allocation_history',$insert_sql_array);
        }
        return true;
    }
    
    /**
     * Historieneintraege einlesen
     * 
     * Liefert ein Array aller Historieneintraege zu einer Email. Sortiert nach
     * Datum, neueste zuerst
     * 
     * @param int $email_id
     * @return array
     */
    public static function get_history(int $email_id){
        $return = array();
        $query = xtc_db_query(sprintf(
                "SELECT * FROM email_staff_allocation_history WHERE email_id='%d' ORDER BY date_added DESC",
                $email_id
        ));
        while($record = xtc_db_fetch_array($query)){
            $return[] = $record;
        }
        return $return;
    }
    
    /**
     * Zuweisungen Usernamen kommasepariert
     * 
     * Liefert einen Kommaseparierten String der zugewiesenen Adminuser einer
     * Email
     * 
     * @param int $email_id
     * @return string
     */
    public function get_allocation_link_title(int $email_id){
        $return = array();
        $query = xtc_db_query(sprintf(
                "SELECT customers_id FROM email_staff_allocation WHERE email_id='%d'",
                $email_id
        ));
        while($record = xtc_db_fetch_array($query)){
            $return[] = xtc_get_editor_name($record['customers_id']);
        }
        if(!sizeOf($return)){
            return '';
        }
        if(!defined('STAFF_ALLOCATION_LINK_TITLE')){
            require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/ebay_email.php');
        }
        return sprintf(STAFF_ALLOCATION_LINK_TITLE,implode(', ',$return));
    }
    
    /**
     * Zuweisungen Array
     * 
     * liefert alle customer_id Zuweisungen zur Email als Array (ausser eigenem
     * User)
     * wird zb benoetigt um PUSH Benachrichtigungen an alle anderen User zu
     * senden.
     * 
     * @param int $email_id
     * @return array
     */
    public static function get_recipients( int $email_id ){
        $return = array();
        $query = xtc_db_query(sprintf(
                "SELECT customers_id FROM email_staff_allocation WHERE email_id='%d' AND customers_id !='%d'",
                $email_id, $_SESSION['customer_id']
        ));
        while($record = xtc_db_fetch_array($query)){
            $return[] = $record['customers_id'];
        }
        return $return;
    }

    /**
     * Read Status aktualisieren
     * 
     * Den read_status eines Historieneintrags fuer einen Mitarbeiter aendern
     * 0=ungelesen; 1=gelesen
     * 
     * @param int $email_staff_allocation_history_id
     * @param int $read_status
     */
    public static function set_history_read_status(int $email_staff_allocation_history_id, int $read_status = 1){
        xtc_db_perform('email_staff_allocation_history',array(
            'read_status'=>$read_status
        ),
        'update',"email_staff_allocation_history_id='".$email_staff_allocation_history_id."' AND customers_id='".$_SESSION['customer_id']."'");
    }
}
