<?php
/**
 * condition muss beim artikel gesetzt sein
 * die kategorie muss mit google product feed versehen sein
 *
 * @author mario
 */
require_once(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');
class google_product_feed {
	var $separator = "\t";
	var $filename;
	var $language_id;
	var $availability = 'in stock';
	#	'available for order'
	#	'out of stock'
	#	'preorder'
	
	function __construct($language_id) {
		$this->language_id = $language_id;
		$query = xtc_db_query(sprintf(
			"SELECT p.products_id,products_name,products_short_description,p.products_image,products_conditions_id,products_price,manufacturers_id,products_weight FROM products p LEFT JOIN products_description pd USING(products_id) LEFT JOIN products_collies pc ON pd.products_id=pc.collie_products_id WHERE products_status=1 AND language_id='%s' AND pc.products_collies_id IS NULL AND p.no_google_product_feed_export=0",
			$this->language_id
		));
		$xtPrice = new xtcPrice(DEFAULT_CURRENCY,DEFAULT_CUSTOMERS_STATUS_ID);
		while($record = xtc_db_fetch_array($query)){
			$products_tax_class_id = yes_eu_oss_get_products_tax_class_id(
                            $record['products_id'], STORE_COUNTRY
                        );
				$gpf_data = $this->get_gpf_data($record['products_id']);
				foreach($gpf_data as $k=>$v){
					if($k == 'google_condition') $k = 'condition';
					$record[ $k ] = $v;
				}
				
				$mo_images = $this->get_mo_images($record['products_id']);
				if(sizeOf($mo_images)){
					$record['additional_image_link'] = implode(',',$mo_images);
				}
				$record['category'] = $this->get_category_id($record['products_id']);
				$record['description'] = $this->prepare_string($record['products_short_description']);
				$record['link'] = $this->xtc_href_link('product_info.php', 'products_id='.$record['products_id'], 'NONSSL', false);
				$record['image'] = $this->get_image_url($record['products_image']);
				$record['price'] = $xtPrice->xtcGetPrice($record['products_id'],
						true,
						1,
						$products_tax_class_id,
				'');
				$price_raw = $xtPrice->xtcGetPrice($record['products_id'],
						false,
						1,
						$products_tax_class_id,
				'');
				$record['brand'] = $this->get_products_manufacturer($record['manufacturers_id']);
                                if(defined('MODULE_ORDER_TOTAL_SHIPPING_STATUS') and MODULE_ORDER_TOTAL_SHIPPING_STATUS == 'true'){
                                    if(MODULE_ORDER_TOTAL_SHIPPING_DESTINATION == 'national'){
                                        if(MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING == 'true'){
                                            if($price_raw >= MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER){
                                                $record['shipping'] = sprintf('DE::Free:0,00 %s',DEFAULT_CURRENCY);
                                            }
                                        }
                                    }
                                }
                                if(!isset($record['shipping'])){
                                    $record['shipping'] = $this->get_shippingcosts_de($record['products_id']);
                                }
                                
				$record['weight'] = sprintf('%s kg',$record['products_weight']);
		}
	}
	
	private static function get_header_row(){
		return array(
			'id','title','description','google_product_category','price','condition','link','image_link','additional_image_link','availability','price','brand'
		);
	}
	
	private function get_category_id($products_id){
		$query = xtc_db_query(sprintf(
			"SELECT p2c.categories_id,cd.categories_name,cd.google_product_feed_category FROM products_to_categories p2c LEFT JOIN categories c USING(categories_id) LEFT JOIN categories_description cd USING(categories_id) WHERE p2c.products_id='%s' AND c.categories_status=1 AND c.link_id=0 AND cd.language_id='%s' LIMIT 1",
			$products_id,$this->language_id
		));
		if(!xtc_db_num_rows($query))
			return array();
		$record = xtc_db_fetch_array($query);
		return $record;
	}
	
	private function prepare_string($string){
		return str_replace(array("\r\n","\r","\n"),'',$string);
	}
	
	private function xtc_href_link($page = '', $parameters = '', $connection = 'NONSSL', $add_session_id = true, $search_engine_safe = true, $urlencode=false) {
	    global $request_type, $session_started, $http_domain, $https_domain,$truncate_session_id;

	    if (!xtc_not_null($page)) {
	      //die('</td></tr></table></td></tr></table><br /><br /><font color="#ff0000"><b>Error!</b></font><br /><br /><b>Unable to determine the page link!<br /><br />');
	      $page = 'index.php';
	    }

	    if ($connection == 'NONSSL') {
	      $link = HTTP_SERVER . DIR_WS_CATALOG;
	    } elseif ($connection == 'SSL') {
	      if (ENABLE_SSL == true) {
	        $link = HTTPS_SERVER . DIR_WS_CATALOG;
	      } else {
	        $link = HTTP_SERVER . DIR_WS_CATALOG;
	      }
	    } else {
	      die('</td></tr></table></td></tr></table><br /><br /><font color="#ff0000"><b>Error!</b></font><br /><br /><b>Unable to determine connection method on a link!<br /><br />Known methods: NONSSL SSL</b><br /><br />');
	    }
	    if (xtc_not_null($parameters)) {
	      $link .= $page . '?' . $parameters;
	      $separator = '&';
	    } else {
	      $link .= $page;
	      $separator = '?';
	    }

	    while ( (substr($link, -1) == '&') || (substr($link, -1) == '?') ) $link = substr($link, 0, -1);

	// Add the session ID when moving from different HTTP and HTTPS servers, or when SID is defined
	    if ( ($add_session_id == true) && ($session_started == true) && (SESSION_FORCE_COOKIE_USE == 'False') ) {
	      if (defined('SID') && xtc_not_null(SID)) {
	        $sid = SID;
	      } elseif ( ( ($request_type == 'NONSSL') && ($connection == 'SSL') && (ENABLE_SSL == true) ) || ( ($request_type == 'SSL') && ($connection == 'NONSSL') ) ) {
	        if ($http_domain != $https_domain) {
	          $sid = session_name() . '=' . session_id();
	        }
	      }
	    }

	//--- SEO Hartmut König -----------------------------------------//
	    if (
	        ((SEARCH_ENGINE_FRIENDLY_URLS == 'true') && ($search_engine_safe == true)) )
	        {
	        require_once(DIR_FS_INC . 'shopstat_functions.inc.php');

	        $seolink = shopstat_getSEO( $page,
	                                    $parameters,
	                                    $connection,
	                                    $add_session_id,
	                                    $search_engine_safe,
	                                    'admin');
	        if($seolink)
	            {
	            $link       = $seolink;
	            $elements   = parse_url($link);
	            (isset($elements['query']))
	                ? $separator = '&'
	                : $separator = '?';
	            }
	        }
	//--- SEO Hartmut König -----------------------------------------//

		// remove session if useragent is a known Spider
	    if ($truncate_session_id) $sid=NULL;

	    if (isset($sid)) {
	      $link .= $separator . $sid;
	    }
	/*
	    if ( (SEARCH_ENGINE_FRIENDLY_URLS == 'true') && ($search_engine_safe == true) ) {
	      while (strstr($link, '&&')) $link = str_replace('&&', '&', $link);

	      $link = str_replace('?', '/', $link);
	      $link = str_replace('&', '/', $link);
	      $link = str_replace('=', '/', $link);
	      $separator = '?';
	    }
	*/

	    //-- W3C-Conform
	    if($urlencode)
	        {
	        $link = htmlentities($link);
	        }

	    return $link;
	}
	
	private function get_mo_images($products_id){
		$array = array();
		$query = xtc_db_query(sprintf(
			"SELECT image_name FROM products_images WHERE products_id='%s' AND noshop=0",
			$products_id
		));
		while($record = xtc_db_fetch_array($query)){
			$array[] = $this->get_image_url($record['image_name']);
		}
		return $array;
	}
	
	private function get_image_url($image){
		return sprintf('%simages/product_images/thumbnail_images/%s',HTTP_SERVER,$image);
	}
	
	private function get_condition($condition){
		$c = strtolower($condition);
		switch($c){
			case 'neu':
			case 'new':
				return 'new';
				break;
			default:
				return 'used';
				break;
		}
	}
	
	private function get_products_manufacturer($manufacturers_id){
		$query = xtc_db_query(sprintf(
			"SELECT manufacturers_name FROM manufacturers WHERE manufacturers_id='%s'",
			$manufacturers_id
		));
		$record = xtc_db_fetch_array($query);
		return $record['manufacturers_name'];
	}
	
	private function get_gpf_data($products_id){
		$query = xtc_db_query(sprintf(
			"SELECT google_condition,availability,gtin,mpn,adwords_grouping,adwords_labels FROM products_google_feed_data WHERE products_id='%s'",
			$products_id
		));
		$record = xtc_db_fetch_array($query);
		if(defined('MODULE_GOOGLE_PRODUCT_FEED_APPAREL') and MODULE_GOOGLE_PRODUCT_FEED_APPAREL == 'True'){
			$query = xtc_db_query(sprintf(
				"SELECT gender,age_group,color,size FROM products_google_feed_apparel WHERE products_id='%s' AND language_id='%s'",
				$products_id,$this->language_id
			));
			$record2 = xtc_db_fetch_array($query);
			foreach($record2 as $k=>$v){
				$record[ $k ] = $v;
			}
		}
		return $record;
	}
	
	// BOF VERSANDKRAM
	
	private function get_shippingcosts_de($products_id){
		// versandkosten DE
		if(MODULE_SHIPPING_YES_STATUS != 'True'){
			return 0;
		}
	
		$group_id_germany = main::get_shipping_graduation_groups_id_by_countries_id(STORE_COUNTRY);
		$pweight = xtc_get_ext_products_weight($products_id);
		if(main::get_ext_shipping_costs_status($products_id)){

			$ext_additionalcosts = main::get_product_shipping_extra_charges($products_id, $group_id_germany);

			$costs = main::get_ext_shipping_costs($products_id);
			foreach($costs as $group_id => $qty_array){
				if($group_id_germany == $group_id){
					$brutto = true;
					$shipping_price = main::calc_yes_modul($ext_additionalcosts+$qty_array[1],$group_id,$pweight,$products_id,$brutto);
				}
			}
		}else{
			$qty = 1;
			$grad_query = xtc_db_query("select * from shipping_graduation WHERE value=1");
			$grad = xtc_db_fetch_array($grad_query);
			$gID = $grad['shipping_graduation_id'];
			$groups_query = xtc_db_query("select * from shipping_graduation_groups ORDER BY shipping_graduation_groups_id");

			$extra_charge = main::get_product_shipping_extra_charges($products_id, $group_id_germany);
                        $tmp_groups = array();
			while($groups = xtc_db_fetch_array($groups_query)){
                            $tmp_groups[] = $groups;
                        }
                        foreach($tmp_groups as $groups){
				$group_id = $groups['shipping_graduation_groups_id'];
				if($group_id_germany == $group_id){
					// pweight nehmen wir fuer die kalkulation des Preises
					$weight_query = xtc_db_query("select * from shipping_graduation_weights order by weight DESC");
					while ($weight = xtc_db_fetch_array($weight_query)) {
						if((float)$pweight <= (float)$weight['weight']){
							$wID = $weight['shipping_graduation_weights_id'];
						}
					}
					$grad_query_raw = sprintf("SELECT grad_value FROM shipping_graduation_values WHERE shipping_graduation_weights_id='%s' and shipping_graduation_groups_id='%s' and shipping_graduation_id='%s'",$wID,$group_id,$gID);
					$grad_query = xtc_db_query($grad_query_raw);
					$grad = xtc_db_fetch_array($grad_query);

					$product_shipping = $grad['grad_value']+$extra_charge;

					$price = main::calc_yes_modul($product_shipping,$group_id,$pweight,$products_id);
					$tax_class = constant('MODULE_SHIPPING_YES_TAX_CLASS');
					$tax_value = xtc_get_tax_rate($tax_class, STORE_COUNTRY);
					$tax_price = $price*(($tax_value+100)/100);
					$c_array = main::get_group_countries($group_id);
					if(sizeOf($c_array)>0){
						$shipping_price = number_format($tax_price,2,'.','');
					}
				}
			}
		}
		return sprintf('DE::Standard:%s %s',$shipping_price,DEFAULT_CURRENCY);
	}
	
	private function get_ext_shipping_costs_status($products_id){
            return main::get_ext_shipping_costs_status($products_id);
	}

	private function get_ext_shipping_costs($products_id){
            return main::get_ext_shipping_costs($products_id);
	}
        
        // OBSOLETE
	private function get_shipping_extra_charge($products_id){
            return main::get_shipping_extra_charge($products_id);
	}
	
	private function calc_yes_modul($shipping,$group_id,$pweight,$pID,$brutto = false){
            main::calc_yes_modul($shipping,$group_id,$pweight,$pID,$brutto);
        }
	
	private function get_group_countries($gID){
            return main::get_group_countries($gID);
	}
	private function get_weight_calc($gID){
            return main::get_weight_calc($gID);
	}
	
	// EOF VERSANDKRAM
	
	
}
