<?php
/* --------------------------------------------------------------
   $Id: order.php,v 1.233 2020/06/24 08:50:01 ssh-511548-cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(order.php,v 1.6 2003/02/06); www.oscommerce.com
   (c) 2003	 nextcommerce (order.php,v 1.12 2003/08/18); www.nextcommerce.org

   Released under the GNU General Public License
   --------------------------------------------------------------
   Third Party contribution:

   Customers Status v3.x  (c) 2002-2003 Copyright Elari elari@free.fr | www.unlockgsm.com/dload-osc/ | CVS : http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/elari/?sortby=date#dirlist

   Credit Class/Gift Vouchers/Discount Coupons (Version 5.10)
   http://www.oscommerce.com/community/contributions,282
   Copyright (c) Strider | Strider@oscworks.com
   Copyright (c  Nick Stanko of UkiDev.com, nick@ukidev.com
   Copyright (c) Andre ambidex@gmx.net
   Copyright (c) 2001,2002 Ian C Wilson http://www.phesis.org
   Copyright (c) 2005 Mario Aspeleiter <mario.aspeleiter@gmx.de>

   Released under the GNU General Public License
   --------------------------------------------------------------*/
require_once(DIR_FS_CATALOG.'includes/classes/order_positions.php');
if(!function_exists('xtc_get_short_description')){
    require_once(DIR_FS_INC . 'xtc_get_short_description.inc.php');
}
require_once(DIR_FS_INC.'xtc_get_tax_description.inc.php');
if(defined('MODULE_OTHER_YES_HITMEISTER_API_STATUS') and MODULE_OTHER_YES_HITMEISTER_API_STATUS == 'True'){
    require_once(DIR_WS_CLASSES.'yes_hitmeister.php');
}
class order {
    var $info, $totals, $products, $customer, $billing, $delivery,$costs,$rueckerstattungen,$language_id,$editor_id,$ebay_id_array;
    var $ebay_no_shippingaddress, $ebay_no_registrationaddress, $ebay_different_address;
    var $hitmeister, $hitmeister_products, $allow_shipping_ebay_1_hour;

    function __construct($order_id) {
        global $_SESSION;
        $this->language_id = 2;
        $this->info = array();
        $this->totals = array();
        $this->products = array();
        $this->customer = array();
        $this->delivery = array();
        $this->costs = array();
        $this->rueckerstattungen = array();
        $this->editor_id = intval($_SESSION['customer_id']??0);
        if(!$this->query($order_id)){
            return false;
        }
        return true;
    }
    
    function getAllow_shipping_ebay_1_hour() {
        return $this->info['allow_shipping_ebay_1_hour'];
    }

    function setAllow_shipping_ebay_1_hour($allow_shipping_ebay_1_hour): void {
        $this->info['allow_shipping_ebay_1_hour'] = $allow_shipping_ebay_1_hour;
    }

    
    public function get_price_instance(){
        $xtPrice = new xtcPrice($this->info['currency'],$this->info['status']);
        // EU-OSS 2021/07
        // BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
        /*if(yes_eu_oss_use_country_handling($this->delivery['country_id'])){
            $xtPrice->setCountryZone($this->delivery['country_id'],$this->delivery['zone_id'] );
        }*/
        // EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
        
        // BUGF_CH_OSS
        $xtPrice->setCountryZone($this->delivery['country_id'],$this->delivery['zone_id'] );
        
        return $xtPrice;
    }

    function query($order_id) {
        $order_query = xtc_db_query("select *
            from " . TABLE_ORDERS . " o where
            orders_id = '" . xtc_db_input($order_id) . "'");
        if(!xtc_db_num_rows($order_query)){
            return false;
        }
        $order = xtc_db_fetch_array($order_query);

        $totals_query = xtc_db_query("select * from " . TABLE_ORDERS_TOTAL . " where orders_id = '" . xtc_db_input($order_id) . "' order by sort_order");
        while ($totals = xtc_db_fetch_array($totals_query)) {
            if( strpos( $totals['title'],':') != strlen($totals['title'])-1 ){
                $totals['title'] = $totals['title'].':';
            }
            $this->totals[] = array('title' => $totals['title'],
                'text' => $totals['text'],
                'value' => $totals['value'],
                'id' => $totals['orders_id'],
                'otid' => $totals['orders_total_id'],
                'class' => $totals['class'],
                'tax_rate_percent' => $totals['tax_rate_percent'],
                'sort_order'=>$totals['sort_order']
            );
        }

        $costs_query = xtc_db_query("select * from costs where orders_id = '" . xtc_db_input($order_id) . "' order by date_created");
        while ($costs = xtc_db_fetch_array($costs_query)) {
            $this->costs[] = array('class' => $costs['class'],
                'reclamations_id'=>$costs['reclamations_id'],
                'customers_id'=>$costs['customers_id'],
                'comments'=>xtc_db_input($costs['comments']),
                'value'=>xtc_db_input($costs['value']),
                'date_created'=>$costs['date_created'],
                'editor_id'=>$costs['editor_id']
            );
        }

        $rueck_query = xtc_db_query("select * from rueckerstattungen where orders_id = '" . xtc_db_input($order_id) . "' order by date_created");
        while ($rueck = xtc_db_fetch_array($rueck_query)) {
            $this->rueckerstattungen[] = array('reclamations_id' => $rueck['reclamations_id'],
                'id'=>$rueck['rueckerstattungs_id'],
                'betrag'=>$rueck['betrag'],
                'paymode'=>$rueck['paymode'],
                'date_created'=>$rueck['date_created'],
                'date_payment'=>$rueck['date_payment'],
                'kto_nummer'=>$rueck['kto_nummer'],
                'kto_blz'=>$rueck['kto_blz'],
                'kto_inhaber'=>$rueck['kto_inhaber'],
                'kto_bank'=>$rueck['kto_bank'],
                'kto_grund'=>$rueck['kto_grund'],
                'kto_iban'=>$rueck['kto_iban'],
                'kto_swift'=>$rueck['kto_swift'],
                'comments'=>$rueck['comments'],
                'editor_id'=>$rueck['editor_id'],
                'status'=>$rueck['status'],
            );
        }

        $eb_query = xtc_db_query("SELECT customers_ebay_userid FROM customers WHERE customers_id='".$order['customers_id']."'");
        $eb = xtc_db_fetch_array($eb_query);
        $ebayuser = $eb['customers_ebay_userid'];
        $this->info = array('currency' => $order['currency'],
            'currency_value' => $order['currency_value'],
            'payment_method' => $order['payment_class'],
            'payment_class_db' => $order['payment_class'],
            'payment_class_raw' => $order['payment_class'],
            'payment_method_db' => $order['payment_method'],
            'status' => $order['customers_status'],
            'status_name' => $order['customers_status_name'],
            'status_image' => $order['customers_status_image'],
            'status_discount' => $order['customers_status_discount'],
            'cc_type' => $order['cc_type'],
            'cc_owner' => $order['cc_owner'],
            'cc_number' => $order['cc_number'],
            'cc_expires' => $order['cc_expires'],
            'cc_cvv'=>$order['cc_cvv'],
            'comments' => $order['comments'],
            'language' => $order['language'],
            'date_purchased' => $order['date_purchased'],
            'date_shipping' => $order['date_shipping'],
            'orders_status' => $order['orders_status'],
            'orders_status_name' => $this->get_status_name($order['orders_status']),
            'id' => $order['orders_id'],

            /* DAS ALTE KOMBINIEREN-HANDLING */
            'is_parent' => $order['is_parent'],
            'parent_orders_id' => $order['parent_orders_id'],

            /* KOMBINIEREN-HISTORY */
            'combined_orders_id'=>$order['combined_orders_id'],

            'ebay_id'=>$order['ebay_id'],
            'ebay_userid'=>$ebayuser,
            'last_modified' => $order['last_modified'],
            'date_payment' => $order['date_payment'],
            'no_warning' => $order['no_warning'],
            'versender' => $order['versender'],
            'shipping_class' => $order['shipping_class'],
            'shipping_method' => $order['shipping_method'],
            'warning_span_date' => $order['warning_span_date'],
            'warning_span' => $order['warning_span'],
            'warning_status' => $order['warning_status'],
            'block_shipping' => $order['block_shipping'],
            'block_shipping_comment'=>$order['block_shipping_comment'],
            'block_shipping_end_date'=>$order['block_shipping_end_date'],
            'ebay_no_shippingaddress'=>$order['ebay_no_shippingaddress'],
            'ebay_no_registrationaddress'=>$order['ebay_no_registrationaddress'],
            'ebay_different_address'=>$order['ebay_different_address'],
            'select_set'=>$order['select_set'],
            'select_set_status'=>$order['select_set_status'],
            'select_set_product_status'=>$order['select_set_product_status'],
            'rueckstand'=>$order['rueckstand'],
            'orders_split_id'=>$order['orders_split_id'],
            'ebayfeedback_block_status'=>$order['ebayfeedback_block_status'],
            'comments_visible'=>$order['comments_visible'],
            'payment_transaction_id'=>$order['payment_transaction_id'],
            'part_orders'=>0,
            'not_ship_products'=>0,
            'source'=>$order['source'],
            'source_editor_id'=>$order['source_editor_id'],
            'marge'=>$order['marge'],
            'shipping_comments'=>$order['shipping_comments'],
            'account_type'=>$order['account_type'],
            'ebay_plus'=>$order['ebay_plus'], 
            'yes_amazon_pay_reference'=>$order['yes_amazon_pay_reference'],
            'prime'=>$order['amazon_prime'],
            'allow_shipping_ebay_1_hour'=>$order['allow_shipping_ebay_1_hour'],
            'allow_email_shipper'=>$order['allow_email_shipper'],
            'commission_number'=>$order['commission_number'],
            'distribution_warehouse_storage_id'=>$order['distribution_warehouse_storage_id'],
        );
        if(isset($order['yes_amazon_pay_reference_id'])){
            $this->info['yes_amazon_pay_reference_id'] = $order['yes_amazon_pay_reference_id'];
        }

        $this->customer = array('name' => $order['customers_name'],
            'company' => $order['customers_company'],
            'csID' => $order['customers_cid'],
            'vat_id' => $order['customers_vat_id'],
            'shop_id' => ((isset($order['shop_id']))?$order['shop_id']:''),
            'ID' => $order['customers_id'],
            'cIP' => $order['customers_ip'],
            'street_address' => $order['customers_street_address'],
            'suburb' => $order['customers_suburb'],
            'city' => $order['customers_city'],
            'postcode' => $order['customers_postcode'],
            'state' => $order['customers_state'],
            'country' => $order['customers_country'],
            'format_id' => $order['customers_address_format_id'],
            'telephone' => $order['customers_telephone'],
            'mobile' => $order['customers_mobile'],
            'email_address' => $order['customers_email_address']
        );

        if($order['ebay_id'] != ''){
            $this->ebay_id_array[] = $order['ebay_id'];
        }
        $ebay_ids_query = xtc_db_query(sprintf(
            "SELECT ebay_id FROM orders WHERE combined_orders_id='%s' and ebay_id != ''",
            $order['orders_id']
        ));
        while($ebay_ids = xtc_db_fetch_array($ebay_ids_query)){
            $this->ebay_id_array[] = $ebay_ids['ebay_id'];
        }
        // WE NEED THE COUNTRY ID
        $delivery_country_id_query = xtc_db_query(sprintf(
            "SELECT countries_id,countries_iso_code_2 FROM countries WHERE countries_name='%s'",
            xtc_db_input($order['delivery_country'])
        ));
        $delivery_country_id = xtc_db_fetch_array($delivery_country_id_query);

        $this->delivery = array('name' => $order['delivery_name'],
            'company' => $order['delivery_company'],
            'street_address' => $order['delivery_street_address'],
            'suburb' => $order['delivery_suburb'],
            'city' => $order['delivery_city'],
            'postcode' => $order['delivery_postcode'],
            'state' => $order['delivery_state'],
            'country' => $order['delivery_country'],
            'country_id' => $delivery_country_id['countries_id'],
            'iso_code_2' => $delivery_country_id['countries_iso_code_2'],
            'format_id' => $order['delivery_address_format_id'],
            'email_address'=> $order['delivery_email_address'],
            'telephone'=>$order['delivery_telephone'],
            'zone_id'=>0
        );

        // WE NEED THE COUNTRY ID
        $billing_country_id_query = xtc_db_query("SELECT countries_id,countries_iso_code_2 FROM countries WHERE countries_name='".xtc_db_input($order['billing_country'])."'");
        $billing_country_id = xtc_db_fetch_array($billing_country_id_query);
        $this->billing = array('name' => $order['billing_name'],
            'company' => $order['billing_company'],
            'street_address' => $order['billing_street_address'],
            'suburb' => $order['billing_suburb'],
            'city' => $order['billing_city'],
            'postcode' => $order['billing_postcode'],
            'state' => $order['billing_state'],
            'country' => $order['billing_country'],
            'country_id' => $billing_country_id['countries_id'],
            'iso_code_2' => $billing_country_id['countries_iso_code_2'],
            'format_id' => $order['billing_address_format_id']
        );

        $index = 0;
        if($order['is_parent'] == 'y') {
            $orders_products_query = xtc_db_query("select o.parent_orders_id,
                    p.orders_products_id,p.products_id, p.products_name, p.products_model, p.products_price, p.products_tax, p.products_quantity, p.final_price,p.allow_tax, p.products_discount_made,p.amazon_order_item_code,p.quantity_shipped,p.not_ship,p.marge,p.weight, p.volume 
                from
                    " . TABLE_ORDERS_PRODUCTS . " p, " .TABLE_ORDERS. " o
                where
                    o.parent_orders_id=".$order_id." && p.orders_id=o.orders_id ORDER BY date_added");
        }else{
            $orders_products_query = xtc_db_query("select
                orders_products_id,products_id, products_name, products_model, products_price, products_tax, products_quantity, final_price,allow_tax, products_discount_made,amazon_order_item_code,quantity_shipped,not_ship,marge ,weight, volume 
            from
                " . TABLE_ORDERS_PRODUCTS . "
            where
                orders_id ='" . xtc_db_input($order_id) . "' ORDER BY date_added");
        }

        $products_netto = 0;
        require_once(DIR_FS_CATALOG.'includes/classes/xtcPrice.php');
        $lang_id = (isset($_SESSION['languages_id']))?$_SESSION['languages_id']:2;
        $customers_status = main::get_customers_status($this->info['status'],$lang_id);

        $xtPrice = $this->get_price_instance();
        $own_weight = 0;
        $own_volume = 0;
        while ($orders_products = xtc_db_fetch_array($orders_products_query)) {
            $own_weight += floatval($orders_products['weight']);
            $own_volume += floatval($orders_products['volume']);
            $this->products[$index] = array('qty' => $orders_products['products_quantity'],
                'opID'=> $orders_products['orders_products_id'],
                'name' => $orders_products['products_name'],
                'id' => $orders_products['products_id'],
                'model' => $orders_products['products_model'],
                'tax' => $orders_products['products_tax'],
                'price' => $orders_products['products_price'],
                'discount' => $orders_products['products_discount_made'],
                'final_price' => $orders_products['final_price'],
                'allow_tax' => $orders_products['allow_tax'],
                'amazon_order_item_code'=>$orders_products['amazon_order_item_code'],
                'quantity_shipped'=>$orders_products['quantity_shipped'],
                'not_ship'=>$orders_products['not_ship'],
                'marge'=>$orders_products['marge'],
                'weight'=>floatval($orders_products['weight']),
                'volume'=>floatval($orders_products['volume']),
            );
            if($orders_products['quantity_shipped'] > 0 and $this->info['part_orders'] == 0 and ( !in_array($this->info['orders_status'], array(ORDERS_STATUS_ABGESCHLOSSEN,ORDERS_STATUS_VERSENDET,ORDERS_STATUS_STORNIERT) )) ){
                $this->info['part_orders'] = 1;
            }
            if($orders_products['not_ship'] > 0 and $this->info['not_ship_products'] == 0){
                $this->info['not_ship_products'] = 1;
            }

            if(intval($customers_status['customers_status_add_tax_ot']) == 1){
                $products_netto += $xtPrice->xtcRemoveTax($orders_products['final_price'], $orders_products['products_tax']);
            }
            $this->products[$index]['properties'] = $this->get_properties( $orders_products['orders_products_id']);
            $index++;
        }
        $this->info['products_netto'] = $products_netto;
        $this->info['own_weight'] = $own_weight;
        $this->info['own_volume'] = $own_volume;

        $this->setEbay_different_address($order['ebay_different_address']);
        $this->setEbay_no_registrationaddress($order['ebay_no_registrationaddress']);
        $this->setEbay_no_shippingaddress($order['ebay_no_shippingaddress']);

        if(defined('MODULE_OTHER_YES_HITMEISTER_API_STATUS') and MODULE_OTHER_YES_HITMEISTER_API_STATUS == 'True'){
            if(!yes_hitmeister::is_hitmeister_order($order_id)){
                 return true;
            }
            $this->hitmeister = self::get_hitmeister_data($order_id);
            $this->hitmeister_products = self::get_hitmeister_products_data($this->hitmeister['hitmeister_orders_id']);
        }
        return true;
    }

    function get_products_date_available(){
        $return_array = array();
        for($i=0;$i<sizeOf($this->products);$i++){
            $date = array();
            $date_query = yes_db_query(sprintf("SELECT products_date_available FROM products WHERE products_id='%s' and products_date_available>now()",$this->products[$i]['id']),true);
            if(yes_db_num_rows($date_query))
                $date = current($date_query);
            if(isset($date['products_date_available'])){
                $return_array[$this->products[$i]['id']] = $date['products_date_available'];
            }
        }
        return $return_array;
    }

    /**
     * Berechnet das Gewicht des Auftrags und schreibt dieses in weight
     * Wird der Parameter shippings_id uebergeben, dann werden nur die Artikel
     * berechnet, die in shippings_products zur entsprechenden shippings_id
     * enthalten sind
     * @param int $shippings_id
     */
    function calculate( $shippings_id = 0) {
        $this->total = 0;
        $this->weight = 0;
        if (!is_array($this->products)) {
            return 0;
        }
        reset($this->products);
        if(!function_exists('xtc_get_ext_products_weight')){
            require(DIR_FS_INC.'xtc_collis.inc.php');
        }

        if($shippings_id > 0){
            $shippings_products_query = xtc_db_query(sprintf(
                "SELECT products_id, quantity FROM shippings_products WHERE shippings_id='%s'",
                $shippings_id
            ));
            if(xtc_db_num_rows($shippings_products_query)){
                while($shippings_products = xtc_db_fetch_array($shippings_products_query)){
                    $weight = xtc_get_ext_products_weight($shippings_products['products_id']);
                    $this->weight += ($shippings_products['quantity'] * $weight);
                }
            }else{
                // php8 bugfix
                //while (list($id, ) = each($this->products)) {
                foreach($this->products as $id => $egal) {
                    $weight = xtc_get_ext_products_weight($this->products[$id]['id']);
                    $weight_qty = $this->products[$id]['qty']-$this->products[$id]['quantity_shipped']-$this->products[$id]['not_ship'];
                    $this->weight += ($weight_qty * $weight);
                }
            }
        }else{
            // php8 bugfix
            //while (list($id, ) = each($this->products)) {
            foreach($this->products as $id => $egal) {
                $weight = xtc_get_ext_products_weight($this->products[$id]['id']);
                $this->weight += ($this->products[$id]['qty'] * $weight);
            }
        }
    }

    function count_contents() {  // get total number of items in cart 
        $total_items = 0;
        if (is_array($this->products)) {
            reset($this->products);
            // php8 bugfix
            //while (list($id, ) = each($this->products)) {
            foreach($this->products as $id => $egal) {
                $total_items += $this->get_quantity($id);
            }
        }
        return $total_items;
    }

    /**
     * Ermittelt das Gewicht der Artikel des Auftrags
     * Wird der Parameter shippings_id uebergeben, dann wird das Gewicht
     * der Artikel ausgegeben, die in shippings_products zur entsprechenden
     * shippings_id enthalten sind
     * @param int $shippings_id
     * @return float
     */
    function show_weight($shippings_id = 0) {
        $this->calculate($shippings_id);
        return $this->weight;
    }

    function get_quantity($id) {
        if (isset($this->products[$id])) {
            return $this->products[$id]['qty'];
        }
        return 0;
    }
    
    function recalc(){
        // EU-OSS 2021/07
        // darf der MwSt Satz neu ermittelt werden auf EU OSS Basis?
        $allow_eu_tax_change = true; 
	if(strpos($this->info['source'], 'hitm') > -1){
            // BEI HITMEISTER ZB KRIEGEN WIR KEINEN MWST SATZ VON DER API
            // DAS HEISST DIE RECHNUNG MUSS SO BLEIBEN WIE WIR SIE IMPORTIERT
            // HABEN. STANDARDMAESSIG WIRD BEI HITMEISTER IMPORTEN MIT
            // tax_country = STORE_COUNTRY GEARBEITET, ALSO GERMANY
            $allow_eu_tax_change = false;
        }
        $cinfo = xtc_oe_customer_infos($this->customer['ID']);
        $lang_id = (isset($_SESSION['languages_id'])) ? $_SESSION['languages_id'] : 2;
        $status = main::get_customers_status($this->info['status'],$lang_id);

        // HABEN WIR SUBTOTAL-NOTAX?
        $ot_subtotal_no_tax_exists = false;
        // HABEN WIR SUBTOTAL ?
        $ot_subtotal_exists = false;
        for($oti=0;$oti<sizeOf($this->totals);$oti++){
            if($this->totals[$oti]['class'] == 'ot_subtotal_no_tax'){
                $ot_subtotal_no_tax_exists = true;
            }
            if($this->totals[$oti]['class'] == 'ot_subtotal'){
                $ot_subtotal_exists = true;
            }
        }

        // Errechne neue Zwischensumme fuer die Bestellung Anfang
        if($this->info['is_parent'] == 'n') {
            $products_query = xtc_db_query("select SUM(final_price) as subtotal_final from " . TABLE_ORDERS_PRODUCTS . " where orders_id = '" . $this->info['id'] . "' ");
            $products = xtc_db_fetch_array($products_query);
            $subtotal_final = $products['subtotal_final'];
        }else{
            $products_query = xtc_db_query("select SUM(op.final_price) as subtotal_final from " . TABLE_ORDERS_PRODUCTS . " op, ".TABLE_ORDERS." o where o.parent_orders_id = '" . $this->info['id'] . "' && op.orders_id=o.orders_id");
            while( $products = xtc_db_fetch_array($products_query) ) {
                $subtotal_final += $products['subtotal_final'];
            }
        }
        //********************* COMBINED PAYMENT CHANGE
	
        $xtPrice = $this->get_price_instance();
	
        $subtotal_text = $xtPrice->xtcFormat($subtotal_final,true);
        $update_sql_array = array(
            'text'=>$subtotal_text,
            'value'=>$subtotal_final
        );

        if(!$ot_subtotal_no_tax_exists){
            $ot_class = 'ot_subtotal';
        }else{
            $ot_class = 'ot_subtotal_no_tax';
        }
        xtc_db_perform(TABLE_ORDERS_TOTAL,$update_sql_array,"update","orders_id='" . $this->info['id'] . "' and class='".$ot_class."'");

        // COUPON ADDON 
        // ot_discount hinzugefuegt - 17.11.15
        $exclude_subtotal_classes = array('"ot_subtotal_no_tax"','"ot_tax"','"ot_subtotal"','"ot_coupon"','"ot_discount"');
        $subtotal_query = xtc_db_query("select SUM(value) as value from " . TABLE_ORDERS_TOTAL . " where orders_id = '" . $this->info['id'] . "' and class NOT IN( " . implode(',',$exclude_subtotal_classes) . ")");
        $subtotal = xtc_db_fetch_array($subtotal_query);

        $subtotal_final = $subtotal['value'];
        $subtotal_text = $xtPrice->xtcFormat($subtotal_final, true);
        xtc_db_query("update " . TABLE_ORDERS_TOTAL . " set text = '" . $subtotal_text . "', value = '" . $subtotal_final . "' where orders_id = '" . $this->info['id'] . "' and class = 'ot_total'");

        //********************* COMBINED PAYMENT CHANGE
        if($this->info['is_parent'] == 'n') {
            $products_query = xtc_db_query("select products_id,final_price, products_tax, allow_tax from " . TABLE_ORDERS_PRODUCTS . " where orders_id = '" . $this->info['id'] . "' ");
        }else{
            $products_query = xtc_db_query("select op.products_id,op.final_price, op.products_tax, op.allow_tax from " . TABLE_ORDERS_PRODUCTS . " op, ".TABLE_ORDERS." o where o.parent_orders_id = '" . $this->info['id'] . "' && o.orders_id=op.orders_id");
        }
        //********************* COMBINED PAYMENT CHANGE
	
        // EU-OSS 2021/07
        // BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
        /*if(yes_eu_oss_use_country_handling($this->delivery['country_id']) and $allow_eu_tax_change === true){
            $country_id = $xtPrice->getCountry_id();
            $zone_id = $xtPrice->getZone_id();
        }else{
            $country_id = STORE_COUNTRY;
            $zone_id = 0;
        }*/
        // EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
        
        // BUGF_CH_OSS
        $country_id = $xtPrice->getCountry_id();
        $zone_id = $xtPrice->getZone_id();
            
        while($products = xtc_db_fetch_array($products_query)){
            // EU-OSS 2021/07
            $products_tax_class_id = yes_eu_oss_get_products_tax_class_id($products['products_id'], $country_id);
            $tax_rate = $products['products_tax'];
            $multi = (($products['products_tax'] / 100) + 1);
            if ($products['allow_tax'] == '1') {
                $bprice = $products['final_price'];
                $nprice = $xtPrice->xtcRemoveTax($bprice, $tax_rate);
                $tax = $xtPrice->calcTax($nprice, $tax_rate);
            } else {
                $nprice = $products['final_price'];
                $bprice = $xtPrice->xtcAddTax($nprice, $tax_rate);
                $tax = $xtPrice->calcTax($nprice, $tax_rate);
            }

            // KEINE MWST BEI ENTSPRECHENDER KUNDENGRUPPENCONFIG
            if ($status['customers_status_add_tax_ot'] == 1) {
                $sql_data_array = array (
                    'orders_id' => $this->info['id'], 
                    'n_price' => $nprice, 
                    'b_price' => $bprice,
                    'tax' => $tax, 
                    'tax_rate' => $products['products_tax'],
                    'tax_class_id'=>$products_tax_class_id,
                );
                $insert_sql_data = array (
                    'class' => 'products'
                );
                $sql_data_array = xtc_array_merge($sql_data_array, $insert_sql_data);
                xtc_db_perform(TABLE_ORDERS_RECALCULATE, $sql_data_array);
            }
        }
	// Produkte Ende
	
        // Module Anfang
        if($allow_eu_tax_change === true){
            $module_tax_class = $this->get_shipping_tax_class();
        }else{
            // BEI HITMEISTER/KAUFLAND SOLL DIE EU OSS MWST BASIEREND AUF
            // VERSANDLAND DES AUFTRAGS KEINE ANWENDUNG FINDEN, DARUM GEBEN WIR
            // DIE COUNTRY_ID VOR DIE ANWENDUNG FINDEN SOLL, IN DIESEM FALL ALSO
            // STORE_COUNTRY WAS WEITER OBEN GESETZT WURDE ALS country_id
            $module_tax_class = $this->get_shipping_tax_class( $country_id );
        }
        $module_tax_rate = xtc_get_tax_rate($module_tax_class, $country_id, $zone_id);
        // COUPON ADDON
        // ot_discount hinzugefuegt - 17.11.15
        $exclude_total_classes_array = array('"ot_total"','"ot_subtotal_no_tax"','"ot_tax"','"ot_subtotal"','"ot_coupon"','"ot_discount"');
        $module_query = xtc_db_query("select value, class from " . TABLE_ORDERS_TOTAL . " where orders_id = '" . $this->info['id'] . "' and class NOT IN(".implode(',',$exclude_total_classes_array).")");
        while ($module_value = xtc_db_fetch_array($module_query)) {
            $module_name = str_replace('ot_', '', $module_value['class']);
            if ($module_name == 'shipping' and $allow_eu_tax_change === true) {
                $module_tmp_name = split('_', $this->info['shipping_class']);
                $module_tmp_name = $module_tmp_name[0];
                if ($module_tmp_name != 'selfpickup') {
                    // IMMER DIE NEUE
                    xtc_db_query(sprintf(
                        "UPDATE orders_total SET tax_rate_percent=%d WHERE orders_id=%d AND class='ot_shipping'",
                        $module_tax_rate,$this->info['id']
                    ));
                }
            }
			
            if ($status['customers_status_show_price_tax'] == 1) {
                $module_b_price = $module_value['value'];
                if ($module_tax_rate == 0) {
                    $module_n_price = $module_value['value'];
                } else {
                    $module_n_price = $xtPrice->xtcRemoveTax($module_b_price, $module_tax_rate);
                }
                $module_tax = $xtPrice->calcTax($module_n_price, $module_tax_rate);
            } else {
                $module_n_price = $module_value['value'];
                if($status['customers_status_add_tax_ot'] == 0){
                    $module_b_price = $xtPrice->xtcAddTax($module_n_price, $module_tax_rate);
                }else{
                    $module_b_price = $module_n_price;
                }
                $module_tax = $xtPrice->calcTax($module_n_price, $module_tax_rate);
            }
            // KEINE MWST BEI ENTSPRECHENDER KUNDENGRUPPENCONFIG
            if ($status['customers_status_add_tax_ot'] == 1) {
                $sql_data_array = array (
                    'orders_id' => $this->info['id'], 
                    'n_price' => $module_n_price,
                    'b_price' => $module_b_price,
                    'tax' => $module_tax,
                    'tax_rate' => $module_tax_rate,
                    'tax_class_id'=>$module_tax_class,
                );

                $insert_sql_data = array (
                    'class' => $module_value['class']
                );
                $sql_data_array = xtc_array_merge($sql_data_array, $insert_sql_data);
                xtc_db_perform(TABLE_ORDERS_RECALCULATE, $sql_data_array);
            }
	}
	// Module Ende  

        // Alte UST L�schen ANFANG
        xtc_db_query("delete from " . TABLE_ORDERS_TOTAL . " where orders_id = '" . $this->info['id'] . "' and class='ot_tax'");
        // Alte UST L�schen ENDE

        $tax_values = array(); // fuer discount handling
        // Neue Mwst. zusammenrechnen Anfang
        // am Ende muss "tax_value_new" die Summe des tax-Werts fuer eine tax_rate
        // herauskommen
        $ust_array = [];
        $ust_total_array = [];
        $ust_query = xtc_db_query("select tax_rate, tax, tax_class_id from " . TABLE_ORDERS_RECALCULATE . " where orders_id = '" . $this->info['id'] . "' and tax !='0'");
        while ($ust = xtc_db_fetch_array($ust_query)) {
            $ust_array[] = $ust;
            $key = $ust['tax_rate'];
            $key2 = $ust['tax_class_id'];
            if(!isset($ust_total_array[ $key ])){
                $ust_total_array[ $key ] = [];
            }
            if(!isset($ust_total_array[ $key ][$key2])){
                $ust_total_array[ $key ][$key2] = 0;
            }
            $ust_total_array[ $key ][$key2] += $ust['tax'];
        }
        foreach($ust_total_array as $tax_rate=>$tax_class_data){
            foreach($tax_class_data as $tax_class_id=>$new_tax_value){
                $title = xtc_get_tax_description($tax_class_id, $country_id);
                if(empty($title)){
                    $title = sprintf('Enth. MwSt. %s%%',number_format($tax_rate,2,',',''));
                }
                if($new_tax_value === 0){
                    continue;
                }
                $text = $xtPrice->xtcFormat($new_tax_value, true);
                $tax_values[ ''.number_format($tax_rate,0,'','') ] = array(
                    'value'=>$new_tax_value,
                    'tax_class_id'=>$tax_rate
                );
                $sql_data_array = array (
                    'orders_id' => $this->info['id'], 
                    'title' => xtc_db_prepare_input($title), 
                    'text' => xtc_db_prepare_input($text), 
                    'value' => $new_tax_value, 
                    'class' => 'ot_tax',
                    'tax_rate_percent'=>$tax_rate
                );
                $insert_sql_data = array (
                    'sort_order' => MODULE_ORDER_TOTAL_TAX_SORT_ORDER
                );
                $sql_data_array = xtc_array_merge($sql_data_array, $insert_sql_data);
                xtc_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);
            }

        }

        // ot_discount ausklammern - 17.11.15
        if ($status['customers_status_show_price_tax'] == 0){
            $exclude_subtotal_class = 'ot_subtotal';
            // SPEZIALFALL
            if($status['customers_status_add_tax_ot'] == 0){
                $exclude_subtotal_class = 'ot_subtotal_no_tax';
            }
            $total_query = xtc_db_query(sprintf(
                "SELECT SUM(value) as totalsum FROM orders_total WHERE orders_id='%s' and class != 'ot_total' and class != '%s' and class != 'ot_coupon' and class != 'ot_discount'",
                $this->info['id'],
                $exclude_subtotal_class
            ));
        }else{
            $total_query = xtc_db_query("SELECT SUM(value) as totalsum FROM orders_total WHERE orders_id='".$this->info['id']."' and class != 'ot_total' and class != 'ot_tax' and class != 'ot_coupon' and class != 'ot_discount'");
        }
        $total = xtc_db_fetch_array($total_query);


        // ot_coupon
        $coupon_query = xtc_db_query("SELECT SUM(value) as totalsum FROM orders_total WHERE orders_id='".$this->info['id']."' and class = 'ot_coupon'");
        $coupon = xtc_db_fetch_array($coupon_query);
        $coupon_value = (float)$coupon['totalsum'];
        if($coupon_value <> 0){
            $total['totalsum'] = $total['totalsum'] - $coupon_value;
        }

        // ot_discount
        $discount_query = xtc_db_query("SELECT SUM(value) as totalsum FROM orders_total WHERE orders_id='".$this->info['id']."' and class = 'ot_discount'");
        $discount = xtc_db_fetch_array($discount_query);
        $discount_value = (float)$discount['totalsum'];
        if($discount_value != 0){
            // RABATT VORHANDEN
            $total['totalsum'] += $discount_value;
            $nebenleistung_value = $discount_value;
            $discount_tr = $this->get_tax_rates_for_nebenleistung($nebenleistung_value);
            foreach($discount_tr as $tax_data){
                $tax = ''.xtc_get_tax_rate($tax_data['tax_class_id'],$country_id, $zone_id);
                $tax_values[ $tax ]['value'] = $tax_values[$tax]['value'] + $tax_data['amount'];
            }
            foreach($tax_values as $tax_rate=>$tax_data){
                $update_sql_array = array(
                    'text'=>$xtPrice->xtcFormat($tax_data['value'], true),
                    'value'=>$tax_data['value']
                );
                xtc_db_perform(TABLE_ORDERS_TOTAL,$update_sql_array,'update',"class='ot_tax' AND tax_rate_percent='".$tax_rate."' AND orders_id='".$this->info['id']."'");
            }
        }
        $text = $xtPrice->xtcFormat($total['totalsum'], true);

        $sql_data_array = array (
            'text' => xtc_db_prepare_input($text), 
            'value' => xtc_db_prepare_input($total['totalsum']), 
        );
        xtc_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array,'update',"orders_id='".$this->info['id']."' and class='ot_total'");

        // Loeschen des Zwischenspeichers Anfang
        xtc_db_query("delete from " . TABLE_ORDERS_RECALCULATE . " where orders_id = '" . $this->info['id'] . "'");
        // Loeschen des Zwischenspeichers Ende
        $this->save_real_shipping_cost();
    }
	
    function is_kasse(){
        $kasse_query = xtc_db_query("SELECT id FROM kasse WHERE orders_id='".$this->info['id']."'");
        if(xtc_db_num_rows($kasse_query)>0){
            return true;
        }
        return false;
    }
	
	function get_kasse_data(){
		$kasse_query = xtc_db_query("SELECT * FROM kasse WHERE orders_id='".$this->info['id']."'");
		$kasse = xtc_db_fetch_array($kasse_query);
		$data_array = array('id'=>$kasse['id'],
			'paymode'=>$kasse['paymode'],
			'date_purchased'=>$kasse['date_purchased'],
			'quantity_purchased'=>$kasse['quantity_purchased'],
			'tax_rate'=>$kasse['tax_rate'],
			'total'=>$kasse['total'],
			'send'=>$kasse['send'],
			'branches_id'=>$kasse['branches_id']
		);
		return $data_array;
	}
	
	function get_status_name($status){
            return main::get_orders_status_name($status, $this->language_id);
	}
	
	// KOMBINIERTE ERMITTELN
	function get_combined_orders(){
  		$child_orders = array();
		$query = xtc_db_query("SELECT orders_id FROM ".TABLE_ORDERS." WHERE combined_orders_id = '".$this->info['id']."'");
	  	while($res = xtc_db_fetch_array($query)) {
  			$link = xtc_href_link(FILENAME_ORDERS,'oID='.$res['orders_id'].'&action=edit');
			$child_orders[] = array('orders_id'=>$res['orders_id'],'link'=>$link);
	  	}
	  	return $child_orders;
	}

	// ALTES KOMBINIEREN HANDLING
	function get_child_orders(){
  		$child_orders = array();
		$query = xtc_db_query("SELECT orders_id FROM ".TABLE_ORDERS." WHERE parent_orders_id = '".$this->info['id']."'");
	  	while($res = xtc_db_fetch_array($query)) {
			// yes accounting
			if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_orders_view'] == '1')) {
	  			$link = xtc_href_link(FILENAME_ORDERS,'oID='.$res['orders_id'].'&action=edit');
	  		}
			$child_orders[] = array('orders_id'=>$res['orders_id'],'link'=>$link);
	  	}
	  	return $child_orders;
	}
	
	function add_history($status_id,$notified,$comments){
		$insert_sql_array = array(
			'orders_id'=>$this->info['id'],
			'orders_status_id'=>$status_id,
			'date_added'=>'now()',
			'customer_notified'=>($notified)?1:0,
			'comments'=>$comments,
			'editor_id'=>$this->editor_id
		);
		xtc_db_perform('orders_status_history',$insert_sql_array);
	}
        
	public static function add_history_static(int $orders_id, int $status_id,bool $notified,string $comments){
		$insert_sql_array = array(
			'orders_id'=>$orders_id,
			'orders_status_id'=>$status_id,
			'date_added'=>date('Y-m-d H:i:s'),
			'customer_notified'=>($notified)?1:0,
			'comments'=>$comments,
			'editor_id'=>intval($_SESSION['customer_id']??0)
		);
		xtc_db_perform('orders_status_history',$insert_sql_array);
	}
	
	
	function insert_product($pID,$model,$name,$price,$discount,$final_price,$tax,$qty,$allow_tax){
		$insert_sql_array = array(
		  'orders_id'=>$this->info['id'],
		  'products_id'=>$pID,
		  'products_model'=>$model,
		  'products_name'=>$name,
		  'products_price'=>$price,
		  'products_discount_made'=>$discount,
		  'final_price'=>$final_price,
		  'products_tax'=>$tax,
		  'products_quantity'=>$qty,
		  'allow_tax'=>$allow_tax,
		  'date_added'=>'now()'
		);
		xtc_db_perform('orders_products',$insert_sql_array);
		return xtc_db_insert_id();
	}
	
	function update_shippingcosts($otID,$value,$title){
		$xtPrice = $this->get_price_instance();

	        $text = $xtPrice->xtcFormat($value,1);
		$update_sql_array = array( 
			'title'=>$title,
			'text'=>$text,
			'value'=>$value
		);
		xtc_db_perform(TABLE_ORDERS_TOTAL,$update_sql_array,'update',"orders_total_id='".$otID."' and orders_id='".$this->info['id']."'");
		$comments = 'Versandkosten wurden von '.$original_total.' zu '.$formated_value.' geaendert.';
		$this->add_history($this->info['orders_status'],$notified=0,$comments);
	}
	
	function delete_orders_total_entry($otID){
		xtc_db_query("delete from " . TABLE_ORDERS_TOTAL . " where orders_total_id = '" . $otID . "' and orders_id='".$this->info['id']."'");
	}

	function update_orders_status($status_id){
		$update_sql_array = array(
			'orders_status'=>$status_id,
			'last_modified'=>'now()'
		);
		xtc_db_perform('orders',$update_sql_array,'update','orders_id='.$this->info['id']);
	}

	function remove_tax(){
            global $shipping_modules;
            $xtPrice = $this->get_price_instance();
            $_class = current(split('_',$this->info['shipping_class']));
            $_class = $_class.'.php';
            for($i=0;$i<sizeOf($shipping_modules->modules);$i++){
                if($shipping_modules->modules[$i] == $_class){
                   $shipping_method = $_class;
                }
            }
            if(!$shipping_method){
                $shipping_method = $shipping_modules->modules[0];
            }
            $tax_class_id = $this->get_shipping_tax_class();
                
            // EU-OSS 2021/07
            // BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
            /*if(yes_eu_oss_use_country_handling($this->delivery['country_id'])){
                $country_id = $this->delivery['country_id'];
                $zone_id = $this->delivery['zone_id'];
            }else{
                $country_id = STORE_COUNTRY;
                $zone_id = 0;
            }*/
            // EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
            
            // BUGF_CH_OSS
            $country_id = $this->delivery['country_id'];
            $zone_id = $this->delivery['zone_id'];
            
            $shipping_class_tax_value = xtc_get_tax_rate($tax_class_id, $country_id, $zone_id);

		if(sizeOf($this->products)>0){
			$subtotal_no_tax = 0;
			// DURCHLAUFE PRODUKTE UND ERMITTELE DIE NETTO-ZWISCHENSUMME
			foreach($this->products as $k=>$product){
				$orig_price = $product['price'];
				$orig_final_price = $product['final_price'];
				$orig_tax = $product['tax'];
				if($orig_tax>0){
					$netto_price = xtc_oe_get_price_o_tax($orig_price,$orig_tax,0);
					$netto_final_price = xtc_oe_get_price_o_tax($orig_final_price,$orig_tax,0);

					$subtotal_no_tax += $netto_final_price;
					
					$sql_array = array('products_tax'=>0,
						'products_price'=>$netto_price,
						'allow_tax'=>0,
						'products_tax'=>0,
						'final_price'=>$netto_final_price
					);
					xtc_db_perform('orders_products',$sql_array,'update','orders_id=\''.$this->info['id'].'\' and products_id=\''.$product['id'].'\'');
				}
			}
			// WENN EINE NETTOZWISCHENSUMME ERMITTELT WURDE, DB UPDATE
			if($subtotal_no_tax > 0){
				// NACHSEHEN OB BEREITS EINE ot_subtotal_no_tax CLASS IN
				// ORDERS_TOTAL GESPEICHERT IST, WENN JA DANN SUMME UPDATEN
				foreach($this->totals as $k=>$v){
					if($v['class'] == 'ot_subtotal_no_tax'){
						$ot_subtotal_no_tax = true;
						$text=$xtPrice->xtcFormat($subtotal_no_tax,true);
						$update_sql_array = array(
							'value'=>$subtotal_no_tax,
							'text'=>$text
						);
						xtc_db_perform('orders_total',$update_sql_array,'update',"orders_id='".$this->info['id']."' and class='ot_subtotal_no_tax'");
					}
				}
				// ES IST NOCH KEINE ot_subtotal_no_tax CLASS IN ORDERS_TOTAL
				// ALSO EINE NEUE ANLEGEN
				if(!$ot_subtotal_no_tax){
					$text=$xtPrice->xtcFormat($subtotal_no_tax,true);
					$insert_sql_array = array(
						'title'=>MODULE_ORDER_TOTAL_SUBTOTAL_NO_TAX_TITLE,
						'class'=>'ot_subtotal_no_tax',
						'orders_id'=>$this->info['id'],
						'sort_order'=>MODULE_ORDER_TOTAL_SUBTOTAL_NO_TAX_SORT_ORDER,
						'value'=>$subtotal_no_tax,
						'text'=>$text
					);
					xtc_db_perform('orders_total',$insert_sql_array);
				}
				xtc_db_query("DELETE FROM orders_total WHERE orders_id='".$this->info['id']."' and class='ot_subtotal'");
			} // ENDE NEUE ZWISCHENSUMME SPEICHERN
		} // ENDE IF PRODUCTS

		// TOTALS DURCHLAUFEN UND NACH SHIPPINGCOSTS SUCHEN
		foreach($this->totals as $k=>$v){
			if($v['class'] == 'ot_shipping'){
				$netto_shippingcosts = xtc_oe_get_price_o_tax($v['value'], $shipping_class_tax_value, 0);
				$text=$xtPrice->xtcFormat($netto_shippingcosts,true);
				$update_sql_array = array(
					'value'=>$netto_shippingcosts,
					'text'=>$text
				);
				xtc_db_perform('orders_total',$update_sql_array,'update',"orders_id='".$this->info['id']."' and class='ot_shipping'");
			}
		}
		xtc_db_query("DELETE FROM orders_total WHERE orders_id='".$this->info['id']."' and class='ot_tax'");
		$this->order($this->info['id']);
		$this->recalc();
	}

	/**
	 * Ueberarbeitete Version von is_netto
	 * prueft sowohl den tax wert als auch die allow_tax einstellung
	 *
	 * @return bool
	 */
	function is_netto2(){
            if(sizeOf($this->products)>0){
                if($this->products[0]['tax']>0 and $this->products[0]['allow_tax'] == 1){
                        return false;
                }
            }else{
                $lang_id = (isset($_SESSION['languages_id'])) ? $_SESSION['languages_id'] : 2;
                $customers_status_value = main::get_customers_status($this->info['status'], $lang_id);
                if($customers_status_value['customers_status_add_tax_ot'] > 0){
                        return false;
                }
            }
            return true;
	}

	function is_netto(){
		if(sizeOf($this->products)>0){
			if($this->products[0]['tax']>0)
				return false;
		}else{
            $customers_status = \YES4Trade\Model\customers_status::get_by_customers_status_id(intval($this->info['status']),[
                'customers_status_add_tax_ot'
            ]);
    		if($customers_status !== null and intval($customers_status->customers_status_add_tax_ot) > 0){
				return false;
			}
		}
		return true;
	}

	function insert_shippingcosts($inp_price,$title,$file='yes.php'){
		$xtPrice = $this->get_price_instance();
		$shipping_tax_class = $this->get_shipping_tax_class();
                
                // EU-OSS 2021/07
                // BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
                /*if(yes_eu_oss_use_country_handling($this->delivery['country_id'])){
                    $shipping_tax_rate = xtc_get_tax_rate($shipping_tax_class, $this->delivery['country_id'], $this->delivery['zone_id']);
                }else{
                    $shipping_tax_rate = xtc_get_tax_rate($shipping_tax_class);
                }*/
                // EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
                
                // BUGF_CH_OSS
                $shipping_tax_rate = xtc_get_tax_rate($shipping_tax_class, $this->delivery['country_id'], $this->delivery['zone_id']);
                
	        $text = $xtPrice->xtcFormat(floatval($inp_price),1);
	        $sort = MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER;
	 
	        $insert_sql_array = array('orders_id' => $this->info['id'],
			'title' => $title,
			'text' => xtc_db_prepare_input($text),
			'value' => xtc_db_prepare_input($inp_price),
			'class' => 'ot_shipping',
			'sort_order' => $sort,
				'tax_rate_percent'=>$shipping_tax_rate
		);
                xtc_db_perform(TABLE_ORDERS_TOTAL, $insert_sql_array);
		$module = current(split('\.php',$file));
		require (DIR_FS_LANGUAGES . $_SESSION['language'] . '/modules/shipping/' . $file);
                if(defined('MODULE_SHIPPING_'. strtoupper($module) . '_TEXT_TITLE')){
                    $shipping_text = constant('MODULE_SHIPPING_' . strtoupper($module) . '_TEXT_TITLE');
                }else{
                    $shipping_text = $_POST['title'];
                }
		$shipping_class = $module . '_' . $module;

		$sql_data_array = array (
			'shipping_method' => xtc_db_prepare_input($shipping_text
		), 'shipping_class' => xtc_db_prepare_input($shipping_class),);
		xtc_db_perform(TABLE_ORDERS, $sql_data_array, 'update', 'orders_id = \'' . $this->info['id'] . '\'');

		$comments = 'Versandkosten wurden mit '.$text.' hinzugefuegt.';
		$this->add_history($this->info['orders_status'],$notified=0,$comments);
	}

    function get_skonto(){
        $skonto_array = array();
        $order_skonto_array = array();
        $customers_status = \YES4Trade\Model\customers_status::get_by_customers_status_id(intval($this->info['status']),[
            'customers_status_skonto'
        ]);
        if($customers_status !== null and $customers_status->customers_status_skonto != ''){
            $skonto_values = explode(';',$customers_status->customers_status_skonto);
            for($i=0;$i<sizeOf($skonto_values);$i++){
                $skonto = explode(':',$skonto_values[$i]);
                if((float)$skonto[1]>0 and (int)$skonto[0]>0){
                    $skonto_array[] = array(
                        'days'=>(int)$skonto[0],
                        'percent' => (float)$skonto[1]
                    );
                }
            }
        }
        if(sizeOf($skonto_array)>0){
            $xtPrice = $this->get_price_instance();
            foreach($skonto_array as $skonto){
                $order_skonto_array[] = array(
                    'title'=>sprintf(TEXT_ORDER_SKONTO,number_format($skonto['days'],0),number_format($skonto['percent'],2,',','.')),
                    'text'=>$xtPrice->xtcFormat($this->get_skonto_amount($skonto['percent']),1)
                );
            }
        }
        return $order_skonto_array;
    }

	public function get_skonto_amount($percent){
		for($i=0;$i<sizeOf($this->totals);$i++){
			if($this->totals[$i]['class'] == 'ot_total'){
				return $this->totals[$i]['value'] - (($this->totals[$i]['value'] / 100)*$percent);
			}
		}
	}

	public function get_fibunumber($check_all = false){
		if(!defined('MODULE_OTHER_FIBUNUMBERS_STATUS') or MODULE_OTHER_FIBUNUMBERS_STATUS != 'True'){
			return 0;
		}
		if($check_all){
			// ERST NORMAL
			$query = xtc_db_query(sprintf(
				"SELECT fibunumber FROM orders_fibunumbers WHERE orders_id='%s'",
					$this->info['id']
			));
			if(xtc_db_num_rows($query)){
				$record = xtc_db_fetch_array($query);
				return $record['fibunumber'];
			}
			// DANN KASSE
			$kasse_data = $this->get_kasse_data();
			$branches_id = $kasse_data['branches_id'];

			// BUGFIX - WENN KEINE FILIALE
			$branches_num_query = xtc_db_query("SELECT branches_id FROM branches");
			$branches_num = xtc_db_num_rows($branches_num_query);

			$branches_stammlager_query = xtc_db_query("SELECT stammlager FROM branches WHERE branches_id='".$branches_id."'");
			$branches_stammlager = xtc_db_fetch_array($branches_stammlager_query);
			if($branches_stammlager['stammlager'] == 0 and $branches_num){
				$query = xtc_db_query(sprintf(
					"SELECT fibunumber FROM branches_orders_fibunumbers WHERE orders_id='%s'",
					$this->info['id']
				));
			}else{
				$query = xtc_db_query(sprintf(
					"SELECT fibunumber FROM orders_fibunumbers WHERE orders_id='%s'",
						$this->info['id']
				));
			}
			if(xtc_db_num_rows($query)){
				$record = xtc_db_fetch_array($query);
				return $record['fibunumber'];
			}
		}else{
			if($this->is_kasse()){
				$kasse_data = $this->get_kasse_data();
				$branches_id = $kasse_data['branches_id'];

				// BUGFIX - WENN KEINE FILIALE
				$branches_num_query = xtc_db_query("SELECT branches_id FROM branches");
				$branches_num = xtc_db_num_rows($branches_num_query);

				$branches_stammlager_query = xtc_db_query("SELECT stammlager FROM branches WHERE branches_id='".$branches_id."'");
				$branches_stammlager = xtc_db_fetch_array($branches_stammlager_query);
				if($branches_stammlager['stammlager'] == 0 and $branches_num){
					$query = xtc_db_query(sprintf(
						"SELECT fibunumber FROM branches_orders_fibunumbers WHERE orders_id='%s'",
						$this->info['id']
					));
				}else{
					$query = xtc_db_query(sprintf(
						"SELECT fibunumber FROM orders_fibunumbers WHERE orders_id='%s'",
							$this->info['id']
					));
				}
				if(xtc_db_num_rows($query)){
					$record = xtc_db_fetch_array($query);
					return $record['fibunumber'];
				}
			}else{
				$query = xtc_db_query(sprintf(
					"SELECT fibunumber FROM orders_fibunumbers WHERE orders_id='%s'",
						$this->info['id']
				));
				if(xtc_db_num_rows($query)){
					$record = xtc_db_fetch_array($query);
					return $record['fibunumber'];
				}
			}
		}
		return 0;
	}

	public function _parse_branch_fibunumber($counter,$prefix,$length){
			$target_string = ''.$counter;
			$counter_length = strlen(''.$counter);
			if($counter_length < $length){
				$target_nulls = $length-$counter_length;
				for($i=0;$i<$target_nulls;$i++){
					$target_string = '0'.$target_string;
				}
			}
			return $prefix.$target_string;
	}
	public function add_fibunumber(){
		if($this->is_kasse()){
			$kasse_data = $this->get_kasse_data();
			$branches_id = $kasse_data['branches_id'];

			$branches_num_query = xtc_db_query("SELECT branches_id FROM branches");
			$branches_num = xtc_db_num_rows($branches_num_query);

			if($branches_num){ // BUGFIX - WENN KEINE FILIALE
				$branches_fibu_query = xtc_db_query(sprintf(
					"SELECT fibunumber_prefix,fibunumber_length,fibunumber_start,stammlager FROM
					   branches WHERE branches_id='%s'",
					$branches_id
				));
				$branches_fibu = xtc_db_fetch_array($branches_fibu_query);
				if($branches_fibu['stammlager'] == 0){
					$query = xtc_db_query(sprintf(
						"SELECT MAX(fibunumber_branches_counter) as lastid FROM branches_orders_fibunumbers WHERE branches_id='%s'",
						$branches_id
					));
					$record = xtc_db_fetch_array($query);
					if($record['lastid']>0){
						$number = $record['lastid'] + 1;
					}else{
						$number = (int)$branches_fibu['fibunumber_start'];
						if($number == 0) $number = 1; // BUGFIX
					}
					$fibunumber = $this->_parse_branch_fibunumber($number,$branches_fibu['fibunumber_prefix'],$branches_fibu['fibunumber_length']);
					$insert_sql_array = array(
						'orders_id'=>$this->info['id'],
						'fibunumber'=>$fibunumber,
						'branches_id'=>$branches_id,
						'fibunumber_branches_counter'=>$number,
						'date_added'=>'now()'
					);
					xtc_db_perform('branches_orders_fibunumbers',$insert_sql_array);
					return $fibunumber;
				}
			}
		}

		$query = xtc_db_query("SELECT MAX(fibunumber) as lastid FROM orders_fibunumbers");
		$record = xtc_db_fetch_array($query);
		if($record['lastid']>0){
			$number = $record['lastid'] + 1;
		}else{
			$number = MODULE_OTHER_FIBUNUMBERS_START;
		}
		$insert_sql_array = array(
			'orders_id'=>$this->info['id'],
			'fibunumber'=>$number,
			'date_added'=>'now()'
		);
		xtc_db_perform('orders_fibunumbers',$insert_sql_array);
		return $number;
	}

	/**
	 * UEBERPRUEFT OB DER AUFTRAG MIT DEM UEBERGEBENEM STATUS EINE FIBUNUMMER
	 * ERHALTEN DARF
	 * 
	 * @param int $status
	 * @return bool
	 */
	public static function check_add_fibunumber_by_status($status){
		switch($status){
			/* KOMPLETT RAUS - TICKET 2096
			case ORDERS_STATUS_BEZAHLT:
			 */
			case ORDERS_STATUS_ABGESCHLOSSEN:
			case ORDERS_STATUS_VERSENDET:
				return true;
				break;
		}
		return false;
	}

  /**
   * Ermittelt den Nettobetrag zu einem Eintrag des $this->products Arrays
   * Achtung - nicht die original Datenbank Array Keys (aus einem SQL Query)
   * uebergeben, sondern immer einen Eintrag des $this->products Arrays
   *
   * @global object $xtPrice
   * @param array $orders_product
   * @return float Netto-Price
   */
  function get_products_price_netto($orders_product){
		global $xtPrice;
	    if(!is_array($orders_product) or !is_object($xtPrice)) return 0;
	    if(!isSet($orders_product) or !isSet($xtPrice)) return 0;
		$products_price_netto = $orders_product['final_price'];
		if(!$this->is_netto2()){ // is_netto2() ist ueberarbeitet
			if($orders_product['tax']>0 and $orders_product['allow_tax'] == 1){
				$products_price_netto = $xtPrice->xtcRemoveTax($orders_product['final_price'], $orders_product['tax']);
			}else{
				$products_price_netto = $orders_product['final_price'];
			}
		}
		return (float)$products_price_netto;
  }

    /**
     * Alle Rechnungspositionen zurueckgeben
     * 
     * Gibt ein Array aller Rechnungspositionen zurueck. Wird eine shippings_id
     * uebergeben, werden nur die Artikelpositionen zurueckgegeben die mit dieser
     * id abgewickelt wurden (teillieferung)
     * 
     * @global object $xtPrice
     * @param object|null $xtPriceInstance
     * @param int $shippings_id
     * @return array
     */
    function get_order_positions($xtPriceInstance = null, $shippings_id = null){
        $sess_lang_id = (isset($_SESSION['languages_id']))?$_SESSION['languages_id']:2;
        if($xtPriceInstance !== null){
            $xtPrice = $xtPriceInstance;
        }else{
            global $xtPrice;
            if(gettype($xtPrice) != 'object'){
                $xtPrice = $this->get_price_instance();
            }
        }
        $positions = new order_positions;
        $positions->setCommission_number($this->info['commission_number']??'');
        $positions->setOwn_volume(floatval($this->info['own_volume']??0));
        $positions->setOwn_weight(floatval($this->info['own_weight']??0));

        if(intval($this->info['distribution_warehouse_storage_id']) > 0){
            $storage_info = yes_get_storage_info(intval($this->info['distribution_warehouse_storage_id']));
            $positions->setDistribution_warehouse($storage_info['name']);
        }
        
        // ALS ERSTES DIE PRODUKTE ALS POSITIONEN ADDEN
        $total_weight = 0;
        $total_weight_netto = 0;
        
        $shippings_products = ($shippings_id > 0) ? yes_get_shippings_products($shippings_id) : [];
        
    $own_weight_total = 0;
    $own_volume_total = 0;
	for($i=0;$i<sizeOf($this->products);$i++){
        if(sizeOf($shippings_products)){
            $product_to_send = 0;
            foreach($shippings_products as $shp){
                if($shp['source_products_id'] == $this->products[$i]['opID']){
                    $pqty = $shp['quantity'];
                    // BUGFIX - IM VERSANDABSCHLUSS DIESEN WERT VERWENDEN
                    $product_to_send = $pqty;
                }
            }
        }else{
            $product_to_send = $this->products[$i]['qty'];
        }
        if($product_to_send < 1){
            continue;
        }
            
	    $product_detail_query = xtc_db_query(sprintf(
            "SELECT manufacturers_id,products_ean,products_image,size_width, size_depth,size_height FROM products WHERE products_id='%s'",
            $this->products[$i]['id']
	    ));
	    $product_detail = xtc_db_fetch_array($product_detail_query);
	    
        $total_netto = $this->get_products_price_netto( $this->products[$i] );
        $total = $this->products[$i]['final_price'];
        $pos = new order_position;
        $pos->setClass('product');            
        $pos->setQuantity($product_to_send); 
        if(intval($product_detail['manufacturers_id']) > 0){
            $manufacturer_info = \YES4Trade\Model\manufacturer::get_by_manufacturers_id(intval($product_detail['manufacturers_id']),['manufacturer_country']);
            if($manufacturer_info !== null and !empty($manufacturer_info->manufacturer_country)){
                $pos->setCountry_of_origin($manufacturer_info->manufacturer_country);
            }
        }
        $pos->setTotal_price($this->products[$i]['final_price']);
        $pos->setTotal_price_netto($total_netto);
        $pos->setSingle_price($this->products[$i]['price']);
        $pos->setSingle_price_netto( (($this->products[$i]['qty'] != 0) ? $total_netto/$this->products[$i]['qty'] : 0) );
        $pos->setProducts_model($this->products[$i]['model']);
        $pos->setTitle($this->products[$i]['name']);
        if($this->is_netto2()){
            $pos->setText1( $xtPrice->xtcFormat( $pos->getSingle_price_netto(),true) );
            $pos->setText2( $xtPrice->xtcFormat( $pos->getTotal_price_netto(),true) );
        }else{
            $pos->setText1( $xtPrice->xtcFormat( $pos->getSingle_price(),true) );
            $pos->setText2( $xtPrice->xtcFormat( $pos->getTotal_price(),true) );
        }
        $weight = xtc_get_ext_products_weight($this->products[$i]['id']);
        $weight_netto = xtc_get_ext_products_weight_netto($this->products[$i]['id']);
        $pos->setWeight($weight);
        $pos->setWeight_netto($weight_netto);
        $pos->setImage($product_detail['products_image']);

            $collies = xtc_get_product_collies($this->products[$i]['id']);
            for($ci=0;$ci<sizeOf($collies);$ci++){
                $collie_desc_query = xtc_db_query(sprintf(
                    "SELECT pd.slave_title,pd.products_name,p.products_model FROM products p LEFT JOIN products_description pd USING(products_id) WHERE p.products_id='%s' AND language_id='%s'",
                    $collies[$ci]['collie_products_id'],
                    $_SESSION['languages_id']
                ));
                $collie_desc = xtc_db_fetch_array($collie_desc_query);
                $collies[ $ci ]['SLAVE_TITLE'] = $collie_desc['slave_title'];
                $collies[ $ci ]['TITLE'] = $collie_desc['products_name'];
                $collies[ $ci ]['PRODUCTS_WEIGHT'] = xtc_get_ext_products_weight($collies[$ci]['collie_products_id']);
                $collies[ $ci ]['PRODUCTS_WEIGHT_NETTO'] = xtc_get_ext_products_weight_netto($collies[$ci]['collie_products_id']);
                $collies[ $ci ]['PRODUCTS_MODEL'] = $collie_desc['products_model'];
            }
            $pos->setCharacteristics($this->get_characteristics_for_product($this->products[$i]['id'],$collies));
            $pos->setAllow_tax( $this->products[$i]['allow_tax'] );
            if($pos->getAllow_tax() == 1){
                $pos->setTax_rate( number_format($this->products[$i]['tax'],2,'.',''));
            }
            
            $properties = $this->get_properties($this->products[$i]['opID']);
            $pos->setProperties($properties);
            
            $pos->setProducts_ean($product_detail['products_ean']);
            $pos->setCollis($collies);
            $pos->setStorages($this->get_product_storages($this->products[$i]['id'], $collies));
            $pos->setStorages_array($this->get_product_storages($this->products[$i]['id'], $collies,false));
            $pos->setProducts_short_description(xtc_get_short_description($this->products[$i]['id'], $sess_lang_id));
            $pos->setSlave_title(xtc_get_products_slave_title($this->products[$i]['id'], $sess_lang_id));
//            $pos->setPersons($this->products[$i]['persons']);
            $pos->setProducts_id($this->products[$i]['id']);
            
            $pos->setWidth(floatval($product_detail['size_width']));
            $pos->setDepth(floatval($product_detail['size_depth']));
            $pos->setHeight(floatval($product_detail['size_height']));
            $pos->setOwn_volume($this->products[$i]['volume']);
            $pos->setOwn_weight($this->products[$i]['weight']);
            $own_volume_total += ($this->products[$i]['volume'] * $this->products[$i]['qty']);
            $own_weight_total += ($this->products[$i]['weight']*$this->products[$i]['qty']);
            $pos->setOrders_products_id($this->products[$i]['opID']);
            $puc = \YES4Trade\Model\product_un_classification::get_by_products_id($this->products[$i]['id']);
            if($puc !== null){
                $un = \YES4Trade\Model\un_classifications::get_by_un_classifications_id($puc->un_classifications_id);
                $pos->setUn_classification_title($un->un_title);
                $pos->setUn_classification_description($un->un_description);
                $pos->setUn_classification_full_string( $puc->get_un_classification_title() );
                $pos->setUn_classification_values($puc->get_un_classification_values());

                $bk = \YES4Trade\Enums\Bk::fromName($puc->Bk);
                $bk_value = intval($bk->value);
                if($bk_value == 4){
                    // nix
                }else{
                    $faktor = $bk->multiplikator();
                    $weight = (floatval($own_weight_total)>0)?floatval($own_weight_total):floatval($weight * $pos->getQuantity());
                    $score = ($faktor*$weight);
                    $pos->setUn_score_values([
                        'WEIGHT'=>$weight,
                        'Bk'=>$bk_value,
                        'FAKTOR'=>$faktor,
                        'SCORE'=>$score,
                    ]);
                }
            }
            
            $pos->setPosition($i+1);
            $positions->addPosition( $pos );
            $total_weight += $weight * $pos->getQuantity();
            $total_weight_netto += $weight_netto * $pos->getQuantity();
	}
	$positions->setWeight($total_weight);
    $positions->setWeight_netto($total_weight_netto);
    $positions->setOwn_volume($own_volume_total);
    $positions->setOwn_weight($own_weight_total);

    // pallets
    $pallets = [];
    $pallets_array = \YES4Trade\Model\orders_pallets::get_by_orders_id($this->info['id']);
    foreach($pallets_array as $pallet_obj){
        $pallet = $pallet_obj->toArray();
        $pallet['items'] = [];
        $pallet_items = \YES4Trade\Model\orders_pallets_items::get_by_orders_pallets_id(intval($pallet_obj->orders_pallets_id));
        foreach($pallet_items as $pallet_item){
            $pallet_item_array = $pallet_item->toArray();
            foreach($positions->positions as $pos){
                if(intval($pos->orders_products_id) == intval($pallet_item_array['orders_products_id'])){
                    $pallet_item_array['pos'] = $pos->position;
                    $pallet_item_array['products_id'] = $pos->products_id;
                }
            }
            $pallet['items'][] = $pallet_item_array;
        }
        $pallets[] = $pallet;
    }
    $positions->setPallets($pallets);

	$position_counter = $i;

	// NUN DIE OT_TOTAL MODULE
	$totals_num = sizeOf($this->totals);
        
        $shipping_tax_class_id = $this->get_shipping_tax_class();
        
        // EU-OSS 2021/07
        
        // BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
        /*if(yes_eu_oss_use_country_handling($this->delivery['country_id'])){
            $tax_rate = xtc_get_tax_rate($this->delivery['country_id'],$this->delivery['zone_id']);
        }else{
            $tax_rate = xtc_get_tax_rate($shipping_tax_class_id);
        }*/
        // EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
        
        // BUGF_CH_OSS
        $tax_rate = xtc_get_tax_rate($this->delivery['country_id'],$this->delivery['zone_id']);
	for($i=0;$i<$totals_num;$i++){
            $item_countable = false;
            switch($this->totals[$i]['class']){
                case 'ot_subtotal':
                    $positions->title_subtotal = $this->totals[$i]['title'];
                    break;
                case 'ot_subtotal_no_tax':
                    $positions->title_subtotal = $this->totals[$i]['title'];
                    break;
                case 'ot_total':
                    $positions->title_total = $this->totals[$i]['title'];
                    break;
                case 'ot_discount':
                    $total = $this->totals[$i]['value'];
                    if($tax_rate > 0 and !$this->is_netto2()){ // bugfix 17.02.10
                            $total_netto = $xtPrice->xtcRemoveTax($total, $tax_rate);
                    }else{
                            $total_netto = $total;
                    }

                    $class = 'ot';
                    $item_countable = true;
                    break;
                case 'ot_coupon':
                case 'ot_gv':
                case 'ot_loworderfee':
                case 'ot_payment_fee':
                    $total = $this->totals[$i]['value'];

                    $total_netto = $total;
                    $class = 'ot';
                    $item_countable = true;
                    break;
                case 'ot_cod_fee':
                    $total = $this->totals[$i]['value'];

                    if($tax_rate > 0 and !$this->is_netto2()){ // bugfix 17.02.10
                            $total_netto = $xtPrice->xtcRemoveTax($total, $tax_rate);
                    }else{
                            $total_netto = $total;
                    }

                    $class = 'ot';
                    $item_countable = true;
                    break;
                case 'ot_shipping':
                    $scn = $this->totals[$i]['value'];
                    if(xtc_not_null($this->info['shipping_class']) and !$this->is_netto2()){
                        $scn = $xtPrice->xtcRemoveTax($scn, $tax_rate);
                    }
                    $total = $this->totals[$i]['value'];
                    $total_netto = $scn;
                    $class = 'shipping';
                    $item_countable = true;
                    break;
            }
            if(!$item_countable) continue;

            $position_counter++;
            $pos = new order_position;
            $pos->setClass($class);
            $pos->setTotal_price($total);
            $pos->setTotal_price_netto($total_netto);
            $pos->setSingle_price($total);
            $pos->setSingle_price_netto( $total_netto );
            $pos->setQuantity(1);
            $pos->setPosition($position_counter);
            $pos->setTitle($this->totals[$i]['title']);
            if($this->is_netto2()){ // is_netto2() ist ueberarbeitet
                    $pos->setText1( $xtPrice->xtcFormat( $pos->getSingle_price_netto(),true) );
                    $pos->setText2( $xtPrice->xtcFormat( $pos->getTotal_price_netto(),true) );
            }else{
                    $pos->setText1( $xtPrice->xtcFormat( $pos->getSingle_price(),true) );
                    $pos->setText2( $xtPrice->xtcFormat( $pos->getTotal_price(),true) );
            }
            $positions->addPosition( $pos );
	}
	$positions->setIs_netto( $this->is_netto2() ); // is_netto2() ist ueberarbeitet

	// BUGFIX 18.02.10
    $customers_status = \YES4Trade\Model\customers_status::get_by_customers_status_id(intval($this->info['status']),[
        'customers_status_add_tax_ot','customers_status_show_price_tax'
    ]);
	if($customers_status !== null and intval($customers_status->customers_status_show_price_tax) == 0 and intval($customers_status->customers_status_add_tax_ot) == 1){
		$positions->setAdd_tax_to_total(  true );
	}
	// END BUGFIX 18.02.
	$positions->process($this->totals);
	return $positions->getArray($xtPrice);
  }

  /**
   * Return the Templatefile
   * Only if order is_kasse and branches_id not stammlager
   * @param string $mode
   * @return string template file
   */
  function get_template($mode){
	  switch($mode){
		  case 'print':
			$template = 'print_order.html';
			if($this->is_kasse()){
				$kasse_data = $this->get_kasse_data();
				$branches_id = $kasse_data['branches_id'];
				$branches_template_query_raw = sprintf(
					"SELECT template_filename FROM branches
						WHERE branches_id='%s' AND stammlager=0",
					$branches_id
				);
				$branches_template_query = xtc_db_query($branches_template_query_raw);
				if(xtc_db_num_rows($branches_template_query)){
					$branches_template = xtc_db_fetch_array($branches_template_query);
					$template = $branches_template['template_filename'];
				}
			}
			return $template;
			break;
	  }
  }

  function get_title(string $fibu_number = ''){
	if($this->info['orders_status'] == ORDERS_STATUS_OFFER){
		return TEXT_OFFER;
	}
	$invoice_statuses = array(ORDERS_STATUS_BEZAHLT, ORDERS_STATUS_ABGESCHLOSSEN, ORDERS_STATUS_VERSENDET);
	if( (!empty($fibu_number) and strlen($fibu_number) > 1 ) ){
		return TEXT_INVOICE;
	}
	if(!defined('MODULE_OTHER_FIBUNUMBERS_STATUS') or MODULE_OTHER_FIBUNUMBERS_STATUS != 'True'){
		if(in_array($this->info['orders_status'],$invoice_statuses)){
			return TEXT_INVOICE;
		}
	}
	return TEXT_ORDER;
  }

  /**
   * BEI KOMBINIERTEN AUFTRAEGEN KOENNEN MEHR ALS EINE
   * AUKTIONSNUMMERN ENTHALTEN SEIN
   *
   * WENN $return_orders_id MIT true uebergeben wird, dann wird ein Mehrdimen-
   * sionales Array zurueckgegeben was jeweils die orders_id zur ebay_id ent-
   * haelt
   *
   * @param bool $return_orders_id
   * @return array ebay_id
   */
  //
  function get_auction_array($return_orders_id = false){
	$ebay_id = array();
	$combineds = $this->get_combined_orders();
	if(!sizeOf($combineds)){
		if(empty($this->info['ebay_id']))
			return $ebay_id;
		if(!$return_orders_id){
			return array($this->info['ebay_id']);
		}else{
			return array(
				0=>array(
					'orders_id'=>$this->info['id'],
					'ebay_id'=>$this->info['ebay_id']
				)
			);
		}
	}

	foreach($combineds as $combined){
		$ebay_id_query = xtc_db_query(sprintf(
			"SELECT ebay_id FROM orders WHERE orders_id='%s'",
			$combined['orders_id']
		));
		$ebay_id_result = xtc_db_fetch_array($ebay_id_query);
		if(xtc_not_null($ebay_id_result['ebay_id'])){
			if(!$return_orders_id){
				$ebay_id[] = $ebay_id_result['ebay_id'];
			}else{
				$ebay_id[] = array(
					'orders_id'=>$combined['orders_id'],
					'ebay_id'=>$ebay_id_result['ebay_id']
				);
			}
		}
	}
	return $ebay_id;
  }

  /**
   * Prueft ob die Bestellung einen Eintrag in amazon_orders enthaelt
   * 
   * @return Boolean
   */
  public function has_amazon_items(){
	if(!defined('MODULE_OTHER_AMAZON_STATUS') or MODULE_OTHER_AMAZON_STATUS != 'True')
		return false;
	$query = yes_db_query(sprintf(
		"SELECT count(orders_id) as anz FROM amazon_orders WHERE orders_id='%s'",
		$this->info['id']
	));

	if(yes_db_num_rows($query)){
		$record = current($query);
		if($record['anz'] > 0)
			return true;
	}

	// vllt ist der Auftrag kombiniert - dann zusaetzl. die enthaltenen pruefen
	$combineds = $this->get_combined_orders();
	if(!sizeOf($combineds))
		return false;
	foreach($combineds as $combined){
		$query = yes_db_query(sprintf(
			"SELECT count(orders_id) as anz FROM amazon_orders WHERE orders_id='%s'",
			$combined['orders_id']
		));
		if(yes_db_num_rows($query)){
			$record = current($query);
			if($record['anz'] > 0)
				return true;
		}
	}

	return false;
  }

  /**
   * Holt alle enthaltenen Amazonartikel der Bestellung (incl. Kombinierte).
   * SQL-Bedingung: orders_id muss in amazon_orders enthalten sein
   *
   * @return Array
   */
  public function get_amazon_items(){
	$items_array = array();
	if(defined('MODULE_OTHER_AMAZON_STATUS') and MODULE_OTHER_AMAZON_STATUS != 'True'){
		return $items_array;
        }
	$query = yes_db_query(sprintf(
		"SELECT ao.shipping_method_service_level,ao.orig_amazon_orders_id,aop.* FROM amazon_orders ao LEFT JOIN amazon_orders_products aop USING(amazon_orders_id) WHERE ao.orders_id='%d' GROUP BY aop.amazon_orders_products_id",
		$this->info['id']
	));
	if(yes_db_num_rows($query)){
		foreach($query as $record){
			$items_array[] = $record;
		}
	}
        
	$combineds = $this->get_combined_orders();
	if(!sizeOf($combineds)){
            return $items_array;
        }

	foreach($combineds as $combined){
            $query = yes_db_query(sprintf(
                "SELECT ao.shipping_method_service_level,ao.orig_amazon_orders_id,aop.* FROM amazon_orders ao LEFT JOIN amazon_orders_products aop USING(amazon_orders_id) WHERE ao.orders_id='%s'",
                $combined['orders_id']
            ));
            if(yes_db_num_rows($query)){
                foreach($query as $record){
                        $items_array[] = $record;
                }
            }
	}
	return $items_array;
  }

  /**
   * Wenn nur die pID eines enthaltenen Produkts bekannt ist, gibt diese
   * Funktion die orders_products_id des Artikels in der Rechnung wieder
   * Gibt -1 zurueck wenn die pID nicht in der Rechnung enthalten ist.
   * Setzt voraus dass in YES Auftraegen keine doppelten pID Eintraege sind.
   *
   * @param Integer $products_id
   * @return Integer
   */
  public function get_orders_products_id_from_products_id($products_id){
	  if($products_id < 1)
		  return -1;
	  foreach($this->products as $product){
		  if($product['id'] == $products_id)
			  return $product['opID'];
	  }
	  return -1;
  }
  
  public function has_unallocated_amazon_items(){
	  if(!defined('MODULE_OTHER_AMAZON_STATUS') or MODULE_OTHER_AMAZON_STATUS != 'True'){
		  return false;
	  }
	  for($i=0;$i<sizeOf($this->products);$i++){
		  if(!empty($this->products[$i]['amazon_order_item_code']) and $this->products[$i]['id'] <= 0){
			  return true;
		  }
	  }
	  return false;
  }
  
	public function has_unallocated_ebay_items(){
		$auctions = $this->get_auction_array(true);
		if(!sizeOf($auctions) or !sizeOf($this->products))
			return false;
		$dummy_pid = (defined('EBAY_DEFAULT_DUMMY_PRODUCTS_ID') and EBAY_DEFAULT_DUMMY_PRODUCTS_ID > 0) ? EBAY_DEFAULT_DUMMY_PRODUCTS_ID : 0;
		foreach($this->products as $product){
			if($product['id'] == $dummy_pid)
				return true;
		}
	}

    public function get_orders_entry_for_copy(int $orders_status){
		$query = xtc_db_query(sprintf(
			"SELECT * FROM orders WHERE orders_id=%s",
			$this->info['id']
		));
		$record = xtc_db_fetch_array($query);
		unset($record['orders_id']);
		unset($record['ebay_id']);
		unset($record['customers_ip']);
		unset($record['last_modified']);
		unset($record['date_payment']);
		unset($record['orders_date_finished']);
		unset($record['parent_orders_id']);
		unset($record['is_parent']);
		unset($record['warning_status']);
		unset($record['no_warning']);
		unset($record['warning_span_date']);
		unset($record['warning_span']);
		unset($record['block_shipping']);
		unset($record['block_shipping_comment']);
		unset($record['block_shipping_end_date']);
		unset($record['date_shipping']);
		unset($record['last_warning']);
		unset($record['rueckstand']);
		unset($record['orders_split_id']);
		unset($record['combined_orders_id']);
		unset($record['ebayfeedback_block_status']);
		unset($record['refferers_id']);
        $record['source_editor_id'] = $_SESSION['customer_id'];
		$record['date_purchased'] = 'now()';
		$record['orders_status'] = $orders_status;
		$record['payment_method'] = 'moneyorder';
		$record['payment_class'] = 'moneyorder';
        return $record;
    }

    public function get_orders_products_entries_for_copy(){
		$query = yes_query(
			"SELECT * FROM orders_products WHERE orders_id=:id",[
			    'id'=>intval($this->info['id'])
            ]
		);
        $sql = [];
		foreach($query as $record){
			$orig_opID = $record['orders_products_id'];                      

			$orders_products_price_fixing = yes_query(
				"SELECT * FROM orders_products_price_fixing WHERE orders_products_id=:opid",[
				    'opid'=>intval($orig_opID)
			    ]
            );
			
            $orders_products_properties = yes_query(
				"SELECT * FROM orders_products_properties WHERE orders_products_id=:opid",[
				    'opid'=>intval($orig_opID)
			    ]
            );
            $sql[ $orig_opID ] = [
                'orders_products'=>$record,
                'orders_products_price_fixing'=>$orders_products_price_fixing,
                'orders_products_properties'=>$orders_products_properties
            ];
		}
        return $sql;
    }
  
	public function copy($orders_status=1){
        $record = $this->get_orders_entry_for_copy(intval($orders_status));
		xtc_db_perform('orders',$record);
		$orders_id = xtc_db_insert_id();
	
        $orders_products_entries = $this->get_orders_products_entries_for_copy();
        $products_copies = array();
		foreach($orders_products_entries as $opID=>$tables){
            $record = $tables['orders_products'];
			unset($record['orders_products_id']);
            $products_copies[ $record['products_id'] ] = true;
			unset($record['quantity_shipped']);
			unset($record['not_ship']);
			$record['orders_id'] = $orders_id;
			xtc_db_perform('orders_products',$record);
			$new_opID = xtc_db_insert_id();
                        
            // BOF - ARTIKELHISTORIE Ticket 3195
            $insert_sql_array = array(
                'products_id'=>$record['products_id'],
                'editor_id'=>intval($_SESSION['customer_id']??0),
                'date_saved'=>'now()',
                'comments'=>sprintf(PRODUCTS_HISTORY_ORDER_COPY,
                        $this->info['id'],
                        $orders_id,
                        $record['products_quantity']
                )
            );
            xtc_db_perform('products_history',$insert_sql_array);
            // EOF - ARTIKELHISTORIE Ticket 3195
                        
			
			foreach($tables['orders_products_price_fixing'] as $record2){
				unset($record2['orders_products_price_fixing_id']);
				$record2['orders_products_id'] = $new_opID;
				xtc_db_perform('orders_products_price_fixing',$record2);
			}
			
			foreach($tables['orders_products_properties'] as $record2){
				unset($record2['orders_products_properties_id']);
				$record2['orders_products_id'] = $new_opID;
				xtc_db_perform('orders_products_properties',$record2);
			}
		}
	
		$query = xtc_db_query(sprintf(
			"SELECT * FROM orders_products_download WHERE orders_id=%s",
			$this->info['id']
		));
		while($record = xtc_db_fetch_array($query)){
			unset($record['orders_products_download_id']);
			$record['orders_id'] = $orders_id;
			xtc_db_perform('orders_products_download',$record);
		}
		
		$query = xtc_db_query(sprintf(
			"SELECT * FROM orders_total WHERE orders_id=%s",
			$this->info['id']
		));
		while($record = xtc_db_fetch_array($query)){
			unset($record['orders_total_id']);
			$record['orders_id'] = $orders_id;
			xtc_db_perform('orders_total',$record);
		}
		$insert_sql_array = array(
			'orders_id' => $orders_id,
			'orders_status_id'=>$orders_status,
			'date_added'=>'now()',
			'customer_notified'=>0,
			'comments'=>'Kopie von Re-Nr: '.$this->info['id'],
			'editor_id'=>$_SESSION['customer_id']
		);
		xtc_db_perform('orders_status_history',$insert_sql_array);
        
        if(!function_exists('yes_end_auction_add')){
            require_once(DIR_FS_INC.'yes_end_auction_add.inc.php');
        }
        foreach($products_copies as $pID => $true){
            yes_end_auction_add($pID, 1);
        }
		return $orders_id;
	}
        
    /**
     * MwSt Satz fuer Versandkostenberechnung
     * 
     * Ermittelt den anzuwendenden MwSt Satz. Bei Uebergabe einer use_country_id
     * wird nicht EU OSS angewendet um den MwSt Satz zu ermitteln. Das wird
     * zb benoetigt fuer den MwSt Satz von hitmeister/kaufland Auftraegen
     * Dort wird immer der MwSt Satz des Einstellandes (also idR DE 19%)
     * verwendet und darf nicht neu berechnet werden
     * 
     * @param int $use_country_id
     * @return int tax_class_id
     */
    public function get_shipping_tax_class( int $use_country_id = -1 ){
        $tax_class_id = 0;
	if(is_array($this->products)){
            $taxes = array();
            if($use_country_id <= 0){
                $country_id = $this->delivery['country_id'];
                // BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
                /*if(!yes_eu_oss_use_country_handling($country_id)){
                    $country_id = STORE_COUNTRY;
                }*/
                // EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
            }else{
                $country_id = $use_country_id;
            }
            foreach($this->products as $k=>$product){
                $products_tax_class_id = yes_eu_oss_get_products_tax_class_id($product['id'], $country_id);
                $key = $products_tax_class_id.':'.number_format($product['tax'],2,'.','');
                if(!isset($taxes[ $key ])){
                    $taxes[ $key ] = 0;
                }
                $taxes[ $key ] += $product['final_price'];
            }
            $max = (sizeOf($taxes)>0)?max($taxes):0;
            foreach($taxes as $tax=>$val){
                if($val == $max){
                    $tax_parts = explode(':',$tax);
                    $tax_class_id = $tax_parts[0];
                }
            }
	}
	return $tax_class_id;
  }
  
  public function get_tax_class_from_rate($tax_rate):int{
        $z2gz_items = \YES4Trade\Model\zones_to_geo_zones::get_by_zone_country_id(
            intval($this->delivery['country_id']), ['geo_zone_id']
        );
        // gibt scheinbar nur eine verknuepfung zones_to_geo_zones/zone_country_id
        $z2gz = current($z2gz_items);
        $tax_class_query = xtc_db_query(sprintf(
            "SELECT tax_class_id FROM tax_rates WHERE tax_rate=%s AND tax_zone_id='%s' LIMIT 1",
            $tax_rate,$z2gz->geo_zone_id
        ));
        $tax_class = xtc_db_fetch_array($tax_class_query);
        return intval($tax_class['tax_class_id']);
  }
  
	public function is_in_shipping(){
		$query = xtc_db_query(sprintf(
			"SELECT id FROM shippings WHERE orders_id=%s AND status=0",
			$this->info['id']
		));
		if(xtc_db_num_rows($query)){
			return true;
		}
		return false;	
	}
        
        /**
         * Ermittelt zur pID des Auftrags, von welchen Lagerplaetzen beim Versand-
         * abschluss gebucht wurde. Wird benoetigt in der PDF Paketliste
         * 
         * *** 09/2017 ***
         * Der Parameter shipping_products_id grenzt die Abfrage ein auf einen
         * speziellen Versanddatensatz - somit koennen auch Teillieferungen
         * beruecksichtigt werden
         * 
         * @param type $products_id
         * @param type $reason_subclass
         * @param type $is_colli
         * @param type $shipping_products_id
         * @return Array
         */
	public function get_transferred_places($products_id,$reason_subclass = '',$is_colli = false, $shipping_products_id = 0){
		return yes_get_transferred_storage_products(
                        $products_id,
                        'order', 
                        $this->info['id'] , 
                        $reason_subclass,
                        $is_colli,
                        $shipping_products_id
                );
	}
	
	public function get_source(){
		return $this->info['source'];
	}
	
	public function get_source_title(){
		switch($this->info['source']){
		    case 'admin':
			if($this->info['source_editor_id'] > 0){
			    return 'Kundendienst ('.xtc_get_editor_name($this->info['source_editor_id']).')';
			}
			break;
		    case 'counter':
			    return TEXT_HEADER_MENU_COUNTER;
			break;
		    case 'amazon':
                        if($this->info['prime'] == 1){
                            return 'Amazon Prime';
                        }
			return 'Amazon';
			break;
		    case 'hitmeist':
			    return TEXT_HEADER_MENU_HITMEISTER;
			break;  
		    default:
			return $this->info['source'];
			break;
		}
	}
	
	public function get_shipped_products_with_collis($products){
		if(!sizeOf($this->products)){
			return $products;
		}
		foreach($this->products as $product){
			$colli_query = xtc_db_query(sprintf(
				"SELECT collie_products_id,quantity FROM products_collies WHERE products_id='%s'",
				$product['id']
			));
			if(!xtc_db_num_rows($colli_query)){
				if(!isset($products[$product['id']]))
					$products[$product['id']] = 0;
				$products[$product['id']] += $product['qty'];
			}
			while($colli = xtc_db_fetch_array($colli_query)){
				if(!isset($products[ $colli['collie_products_id'] ]))
					$products[ $colli['collie_products_id'] ] = 0;
				$products[ $colli['collie_products_id'] ] += $colli['quantity'] * $product['qty'];
			}
		}
		return $products;
	}
	function get_properties($opID){
		$properties_array = array();
		$properties_query = xtc_db_query(sprintf(
			"SELECT property_title,property_value,price_netto,input_span FROM orders_products_properties WHERE orders_products_id='%d' ORDER BY property_title",
			$opID
		));
		if(xtc_db_num_rows($properties_query)){
			while($properties = xtc_db_fetch_array($properties_query)){
				 $properties_array[] = $properties;
			}
		}
		return $properties_array;
	}
	
	public function get_update_address_part_prefix($address_type){
		switch($address_type){
			case 'customer':
				$prefix = 'customers_';
				break;
			case 'shipping':
				$prefix = 'delivery_';
				break;
			case 'invoice':
				$prefix = 'billing_';
				break;
		}
		return $prefix;
	}
	
	public function get_address_part_sql($address_type,$data,$transform_to='',$utf8_decode=true){
		$prefix = $this->get_update_address_part_prefix($address_type);
		$update_sql_array = array();
		$target_key = ($transform_to != '') ? $this->get_update_address_part_prefix($transform_to) : '';
		foreach($data as $key=>$val){
			if(!strstr($key,$prefix) or $key == 'update_customers_name'){
				continue;
			}
			if(strstr($key,'country')){
				if($target_key != ''){
					if($utf8_decode)
						$update_sql_array[ str_replace($prefix,$target_key,$key) ] = yes_decode_string( xtc_get_country_name( $val ) );
					else
						$update_sql_array[ str_replace($prefix,$target_key,$key) ] = xtc_get_country_name( $val );
				}else{
					if($utf8_decode)
						$update_sql_array[ $key ] = yes_decode_string(xtc_get_country_name($val));
					else
						$update_sql_array[ $key ] = xtc_get_country_name($val);
				}
			}else{
				if($target_key != ''){
					if(!strstr($key,'telephone') and !strstr($key,'mobile') and !strstr($key,'vat_id')){
						$update_sql_array[ str_replace($prefix,$target_key,$key) ] = yes_decode_string($val);
					}
				}else{
					$update_sql_array[ $key ] = yes_decode_string($val);
				}
			}
		}
		return $update_sql_array;
	}
	public function update_address_part($update_sql_array){
		foreach($update_sql_array as $key => $val){
			if(mb_detect_encoding($val) == 'UTF-8'){
				//$update_sql_array[ $key ] = utf8_encode($val);
			}
		}
		foreach($update_sql_array as $k=>$v){
		    $update_sql_array[$k]=xtc_db_prepare_input($v);
		}
		xtc_db_perform(TABLE_ORDERS,$update_sql_array,'update',"orders_id='".$this->info['id']."'");
	}
	
	public function allow_shipping(){
		$wc_query = xtc_db_query(sprintf(
			"SELECT wrapping_counter_id FROM wrapping_counter WHERE orders_id='%s'",
			$this->info['id']
		));
		if(xtc_db_num_rows($wc_query)){
			return false;
		}
		if($this->info['orders_status'] == ORDERS_STATUS_BEZAHLT or 
				(in_array($this->info['orders_status'],array(1,2,ORDERS_STATUS_UPSELLING)) and xtc_is_shipping_before_payment($this->info['payment_method']) ) ){
			if($this->info['block_shipping'] == 0 and $this->info['rueckstand'] == 0)
				return true;
		}
		return false;
	}
	
        public function insert_shippings_products($opID,$qty,$shippings_id=0){
            foreach($this->products as $product){
                if($product['opID'] == $opID){
                    $insert_sql_array = array(
                            'products_id'=>$product['id'],
                            'shippings_id'=>$shippings_id,
                            'quantity'=>$qty,
                            'source_products_id'=>$opID
                    );
                    xtc_db_perform('shippings_products',$insert_sql_array);
                    return xtc_db_insert_id();
                }
            }
        }
	public function add_quantity_shipped(int $opID,int $qty){
            xtc_db_query(sprintf(
                "UPDATE %s SET quantity_shipped=quantity_shipped+%d WHERE orders_products_id='%d' and orders_id='%d'",
                TABLE_ORDERS_PRODUCTS,$qty,$opID,$this->info['id']
            ));
	}
	
	public function update_not_ship($opID,$qty){
		xtc_db_query(sprintf(
			"UPDATE %s SET not_ship=%s WHERE orders_products_id='%s' and orders_id='%s'",
			TABLE_ORDERS_PRODUCTS,$qty,$opID,$this->info['id']
		));
	}
	
	public function get_part_order_short_html(){
		$string = '';
		if($this->info['part_orders'] == 1){
			$string = sprintf('<span style="color:#00FF00;font-size:12px;padding:3px;border:1px solid #00FF00;background:#FFFFFF;width:10px;" title="%s">T</span>',
				TEXT_PART_ORDER
			);
		}
		return $string;
	}
	
	public function get_not_ship_short_html(){
		$string = '';
		if($this->info['not_ship_products'] == 1){
			$string = sprintf('<span style="color:#FFFFFF;font-size:12px;padding:3px;border:1px solid #000000;background:#FF0000;font-weight:bold;width:10px;" title="%s">!</span>',
				TEXT_NOT_SHIP_PRODUCTS_IN_ORDER
			);
		}
		return $string;
	}
	
  private function get_characteristics_for_product($pID,$collies){
      $products_characteristics_data = array();
      $sess_lang_id = (isset($_SESSION['languages_id'])) ? $_SESSION['languages_id'] : 2;
      $gh = new \YES4Trade\Model\group_handler($sess_lang_id);
      $collies_array = array();
      if(sizeOf($collies)>0){
	    foreach($collies as $ck=>$collie){
		    $collie_title_query = xtc_db_query(sprintf(
			    "SELECT slave_title,products_name FROM products_description WHERE products_id=%s AND language_id=%s",
			    $collie['collie_products_id'],$sess_lang_id
		    ));
		    $collie_title = xtc_db_fetch_array($collie_title_query);
		    $collies_array[] = array(
			    'products_id'=>$collie['collie_products_id'],
			    'slave_title'=>$collie_title['slave_title'],
			    'products_name'=>$collie_title['products_name'],
			    'PRODUCTS_WEIGHT'=>xtc_get_ext_products_weight($collie['collie_products_id']),
                'PRODUCTS_WEIGHT_NETTO'=>xtc_get_ext_products_weight_netto($collie['collie_products_id']),
		    );
            $allocs = $gh->get_allocated_product_group_characteristic_values($collie['collie_products_id']);
            if(is_countable($allocs) and sizeOf($allocs)){
                $products_characteristics_data[$collie['collie_products_id']] = $allocs;
            }
	    }
	}else{
            $allocs = $gh->get_allocated_product_group_characteristic_values($pID);
            if(is_countable($allocs) and sizeOf($allocs)){
                $products_characteristics_data = $allocs;
            }
	}
	return $products_characteristics_data;
  }
  
  private function get_product_storages($pID,$collies, $asTable = true){
		// LAGERPLAETZE
		$storage_str = '';
		$transfer_places = array();
		if(in_array($this->info['orders_status'],array(ORDERS_STATUS_VERSENDET, ORDERS_STATUS_ABGESCHLOSSEN))){
			$transfer_places = $this->get_transferred_places($pID,'Versand');
		}else{
			$transfer_places = array();
		}
		if(sizeOf($transfer_places)){
			foreach($transfer_places as $tp){
				$storage_str .= sprintf('<br />Lager &raquo;%s&laquo; / Lagerplatz &raquo;%s&laquo;: %s Stk.',
					$tp['name'],$tp['storage_place'],$tp['quantity']
				);
			}
		}else{
			$storages = array();
			if(sizeOf($collies)>0){
				foreach($collies as $ck=>$collie){
                                        $storage_query = xtc_db_query(sprintf(
                                                "SELECT stp.title as storage_place,sn.nummer,sp.storage_id FROM storage_products sp LEFT JOIN storage_numbers sn USING(storage_id, products_id), storage_places stp WHERE sp.products_id='%d' AND stp.storage_places_id=sp.storage_places_id",
                                                $collie['collie_products_id']
                                        ));
                                        $_array = array();
					while($storage = xtc_db_fetch_array($storage_query)){
                                            $_array[] = $storage;
                                        }
                                        foreach($_array as $storage){
                                            $storage['name'] = xtc_get_storage_name($storage['storage_id']);
                                            $storage['name'] = '(Colli aus pID '.$collie['collie_products_id'].') '.$storage['name'];
                                            $storages[] = xtc_db_prepare_input($storage);
					}
				}
			}else{
                                $storage_query = xtc_db_query(sprintf(
                                        "SELECT stp.title as storage_place,sn.nummer,sp.storage_id FROM storage_products sp LEFT JOIN storage_numbers sn USING(storage_id, products_id), storage_places stp WHERE sp.products_id='%d' AND stp.storage_places_id=sp.storage_places_id",
                                        $pID
                                ));
                                $_array = array();
                                while($storage = xtc_db_fetch_array($storage_query)){
                                    $_array[] = $storage;
                                }
				while($storage = xtc_db_fetch_array($storage_query)){
                                    $storage['name'] = xtc_get_storage_name($storage['storage_id']);
                                    $storages[] = xtc_db_prepare_input($storage);
				}
			}
		}
                if(!$asTable){
                    return $storages;
                }
		if(is_countable($storages) and sizeOf($storages)>0){
			$storage_str = '<table border="0" cellpadding="2" cellspacing="2">';
			foreach($storages as $sk=>$storage){
				$storage_str .= '<tr>';
				$storage_str .= '	<td colspan="2" class="smallText"><font size="1" face="Verdana, Arial, Helvetica, sans-serif"><b>'.TEXT_STORAGE.' '.$storage['name'].'</b></font></td>';
				$storage_str .= '</tr><tr>';
				$storage_str .= '	<td class="smallText"><font size="1" face="Verdana, Arial, Helvetica, sans-serif">'.$storage['storage_place'].'</font></td>';
				$storage_str .= '	<td class="smallText"><font size="1" face="Verdana, Arial, Helvetica, sans-serif">'.$storage['nummer'].'</font></td>';
				$storage_str .= '</tr>';
			}
			$storage_str .= '</table>';
		}
		return $storage_str;
  }
  public function has_part_delivery(){
	if( in_array( $this->info['orders_status'],array(ORDERS_STATUS_ABGESCHLOSSEN,ORDERS_STATUS_VERSENDET,ORDERS_STATUS_STORNIERT) )){
	    $query = xtc_db_query(sprintf(
		    "SELECT count(id) as anz FROM shippings WHERE orders_id='%s'",
		    $this->info['id']
	    ));
	    $record = xtc_db_fetch_array($query);
	    return ($record['anz'] > 1) ? true : false;
	}else{
	    $query = xtc_db_query(sprintf(
		    "SELECT count(id) as anz FROM shippings WHERE orders_id='%s' AND status=1",
		    $this->info['id']
	    ));
	    $record = xtc_db_fetch_array($query);
	    if($record['anz'] < 1){
		return false;
	    }
	    foreach($this->products as $product){
		if($product['quantity_shipped'] > 0){
		    return true;
		}
	    }
	}
        
  }
  
    public function get_cashier(){
        $array = array();
        if(!defined('MODULE_OTHER_CASHIER_STATUS') or MODULE_OTHER_CASHIER_STATUS != 'True'){
            return $array;
        }
        
        $query = xtc_db_query(sprintf(
                "SELECT module_cashier_seller_id,module_cashier_cashiers_id,date_created FROM module_cashier_orders WHERE orders_id='%s'",
                $this->info['id']
        ));
        if(xtc_db_num_rows($query)){
            $items = array();
            while($record = xtc_db_fetch_array($query)){
                $items[] = $record;
            }
            foreach($items as $record){
                $query = xtc_db_query(sprintf(
                        "SELECT seller_alias FROM module_cashier_sellers WHERE module_cashier_sellers_id='%s'",
                        $record['module_cashier_seller_id']
                ));
                $alias = xtc_db_fetch_array($query);
                $array[] = array(
                    'seller'=> $alias['seller_alias'],
                    'cashier'=>xtc_get_editor_name($record['module_cashier_cashiers_id']),
                    'date_created'=>xtc_date_short($record['date_created'])
                );
            }
        }
        return $array;

    }
    
  
  public function get_real_shipping_costs(){
      if(stristr($this->info['shipping_class'],'pickup')){
          return 0;
      }
      $graduation_query = xtc_db_query(sprintf(
              "SELECT shipping_graduation_id FROM shipping_graduation WHERE value <= %s ORDER BY value DESC limit 1",
              sizeOf($this->products)
      ));
      $graduation = xtc_db_fetch_array($graduation_query);
      $gID = $graduation['shipping_graduation_id'];
      $group_query = xtc_db_query(sprintf(
              "SELECT shipping_graduation_groups_id FROM shipping_graduation_countries WHERE country_id='%s'",
              $this->delivery['country_id']
      ));
      if(xtc_db_num_rows($group_query)){
          $group = xtc_db_fetch_array($group_query);
          $groupID = $group['shipping_graduation_groups_id'];
      }else{
          $groupID = 999999;
      }
      $weight_query = xtc_db_query(sprintf(
              "SELECT shipping_graduation_weights_id FROM shipping_graduation_weights ORDER BY abs(weight - %s) limit 1",
              $this->show_weight()
      ));
      $weight = xtc_db_fetch_array($weight_query);
      $wID = $weight['shipping_graduation_weights_id'];
      $cost_query = xtc_db_query(sprintf(
              "SELECT grad_value_cost FROM shipping_graduation_values WHERE shipping_graduation_id='%s' AND shipping_graduation_weights_id='%s' AND shipping_graduation_groups_id='%s'",
              $gID,$wID,$groupID
      ));
      if(xtc_db_num_rows($cost_query)){
          $cost = xtc_db_fetch_array($cost_query);
          return $cost['grad_value_cost'];
      }
      return 0;
  }
  
  public function save_real_shipping_cost(){
      xtc_db_query(sprintf(
              "DELETE FROM orders_costs WHERE orders_id='%s' AND title='shipping'",
              $this->info['id']
      ));
      $insert_sql_array = array(
          'orders_id'=>$this->info['id'],
          'title'=>'shipping',
          'costs'=>$this->get_real_shipping_costs()
      );
      xtc_db_perform('orders_costs',$insert_sql_array);
  }
  
  public function get_costs(){
      $array = array();
      $query = xtc_db_query(sprintf(
              "SELECT * FROM orders_costs WHERE orders_id='%s' ORDER BY title",$this->info['id']
      ));
      while($record = xtc_db_fetch_array($query)){
          $record['title_lang'] = '';
          switch($record['title']){
              case 'shipping':
                  $record['title_lang'] = TEXT_ORDER_COSTS_SHIPPING_TITLE;
                  break;
          }
          $array[] = $record;
      }
      return $array;
  }
  
  public function get_reclamations(){
      $array = array();
      $query = xtc_db_query(sprintf(
              "SELECT reclamations_id FROM reclamations WHERE orders_id='%s'",
              $this->info['id']
      ));
      while($record = xtc_db_fetch_array($query)){
          $array[] = $record['reclamations_id'];
      }
      return $array;
  }

/**
 * Gibt ein Array zurueck welches die Versanddatensatze zum Auftrag ausliest
 * 
 * @param type $include_reclamations
 * @return array( 'id'=>,'versender'=>,'tracking_id'=>,'date_finished'=>)

 */  
  public function get_shipping_tracking_id_array( $include_reclamations = true ){
	$array = array();
	if($include_reclamations){
	    $query = xtc_db_query(sprintf(
		"SELECT id,versender, tracking_id,date_finished FROM shippings WHERE orders_id='%s' ORDER BY date_finished DESC",
		$this->info['id']
	    ));
	}else{
	    $query = xtc_db_query(sprintf(
		"SELECT id,versender, tracking_id,date_finished FROM shippings WHERE orders_id='%s' AND reclamations_id=0 ORDER BY date_finished DESC",
		$this->info['id']
	    ));
	}
	while($record = xtc_db_fetch_array($query)){
	    /**
	     * DAS IST ALTES HANDLING, BEIM NEUEN HANDLING WERDEN DIE tracking_id
	     * IN shippings_tracking_numbers GESPEICHERT UND PER yes_shipping Klasse
	     * ausgelesen
	     */
	    if($record['tracking_id'] != ''){
		$array[] = $record;
	    }
	    // NEUES HANDLING
	    $YS = new yes_shipping($record['id']);
	    $_array = $YS->getTracking_id_array();
	    if(sizeOf($_array)){
		foreach($_array as $_a){
		    $array[] = array(
			'id'=>$record['id'],
			'versender'=>$record['versender'],
			'tracking_id'=>$_a,
			'date_finished'=>$record['date_finished']
		    );
		}
	    }
	}
	return $array;
  }
  
  public function getEbay_no_shippingaddress() {
      return $this->ebay_no_shippingaddress;
  }

  public function setEbay_no_shippingaddress($ebay_no_shippingaddress) {
      $this->ebay_no_shippingaddress = $ebay_no_shippingaddress;
  }

  public function getEbay_no_registrationaddress() {
      return $this->ebay_no_registrationaddress;
  }

  public function setEbay_no_registrationaddress($ebay_no_registrationaddress) {
      $this->ebay_no_registrationaddress = $ebay_no_registrationaddress;
  }

  public function getEbay_different_address() {
      return $this->ebay_different_address;
  }

  public function setEbay_different_address($ebay_different_address) {
      $this->ebay_different_address = $ebay_different_address;
  }
  
  public function get_ebay_buyer(){
      // WENN ES EIN KOMBINIERTER AUFTRAG, ABER VON UNTERSCHIEDLICHEN BUYERN IST
      // DANN IST ES ERSTMAL SO, DAS LESEN WIR NICHT AUS
      // DEN ERSTEN BUYER NEHMEN WIR
      if(sizeOf($this->ebay_id_array)){
	  foreach($this->ebay_id_array as $ebay_id){
	      $query = xtc_db_query("SELECT userid FROM ebay_transactions WHERE ebayid='".$ebay_id."' AND orders_id='".$this->info['id']."'");
              if(!xtc_db_num_rows($query)){
                  return '';
              }
	      $record = xtc_db_fetch_array($query);
              return $record['userid'];
	  }
      }
  }
  
  public function get_ebay_fees(){
      $data = array();
      if(is_countable($this->ebay_id_array) and sizeOf($this->ebay_id_array)){
	  foreach($this->ebay_id_array as $ebay_id){
	      $data[$ebay_id] = array();
	      $query = xtc_db_query("SELECT * FROM ebay_auctions_fees WHERE ebay_id='".$ebay_id."'");
	      while($record = xtc_db_fetch_array($query)){
		  $data[$ebay_id][] = $record;
	      }
	  }
      }
      return $data;
  }
  
  function get_paymentinstructions(){
      $instructions = array();
	$query  = xtc_db_query(sprintf(
		"SELECT paymentinstructions FROM orders_paymentinstructions WHERE orders_id='%s' ORDER BY date_saved DESC",
		$this->info['id']
	));
	while($record = xtc_db_fetch_array($query)){
	    $instructions[] = $record['paymentinstructions'];
	}
	return $instructions;
  }
  
  /**
   * Berechnet die Marge zu einer pID
   * 
   * Liefert entweder einen float Wert ueber den Brutto-Marge-Betrag zurueck oder
   * ein Array mit den einzelnen Werten.
   * Wird return_as_array mit true uebergeben, wird ein Array aller Werte zurueck-
   * gegeben die an der Berechnung der Marge beteiligt sind.
   * 
   * @param int $products_id
   * @param int $qty
   * @param bool $return_as_array
   * @return float or array
   */
  public function get_product_marge(int $products_id, int $qty, bool $return_as_array = false){
        /*printf('<li>get_product_marge(%d, %s, %s)',
                $products_id, $qty, ($return_as_array)?'true':'false'
        );*/
        if($return_as_array){
            // ohne qty multiplikator
            $marge = yes_product_margenrechner($products_id,$this->info['source'],$this->delivery['country_id'],$return_as_array);
            return $marge;
        }
        $marge = yes_product_margenrechner($products_id,$this->info['source'],$this->delivery['country_id'],$return_as_array)*$qty;
        return $marge;
  }
  
  public function save_marge(){
      $marge = $this->get_marge();
      $update_sql_array = array(
	  'marge'=>$marge['MARGE_DIFF'],
	  'last_modified'=>'now()'
      );
      xtc_db_perform(TABLE_ORDERS,$update_sql_array,'update',"orders_id='".$this->info['id']."'");
      foreach($this->products as $product){
	  $update_sql_array = array(
	      'marge'=>$this->get_product_marge($product['id'], $product['qty'])
	  );
	  xtc_db_perform(TABLE_ORDERS_PRODUCTS,$update_sql_array,'update',"orders_products_id='".$product['opID']."'");
      }
      
      $comments = sprintf(TEXT_ORDERS_MARGE_SAVED,number_format($marge['MARGE_DIFF'],2,',',''));
      $this->add_history($this->info['orders_status'], false, $comments);
      return $marge['MARGE_DIFF'];
  }
  
  public function get_marge(){
    $total_marge = 0;
    $weight = 0;
    $brutto_total = 0;
    $has_shippingcosts = false;
    foreach($this->totals as $ot){
	switch($ot['class']){
	    case 'ot_total':
		$brutto_total = $ot['value'];
		break;
	    case 'ot_shipping':
		$has_shippingcosts = true;
		break;
	}
    }
    for ($i = 0, $n = sizeof($this->products); $i < $n; $i++) {
	$collies = xtc_get_product_collies($this->products[$i]['id']);
    $weight += xtc_get_ext_products_weight($this->products[$i]['id'])*$this->products[$i]['qty'];
	if(sizeOf($collies)>0){
	    foreach($collies as $k=>$collie){
		    $total_marge += $this->get_product_marge($collie['collie_products_id'], $collie['quantity']*$this->products[$i]['qty']);
	    }
	}else{
	    $total_marge += $this->get_product_marge($this->products[$i]['id'], $this->products[$i]['qty']);
	}
    }
    if($has_shippingcosts){
        $total_marge += yes_product_margenrechner_get_shipping_netto($weight,$this->delivery['country_id']);
    }
    return array(
	'MARGE_TOTAL'=>$total_marge,
	'MARGE_TOTAL_FORMATTED'=>number_format($total_marge,2,',','.'),
	'MARGE_DIFF'=>$brutto_total-$total_marge,
	'MARGE_DIFF_FORMATTED'=>number_format($brutto_total-$total_marge,2,',','.')
    );
  }
  
  
  private function get_tax_proportional_distribution(){
      if(!sizeOf($this->products)){
	  return array(array(
	      'tax_class_id'=>1,
	      'tax_rate'=>xtc_get_tax_rate(1),
	      'title'=>  xtc_get_tax_description(1),
	      'percentage'=>100
	  ));
      }
      $return = array();
      $tc_values = array();
      $tc_percentage = array();
      $product_sum = 0;
      foreach($this->products as $product){
	  if(!isset($product['tax_class_id'])){
	      $product['tax_class_id'] = $this->get_tax_class_from_rate($product['tax']);
	  }
	  if(!isset($tc_values[ $product['tax_class_id']])){
	      $tc_values[ $product['tax_class_id']] = 0;
	  }
	  $tc_values[ $product['tax_class_id']] += $product['final_price'];
	  $product_sum += $product['final_price'];
	  
	  if(!isset($this->tax)){
	      $this->tax = array();
	  }
	  if(!isset($this->tax[ $product['tax_class_id'] ])){
	      $this->tax[ $product['tax_class_id'] ] = $product['tax'];
	  }
	  
      }
      foreach($tc_values as $tcID=>$sum){
	  $tc_percentage[ $tcID ] = 100/$product_sum*$sum;
      }
      // BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
      /*if(yes_eu_oss_use_country_handling($this->delivery['country_id'])){
          $country_id = $this->delivery['country_id'];
          $zone_id = $this->delivery['zone_id'];
      }else{
          $country_id = STORE_COUNTRY;
          $zone_id = 0;
      }*/
      // EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
      
      // BUGF_CH_OSS
      $country_id = $this->delivery['country_id'];
      $zone_id = $this->delivery['zone_id'];
      
      foreach($this->tax as $tax_class_id=>$tr){
	  $return[] = array(
	      'tax_class_id'=>$tax_class_id,
	      'tax_rate'=>xtc_get_tax_rate($tax_class_id,$country_id, $zone_id),
	      'title'=> xtc_get_tax_description($tax_class_id,$country_id, $zone_id),
	      'percentage'=>$tc_percentage[ $tax_class_id ]
	  );
      }
      return $return;
  }
  public function get_tax_rates_for_nebenleistung($value){
      $tpd = $this->get_tax_proportional_distribution();
      $tax_values = array();
      foreach($tpd as $tr){
	  $_tax_rate = ($tr['tax_rate']+100)/100;
	  $anteil_brutto = ($value/100*$tr['percentage']);
	  $tr['amount'] = $anteil_brutto-($anteil_brutto/$_tax_rate);
	  $tax_values[] = $tr;
      }
      return $tax_values;
  }
  
  
  /**
   * Prueft ob der Auftrag ueber Warenausgabe (otc) abgewickelt wurde
   * 
   * @return int Anzahl Datensaetze (0 = keine otc Eintraege)
   */
  public function is_otc(){
      $query = xtc_db_query(sprintf(
              "SELECT otc_id FROM otc WHERE orders_id='%s'",
              $this->info['id']
      ));
      return xtc_db_num_rows($query);
  }
  
   
    private function process_shipping_orders_product($products,$row,$versender){
        $op_shipped_status = true;
        $qty_to_send = $products['qty']-$products['quantity_shipped']-$products['not_ship'];

        // DIE shipping_products_id WIRD IN
        // DER BESTANDSKLASSE BENOETIGT, UM
        // DIESE BEI EINEM FILIALTRANSFER IN
        // DER TABELLE storage_products_transfer
        // ZU SPEICHERN
        // SONST KANN SPAETER NICHT HERAUSGELESEN
        // WERDEN WELCHE TRANSFERS BEIM JEWEILIGEN
        // VERSANDDATENSATZ TATSAECHLICH STATTFANDEN
        $shipping_products_id = $this->insert_shippings_products($products['opID'],$qty_to_send,$row['id']);
        if($qty_to_send > 0){

            // KOMMENTAR IN HISTORY
            $collies = xtc_get_product_collies($products['id']);
            if(sizeOf($collies)>0){
                foreach($collies as $ck=>$colli){
                    $SQ = new products_quantity($colli['collie_products_id']);
                    $qty_total = $SQ->get_products_total_qty();
                    $new_qty = $qty_to_send*$colli['quantity'];
                    $comment = sprintf(HISTORY_ORDER_SEND,$this->info['id'],$new_qty);
                    if($qty_to_send != $products['qty']){
                        $comment .= ' '.TEXT_PART_DELIVERY;
                    }
                    $collie_comment = sprintf(HISTORY_SEND_COLLIES,$products['id'],$qty_total,$qty_total);
                    // NEU (09/2017): UEBERGABE DER shipping_products_id
                    $SQ->update_qty(-$new_qty, $SQ->get_default_storage_id(), $qty_total, $collie_comment,
                        'order',$this->info['id'],'Versand',$shipping_products_id
                    );
                }
                yes_add_products_history($products['id'], $comment = sprintf(HISTORY_ORDER_SEND,$this->info['id'],$products['qty']));
            }else{
                $SQ = new products_quantity($products['id']);
                $qty_total = $SQ->get_products_total_qty();
                $new_qty = $qty_to_send;
                $comment = sprintf(HISTORY_ORDER_SEND,$this->info['id'],$new_qty);
                if($qty_to_send != $products['qty']){
                    $comment .= ' '.TEXT_PART_DELIVERY;
                }
                // NEU (09/2017): UEBERGABE DER shipping_products_id
                $SQ->update_qty(-$new_qty, $SQ->get_default_storage_id(), $qty_total,$comment,
                                'order',$this->info['id'],'Versand',$shipping_products_id
                );
            }
        } // end if qty_to_send > 0
        // BOF - TEILLIEFERUNG HANDLING
        xtc_db_query(sprintf(
                "UPDATE orders_products SET not_ship=0 WHERE orders_products_id='%s'",
                $products['opID']
        ));
        $this->add_quantity_shipped($products['opID'],$qty_to_send,$row['id']);
        if( $products['qty'] != ($products['quantity_shipped'] + $qty_to_send) ){
            $op_shipped_status = false;
        }
        // EOF - TEILLIEFERUNG HANDLING
        return array(
            'op_shipped_status'=>$op_shipped_status,
        );
    }
    
    
    /**
     * ARTIKEL DURCHLAUFEN
     * quantity_shipped bei jeder opID setzen
     * mit $op_shipped_status pruefen ob alle Artikel
     * versendet sind. (true = alle versendet)
    
     * @param type $row
     * @param type $versender
     * @return array()
     */
    public function process_shipping($row,$versender){
        $op_shipped_status = true;
        foreach ($this->products as $k=>$products) {
            $status = $this->process_shipping_orders_product($products,$row,$versender);
            if(!$status['op_shipped_status']){
                $op_shipped_status = false;
            }
        } // ENDE ARTIKEL
        
        //
        // EBAY ADDON - COMPLETE SALE SENDEN
        // WIR SETZEN EIN FLAG UM DIE COMPLETE-SALE MELDUNGEN
        // ABARBEITEN ZU KOENNEN
        //
        $auctions = $this->get_auction_array(true); // incl orders_id
        for($ai=0;$ai<sizeOf($auctions);$ai++){
            $update_sql_array = array(
                    'shipped'=>1
            );
            xtc_db_perform('ebay_transactions',$update_sql_array,'update',sprintf(
                    "orders_id='%s' and ebayid='%s'",
                    $auctions[$ai]['orders_id'],
                    $auctions[$ai]['ebay_id']
            ));
        }
        
        $this->set_shipping_orders_status($op_shipped_status,$row);
        return array(
            'op_shipped_status'=>$op_shipped_status
        );
    }
    
    
    /**
     * Versendete Artikel im Versandabschluss
     * 
     * Ermittelt anhand der shipping_id welche Artikel versendet wurden und
     * gibt diese als Array zurueck
     * 
     * [shippings_products_id, shippings_id, products_id, source_products_id, quantity] 	
     * 
     * @param int $shipping_id
     * @return array
     */
    public function get_part_delivery_products( int $shipping_id ){
        $products = [];
        $query = xtc_db_query(sprintf(
                "SELECT * FROM shippings_products WHERE shippings_id='%d'",
                $shipping_id
        ));
        while($record = xtc_db_fetch_array($query)){
            $products[] = $record;
        }
        return $products;
    }
    
    /**
     * Versandabschluss: Auftragsstatus aktualisieren
     * 
     * Beim Versandabschluss Vorgang wird der Auftragsstatus aktualisiert. In 
     * Abhaengigkeit von Bezahlart und ob alle Artikel versendet wurden.
     * 
     * @param bool $op_shipped_status
     * @param array $row muss nur den parameter "versender" enthalten. Hat aber
     * auch shippings_id sofern es eben eine Teillieferung ist
     */
    public function set_shipping_orders_status(bool $op_shipped_status, array $row){
        $set_date_shipping_sql = ($op_shipped_status) ? ', date_shipping = now()' : '';
        // BOF - Teillieferung Artikel anzeigen - 2022/01/18
        $part_delivery_products = '';
        if(!$op_shipped_status){
            $affected_products = $this->get_part_delivery_products($row['shipping_id']);
            $part_delivery_products_arr = [];
            foreach($affected_products as $ap){
                $part_delivery_products_arr[] = sprintf("%dx pID %d",
                    $ap['quantity'], 
                    $ap['products_id']
                );
            }
            $part_delivery_products = ': '.implode(', ',$part_delivery_products_arr);
        }
        // EOF - Teillieferung Artikel anzeigen
            
        if(xtc_is_shipping_before_payment($this->info['payment_method'])){
            if($this->info['orders_status'] == ORDERS_STATUS_BEZAHLT){
                $new_status = ($op_shipped_status) ? ORDERS_STATUS_ABGESCHLOSSEN : $this->info['orders_status'];
                xtc_db_query("UPDATE orders SET orders_status='".$new_status."',last_modified=now() ".$set_date_shipping_sql." WHERE orders_id='".$this->info['id']."'");
                $comments = sprintf(HISTORY_ORDER_SHIPPED_SENDER,$row['versender']);
                if(!$op_shipped_status){
                    $comments .= ' '.TEXT_PART_DELIVERY.$part_delivery_products;
                }
                $this->add_history($new_status, false, $comments);
            }else{
                $new_status = ($op_shipped_status) ? ORDERS_STATUS_VERSENDET : $this->info['orders_status'];
                xtc_db_query("UPDATE orders SET orders_status='".$new_status."',last_modified=now()".$set_date_shipping_sql." WHERE orders_id='".$this->info['id']."'");
                $comments = sprintf(HISTORY_ORDER_SHIPPED_SENDER,$row['versender']);
                if(!$op_shipped_status){
                    $comments .= ' '.TEXT_PART_DELIVERY.$part_delivery_products;
                }
                $this->add_history($new_status, false, $comments);
            }
        }else{
            $new_status = ($op_shipped_status) ? ORDERS_STATUS_ABGESCHLOSSEN : $this->info['orders_status'];
            xtc_db_query("UPDATE orders SET orders_status='".$new_status."',last_modified=now()".$set_date_shipping_sql." WHERE orders_id='".$this->info['id']."'");
            $comments = sprintf(HISTORY_ORDER_SHIPPED_SENDER,$row['versender']);
            if(!$op_shipped_status){
                $comments .= ' '.TEXT_PART_DELIVERY.$part_delivery_products;
            }
            $this->add_history($new_status, false, $comments);
        }
    }
    
    public function process_shipping_amazon($versender,$AmazonHelper,$shippings_id){
        $amazon_items = $this->get_amazon_items();
        foreach($amazon_items as $amazon_item){
            $amazon_carrier = $AmazonHelper->get_amazon_carrier_from_yes_shipping($versender);
            // BOF - WIR HABEN DIE shippings_id - 06/2023
                // BUGFIX MARIO - shippings_id MUSS UNIQUE SEIN
                // DARUM BERECHNEN DER NAECHSTEN
                // $next_shipping_query = xtc_db_query(
                //         "SELECT MAX(shippings_id) as mxvalue FROM amazon_orders_products"
                // );
                // $next_shipping = xtc_db_fetch_array($next_shipping_query);
                // $next_shipping_id = $next_shipping['mxvalue']+1;
            $update_sql_array = array(
                'yes_shipping_status'=>1,
                'carrier_code'=>$amazon_carrier['carrier_code'],
                'shipping_method'=>$AmazonHelper->get_amazon_shipping_method_name($amazon_item['shipping_method_service_level']),
                'carrier_name'=>$amazon_carrier['carrier_name'],
                'shippings_id'=>$shippings_id
            );
            $where = sprintf("amazon_orders_products_id='%d'",
                $amazon_item['amazon_orders_products_id']
            );
            xtc_db_perform('amazon_orders_products',$update_sql_array,'update',$where);
        }
    }
    
    /**
     * es gibt szenarien in denen eine eBay Auktion doppelt eingelesen werden
     * bei dieser funktion wird geprueft ob es zu einer auktion/transaktion
     * mehrere eintraege in ebay_transactions gibt
     * Wenn es Datensaetze gibt die doppelt sind, wird folgendes Array zurueck
     * gegeben
     *          'ebay_id'=>...,
     *          'transaction_id'=>...,
     *          'detected_orders'=>array(...),
     *          'message'=>...
     *
     */
    public static function check_auction_transaction_exists( $orders_id, $ebay_id ){
        $return = array();
        if($ebay_id == ''){
            return $return;
        }
        $_doppelt_check_query = xtc_db_query(sprintf(
                "SELECT transactionid FROM ebay_transactions WHERE ebayid='%s' AND orders_id='%s'",
                $ebay_id, $orders_id
        ));
        if(!xtc_db_num_rows($_doppelt_check_query)){
            return $return;
        }
        $_doppelt_check = xtc_db_fetch_array($_doppelt_check_query);
        $_doppelt_check2_query = xtc_db_query(sprintf(
                "SELECT orders_id FROM ebay_transactions WHERE ebayid='%s' AND transactionid='%s'",
                $ebay_id, $_doppelt_check['transactionid']
        ));
        $chk_num = xtc_db_num_rows($_doppelt_check2_query);
        if($chk_num > 1){
            $detected_orders = array();
            while($_doppelt_check2 = xtc_db_fetch_array($_doppelt_check2_query)){
                $detected_orders[] = $_doppelt_check2['orders_id'];
            }
            $chk_comm = sprintf('Zur Auktion #%s gibt es %s Auftr&auml;ge mit identischer eBay Auktionsnummer / Transaktionsnummer (%s). Die Auftr&auml;ge sind: %s. Bitte pr&uuml;fen Sie den Vorgang.',
                    $ebay_id, $chk_num, 
                    $_doppelt_check['transactionid'],
                    implode(', ',$detected_orders)
            );
            $return = array(
                'ebay_id'=>$ebay_id,
                'transaction_id'=>$_doppelt_check['transactionid'],
                'detected_orders'=>$detected_orders,
                'message'=>$chk_comm
            );
        }
        return $return;
    }
    
    public function email($email_addresses, $language_id, yesSmarty $smarty, string $subject = '',bool $send_products_file_contents=false, $use_html = true){
        $needed_functions = array(
            'yes_get_shop_content','yes_get_shop_content_html_stripped',
            'xtc_get_customers_status_name','xtc_get_orders_ebay_seller',
            'xtc_get_ebay_seller_data','xtc_get_vpe_name',
            'xtc_get_short_description','xtc_get_ext_products_weight',
            'xtc_get_ext_products_weight_netto',
            'format_price','xtc_round','xtc_get_customers_status_export_note',
            'xtc_get_payment_method_title','xtc_date_long',
            'xtc_get_customers_status_delivery_conditions','yes_encode_string',
            'xtc_get_order_html_for_pdf','yes_get_order_teaser_html_for_pdf',
            'xtc_php_mail','xtc_format_price_order'
        );
        foreach($needed_functions as $f){
            if(!function_exists($f)){
                if(is_file(DIR_FS_INC.$f.'.inc.php')){
                    require_once(DIR_FS_INC.$f.'.inc.php');
                }else{
                    throw new Exception('order::email() Missing Function '.$f);
                }
            }
        }
        if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
            try{
                $pdf = new yes_pdf();
            }catch(Exception $ex){
                throw new Exception('order::email() Missing DOMPDF Class');
            }
        }else{
            try{
                $pdf=new HTML2FPDF();
            }catch(Exception $ex){
                throw new Exception('order::email() Missing HTML2PDF Class');
            }
        }
        $needed_classes = array(
            'DBmail'
        );
        foreach($needed_classes as $c){
            if(!class_exists($c)){
                throw new Exception('order::email() Missing Class '.$c);
            }
        }
		$payi = $this->get_paymentinstructions();
		if(sizeOf($this->get_paymentinstructions())){
		    $smarty->assign('PAYMENTINSTRUCTIONS',current($payi));
		}
		
		$smarty->assign('address_label_customer',xtc_address_format($this->customer['format_id'], $this->customer, 1, '', '<br>'));
		$smarty->assign('address_label_shipping',xtc_address_format($this->delivery['format_id'], $this->delivery, 1, '', '<br>'));
		$smarty->assign('address_label_payment',xtc_address_format($this->billing['format_id'], $this->billing, 1, '', '<br>'));
		$smarty->assign('csID',$this->customer['csID']);
		$smarty->assign('vatID',$this->customer['vat_id']);
		
		$conditions = '';
		$conditions_txt = '';
		$shop_content_data = yes_get_shop_content(3, $language_id,false);
		if (isset($shop_content_data['content_text']) and $shop_content_data['content_text']!=''){
                    $conditions = $shop_content_data['content_text'];
                    $conditions_txt = yes_get_shop_content_html_stripped($conditions);
		}

		// WIDERRUF
		$widerruf = '';
		$widerruf_txt = '';
		$shop_content_data = yes_get_shop_content(9, $language_id,false);
		if (isset($shop_content_data['content_text']) and $shop_content_data['content_text']!=''){
                    $widerruf = $shop_content_data['content_text'];
                    $widerruf_txt = yes_get_shop_content_html_stripped($widerruf);
		}
		
		$smarty->assign(array(
                    'cID'=>$this->customer['ID'],
                    'cgroup'=>  xtc_get_customers_status_name($this->info['status']),
                    'conditions'=>$conditions,
                    'widerruf'=>$widerruf,
                    'conditions_txt'=>$conditions_txt,
                    'widerruf_txt'=>$widerruf_txt
		));

		$ebay_seller = xtc_get_orders_ebay_seller($this->info['id']);
		if($ebay_seller != ''){
                    $smarty->assign('EBAY_SELLER_DATA',xtc_get_ebay_seller_data($ebay_seller));
                    $smarty->assign('EBAY_ID',$this->info['ebay_id']);
		}
		
		if( $this->info['orders_status'] == ORDERS_STATUS_STORNIERT) {
                    $smarty->assign('IS_STORNO','1');
		}
		
		// get products data
		if( $this->info['is_parent'] == 'n') {
                    $order_query=xtc_db_query("SELECT
                        products_id,
                        orders_products_id,
                        products_model,
                        products_name,
                        allow_tax,
                        products_tax,
                        final_price,
                        products_quantity
                        FROM ".TABLE_ORDERS_PRODUCTS."
                        WHERE orders_id='".$this->info['id']."'");
		}else{
                    $order_query=xtc_db_query("SELECT
                        op.products_id,
                        op.orders_products_id,
                        op.products_model,
                        op.products_name,
                        op.allow_tax,
                        op.products_tax,
                        op.final_price,
                        op.products_quantity
                        FROM ".TABLE_ORDERS_PRODUCTS." op, orders o 
                        WHERE o.parent_orders_id='".$this->info['id']."' && op.orders_id=o.orders_id");
		}
		$order_data=array();
		$xtPrice = $this->get_price_instance();
		$sum_netto = 0;
		while ($order_data_values = xtc_db_fetch_array($order_query)) {
			// EAN AUSLESEN
			$ean = '';
			$vpe = '';
			$ean_query = yes_db_query(sprintf("SELECT products_ean,products_vpe,products_vpe_status,products_vpe_value FROM products WHERE products_id='%s'",$order_data_values['products_id']),true);
			if($ean_query){
				$result = current($ean_query);
				$ean = $result['products_ean'];
				if ($result['products_vpe_status'] == 1 && $result['products_vpe_value'] != 0.0){
					$vpe = $xtPrice->xtcFormat($order_data_values['final_price']  * (1 / $result['products_vpe_value']), true).TXT_PER.xtc_get_vpe_name($result['products_vpe']);
				}
			}
		
			$order_data[]=array(
				'PRODUCTS_SHORT_DESCRIPTION' => xtc_get_short_description($order_data_values['products_id'],$language_id),
				'PRODUCTS_MODEL' => $order_data_values['products_model'],
				'PRODUCTS_EAN' => $ean,
				'PRODUCTS_VPE'=>$vpe,
				'PRODUCTS_NAME' => $order_data_values['products_name'],
				'PRODUCTS_PRICE' => $xtPrice->xtcFormat($order_data_values['final_price'], true),
				'PRODUCTS_SINGLE_PRICE' => $xtPrice->xtcFormat($order_data_values['final_price']/$order_data_values['products_quantity'], true),
				'PRODUCTS_TAX' => $order_data_values['products_tax'],
				'PRODUCTS_QTY' => $order_data_values['products_quantity'],
				'PRODUCTS_WEIGHT'=>  xtc_get_ext_products_weight($order_data_values['products_id'])*$order_data_values['products_quantity'],
                'PRODUCTS_WEIGHT_NETTO'=>xtc_get_ext_products_weight_netto($order_data_values['products_id'])*$order_data_values['products_quantity'],
			);
			
			if($order_data_values['allow_tax'] == '1' and $order_data_values['products_tax'] > 0){
				$sum_netto += format_price($order_data_values['final_price'], 0, $this->info['currency'], $order_data_values['allow_tax'], $order_data_values['products_tax']);
			}
		}
		// ZEIGE ZWISCHENSUMME NETTOSUMME WENN INCL STEUER
		if($sum_netto > 0){
			$smarty->assign('NETTOSUM',number_format(xtc_round($sum_netto,PRICE_PRECISION),2,',','').' '.$this->info['currency']);
		}
			
		// get order_total data
		$oder_total_query=xtc_db_query("SELECT
				title,
				text,
				class,
				value,
				sort_order
						FROM ".TABLE_ORDERS_TOTAL."
						WHERE orders_id='".$this->info['id']."'
						ORDER BY sort_order ASC");
		
		$order_total=array();
		
		$notax = 0;
		while ($oder_total_values = xtc_db_fetch_array($oder_total_query)) {
		
			$order_total[]=array(
				'TITLE' => $oder_total_values['title'],
				'CLASS'=> $oder_total_values['class'],
				'VALUE'=> $oder_total_values['value'],
				'TEXT' => $oder_total_values['text']);
			
			if ($oder_total_values['class']=='ot_total'){
				$total=$oder_total_values['value'];
			}
			if($oder_total_values['class']=='ot_subtotal_no_tax'){
				$notax = 1; // RE OHNE MWST
			}
		}
		// das muss kundengruppenabh. sein
		$export_note = xtc_get_customers_status_export_note($this->info['status'],$language_id);
		if($export_note != '')
			$smarty->assign('export_note',$export_note);
		
		// assign language to template for caching
		$smarty->assign('STORE', nl2br(STORE_NAME_ADDRESS));
		$smarty->assign('STORE_WRAP', STORE_WRAP);
		$smarty->assign('COMMENTS_VISIBLE', $this->info['comments_visible']);
		$smarty->assign('BANK', MODULE_PAYMENT_MONEYORDER_PAYTO);
		$language = yes_get_language_folder();
		$smarty->assign('language', $language);
		$smarty->assign('logo_path',HTTP_SERVER.'templates/'.CURRENT_TEMPLATE.'/img/');
		
		$o_ebayid = '';
		$in_auction_array = array();
		if($this->info['is_parent'] == 'y'){
			$all_ebay_query = xtc_db_query("SELECT ebay_id FROM orders WHERE parent_orders_id='".$this->info['id']."'");
			while($all_ebay = xtc_db_fetch_array($all_ebay_query)){
				$o_ebayid .= $all_ebay['ebay_id'].', ';
				$in_auction_array[] = $all_ebay['ebay_id'];
			}
			$o_ebayid = substr($o_ebayid,0,(strlen($o_ebayid)-2));
		}else{
			$o_ebayid .= $this->info['ebay_id'];
			$in_auction_array[] = $this->info['ebay_id'];
		}
		if($o_ebayid!=''){
			$o_ebayid = '<p><b>'.EBAY_ID.':</b> '.$o_ebayid.'</p>';
		}
		$smarty->assign('ORDERS_ID',$this->info['id']);
		if(sizeOf($in_auction_array)){
		    $smarty->assign(array(
                        'EBAY_ID_ARRAY'=>$in_auction_array,
                        'EBAY_PLUS'=>$this->info['ebay_plus']
                    ));
		}
		$smarty->assign('oID',$this->info['id'].$o_ebayid);
                if(defined('MODULE_OTHER_YES_HITMEISTER_API_STATUS') and MODULE_OTHER_YES_HITMEISTER_API_STATUS == 'True'){
                    if(!class_exists('yes_hitmeister')){
                        require_once(DIR_WS_CLASSES.'yes_hitmeister.php');
                    }
                    $hio = yes_hitmeister::get_hitmeister_id_order_from_orders_id($this->info['id']);
                    if($hio != ''){
                        $smarty->assign('HITMEISTER_ID_ORDER',$hio);
                    }
                }
		$smarty->assign('PAYMENT_METHOD',xtc_get_payment_method_title($this->info['payment_method']));
		$smarty->assign('PAYMENT_METHOD_RAW',$this->info['payment_method_db']);
		$smarty->assign('PAYMENT_CLASS_RAW',$this->info['payment_class_db']);


		$smarty->assign('DATE',xtc_date_long($this->info['date_purchased']));
	  	if($this->info['date_shipping'] > 0)
			$smarty->assign('DATE_SHIPPING',xtc_date_long($this->info['date_shipping']));
		$smarty->assign('order_data', $order_data);
		$smarty->assign('order_total', $order_total);
		$smarty->assign('skonto_values', $this->get_skonto());
		$delivery_conditions = xtc_get_customers_status_delivery_conditions($this->info['status'],$language_id);
		if(xtc_not_null($delivery_conditions)){
			$smarty->assign('DELIVERY_CONDITIONS',$delivery_conditions);
		}
		$smarty->assign('skonto_values',$this->get_skonto());

		// FIBUNUMBER ADDON
		$fibu_number = $this->get_fibunumber();
		if($fibu_number > 0){
			$smarty->assign('FIBU_NUMBER',$fibu_number);
		}
		$smarty->assign('ORDER_TYPE',$this->get_title($fibu_number));
		if(isset($_GET['oc'])){
			$smarty->assign('ORDER_TYPE',TEXT_ORDER_CONFIRMATION);
		}

		$smarty->assign('YESORDER',$this->get_order_positions($xtPrice));
		$smarty->assign('tpl_path',HTTP_SERVER.'templates/'.CURRENT_TEMPLATE.'/');
		if(defined('MODULE_OTHER_FIBUNUMBERS_STATUS') and MODULE_OTHER_FIBUNUMBERS_STATUS == 'True'){
			$fibu_date_query = yes_db_query(sprintf(
				"SELECT date_added FROM orders_fibunumbers WHERE orders_id='%s'",
				$this->info['id']
			));
			if(yes_db_num_rows($fibu_date_query)){
				$date = current($fibu_date_query);
				$smarty->assign('fibu_date',$date['date_added']);
			}
		}
		if($this->info['source_editor_id'] > 0){
		    $editor_data_query = xtc_db_query(sprintf(
			    "SELECT customers_firstname, customers_lastname,customers_telephone,customers_fax,mobile,customers_email_address FROM customers c WHERE customers_id='%s'",
			    $this->info['source_editor_id']
		    ));
		    $smarty->assign('EDITOR_DATA',xtc_db_fetch_array($editor_data_query));
		}
                if($use_html || !is_file(DIR_FS_CATALOG.DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.CURRENT_TEMPLATE . '/admin/mail/'.yes_get_language_folder().'/send_order.txt')){
                    $html_mail=$smarty->fetch(CURRENT_TEMPLATE . '/admin/mail/'.yes_get_language_folder().'/send_order.html');
                }else{
                    $html_mail=$smarty->fetch(CURRENT_TEMPLATE . '/admin/mail/'.yes_get_language_folder().'/send_order.txt');
                }
		// **** EMAILCLIENT - ADDON *****
		$dbMail = new DBmail('0');
                $order_email_subject_prefix = ($fibu_number > 0) ? TEXT_ORDER_FIBU_EMAIL_SUBJECT.$fibu_number : TEXT_ORDER_EMAIL_SUBJECT.$this->info['id'];
                
		$subject = ($subject != '') ? xtc_db_prepare_input(yes_encode_string($subject)) : $order_email_subject_prefix.(($this->info['ebay_id']!='') ? ' ('.$this->info['ebay_id'].')':'');
                $spf_comments = '';
                if($send_products_file_contents){
                    $spf_comments = " [Artikel-Dateien wurden mitgesendet]";
                }
		foreach($email_addresses as $ea){
		    $dbMail->save_mail($subject,$ea,EMAIL_BILLING_REPLY_ADDRESS_NAME,EMAIL_BILLING_REPLY_ADDRESS,$html_mail."<br /><br />".$spf_comments,date('Y-m-d H:i:s'), $this->info['ebay_id'],$this->customer['ID'],$this->info['id']);
		    $comments = sprintf(HISTORY_ORDER_EMAIL,$ea).$spf_comments;
		    $this->add_history($this->info['orders_status'], true, $comments);
		}


		$pdf_name = '';
		if(PDF_EMAILS == 'True'){
			// GENERIERE RECHNUNG-PDF
			$pdf_smarty = new yesSmarty;
			$pdf_html = xtc_get_order_html_for_pdf($this,$pdf_smarty,CURRENT_TEMPLATE . '/admin/mail/'.yes_get_language_folder().'/pdf_order.html');
            if(!empty($fibu_number)){
                $pdf_name = \main::get_exportdata_path().sprintf('%s_%s.pdf',
                    $this->get_title($fibu_number),
                    $fibu_number
                );
            }else{
                $pdf_name=\main::get_exportdata_path().sprintf('%s_%s.pdf',
                    $this->get_title($fibu_number),
                    $this->info['id']
                );
            }
            $er = error_reporting();
            error_reporting(E_ERROR);
			if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
			    $pdf = new yes_pdf();
			    if(DOMPDF_ORDER_LANDSCAPE == 'True'){
    				$pdf->set_landscape();
			    }
			    $pdf->set_html($pdf_html);
			    $pdf->save($pdf_name);
			}else{
			    $pdf=new HTML2FPDF();
			    $pdf->AddPage();
			    $pdf->WriteHTML($pdf_html);
			    $pdf->Output($pdf_name,$dest='F'); //Read the FPDF.org manual to know the other options
			}
			error_reporting($er);
		}
		$teaser_pdf_name = '';
		if(PDF_TEASER_IN_ORDERS == 'true'){
			$pdf_teaser_smarty = new yesSmarty;
			$pdf_teaser_html = '';
			$pdf_teaser_html=yes_get_order_teaser_html_for_pdf($this,$pdf_teaser_smarty,CURRENT_TEMPLATE . '/admin/pdf_ordered_products.html');
			if($pdf_teaser_html != ''){
				$teaser_pdf_name = \main::get_exportdata_path().TEXT_ORDER.'_'.$this->info['id'].'_ARTIKEL.pdf';
                $er = error_reporting();
                error_reporting(E_ERROR);
				if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
				    $pdf = new yes_pdf();
				    $pdf->set_html($pdf_teaser_html);
				    $pdf->save($teaser_pdf_name);
				}else{
				    $teaser_pdf=new HTML2FPDF();
				    $teaser_pdf->AddPage();
				    $teaser_pdf->WriteHTML($pdf_teaser_html);
				    $teaser_pdf->Output($teaser_pdf_name,'F'); //Read the FPDF.org manual to know the other options
				}
        			error_reporting($er);
			}
		}
		$attachments_array = array();
		if($pdf_name != ''){
		    $attachments_array[] = $pdf_name;
		}
		if($teaser_pdf_name != ''){
		    $attachments_array[] = $teaser_pdf_name;
		}
		if(isset($_REQUEST['attachment']) and sizeOf($_REQUEST['attachment'])){
		    $mod_att = new module_attachments('order', $this->info['id']);
		    foreach($_REQUEST['attachment'] as $file_att){
			   $att_info = $mod_att->get_attachment_info($file_att);
			   $attachments_array[] = $att_info['path'];
		    }
		}
                
                if($send_products_file_contents){
                    foreach($this->get_products_content_files() as $pID => $files){
                        foreach($files as $file_path=>$desc){
                            $attachments_array[] = DIR_FS_CATALOG.$file_path;
                        }
                    }
                }
                $email_address = array_shift($email_addresses);
                // durch array shirt wird das erste element entfernt, also die
                // haupt emailadresse
                $additional_email_addresses = implode(',',$email_addresses);
                xtc_php_mail(EMAIL_BILLING_REPLY_ADDRESS, EMAIL_BILLING_REPLY_ADDRESS_NAME, $email_address, $email_address, $additional_email_addresses, EMAIL_BILLING_REPLY_ADDRESS, EMAIL_BILLING_REPLY_ADDRESS_NAME, $attachments_array, '', $subject, $html_mail,'');
                
		
		if(PDF_EMAILS == 'True'){
			unlink($pdf_name);
		}
		if(PDF_TEASER_IN_ORDERS == 'true' and $teaser_pdf_name != ''){
			unlink($teaser_pdf_name);
		}
                return $comments;
    }
    public static function get_hitmeister_data($orders_id){
        $query = xtc_db_query(sprintf(
                "SELECT * FROM hitmeister_orders WHERE orders_id='%s'",
                $orders_id
        ));
        return xtc_db_fetch_array($query);
    }
    
    public static function get_hitmeister_products_data($hitmeister_orders_id){
        $query = xtc_db_query(sprintf(
                "SELECT * FROM hitmeister_orders_units WHERE hitmeister_orders_id='%s'",
                $hitmeister_orders_id
        ));
        $hitmeister_products = array();
        while($record = xtc_db_fetch_array($query)){
            $hitmeister_products[] = $record;
        }
        return $hitmeister_products;
    }
    
    private static function get_secupay_transaction_id_from_orders_id($orders_id){
        $query = xtc_db_query(sprintf(
                "SELECT * FROM secupay_transaction_order WHERE ordernr='%s'",
                $orders_id
        ));
        if(xtc_db_num_rows($query)){
            $record = xtc_db_fetch_array($query);
            return $record['transaction_id'];
        }
        return '';
    }
    
    public function get_secupay_transaction_ids(){
        $array = array();
        $q = xtc_db_query("SHOW TABLES LIKE 'secupay_transaction_order'");
        if(!xtc_db_num_rows($q)){
            return $array;
        }
        $tid = $this->get_secupay_transaction_id_from_orders_id($this->info['id']);
        if($tid != ''){
            $array[] = $tid;
        }
        foreach($this->get_child_orders() as $child_order){
            $tid = $this->get_secupay_transaction_id_from_orders_id($child_order['orders_id']);
            if($tid != ''){
                $array[] = $tid;
            }
        }
        return $array;
    }
    
    public function has_current_tax_failure(){
        $diff_tax = array();
        foreach($this->products as $p){
            if($p['tax'] == 0){
                continue;
            }
            $tax_chk = number_format($p['tax'],1,'.','');
            if(!in_array($tax_chk, $diff_tax)){
                $query = xtc_db_query(sprintf(
                        "SELECT tax_rates_id FROM tax_rates WHERE tax_rate = '%s'",
                        $tax_chk
                ));
                if(!xtc_db_num_rows($query)){
                    return true;
                }
                $diff_tax[] = $tax_chk;
            }
        }
        foreach($this->totals as $t){
            if($t['class'] != 'ot_tax'){
                continue;
            }
            if($t['tax_rate_percent'] == 0){
                continue;
            }
            $tax_chk = number_format($t['tax_rate_percent'],1,'.','');
            if(!in_array($tax_chk, $diff_tax)){
                $query = xtc_db_query(sprintf(
                        "SELECT tax_rates_id FROM tax_rates WHERE tax_rate = '%s'",
                        $tax_chk
                ));
                if(!xtc_db_num_rows($query)){
                    return true;
                }
                $diff_tax[] = $tax_chk;
            }
        }
        return false;
    }
    
    /**
     * FSK18 Artikel enthalten?
     * 
     * Prueft die Artikel der Bestellung ob FSK18 Artikel enthalten sind.
     * Beruecksichtigt Collis
     * Wird der Parameter opID uebergeben, wird zu einem einzelnen Artikel
     * des Auftrags geprueft
     * 
     * @return bool
     */
    public function has_FSK18_products( int $opID = null){
        foreach($this->products as $op){
            if($opID !== null && $opID != $op['opID']){
                continue;
            }
            if($op['qty']<=$op['quantity_shipped']){
	            continue;
            }
            $check_products = array($op['id']);
            $collies = xtc_get_product_collies($op['id']);
            foreach($collies as $c){
                $check_products[] = $c['collie_products_id'];
            }
            $query = xtc_db_query(sprintf(
                    "SELECT COUNT(products_id) as anz FROM `%s` WHERE products_id IN(%s) AND products_fsk18=1",
                    TABLE_PRODUCTS,
                    implode(',',$check_products)
            ));
            $record = xtc_db_fetch_array($query);
            if($record['anz']>0){
                return true;
            }
        }
        return false;
    }

    public function get_order_language_id(){
        $order_language_id = (isset($_SESSION['languages_id']))?$_SESSION['languages_id']:2;
        foreach(xtc_get_languages() as $lang){
            if($lang['directory'] == $this->info['language']){
                $order_language_id = $lang['id'];
            }
        }
        return $order_language_id;
    }
    
    public function get_products_content_files(){
        $order_products_files = array();
        foreach ($this->products as $products) {
            $items = \YES4Trade\Model\products_content::get_by_products_id(intval($products['id']));
            foreach($items as $it){
                $pcd = \YES4Trade\Model\products_content_description::get_by_content_id_and_language_id(intval($it->content_id),intval($this->get_order_language_id()));
                $order_products_files[$products['id']][$it->content_file] = $pcd->content_name;
            }
        }
        return $order_products_files;
    }
    
    public function check_low_order_fee(){
        $ok = true;
        $fee = 0;
        $total = 0;
        foreach($this->totals as $ot){
            switch($ot['class']){
                case 'ot_loworderfee':
                    $fee = $ot['value'];
                    break;
                case 'ot_total':
                    $total = $ot['value'];
                    break;
            }
        }
        if($fee > 0){
            if(MODULE_ORDER_TOTAL_LOWORDERFEE_ORDER_UNDER <= $total){
                $ok = false;
            }
        }
        return $ok;
    }
    
    /**
     * HAT 1 STUNDE VERSANDSPERRE?
     * 
     * PRUEFT OB DER AUTRAG EBAY TRANSAKTIONEN ENTHAELT DIE 1 STUNDE VERSANDSPERRE
     * HABEN WEIL SIE GERADE ERST EINGELESEN WURDEN
     * 
     * @return boolean
     */
    public function get_allow_shipping_ebay_1_hour_active(){
        if( sizeOf($this->get_auction_array()) < 1 ){
            return false;
        }
        $return = true;
        foreach($this->get_auction_array() as $ebay_id){
            if(strtotime($this->info['date_purchased'])+(60*60) < time()  ){
                $return = false;
            }
        }
        return $return;
    }
    
    /**
     * Anzahl Minuten nach Kauf
     * 
     * Gibt die Anzahl der Minuten zurueck die nach Anlage eines eBay Auftrags
     * noch verbleiben bis eine Stunde rum ist
     * 
     * @return int Minuten Restzeit
     */
    public function get_allow_shipping_ebay_1_hour_active_duration(){
            $rest = time() - (strtotime($this->info['date_purchased'])+(60*60));
            return (int)(-$rest/60);
    }
    
    public function update_allow_shipping_ebay_1_hour_active( int $status ){
        $update_sql_array = array(
            'allow_shipping_ebay_1_hour'=>$status
        );
        xtc_db_perform(TABLE_ORDERS,$update_sql_array, 'update',"orders_id='".$this->info['id']."'");
        $this->add_history($this->info['orders_status'], false, 'eBay 1 Stunden Sperre: '.$status);
    }
    
    public function update_default_shipper( string $shipper_profile ){
        $update_sql_array = [
            'versender'=>$shipper_profile,
            'last_modified'=>'now()'
        ];
        xtc_db_perform(TABLE_ORDERS,$update_sql_array,'update',"orders_id='".$this->info['id']."'");
        $this->add_history($this->info['orders_status'], false, 'Versender Vorgabe: '.$shipper_profile);
    }

	public static function get_orders_status(int $orders_id):int|null{
		$query = yes_query(sprintf(
			"SELECT orders_status FROM %s WHERE orders_id=:id",
				TABLE_ORDERS
			),[
				'id'=>$orders_id
			],true
		);
		if($query === false){
			return null;
		}
		return intval($query['orders_status']);
	}

    public function get_un_score():float{
        $score = 0;
        $positions = $this->get_order_positions();
        foreach($positions['POSITIONS'] as $pos){
            if($pos['PRODUCTS_ID'] < 1){
                continue;
            }
            $puc = \YES4Trade\Model\product_un_classification::get_by_products_id($pos['PRODUCTS_ID']);
            if($puc === null){
                continue;
            }
            $bk = \YES4Trade\Enums\Bk::fromName($puc->Bk);
            $bk_value = intval($bk->value);
            if($bk_value == 4){
                continue;
            }
            $faktor = $bk->multiplikator();
            $weight = (floatval($pos['OWN_WEIGHT_TOTAL'])>0)?floatval($pos['OWN_WEIGHT_TOTAL']):floatval($pos['TOTAL_WEIGHT']);
            $score += ($faktor*$weight);
        }
        return round($score,2);
    }
    
}
