<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of order_product_serials
 *
 * @author mario
 */
require_once(realpath(dirname(__FILE__)).'/product.php');
require_once(realpath(dirname(__FILE__)).'/order_product_serial.php');

class order_product_serials {
    var $orders_products_id;
    var $serials = array();
    
    public function getOrders_products_id() {
	return $this->orders_products_id;
    }

    public function setOrders_products_id($orders_products_id) {
	$this->orders_products_id = $orders_products_id;
    }

    public function getSerials( $serial_pid = -1 ) {
	if($serial_pid >= 0){
	    $return = array();
	    foreach($this->serials as $serial){
		if($serial->getProducts_id() == $serial_pid){
		    $return[] = $serial;
		}
	    }
	    return $return;
	}
	return $this->serials;
    }

    public function addSerial(order_product_serial $serial,$i=-1) {
	if($i >= 0){
	    $this->serials[$i] = $serial;
	}else{
	    $this->serials[] = $serial;
	}
    }

    function __construct($orders_products_id){
	$this->setOrders_products_id($orders_products_id);
	$this->get_saved_serials();
    }
    
    public function get_saved_serials(){
	$query = xtc_db_query(sprintf(
		"SELECT orders_products_serials_id FROM orders_products_serials WHERE orders_products_id='%s'",
		$this->getOrders_products_id()
	));
	while($record = xtc_db_fetch_array($query)){
	    $serial = new order_product_serial($record['orders_products_serials_id']);
	    $this->addSerial($serial);
	}
    }
    
    public function get_input_fields( $qty,$available_sn = array()){
	$return = array();
	$array = array();
	foreach($this->getSerials() as $serial){
	    if(!isset($array[$serial->getProducts_id()])){
		$array[$serial->getProducts_id()] = array(
		    'INPUT_AVAILABLE_SN'=>array(),
		    'saved'=>array(),
		    'orders_products_serials_id'=>$serial->getOrders_products_serials_id(),
		    'sn_per_qty'=>0
		);
	    }
	    $array[$serial->getProducts_id()]['saved'][] = array(
		'serial_number'=>$serial->getSerial_number(),
		'serial_status'=>$serial->getSerial_status()
	    );
	}
	foreach($array as $pID=>$data){
	    $array[$pID]['sn_per_qty'] = sizeOf($data['saved']) / $qty;
	    if($array[$pID]['sn_per_qty'] > 1)
		$available_options = array();
	    else
		$available_options = array(array('id'=>'','text'=>TEXT_SELECT));
	    $available = $this->getAvailable_serials( $pID );
	    foreach($available as $av){
		$available_options[] = array('id'=>$av,'text'=>$av);
	    }
	    if($array[$pID]['sn_per_qty'] > 1)
		$multi = ' multiple="multiple" size="6"';
	    else
		$multi = '';
	    $array[$pID]['INPUT_AVAILABLE_SN'] = xtc_draw_pull_down_menu('ops_av_sn['.$pID.']',$available_options,'','id="'.$pID.'" '.$multi);
	}
	return $array;
    }
    
    public function get_input_fields_remove( $qty ){
	$return = array();
	$array = array();
	foreach($this->getSerials() as $serial){
	    if(!isset($array[$serial->getProducts_id()])){
		$array[$serial->getProducts_id()] = array(
		    'INPUT_REMOVABLE_SN'=>array(),
		    'orders_products_serials_id'=>$serial->getOrders_products_serials_id(),
		    'sn_per_qty'=>0
		);
	    }
	}
	foreach($array as $pID=>$data){
	    $removable = $this->getSerials($pID);
	    $array[$pID]['sn_per_qty'] = sizeOf($removable) / $qty;
	    if($array[$pID]['sn_per_qty'] > 1)
		$removable_options = array();
	    else
		$removable_options = array(array('id'=>'','text'=>TEXT_SELECT));
	    foreach($removable as $rv){
		$removable_options[] = array('id'=>$rv->getSerial_number(),'text'=>$rv->getSerial_number());
	    }
	    if($array[$pID]['sn_per_qty'] > 1)
		$multi = ' multiple="multiple" size="6"';
	    else
		$multi = '';
	    $array[$pID]['INPUT_REMOVABLE_SN'] = xtc_draw_pull_down_menu('ops_rv_sn['.$pID.']',$removable_options,'','id="'.$pID.'" '.$multi);
	}
	return $array;
    }
    
    public function is_serial_saved($sn,$serial_products_id){
	$query = xtc_db_query(sprintf(
		"SELECT serial_number FROM orders_products_serials WHERE orders_products_id='%s' AND serial_number='%s' AND products_id='%s'",
		$this->getOrders_products_id(),$sn,$serial_products_id
	));
	return xtc_db_num_rows($query);
    }
    
    public function products_serial_exists($pID,$sn){
	$query = xtc_db_query(sprintf(
		"SELECT serial_number FROM products_serials WHERE products_id='%s' AND serial_status='0' and serial_number='%s'",
		$pID,$sn
	));
	return xtc_db_num_rows($query);
    }
    
    public function getAvailable_serials($pID){
	$available_sn = array();
	$product = new product($pID);
	if($product->info['serial_numbers'] === 0)
	    return $available_sn;
	$free_sn = $product->get_free_serial_numbers();
	foreach($free_sn as $fsn){
	    $available_sn[] = $fsn['serial_number'];
	}
	return $available_sn;
    }
}
