<?php
require_once(DIR_FS_CATALOG.'admin/includes/classes/paketliste_pdf_products.php');
require_once(DIR_FS_CATALOG.'admin/includes/classes/paketliste_pdf_product.php');
require_once(DIR_FS_CATALOG.'admin/includes/classes/paketliste_pdf_product_storages.php');
require_once(DIR_FS_CATALOG.'admin/includes/classes/paketliste_pdf_product_storage.php');
class yes_paketliste_pdf
{
    var $pre_write_mode = false;
    var $process_shipping_id_array=array();
    var $filter_sql_status = 0; // wird im sql verwendet
    var $filter_sql_csv_status = 0; // wird im sql verwendet
    var $filter_sql_pdf_status = 0; // wird im sql verwendet
    var $filter_sql_order_by = 'customers_id'; // wird im sql verwendet
    var $flag_shipper = false;
    
    var $filter_sql_shipper = '';
    var $filename = '';
    var $products_array = array();
    var $total_number_of_products = 0;
    var $distinct_number_of_products = 0;
    var $ppdf_products;
    var $debug_html = false;
    var $missing_products = []; //prewrite mode, artikel die keinen bestand haben
    var $debug = false;
    var $V2 = false;
    
    function __construct() {
        
    }
    public function getFlag_shipper() {
        return $this->flag_shipper;
    }

    public function setFlag_shipper($flag_shipper) {
        $this->flag_shipper = $flag_shipper;
    }

    public function getFilter_sql_shipper() {
        return $this->filter_sql_shipper;
    }

    public function setFilter_sql_shipper($filter_sql_shipper) {
        $this->filter_sql_shipper = $filter_sql_shipper;
    }


    public function getPre_write_mode() {
        return $this->pre_write_mode;
    }

    public function setPre_write_mode($pre_write_mode) {
        $this->pre_write_mode = $pre_write_mode;
    }

    public function getProcess_shipping_id_array() {
        return $this->process_shipping_id_array;
    }

    public function setProcess_shipping_id_array($process_shipping_id_array) {
        $this->process_shipping_id_array = $process_shipping_id_array;
    }

    public function getFilter_sql_status() {
        return $this->filter_sql_status;
    }

    public function setFilter_sql_status($filter_sql_status) {
        $this->filter_sql_status = $filter_sql_status;
    }

    public function getFilter_sql_csv_status() {
        return $this->filter_sql_csv_status;
    }

    public function setFilter_sql_csv_status($filter_sql_csv_status) {
        $this->filter_sql_csv_status = $filter_sql_csv_status;
    }

    public function getFilter_sql_pdf_status() {
        return $this->filter_sql_pdf_status;
    }

    public function setFilter_sql_pdf_status($filter_sql_pdf_status) {
        $this->filter_sql_pdf_status = $filter_sql_pdf_status;
    }

    public function getFilter_sql_order_by() {
        return $this->filter_sql_order_by;
    }

    public function setFilter_sql_order_by($filter_sql_order_by) {
        $this->filter_sql_order_by = $filter_sql_order_by;
    }

    public function getFilename() {
        return $this->filename;
    }

    public function setFilename($filename) {
        $this->filename = $filename;
    }

    public function getProducts_array() {
        return $this->products_array;
    }

    public function setProducts_array($products_array) {
        $this->products_array = $products_array;
    }

    public function getTotal_number_of_products() {
        return $this->total_number_of_products;
    }

    public function setTotal_number_of_products($total_number_of_products) {
        $this->total_number_of_products = $total_number_of_products;
    }
    
    function getDebug_html() {
        return $this->debug_html;
    }

    function setDebug_html($debug_html) {
        $this->debug_html = $debug_html;
    }

    function getDistinct_number_of_products() {
        return $this->distinct_number_of_products;
    }

    function setDistinct_number_of_products($distinct_number_of_products) {
        $this->distinct_number_of_products = $distinct_number_of_products;
    }

    /** 
     * VERALTET IN v2 
     * WIRD BEREITS IN process_v2 BERECHNET
     * **/
    private function process_ppdf_product($products_id,$qty,$opID,$shippings_products=array(),$stklisten_id=0){
        if(!$this->ppdf_products->product_exists($products_id)){
            $this->ppdf_products->add( $products_id );
        }
        $ppdf_product = $this->ppdf_products->get( $products_id );

        if($this->getPre_write_mode()){
            $ppdf_product->add_quantity( $qty );
        }else{
                if(sizeOf($shippings_products)){
                        foreach($shippings_products as $shp){
                            $multiplicator = 1; // NORMALE ARTIKEL
                            if($stklisten_id > 0){
                                $collies = xtc_get_product_collies($stklisten_id);
                                foreach($collies as $colli){
                                    if($colli['collie_products_id'] == $products_id){
                                        $multiplicator = $colli['quantity'];
                                    }
                                }
                            }
                            if($shp['source_products_id'] == $opID){
                                $ppdf_product->add_quantity( $shp['quantity']*$multiplicator );
                            }
                        }
                }
        }
        return $ppdf_product;
    }
    
    public function get_order_products($shipping){
        if($this->debug === True){
            printf("[%s] \tget_order_products(%d)\r\n",
                    date('H:i:s'),$shipping['id']
            );
        }
        $order = new order($shipping['orders_id']);
        $shippings_products = yes_get_shippings_products($shipping['id']);
        foreach($order->products as $product){
	    $collies = $this->get_collies($product['id']);
            if(sizeOf($collies)){
                foreach($collies as $colli){
                    $qty = $colli['quantity']*($product['qty']-$product['quantity_shipped']-$product['not_ship']);
                    $stklisten_id = $product['id'];
                    $ppdf_product = $this->process_ppdf_product($colli['collie_products_id'],
                        $qty,$product['opID'],$shippings_products,$stklisten_id
                    );
                    // zusaetzlich enthalten die tp Eintraege nun is_colli und
                    // die collie_products_id
                    $tp = $order->get_transferred_places($colli['collie_products_id'],'Versand',true);
                    if(sizeOf($tp)){
                        $ppdf_product->addStorages_array($tp);
                    }
                }
            }else{
                $qty = $product['qty']-$product['quantity_shipped']-$product['not_ship'];
                if($this->debug === True){
                    printf("[%s] \t\tpID %s: %d Stk (%d bereits versendet)\r\n",
                            date('H:i:s'),
                            $product['id'],
                            $qty,
                            sizeOf($shippings_products)
                    );
                }
                $ppdf_product = $this->process_ppdf_product($product['id'],
                    $qty,$product['opID'],$shippings_products
                );
                // in der tabelle storage_products_transfer nachsehen, ob ein
                // lagerplatz transfer stattfand
                $tp = $order->get_transferred_places($product['id'],'Versand');
                if(sizeOf($tp)){
                    if($this->debug === True){
                        printf("[%s] \t\tpID %s: Es gab Lagerplatzbuchungen beim Versandabschluss\r\n",
                                date('H:i:s'),
                                $product['id']
                        );
                    }
                    $ppdf_product->addStorages_array($tp);
                }
            }
        }
    }
    
    private function get_reclamation_products($shipping){
	$reclamation = new reclamation($shipping['reclamations_id']);
        foreach($reclamation->products as $product){
            if(!$this->ppdf_products->product_exists($product['id'])){
                $this->ppdf_products->add( $product['id'] );
            }
            $ppdf_product = $this->ppdf_products->get( $product['id'] );
            $ppdf_product->add_quantity( $product['qty'] );
	    $collies = $this->get_collies($product['id']);
	    if(sizeOf($collies)){
		$tp = array();
		foreach($collies as $colli){
		    // zusaetzlich enthalten die tp Eintraege nun is_colli und
		    // die collie_products_id
		    $tp = array_merge($tp,$reclamation->get_transferred_places($colli['collie_products_id'],'Versand',true));
		}
	    }else{
                $tp = $reclamation->get_transferred_places($product['id'],'Versand');
	    }
            if(sizeOf($tp)){
                $ppdf_product->addStorages_array($tp);
            }
            /*
            if(!isset($this->products_array[ $product['id'] ])){
                    $this->products_array[ $product['id'] ] = array(
                            'qty'=>0,
                            'storages'=>array()
                    );
            }
            $this->products_array[ $product['id'] ]['qty'] += $product['qty'];
            $this->products_array[ $product['id'] ]['storages'] = xtc_array_merge(
                    $this->products_array[ $product['id'] ]['storages'],
                    $reclamation->get_transferred_places($product['id'],'Versand')
            );
            $this->total_number_of_products += $product['qty'];
            */
            
        }
    }
    
    
    
    function get_export_data(string $source_sort='products'){
        // source_sort ist auf 'storages' beim Versandabschluss
        // im pre_write_modus ist der Wert bei 'products'
	$SQ_ARRAY = array(); // DOPPEL INITS VERMEIDEN
        $products_array = array();
        $missing = array();
	if($this->ppdf_products->count() < 1){
            if($this->debug === True){
                printf("[%s] function get_export_data() has no products\r\n",date('H:i:s'));
            }
            return array();
        }
	
	if($source_sort == 'storages'){
	    $storages_return_array = array();
	}
        foreach($this->ppdf_products->products as $pID => $ppdf_product){
		$storage_allocated_qty = 0;
		$storage_allocated_array = array();
		$collies = $this->get_collies($pID);
                $qty = $ppdf_product->getQty();
                
                if($qty < 1) {
                    continue;
                }
                $this->total_number_of_products += $qty;
                $this->distinct_number_of_products++;
                if(!$this->getPre_write_mode()){
                    $transfer_places = $ppdf_product->get_transfer_places();
		    foreach($transfer_places as $trp){
			// negieren, denn der quantity Wert entspricht zb -2 ... also wurden
			// 2 Stk abgebucht
			$storage_allocated_qty += -$trp['quantity']; 
		    }
                }else{
                    $transfer_places = array();
                    
		    $storage_data = $ppdf_product->get_default_storage_data($collies);
		    $storage_str = $this->get_default_storage_string($storage_data);
		}
                $products_model_query = xtc_db_query(sprintf("SELECT products_model,products_image,products_weight,products_ean FROM products WHERE products_id='%s'",$pID));
                $products_model = xtc_db_fetch_array($products_model_query);
                $distributor_info = $this->get_distributor_info($pID);
                
		$pi_src = $this->get_products_image_link($products_model['products_image']);
		if(!isset($SQ_ARRAY[$pID])){
		    $SQ_ARRAY[$pID] = new products_quantity($pID);
		}
                $_products_array = array(
		    'products_id'=>$pID,
		    'qty'=>$qty,
		    'PHYSICAL_QTY'=>$SQ_ARRAY[$pID]->get_gesamtbestand_qty(),
		    'products_model'=>$products_model['products_model'],
                    'products_ean'=>$products_model['products_ean'],
		    'products_name'=>xtc_get_products_name($pID),
		    'distributor_name'=>$distributor_info['name'],
		    'distributor_products_number'=>$distributor_info['number'],
		    'products_image'=>$products_model['products_image'],
		    'products_image_src'=>$pi_src,
		    'weight'=>number_format($products_model['products_weight'],2,',','.'),
		    'total_weight'=>number_format($products_model['products_weight']*$qty,2,',','.'),
		    'PRODUCTS_STORAGES'=>$storage_str??'', // fuer prewrite mode
            'PRODUCTS_STORAGES_ARRAY'=>$storage_data??[],
		    'PRODUCTS_STORAGES_ALLOCATED'=>$storage_allocated_array??[] // fuer non prewrite
        );
		switch($source_sort){
                    case 'storages':
                        //printf('<li>%s: %s %s',$pID,$qty,$storage_allocated_qty);
                        // NACH VERSANDABSCHLUSS
                        $storages_return_array[] = $this->get_storages_return_array($transfer_places,$_products_array,$qty,$storage_allocated_qty);
                        break;
                    default:
                        $products_array[] = $_products_array;
                        break;
		}
        }
        $storage_groups = array();
        switch($this->getPre_write_mode()){
            case False:
                foreach($storages_return_array as $nr=>$storage){
                    foreach($storage as $storage_id=>$places){
                        // oder ist der storage_name bereits in $places vorhanden?
                        $storage_name = ($storage_id > 0) ? xtc_get_storage_name($storage_id) : TEXT_MAIN_STORAGE.' / Unzugewiesen';
                        if(!isset($storage_groups[$storage_id])){
                            $storage_groups[$storage_id] = array(
                                'places'=>array(),
                                'title'=>$storage_name
                            );
                        }
                        foreach($places['places'] as $place_title=>$place){
                            if(!isset($storage_groups[$storage_id]['places'][$place_title])){
                                $storage_groups[$storage_id]['places'][$place_title] = array(
                                    'place_title'=>$place_title,
                                    'products'=>array()
                                );
                            }
                            foreach($place['products'] as $prod){
                                $storage_groups[$storage_id]['places'][$place_title]['products'][] = $prod;
                            }
                        }
                    }
                }
                break;
            default:
                foreach($products_array as $nr=>$product){
                    if(!isset($storage_groups[0])){
                        $storage_name = TEXT_MAIN_STORAGE.' / Unzugewiesen';
                        $place_title = 'Lagerpl&auml;tze';
                        $storage_groups[ 0 ] = array(
                            'places'=>array(),
                            'title'=> $storage_name
                        );
                        $storage_groups[ 0 ]['places'][ $place_title/*$place['storage_places_id']*/ ] = array(
                            'place_title'=>$place_title,
                            'products'=>array()
                        );
                    }
                    $stammlager_included = false;
                    foreach($product['PRODUCTS_STORAGES_ARRAY'] as $psa){
                        if($psa['storage_id'] == 0){
                            $stammlager_included = true;
                        }
                        if(!isset($storage_groups[ $psa['storage_id'] ])){
                            $storage_name = xtc_get_storage_name($psa['storage_id']);
                            if($storage_name == ''){
                                $storage_name = 'No Name';
                            }
                            $storage_groups[ $psa['storage_id'] ] = array(
                                'places'=>array(),
                                'title'=> $storage_name
                            );
                        }
                        foreach($psa['places'] as $place){
                            if($place['product_place_quantity'] < 1){
                                continue;
                            }
                            $product_copy = $product;
                            unset($product_copy['PRODUCTS_STORAGES_ARRAY']);
                            unset($product_copy['PRODUCTS_STORAGES']);
                            $product_copy['storage_nummer'] = $place['storage_nummer'];
                            $product_copy['product_place_quantity'] = $place['product_place_quantity'];
                            $place_title = ($place['title'] != '') ? $place['title'] : 'No Name';
                            if(!isset($storage_groups[ $psa['storage_id'] ]['places'][ $place_title ])){
                                $storage_groups[ $psa['storage_id'] ]['places'][ $place_title ] = array(
                                    'place_title'=>$place_title,
                                    'products'=>array()
                                );
                            }
                            $storage_groups[ $psa['storage_id'] ]['places'][$place_title ]['products'][] = $product_copy;
                        }
                    }
                    // BOF - FALLS STAMMLAGER NICHT BEI IST
                    if(!$stammlager_included){
                        $SQ = new products_quantity($product['products_id']);
                        if($SQ->get_untransferred() > 0){
                            $place_title = 'Lagerpl&auml;tze';
                            $product_copy = $product;
                            unset($product_copy['PRODUCTS_STORAGES_ARRAY']);
                            unset($product_copy['PRODUCTS_STORAGES']);
                            $product_copy['storage_nummer'] = '-';
                            $product_copy['product_place_quantity'] = $SQ->get_untransferred();
                            $storage_groups[ 0 ]['places'][ $place_title ]['products'][] = $product_copy;
                        }
                    }
                    // EOF - FALLS STAMMLAGER NICHT BEI IST
                }
                break;
        }
        
	if($source_sort == 'storages'){
                // Nach Versandabschluss
		$sorted_array = array();
		foreach($storage_groups as $storage_id=>$places){
			asort($places['places']);
		        $sorted_array[$storage_id]['title'] = $storage_groups[$storage_id]['title'];
			$sorted_array[$storage_id]['places'] = $places['places']; 
		}
                if(isset($sorted_array[0])){
                    $stamm = $sorted_array[0];
                    unset($sorted_array[0]);
                    $sorted_array[0] = $stamm;
                }
		return $sorted_array; // neues handling 2017/07
	}else{
		$sorted_array = array();
		if(!sizeOf($storage_groups[0]['places']['Lagerpl&auml;tze']['products'])){
		    unset($storage_groups[0]);
		}
		// 1. LAGERPLAETZE OHNE BESTAND RAUS
		foreach($storage_groups as $storage_id=>$places){
		    foreach($places['places'] as $place_key=>$place){
			if(!sizeOf($place['products'])){
			    unset($storage_groups[$storage_id]['places'][$place_key]);
			}
		    }
		}
		// 2. LAGER OHNE LAGERPLAETZE RAUS
		foreach($storage_groups as $storage_id=>$places){
		    if(!sizeOf($places['places'])){
			unset($storage_groups[$storage_id]);
		    }
		}
            $this->set_missing_products($products_array, $storage_groups);
		foreach($storage_groups as $storage_id=>$places){
			asort($places['places']);
			$sorted_array[$storage_id]['title'] = $storage_groups[$storage_id]['title'];
			$sorted_array[$storage_id]['places'] = $places['places']; 
		}
                if(isset($sorted_array[0])){
                    $stamm = $sorted_array[0];
                    unset($sorted_array[0]);
                    $sorted_array[0] = $stamm;
                }
		return $sorted_array; // neues handling 2017/07
	}
    }
    

    private function get_html(){
        $smarty = $this->create_smarty_instance();
	if(!$this->getPre_write_mode()){
	    // bei versandabschluss sortiert nach lager
	    $products = $this->get_export_data('storages');
	}else{
	    $products = $this->get_export_data();
	}
	if(!sizeOf($products) and !sizeOf($this->missing_products)){
            if($this->debug === True){
                printf("[%s] function get_html() has no products\r\n",date('H:i:s'));
            }
	    return '';
        }
	$distinct_products = [];
	foreach($products as $storage){
		foreach($storage['places'] as $place){
			foreach($place['products'] as $p){
                if(!isset($distinct_products[ $p['products_id'] ])){
                    $distinct_products[ $p['products_id'] ] = 0;
                }
                // 2025/06 das war vorher += p[quantity]
				$distinct_products[ $p['products_id'] ] += $p['qty'];
			}
		}
	}
    $subtitle_define = sprintf(TEXT_PROCESS_SHIPPING_SUBTITLE2,$this->get_storages_num($products),sizeOf($distinct_products));
	$smarty->assign(array(
		'TITLE'=>$this->getFilename(),
        'DATE_NOW'=>xtc_date_short(date('Y-m-d')).' '.date('H:i'),
		'SUBTITLE'=>$subtitle_define,
		'TABLE_HEADING_QTY'=>TEXT_PROCESS_SHIPPING_TH_QTY,
		'TABLE_HEADING_PRODUCTS_NAME'=>TEXT_PROCESS_SHIPPING_TH_PRODUCTS_NAME,
		'TABLE_HEADING_STORAGE'=>TEXT_PROCESS_SHIPPING_TH_STORAGE,
		'STORAGE'=>TEXT_PROCESS_SHIPPING_STORAGE,
		'NUMBER'=>TEXT_PROCESS_SHIPPING_NUMBER,
		'PLACE'=>TEXT_PROCESS_SHIPPING_PLACE,
		'PIXEL_BLACK'=>xtc_draw_separator('pixel_black.gif'),
		'DISTRIBUTOR_PRODUCTS_NUMBER'=>TEXT_PROCESS_SHIPPING_DISTRIBUTOR_PRODUCTS_NUMBER,
		'DISTRIBUTOR'=>TEXT_PROCESS_SHIPPING_DISTRIBUTOR
	));
	if(!$this->getPre_write_mode()){
	    $smarty->assign('products',$products);
	    $html = $this->get_fetched_smarty_result($smarty, $this->get_smarty_template());
	}else{
	    $smarty->assign(array(
                'products'=>$products,
                'missing_products'=>$this->get_missing_products_with_details()
            ));
            $html = $this->get_fetched_smarty_result($smarty, $this->get_smarty_template());
	}
        return $html; // bei versandabschluss gibt es html array wieder, fuer einzelne seiten
    }
    
    private static function get_fetched_smarty_result($smarty, $filename){
        if(is_file(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/'.$filename)){
            return $smarty->fetch('admin/'.$filename);
        }
        return $smarty->fetch($filename);
    }

    private function write(){
	$html = $this->get_html();
	if(empty($html)){
            if($this->debug === True){
                printf("[%s] function write() has no html\r\n",date('H:i:s'));
            }
	    return $html;
        }
        if($this->getDebug_html() === true){
            if(is_array($html)){
                foreach($html as $nr => $t){
                    echo "<br /><br /><b>----------- PDF SEITE ".($nr+1)." &raquo;".$t['title']."&laquo; ----------</b><br /><br />".$t['html'];
                }
            }else{
                echo $html;
            }
            exit;
        }
        
	$sha1_name = yes_get_sha1_from_string( date('d_m_Y-H_i_s') );
	$export_data_subdir = yes_get_sha1_from_string( date('Y-m-d') );
	$path = \main::get_exportdata_path().$export_data_subdir;
	if(!is_dir($path)){
		mkdir($path);
	}
        
	if($this->getPre_write_mode()){
		$pdf_name=$path.'/VORAB_PRODUKTLISTE_'.$sha1_name.'.pdf';
        }else{
            $pdf_name=$path.'/PRODUKTLISTE_'.$this->getFilter_sql_shipper().'_'.$sha1_name.'.pdf';
        }
        if( !defined('USE_DOMPDF') or USE_DOMPDF != 'True'){
	    if( is_array($html) ){
		$tmp_names = array();
		foreach($html as $nr=>$storage_page){
		    $pdf=new HTML2FPDF('P','mm','A4');
//echo '<li>new pdf instance for '.$storage_page['title'];continue;
		    $pdf->SetAutoPageBreak(false,30);
		    $pdf->add_footer = true;
		    $pdf->AliasNbPages();
		    $pdf->pre_text = $storage_page['title'];
		    $pdf->AddPage();
		    $pdf->WriteHTML($storage_page['html']);
		    $tmp_name = $pdf_name.'-'.$nr.'-TMP.pdf';
		    $pdf->Output($tmp_name,$dest='F'); //Read the FPDF.org manual to know the other options
		    $tmp_names[] = $tmp_name;
		}
		touch($pdf_name);
		if(sizeOf($tmp_names) > 1) {
                        $cmd = "gs -q -dNOPAUSE -dBATCH -sDEVICE=pdfwrite -sOutputFile=$pdf_name ";
                        //Add each pdf file to the end of the command
                        foreach($tmp_names as $file) {
                                $cmd .= $file." ";
                        }
                        $result = shell_exec($cmd);            
		}elseif(sizeOf($tmp_names) == 1){
			rename($tmp_names[0],$pdf_name);
		}
	    }else{
		$pdf=new HTML2FPDF();
		$pdf->AddPage();
		$pdf->WriteHTML($html);
		$pdf->Output($pdf_name,$dest='F'); //Read the FPDF.org manual to know the other options
	    }
	}else{
//	    $pdf->save_large_file($pdf_name,$this->get_html());
	    if(is_array($html) and sizeOf($html)){
		$tmp_names = array();
		foreach($html as $nr=>$storage_page){
		    $ypdf = new yes_pdf();
		    if(DOMPDF_ORDER_LANDSCAPE == 'True'){
			//$ypdf->set_landscape();
		    }
		    $ypdf->set_html($storage_page['html']);
		    $ypdf->instance->render();
		    //nun kommt der Header-Teil
		    $font = Font_Metrics::get_font('helvetica');
		    $left = 10;
		    $text = $storage_page['title'];
		    $size = 10;
		    $color = array();
		    $_color = array(100,100,100);
		    foreach($_color as $_col){
			// Bugfix inline
			if($_col > 0)
			    $color[] = $_col / 255;
			else
			    $color[] = 0;
		    }
		    //canvas holen (das liegt beim inline code bereits vor bzw. wurde �bergeben)
		    $pdf = $ypdf->instance->get_canvas();
		    $footer = $pdf->open_object();
		    $pdf->page_text($left, 0, $text." - Seite {PAGE_NUM}/{PAGE_COUNT}", $font, $size, $color);
		    $pdf->close_object();
		    $pdf->add_object($footer, "all");
		    $tmp_name = $pdf_name.'-'.$nr.'-TMP.pdf';
		    $pdf_c = $ypdf->instance->output($tmp_name);
		    file_put_contents($tmp_name, $pdf_c);
		    chmod($tmp_name,0777);
		    $tmp_names[] = $tmp_name;
		}
// BOF - NEUES HANDLING
		touch($pdf_name);
		chmod($pdf_name,0777);
		$cmd = "gs -q -dNOPAUSE -dBATCH -sDEVICE=pdfwrite -sOutputFile=$pdf_name ";
		//Add each pdf file to the end of the command
		foreach($tmp_names as $file) {
			$cmd .= $file." ";
		}
		$result = shell_exec($cmd);            
//		$ypdf->merge($tmp_names,$pdf_name);
//		foreach($tmp_names as $tmp){
//		    unlink($tmp);
//		}
// EOF - NEUES HANDLING
	    }else{
                $ypdf = new yes_pdf();
                if(DOMPDF_ORDER_LANDSCAPE == 'True'){
                    //$ypdf->set_landscape();
                }
		$ypdf->set_html($html);
		$ypdf->save($pdf_name);
	    }
	}
	return $pdf_name;
    }
    
    public function get_available_shipper(){
        $array = array();
        $query = xtc_db_query(
                "SELECT DISTINCT(versender) as vers FROM shippings WHERE shipper_export_status=0 AND status=1 and pdf_status=1"
        );
        while($record = xtc_db_fetch_array($query)){
            $array[] = $record['vers'];
        }
        return $array;
    }
    
    public function get_open_shipper_exports_num(){
        $query = xtc_db_query(
                "SELECT id FROM shippings WHERE shipper_export_status=0 AND status=1"
        );
        return xtc_db_num_rows($query);
    }
    
    public function process(){
        $this->ppdf_products = new paketliste_pdf_products;
        $this->ppdf_products->debug = $this->debug;
	if($this->getPre_write_mode()){
		$this->setFilename(sprintf(TEXT_PROCESS_SHIPPING_PRE_TITLE,date('d.m.Y H:i:s')));
        }else{
            if($this->getFlag_shipper()){
		$this->setFilename(sprintf(TEXT_PROCESS_SHIPPING_TITLE,'_'.$this->getFilter_sql_shipper().'_'.date('d.m.Y H:i:s')));
            }else{
		$this->setFilename(sprintf(TEXT_PROCESS_SHIPPING_TITLE,date('d.m.Y H:i:s')));
            }
        }
        $query = xtc_db_query($this->get_sql());
	while($shipping = xtc_db_fetch_array($query)){
		if($shipping['orders_id'] > 0){
                    $this->get_order_products($shipping);
                }else{
                    $this->get_reclamation_products($shipping);
                }
        }
        //$this->get_html();
        $filename = $this->write();
        return $filename;
    }
    
    private function get_collies($pID){
	$collies = array();
	$query = xtc_db_query(sprintf(
		"SELECT collie_products_id,quantity FROM products_collies WHERE products_id='%s' ORDER BY sort_order",
		$pID
	));
	while($record = xtc_db_fetch_array($query)){
	    $collies[] = $record;
	}
	return $collies;
    }
    
    // BEI DER VORABLISTE PDF BRAUCHEN WIR EINE LISTE DER ARTIKEL DIE NICHT
    // VERFUEGBAR SIND. DIESE GENERIEREN WIR INDEM WIR DIE BEIDEN ARRAYS VER-
    // GLEICHEN
    private function set_missing_products(array $products_array, array $storage_groups){
        $products = [];
        foreach($products_array as $p){
            if(!isset($products[$p['products_id']])){
                $products[$p['products_id']] = 0;
            }
            $products[$p['products_id']] += $p['qty'];
        }
        foreach($storage_groups as $storage_id=>$places_array){
            foreach($places_array as $place_title=>$places){
                foreach($places as $place){
                    foreach($place['products'] as $product){
                        if(!isset($products[ $product['products_id'] ])){
                            $products[ $product['products_id'] ] = 0;
                        }
                        $products[ $product['products_id'] ] -= $product['qty'];
                    }
                }
            }
        }
        foreach($products as $pID=>$qty){
            if($qty < 1) unset($products[$pID]);
        }
        $this->missing_products = $products;
    }
    
    private function get_missing_products_with_details(){
        $details = [];
        foreach($this->missing_products as $pID => $qty){
            $q = xtc_db_query(sprintf(
                    "SELECT products_ean, products_model,products_image FROM %s WHERE products_id='%d'",
                    TABLE_PRODUCTS, $pID
            ));
            $r = xtc_db_fetch_array($q);
            $details[] = array(
                'products_id'=>$pID,
                'quantity'=>$qty,
                'products_name'=>xtc_get_products_name($pID),
                'products_model'=>$r['products_model'],
                'products_ean'=>$r['products_ean'],
		'products_image'=>$r['products_image']
            );
        }
        return $details;
    }
    private static function get_storage_place_info($storage_places){
        $return = array('total'=>0,'diff'=>array());
        foreach($storage_places as $strg_place){
            foreach($strg_place as $strg_place_product){
                $return['total'] += -$strg_place_product['qty'];
                $return['diff'][ $strg_place_product['products_id'] ] = true;
            }
        }
        return $return;
    }
    
    public function create_smarty_instance(){
	return new yesSmarty;
    }
    
    private static function get_storages_num($array){
        return sizeOf($array);
    }
    
    private function get_smarty_template(){
        if(USE_DOMPDF == 'True'){
            $filename = 'produktliste2_dompdf.html';// neues handling 2017/07
        }else{
            $filename = 'produktliste2.html';// neues handling 2017/07
        }
        // WENN USER EIGENES TEMPLATE HAT, DAS NEHMEN
        if(is_file(DIR_FS_CATALOG.'templates'.DIRECTORY_SEPARATOR.CURRENT_TEMPLATE.DIRECTORY_SEPARATOR.'admin'.DIRECTORY_SEPARATOR.$filename)){
            $filename = DIR_FS_CATALOG.'templates'.DIRECTORY_SEPARATOR.CURRENT_TEMPLATE.DIRECTORY_SEPARATOR.'admin'.DIRECTORY_SEPARATOR.$filename;
        }
        return $filename;
    }
    
    private function get_sql(){
        $sql = "SELECT * FROM shippings WHERE ";
	if($this->getPre_write_mode()){
            $this->setFilter_sql_status(0);
	    $this->setFilter_sql_csv_status(0);
            $sql = $sql . sprintf("status='%s' AND csv_status='%s' ",
                    $this->getFilter_sql_status(),
                    $this->getFilter_sql_csv_status()
            );
	}else{
            $this->setFilter_sql_status(1);
	    $this->setFilter_sql_csv_status(1);
            if($this->getFlag_shipper()){
                $this->setFilter_sql_pdf_status(1);
            }
            $sql = $sql . sprintf("status='%s' AND pdf_status='%s' AND csv_status='%s' ",
                    $this->getFilter_sql_status(),
                    $this->getFilter_sql_pdf_status(),
		    $this->getFilter_sql_csv_status()
            );
            if($this->getFlag_shipper()){
                $sql .= sprintf(" AND shipper_export_status=0 AND versender='%s' ",$this->getFilter_sql_shipper());
            }
	}
        if(sizeOf($this->getProcess_shipping_id_array())){
            $sql .= sprintf(" AND id IN(%s) ",implode(',',$this->getProcess_shipping_id_array() ));
        }
        
        return $sql . sprintf(" ORDER BY %s",$this->getFilter_sql_order_by());
    }
    
    private static function get_products_image_link($products_image){
        if($products_image != '' and ( substr(strtolower($products_image),strlen($products_image)-3) == 'jpg' or substr(strtolower($products_image),strlen($products_image)-3) == 'jpeg') ){
            if(!is_file(DIR_FS_CATALOG_THUMBNAIL_IMAGES.$products_image)){
                return '';
            }
            if(exif_imagetype(DIR_FS_CATALOG_THUMBNAIL_IMAGES.$products_image) == IMAGETYPE_JPEG){
                return HTTP_SERVER.'images/product_images/thumbnail_images/'.$products_image;
            }
        }
        return '';
    }
    
    /**
     * gibt den default lieferanten und die dazugehoerige lieferantennr des
     * artikels zurueck
     * 
     * @param int $products_id
     * @return Array [name, number]
     */
    private static function get_distributor_info($products_id){
        $return = array(
            'name'=>'',
            'number'=>''
        );
        $distributors_query = xtc_db_query(sprintf(
                "SELECT distributor_id,distributor_products_number FROM products_distributors WHERE is_default=1 AND products_id='%s'",
                $products_id
        ));
        if(xtc_db_num_rows($distributors_query)){
                $distributors = xtc_db_fetch_array($distributors_query);
                $return['name'] = xtc_get_distributor_name($distributors['distributor_id']);
                $return['number'] = $distributors['distributor_products_number'];
        }
        return $return;
    }
    
    /**
     * wird nirgends verwendet
     * @param type $_products_array
     * @return string
     */
    private static function hide_storage_places($_products_array){
        // AUSBLENDEN DER ANZEIGE ALLER LAGERPLAETZE
        $_products_array2 = $_products_array;
        // NUR DIE PASSENDEN storage_allocated_array EINTRAEGE UEBERNEHMEN
        foreach($_products_array2['PRODUCTS_STORAGES_ALLOCATED'] as $psa){
            if(!isset($psa['set_info']) or empty($psa['set_info'])){
                continue;
            }
            if($psa['storage_name'] == $tp['name'] and $psa['storage_place'] == $tp['storage_place']){
                $_products_array2['products_name'] .= '<br />'.$psa['set_info'];
            }
        }
        unset($_products_array2['PRODUCTS_STORAGES']);
        unset($_products_array2['PRODUCTS_STORAGES_ALLOCATED']);
        return $_products_array2;
    }
    
    private function get_storages_return_array_with_storage_string($transfer_places,$_products_array,$qty,$storage_allocated_qty){
        $storages_return_array = array();
        foreach($transfer_places as $tp){
            if(!isset($storages_return_array[ $tp['storage_id'] ])){
                $storages_return_array[ $tp['storage_id'] ] = array(
                    'places'=>array(),
                    'title'=>$tp['name']
                );
            }
            if(!isset($storages_return_array[ $tp['storage_id'] ]['places'][$tp['storage_place']])){
                $storages_return_array[ $tp['storage_id'] ]['places'][$tp['storage_place']]['products'] = array();
            }
            //$_products_array['qty'] = $tp['quantity'];
            //$_products_array2 = $this->hide_storage_places($_products_array);
            $_products_array['storage_nummer'] = $tp['storage_nummer'];
		// wir ueberschreiben den Wert product_place_quantity weil dieser
		// im Template den Wert widerspiegelt, der tatsaechlich abgebucht
		// wurde beim Versandabschluss.
		// negiert wird der Wert, weil er zb als -2 ankommt, wenn von diesem
		// lagerplatz 2 stk gebucht wurden.
		$_products_array['product_place_quantity'] = -$tp['quantity'];
            $storages_return_array[ $tp['storage_id'] ]['places'][$tp['storage_place']]['products'][] = $_products_array;
        }
        return $storages_return_array;
    }
    
    private function get_storages_return_array($transfer_places,$_products_array,$qty,$storage_allocated_qty){
        $storages_return_array = $this->get_storages_return_array_with_storage_string($transfer_places,$_products_array,$qty,$storage_allocated_qty);
        
        if($qty > $storage_allocated_qty){
	    // stammlager muss dann die Restmenge als product_place_quantity haben
	    $_products_array['product_place_quantity'] = $qty-$storage_allocated_qty;
            $storage_place = 'Lagerpl&auml;tze';
            if(!isset($storages_return_array[ 0 ]['places'][ $storage_place ]['products'])){
                $storages_return_array[ 0 ]['places'][ $storage_place ]['products'] = array();
            }
            $storages_return_array[ 0 ]['places'][ $storage_place ]['products'][] = $_products_array;
        }
        return $storages_return_array;
    }
    
    
    private function get_default_storage_string($products_storages_array){
	$storage_str = '';
        for($i=0;$i<count($products_storages_array);$i++){
                $storage_name = xtc_get_storage_name($products_storages_array[$i]['storage_id']);
                $numbers_str = '';
                $plc_arr = array();
                foreach($products_storages_array[$i]['places'] as $place){
                    $nummer = $place['nummer'];
                    $plc_arr[] = $place['title'];
                }
                $numbers_str .= sprintf('%s: %s<br />',
                        $nummer,implode(', ',$plc_arr)
                );
                if($products_storages_array[$i]['is_colli']){
                    $set_info = sprintf('[Colli pID %s (%s Stk / SET) &raquo;%s&laquo;]<br />',
                            $products_storages_array[$i]['products_id'],
                            $products_storages_array[$i]['calculated_colli_quantity'],
                            xtc_get_products_name($products_storages_array[$i]['products_id'])
                    );
                    $storage_str .= sprintf('<br />%s <b>Lager &raquo;%s&laquo;</b><br /><b>Lagerpl&auml;tze</b><br />%s<br />',
                        $set_info,$storage_name,$numbers_str
                    );
                }else{
                    $storage_str .= sprintf('<br /><b>Lager &raquo;%s&laquo;</b><br /><b>Lagerpl&auml;tze</b><br />%s<br />',
                        $storage_name,$numbers_str
                    );
                }
        }
	return $storage_str;
    }
    

    /** 
     * ERSETZT process() nachdem auf V2 umgestellt wurde
     * 
     * @return string filename
     */
    public function process_v2(string $shipper, array $items){
        if($shipper != ''){
            $this->getFlag_shipper(true);
            $this->setFilter_sql_shipper($shipper);
        }
        $this->ppdf_products = new paketliste_pdf_products;
        $this->ppdf_products->debug = $this->debug;
        $this->v2_add_ppdf_products($items);
	if($this->getPre_write_mode()){
		$this->setFilename(sprintf(TEXT_PROCESS_SHIPPING_PRE_TITLE,date('d.m.Y H:i:s')));
        }else{
            if($this->getFlag_shipper()){
		$this->setFilename(sprintf(TEXT_PROCESS_SHIPPING_TITLE,'_'.$this->getFilter_sql_shipper().'_'.date('d.m.Y H:i:s')));
            }else{
		$this->setFilename(sprintf(TEXT_PROCESS_SHIPPING_TITLE,date('d.m.Y H:i:s')));
            }
        }
        return $this->write();
    }
    
    public function v2_add_ppdf_products(array $items = []){
        foreach($items as $YESShippingItem){
            foreach($YESShippingItem->products_to_ship as $YESShippingItemSavedProduct){
                if(!$this->ppdf_products->product_exists($YESShippingItemSavedProduct->products_id)){
                    $this->ppdf_products->add( $YESShippingItemSavedProduct->products_id );
                }
                $ppdf_product = $this->ppdf_products->get( $YESShippingItemSavedProduct->products_id );
                $collies = $this->get_collies($YESShippingItemSavedProduct->products_id);
                $class_obj = $YESShippingItem->source_obj->class_obj;
                if(sizeOf($collies)){
                    $tp = array();
                    $ppdf_product->setIs_stklistenartikel(true);
                    foreach($collies as $colli){
                        if(!$this->ppdf_products->product_exists($colli['collie_products_id'])){
                            $this->ppdf_products->add( $colli['collie_products_id'] );
                        }
                        $cppdf_product = $this->ppdf_products->get( $colli['collie_products_id'] );
                        $cppdf_product->add_quantity( $YESShippingItemSavedProduct->quantity*$colli['quantity'] );
                        
                        // LIEST DIE TABELLE storage_products_transfer AUS UND WENN
                        // GEBUCHT WURDE, GIBT ES source UND target storage ZURUECK
                        // zusaetzlich enthalten die tp Eintraege nun is_colli und
                        // die collie_products_id
                        $tp = array_merge($tp,$class_obj->get_transferred_places($colli['collie_products_id'],'Versand',true));
                        if(sizeOf($tp)){
                            $cppdf_product->addStorages_array($tp);
                        }
                    }
                }else{
                    $ppdf_product->add_quantity( $YESShippingItemSavedProduct->quantity );
                    // LIEST DIE TABELLE storage_products_transfer AUS UND WENN
                    // GEBUCHT WURDE, GIBT ES source UND target storage ZURUECK
                    $tp = $class_obj->get_transferred_places($YESShippingItemSavedProduct->products_id,'Versand');
                    if(sizeOf($tp)){
                        $ppdf_product->addStorages_array($tp);
                    }
                }
            }
        }
    }
}

function paketliste_pdf($pre_write_mode = false,$process_shipping_id_array=array()){
    $ppdf = new yes_paketliste_pdf();
    $ppdf->setPre_write_mode($pre_write_mode);
    $ppdf->setProcess_shipping_id_array($process_shipping_id_array);
    return $ppdf->process();
}
