<?php
class running_auctions_sql {
    const AUCTIONS_TABLE = 'ebay_auctions ea';
    const AUCTIONS_VARIATIONS_TABLE = 'ebay_auctions_variations eav';
    const PRODUCTS_TABLE = 'products p';
    const EBAY_PRODUCTS_TABLE = 'ebay_products ep';
    var $ebay_sammler,$manufacturers_id,$view_limit,$order_by,$search_mode,$search,$filter_ebayuser,$date_available_gt_now,$zero_quantity,$type,$duration,$ebay_plus;
    
    public function getZero_quantity() {
	return $this->zero_quantity;
    }

    public function setZero_quantity($zero_quantity) {
	$this->zero_quantity = $zero_quantity;
    }

    public function getDate_available_gt_now() {
	return $this->date_available_gt_now;
    }

    public function setDate_available_gt_now($date_available_gt_now) {
	$this->date_available_gt_now = $date_available_gt_now;
    }

    public function getEbay_sammler() {
	return $this->ebay_sammler;
    }

    public function setEbay_sammler($ebay_sammler) {
	$this->ebay_sammler = $ebay_sammler;
    }

    public function getManufacturers_id() {
	return $this->manufacturers_id;
    }

    public function setManufacturers_id($manufacturers_id) {
	$this->manufacturers_id = $manufacturers_id;
    }

    public function getView_limit() {
	return $this->view_limit;
    }

    public function setView_limit($view_limit) {
	$this->view_limit = $view_limit;
    }

    public function getOrder_by() {
	return $this->order_by;
    }

    public function setOrder_by($order_by) {
	$this->order_by = $order_by;
    }

    public function getSearch_mode() {
	return $this->search_mode;
    }

    public function setSearch_mode($search_mode) {
	$this->search_mode = $search_mode;
    }

    public function getSearch() {
	return $this->search;
    }

    public function setSearch($search) {
	$this->search = $search;
    }

    public function getFilter_ebayuser() {
	return $this->filter_ebayuser;
    }

    public function setFilter_ebayuser($filter_ebayuser) {
	$this->filter_ebayuser = $filter_ebayuser;
    }

    public function getType() {
	return $this->type;
    }

    public function setType($type) {
	$this->type = $type;
    }

    public function getDuration() {
	return $this->duration;
    }

    public function setDuration($duration) {
	$this->duration = $duration;
    }

    public function getEbay_plus() {
	return $this->ebay_plus;
    }

    public function setEbay_plus($ebay_plus) {
	$this->ebay_plus = $ebay_plus;
    }

    function __construct(){
	    $this->setOrder_by( (isset($_GET['order_by']) and $_GET['order_by']!='') ? xtc_db_prepare_input(str_replace('+',' ',$_GET['order_by'])) : 'title' );
            if(substr($this->getOrder_by(),0,11)== 'products_id'){
                $this->setOrder_by('ea.'.$this->getOrder_by());
            }
	    $this->setEbay_sammler( (isset($_REQUEST['ebay_sammler']) and is_numeric($_REQUEST['ebay_sammler'])) ? (int)xtc_db_input($_REQUEST['ebay_sammler']) : '' );
	    $this->setManufacturers_id( (isset($_REQUEST['manufacturers_id']) and is_numeric($_REQUEST['manufacturers_id'])) ? (int)xtc_db_input($_REQUEST['manufacturers_id']) : '' );
            if(isset($_GET['seller'])){
                $this->setFilter_ebayuser( $_GET['seller'] );
            }elseif(isset($_GET['filter_ebay_user']) and !empty($_GET['filter_ebay_user'])){
                $this->setFilter_ebayuser( $_GET['filter_ebay_user'] );
            }
	    $this->setDate_available_gt_now( (isset($_REQUEST['date_available_gt_now']) and $_REQUEST['date_available_gt_now'] == 1) ? true : false );
	    $this->setZero_quantity( (isset($_REQUEST['zero_quantity']) and $_REQUEST['zero_quantity'] == 1) ? true : false );
	    $this->setType( (isset($_REQUEST['type']) and $_REQUEST['type'] != '') ? substr(xtc_db_input($_REQUEST['type']),0,16) : '' );
	    $this->setDuration( (isset($_REQUEST['duration']) and $_REQUEST['duration'] != '') ? xtc_db_input($_REQUEST['duration']) : '' );
	    $this->setEbay_plus( (isset($_REQUEST['ebay_plus']) and $_REQUEST['ebay_plus'] == 1) ? true : false );
	    $max_running_auctions = (defined('MAX_DISPLAY_RUNNING_AUCTIONS')) ? MAX_DISPLAY_RUNNING_AUCTIONS : 250;
	    $view_limit = (EBAY_ALLCARTPRODUCTS == 1) ? $max_running_auctions : MAX_DISPLAY_SEARCH_RESULTS;
	    if(MAX_DISPLAY_SEARCH_RESULTS > $max_running_auctions)
		$view_limit = $max_running_auctions;
	    if(isset($_GET['view_limit']) and $_GET['view_limit'] == 'all')
		    $view_limit = 1000;
	    $this->setView_limit($view_limit);
	    $this->set_search_values();
    }

    public function getSql(){
	$select_sql = 'distinct(ea.id)';
	$from = array();
	if( $this->getDate_available_gt_now() === true or $this->getManufacturers_id() > 0 or in_array($this->getSearch_mode(),array('ean','model','pid','epid'))){
	    $from[] = self::AUCTIONS_TABLE." left join ebay_auctions_variations eav on ea.id=eav.ebay_auctions_id ";
	}else{
	    $from[] = self::AUCTIONS_TABLE;
	}

	
	if($this->getDate_available_gt_now() === true or $this->getManufacturers_id() > 0 or in_array($this->getSearch_mode(),array('ean','model','pid','epid'))){
	    $from[] = self::PRODUCTS_TABLE;
	}
	if(is_numeric($this->getEbay_sammler())){
	    $from[] = self::EBAY_PRODUCTS_TABLE;
	}
	$use_products_where = false;
	$where = array("ea.status = '0'");
	if($this->getManufacturers_id() > 0){
	    $where[] = sprintf("p.manufacturers_id='%s'",$this->getManufacturers_id());
	    $use_products_where = true;
	}
	if($this->getDate_available_gt_now() === true){
	    $where[] = " p.products_date_available > now() ";
	    $use_products_where = true;
	}
	if(is_numeric($this->getEbay_sammler())){
	    $where[] = sprintf("ea.ebay_products_id=ep.id and ep.ebay_sammler_id='%s'",
		    $this->getEbay_sammler()
	    );
	}
	if($this->getFilter_ebayuser() != ''){
	    $where[] = "ea.user='".$this->getFilter_ebayuser()."'";
	}
	
	if($this->getEbay_plus() === true){
	    $where[] = 'ea.ebay_plus=1';
	}
	
	if($this->getSearch() != ''){
	    
	    switch($this->getSearch_mode()){
			case 'ean':
				$where[] = "p.products_ean IN(".$this->getSearch().")";
				$use_products_where = true;
				break;
			case 'model':
				$where[] = "p.products_model LIKE '%".$this->getSearch()."%'";
				$use_products_where = true;
				break;
			case 'pid':
				$where[] = "p.products_id = ".(int)$this->getSearch();
				$use_products_where = true;
				break;
			case 'epid':
				$where[] = "ea.ebay_products_id = ".(int)$this->getSearch();
				$use_products_where = true;
				break;
			default:
			    $where[] = sprintf("(ea.title like '%%%s%%' or ea.ebay_id='%s')",
				    $this->getSearch(),$this->getSearch()
			    );
			    break;
		}
	}
	if($use_products_where){
		$where[] = "(ea.products_id=p.products_id or (ea.products_id=0 and eav.products_id=p.products_id))";
	}
	
	if($this->getZero_quantity() == 1){
	    $where[] = " ea.quantity=0 ";
	}
	
	if($this->getType() != ''){
	    $where[] = sprintf(" ea.type='%s'",$this->getType());
	}
	
	if($this->getDuration() != ''){
	    switch($this->getDuration()){
		case 'GTC':
		    $where[] = sprintf(" ea.duration='0'");
		    break;
		default:
		    $where[] = sprintf(" ea.duration='%s'",$this->getDuration());
		    break;
	    }
	}
	return sprintf("select %s from %s where %s order by %s",
		$select_sql,
		implode(', ',$from),
		implode(' and ',$where),
		$this->getOrder_by()
	);
    }
    
    private function set_search_values(){
	// FALLS ALS SUCHSTRING "ean:" am Anfang steht, wird erwartet dass ein
	// String kommaseparierter EAN-Nummern uebergeben wird. Also zB
	// ean:ABC991,DED-9092
	// DIESE EAN NUMMERN WERDEN DANN MIT DER TABELLE products ABGEGLICHEN
	// UND TREFFENDE RESULTS BEI LAUFENDEN AUKTIONEN AUSGEGEBEN
	$search = (isset($_REQUEST['searchword'])) ? xtc_db_prepare_input($_REQUEST['searchword']) : '';
        $search_mode = '';
	if(strstr($search,'ean:')){
		$_array = split('ean:',$search);
		$_search = split(',',$_array[1]);
		for($i=0;$i<sizeOf($_search);$i++){
			$_search[$i] = "'".$_search[$i]."'";
		}
		$search = implode(',',$_search);
	}else{
	    if(isset($_REQUEST['searchmode'])){
		switch($_REQUEST['searchmode']){
			case 'ean':
				$search = "'$search'";
				$search_mode = 'ean';
				break;
			case 'model':
				$search_mode = 'model';
				break;
			case 'pid':
				$search_mode = 'pid';
				break;
			case 'epid':
				$search_mode = 'epid';
				break;
		}
	    }
	}
	$this->setSearch($search);
	$this->setSearch_mode($search_mode);
    }
    
}
