<?php
/* --------------------------------------------------------------
   $Id: split_page_results.php,v 1.11 2017/02/14 06:11:06 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(split_page_results.php,v 1.13 2003/05/05); www.oscommerce.com 
   (c) 2003	 nextcommerce (split_page_results.php,v 1.6 2003/08/18); www.nextcommerce.org

   Released under the GNU General Public License 
   --------------------------------------------------------------*/

  class splitPageResults {
    function __construct(&$current_page_number, $max_rows_per_page, &$sql_query, &$query_num_rows,$reviews_count_query_raw = '') {
        if ((int)$current_page_number<1 or $current_page_number == '') {
            $current_page_number = 1;
        }
        $sql_query = self::validate_and_clean_sql($sql_query);
        if(empty($reviews_count_query_raw)){
          $pos_to = strlen($sql_query);
          $pos_from = strpos($sql_query, ' from', 0);

          $pos_group_by = strpos($sql_query, ' group by', $pos_from);
          if (($pos_group_by < $pos_to) && ($pos_group_by != false)) {
              $pos_to = $pos_group_by;
          }

          $pos_having = strpos($sql_query, ' having', $pos_from);
          if (($pos_having < $pos_to) && ($pos_having != false)) {
              $pos_to = $pos_having;
          }

          $pos_order_by = strpos($sql_query, ' order by', $pos_from);
          if (($pos_order_by < $pos_to) && ($pos_order_by != false)) {
              $pos_to = $pos_order_by;
          }
          $reviews_count_query_raw = sprintf("select count(1) as total %s",
                substr($sql_query, $pos_from, ($pos_to - $pos_from))
          );
        }
        // wenn zb am ende nur "WHERE" steht ohne weitere Parameter
        $reviews_count_query = xtc_db_query($reviews_count_query_raw);
        $reviews_count = xtc_db_fetch_array($reviews_count_query);
        $query_num_rows = $reviews_count['total'];

        $num_pages = ceil($query_num_rows / $max_rows_per_page);
        if ($current_page_number > $num_pages) {
            $current_page_number = $num_pages;
        }
        $offset = ($max_rows_per_page * ($current_page_number - 1));
        if($offset < 0) {
            $offset = 0;
        }
        $sql_query .= " limit " . $offset . ", " . $max_rows_per_page;
    }

    function display_links($query_numrows, $max_rows_per_page, $max_page_links, $current_page_number, $parameters = '', $page_name = 'page') {

      if ( xtc_not_null($parameters) && (substr($parameters, -1) != '&') ) $parameters .= '&';

      // calculate number of pages needing links
      $num_pages = ceil($query_numrows / $max_rows_per_page);


      $pages_array = array();
	  if($num_pages <= 20){
		  for ($i=1; $i<=$num_pages; $i++) {
			$pages_array[] = array('id' => $i, 'text' => $i);
		  }
	  }

      if ($num_pages > 1) {
        $display_links = xtc_draw_form('pages', basename($_SERVER['PHP_SELF']), '', 'get');

        if ($current_page_number > 1) {
          $display_links .= '<a href="' . xtc_href_link(basename($_SERVER['PHP_SELF']), $parameters . $page_name . '=' . ($current_page_number - 1), 'NONSSL') . '" class="splitPageLink">' . PREVNEXT_BUTTON_PREV . '</a>&nbsp;&nbsp;';
        } else {
          $display_links .= PREVNEXT_BUTTON_PREV . '&nbsp;&nbsp;';
        }

		if($num_pages <= 20){
			$display_links .= sprintf(TEXT_RESULT_PAGE, xtc_draw_pull_down_menu($page_name, $pages_array, $current_page_number, 'onChange="this.form.submit();"'), $num_pages);
		}else{
			$display_links .= sprintf(TEXT_RESULT_PAGE, xtc_draw_hidden_field($page_name, $current_page_number).'<input type="button" value="'.$current_page_number.'" onclick="split_page_select(this,'.(int)$num_pages.');" /><img src="images/pixel_trans.gif" width="1" border="0" /></a>', $num_pages);
		}

        if (($current_page_number < $num_pages) && ($num_pages != 1)) {
          $display_links .= '&nbsp;&nbsp;<a href="' . xtc_href_link(basename($_SERVER['PHP_SELF']), $parameters . $page_name . '=' . ($current_page_number + 1), 'NONSSL') . '" class="splitPageLink">' . PREVNEXT_BUTTON_NEXT . '</a>';
        } else {
          $display_links .= '&nbsp;&nbsp;' . PREVNEXT_BUTTON_NEXT;
        }

        if ($parameters != '') {
          if (substr($parameters, -1) == '&') $parameters = substr($parameters, 0, -1);
          $pairs = explode('&', $parameters);
          // php8 bugfix
          // while (list(, $pair) = each($pairs)) {
          foreach($pairs as $egal =>$pair) {
            list($key,$value) = explode('=', $pair);
			$display_links .= xtc_draw_hidden_field($key, urldecode($value));
          }
        }

        if (SID) $display_links .= xtc_draw_hidden_field(session_name(), session_id());

        $display_links .= '</form>';
      } else {
        $display_links = sprintf(TEXT_RESULT_PAGE, $num_pages, $num_pages);
      }

      return $display_links;
    }

    public static function display_count($query_numrows, $max_rows_per_page, $current_page_number, $text_output) {
      $to_num = (intval($max_rows_per_page) * intval($current_page_number));
      if ($to_num > intval($query_numrows)) {
          $to_num = intval($query_numrows);
      }
      $from_num = (intval($max_rows_per_page) * (intval($current_page_number) - 1));
      if ($to_num == 0) {
        $from_num = 0;
      } else {
        $from_num++;
      }
      return sprintf($text_output, $from_num, $to_num, $query_numrows);
    }

    public static function validate_and_clean_sql(string $sql): string {
      // Überprüfen, ob der SQL-Befehl das Schlüsselwort "WHERE" enthält
      if (stripos($sql, 'where') !== false) {
          // Entfernen von unvollständigen "WHERE"-Bedingungen
          if (preg_match('/where\s*$/i', $sql)) {
              // Entferne das WHERE, wenn es keine Bedingungen gibt
              $sql = preg_replace('/where\s*$/i', '', $sql);
          }
      }
      return $sql;
    }
  }
