<?php
class stepwise_step{
    var $url, $title, $id;
    function __construct( array $data ){
        $this->url = $data['url'];
        $this->title = $data['title'];
        $this->id = $data['id'];
    }
}
class stepwise {
    public $steps, $current_step, $final_url;
    function __construct( array $steps, string $final_url ){
        foreach($steps as $step){
            $this->addStep($step);
        }
        $this->current_step = 1;
        $this->final_url = $final_url;
        self::clearSV();
    }
    
    public function setCurrent_Step( int $step ){
        $this->current_step = $step;
    }
    public function addStep( stepwise_step $step, $index = null ){
        if($index !== null){
            $this->steps[ $index ] = $step;
        }else{
            $this->steps[] = $step;
        }
    }
    
    public function getStep(int $index = null){
        return $this->steps[$index];
    }
    
    public function getBaseHTML( string $title ){
        $smarty = new yesSmarty();
        $smarty->assign([
            'TITLE' => $title,
            'STEPS'=>$this->steps,
            'CURRENT_STEP'=>$this->current_step,
            'STEP_FINAL_URL'=>$this->final_url,
            'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
        ]);
        $smarty->display('stepwise.html');
    }
    
    public function clearSV(){
        $_SESSION['stepwise'] = null;
        unset($_SESSION['stepwise']);
    }
    
    public static function getSV(string $group='', string $key=''){
        if(!empty($group) && !empty($key)){
            return (isset($_SESSION['stepwise'][$group][$key]))?$_SESSION['stepwise'][$group][$key]:null;
        }
        return $_SESSION['stepwise'];
    }
    
    public static function setSV(string $group, string $key, $value){
        $_SESSION['stepwise'][$group][$key] = $value;
    }
}
