<?php
require_once(DIR_WS_CLASSES.'yes_export_module.php');
class yes_export_modules {
    var $modules,$modules_path,$file_prefix,$config,$types,$template_extension;
    var $data_table_id;
    var $modal_window_instance_id;
    var $smarty;
    var $language;
    
    
    function __construct($language){
	$this->language = $language;
	$smarty = new yesSmarty;
	$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
	
	$this->smarty = $smarty;
	$this->modules = array();
	$this->data_table_id = 'products_table';
	$this->modal_window_instance_id = 'modal_window';
	$this->modules_path = 'includes/modules/';
	$this->file_prefix = 'yes_export_module_';
	$this->template_extension = '.conf';
	if(isset($_REQUEST['template'])){
	    $template = $_REQUEST['template'];
	    $this->import_modules($template);
	}
	$this->config = array();
	$this->types = array(
	    array('id'=>'short_text','text'=>TEXT_YES_EXPORT_MODULES_TYPE_SHORT_TEXT),
	    array('id'=>'int','text'=>TEXT_YES_EXPORT_MODULES_TYPE_INT),
	    array('id'=>'float','text'=>TEXT_YES_EXPORT_MODULES_TYPE_FLOAT),
	    array('id'=>'large_text','text'=>TEXT_YES_EXPORT_MODULES_TYPE_LARGE_TEXT),
	    array('id'=>'text','text'=>TEXT_YES_EXPORT_MODULES_TYPE_TEXT),
	    array('id'=>'date','text'=>TEXT_YES_EXPORT_MODULES_TYPE_DATE),
	    array('id'=>'price','text'=>TEXT_YES_EXPORT_MODULES_TYPE_PRICE),
	    array('id'=>'bool','text'=>TEXT_YES_EXPORT_MODULES_TYPE_BOOL),
	    array('id'=>'image','text'=>TEXT_YES_EXPORT_MODULES_TYPE_IMAGE),
	    array('id'=>'select','text'=>TEXT_YES_EXPORT_MODULES_TYPE_SELECT)
	);
	$this->do_request_action();
    }
    
    public function import_modules(){
	$modules = array();
	if ($handle = opendir($this->modules_path)) {
	    while (false !== ($file = readdir($handle))) {
		if(strcmp( substr($file,0,strlen($this->file_prefix)),$this->file_prefix ) == 0){
		    $modules[] = $file;
		}
	    }
	}
	sort($modules);
	foreach($modules as $file){
		$module = substr($file,0,strlen($file)-4);
		include($this->modules_path.$file);
		$module_name = substr( $file, strlen($this->file_prefix), strlen($file)-strlen($this->file_prefix)-4);
		$this->modules[] = new $module($module_name);
	}
    }
    
    public function get_modules(){
	return $this->modules;
    }
    
    public function get_module_title($module){
	$str = '';
	if($module == '' or !sizeOf($this->modules)) return $str;
	foreach($this->modules as $m){
	    if($m->id == $module)
		$str = $m->text;
	}
	return $str;
    }
    
    public function get_module_by_name($name){
	if(!sizeOf($this->modules)) return false;
	foreach($this->modules as $k=>$module){
	    if(get_class($module) == $name){
		return $this->modules[$k];
	    }
	}
	return false;
    }
    
    public function get_module_by_id($id){
	if(!sizeOf($this->modules)) return false;
	foreach($this->modules as $k=>$module){
	    if($module->id == $id){
		return $this->modules[$k];
	    }
	}
	return false;
    }

	public function parse_ini_string_m($str) {
	    
	    if(empty($str)) return false;

	    $lines = explode("\r\n", $str);
	    $ret = Array();
	    $inside_section = false;

	    foreach($lines as $line) {
		
		$line = trim($line);

		if(!$line || $line[0] == "#" || $line[0] == ";") continue;
		
		if($line[0] == "[" && $endIdx = strpos($line, "]")){
		    $inside_section = substr($line, 1, $endIdx-1);
		    continue;
		}

		if(!strpos($line, '=')) continue;

		$tmp = explode("=", $line, 2);

		if($inside_section) {
		    
		    $key = rtrim($tmp[0]);
		    $value = ltrim($tmp[1]);

		    if(preg_match("/^\".*\"$/", $value) || preg_match("/^'.*'$/", $value)) {
		        $value = mb_substr($value, 1, mb_strlen($value) - 2);
		    }

		    $t = preg_match("^\[(.*?)\]^", $key, $matches);
		    if(!empty($matches) && isset($matches[0])) {

		        $arr_name = preg_replace('#\[(.*?)\]#is', '', $key);

		        if(!isset($ret[$inside_section][$arr_name]) || !is_array($ret[$inside_section][$arr_name])) {
		            $ret[$inside_section][$arr_name] = array();
		        }

		        if(isset($matches[1]) && !empty($matches[1])) {
		            $ret[$inside_section][$arr_name][$matches[1]] = $value;
		        } else {
		            $ret[$inside_section][$arr_name][] = $value;
		        }

		    } else {
		        $ret[$inside_section][trim($tmp[0])] = $value;
		    }            

		} else {
		    
		    $ret[trim($tmp[0])] = ltrim($tmp[1]);

		}
	    }
	    return $ret;
	}    

    public function read_ini_data($ini_file){
	if(is_file($ini_file)){

		// UTF8 Problem
		$ini_iso88591 = file_get_contents($ini_file);
		$ini_utf8     = iconv("ISO-8859-1", "UTF-8", $ini_iso88591);
		$this->config    = $this->parse_ini_string_m($ini_utf8, TRUE);
		foreach($this->config as $space_name => $space){
			foreach($space as $k=>$v){
				$this->config[$space_name][$k] = str_replace("'",'',$v);
			}
		}
	}
    }
    
    public function get_install_field_data($field_data){
	    $src_str = ($field_data['src'] != '') ? xtc_draw_hidden_field('module_src['.$field_data['id'].']',$field_data['src']) : '';
	    $src_str .= $this->get_module_title($field_data['src']);
	    if(isset($this->config['module_type'][$field_data['id']])){
		$field_data['type'] =  $this->config['module_type'][$field_data['id']];
	    }else{
	     if(!isset($field_data['type']))
		 $field_data['type'] = 'short_text';
	    }
	    
	    $type_str = xtc_draw_hidden_field('module_type['.$field_data['id'].']',$field_data['type']).$this->get_type_name($field_data['type']);
	    if($field_data['src'] == 'own_value'){
		$ov_val = (isset($this->config['module_src_own_value'][ $field_data['id'] ])) ? $this->config['module_src_own_value'][ $field_data['id'] ] : '';
		$src_str .= sprintf('<br />%s',xtc_draw_input_field('module_src_own_value['. $field_data['id'] .']',$ov_val,'size="32" maxlength="64"'));
		$field_data['type'] = 'short_text';
		$type_str = xtc_draw_hidden_field('module_type['. $field_data['id'] .']',$field_data['type']).$this->get_type_name($field_data['type']);
	    }else if($field_data['type'] == 'select'){
		$m = $this->get_module_by_id($field_data['src']);
		$src_str .= sprintf('<br />%s',xtc_draw_pull_down_menu('module_src_select_value['. $field_data['id'] .']',$m->values));
		$field_data['type'] = 'select';
		$type_str = xtc_draw_hidden_field('module_type['. $field_data['id'] .']',$field_data['type']).$this->get_type_name($field_data['type']);
	    }
	    return array(
		'id'=>$field_data['id'],

		'text'=>$field_data['text'],
		'type'=>$type_str,
		'mandatory'=>$field_data['mandatory'],
		'src'=>$src_str
	    );
    }
    
    private function get_type_name($type){
	foreach($this->types as $type_item){
	    if($type_item['id'] == $type) return $type_item['text'];
	}
	return basename(__FILE__).' get_type_name(): unknown type '.$type;
    }
    
    private function do_request_action(){
	if(!isset($_REQUEST['action'])) return false;
	switch($_REQUEST['action']){
	    case 'get_type_selector_html':
		$str = '<input type="hidden" name="module_type['.$_REQUEST['module'].']" value="'.$_REQUEST['value'].'" />';
		$str .= $this->get_type_name($_REQUEST['value']);
		$hide_selector = (isset($_REQUEST['hide_selector']) and $_REQUEST['hide_selector'] == 1) ? 1 : 0;
		die(json_encode(array(
		    'html'=>yes_encode_string($str),
		    'hide_selector'=>$hide_selector
		)));
		exit;
	    case 'get_source_selector_html':
		$m = $this->get_module_by_id($_REQUEST['value']);
		$str = '<input type="hidden" name="module_src['.$_REQUEST['module'].']" value="'.$_REQUEST['value'].'" />';
		$str .= $this->get_module_title($_REQUEST['value']);
		$hide_type_selector = 0;
		$change_type_selector = $m->type;
		if($_REQUEST['value'] == 'own_value'){
		    $change_type_selector = 'text';
		}
		if(isset($m->values) and sizeOf($m->values)){
		    $hide_type_selector = 1;
		    $change_type_selector = 'select';
		    $str .= '<br />'.xtc_draw_pull_down_menu('module_src_select_value['.$_REQUEST['module'].']',$m->values);
		}
		
		die(json_encode(array(
		    'html'=>yes_encode_string($str),
		    'hide_type_selector'=>$hide_type_selector,
		    'change_type_selector'=>$change_type_selector,
		    'change_default_input'=>((isset($m->change_default_input_function))?$m->change_default_input_function:'')
		)));
		exit;
	    case 'get_type_selector':
		$types_array = array();
		foreach($this->types as $type){
		    if($type['id'] != 'select')
			$types_array[] = $type;
		}
		$this->smarty->assign(array(
		    'baselink'=>xtc_href_link(basename($_SERVER['SCRIPT_FILENAME']),xtc_get_all_get_params(array('action'))),
		    'action'=>$_REQUEST['action'],
		    'module'=>$_REQUEST['module'],
		    'data_table_id'=>$this->data_table_id,
		    'modal_window_instance_id'=>$this->modal_window_instance_id,
		    'short_text_module_name'=>$this->get_type_name('short_text'),
		    'input'=>xtc_draw_pull_down_menu('type',$types_array,'')
		));
		header('Content-Type: text/html; charset='.CHARSET);
		$this->smarty->display('yes_export_modules_helper.html');
		exit;
		break;
	    case 'get_source_selector':
		$modules = array(array('id'=>'','text'=>TEXT_SELECT));
		$yep_modules = $this->get_modules();
		if(sizeOf($yep_modules)){
		    foreach($yep_modules as $module){
			$modules[] = array('id'=>$module->id,'text'=>$module->text);
		    }
		}
		$this->smarty->assign(array(
		    'baselink'=>xtc_href_link(basename($_SERVER['SCRIPT_FILENAME']),xtc_get_all_get_params(array('action'))),
		    'action'=>$_REQUEST['action'],
		    'module'=>$_REQUEST['module'],
		    'data_table_id'=>$this->data_table_id,
		    'modal_window_instance_id'=>$this->modal_window_instance_id,
		    'short_text_module_name'=>$this->get_type_name('short_text'),
		    'select_module_name'=>$this->get_type_name('select'),
		    'input'=>xtc_draw_pull_down_menu('src',$modules,'')
		));
		header('Content-Type: text/html; charset='.CHARSET);
		$this->smarty->display('yes_export_modules_helper.html');
		exit;
		break;
	} // EOF SWITCH action
    }
    
    public function write_ini_file($file){
	if(is_file($file)){
	    unlink($file);
	}
	$config_str = "[module_src]\r\n";
	if(isset($_REQUEST['module_src']) and sizeOf($_REQUEST['module_src'])){
	    foreach($_REQUEST['module_src'] as $module=>$src){
		$config_str .= sprintf("%s = '%s'\r\n",trim($module),$src);
	    }
	}
	$config_str .= "\r\n[module_type]\r\n";
	if(isset($_REQUEST['module_type']) and sizeOf($_REQUEST['module_type'])){
	    foreach($_REQUEST['module_type'] as $module=>$type){
		$config_str .= sprintf("%s = '%s'\r\n",trim($module),$type);
	    }
	}
	$config_str .= "\r\n[module_default_value]\r\n";
	if(isset($_REQUEST['module_default_value']) and sizeOf($_REQUEST['module_default_value'])){
	    foreach($_REQUEST['module_default_value'] as $module=>$type){
		$config_str .= sprintf("%s = '%s'\r\n",trim($module),$type);
	    }
	}
	$config_str .= "\r\n[module_mandatory]\r\n";
	if(isset($_REQUEST['mandatory']) and sizeOf($_REQUEST['mandatory'])){
	    foreach($_REQUEST['mandatory'] as $module=>$value){
		$config_str .= sprintf("%s = '%s'\r\n",trim($module),$value);
	    }
	}
	
	if (!$handle = fopen($file, "w")) {
	    print "Kann die Datei $file nicht schreiben";
	    exit;
	}
	if (!fwrite($handle, $config_str)) {
	    print "Kann in die Datei $file nicht schreiben - fehlerhafter/kein Content";
	    exit;
	}
	fclose($handle);
    }
}
