<?php
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
require_once(DIR_FS_INC.'xtc_productgroups.inc.php');
define('MODULE_AMAZON_TEXT_DESCRIPTION', 'Export - Amazon (Tab getrennt)');
define('MODULE_AMAZON_TEXT_TITLE', 'Amazon Produkte Export - CSV');
//define('MODULE_AMAZON_FILE_TITLE' , '<hr noshade>Dateiname');
//define('MODULE_AMAZON_FILE_DESC' , 'Geben Sie einen Dateinamen ein, falls die Exportdatei am Server gespeichert werden soll.<br>(Verzeichnis ebaymich/)');
define('MODULE_AMAZON_SORT_ORDER_TITLE', 'Sortierung');
define('MODULE_AMAZON_SORT_ORDER_DESC', 'Sortierung innerhalb Exportmodule');

define('MODULE_AMAZON_STATUS_DESC','Modulstatus');
define('MODULE_AMAZON_STATUS_TITLE','Status');
define('EXPORT_YES','Nur Herunterladen');
define('EXPORT_NO','Am Server Speichern');
define('EXPORT_LINKED_PRODUCTS','Verlinkte Produkte mit exportieren');
define('DATE_FORMAT_EXPORT', '%d.%m.%Y');  // this is used for strftime()
define('TABLE_PERSONAL_OFFERS_BY','personal_offers_by_customers_status_');
define('MODULE_AMAZON_LANGUAGE_ID',2);
define('MODULE_AMAZON_EXPORT_CSV_SEPARATOR',"\t");
// include needed functions

  class amazon extends products_export{
    var $code, $title, $description, $enabled,$categories_string,$selected_categories,$Groups,$sort_order;


    function __construct() {
      global $order;

      $this->TextSign = '';
      $this->code = 'amazon';
      $this->title = MODULE_AMAZON_TEXT_TITLE;
      $this->description = MODULE_AMAZON_TEXT_DESCRIPTION;
      $this->sort_order = (defined('MODULE_AMAZON_SORT_ORDER'))?MODULE_AMAZON_SORT_ORDER:0;
      $this->enabled = ((defined('MODULE_AMAZON_STATUS') and MODULE_AMAZON_STATUS == 'True') ? true : false);
      $this->only_active_products = false;
      $this->only_active_categories = false;
      $this->max_items_per_step = 1000;
    }

    function get_sql( $order = true ){
	if(isset($_REQUEST['export_linked_products']) and $_REQUEST['export_linked_products'] == 1){
		$linked_sql = "";
	}else{
		$linked_sql = " GROUP BY products_id ";
	}
	$export_query_raw = "SELECT ap.sku, ap.asin,
			p.products_id,
			p.products_ean,
			p.products_model,
			p.products_image,
			p.products_sort,
			p.products_price,
			DATE_FORMAT(p.products_date_available,'%d.%m.%y') as available,
			p.products_weight,
			p.products_status,
			p.products_fsk18,
			p.size_width,
			p.size_height,
			p.size_depth,
			p.products_listing_status,				
			p.products_startpage,
			p.products_startpage_sort,
			p.products_master,
			p.products_master_status,
			p.products_shippingtime,
			p.products_meldebestand,
			p.meldebestand_active,
			p.price_fixing,
			p.manufacturers_id ";
	if($_REQUEST['exporttype'] == 'unallocated'){
		$export_query_raw .= " FROM 
		 products p LEFT JOIN amazon_products ap USING(products_id),products_to_categories p2c 
		 WHERE ap.products_id IS NULL AND p2c.products_id=p.products_id
		".$this->getP2CWhereSQLString($_REQUEST['allCat'],$_REQUEST['cat'])." 
		".$linked_sql;
	}else{
		$export_query_raw .= " FROM
			products_to_categories p2c LEFT JOIN
			" . TABLE_PRODUCTS . " p USING (products_id),
			 amazon_products ap 
			WHERE p.products_id > 0 and p.products_id=ap.products_id 
			".$this->getP2CWhereSQLString($_REQUEST['allCat'],$_REQUEST['cat'])." 
			".$linked_sql;
	}
	if($order){
	    return $export_query_raw . " ORDER BY p.products_date_added DESC";
	}else{
	    return $export_query_raw;
	}
	
    }
    
    function get_schema(){
	$schema_array = array(
		'ProductID',
		'ProductName',
		'StandardProductID',
		'ProductIDType',
		'ManufacturerPartNumber',
		'Manufacturer',
		'Quantity',
		'ItemPrice',
		'Currency',
		'Description',
		'BulletPoint1',
		'BulletPoint2',
		'BulletPoint3',
		'BulletPoint4',
		'BulletPoint5',
		'MainImageURL',
		'OtherImageURL1',
		'OtherImageURL2',
		'OtherImageURL3',
		'OtherImageURL4',
		'OtherImageURL5',
		'OtherImageURL6',
		'OtherImageURL7',
		'OtherImageURL8',
		'RelationshipType',
		'Parentage',
		'ParentSKU',
		'ASIN',
		'SKU',
	    'GenericKeywords1',
	    'GenericKeywords2',
	    'GenericKeywords3',
	    'GenericKeywords4',
	    'GenericKeywords5',
            'ItemWeight'
	);
	$data = array();
	foreach($schema_array as $r){
		$data[] = sprintf('"%s"',$r);
	}
	return $data;
    }
    
    public function get_total_number_of_items(){
	$query = xtc_db_query($this->get_sql(false));
	return xtc_db_num_rows($query);
    }
    function process_header(){
	$basics = new basics;
	$str = implode(MODULE_AMAZON_EXPORT_CSV_SEPARATOR, $this->get_schema())."\r\n";
	if(is_file($this->tmp_directory.'/00_HEADER.CSV'))
	    unlink($this->tmp_directory.'/00_HEADER.CSV');
	$basics->create_file($this->tmp_directory.'/00_HEADER.CSV', $str);
    }
    
    function process_page($page,$max_items_per_step){
        global $InstanceCache;
	$basics = new basics;

	// mario - 19.01.2013
	if(!isset($this->language_id)) {
            $this->language_id = (isset($_SESSION['languages_id']))?$_SESSION['languages_id']:2;
        }
        
        $gh = new \YES4Trade\Model\group_handler($this->language_id);
	
        @xtc_set_time_limit(0);
        require(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');
	$status = (defined('MODULE_OTHER_AMAZON_CUSTOMERS_STATUS_ID')) ? MODULE_OTHER_AMAZON_CUSTOMERS_STATUS_ID : 1;
        $xtPrice = new xtcPrice(DEFAULT_CURRENCY,$status);
	if((is_array($_REQUEST['cat']) and sizeOf($_REQUEST['cat'])>0) or $_REQUEST['allCat'] == '1'){
	    
	}else{
	    return false;
	}
	$page_sql = $this->get_sql();
	$page_sql .= sprintf(' LIMIT %s, %s',$page*$max_items_per_step,$max_items_per_step);
	$items = array();
	$query = xtc_db_query($page_sql);
	while($products = xtc_db_fetch_array($query)){
            $products_tax_class_id = yes_eu_oss_get_products_tax_class_id(
                $products['products_id'], STORE_COUNTRY
            );
            $item_weight = number_format(xtc_get_ext_products_weight($products['products_id'], false),2,'.','');
	    $SQ = new products_quantity($products['products_id']);
	    $desc_query = xtc_db_query(sprintf(
		    "SELECT * FROM products_description WHERE products_id=%s and language_id=%s",
		    $products['products_id'],MODULE_AMAZON_LANGUAGE_ID
	    ));
	    $desc = xtc_db_fetch_array($desc_query);
	    $manufacturer = '';
	    if($products['manufacturers_id'] > 0){
		    $manu_query = xtc_db_query(sprintf(
			    "SELECT manufacturers_name FROM manufacturers WHERE manufacturers_id=%s",
			    $products['manufacturers_id']
		    ));
		    $manu = xtc_db_fetch_array($manu_query);
		    $manufacturer = $manu['manufacturers_name'];
	    }
	    $products_price = $xtPrice->xtcGetPrice(
		    $products['products_id'],
		    $format=false,
		    1,
		    $products_tax_class_id,
		    ''
	    );
            $products_characteristics_data = [];
            $allocs = $gh->get_allocated_product_group_characteristic_values($products['products_id']);
            if(is_countable($allocs) and sizeOf($allocs)){
                $products_characteristics_data = $allocs;
            }


	    $bullet1 = '';
	    $bullet2 = '';
	    $bullet3 = '';
	    $bullet4 = '';
	    $bullet5 = '';
	    if(sizeOf($products_characteristics_data)){
		    $current_counter = 0;
		    $max_counter = 4;
		    $bullet_counter = 0;
		    $max_bullets = 5;
		    $bullets = array();
		    for($i=0;$i<$max_bullets;$i++){
			    if(!isset($bullets[$i]))
				    $bullets[$i] = array();
		    }
		    foreach($products_characteristics_data as $pcd){
			    $bullets[$bullet_counter][] = $this->prepare_string($pcd['title'].' '.$pcd['value']);
			    $current_counter++;
			    if($current_counter >= $max_counter){
				    $current_counter = 0;
				    $bullet_counter++;
			    }
		    }
		    $bullet1 = implode('; ',$bullets[0]);
		    $bullet2 = implode('; ',$bullets[1]);
		    $bullet3 = implode('; ',$bullets[2]);
		    $bullet4 = implode('; ',$bullets[3]);
		    $bullet5 = implode('; ',$bullets[4]);
	    }
	    // EOF GRUPPEN

	    // BOF BILDER
	    $pics = array();
	    if($products['products_image'] != ''){
		    $pics[] = $this->get_picture_url($products['products_image']);
	    }
	    $pics_query = yes_db_query(sprintf("SELECT image_name FROM products_images WHERE products_id=%s AND noshop=0 LIMIT 8",$products['products_id']));
	    if(yes_db_num_rows($pics_query)){
		    foreach($pics_query as $pic){
			    $pics[] = $this->get_picture_url($pic['image_name']);
		    }
	    }
	    // EOF BILDER

	    // BOF MASTER/SLAVES
	    $master_query = xtc_db_query(sprintf(
		    "SELECT COUNT(products_id) as anz FROM products WHERE products_master=%s",
		    $products['products_id']
	    ));
	    $is_master = xtc_db_fetch_array($master_query);
	    $parentage = '';
	    $parent_sku = '';
	    if($is_master['anz']>0){
		    $parentage = 'Parent';
	    }
	    $relationship_type = ($products['products_master']>0) ? 'Variation' : '';
	    if($relationship_type != ''){
		    $parentage = 'Child';
		    $parent_sku_query = xtc_db_query(sprintf(
			    "SELECT sku FROM amazon_products WHERE products_id=%s",
			    $products['products_master']
		    ));
                    if(xtc_db_num_rows($parent_sku_query)){
                        $parent_sku_res = xtc_db_fetch_array($parent_sku_query);
                        $parent_sku = $parent_sku_res['sku'];
                    }else{
                        $parent_sku = $products['products_master'];
                    }
	    }
	    // EOF MASTER/SLAVES
			
	    $row = array(
		$products['products_id'],
		$this->prepare_string($desc['products_name']),
		$products['products_ean'],
		'EAN',
		$products['products_model'],
		$this->prepare_string($manufacturer),
		$SQ->get_available1_qty(),
		number_format($products_price,2,'.',''),
		'EUR',
		nl2br($this->prepare_string($desc['products_description_amazon'],true,true)),
		$bullet1,
		$bullet2,
		$bullet3,
		$bullet4,
		$bullet5,
		$pics[0],
		$pics[1],
		$pics[2],
		$pics[3],
		$pics[4],
		$pics[5],
		$pics[6],
		$pics[7],
		$pics[8],
		$relationship_type,
		$parentage,
		$parent_sku,
		((isset($products['asin'])) ? $products['asin'] : ''),
		((isset($products['sku'])) ? $products['sku'] : $products['products_id']),
		$desc['amazon_generic_keywords1'],
		$desc['amazon_generic_keywords2'],
		$desc['amazon_generic_keywords3'],
		$desc['amazon_generic_keywords4'],
		$desc['amazon_generic_keywords5'],
                $item_weight
	    );
	    $data = array();
	    foreach($row as $r){
		    $data[] = sprintf('"%s"',$r);
	    }
	    $items[] = $data;
	    if(sizeOf($items)){
		$str = '';
		foreach($items as $row){
		    $str .= implode(MODULE_AMAZON_EXPORT_CSV_SEPARATOR,$row)."\r\n";
		}
		$basics->create_file($this->tmp_directory.'/PAGE_'.$page.'.CSV', $str);
	    }
	}
    }

    function process($file) {
	$basics = new basics;

	// mario - 19.01.2013
	if(!isset($this->language_id)) {
            $this->language_id = $_SESSION['languages_id'];
        }
	
	$gh = new \YES4Trade\Model\group_handler($this->language_id);
        @xtc_set_time_limit(0);
        require(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');
	$status = (defined('MODULE_OTHER_AMAZON_CUSTOMERS_STATUS_ID')) ? MODULE_OTHER_AMAZON_CUSTOMERS_STATUS_ID : 1;
        $xtPrice = new xtcPrice(DEFAULT_CURRENCY,$status);
	if((is_array($_POST['cat']) and sizeOf($_POST['cat'])>0) or $_POST['allCat'] == '1'){

		$export_query = xtc_db_query($export_query_raw);
		while ($products = xtc_db_fetch_array($export_query)) {
                    $products_tax_class_id = yes_eu_oss_get_products_tax_class_id(
                            $products['products_id'], STORE_COUNTRY
                    );
			$SQ = new products_quantity($products['products_id']);
			$desc_query = xtc_db_query(sprintf(
				"SELECT * FROM products_description WHERE products_id=%s and language_id=%s",
				$products['products_id'],MODULE_AMAZON_LANGUAGE_ID
			));
			$desc = xtc_db_fetch_array($desc_query);
			$manufacturer = '';
			if($products['manufacturers_id'] > 0){
				$manu_query = xtc_db_query(sprintf(
					"SELECT manufacturers_name FROM manufacturers WHERE manufacturers_id=%s",
					$products['manufacturers_id']
				));
				$manu = xtc_db_fetch_array($manu_query);
				$manufacturer = $manu['manufacturers_name'];
			}
			$products_price = $xtPrice->xtcGetPrice(
				$products['products_id'],
				$format=false,
				1,
				$products_tax_class_id,
				''
			);
			// BOF - GRUPPEN
			$products_characteristics_data = array();
                        $allocs = $gh->get_allocated_product_group_characteristic_values($products['products_id']);
                        if(is_countable($allocs) and sizeOf($allocs)){
                            $products_characteristics_data = $allocs;
                        }
                        
			$bullet1 = '';
			$bullet2 = '';
			$bullet3 = '';
			$bullet4 = '';
			$bullet5 = '';
			if(sizeOf($products_characteristics_data)){
				$current_counter = 0;
				$max_counter = 4;
				$bullet_counter = 0;
				$max_bullets = 5;
				$bullets = array();
				for($i=0;$i<$max_bullets;$i++){
					if(!isset($bullets[$i]))
						$bullets[$i] = array();
				}
				foreach($products_characteristics_data as $pcd){
					$bullets[$bullet_counter][] = $this->prepare_string($pcd['title'].' '.$pcd['value']);
					$current_counter++;
					if($current_counter >= $max_counter){
						$current_counter = 0;
						$bullet_counter++;
					}
				}
				$bullet1 = implode('; ',$bullets[0]);
				$bullet2 = implode('; ',$bullets[1]);
				$bullet3 = implode('; ',$bullets[2]);
				$bullet4 = implode('; ',$bullets[3]);
				$bullet5 = implode('; ',$bullets[4]);
			}
			// EOF GRUPPEN
			
			// BOF BILDER
			$pics = array();
			if($products['products_image'] != ''){
				$pics[] = $this->get_picture_url($products['products_image']);
			}
			$pics_query = yes_db_query(sprintf("SELECT image_name FROM products_images WHERE products_id=%s AND noshop=0 LIMIT 8",$products['products_id']));
			if(yes_db_num_rows($pics_query)){
				foreach($pics_query as $pic){
					$pics[] = $this->get_picture_url($pic['image_name']);
				}
			}
			// EOF BILDER
			 
			// BOF MASTER/SLAVES
			$master_query = xtc_db_query(sprintf(
				"SELECT COUNT(products_id) as anz FROM products WHERE products_master=%s",
				$products['products_id']
			));
			$is_master = xtc_db_fetch_array($master_query);
			$parentage = '';
			$parent_sku = '';
			if($is_master['anz']>0){
				$parentage = 'Parent';
			}
			$relationship_type = ($products['products_master']>0) ? 'Variation' : '';
			if($relationship_type != ''){
				$parentage = 'Child';
				$parent_sku_query = xtc_db_query(sprintf(
					"SELECT sku FROM amazon_products WHERE products_id=%s",
					$products['products_master']
				));
				$parent_sku_res = xtc_db_fetch_array($parent_sku_query);
				$parent_sku = $parent_sku_res['sku'];
			}
			
			// EOF MASTER/SLAVES
			
			$row = array(
			    $products['products_id'],
			    $this->prepare_string($desc['products_name']),
			    $products['products_ean'],
			    'EAN',
			    $products['products_model'],
			    $this->prepare_string($manufacturer),
			    $SQ->get_available1_qty(),
			    number_format($products_price,2,'.',''),
			    'EUR',
			    $this->prepare_string($desc['products_description'], true,true),
			    $bullet1,
			    $bullet2,
			    $bullet3,
			    $bullet4,
			    $bullet5,
			    $pics[0],
			    $pics[1],
			    $pics[2],
			    $pics[3],
			    $pics[4],
			    $pics[5],
			    $pics[6],
			    $pics[7],
			    $pics[8],
			    $relationship_type,
			    $parentage,
			    $parent_sku,
			    ((isset($products['asin'])) ? $products['asin'] : ''),
			    ((isset($products['sku'])) ? $products['sku'] : $products['products_id']),
			    $desc['amazon_generic_keywords1'],
			    $desc['amazon_generic_keywords2'],
			    $desc['amazon_generic_keywords3'],
			    $desc['amazon_generic_keywords4'],
			    $desc['amazon_generic_keywords5'],
                            $weight
			);
			$data = array();
			foreach($row as $r){
				$data[] = sprintf('"%s"',$r);
			}
			$items[] = $data;
		}
		// create File
		$fp = fopen(DIR_FS_CATALOG.'../ebaymich/' . $file, "w+");
		fputs($fp, $schema);
		fclose($fp);


		switch ($_POST['export']) {
        	case 'yes':
			// send File to Browser
			$extension = substr($file, -3);
			
			$crypt_file = yes_get_sha1_from_string( date('d.m.Y_H.i.s') );
			$filename = sprintf('yes_amazon_artikel_%s.csv',$crypt_file);
			$filepath = \main::get_exportdata_path();
			$basics->create_file($filepath.$filename,$schema);
			$basics->zip_file($filepath,$filename,$filename.'.zip',true);

			$file_contents = $basics->read_file_content($filepath.$filename.'.zip',$mode='rb');
			unlink($filepath.$filename.'.zip');
			// send File to Browser
			$file = 'yes_artikel_'.date('Y-m-d_H_i_s').'.zip';
			header('Content-Type: application/octet-stream');
			header('Content-Transfer-Encoding: binary');
			header('Content-disposition: attachment; filename=' . $file);
			echo $file_contents;
			exit;
			break;
        	}
	} // end if categories_array

    }


    function display() {
		/* WIR WOLLEN AUSGEWAEHLTE KATEGORIEN EXPORTEN */
		$array = array('text' =>  $this->getCategoryJSString().'<br />'.
			'<script type="text/javascript">'.
			"   $().ready(function(){
			    $('.start_lbon_export_button').click(function(){
				$('#modal_window').dialog({title: 'Export'}).load(
				    '".xtc_href_link(FILENAME_MODULE_EXPORT,xtc_get_all_get_params(array('action')).'&action=save_stepwise')."&'+$('form[name=\"modules\"]').serialize(),
					function(){
					    hidePreloader();
					}
				).html('<p align=\"center\"><img src=\"images/loading.gif\" alt=\"Loading\" title=\"Loading\"><br />loading...</p>');
				return false;
			    });
			   });
			</script>".
			/*EXPORT_TYPE.'<br />'.
			EXPORT.'<br />'.
			xtc_draw_radio_field('export', 'no',false).EXPORT_NO.'<br />'.
			xtc_draw_radio_field('export', 'yes',true).EXPORT_YES.'<br /><br />'.
			 * 
			 */
			'<hr noshade="noshade"><b>Exporttyp:</b> '.xtc_draw_pull_down_menu('exporttype',array(
				array('id'=>'unallocated','text'=>'Unzugewiesene'),
				array('id'=>'allocated','text'=>'Zugewiesene')
			)).'<br /><br />'.
			'<b>Exportiere Produkte aus Kategorie:</b><br />'.
			'<input type="checkbox" name="allCat" value="1" CHECKED onclick="allCatFunc();"> Alle Kategorien<br />'.
			$this->getCategoriesString().
			'<input type="checkbox" name="export_linked_products" value="1" />'.EXPORT_LINKED_PRODUCTS.'<br />'.
			'<br />'.yes_draw_href_button(IMAGE_EXPORT,'javascript:','width:120px;','button','start_lbon_export_button ui-button ui-corner-all ui-state-default') . '&nbsp;' .
			/*'<br />' . xtc_image_submit('button_export.gif',IMAGE_EXPORT) .*/
			//'<a href="'.xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=amazon').'">'.xtc_image_button('button_cancel.gif',IMAGE_CANCEL).'</a>'
			    yes_draw_href_button(IMAGE_CANCEL,xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=bestand'),'width:120px;')
		);
		return $array;
    }
	
	function prepare_string($string,$replace_gaense=true, $strip_tags = false){
		if($replace_gaense)
			$string = str_replace('"','""',$string);
                if($strip_tags){
                    $string = strip_tags($string,'<br><br /><br/><b><p><i><u>');
                }
		return html_entity_decode($string);
	}

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_AMAZON_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }
	
	function get_picture_url($image_name,$path='popup_images'){
		return sprintf(HTTP_CATALOG_SERVER . 'images/product_images/%s/%s',$path, $image_name);
	}

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_AMAZON_SORT_ORDER', '0',  '6', '1', '', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_AMAZON_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
	}

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_AMAZON_STATUS','MODULE_AMAZON_SORT_ORDER');
    }

  }
