<?php
require_once("includes/classes/class.storagequantity.php");
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_WS_CLASSES.'product.php');
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
if(!isset($_SESSION['languages_id'])) {
    $_SESSION['languages_id'] = 2;
}
define('MODULE_BESTAND_TEXT_DESCRIPTION', 'Hier k&ouml;nnen Sie sich die Best&auml;nde Ihrer Artikel im CSV Format exportieren. (Es werden keine St&uuml;cklistenartikel exportiert) Dabei k&ouml;nnen Sie einzelne Produktgruppen filtern. Ben&ouml;tigte Berechtigung: f_bestand');
define('MODULE_BESTAND_TEXT_TITLE', 'Bestandsexport - CSV');
define('MODULE_BESTAND_SORT_ORDER_TITLE', 'Sortierung');
define('MODULE_BESTAND_SORT_ORDER_DESC', 'Sortierung innerhalb Exportmodule');
define('MODULE_BESTAND_STATUS_TITLE','Status');
define('MODULE_BESTAND_STATUS_DESC','Modulstatus');
define('MODULE_BESTAND_EXPORTTEXT','<br />Es wird im CSV Format exportiert, der Texttrenner ist Tabulator.');
define('BESTAND_CSV_SEPARATOR',"\t");
define('MODULE_BESTAND_GROUP','Produktgruppe');
define('MODULE_BESTAND_SET','Merkmal %s');
define('MODULE_BESTAND_SET_NO_SETS','Produktgruppe hat keine Merkmale');
define('MODULE_BESTAND_FILE','bestandsexport.csv');

// include needed functions

  class bestand extends products_export{
    var $code, $title, $description, $enabled,$sort_order,$tmp_directory;
    var $max_items_per_step,$from_cron,$export_config,$save_path;


    function __construct(){
	$this->code = 'bestand';
	$this->title = MODULE_BESTAND_TEXT_TITLE;
	$this->description = MODULE_BESTAND_TEXT_DESCRIPTION;
	$this->sort_order = (defined('MODULE_BESTAND_SORT_ORDER')) ? MODULE_BESTAND_SORT_ORDER:0;
	$this->enabled = ((defined('MODULE_BESTAND_STATUS') and MODULE_BESTAND_STATUS == 'True') ? true : false);
	$this->max_items_per_step = 1000;
	$this->from_cron = (isset($_SERVER['REMOTE_ADDR'])) ? false : true;
	$sets = array();
	if(!$this->from_cron){
	    foreach($_REQUEST as $k=>$v){
		    if(strstr($k,'set_')){
			    if($v != 'ALL'){
				    $set = current(array_reverse(explode('set_',$k)));
				    $sets[] = array('id'=>$set,'value'=>$v);
			    }
		    }
	    }
	}
	$this->export_config = array(
	    'group'=>(isset($_REQUEST['groups_id']) and $_REQUEST['groups_id'] > 0) ? (int)xtc_db_input($_REQUEST['groups_id']) : false,
	    'sets'=>$sets,
	    'cat'=>(isset($_REQUEST['cat']) and sizeOf($_REQUEST['cat'])) ? $_REQUEST['cat'] : array(),
	    'allCat'=>(isset($_REQUEST['allCat']) and $_REQUEST['allCat'] == 1) ? true : false,
	    'language_id'=>(isset($_SESSION['languages_id'])) ? $_SESSION['languages_id'] : 2,
	    'particle_path'=>\main::get_exportdata_path().'BESTAND_EXPORT/',
	    'start'=>0
	);
    }
    
    function get_count_sql(){
	if($this->export_config['group'] == 'ALL')
		$group = false;
	$query_raw = "SELECT p.products_id FROM products p LEFT JOIN products_collies pcol USING(products_id) ";
	$query_raw .= " WHERE pcol.products_id IS NULL ";
	return $query_raw;
    }
    function get_sql(){
	if($this->export_config['group'] == 'ALL')
		$group = false;
	$query_raw = "SELECT p.products_id,p.products_model,p.products_price,pd.products_name,p.products_ean,p.products_quantity FROM products_description pd LEFT JOIN products_collies pcol USING(products_id) ";
	if(sizeOf($this->export_config['sets'])>0)
		$query_raw .= ", products_characteristic_set pcs, products_characteristic pc ";
	if(sizeOf($this->export_config['sets'])>0)
		$query_raw .= ", products_to_characteristics ptc ";
	if(sizeOf($this->export_config['cat'])){
		$query_raw .= ", products_to_categories p2c ";
	}

	$query_raw .= ", products p ";
	if($group)
		$query_raw .= " LEFT JOIN groups_allocations ga USING(products_id) ";

	$query_raw .= " WHERE pd.products_id=p.products_id AND pd.language_id='".$this->export_config['language_id']."' and pcol.products_id IS NULL ";
	if($group)
		$query_raw .= " AND ga.groups_id='".$group."' ";
	if(sizeOf($this->export_config['sets'])>0){
		$query_raw .= " and ptc.products_id=p.products_id and ga.groups_id=pc.groups_id AND pcs.products_characteristic_id=pc.products_characteristic_id AND ptc.products_characteristic_set_id=pcs.products_characteristic_set_id AND (";
		$query_raw_set = '';
		foreach($this->export_config['sets'] as $k=>$v){
			$query_raw_set .= "  (pc.products_characteristic_id='".$v['id']."' ";
			if( $v['value'] != 'ALL' ){
				$query_raw_set .= "AND pcs.products_characteristic_set_id='".$v['value']."'";
			}
			$query_raw_set .= ") OR ";
		}
		$query_raw_set = substr($query_raw_set,0,(strlen($query_raw_set)-3));
		$query_raw .= $query_raw_set.' ) ';
	}
	if(sizeOf($this->export_config['cat'])){
		$query_raw .= " AND p.products_id=p2c.products_id ".$this->getP2CWhereSQLString($this->export_config['allCat'],$this->export_config['cat']);
	}
	return $query_raw;
    }
    
    function get_schema(){
	$schema = array(
	    'products_id'
	);
	if(defined('MODULE_OTHER_AMAZON_STATUS') and MODULE_OTHER_AMAZON_STATUS == 'True'){
	    $schema[] = 'Amazon SKU';
	}
	$schema[] = 'products_model';
	$schema[] = 'products_price';
	$schema[] = 'products_name';
	$schema[] = 'ebay_title';
	$schema[] = 'products_ean';
	$schema[] = 'Phys. Bestand';
	$schema[] = 'Verfgb. 1';
	$schema[] = 'Verfgb. 2';
	$schema[] = 'Meldebestand';
	$schema[] = 'Erscheinungsdatum';
	if(defined('MODULE_OTHER_AMAZON_STATUS') and MODULE_OTHER_AMAZON_STATUS == 'True'){
	    $schema[] = 'Amazon Bestand';
	}
	$schema[] = 'eBay Bestand';
	$schema[] = 'In Auftr.';
	$schema[] = 'Bestellungen';
	$schema[] = 'EK Preis (neuester)';
	$schema[] = 'Lieferant des EK Preises';
	return $schema;
    }
    
    public function get_total_number_of_items(){
	$query = xtc_db_query($this->get_sql());
	return xtc_db_num_rows($query);
    }
    
    function process_header(){
	$basics = new basics;
	$str = implode(BESTAND_CSV_SEPARATOR, $this->get_schema())."\r\n";
	if(is_file($this->tmp_directory.'/00_HEADER.CSV'))
	    unlink($this->tmp_directory.'/00_HEADER.CSV');
	$basics->create_file($this->tmp_directory.'/00_HEADER.CSV', $str);
    }

    function process_page($page,$max_items_per_step){
	$basics = new basics;
	if(!xtc_check_permission('f_bestand')){
			die(MODULE_ACCESS_ERROR);
	}
	$page_sql = $this->get_sql();
	$page_sql .= sprintf(' LIMIT %s, %s',$page*$max_items_per_step,$max_items_per_step);
	
	$items = array();
	$query = xtc_db_query($page_sql);
	$num_rows = xtc_db_num_rows($query);
	while($record = xtc_db_fetch_array($query)){
	    $product = new product($record['products_id']);
	    $SQ = new products_quantity($record['products_id']);
	    $schema = array(
		$record['products_id']
	    );
	    if(defined('MODULE_OTHER_AMAZON_STATUS') and MODULE_OTHER_AMAZON_STATUS == 'True'){
		$amz_values = yes_get_products_amazon_values($record['products_id']);
		$amz_sku = (isset($amz_values['sku'])) ? $amz_values['sku'] : '';
		$schema[] = $amz_sku;
	    }
	    $schema[] = $product->info['products_model'];
	    $schema[] = number_format($product->info['products_price'],2,',','.');
	    $schema[] = $product->info['products_name'];
	    $schema[] = $product->info['ebay_title'];
	    $schema[] = $product->info['products_ean'];
	    $schema[] = $SQ->get_products_total_qty();
	    $schema[] = $SQ->get_available1_qty();
	    $schema[] = $SQ->get_available2_qty();
	    $schema[] = $product->info['products_meldebestand'];
	    $schema[] = $product->info['products_date_available'];
	    if(defined('MODULE_OTHER_AMAZON_STATUS') and MODULE_OTHER_AMAZON_STATUS == 'True'){
		$schema[] = $SQ->get_amazon_qty();
	    }
	    $schema[] = $SQ->get_auction_qty();
	    $schema[] = $SQ->get_not_shipped_qty();
	    $doquery = xtc_db_query(sprintf(
		    "SELECT SUM(dop.products_quantity-dop.qty_rueckbuch) AS anz FROM distributor_orders_products dop LEFT JOIN distributor_orders do USING(distributor_orders_id) WHERE dop.products_id=%s AND do.orders_status IN(%s)",
		    $record['products_id'],implode(',',array(2))
	    ));
	    $dorecord = xtc_db_fetch_array($doquery);
	    $schema[] = (int)$dorecord['anz'];
	    $ek_price_query = xtc_db_query("SELECT dp.price,d.name FROM distributor_product_prices dp LEFT JOIN distributors d ON dp.distributor_id = d.id WHERE products_id='".$record['products_id']."' ORDER BY dp.date_saved DESC LIMIT 1");
	    $ek_price = xtc_db_fetch_array($ek_price_query);
	    $schema[] = number_format($ek_price['price'],2,',','.');
	    $schema[] = $ek_price['name'];
	    $items[] = $schema;
	}
        if(sizeOf($items)){
	    $str = '';
	    foreach($items as $row){
		$str .= implode(BESTAND_CSV_SEPARATOR,$row)."\r\n";
	    }
	    $basics->create_file($this->tmp_directory.'/PAGE_'.$page.'.CSV', $str);
	}
    }
    
    function process($file) {
	$basics = new basics;
	if(is_dir($this->export_config['particle_path'])){
	    $files = $basics->get_directory_content($this->export_config['particle_path']);
	    foreach($files as $f){
		if(!strstr($f,'PART_')){
		    continue;
		}
		$strpos1 = strpos($f,'_')+1;
		$str1 = substr($f,$strpos1);
		$strpos2 = strpos($str1,'.');
		$_start = (int)substr($str1,0,$strpos2);
		if($_start >= $this->export_config['start']){
		    $this->export_config['start'] = $_start+$this->max_items_per_step;
		}
	    }
	}
	if($this->export_config['start'] == 0){
	    if(is_dir($this->export_config['particle_path'])){
		    $files = $basics->get_directory_content($this->export_config['particle_path']);
		    foreach($files as $f){
			    unlink($this->export_config['particle_path'].$f);
		    }
		    rmdir($this->export_config['particle_path']);
	    }
	    mkdir($this->export_config['particle_path']) or die(get_current_user().": cant create folder ".$this->export_config['particle_path']);
	}

	$count_export_query = xtc_db_query($this->get_count_sql());
	$num_total = xtc_db_num_rows($count_export_query);

	$query_raw = $this->get_sql();
	$query_raw .= sprintf(" LIMIT %s, %s",$this->export_config['start'],$this->max_items_per_step);
	$query = xtc_db_query($query_raw);
	if(!xtc_db_num_rows($query)){
	    die("\r\nEs wurden keine Artikel exportiert\r\n");
	}

	$row = '';
	$pids = array();
	$header = $this->get_schema();
	$schema = '';
	$counter = 0;
	$items = array();
	while($products = xtc_db_fetch_array($query)){
	    if(!in_array($products['products_id'],$pids)){
		$product = new product($products['products_id']);
		$SQ = new products_quantity($products['products_id']);
		$_schema = array(
		    $products['products_id']
		);
		if(defined('MODULE_OTHER_AMAZON_STATUS') and MODULE_OTHER_AMAZON_STATUS == 'True'){
		    $amz_values = yes_get_products_amazon_values($products['products_id']);
		    $amz_sku = (isset($amz_values['sku'])) ? $amz_values['sku'] : '';
		    $_schema[] = $amz_sku;
		}
		$_schema[] = $product->info['products_model'];
		$_schema[] = number_format($product->info['products_price'],2,',','.');
		$_schema[] = $product->info['products_name'];
		$_schema[] = $product->info['ebay_title'];
		$_schema[] = $product->info['products_ean'];
		$_schema[] = $SQ->get_products_total_qty();
		$_schema[] = $SQ->get_available1_qty();
		$_schema[] = $SQ->get_available2_qty();
		$_schema[] = $product->info['products_meldebestand'];
		$_schema[] = $product->info['products_date_available'];
		if(defined('MODULE_OTHER_AMAZON_STATUS') and MODULE_OTHER_AMAZON_STATUS == 'True'){
		    $_schema[] = $SQ->get_amazon_qty();
		}
		$_schema[] = $SQ->get_auction_qty();
		$_schema[] = $SQ->get_not_shipped_qty();
		$doquery = xtc_db_query(sprintf(
			"SELECT SUM(dop.products_quantity-dop.qty_rueckbuch) AS anz FROM distributor_orders_products dop LEFT JOIN distributor_orders do USING(distributor_orders_id) WHERE dop.products_id=%s AND do.orders_status IN(%s)",
			$products['products_id'],implode(',',array(2))
		));
		$dorecord = xtc_db_fetch_array($doquery);
		$_schema[] = (int)$dorecord['anz'];
		$ek_price_query = xtc_db_query("SELECT dp.price,d.name FROM distributor_product_prices dp LEFT JOIN distributors d ON dp.distributor_id = d.id WHERE products_id='".$products['products_id']."' ORDER BY dp.date_saved DESC LIMIT 1");
		$ek_price = xtc_db_fetch_array($ek_price_query);
		$_schema[] = number_format($ek_price['price'],2,',','.');
		$_schema[] = $ek_price['name'];
		$items[] = $_schema;
		$pids[] = $products['products_id'];
	    }
	}
	foreach($items as $products){
	    foreach($products as $k=>$v){
		$schema .= sprintf('"%s"%s',str_replace(array(BESTAND_CSV_SEPARATOR,'"'),array('&nbsp;',"'"),$v),BESTAND_CSV_SEPARATOR );
	    }
	    $schema .= "\r\n";
	    $counter++;
	}
	$filename = sprintf('PART_%s.csv',$this->export_config['start']);
	$basics->create_file($this->export_config['particle_path'].$filename, $schema);
	if( $this->export_config['start']+$this->max_items_per_step >= $num_total ){
		// KOMPLETT ERZEUGEN
		$schema = implode(BESTAND_CSV_SEPARATOR,$header)."\r\n";
		$files = $basics->get_directory_content($this->export_config['particle_path']);
		foreach($files as $f){
			$fp = fopen($this->export_config['particle_path'].$f,"rb");
			$schema .= fread($fp, filesize($this->export_config['particle_path']. $f));
			fclose($fp);
			unlink($this->export_config['particle_path'].$f);
		}
		$directory_without_slash = substr($this->export_config['particle_path'],0,strlen($this->export_config['particle_path'])-1);
		$basics->create_file($this->export_config['particle_path'] . $file, $schema);
		$basics->zip_file($directory_without_slash, $file, $file.'.zip', true);

		$save_path = ($this->from_cron) ? $this->save_path.'/' : DIR_FS_CATALOG.'files/';
		copy($this->export_config['particle_path']. $file.'.zip',$save_path.$file.'.zip');
		unlink($this->export_config['particle_path']. $file.'.zip');
		echo $this->save_path.'/'.$file.".zip wurde erzeugt\r\n";
		return $this->save_path.'/'.$file.".zip";
	}else{
		die("\r\nGENERATED FILE: $filename\r\n".'Start: '.$this->export_config['start'].' / Generated: '.$counter.' / Total: '.$num_total." / MAX: ".$this->max_items_per_step."\r\n");
	}
    }


    function display() {
		if(!xtc_check_permission('f_bestand')){
				return array(0=>array('text'=>MODULE_ACCESS_ERROR));
		}
		$array = array(
			'text' => $this->getCategoryJSString().MODULE_BESTAND_EXPORTTEXT.'<br /><br />'.
			'<script type="text/javascript">'.
			"  $('#product_groups').ready(function(){
				$('#product_groups').load('module_export.php?action=get_groups');
				$('#product_groups').show();  
			   });
			   $().ready(function(){
			    $('.start_lbon_export_button').click(function(){
				$('#modal_window').dialog({title: 'Export'}).load(
				    '".xtc_href_link(FILENAME_MODULE_EXPORT,xtc_get_all_get_params(array('action')).'&action=save_stepwise')."&'+$('form[name=\"modules\"]').serialize(),
					function(){
					    hidePreloader();
					}
				).html('<p align=\"center\"><img src=\"images/loading.gif\" alt=\"Loading\" title=\"Loading\"><br />loading...</p>');
				return false;
			    });
			   });
			function preselect_group(){
				myform = document.forms['modules'];
				gID = myform.groups_id.value;
				var base_url = '".xtc_href_link('module_export.php','action=get_groups')."';
				if(base_url.indexOf('?')>0)
					$('#product_groups').load(base_url+'&groups_id='+gID);
				else
					$('#product_groups').load(base_url+'?groups_id='+gID);
				$('#product_groups').show();
			}
			</script>".
			'<div style="width:100%;display:none;" id="product_groups"></div>'.
			'<b>Exportiere Produkte aus Kategorie:</b><br />'.
			'<input type="checkbox" name="allCat" value="1" CHECKED onClick="allCatFunc();"> Alle Kategorien<br />'.
			$this->getCategoriesString().
//			'<br />'.yes_draw_href_button(IMAGE_EXPORT,'','width:120px;','submit') . '&nbsp;' .
			'<br />'.yes_draw_href_button(IMAGE_EXPORT,'javascript:','width:120px;','button','start_lbon_export_button ui-button ui-corner-all ui-state-default') . '&nbsp;' .
			yes_draw_href_button(IMAGE_CANCEL,xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=bestand'),'width:120px;')
		);
		return $array;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_BESTAND_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
	xtc_db_query(sprintf(
		"DELETE FROM %s WHERE configuration_key IN('MODULE_BESTAND_STATUS','MODULE_BESTAND_SORT_ORDER')",
		TABLE_CONFIGURATION
	));
	xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_BESTAND_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
	xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_BESTAND_SORT_ORDER', '0',  '6', '1', '', now())");
	$q = xtc_db_query(sprintf(
		"SHOW COLUMNS FROM %s LIKE 'f_bestand'",
		TABLE_ADMIN_ACCESS
	));
	if(!xtc_db_num_rows($q)){
		xtc_db_query("ALTER TABLE " . TABLE_ADMIN_ACCESS . " ADD COLUMN `f_bestand` INT(1) NOT NULL");
	}
	xtc_db_query("UPDATE admin_access SET f_bestand=1 WHERE customers_id='1'");
    }

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
      xtc_db_query("ALTER TABLE " . TABLE_ADMIN_ACCESS . " DROP COLUMN `f_bestand`");
    }

    function keys() {
      return array('MODULE_BESTAND_STATUS','MODULE_BESTAND_SORT_ORDER');
    }
  }
