<?php
require_once("includes/classes/class.storagequantity.php");
require_once(DIR_FS_INC.'xtc_href_link_from_admin.inc.php');
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_FS_CATALOG.'includes/classes/xtcPrice.php');
require_once(DIR_WS_CLASSES.'product.php');
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
if(!isset($_SESSION['languages_id'])) $_SESSION['languages_id'] = 2;
define('MODULE_CUSTOMERS_STATUS_PRICES_TEXT_DESCRIPTION', 'Export der Kundengruppenpreise f&uuml;r Artikel');
define('MODULE_CUSTOMERS_STATUS_PRICES_TEXT_TITLE', 'Artikel Kundengruppenpreise - CSV');
define('MODULE_CUSTOMERS_STATUS_PRICES_SORT_ORDER_TITLE', 'Sortierung');
define('MODULE_CUSTOMERS_STATUS_PRICES_SORT_ORDER_DESC', 'Sortierung innerhalb Exportmodule');
define('MODULE_CUSTOMERS_STATUS_PRICES_STATUS_TITLE','Status');
define('MODULE_CUSTOMERS_STATUS_PRICES_STATUS_DESC','Modulstatus');
define('MODULE_CUSTOMERS_STATUS_PRICES_EXPORTTEXT','<p>Es werden alle gespeicherten Kundengruppen- und Staffelpreise zur ausgew&auml;hlten Kundengruppe exportiert.</p>Export als CSV, der Texttrenner ist Tabulator.<br /><p class="helptable">Die CSV Datei kann &uuml;ber <a href="categories.php?action=customers_status_prices_import">diesen Link</a> wieder importiert werden.</p>');
define('BESTAND_CSV_SEPARATOR',"\t");
define('MODULE_CUSTOMERS_STATUS_PRICES_FILE','customers_status_prices.csv');

// include needed functions

class customers_status_prices extends products_export{
    var $code, $title, $description, $enabled,$sort_order,$tmp_directory;
    var $max_items_per_step,$from_cron,$export_config,$save_path,$save_as_name,
        $categories_string, $tree;


    function __construct(){
        $this->only_active_categories = false;
        $csID = (isset($_REQUEST['customers_status']) and $_REQUEST['customers_status'] > 0) ? (int)xtc_db_input($_REQUEST['customers_status']) : -1;
	$this->code = 'customers_status_prices';
	$this->title = MODULE_CUSTOMERS_STATUS_PRICES_TEXT_TITLE;
	$this->description = MODULE_CUSTOMERS_STATUS_PRICES_TEXT_DESCRIPTION;
	$this->sort_order = (defined('MODULE_CUSTOMERS_STATUS_PRICES_SORT_ORDER')) ? MODULE_CUSTOMERS_STATUS_PRICES_SORT_ORDER : 0;
	$this->enabled = ((defined('MODULE_CUSTOMERS_STATUS_PRICES_STATUS') and MODULE_CUSTOMERS_STATUS_PRICES_STATUS == 'True') ? true : false);
	$this->max_items_per_step = 10000;
	$this->from_cron = (isset($_SERVER['REMOTE_ADDR'])) ? false : true;
        $this->save_as_name = sprintf('KDG_PREISE-%s-%s-%s.csv',
            main::filesanitize(xtc_get_customers_status_name($csID)),
            date('Y-m-d_His'),
            $csID
        );

	$this->export_config = array(
            'customers_status_id'=>$csID,
	    'language_id'=>(isset($_SESSION['languages_id'])) ? $_SESSION['languages_id'] : 2,
	    'particle_path'=>\main::get_exportdata_path().'CUSTOMERS_STATUS_PRICES_EXPORT/',
	    'start'=>0
	);
        if($csID>-1){
            xtc_db_query(sprintf(
                    "DELETE FROM %s%s WHERE quantity=0 OR personal_offer=0",
                    TABLE_PERSONAL_OFFERS_BY,$this->export_config['customers_status_id']
            ));
        }
    }
    
    function get_count_sql(){
        return $this->get_sql();
    }
    function get_sql(){
        $catFilterSQL = '';
        $catFilter = (isset($_GET['cat'])) ? $_GET['cat'] : [];
        if(sizeOf($catFilter)){
            $cat_items = [];
            foreach($catFilter as $cfID_string){
                $cat_items[ current(array_reverse(explode('_',$cfID_string))) ] = true;
            }
            $catFilterIDs = implode(',',array_keys($cat_items));
            $catFilterSQL = sprintf(" LEFT JOIN %s p2c USING(products_id) WHERE p2c.categories_id IN(%s) ",
                    TABLE_PRODUCTS_TO_CATEGORIES,
                    $catFilterIDs
            );
        }
	return sprintf("SELECT po.* FROM %s%s po %s ORDER BY po.products_id",
                TABLE_PERSONAL_OFFERS_BY,$this->export_config['customers_status_id'],
                $catFilterSQL
        );
    }
    
    function get_schema(){
	$schema = array(
	    'pID',
            'Anzahl',
            'Preis (Netto)',
            'Artikelname',
            TEXT_EXPORT_CONFIG_PRODUCTS_MODEL,
            'Link'
	);
	return $schema;
    }
    
    public function get_total_number_of_items(){
	$query = xtc_db_query($this->get_sql());
	return xtc_db_num_rows($query);
    }
    
    function process_header(){
	$basics = new basics;
	$str = implode(BESTAND_CSV_SEPARATOR, $this->get_schema())."\r\n";
	if(is_file($this->tmp_directory.'/00_HEADER.CSV'))
	    unlink($this->tmp_directory.'/00_HEADER.CSV');
	$basics->create_file($this->tmp_directory.'/00_HEADER.CSV', $str);
    }

    function process_page($page,$max_items_per_step){
	$basics = new basics;
	$page_sql = $this->get_sql();
	$page_sql .= sprintf(' LIMIT %s, %s',$page*$max_items_per_step,$max_items_per_step);
	$customers_status_id = (int)xtc_db_input($_GET['customers_status']);
	$items = array();
	$query = xtc_db_query($page_sql);
        $records = array();
	while($record = xtc_db_fetch_array($query)){
            $records[] = $record;
        }
        foreach($records as $record){
	    $product = new product($record['products_id']);
	    $items[] = array(
		$record['products_id'],
                $record['quantity'],
                xtc_round($record['personal_offer'],PRICE_PRECISION),
                $product->info['products_name'],
                $product->info['products_model'],
                xtc_href_link_from_admin('product_info.php', 'products_id='.$record['products_id'])
            );
        }
        if(sizeOf($items)){
	    $str = '';
	    foreach($items as $row){
		$str .= implode(BESTAND_CSV_SEPARATOR,$row)."\r\n";
	    }
	    $basics->create_file($this->tmp_directory.'/PAGE_'.$page.'.CSV', $str);
	}
    }
    
    public static function get_cs_array(){
        $array = array();
        foreach(xtc_get_customers_statuses() as $k=>$cs){
            if($cs['id'] == 0){
                continue;
            }
            $array[] = array(
                'id'=>$cs['id'],
                'text'=>$cs['text']
            );
        }
        return $array;
    }
    
    function display() {
        if(!xtc_check_permission('f_bestand')){
                        return array(0=>array('text'=>MODULE_ACCESS_ERROR));
        }
        if(!isset($this->language_id) or $this->language_id < 1){
            $this->language_id = (isset($_SESSION['languages_id'])) ? $_SESSION['languages_id'] : 2;
        }
        /* WIR WOLLEN AUSGEWAEHLTE KATEGORIEN EXPORTEN */
        $visible_categories_query = xtc_db_query("SELECT categories_id FROM categories WHERE parent_id=0");
        while($visible_categories = xtc_db_fetch_array($visible_categories_query)){
            $catID = $visible_categories['categories_id'];
            $this->categories_string .= xtc_draw_separator().$this->drawCatBox($catID,$catID).$this->getCategoryName($catID).'<br>';
            $this->tree[$catID] = $this->buildCATTree($catID,$level = 0,$path=$catID);
        }
                
        $this->categories_string = '<table border="0" cellspacing="0"><tr><td class="smallText">'.$this->categories_string.'</td></tr></table>';
        $av_cs = $this->get_cs_array();
        $array = array(
            'text' => $this->getCategoryJSString().MODULE_CUSTOMERS_STATUS_PRICES_EXPORTTEXT.'<br /><br />'.
            '<script type="text/javascript">'.
            "   $().ready(function(){
                $('.start_lbon_export_button').click(function(){
                    $('#modal_window').dialog({
                        title: 'Export'
                    }).load('".xtc_href_link(FILENAME_MODULE_EXPORT,xtc_get_all_get_params(array('action')).'&action=save_stepwise')."&'+$('form[name=\"modules\"]').serialize(),
                            function(){
                                hidePreloader();
                            }
                    ).html('<p align=\"center\"><img src=\"images/loading.gif\" alt=\"Loading\" title=\"Loading\"><br />loading...</p>');
                    return false;
                });
               }); 
               </script>
            ".
            TEXT_CUSTOMERS_STATUS.'<br />'.xtc_draw_pull_down_menu('customers_status', $av_cs).'<br /><br />'.

            '<b>Exportiere Produkte aus Kategorie:</b><br />'.
            '<input type="checkbox" name="allCat" value="1" CHECKED onClick="allCatFunc();"> Alle Kategorien<br />'.
            $this->categories_string.
//                        '<p><input type="checkbox" name="default_category" value="1" />'.EXPORT_DEFAULT_CATEGORY.'</p>'.
//                        '<input type="checkbox" name="export_linked_products" value="1" />'.EXPORT_LINKED_PRODUCTS.'<br />'.
            '<br />'.yes_draw_href_button(IMAGE_EXPORT,'javascript:','width:120px;','button','start_lbon_export_button ui-button ui-corner-all ui-state-default') . '&nbsp;' .
            yes_draw_href_button(IMAGE_CANCEL,xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=bestand'),'width:120px;')
        );
        return $array;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_CUSTOMERS_STATUS_PRICES_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_CUSTOMERS_STATUS_PRICES_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_CUSTOMERS_STATUS_PRICES_SORT_ORDER', '0',  '6', '1', '', now())");
    }

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_CUSTOMERS_STATUS_PRICES_STATUS','MODULE_CUSTOMERS_STATUS_PRICES_SORT_ORDER');
    }
}
