<?php
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_WS_CLASSES.'class.ebay.php');
require_once(DIR_WS_CLASSES.'class.ebay_item.php');
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
define('MODULE_EBAY_PRODUCTS_TEXT_DESCRIPTION', 'Konfigurierbarer Sammler Export (Tab getrennt)');
define('MODULE_EBAY_PRODUCTS_TEXT_TITLE', 'Sammlerprodukte Export konfigurierbar - CSV');
define('MODULE_EBAY_PRODUCTS_STATUS_DESC','Modulstatus');
define('MODULE_EBAY_PRODUCTS_STATUS_TITLE','Status');
define('MODULE_EBAY_PRODUCTS_FILE_DESC','Legen Sie einen Dateinamen f&uuml;r den Export fest');
define('MODULE_EBAY_PRODUCTS_FILE_TITLE','Export Dateiname');
define('MODULE_EBAY_PRODUCTS_IMPORT_LINK','<p class="helptable">Die CSV Datei k&ouml;nnen Sie &uuml;ber <a href="'.xtc_href_link('ebayapi_cart.php','action=import2').'"><u>diesen Link</u></a> wieder in YES importieren.</p>');
define('HEADING_TITLE_EBAY_PRODUCTS_IMPORT','Sammlerprodukte Import');
@define('DATE_FORMAT_EXPORT', '%d.%m.%Y');  // this is used for strftime()
// include needed functions

class ebay_products extends products_export{
    var $code, $title, $description, $enabled, $max_international_shippings,
            $_check,$sort_order,$filePath,$TextSign,$max_domestic_shippings;


    function __construct() {
      $this->TextSign = '';
      $this->max_international_shippings = 5;
      $this->max_domestic_shippings = 3;
      $this->code = 'ebay_products';
      $this->title = MODULE_EBAY_PRODUCTS_TEXT_TITLE;
      $this->description = MODULE_EBAY_PRODUCTS_TEXT_DESCRIPTION;
      $this->sort_order = (defined('MODULE_EBAY_PRODUCTS_SORT_ORDER')) ? MODULE_EBAY_PRODUCTS_SORT_ORDER : 0;
      $this->enabled = ((defined('MODULE_EBAY_PRODUCTS_STATUS') and MODULE_EBAY_PRODUCTS_STATUS == 'True') ? true : false);
      $this->filePath = \main::get_exportdata_path().'module_export_configs/ebay_products/';
    }

    public function get_ini($file){
	if(!is_dir($this->filePath))
	    mkdir($this->filePath);
	if(is_file($this->filePath.$file))
	    return parse_ini_file($this->filePath.$file,true);
    }
    
    public function get_heading_row($header,$ini=array(),$languages=array(),$no_import_config=false){
	$heading_row = array();
	foreach($header as $group=>$fields){
	    if($no_import_config or isset($ini[$group])){
		switch($group){
		    case 'main':
			foreach($fields['items'] as $field=>$field_title){
			    if($no_import_config or isset($ini[$group][$field]))
				$heading_row[] = $header[ $group ]['items'][$field];
			}
			break;
		    case 'shippings':
			for($i=0;$i<$this->max_domestic_shippings;$i++){
			    $heading_row[] = $header[ $group ]['title'].' National '.($i+1);
			}
			for($i=0;$i<$this->max_international_shippings;$i++){
			    $heading_row[] = $header[ $group ]['title'].' Internat. '.($i+1);
			}
			break;
		    default:
			$heading_row[] = $header[ $group ]['title'];
			break;
		}

	    }
	}
	return $heading_row;
    }

    function get_item_fields($data,$is_variation,$header,$ini,$no_import_config){
	$fields = array();
	foreach($header as $group => $gr_fields){
	    if($no_import_config or isset($ini[$group])){
		switch($group){
		    case 'main':
			foreach($gr_fields['items'] as $field=>$what){
			    if($no_import_config or isset($ini[$group][$field])){
				if($is_variation){
				    switch($field){
					    case 'variation_sort_order':
					    case 'ebay_products_id':
					    case 'ebay_variations_id':
						break;
					    case 'products_id':
					    case 'quantity':
						$fields[] = (int)$data[$field];
						break;
					    case 'auctionprice':
						$fields[] = number_format($data[$field],2,',','');
						break;
					    case 'sku':
					    case 'ean':
					    case 'isbn':
                                            case 'ProductReferenceID':
						$fields[] = $this->prepare_string($data[$field],true);
						break;
					    default:
						$fields[] = '';
						break;
				    }
				}else{
				    switch($field){
					    case 'products_id':
					    case 'sammler_id':
					    case 'galleryfeaturedduration':
					    case 'category':
					    case 'category2':
					    case 'duration':
					    case 'quantity':
					    case 'shopcat':
					    case 'shopcat2':
					    case 'dispatchtimemax':
					    case 'itemcondition':
					    case 'ShippingDiscountProfileID':
					    case 'InternationalShippingDiscountProfileID':
					    case 'eBayPlus':
						$fields[] = (int)$data[$field];
						break;
					    case 'auctionprice':
					    case 'buyitnowprice':
					    case 'bestoffer_price':
					    case 'BestOfferAutoAcceptPrice':
					    case 'reserveprice':
						$fields[] = number_format($data[$field],2,',','');
						break;
					    case 'user':
					    case 'type':
					    case 'template':
					    case 'revise_option':
					    case 'counter':
					    case 'picture':
					    case 'site':
					    case 'externalproductidtype':
					    case 'returnswithincode':
					    case 'shippingcostpaidby':
					    case 'title':
					    case 'subtitletext':
					    case 'description':
					    case 'shopcat_name':
					    case 'shopcat2_name':
					    case 'country':
					    case 'location':
					    case 'paymentinstructions':
					    case 'externalproductid':
					    case 'postalcode':
					    case 'sku':
					    case 'ean':
					    case 'isbn':
					    case 'seller_profile_payment_id':
					    case 'seller_profile_return_policy_id':
					    case 'seller_profile_shipping_id':
                                            case 'ProductReferenceID':
						$fields[] = $this->prepare_string($data[$field],true);
						break;
					    case 'select_set':
					    case 'select_set_multiple':
					    case 'locked':
					    case 'gallery':
					    case 'gallery_plus':
					    case 'galleryfeatured':
					    case 'vat':
					    case 'geldzurueck':
					    case 'sofortneu':
					    case 'new':
					    case 'bestoffer':
					    case 'revise':
						$fields[] = ($data[$field]>0) ? 1 : 0;
						break;
					    case 'status':
						$fields[] = (int)$data[$field];
						break;
                                            case 'ScheduleTime':
                                                if($data[$field] != '' and $data[$field] != '0000-00-00 00:00:00'){
                                                    $fields[] = $data[$field];
                                                }
                                                break;
				    }
				} // end if is not variation
			    }
			 }
			 break;
		    case 'paymentmethods':
			if(!$is_variation){
			    $fields[] = implode(',',$data['paymentmethods']);
			}else{
			    $fields[] = '';
			}
			break;
		    case 'shippings':
			$sh = array();
			foreach($data['shippingmethods'] as $sm){
			    $smtype = $sm['shippingtype'];
			    unset($sm['shippingtype']);
			    $sh[$smtype][] = $sm;
			}
			for($i=0;$i<$this->max_domestic_shippings;$i++){
			    $sh_dat = '';
			    if(!$is_variation){
				if(isset($sh['national'][$i])){
				    $sh_dat = implode(';',$sh['national'][$i]);
				}
			    }
			    $fields[] = $sh_dat;
			}
			for($i=0;$i<$this->max_international_shippings;$i++){
			    $sh_dat = '';
			    if(!$is_variation){
				if(isset($sh['international'][$i])){
				    $sh_curr = array();
				    foreach($sh['international'][$i] as $sv){
					if(!is_array($sv)){
					    $sh_curr[] = $sv;
					}else{
					    $locs = array();
					    foreach($sv as $loc){
						$locs[] = $loc;
					    }
					    $sh_curr[] = implode('|',$locs);
					}
				    }
				    $sh_dat = implode(';',$sh_curr);
				}
			    }
			    $fields[] = $sh_dat;
			}
			break;
		}
	    }
	}
	return $fields;
    }
    
    function process($file) {
		global $messageStack,$admin_access;
		$basics = new basics;
		@xtc_set_time_limit(0);
		$header = $this->get_header();
		$no_import_config = false;
		if(isset($_REQUEST['export_config_file']) and !empty($_REQUEST['export_config_file'])){
		    $ini = $this->get_ini('ebay_products_'.basename($_REQUEST['export_config_file'].'.ini'));
		    $heading_row = $this->get_heading_row($header,$ini,array(),$no_import_config);
		}else{
		    $no_import_config = true;
		    $heading_row = $this->get_heading_row($header,array(),array(),$no_import_config);
		}
		$heading_row = array_merge($this->get_automatic_header(),$heading_row);
		$export_query_raw = "SELECT * FROM ebay_products";
		if(isset($_REQUEST['ebay_sammler_id']) and $_REQUEST['ebay_sammler_id'] != ''){
		    $export_query_raw .= sprintf(" WHERE ebay_sammler_id='%s'",
			    (int)xtc_db_input($_REQUEST['ebay_sammler_id'])
		    );
		}
		$export_query = xtc_db_query($export_query_raw);
		if(!xtc_db_num_rows($export_query)){
			$messageStack->add_session('Es wurden keine Artikel exportiert.','error');
			xtc_redirect(xtc_href_link(FILENAME_MODULE_EXPORT,xtc_get_all_get_params(array('action'))));
		}
		$rows = array(implode("\t",$heading_row));
		while ($ep = xtc_db_fetch_array($export_query)) {
			$shippingmethods = array();
			$paymentmethods = array();
			if($no_import_config or (isset($ini['paymentmethods']['export']) and $ini['paymentmethods']['export'] == 1)){
			    $payments_query = xtc_db_query(sprintf(
				    "SELECT payment FROM ebay_products_payments WHERE ebay_products_id='%s'",
				    $ep['id']
			    ));
			    while($payments = xtc_db_fetch_array($payments_query)){
				$paymentmethods[] = xtc_db_prepare_input($payments['payment']);
			    }
			}
			
			if($no_import_config or (isset($ini['shippings']['export']) and $ini['shippings']['export'] == 1)){
                            $_tmp = array();
			    $shippings_query = xtc_db_query(sprintf(
				    "SELECT ebay_products_shippings_id,shippingtype,ShippingService,ShippingServiceCost,ShippingServiceAdditionalCost,ShippingServicePriority,shipsWithinDays FROM ebay_products_shippings WHERE ebay_products_id='%s'",
				    $ep['id']
			    ));
			    while($shippings = xtc_db_fetch_array($shippings_query)){
                                $_tmp[] = $shippings;
                            }
                            foreach($_tmp as $shippings){
				$locations_query = xtc_db_query(sprintf(
					"SELECT location FROM ebay_products_shippings_locations WHERE ebay_products_shippings_id='%s'",
					$shippings['ebay_products_shippings_id']
				));
				unset($shippings['ebay_products_shippings_id']);
				if(xtc_db_num_rows($locations_query)){
				    $shippings['locations'] = array();
				}
				while($location = xtc_db_fetch_array($locations_query)){
				    $shippings['locations'][] = xtc_db_prepare_input($location['location']);
				}
				$shippingmethods[] = $shippings;
			    }
			}
			$ebay_product = new ebay_product($ep['id']);
			$data = array(
			    'shippingmethods'=>$shippingmethods,
			    'paymentmethods'=>$paymentmethods
			);
			foreach(get_class_vars(get_class($ebay_product)) as $k=>$v){
			    switch($k){
				case 'sql_array':
				case 'characteristics':
				case 'shippings':
				case 'itemspecifics':
				case 'itemspecifics_recommendations':
				case 'variations_set_id':
				case 'properties':
				case 'id':
				case 'uuid':
				case 'payments':
				case 'ebay_products_id':
				case 'ebay_variations_id':
				case 'variation_sort_order':
				    break;
				default:
				    $data[$k] = $ebay_product->$k;
				    break;
			    }
			}
			$fields = array(
			    $ep['id'],0,0
			);
			$item_fields = $this->get_item_fields($data,false,$header,$ini,$no_import_config);
			$fields = array_merge($fields,$item_fields);
			$rows[] = implode("\t",$fields);

			$variations_sets_id = ebay_item::get_variations_sets_id_from_ebay_products_id($ep['id']);
			if($variations_sets_id > 0){
				$variations_query = xtc_db_query(sprintf(
					"SELECT * FROM ebay_variations WHERE ebay_variations_sets_id='%s'",
					$variations_sets_id
				));
				while($variation = xtc_db_fetch_array($variations_query)){
					$base_data = array($ep['id'],$variation['ebay_variations_id'],$variation['sort_order']);
					$data['quantity'] = $variation['quantity'];
				        $data['auctionprice'] = $variation['startprice'];
				        $data['products_id'] = $variation['products_id'];
				        $data['ean'] = xtc_db_prepare_input($variation['ean']);
				        $data['sku'] = xtc_db_prepare_input($variation['sku']);
				        $data['isbn'] = xtc_db_prepare_input($variation['isbn']);
                                        $data['ProductReferenceID'] = xtc_db_prepare_input($variation['ProductReferenceID']);
					$item_fields = $this->get_item_fields($data,true,$header,$ini,$no_import_config);
					$rows[] = implode("\t",array_merge($base_data,$item_fields));
				}
			}
		}
		$schema = implode("\r\n",$rows);
		$crypt_file = yes_get_sha1_from_string( date('d.m.Y_H.i.s') );
		if(isset($_REQUEST['export_config_file']) and $_REQUEST['export_config_file'] != ''){
		    $filename = sprintf('ebay_products_{%s}_%s.csv',basename($_REQUEST['export_config_file']),$crypt_file);
		}else{
		    $filename = sprintf('ebay_products_%s.csv',$crypt_file);
		}
		$filepath = \main::get_exportdata_path();
		$basics->create_file($filepath.$filename,$schema);
		if(!strstr(HTTP_SERVER,'localhost')){
		    $basics->zip_file($filepath,$filename,$filename.'.zip',true);
		    $file_contents = $basics->read_file_content($filepath.$filename.'.zip',$mode='rb');
		    unlink($filepath.$filename);
		    unlink($filepath.$filename.'.zip');
		    // send File to Browser
		    $file = 'sammlerartikel_'.((isset($_REQUEST['export_config_file']) and $_REQUEST['export_config_file'] != '')?'{'.basename($_REQUEST['export_config_file']).'}_':'').date('Y-m-d_H_i_s').'.zip';
		}else{
		    $file_contents = $schema;
		    $file = 'sammlerartikel_'.((isset($_REQUEST['export_config_file']) and $_REQUEST['export_config_file'] != '')?'{'.basename($_REQUEST['export_config_file']).'}_':'').date('Y-m-d_H_i_s').'.csv';
		}
		header('Content-Type: application/octet-stream');
		header('Content-Transfer-Encoding: binary');
		header('Content-disposition: attachment; filename=' . $file);
		echo $file_contents;
		exit;
    }

    function display() {
	$export_config_files = array(array('id'=>'','text'=>TEXT_SELECT));
	if(!is_dir($this->filePath)){
	    mkdir($this->filePath);
	}
	$basics = new basics;
	$dir = $basics->get_directory_content($this->filePath);
	foreach($dir as $fn){
	    if(substr($fn,0,strlen($this->code)) == $this->code){
		$export_config_files[] = array(
		    'id'=>str_replace(array('.ini','ebay_products_'),'',$fn),
		    'text'=>str_replace(array('.ini','ebay_products_'),'',$fn)
		);
	    }
	}
	
	$array = array('text' => '<script type="text/javascript">'.
		'$(function(){'.
		'   $(\'select[name="ebay_sammler_id"]\').change(function(){'.
		'	switch($(this).val()){'.
		'	    case \'\':'.
		'		if($(\'input[name="allCart"]\').prop(\'checked\') !== true){'.
		'		    $(\'input[name="allCart"]\').prop(\'checked\',true);'.
		'		}'.
		'		break;'.
		'	    default:'.
		'		$(\'input[name="allCart"]\').prop(\'checked\',false);'.
		'		break;'.
		'	}'.
		'   });'.
		'   $(\'input[name="allCart"]\').click(function(){'.
		'	if($(this).prop(\'checked\') === true){'.
		'	    $(\'select[name="ebay_sammler_id"]\').val(\'\');'.		
		'	}'.
		'   });'.
		'   $(\'input.button_export_config\').click(function(){'.
		'	$("#modal_window").dialog({width:"800px",height:"auto",modal: true,title: $(this).val()}).load(\''.xtc_href_link(FILENAME_MODULE_EXPORT,xtc_get_all_get_params(array('action')).'action=export_config').'\');'.
		'   });'.
	    "
		    $('a.delete_config_file').click(function(){
			var fn = $('select[name=\"export_config_file\"]').val();
			if(fn.length > 0){
			    if(confirm('".CONFIRM_DELETE_CONFIG_FILE."')){
				window.location.href = '".xtc_href_link('module_export.php',xtc_get_all_get_params(array('action','file')).'action=delete_config_file')."&file='+fn;
			    }
			}
		    });
		".
		'});'.
		'</script>'.
		MODULE_EBAY_PRODUCTS_IMPORT_LINK.
		'<p class="formArea" style="padding: 4px;"><b>'.TEXT_USE_EXPORT_CONFIG.':</b><br />'.xtc_draw_pull_down_menu('export_config_file',$export_config_files).
		'&nbsp;<a href="javascript:;" class="delete_config_file"><img src="images/icons/delete.gif" title="'.IMAGE_DELETE.'" /></a><br /><br />'.
		'<input class="ui-state-higlight ui-corner-all button_export_config" type="button" value="Neue Exportkonfiguration anlegen" />'.
		'</p>'.
		'<b>Exportiere Sammlerprodukte aus Sammler:</b><br />'.
		'<input type="checkbox" name="allCart" value="1" checked="checked" /> Alle Sammler<br />'.
		$this->getSammlerDropdown().
		'<br />' . 
		yes_draw_href_button(IMAGE_EXPORT, '', 'width:180px;', 'submit').
		'&nbsp;'.
		yes_draw_href_button(IMAGE_CANCEL, xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module='.$this->code), 'width:180px;')
	);
	return $array;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_EBAY_PRODUCTS_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_EBAY_PRODUCTS_FILE', 'ebay_products_export.csv',  '6', '1', '', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_EBAY_PRODUCTS_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
}

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_EBAY_PRODUCTS_STATUS','MODULE_EBAY_PRODUCTS_FILE');
    }

    public function get_automatic_header(){
	return array(TEXT_EBAY_CONFIG_EBAY_PRODUCTS_ID,TEXT_EBAY_CONFIG_VARIATIONS_ID,TEXT_EBAY_CONFIG_VARIATION_SORT_ORDER);
    }
    public function get_header(){
	$header = array(
	    'main'=>array('items'=>array(),'languages'=>false,'title'=>TEXT_EXPORT_CONFIG_GROUP_EP_MAIN),
	    'shippings'=>array('items'=>array(),'languages'=>false,'title'=>TEXT_EXPORT_CONFIG_GROUP_EP_SHIPPINGS),
	    'paymentmethods'=>array('items'=>array(),'languages'=>false,'title'=>TEXT_EXPORT_CONFIG_GROUP_EP_PAYMENTS)
	);
	$ep = new ebay_product(-1);
	foreach(get_class_vars(get_class($ep)) as $k=>$v){
	    switch($k){
		case 'ebay_products_id':
		case 'sql_array':
		case 'characteristics':
		case 'shippings':
		case 'itemspecifics':
		case 'itemspecifics_recommendations':
		case 'variations_set_id':
		case 'properties':
		case 'id':
		case 'uuid':
		case 'payments':
		    break;
		default:
		    $header['main']['items'][$k] = html_entity_decode(ebay_item::get_db_field_title('ebay_products',$k)/*,ENT_HTML401,'iso8859-1'*/);
		    break;
	    }
	}
	return $header;
		
    }
    public static function prepare_float($str){
	return (float)str_replace(',','.',$str);
    }
    
    function getSammlerDropdown(){
	$EBAYAPI = new ebayAPI();
	return xtc_draw_pull_down_menu('ebay_sammler_id', $EBAYAPI->getSammlerValues());
    }

  }
