<?php
/* -----------------------------------------------------------------------------------------
   
   Google Sitemaps by hendrik (http://www.ecombase.de/)
   V1.1 August 2006
   -----------------------------------------------------------------------------------------
   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(cod.php,v 1.28 2003/02/14); www.oscommerce.com 
   (c) 2003	 nextcommerce (invoice.php,v 1.6 2003/08/24); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/
//defined( '_VALID_XTC' ) or die( 'Direct Access to this location is not allowed.' );

define('MODULE_GOOGLE_XML_SITEMAP_TEXT_DESCRIPTION', 'Export - Google Sitemaps im xml Format');
define('MODULE_GOOGLE_XML_SITEMAP_TEXT_TITLE', 'Google XML Sitemap');
define('MODULE_GOOGLE_XML_SITEMAP_FILE_TITLE','Dateiname');
define('MODULE_GOOGLE_XML_SITEMAP_FILE_DESC','Name der XML Sitemap Datei');
define('MODULE_GOOGLE_XML_SITEMAP_STATUS_DESC','Modulstatus');
define('MODULE_GOOGLE_XML_SITEMAP_STATUS_TITLE','Status');
@define('EXPORT_YES','Nur Herunterladen');
@define('EXPORT_NO','Am Server Speichern');

define('MODULE_GOOGLE_XML_SITEMAP_INSTALL_TITLE' , '<hr noshade><b>Installation im Shopverzeichnis?</b>');
define('MODULE_GOOGLE_XML_SITEMAP_INSTALL_DESC' , 'Die XML Datei wird gz komprimiert im Shopverzeichnis abgelegt.');
// ----------------------
define ('SITEMAP_PAR_PRIORITY_LIST',    '0.5');        
define ('SITEMAP_PAR_PRIORITY_PRODUCT', '0.8');        
define ('SITEMAP_PAR_CHANGEFREQ', 'weekly');        
// ----------------------


// include needed functions

  class google_xml_sitemap extends products_export {
    var $code, $title, $description, $enabled,$from_cron,$_check,$sort_order;


    function __construct() {
      global $order;

      $this->code = 'google_xml_sitemap';
      $this->title = MODULE_GOOGLE_XML_SITEMAP_TEXT_TITLE;
      $this->description = MODULE_GOOGLE_XML_SITEMAP_TEXT_DESCRIPTION;
      $this->sort_order = (defined('MODULE_GOOGLE_XML_SITEMAP_SORT_ORDER')) ? MODULE_GOOGLE_XML_SITEMAP_SORT_ORDER : 0;
      $this->enabled = ((defined('MODULE_GOOGLE_XML_SITEMAP_STATUS') and MODULE_GOOGLE_XML_SITEMAP_STATUS == 'True') ? true : false);
      // from_cron wird beim instantiieren gesetzt
    }
    
// -------------------- XML Generator ----------------------
    function xls_sitemap_top( ) {
      $ret ='<?xml version="1.0" encoding="UTF-8"?>'."\n";
      $ret.='  <urlset xmlns="http://www.google.com/schemas/sitemap/0.9">'."\n";
      return $ret;
    }
    
    function xls_sitemap_bottom() {
      $ret ='  </urlset>'."\n";
      return $ret;
    }
    
    function gmt_diff() {
      preg_match_all("/([\+|\-][0-9][0-9])([0-9][0-9])/", date("O"), $ausgabe, PREG_PATTERN_ORDER);
      return $ausgabe[1][0] . ":" . $ausgabe[2][0];
    }

    function xls_sitemap_entry( $url, $lastmod='', $priority=SITEMAP_PAR_PRIORITY_LIST, $changefreq=SITEMAP_PAR_CHANGEFREQ ) {
      if( $lastmod!='' ) {
        $lastmod = str_replace(' ', 'T', $lastmod);
        $lastmod.= $this->gmt_diff();
      }
      
      $ret ="    <url>\n";
      $ret.="      <loc>$url</loc>\n";
      if( $lastmod != '' ) {
        $ret.="      <lastmod>$lastmod</lastmod>\n";
      }
      $ret.="      <changefreq>$changefreq</changefreq>\n";
      $ret.="      <priority>$priority</priority>\n";
      $ret.="    </url>\n";
      
      return $ret;
    }
    
// -------------------- Contents ----------------------
    function process_contents( &$schema ) {
	if(!function_exists('xtc_cleanName'))
	require(DIR_FS_INC.'xtc_cleanName.inc.php');
	$max_items = 10;
        $items = \YES4Trade\Model\content_manager::get_by_content_status_and_languages_id(1,$_SESSION['languages_id']);
        foreach($items as $it) {
            $link = $this->xtc_href_link('shop_content.php','coID='.$it->content_group,'NONSSL');
            $entry = $this->xls_sitemap_entry( $link );     
            $schema .= $entry;          
        }
    }

// -------------------- Categories ----------------------
    function process_categories( &$schema ) {
	$categories_query_raw = sprintf("SELECT c.categories_image,c.categories_id, 
	    cd.categories_name FROM %s c left join %s cd USING (categories_id)
            WHERE c.categories_status=1 and cd.language_id=%s and c.parent_id=0
            ORDER BY c.sort_order ASC",
		TABLE_CATEGORIES,TABLE_CATEGORIES_DESCRIPTION,
		$_SESSION['languages_id']
	);

	$categories_query = yes_db_query($categories_query_raw,true);
	if(yes_db_num_rows($categories_query)){
	    foreach($categories_query as $categories) {
		$link = $this->xtc_href_link('index.php','cPath='.$categories['categories_id'],'NONSSL');
		$entry=$this->xls_sitemap_entry( $link );
		$schema .= $entry;          
		$category_tree=$this->get_category_tree($categories['categories_id']);
		foreach( $category_tree as $category_entry ) {
		    $link = $category_entry['link'];
		    $entry=$this->xls_sitemap_entry( $link );     
		    $schema .= $entry;          
		}
	    }
	}
    }
     
    function process_products( &$schema ) {      
	if(!function_exists('xtc_product_link'))
	    require(DIR_FS_INC.'xtc_product_link.inc.php');
	$export_query = xtc_db_query(sprintf("SELECT p.products_id,
	    p.products_last_modified, pd.products_name FROM %s p LEFT JOIN %s pd 
	    USING(products_id) WHERE products_status=1 and pd.language_id=%s
	    ORDER BY p.products_id",
	    TABLE_PRODUCTS,TABLE_PRODUCTS_DESCRIPTION,$_SESSION['languages_id']
	));
	while ($products = xtc_db_fetch_array($export_query)) {
	    $link = $this->xtc_href_link('product_info.php','products_id='.$products['products_id'],'NONSSL');
	    $entry=$this->xls_sitemap_entry( $link, $products['products_last_modified'], SITEMAP_PAR_PRIORITY_PRODUCT);
	    $schema .= $entry;          
	}
    }

    function process($file) {
	global $messageStack;
	if(!function_exists('xtc_href_link'))
		require(DIR_FS_INC.'xtc_href_link.inc.php');
	if($this->from_cron){
	    if(is_file(DIR_FS_CATALOG.'export/'.$file.'.gz')){
		die("Die Datei yes/export/$file.gz ist bereits vorhanden. Diese muss entweder manuell oder durch den cronjob cron_google_sitemap_delete_file.php geloescht werden.\r\n");
	    }
	}
	@xtc_set_time_limit(0);
	$schema = $this->xls_sitemap_top();
	$schema.= $this->xls_sitemap_entry( HTTP_SERVER . "index.html" );
	$this->process_contents($schema);
	$this->process_categories($schema);
	$this->process_products($schema);
	$schema.= $this->xls_sitemap_bottom();
	$filename = DIR_FS_DOCUMENT_ROOT.'export/'.$file;
	if(!$this->from_cron and $_POST['google_xml_sitemap_rootinstall'] != 'yes' ) {
	      $fp = fopen($filename, "w+");
	      fputs($fp, $schema);
	      fclose($fp);

	      header('Content-type: application/x-octet-stream');
	      header('Content-disposition: attachment; filename=' . $file);
	      echo $schema;
	      exit;
	}else{
	    // Temporaere Datei zum Schreiben mit der maximalen Kompressionsstufe oeffnen
	    $zp = gzopen($filename.'.gz', "w9");
	    // String in die Datei schreiben
	    gzwrite($zp, $schema);
	    // Datei schließen
	    gzclose($zp);
	    if(!$this->from_cron){
		$messageStack->add_session('Google XML Sitemap wurde erzeugt.','success');
		xtc_redirect(xtc_href_link(FILENAME_MODULE_EXPORT,  xtc_get_all_get_params(array('action')).'action=edit'));
	    }else{
		echo 'Google XML Sitemap wurde erzeugt als yes/export/'.basename($filename).".gz\r\n";
	    }
	}
    }

    function display() {

      return array('text' => 
                            MODULE_GOOGLE_XML_SITEMAP_INSTALL_TITLE.'<br>'.
                            MODULE_GOOGLE_XML_SITEMAP_INSTALL_DESC.'<br>'.
                            xtc_draw_radio_field('google_xml_sitemap_rootinstall', 'no',true).'nein'.'<br>'.
                            xtc_draw_radio_field('google_xml_sitemap_rootinstall', 'yes',false).'ja'.'<br>'.
                            '<br /><input value="Exportieren" type="submit" class="ui-button ui-corner-all ui-state-default">'.
                            '<input value="Abbrechen" type="button" class="ui-button ui-corner-all ui-state-default" onClick="window.location.href=\''.xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=google_xml_sitemap').'\';">');
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_GOOGLE_XML_SITEMAP_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_GOOGLE_XML_SITEMAP_FILE', 'sitemap.xml',  '6', '1', '', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_GOOGLE_XML_SITEMAP_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    }

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_GOOGLE_XML_SITEMAP_STATUS','MODULE_GOOGLE_XML_SITEMAP_FILE');
    }

    function get_category_tree( $parent_id = '0', 
                                $spacing = '', 
                                $exclude = '', 
                                $category_tree_array = '', 
                                $include_itself = false, 
                                $cPath = '' ) {
	global $SITEMAP;

	if ($parent_id == 0){ 
	    $cPath = ''; 
	} else {	
	    $cPath .= $parent_id . '_'; 
	}
	if (!is_array($category_tree_array)) 
	    $category_tree_array = array();
        
	if ($include_itself) {
	    $category_query = "select cd.categories_name from " . TABLE_CATEGORIES_DESCRIPTION . " cd where cd.language_id = '" . $_SESSION['languages_id'] . "' and c.categories_status = '1' and cd.categories_id = '" . $parent_id . "'";
	    $category_query = yes_db_query($category_query,true);
	    if(yes_db_num_rows($category_query))
		    $category = current($category_query);
	    $category_tree_array[] = array('id' => $parent_id, 'text' => $category['categories_name']);
	}

	$categories_query = "select c.categories_id, cd.categories_name, c.parent_id from " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd where c.categories_id = cd.categories_id and cd.language_id = '" . $_SESSION['languages_id'] . "' and c.parent_id = '" . $parent_id . "' and c.categories_status = '1' order by c.sort_order, cd.categories_name";
	$categories_query = yes_db_query($categories_query,true);
	if(yes_db_num_rows($categories_query)){
	      foreach ($categories_query as $categories ) {
		if ($exclude != $categories['categories_id']) {
		  $listing_data = array();

		  if($SITEMAP['get_products'] && xtc_count_products_in_category($categories['categories_id']) > 0) {
		    $listing_data = get_all_products($categories['categories_id']);
		  }

	//          if( SEARCH_ENGINE_FRIENDLY_URLS == 'true' ) {
	//            $link= shopstat_getSEO('index.php', 'cPath='.$cPath.$categories['categories_id']);
	//          } else {
		    $link = $this->xtc_href_link('index.php','cPath='.$cPath.$categories['categories_id'],'NONSSL');
	//            $link= HTTP_CATALOG_SERVER . DIR_WS_CATALOG . 'index.php?cPath='.$cPath.$categories['categories_id'];          
	//          }

		  $category_tree_array[] = array( 'id'    => $categories['categories_id'],
		                                  'text'  => $spacing . $categories['categories_name'],
		                                  'link'  => $link,
		                                  'pcount'=> sizeof($listing_data),
		                                  'products'=>$listing_data
		                                ); //-- DIR_WS_CATALOG . 'index.php?cPath=' . $cPath . $categories['categories_id']
		  $category_tree_array = $this->get_category_tree($categories['categories_id'], $spacing . '&nbsp;&nbsp;&nbsp;', $exclude, $category_tree_array, false, $cPath);
		}
	      }
      }

      return $category_tree_array;
    }

}