<?php
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
define('MODULE_NEWSLETTER_RECIPIENTS_TEXT_DESCRIPTION', 'Export - Newsletter Empf&auml;nger');
define('MODULE_NEWSLETTER_RECIPIENTS_TEXT_TITLE', 'Newsletter Emp&auml;nger - CSV');
define('MODULE_NEWSLETTER_RECIPIENTS_STATUS_DESC','Modulstatus');
define('MODULE_NEWSLETTER_RECIPIENTS_STATUS_TITLE','Status');
define('MODULE_NEWSLETTER_RECIPIENTS_EXPORTTEXT','<br />Es wird im CSV Format exportiert, der Texttrenner ist Tabulator. Aus Performancegr&uuml;nden wird die Export-Datei im .zip Format als Download zur Verf&uuml;gung gestellt.');
@define('DATE_FORMAT_EXPORT', '%d.%m.%Y');  // this is used for strftime()
@define('CSV_SEPARATOR',"\t");
// include needed functions

class newsletter_recipients{
    var $code, $title, $description, $enabled,$_check, $sort_order,$TextSign;


    function __construct() {
      $this->TextSign = '';
      $this->code = 'newsletter_recipients';
      $this->title = MODULE_NEWSLETTER_RECIPIENTS_TEXT_TITLE;
      $this->description = MODULE_NEWSLETTER_RECIPIENTS_TEXT_DESCRIPTION;
      $this->sort_order = (defined('MODULE_NEWSLETTER_RECIPIENTS_SORT_ORDER')) ? MODULE_NEWSLETTER_RECIPIENTS_SORT_ORDER : 0;
      $this->enabled = ((defined('MODULE_NEWSLETTER_RECIPIENTS_STATUS') and MODULE_NEWSLETTER_RECIPIENTS_STATUS == 'True') ? true : false);
    }

    function process() {
        @xtc_set_time_limit(0);
		$basics = new basics;
        $header = array('E-Mail','cID','Kundengruppe','Vorname','Nachname','Aktiv','Angelegt');
        $csv_string = implode(CSV_SEPARATOR,$header)."\r\n";
    	$this->groups = xtc_get_customers_statuses();
		$nl_query = xtc_db_query(
			"SELECT customers_email_address,customers_id,customers_status,customers_firstname,customers_lastname,mail_status,date_added
			 FROM newsletter_recipients ORDER BY date_added DESC"
		);
		$customer_groups = array();
		while($nl = xtc_db_fetch_array($nl_query)){
			if(!isset($customer_groups[$nl['customers_status']])){
				$customer_groups[$nl['customers_status']] = xtc_get_customers_status_name($nl['customers_status']);
			}
			$add_item = array(
				$nl['customers_email_address'],
				$nl['customers_id'],
				$customer_groups[$nl['customers_status']],
				trim($nl['customers_firstname']),
				trim($nl['customers_lastname']),
				$nl['mail_status'],
				$nl['date_added']
			);
		    $csv_string .= implode(CSV_SEPARATOR,$add_item)."\r\n";
		}
		$crypt_file = yes_get_sha1_from_string( date('d.m.Y_H.i.s') );
		$filename = sprintf('newsletter_recipients_export_%s.csv',$crypt_file);
		$filepath = \main::get_exportdata_path();
		$basics->create_file($filepath.$filename,$csv_string);
		$basics->zip_file($filepath,$filename,$filename.'.zip',true);

		$file_contents = $basics->read_file_content($filepath.$filename.'.zip',$mode='rb');
		unlink($filepath.$filename.'.zip');
		// send File to Browser
		$file = 'NEWSLETTER_RECIPIENTS_'.date('Y-m-d_H_i_s').'.zip';
		header('Content-Type: application/octet-stream');
		header('Content-Transfer-Encoding: binary');
		header('Content-disposition: attachment; filename=' . $file);
		echo $file_contents;
		exit;
    }


    function display() {
		$array = array(
			'text' => MODULE_NEWSLETTER_RECIPIENTS_EXPORTTEXT.'<br /><br />'.xtc_image_submit('button_export.gif',IMAGE_EXPORT) .
				'<a href="'.xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=NEWSLETTER_RECIPIENTS').'">'.xtc_image_button('button_cancel.gif',IMAGE_CANCEL).'</a>');
		return $array;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_NEWSLETTER_RECIPIENTS_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_NEWSLETTER_RECIPIENTS_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
}

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_NEWSLETTER_RECIPIENTS_STATUS');
    }
  }
