<?php
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
require_once(DIR_FS_ADMIN.DIR_WS_CLASSES.'storage.php');
define('MODULE_PRODUCTS_STORAGES_TEXT_DESCRIPTION', 'Export - Artikel Lagerpl&auml;tze (Tab getrennt)');
define('MODULE_PRODUCTS_STORAGES_TEXT_TITLE', 'Artikel Lagerpl&auml;tze Export - CSV');
define('MODULE_PRODUCTS_STORAGES_FILE_TITLE' , '<hr noshade>Dateiname');
define('MODULE_PRODUCTS_STORAGES_FILE_DESC' , 'Geben Sie einen Dateinamen ein, falls die Exportdatei am Server gespeichert werden soll.<br>(Verzeichnis ebaymich/)');
define('MODULE_PRODUCTS_STORAGES_STATUS_DESC','Modulstatus');
define('MODULE_PRODUCTS_STORAGES_STATUS_TITLE','Status');
//define('MODULE_PRODUCTS_STORAGES_IMPORT_LINK','<p class="helptable">Die CSV Datei k&ouml;nnen Sie &uuml;ber <a href="categories.php?action=yes_import"><u>diesen Link</u></a> wieder in YES importieren.</p>');
@define('EXPORT_YES','Nur Herunterladen');
@define('EXPORT_NO','Am Server Speichern');
@define('DATE_FORMAT_EXPORT', '%d.%m.%Y');  // this is used for strftime()
@define('TABLE_PERSONAL_OFFERS_BY','personal_offers_by_customers_status_');
@define('EXPORT_PRODUCTS_NAME','Artikelname in Export einbinden');
// include needed functions


class products_storages extends products_export{
    var $code, $title, $description, $enabled,$categories_string,
		$selected_categories,$Groups,$csv_separator,$max_items_per_step,
		$tmp_directory, $storage_id, $_check, $sort_order;
    function __construct() {
		$this->code = 'products_storages';
		$this->title = MODULE_PRODUCTS_STORAGES_TEXT_TITLE;
		$this->description = MODULE_PRODUCTS_STORAGES_TEXT_DESCRIPTION;
		$this->sort_order = (defined('MODULE_PRODUCTS_STORAGES_SORT_ORDER')) ? MODULE_PRODUCTS_STORAGES_SORT_ORDER : 0;
		$this->enabled = ((defined('MODULE_PRODUCTS_STORAGES_STATUS') and MODULE_PRODUCTS_STORAGES_STATUS == 'True') ? true : false);
		$this->only_active_products = false;
		$this->only_active_categories = false;
		$this->csv_separator = "\t";
		$this->max_items_per_step = 1000;
                $this->storage_id = -1;
    }
    
    function get_sql(){
        if(isset($_REQUEST['storage_id']) and $_REQUEST['storage_id']>0){
            $storage = new storage((int)xtc_db_input($_REQUEST['storage_id']));
            $storage_places_ids = [];
            foreach($storage->get_storage_places() as $plc){
                $storage_places_ids[] = $plc['id'];
            }
            return "SELECT
				stpr.*,
				p.products_ean,
				p.products_model
				FROM
				storage_products stpr LEFT JOIN 
				" . TABLE_PRODUCTS . " p USING (products_id)
				WHERE stpr.storage_places_id IN(".implode(',',$storage_places_ids).")
				ORDER BY
				p.products_date_added DESC";
        }else{
            return "SELECT
				stpr.*,
				p.products_ean,
				p.products_model
				FROM
				storage_products stpr LEFT JOIN 
				" . TABLE_PRODUCTS . " p USING (products_id)
				ORDER BY
				p.products_date_added DESC";
        }
    }
    
    function get_schema(){
        $return = array('pID','Art.-Nr.','Phys. Bestand','Lager','Lagernummer','Anzahl','Lagerplatz');
        if(isset($_REQUEST['export_products_name']) and $_REQUEST['export_products_name'] == 1){
            $return[] = 'Artikelname';
        }
		return $return;
    }
    
    function process_header(){
		$basics = new basics;
		$str = implode($this->csv_separator, $this->get_schema())."\r\n";
		if(is_file($this->tmp_directory.'/00_HEADER.CSV'))
			unlink($this->tmp_directory.'/00_HEADER.CSV');
		$basics->create_file($this->tmp_directory.'/00_HEADER.CSV', $str);
    }
    
    
    function process_page($page,$max_items_per_step){
		$basics = new basics;
		if(!xtc_check_permission('f_bestand')){
			die(MODULE_ACCESS_ERROR);
		}
		$page_sql = $this->get_sql();
		$page_sql .= sprintf(' LIMIT %s, %s',$page*$max_items_per_step,$max_items_per_step);
		$items = array();
		$products = array();
		$query = xtc_db_query($page_sql);
		while($record = xtc_db_fetch_array($query)){
			$products[] = array(
				'products_id'=>$record['products_id'],
				'products_model'=>$record['products_model']
			);
		}
		foreach($products as $product){
			$places = array();
			$pID = $product['products_id'];
			$SQ = new products_quantity($pID);
			$phys = $SQ->get_products_total_qty();
			if(isset($_REQUEST['storage_id']) and $_REQUEST['storage_id']>0){
				$storage = new storage((int)xtc_db_input($_REQUEST['storage_id']));
				$storage_places_ids = [];
				foreach($storage->get_storage_places() as $plc){
					$storage_places_ids[] = $plc['id'];
				}
				$sp_query = xtc_db_query(sprintf(
						"SELECT storage_id,quantity,storage_places_id FROM storage_products WHERE products_id='%s' AND storage_places_id IN(%s) ORDER BY priority",
						$pID,implode(',',$storage_places_ids)
				));
			}else{
				$sp_query = xtc_db_query(sprintf(
						"SELECT storage_id,quantity,storage_places_id FROM storage_products WHERE products_id='%s' ORDER BY priority",
						$pID
				));
			}
			while($row = xtc_db_fetch_array($sp_query)){
				$places[] = $row;
			}
			if(!sizeOf($places)){
				continue;
			}
			foreach($places as $place){
				if($place['storage_places_id']>0){
					$place['storage_place'] = yes_get_storage_place_title($place['storage_places_id']);
				}
				$sn_query = xtc_db_query(sprintf(
					"SELECT nummer FROM storage_numbers WHERE products_id=%s AND storage_id=%s",
					$pID,$place['storage_id']
				));
				$sn_record = xtc_db_fetch_array($sn_query);
				$schema = array(
					$pID, $product['products_model'],$phys, xtc_get_storage_name($place['storage_id']),
					$sn_record['nummer'],$place['quantity'],
					$place['storage_place']
				);
				if(isset($_REQUEST['export_products_name']) and $_REQUEST['export_products_name'] == 1){
					$schema[] = xtc_get_products_name($pID);
				}
				$items[] = $schema;
			}
		} // EOF foreach products
		if(sizeOf($items)){
			$str = '';
			foreach($items as $row){
				$str .= implode($this->csv_separator,$row)."\r\n";
			}
			$basics->create_file($this->tmp_directory.'/PAGE_'.$page.'.CSV', $str);
		}
    }


    function process($file) {
		$basics = new basics;
        @xtc_set_time_limit(0);
		if( (isset($_REQUEST['cat']) and is_array($_REQUEST['cat']) and sizeOf($_REQUEST['cat'])>0) or ( isset($_REQUEST['allCat']) and $_REQUEST['allCat'] == '1' )){
		    $export_query_raw = $this->get_sql();
		    $export_query = xtc_db_query($export_query_raw);

			$csv = array(array('pID','Art.-Nr.','Phys. Bestand','Lager','Lagernummer','Anzahl','Lagerplatz'));
			if(isset($_REQUEST['export_products_name']) and $_REQUEST['export_products_name'] == 1){
				$csv[0][] = 'Artikelname';
			}
			$k = 0;
			while ($products = xtc_db_fetch_array($export_query)) {
				$places = array();
				$pID = $products['products_id'];
				$SQ = new products_quantity($pID);
				$phys = $SQ->get_products_total_qty();
				$query = xtc_db_query(sprintf(
					"SELECT storage_id,quantity,storage_places_id FROM storage_products WHERE products_id=%s ORDER BY priority",
					$pID
				));
				while($row = xtc_db_fetch_array($query)){
					$places[] = $row;
				}
				if(!sizeOf($places))
					continue;
				foreach($places as $place){
				    if($place['storage_places_id']>0){
					$place['storage_place'] = yes_get_storage_place_title($place['storage_places_id']);
				    }
				    $query = xtc_db_query(sprintf(
					    "SELECT nummer FROM storage_numbers WHERE products_id=%s AND storage_id=%s",
					    $pID,$place['storage_id']
				    ));
				    $record = xtc_db_fetch_array($query);
				    $csv[$k] = array(
					    $pID, $phys, xtc_get_storage_name($place['storage_id']),
					    $record['nummer'],$place['quantity'],
					    $place['storage_place']
				    );
                                    if(isset($_REQUEST['export_products_name']) and $_REQUEST['export_products_name'] == 1){
                                        $csv[$k][] = xtc_get_products_name($pID);
                                    }
                                    $k++;
				}
			}
			$schema = '';
			if(sizeOf($csv)){
				foreach($csv as $line){
					$schema .= implode($this->csv_separator,$line)."\r\n";
				}
			}
			// create File
			$fp = fopen(DIR_FS_CATALOG.'../ebaymich/' . $file, "w+");
			fputs($fp, $schema);
			fclose($fp);


			switch ($_POST['export']) {
				case 'yes':
				// send File to Browser
				$extension = substr($file, -3);
				$fp = fopen(DIR_FS_CATALOG.'../ebaymich/' . $file,"rb");
				$buffer = fread($fp, filesize(DIR_FS_CATALOG.'../ebaymich/' . $file));
				fclose($fp);
				header('Content-type: application/x-octet-stream');
				header('Content-disposition: attachment; filename=' . $file);
				echo $buffer;
				exit;
				break;
			}
	    }// end if categories_array
	}


    function display() {
		$array = array('text' =>  EXPORT_TYPE.'<br />'.
		    '<script type="text/javascript">'.
		    '$().ready(function(){'.
			    "$('.start_lbon_export_button').click(function(){
				$('#modal_window').dialog({title: 'Export',width:'auto',height:'auto'}).load(
				    '".xtc_href_link(FILENAME_MODULE_EXPORT,xtc_get_all_get_params(array('action')).'&action=save_stepwise')."&'+$('form[name=\"modules\"]').serialize()
				);
				return false;
			    });
		    });".
		    '</script>'.
		    
			EXPORT.'<br />'.
			xtc_draw_radio_field('export', 'no',false).EXPORT_NO.'<br />'.
			xtc_draw_radio_field('export', 'yes',true).EXPORT_YES.'<br /><br />'.
//			'<input type="checkbox" name="export_linked_products" value="1" />'.EXPORT_LINKED_PRODUCTS.'<br />'.
			'<input type="checkbox" name="export_products_name" value="1" />'.EXPORT_PRODUCTS_NAME.'<br />'.
			'<br />'.yes_draw_href_button(IMAGE_EXPORT,'javascript:','width:120px;','button','start_lbon_export_button ui-button ui-corner-all ui-state-default') . '&nbsp;' .
			yes_draw_href_button(IMAGE_CANCEL,xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=products_storages'),'width:120px;')
		);
		return $array;
    }

	function check() {
		if (!isset($this->_check)) {
			$check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PRODUCTS_STORAGES_STATUS'");
			$this->_check = xtc_db_num_rows($check_query);
		}
		return $this->_check;
	}

	function install() {
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PRODUCTS_STORAGES_FILE', 'yes_export.csv',  '6', '1', '', now())");
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PRODUCTS_STORAGES_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
	}

    function remove() {
		xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
		return array('MODULE_PRODUCTS_STORAGES_STATUS','MODULE_PRODUCTS_STORAGES_FILE');
    }
    
    public function get_total_number_of_items(){
	$query = xtc_db_query($this->get_sql());
	return xtc_db_num_rows($query);
    }
}
