<?php
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
define('MODULE_TEXTITEMS_TEXT_DESCRIPTION', 'Export - Textbausteine (Tab getrennt)');
define('MODULE_TEXTITEMS_TEXT_TITLE', 'Textbausteine Export - CSV');
define('MODULE_TEXTITEMS_FILE_TITLE' , '<hr noshade>Dateiname');
define('MODULE_TEXTITEMS_FILE_DESC' , 'Geben Sie einen Dateinamen ein, falls die Exportdatei am Server gespeichert werden soll.<br>(Verzeichnis ebaymich/)');
define('MODULE_TEXTITEMS_STATUS_DESC','Modulstatus');
define('MODULE_TEXTITEMS_STATUS_TITLE','Status');
define('MODULE_IMPORT_LINK','<p class="helptable">Die CSV Datei k&ouml;nnen Sie &uuml;ber <a href="javascript:;" style="margin-left:0px;padding-left:0px;" class="lbOn" id="ebayapi_textitems.php?action=import" title="Textbausteine Importieren"><u>diesen Link</u></a> wieder in YES importieren.</p>');
@define('EXPORT_YES','Nur Herunterladen');
@define('EXPORT_NO','Am Server Speichern');
// include needed functions

class textitems extends products_export{
    var $TextSign, $code, $title, $description, $enabled,$_check, $sort_order;


    function __construct() {
      $this->TextSign = '';
      $this->code = 'textitems';
      $this->title = MODULE_TEXTITEMS_TEXT_TITLE;
      $this->description = MODULE_TEXTITEMS_TEXT_DESCRIPTION;
      $this->sort_order = (defined('MODULE_TEXTITEMS_SORT_ORDER')) ? MODULE_TEXTITEMS_SORT_ORDER : 0;
      $this->enabled = ((defined('MODULE_TEXTITEMS_STATUS') and MODULE_TEXTITEMS_STATUS == 'True') ? true : false);
    }



    function process($file) {
		$basics = new basics;
		$order_by = 'class';
		@xtc_set_time_limit(0);
		$header = array('ID','Text','Titel','Modul','Modulwert','Betreff (E-Mail)','Sortierung','Angelegt am');
		$schema = array($header);
		$query = xtc_db_query("SELECT * FROM ebay_textitems ORDER BY ".$order_by);
		while($record = xtc_db_fetch_array($query)){
		    $line = array();
		    if(empty($record['date_added']) or $record['date_added'] == '0000-00-00 00:00:00'){
			$record['date_added'] = date('Y-m-d H:i:s');
		    }
		    foreach($record as $value){
			// date added kam spaeter - fuer kunden wo kein date_added gesetzt ist
		        $value = xtc_db_prepare_input($value);
		        $line[] = $value;
		    }
		    $schema[] = $line;
		}
		$fp = fopen(DIR_FS_CATALOG.'../ebaymich/' . $file, "w");
		foreach($schema as $line){
		    fputcsv($fp, $line,"\t");
		}
		fclose($fp);


		switch ($_POST['export']) {
        	case 'yes':
			
			$crypt_file = yes_get_sha1_from_string( date('d.m.Y_H.i.s') );
			$filename = sprintf('yes_textbausteine_%s.csv',$crypt_file);
			$filepath = \main::get_exportdata_path();
			$content = file_get_contents(DIR_FS_CATALOG.'../ebaymich/' . $file);
			$basics->create_file($filepath.$filename,$content);
			$basics->zip_file($filepath,$filename,$filename.'.zip',true);

			$file_contents = $basics->read_file_content($filepath.$filename.'.zip',$mode='rb');
			unlink(DIR_FS_CATALOG.'../ebaymich/' . $file);
			unlink($filepath.$filename.'.zip');
			// send File to Browser
			$file = 'yes_textbausteine_'.date('Y-m-d_H_i_s').'.zip';
			header('Content-Type: application/octet-stream');
			header('Content-Transfer-Encoding: binary');
			header('Content-disposition: attachment; filename=' . $file);
			echo $file_contents;
			exit;
			break;
        	}
	} // end if categories_array

    function display() {
		$array = array('text' =>  MODULE_IMPORT_LINK.EXPORT_TYPE.'<br />'.
			EXPORT.'<br />'.
			xtc_draw_radio_field('export', 'no',false).EXPORT_NO.'<br />'.
			xtc_draw_radio_field('export', 'yes',true).EXPORT_YES.'<br /><br />'.
			'<br />' . xtc_image_submit('button_export.gif','Exportieren') .
			'<a href="'.xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=yes').'">'.xtc_image_button('button_cancel.gif','Abbrechen').'</a>'
		);
		return $array;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_TEXTITEMS_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_TEXTITEMS_FILE', 'yes_textbausteine.csv',  '6', '1', '', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_TEXTITEMS_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
	}

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_TEXTITEMS_STATUS','MODULE_TEXTITEMS_FILE');
    }
}
