<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/
include('includes/application_top.php');
include('includes/classes/class.csv.php');
include(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
require(DIR_FS_INC.'xtc_get_ebay_link.inc.php');
require(DIR_FS_INC.'xtc_get_auction_site.inc.php');
$smarty = new yesSmarty;
$path = \main::get_exportdata_path().'RAexport/';
$base_dir = realpath($path);
$admin_access = main::get_admin_access();

$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';
switch( $action ) {
	case 'edit':
		$id = $_GET['id'] ?? null;
		if ($id === null) {
			die('Invalid item');
		}
		$item = yes_query("SELECT * FROM lawyer_export WHERE lawyer_export_id=:id",
			['id'=>$id],
			true
		);
		if ($item === null or $item === false) {
			die('Invalid item');
		}
		echo '<div class="main ui-widget-content" style="padding: 4px;">';
		if(!empty($item['customers_company'])){
			printf('%s: %s<br />',ENTRY_COMPANY,$item['customer_company']);
		}
		printf('Name: %s<br />',$item['customer_name']);
		echo xtc_draw_form('saveexp','lawyer_export.php','action=save&leID='.$id);

		printf('%s:<br>%s', TEXT_AKTENZEICHEN,
			xtc_draw_input_field('aktenzeichen',$item['aktenzeichen'])
		);

		$def = '';
		if($item['aktenzeichen_datum'] !== YES_SQL_EMPTY_DATE){
			$defD = new DateTime($item['aktenzeichen_datum']);
			$def = $defD->format('Y-m-d');
		}
		printf('<br>%s:<br>%s<br />',
			TEXT_AKTENZEICHEN .' '.TEXT_YES_EXPORT_MODULES_TYPE_DATE,
			xtc_draw_input_field('aktenzeichen_datum',$def,'',false,'date')
		);

		$def = '';
		if($item['auffschreiben_datum'] !== YES_SQL_EMPTY_DATE){
			$defD = new DateTime($item['auffschreiben_datum']);
			$def = $defD->format('Y-m-d');
		}
		printf('%s:<br>%s<br />',
			TEXT_AUFFORDERUNG_DATE,
		 	xtc_draw_input_field('auffschreiben_datum',$def,'',false,'date')
		);
		$def = '';
		if($item['weiterleitung_datum'] !== YES_SQL_EMPTY_DATE){
			$defD = new DateTime($item['weiterleitung_datum']);
			$def = $defD->format('Y-m-d');
		}
		printf('%s:<br>%s<br />',
			TEXT_FORDERUNG_WEITERLEITUNG_DATE,
			xtc_draw_input_field('weiterleitung_datum',$def,'',false,'date')
		);

		printf('%s:<br />%s<br />',
			TEXT_LAWYER_FEE,
			xtc_draw_input_field('lawyer_fees',number_format($lInfo->lawyer_fees,2,'.',''))
		);

		printf('<br>%s?<br>%s',TEXT_DUE_PAYED, 
			xtc_draw_radio_field('status','0',((intval($item['status']) == 0) ? true : false )).
			' Open<br>'.
			xtc_draw_radio_field('status','1',((intval($item['status']) == 1) ? true : false )).' Closed<br>'
		);
		if(!empty($item['warning_history'])){
			printf('<br>%s:<br>%s<br />',
				TEXT_LAWYER_WARNING_HISTORY,
				str_replace(' / ','<br>',$item['warning_history'])
			);
		}
		printf('<a href="%s"><button type="button" class="ui-button ui-corner-all ui-state-default">%s</button></a>',
			xtc_href_link('lawyer_export.php', xtc_get_all_get_params(array('leID', 'action'))),
			IMAGE_CANCEL
		);
		printf('<input type="submit" class="ui-button ui-corner-all ui-state-default" value="%s" />',
			IMAGE_UPDATE
		);
		echo '</form></div>';
		exit;
		break;
	case 'view':
		$id = $_GET['id'] ?? null;
		if ($id === null) {
			die('Invalid item');
		}
		$item = yes_query("SELECT * FROM lawyer_export WHERE lawyer_export_id=:id",
			['id'=>$id],
			true
		);
		if ($item === null or $item === false) {
			die('Invalid item');
		}

		$pEbay = array();
		if(!empty($item['ebay_id'])){
			$pEbay[] = $item['ebay_id'];
		}

		$ebays = '<br><b>eBay ID:</b>';
		for($eb=0;$eb<sizeOf($pEbay);$eb++){
			$ebays .= '<br><a target="_blank" href="'.xtc_get_ebay_link(xtc_get_auction_site($pEbay[$eb])).$pEbay[$eb].'">'.$pEbay[$eb]."</a>";
		}
		printf('<div class="main ui-widget-content"><b>%s:</b> %s<br /><b>%s:</b> %s<br /><b>%s:</b> %s<br /><b>%s</b> %s<br /><b>%s:</b> %s<br /><b>%s:</b> %s<br /><p><b>%s:</b></p><i>%s</i></div>',
			TEXT_YES_EXPORT_MODULES_TYPE_DATE,
			yes_date_short($item['date_saved']),
			TEXT_AKTENZEICHEN,
			$item['aktenzeichen'],
			TEXT_AKTENZEICHEN .' '.TEXT_YES_EXPORT_MODULES_TYPE_DATE,
			yes_date_short($item['aktenzeichen_datum']),
			TEXT_AUFFORDERUNG_DATE,
			yes_date_short($item['auffschreiben_datum']),
			TEXT_FORDERUNG_WEITERLEITUNG_DATE,
			yes_date_short($item['weiterleitung_datum']),
			TEXT_LAWYER_FEE,
			number_format($item['lawyer_fees'],2,',',''),
			TEXT_LAWYER_WARNING_HISTORY,
			str_replace('/','<br>',$item['warning_history'])
		);
		exit;
		break;
	case 'deletefile':
			$error = true;
			if(isset($_GET['file'])){
				$fn = basename($_GET['file']);
				$fn_full = realpath($path.$fn);
				if ($fn_full && strpos($fn_full, $base_dir) === 0 && is_file($fn_full)) {
					unlink($fn_full);
					$messageStack->add_session(LAWYER_EXPORT_FILE_DELETED,'success');
					$error = false;
				}
			}
			if($error === true){
				$messageStack->add_session(LAWYER_EXPORT_FILE_DELETE_FAILED,'error');
			}
			xtc_redirect( xtc_href_link('lawyer_export.php',xtc_get_all_get_params(array('action','file'))));
	case "save":
		$sql_array = array(
			'aktenzeichen' => $_POST['aktenzeichen'],
			'aktenzeichen_datum' => $_POST['aktenzeichen_datum'],
			'auffschreiben_datum' => $_POST['auffschreiben_datum'],
			'weiterleitung_datum' => $_POST['weiterleitung_datum'],
			'lawyer_fees' => $_POST['lawyer_fees'],
			'status' => $_POST['status'],
		);
		yes_db_perform('lawyer_export',$sql_array,'update',
			['lawyer_export_id'=>intval($_GET['leID'])]
		);
		$messageStack->add_session(LAWYER_EXPORT_FILE_UPDATED,'success');
		xtc_redirect( xtc_href_link('lawyer_export.php',xtc_get_all_get_params(array('leID','action')).'leID='.$_GET['leID']));
		break;
}

if(isset($_GET['lawyer_export_date_start']) && isset($_GET['lawyer_export_date_end'])){
	$files = array();
	$date_input_start = $_GET['lawyer_export_date_start'] ?? null;
	$date = DateTime::createFromFormat('Y-m-d', $date_input_start);
	$valid = $date && $date->format('Y-m-d') === $date_input_start;
	if (!$valid) {
		$messageStack->add_session('Invalid Start Date Input: '.$date_input_start,'error');
		xtc_redirect(xtc_href_link(basename(__FILE__)));
	}

	$date_input_end = $_GET['lawyer_export_date_end'] ?? null;
	$date = DateTime::createFromFormat('Y-m-d', $date_input_end);
	$valid = $date && $date->format('Y-m-d') === $date_input_end;
	if (!$valid) {
		$messageStack->add_session('Invalid End Date Input: '.$date_input_end,'error');
		xtc_redirect(xtc_href_link(basename(__FILE__)));
	}

	$getSDate = strtotime($date_input_start.' 00:00:00');
	$getEDate = strtotime($date_input_end.' 23:59:59');
	$dh = opendir($base_dir);
	while(false !== ($file = readdir ($dh))){
		$file_date = date('Y-m-d',filemtime($path.$file));
		$date_year = strtotime($file_date.' 10:00:00');
		if($date_year > $getSDate and $date_year < $getEDate and $file != '.' and $file != '..'){
			$files[] = $file;
		}
	}
	if(sizeOf($files) > 0){
		$contents = [];
		$table = new tableBlock();
		$table->table_parameters = 'class="yesListTable_minimal" style="width: auto;"';
		$allow_del = ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_lawyer_export_delete'] == '1')) ? true : false;
		foreach($files as $file){
			if($allow_del){
				$del = sprintf('<a href="javascript:really_delete(\'%s\')">%s</a>',
					xtc_href_link('lawyer_export.php','action=deletefile&file='.$file),
					xtc_image('images/icons/cross.gif',IMAGE_DELETE)
				);
			}else{
				$del = sprintf('<a href="#" onClick="alert(\'%s\');">%s</a>',
					IMAGE_AUTH_DENIED,
					xtc_image('images/icons/cross.gif',IMAGE_DELETE)
				);
			}
			$contents[] = [
				['text'=>sprintf('<a target="_blank" href="%s">%s</a>',
						$base_dir.$file,
						xtc_image('images/icon_save.gif',RIGHT_CLICK_TO_SAVE)
					)
				],
				['text'=>sprintf('<a target="_blank" href="%s">%s</a>',
						$base_dir.$file,
						$file
					)
				],
				['text'=>$del],
				['text'=>date('d.m.Y H:i:s',filemtime($path.$file))]
			];
		}
		$smarty->assign('FILE_TABLE', $table->tableBlock_draw($contents));

	}
}

yes_draw_pre_header();
yes_draw_header(TITLE);
$menus = array();

$q = "select * from lawyer_export order by date_saved desc";
$maxresults = (isset($_GET['view_mode']) and $_GET['view_mode'] == 'all') ? '1000' : intval(constant('MAX_DISPLAY_SEARCH_RESULTS'));
$page = yes_getIntFromRequest('page');
$lawyer_split = new splitPageResults( $page, $maxresults, $q, $lawyer_query_numrows);
$lawyer_query = xtc_db_query($q);

$table = new tableBlock();
$table->table_parameters = 'class="yesListTable_minimal" style="width: auto;"';
$contents = [[
	['text'=>TEXT_ORDER,'th'=>true],
	['text'=>'eBay','th'=>true],
	['text'=>TEXT_HEADER_CUSTOMERNAME,'th'=>true],
	['text'=>TEXT_HEADER_PRODUCT,'th'=>true],
	['text'=>'Total','th'=>true],
	['text'=>TEXT_EK_PRICE,'th'=>true],
	['text'=>TEXT_AMOUNT_DUE,'th'=>true],
	['text'=>'Status','th'=>true],
	['text'=>TEXT_YES_EXPORT_MODULES_TYPE_DATE,'th'=>true],
	['text'=>'&nbsp;','th'=>true],	
]];
while($lawyer = xtc_db_fetch_array($lawyer_query)){
	$address = '';
	if($lawyer['customer_company']!='')
		$address .= $lawyer['customer_company'].'<br>';
	if($lawyer['customer_name']!='')
		$address .= $lawyer['customer_name'].'<br>';
	if(isset($lawyer['customer_street']) and $lawyer['customer_street']!='')
		$address .= $lawyer['customer_street'].'<br>';
	if($lawyer['customer_suburb']!='')
		$address .= $lawyer['customer_suburb'].'<br>';
	if($lawyer['customer_city']!='')
		$address .= $lawyer['customer_postcode'].'&nbsp;'.$lawyer['customer_city'].'<br>';
	if($lawyer['customer_country']!='')
		$address .= $lawyer['customer_country'].'<br>';
	$order_string = sprintf('<a href="%s"><u>%s</u></a><br />%s',
		xtc_href_link('orders.php','oID='.$lawyer['orders_id'].'&action=edit'),
		$lawyer['orders_id'],
		yes_date_short($lawyer['date_purchased'])
	);
	$contents[] = [
		['text'=>$order_string],
		['text'=>$lawyer['ebay_id']],
		['text'=>$address],
		['text'=>str_replace('/','<br>',$lawyer['products'])],
		['text'=>number_format($lawyer['totalprice'],2,',',''),'align'=>'right'],
		['text'=>number_format($lawyer['ekprice'],2,',',''),'align'=>'right'],
		['text'=>number_format($lawyer['outstanding'],2,',',''),'align'=>'right'],
		['text'=>($lawyer['status']==1)?'Closed':'Open'],
		['text'=>yes_date_short($lawyer['date_saved'])],
		['text'=>sprintf(
			'<a class="lbOn" href="javascript:;" id="%s" title="%s">%s</a>',
				xtc_href_link('lawyer_export.php',xtc_get_all_get_params(array('id','action')).'action=view&id='.$lawyer['lawyer_export_id']),
				IMAGE_DETAILS,
				xtc_image('images/basicons/info22.png',IMAGE_DETAILS,20)
			).'&nbsp;'.
			sprintf('<a class="lbOn" href="javascript:;" id="%s" title="%s">%s</a>',
				xtc_href_link('lawyer_export.php',xtc_get_all_get_params(array('id','action')).'action=edit&id='.$lawyer['lawyer_export_id']),
				IMAGE_EDIT,
				xtc_image('images/basicons/black406.png',IMAGE_EDIT,20)
			)
		],
		
	];
}
$contents[] = [
	['text'=>$lawyer_split->display_count($lawyer_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, $page, TEXT_DISPLAY_NUMBER_OF_ITEMS)
    	.'<br />'.$lawyer_split->display_links($lawyer_query_numrows, MAX_DISPLAY_SEARCH_RESULTS_ADMIN, MAX_DISPLAY_PAGE_LINKS, $page),
	'params'=>'colspan="10" align="center"']
];
$smarty->assign(array(
	'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
	'HEADING_TITLE'=>LAWYER_EXPORT_HEADING_TITLE,
	'PAGE_HEADING_MENU_BUTTONS'=>$menus,
	'TABLE'=>$table->tableBlock_draw($contents),
	'LAWYER_EXPORT_DATE_FILTER'=>LAWYER_EXPORT_DATE_FILTER,
	'lawyer_export_date_start'=>$_GET['lawyer_export_date_start']??'',
	'lawyer_export_date_end'=>$_GET['lawyer_export_date_end']??'',
	'today'=>date('Y-m-d'),
	'LAWYER_EXPORT_DATE_RESULT'=>LAWYER_EXPORT_DATE_RESULT,
	'FILES'=>$files,
	'RIGHT_CLICK_TO_SAVE'=>RIGHT_CLICK_TO_SAVE,
	'FILE_PATH'=>$base_dir,
	'IMAGE_SELECT'=>IMAGE_SELECT,
	'DELETE_ENTRY'=>DELETE_ENTRY,
));
$smarty->display('lawyer_export.html');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');