<?php
/* --------------------------------------------------------------
   $Id: module_export.php,v 1.58 2019/09/18 06:49:21 ssh-511548-cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(modules.php,v 1.45 2003/05/28); www.oscommerce.com 
   (c) 2003	 nextcommerce (modules.php,v 1.23 2003/08/19); www.nextcommerce.org

   Released under the GNU General Public License 
   --------------------------------------------------------------*/
require('includes/application_top.php');
$YES_XML_RPC_FUNCTIONS = array(
    'getConfig',
    //'getOrders',
    'getProduct',
    'getProductQuantity',
    'getCategories',
    'getProductsInCategory',
    'searchProducts'
);

$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
define('EXPORT','Bitte den Sicherungsprozess AUF KEINEN FALL unterbrechen. Dieser kann einige Minuten in Anspruch nehmen.');
define('EXPORT_TYPE','<hr noshade="noshade" /><b>Speicherart:</b><br /><i>Wenn Sie direkt auf dem Server speichern, haben Sie die Datei in Ihrem YES Dateimanager zur Verf&uuml;gung.</i>');
// include needed functions (for modules)

require_once(DIR_WS_CLASSES.'product.php');
require_once(DIR_WS_CLASSES.'class.products_export.php');
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_WS_FUNCTIONS . 'export_functions.php');
require_once(DIR_FS_INC .'xtc_get_product_path.inc.php');
require_once(DIR_WS_CLASSES."class.products_characteristic.php");
require_once(DIR_FS_INC .'xtc_get_parent_categories.inc.php');
$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';
switch($action){
    case 'yce_box':
        require_once(DIR_WS_CLASSES.'yes_cron_export.php');
        require_once('includes/modules/export/yes2.php');
        $module = new yes2();
        $box = new box;
        $BASICS = new basics;
        if(isset($_GET['yceID'])){
            $yce = new yes_cron_export((int)xtc_db_input($_GET['yceID']));
            $heading[] = array('text' => '<b>#' . $yce->getId().' '.$yce->getName() . '</b>');
        }else{
            $heading[] = array('text' => '<b>' . YCE_CREATE_NEW_ENTRY . '</b>');
        }
        switch($_GET['box_action']){
            case 'update_own_header':
                $yce->update_heading_rows($_GET['own_text']);
                die(json_encode(array(
                    'MSG'=>1
                )));
                break;
            case 'add':
                // WIR WOLLEN AUSGEWAEHLTE KATEGORIEN EXPORTEN
                $distributor_input_array = array(
                        0=>array('id'=>'','text'=>'Alle')
                );
                $distributors_query = xtc_db_query("SELECT id,name FROM distributors ORDER BY name");
                while($distributors = xtc_db_fetch_array($distributors_query)){
                        $distributor_input_array[] = array(
                                'id'=>$distributors['id'],
                                'text'=>$distributors['name']
                        );
                }
                $contents = array('form' => xtc_draw_form('yce_edit_form', basename(__FILE__), xtc_get_all_get_params(array('action','box_action')) . 'action=cron_export_config&yce_action=save','POST'));
                $contents[] = array('text' => YCE_CREATE_NEW_ENTRY.
                    // MUSS IRGENDWO EINGEFUEGT WERDEN,
                    // DANN HALT HIER
                    '<script src="minify_js.php?file=js/yes_export_module.js" type="text/javascript"></script>'.
                    '<script>'.
                    '   var AE_BASELINK="'.xtc_href_link(basename(__FILE__),xtc_get_all_get_params()).'";'.
                    '   $(function(){'.
                    '        $("form[name=\'yce_edit_form\'] table#categories_select_table").hide(); '.
                    '        $("form[name=\'yce_edit_form\'] input[name=\'allCat\']").on(\'click\',function(){'.
                    '           $("form[name=\'yce_edit_form\'] table#categories_select_table").toggle(); '.
                    '        });'.
                    '   });'.
                    '   $("form[name=\'yce_edit_form\']").on(\'submit\',function(){'.
                    '       if($("form[name=\'yce_edit_form\'] select[name=\'ini_file\']").val() == \'\'){ '.
                    '           $("form[name=\'yce_edit_form\'] select[name=ini_file]").effect(\'highlight\');'.
                    '           return false;'.
                    '       }'.
                    '       if($("form[name=\'yce_edit_form\'] input[name=\'name\']").val() == \'\'){ '.
                    '           $("form[name=\'yce_edit_form\'] input[name=name]").effect(\'highlight\');'.
                    '           return false;'.
                    '       }'.
                    '       if($("form[name=\'yce_edit_form\'] input[name=\'export_filename\']").val() == \'\'){ '.
                    '           $("form[name=\'yce_edit_form\'] input[name=export_filename]").effect(\'highlight\');'.
                    '           return false;'.
                    '       }'.
                    '       var post_url = $("form[name=\'yce_edit_form\']").attr(\'action\');' .
                    '       var post_data = $("form[name=\'yce_edit_form\']").serialize();'.
                    '       $.ajax({'.
                    '           url: post_url,'.
                    '           dataType: \'json\','.
                    '           data: post_data,'.
                    '           type: \'POST\','.
                    '           success: function(json){'.
                    '               if(json.ERR.length){'.
                    '                   alert(json.ERR.join("\r\n\r\n"));'.
                    '                   return false;'.
                    '               }'.
                    '               if(json.MSG.length){'.
                    '                   alert(json.MSG.join("\r\n\r\n"));'.
                    '               }'.
                    '               window.location.href=\''.xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('box_action','action')).'action=cron_export_config').'\';'.
                    '               return false;'.
                    '           },'.
                    '           error: function(xhr, ajaxOptions, thrownError){'.
                    '               alert(xhr.status+": "+thrownError);'.
                    '           }'.
                    '       });'.
                    '       return false;'.
                    '   });'.
                    '</script>' //$module->getCategoryJSString()
                );
                $ini_file_select = array(array('id'=>'','text'=>TEXT_SELECT));
                $available_inis = yes_cron_export::get_inis();
                foreach($available_inis as $ai){
                    if(yes_cron_export::get_yes_cron_export_id_by_ini_file($ai['text']) > 0){
                        continue;
                    }
                    $ini_file_select[] = $ai;
                }
                $contents[] = array('text' => sprintf('%s:<br />%s',
                    YCE_INI_FILE,
                    xtc_draw_pull_down_menu('ini_file',$ini_file_select)
                ));
                $contents[] = array('text' => sprintf('%s:<br />%s',
                    'Name',
                    xtc_draw_input_field('name','EXPORT '.date('Y-m-d His'),'size="32" maxlength="64"')
                ));
                $contents[] = array('text' => sprintf('%s %s',
                    xtc_draw_checkbox_field('use_heading_row','1',false),
                    YCE_USE_HEADING_ROW
                ));
                $contents[] = array('text' => sprintf('%s: <img src="images/basicons/info22.png" width="15" height="15" title="%s" /><br />%s',
                    YCE_EXPORT_FILENAME,
                    YCE_HINT_EXPORT_FILENAME,
                    xtc_draw_input_field('export_filename','export.csv','size="32" maxlength="64"')
                ));
                $contents[] = array('text' => sprintf('%s:<br />%s',
                    YCE_EXPORT_INTERVAL_IN_HOURS,
                    xtc_draw_pull_down_menu('export_interval_in_hours',yes_cron_export::getExport_interval_in_hours_values(),4)
                ));
                $contents[] = array('text' => sprintf('%s %s',
                    xtc_draw_checkbox_field('export_linked_products','1',false),
                    YCE_EXPORT_LINKED_PRODUCTS
                ));
                $contents[] = array('text' => sprintf('%s:<br />%s',
                    YCE_DISTRIBUTORS_ID,
                    xtc_draw_pull_down_menu('distributors_id',$distributor_input_array)
                ));
                $contents[] = array('text' => sprintf('%s:<br />%s',
                    YCE_ALLCAT,
                    xtc_draw_checkbox_field('allCat','1',true,false,'onClick="allCatFunc();"')
                ));
                $contents[] = array('text' => $module->getCategoriesString());
                $contents[] = array('text' => 
                    yes_draw_href_button(IMAGE_CANCEL, xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('box_action','action')).'action=cron_export_config'), 'width: 200px;', 'button')
                );
                $contents[] = array('text' => 
                    yes_draw_href_button(IMAGE_SAVE, '', 'width: 200px;', 'submit')
                );
                break;
            case 'edit':
                // WIR WOLLEN AUSGEWAEHLTE KATEGORIEN EXPORTEN
                $distributor_input_array = array(
                        0=>array('id'=>'','text'=>'Alle')
                );
                $distributors_query = xtc_db_query("SELECT id,name FROM distributors ORDER BY name");
                while($distributors = xtc_db_fetch_array($distributors_query)){
                        $distributor_input_array[] = array(
                                'id'=>$distributors['id'],
                                'text'=>$distributors['name']
                        );
                }
                $contents = array('form' => xtc_draw_form('yce_edit_form', basename(__FILE__), xtc_get_all_get_params(array('action','box_action')) . 'action=cron_export_config&yce_action=save','POST'));
                $js_saved_cats = '"'.implode('","', explode(',',$yce->getCat())).'"';
                $contents[] = array('text' => sprintf('%s: <i>%s</i>%s',
                    YCE_INI_FILE,
                    $yce->getIni_file(),
                    // MUSS IRGENDWO EINGEFUEGT WERDEN,
                    // DANN HALT HIER
                    '<script src="minify_js.php?file=js/yes_export_module.js" type="text/javascript"></script>'.
                    '<script>'.
                    '   var AE_BASELINK="'.xtc_href_link(basename(__FILE__),xtc_get_all_get_params()).'";'.
                    '   var SAVED_CATS = ['.$js_saved_cats.'];'.
                    '   $(function(){'.
                    '        if($("form[name=\'yce_edit_form\'] input[name=\'allCat\']").is(\':checked\')){ '.
                    '           $("form[name=\'yce_edit_form\'] table#categories_select_table").hide(); '.
                    '        }else{'.
                    '            $("form[name=\'yce_edit_form\'] table#categories_select_table tbody tr td input[name=\'cat[]\']").each(function(){'.
                    '               $(this).prop(\'disabled\', false);'.
                    '               if(SAVED_CATS.indexOf($(this).val()) > -1 ){'.
                        '               $(this).prop(\'checked\', true);'.
                    '               }'.
                    '            });'.
                    '        }'.
                    '        $("form[name=\'yce_edit_form\'] input[name=\'allCat\']").on(\'click\',function(){'.
                    '           $("form[name=\'yce_edit_form\'] table#categories_select_table").toggle(); '.
                    '        });'.
                    '        $("form[name=\'yce_edit_form\']").on(\'submit\',function(){'.
                    '           if($("form[name=\'yce_edit_form\'] input[name=\'name\']").val() == \'\'){ '.
                    '               $("form[name=\'yce_edit_form\'] input[name=name]").effect(\'highlight\');'.
                    '              return false;'.
                    '           }'.
                    '           if($("form[name=\'yce_edit_form\'] input[name=\'export_filename\']").val() == \'\'){ '.
                    '               $("form[name=\'yce_edit_form\'] input[name=export_filename]").effect(\'highlight\');'.
                    '               return false;'.
                    '           }'.
                    '           var post_url = $("form[name=\'yce_edit_form\']").attr(\'action\');' .
                    '           var post_data = $("form[name=\'yce_edit_form\']").serialize();'.
                    '           $.ajax({'.
                    '               url: post_url,'.
                    '               dataType: \'json\','.
                    '               data: post_data,'.
                    '               type: \'POST\','.
                    '               success: function(json){'.
                    '                   if(json.ERR.length){'.
                    '                       alert(json.ERR.join("\r\n\r\n"));'.
                    '                       return false;'.
                    '                   }'.
                    '                   if(json.MSG.length){'.
                    '                       alert(json.MSG.join("\r\n\r\n"));'.
                    '                   }'.
                    '                   window.location.href=\''.xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('box_action','action')).'action=cron_export_config').'\';'.
                    '                   return false;'.
                    '               },'.
                    '               error: function(xhr, ajaxOptions, thrownError){'.
                    '                   alert(xhr.status+": "+thrownError);'.
                    '               }'.
                    '           });'.
                    '           return false;'.
                    '       });'.
                    '   });'.
                    '</script>' //$module->getCategoryJSString()
                ));
                
                $contents[] = array('text' => sprintf('%s:<br />%s',
                    'Name',
                    xtc_draw_input_field('name',$yce->getName())
                ));
                $contents[] = array('text' => sprintf('%s %s',
                    xtc_draw_checkbox_field('use_heading_row','1',(bool)$yce->getUse_heading_row()),
                    YCE_USE_HEADING_ROW
                ));
                $contents[] = array('text' => sprintf('%s:<br />%s',
                    YCE_EXPORT_FILENAME,
                    xtc_draw_input_field('export_filename',$yce->getExport_filename(),'size="32" maxlength="64"')
                ));
                $contents[] = array('text' => sprintf('%s:<br />%s',
                    YCE_EXPORT_INTERVAL_IN_HOURS,
                    xtc_draw_pull_down_menu('export_interval_in_hours',$yce->getExport_interval_in_hours_values(),$yce->getExport_interval_in_hours())
                ));
                $contents[] = array('text' => sprintf('%s %s',
                    xtc_draw_checkbox_field('export_linked_products','1',(bool)$yce->getExport_linked_products()),
                    YCE_EXPORT_LINKED_PRODUCTS
                ));
                $contents[] = array('text' => sprintf('%s:<br />%s',
                    YCE_DISTRIBUTORS_ID,
                    xtc_draw_pull_down_menu('distributors_id',$distributor_input_array,$yce->getDistributors_id())
                ));
                $contents[] = array('text' => sprintf('%s:<br />%s',
                    YCE_ALLCAT,
                    xtc_draw_checkbox_field('allCat','1',(bool)$yce->getAllCat(),false,'onClick="allCatFunc();"')
                ));
                $contents[] = array('text' => $module->getCategoriesString());
                $contents[] = array('text' => 
                    yes_draw_href_button(IMAGE_CANCEL, xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('box_action','action')).'action=cron_export_config'), 'width: 200px;', 'button')
                );
                $contents[] = array('text' => 
                    yes_draw_href_button(IMAGE_SAVE, '', 'width: 200px;', 'submit')
                );
                break;
            case 'delete_confirm':
                $contents = array('form' => xtc_draw_form('yce_edit_form', basename(__FILE__), xtc_get_all_get_params(array('action','box_action')) . 'action=cron_export_config&yce_action=delete'),'POST');
                $contents[] = array(
                    'text'=>YCE_REALLY_DELETE
                );
                $contents[] = array('text' => 
                    yes_draw_href_button(IMAGE_CANCEL, xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('box_action','action')).'action=cron_export_config'), 'width: 200px;', 'button')
                );
                $contents[] = array('text' => 
                    yes_draw_href_button(IMAGE_DELETE, '', 'width: 200px;', 'submit')
                );
                break;
            default:
                $contents[] = array('align'=>'center','text'=>
                    yes_draw_href_button(IMAGE_EDIT,
                    'javascript:ajax_box_action('.$yce->getId().',\'yce_box&box_action=edit\')','width: 200px'));
                $contents[] = array('align'=>'center','text'=>
                    yes_draw_href_button(IMAGE_DELETE,
                    'javascript:ajax_box_action('.$yce->getId().',\'yce_box&box_action=delete_confirm\')','width: 200px'));
                $contents[] = array('text'=>sprintf('<b>%s:</b> %s',YCE_DATE_ADDED, xtc_date_long($yce->getDate_added())));
                $dl = $yce->getExport_filename();
                if(!is_file(DIR_FS_CATALOG.'files/'.$dl)){
                    $dl = false;
                }
                $contents[] = array('text'=>sprintf('<b>%s:</b> %s %s',YCE_LAST_EXPORT, xtc_date_long($yce->getLast_export()),
                        ($dl and $yce->getLast_export() > '0000-00-00 00:00:00') ? '<a href="'.HTTP_SERVER.'files/'.$dl.'"><img src="images/basicons/down123.png" width="15" height="15" align="left" title="Download" border="0" style="margin-right: 5px;" /></a>' : ''
                ));
                $contents[] = array('text'=>sprintf('<b>%s:</b> %s',YCE_USE_HEADING_ROW, ($yce->getUse_heading_row() == 1) ? YES : NO ));
                $contents[] = array('text'=>sprintf('<b>%s:</b> %s',YCE_INI_FILE, $yce->getIni_file()));
                $contents[] = array('text'=>sprintf('<b>%s:</b> %s',YCE_EXPORT_FILENAME, $yce->getExport_filename()));
                $contents[] = array('text'=>sprintf('<b>%s:</b> %s',YCE_EXPORT_LINKED_PRODUCTS, ($yce->getExport_linked_products()==1) ? YES : NO  ));
                $contents[] = array('text'=>sprintf('<b>%s:</b> %s',YCE_ALLCAT, ($yce->getAllCat()==1) ? YES : NO  ));
                $contents[] = array('text'=>sprintf('<b>%s:</b> %s',YCE_DISTRIBUTORS_ID, ($yce->getDistributors_id()>0) ? xtc_get_distributor_name($yce->getDistributors_id()) : '-'  ));
                if($yce->getUse_heading_row()){
                    $saved_header = $yce->get_heading_rows();
                    $ini_file = $yce->getIni_file();
                    $ini = $module->get_ini('yes2_'.$ini_file.'.ini');
                    $header = $module->get_header();
                    $heading_row = $module->get_heading_row($header, $ini);
                    $replace = false;   // WIR WOLLEN DIE SORTIERTEN ORIGINAL
                                        // HEADER NAMEN
                    $yce_hr = $yce->get_heading_rows();
                    $sorted = $module->sort_heading_row($heading_row, array(
                        'use_heading_row'=>(bool)$yce->getUse_heading_row(),
                        'header_rows'=>$yce_hr,
                    ), $ini, $replace);

                    $contents[] = array(
                        'text'=>'<br /><a href="javascript:;" id="toggle_yce_own">'.YCE_OWN_HEADINGS.'</a><br />'
                    );
                    $table = '<div class="main"><table border="0" class="yesListTable_minimal yce_own_desc_table">';
                    $table .= '<tfoot><th><input type="button" name="yce_save_own" value="'.IMAGE_SAVE.'" class="ui-button ui-corner-all ui-state-default" /></th></tfoot><tbody>';
                    foreach($sorted as $hsort=>$hc){
                        $checked = false;
                        $own_text = '';
                        foreach($yce_hr as $yhr){
                            if($yhr->sort_order == $hsort){
                                $checked = true;
                                $own_text = $yhr->getName();
                            }
                        }
                        $table .= '<tr><td>'.xtc_draw_checkbox_field('sort['.$hsort.']','1',$checked).' '.$hc.'</td></tr>';
                        $table .= '<tr class="yce_ohr"><td>'.xtc_draw_input_field('own_text['.$hsort.']',$own_text,'size="32" maxlength="128"').'</td></tr>';
                    }
                    $table .= '</tbody></table></div>';
                    $contents[] = array(
                        'text'=>$table
                    );
                }
                break;
        }
        header('Content-Type: text/html; charset='.CHARSET);
        ?>
<script>
$(function(){
    $('input[name="yce_save_own"]').on('click',function(){
        var params = [];
        $('table.yce_own_desc_table tbody tr.yce_ohr').each(function(){
            if($(this).find('input[type="text"]').val() != ''){
                params.push(
                    $(this).find('input[type="text"]').attr('name') +'='+encodeURIComponent($(this).find('input[type="text"]').val())
                );
            }
        });
        $.ajax({
            url: '<?php echo xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('box_action','own_tex')).'box_action=update_own_header'); ?>&'+params.join('&'),
            dataType: 'json',
            success: function(json){
                $('table.yce_own_desc_table').hide();
            }
        });
    });
    $('table.yce_own_desc_table').hide();
    $('a#toggle_yce_own').on('click',function(){
        $('table.yce_own_desc_table').toggle();
    });
    $('table.yce_own_desc_table tbody tr.yce_ohr').hide();
    $('table.yce_own_desc_table tbody tr td input[type="checkbox"]').each(function(){
        $(this).on('change',function(){
            $(this).parent().parent().next().toggle();
            if(!$(this).is(':checked')){
                $(this).parent().parent().next().find('input[type="text"]').val('');
            }
        });
    });
    $('table.yce_own_desc_table tbody tr.yce_ohr').each(function(){
        if($(this).prev().find('input[type="checkbox"]').is(':checked')){
            $(this).show();
        }
    });
});
</script>
        <?php
        echo $box->infoBox($heading, $contents);
        exit;
        break;
    case 'cron_export_config':
        include('yes_cron_export_configuration.php');
        exit;
        break;
    case 'edit_export_config':
	$basics = new basics;
        $export_config = (isset($_REQUEST['export_config'])) ? $_REQUEST['export_config'] : '';
        require_once(DIR_WS_INCLUDES.'modules/export/yes2.php');
        $yes2 = new yes2;
        $ini = $yes2->get_ini('yes2_'.basename($export_config.'.ini'));
        $header = $yes2->get_header();
        $ini_sorted = array();
        $ini_sort_exists = array();
        $not_saved = 0;
        foreach($ini as $g=>$values){
            foreach($values as $k=>$v){
                $sort_order = $v;
                while(isset($ini_sorted[$sort_order])){
                    $sort_order++;
                    // VERMUTLICH WURDEN DIE SORT ORDER ANGABEN
                    // NOCH NICHT GESPEICHERT
                    $not_saved = 1;
                }
                $ini_sorted[$sort_order] = array(
                    'id'=>$g.':'.$k,
                    'group'=>$header[$g]['title'],
                    'name'=>$header[$g]['items'][$k],
                    'sort_order'=>$sort_order
                );
            }
        }
        $smarty->assign(array(
            'MODULE' => $_REQUEST['module'],
            'EXPORT_CONFIG'=>$export_config,
            'HEADER'=>$header,
            'FORM'=>xtc_draw_form('export_config',FILENAME_MODULE_EXPORT,xtc_get_all_get_params(array('action')).'action=export_config_update'),
            'JS_PROMPT_FILENAME'=>JS_PROMPT_FILENAME,
            'JS_FILENAME_HINTS'=>JS_FILENAME_HINTS,
            'MODE'=>'edit',
            'SAVED_INI'=>$ini,
            'SORTED_SAVED_INI'=>$ini_sorted,
            'TEXT_UPDATE_SORT'=> BUTTON_SORT_ORDER_SAVE,
            'NOT_SAVED'=>$not_saved,
            'SORT_ORDER_CONFIG'=>SORT_ORDER_CONFIG,
            'SORT_ORDER_CONFIG_INTRO'=>SORT_ORDER_CONFIG_INTRO
        ));
        header('Content-Type: text/html; charset='.CHARSET);
        $smarty->display('module_export_config.tpl');
        exit;
        break;
    case 'yes2_products_id_export':
        $code = 'yes2';
        $max_products = 500;
        if(is_countable($_REQUEST['products_id']) && sizeOf($_REQUEST['products_id']) > $max_products){
            printf('<p class="errorText">'.TEXT_MODULE_EXPORT_YES2_BY_PRODUCTS_LIMITED.'</p>',sizeOf($_REQUEST['products_id']),$max_products);
            $_REQUEST['products_id'] = array_slice($_REQUEST['products_id'],0,$max_products);
        }
        
        
        printf(TEXT_MODULE_EXPORT_YES2_BY_PRODUCTS_INTRO,sizeOf($_REQUEST['products_id']));
	$export_config_files = array(array('id'=>'','text'=>TEXT_SELECT));
	$filePath = \main::get_exportdata_path().'module_export_configs/';
	if(!is_dir($filePath)){
	    mkdir($filePath);
	}
	$basics = new basics;
	$dir = $basics->get_directory_content($filePath);
	foreach($dir as $fn){
	    if(substr($fn,0,strlen($code)) == $code){
		$export_config_files[] = array(
		    'id'=>str_replace(array('.ini','yes2_'),'',$fn),
		    'text'=>str_replace(array('.ini','yes2_'),'',$fn)
		);
	    }
	}

        echo xtc_draw_form('modules','module_export.php','module=yes2&action=save&export=yes','POST');
        printf('<p>'.TEXT_USE_EXPORT_CONFIG.':<br />%s</p>',
                xtc_draw_pull_down_menu('export_config_file',$export_config_files)
        );
        echo xtc_draw_hidden_field('products_id_export',implode(',',$_REQUEST['products_id']));
        echo '<input type="submit" value="Export" class="ui-button ui-corner-all ui-state-default" />';
        echo '</form>';
        exit;
        break;
    case 'delete_config_file':
        require_once(DIR_WS_CLASSES.'yes_cron_export.php');
	$filePath = \main::get_exportdata_path().'module_export_configs/';
	switch($_REQUEST['module']){
	    case 'ebay_products':
		$filePath .= 'ebay_products/ebay_products_';
		break;
	    case 'yes2':
		$filePath .= 'yes2_';
		break;
	}
	$file = basename($_REQUEST['file'].'.ini');
        $yceID = yes_cron_export::get_yes_cron_export_id_by_ini_file($ini_file);
        if($yceID > 0){
            $yce = new yes_cron_export($yceID);
            $yce->delete();
        }
	if(is_file($filePath.$file)){
	    unlink($filePath.$file);
	}
	$messageStack->add_session(MSG_SUCCESS_DELETE_CONFIG_FILE,'success');
	xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('file','action')).'action=edit'));
	break;
    case 'export_config_save':
    case 'export_config_update':
        $edit = ($action == 'export_config_update') ? true : false;
	$fileName = xtc_db_input($_REQUEST['module']).'_'.basename($_REQUEST['name']);
	if(!preg_match('/^[A-Za-z0-9-_]+$/',$fileName)) {
	   die(json_encode(array(
	       'MSG'=>'Invalid filename '.$fileName
	   )));
	}
	$fileName .= '.ini';
	$filePath = \main::get_exportdata_path().'module_export_configs/';
	switch($_REQUEST['module']){
	    case 'ebay_products':
		$filePath .= 'ebay_products/';
		break;
	}
	if(!is_dir($filePath)){
	    mkdir($filePath);
	}
	if(!is_writable($filePath)){
	    die(json_encode(array(
		'MSG'=>$filePath . ' is not writable'
	    )));
	}
	if(!$edit && is_file($filePath.$fileName)){
	    die(json_encode(array(
		'MSG'=>$_REQUEST['name'] . ' exists'
	    )));
	}
	$output = '';
        $_tmp = array();
        if(isset($_REQUEST['sort'])){
            $edit = 1;
            foreach ($_REQUEST['sort'] as $key => $sort_order){
                $split = explode(':',$key);
                if(sizeOf($split)>1){
                    $section = $split[0];
                    $skey = $split[1];
                }else{
                    $section = $key;
                    $skey = '';
                }
                if(!isset($_tmp[ $section ])){
                    $_tmp[ $section ] = array();
                }
                if($skey != ''){
                    $_tmp[ $section ][ $skey ] = $sort_order;
                }else{
                    $_tmp[ $section ] = $sort_order;
                }
            }
            foreach($_tmp as $section => $values){
                $section = trim($section);
                //add section
                $output .= "[$section]\r\n";

                //add key/value pairs
                if(is_array($values)){
                    foreach ($values as $val=>$sort_order) {
                        $output .= "$val=$sort_order\r\n";
                    }
                }else{
                    $output .= "export=$values\r\n";
                }
                $output .= "\r\n";
            }
        }else{
            $sort_order = 1;
// HIER MUESSEN WIR BEIM MODUS EDIT ERMITTELN OB NEUE FELDER BEI
// SIND UND FUER DIESE DEN SORT ORDER AUTOM. VERGEBEN
            foreach ($_REQUEST['field'] as $section => $values){
                    //values must be an array
                    if (!is_array($values)) {
                        if($values != '1'){
                            continue;
                        }
                    }
                    $section = trim($section);
                    //add section
                    $output .= "[$section]\r\n";

                    //add key/value pairs
                    if(is_array($values)){
                        foreach ($values as $val) {
                            $output .= "$val=$sort_order\r\n";
                        }
                    }else{
                        $output .= "export=$sort_order\r\n";
                    }
                    $output .= "\r\n";
            }
        }
	if(empty($output)){
	    die(json_encode(array(
		'MSG'=>TEXT_EXPORT_CONFIG_NO_DATA
	    )));
	}
        if($edit){
            unlink($filePath.$fileName);
        }
	file_put_contents($filePath.$fileName, trim($output));
	die(json_encode(array(
	    'MSG'=>'',
	    'FILE'=>str_replace('.ini','',$fileName)
	)));
	exit;
	break;
    case 'export_config':
	require_once('module_export_config.php');
	exit;
	break;
    case 'update_yes_xmlrpc_functions':
	$id = (int)xtc_db_input($_REQUEST['id']);
	$funcs = xtc_db_input(implode(';',$_REQUEST['function']));
	$update_sql_array = array(
	    'allowed_functions'=>$funcs
	);
	xtc_db_perform('yes_xmlrpc_token',$update_sql_array,'update',"id='".$id."'");
	$query = xtc_db_query(sprintf(
		"SELECT token_alias FROM yes_xmlrpc_token WHERE id='%s'",$id
	));
	$record = xtc_db_fetch_array($query);
	
	$messageStack->add_session(sprintf(MODULE_EXPORT_YES_XMLRPC_FUNCTIONS_UPDATED,$record['token_alias']),'success');
	xtc_redirect(xtc_href_link('module_export.php',xtc_get_all_get_params(array('action','module')).'action=edit&module=yes_xmlrpc'));
	break;
    case 'yes_xmlrpc_functions':
	$id = (int)xtc_db_input($_REQUEST['id']);
	$query = xtc_db_query(sprintf(
		"SELECT token_alias,allowed_functions FROM yes_xmlrpc_token WHERE id='%s'",$id
	));
	$record = xtc_db_fetch_array($query);
	echo xtc_draw_form('yes_xmlrpc_func','module_export.php?action=update_yes_xmlrpc_functions&id='.$id,'','post');
	echo '<fieldset><legend><b>';
	printf(MODULE_EXPORT_YES_XMLRPC_ALLOWED_FUNCTIONS_INTRO,$record['token_alias']);
	echo '</b></legend>';
	$allowed = explode(';',$record['allowed_functions']);
	foreach($YES_XML_RPC_FUNCTIONS as $func){
	    echo xtc_draw_checkbox_field('function[]',$func,(in_array($func,$allowed))).$func.'&nbsp;&nbsp;';
	}
	echo '<br /><input type="submit" class="ui-button ui-corner-all ui-state-default" value="'.IMAGE_UPDATE.'" />';
	echo '</fieldset></form><br />';
	exit;
	break;
    case 'get_categories_select':
	$pe = new products_export;
	$html = $pe->get_categories_select( (int)xtc_db_input($_REQUEST['parent_id']) );
	die(json_encode(array(
	    'is_flat'=>(($html == '') ? 1 : 0),
	    'html'=>$html
	)));
	break;
    case 'yes_xmlrpc_token_delete':
	$id = (int)xtc_db_input($_REQUEST['id']);
	xtc_db_query(sprintf(
		"DELETE FROM yes_xmlrpc_token WHERE id='%s'",$id
	));
	$messageStack->add_session('Der YES XMLRPC Token wurde entfernt.','success');
	xtc_redirect(xtc_href_link('module_export.php',xtc_get_all_get_params(array('action')).'action=edit'));
	break;
    case 'yes_xmlrpc_token_add':
	if(!isset($_REQUEST['token']) or strlen(trim($_REQUEST['token'])) != 32 ){
	    $messageStack->add_session('Der Token muss 32 Zeichen lang sein. Erlaubt sind Gross/Klein Buchstaben und Zahlen');
	    xtc_redirect(xtc_href_link('module_export.php',xtc_get_all_get_params(array('action')).'action=edit'));
	}
	$token = $_REQUEST['token'];
	if(!isset($_REQUEST['token_alias']) or empty($_REQUEST['token_alias'])){
	    $token_alias = 'Token vom '.date('d.m. H:i:s');
	}else{
	    $token_alias = $_REQUEST['token_alias'];
	}
	$insert_sql_array = array(
	    'token'=>$token,
	    'token_alias'=>$token_alias,
	    'date_added'=>'now()'
	);
	xtc_db_perform('yes_xmlrpc_token',$insert_sql_array);
	$messageStack->add_session('Ein neuer YES XMLRPC Token wurde angelegt.','success');
	xtc_redirect(xtc_href_link('module_export.php',xtc_get_all_get_params(array('action')).'action=edit'));
	break;
}
if(isset($_GET['action']) and $_GET['action'] == 'yes_xmlrpc_token'){
    $token = array();
    $yes_xmlrpc_token_query = xtc_db_query(
	    "SELECT * FROM yes_xmlrpc_token ORDER BY date_added"
    );
    while($yes_xmlrpc_token = xtc_db_fetch_array($yes_xmlrpc_token_query)){
	if($yes_xmlrpc_token['allowed_functions'] != '')
	    $yes_xmlrpc_token['funcs'] = str_replace(';',', ',$yes_xmlrpc_token['allowed_functions']);
	$token[] = $yes_xmlrpc_token;
    }
    $basics = new basics;
    $new_token = $basics->generate_password(16).$basics->generate_password(16);
    
    header('Content-Type: text/html; charset='.CHARSET);
    $smarty->assign(array(
	'MODULE_EXPORT_YES_XMLRPC_REALLY_DELETE_TOKEN'=>MODULE_EXPORT_YES_XMLRPC_REALLY_DELETE_TOKEN,
	'FORM_END'=>'</form>',
	'ADD_FORM'=>xtc_draw_form('yes_xmlrpc_token_add','module_export.php',xtc_get_all_get_params(array('action')).'action=yes_xmlrpc_token_add'),
	'TOKEN_ARRAY'=>$token,
	'MODULE_EXPORT_YES_XMLRPC_NO_TOKEN_SAVED'=>MODULE_EXPORT_YES_XMLRPC_NO_TOKEN_SAVED,
	'IMAGE_DELETE'=>IMAGE_DELETE,
	'TOKEN_ITEM_BASELINK'=>xtc_href_link('module_export.php',xtc_get_all_get_params(array('action','id')).'action=yes_xmlrpc_token_delete'),
	'INPUT_NEW_TOKEN'=> xtc_draw_input_field('token',$new_token,'maxlength="32" size="32" id="token"',true,'text',false),
	'MODULE_EXPORT_YES_XMLRPC_NEW_TOKEN_TITLE'=>MODULE_EXPORT_YES_XMLRPC_NEW_TOKEN_TITLE,
	'INPUT_NEW_TOKEN_ALIAS'=>xtc_draw_input_field('token_alias','','maxlength="32" size="32" id="token_alias"'),
	'MODULE_EXPORT_YES_XMLRPC_NEW_TOKEN_ALIAS'=>MODULE_EXPORT_YES_XMLRPC_NEW_TOKEN_ALIAS,
	'MODULE_EXPORT_YES_XMLRPC_NEW_TOKEN_INTRO'=>MODULE_EXPORT_YES_XMLRPC_NEW_TOKEN_INTRO,
	'MODULE_EXPORT_YES_XMLRPC_FUNCTIONS'=>MODULE_EXPORT_YES_XMLRPC_FUNCTIONS,
	'MODULE_EXPORT_YES_XMLRPC_ALLOWED_FUNCTIONS_TEXT'=>MODULE_EXPORT_YES_XMLRPC_ALLOWED_FUNCTIONS_TEXT
    ));
    $smarty->display('module_export_yes_xmlrpc_token.html');
    exit;
}
if(isset($_GET['action']) and $_GET['action'] == 'get_groups'){
		$groups_array = array(
			0=>array('id'=>'ALL','text'=>MODULE_EXPORT_SELECT_ALL_GROUPS)
		);
		$groups_query = xtc_db_query("SELECT * FROM `groups` ORDER BY groups_title");
		while($group = xtc_db_fetch_array($groups_query)){
			$groups_array[] = array('id'=>$group['groups_id'],'text'=>xtc_db_prepare_input($group['groups_title']));
		}
		if(isset($_GET['groups_id']) and $_GET['groups_id'] > 0){
			$gID = (int)xtc_db_input($_GET['groups_id']);
			$characters = array();
			$chars_query = xtc_db_query("SELECT products_characteristic_id FROM products_characteristic WHERE groups_id='".$gID."'");
			while($chars = xtc_db_fetch_array($chars_query)){
				$C = new products_characteristic($chars['products_characteristic_id']);
				if(sizeOf($C->get_characteristic_sets())>0){
					$sets = array(0=>array('id'=>'ALL','text'=>MODULE_EXPORT_SELECT_ALL_SETS));
					foreach($C->get_characteristic_sets() as $k=>$SET){
						$sets[] = array('id'=>$SET->get_products_characteristic_set_id(),'text'=>$SET->get_title());
					}
					$characters[] = array('select'=>xtc_draw_pull_down_menu('set_'.$C->get_products_characteristic_id(),$sets),'title'=>$C->get_title());
				}
			}
		}
		header('Content-Type: text/html; charset='.CHARSET);
		echo '<div style="width:100%;"></div>';
		echo constant('TEXT_PRODUCT_GROUPS').'&nbsp;';
		echo xtc_draw_pull_down_menu('groups_id',$groups_array,((isset($_GET['groups_id']))?$_GET['groups_id']:''),'onchange="preselect_group();"');
		if(isset($characters) and sizeOf($characters)>0){
			foreach( $characters as $k=>$v ){
				printf('<br />&nbsp;%s&nbsp;%s:<br />%s',
					constant('TEXT_PRODUCT_GROUP_SET'),$v['title'],$v['select']
				);
			}
		}else{
			if(isset($_GET['groups_id']) and $_GET['groups_id']>0)
				printf('<br />%s',constant('MODULE_EXPORT_NO_SETS'));
		}
		echo '</div>';
		exit;
}

$module_type = 'export';
$module_directory = DIR_WS_MODULES . 'export/';
$module_key = 'MODULE_EXPORT_INSTALLED';
$file_extension = '.php';
define('HEADING_TITLE', HEADING_TITLE_MODULES_EXPORT);
if (isset($_GET['error'])) {
	$map='error';
	if ($_GET['kind']=='success') $map='success';
	$messageStack->add($_GET['error'], $map);
}

switch ($action) {
    case 'save_stepwise':
	    $page = (isset($_REQUEST['page'])) ? (int)xtc_db_input($_REQUEST['page']) : 0;
	    $class = basename( str_replace('../','',xtc_db_input($_GET['module'])));
	
	    $tmp_directory = \main::get_exportdata_path().'module_exports/';
	    if(!is_dir($tmp_directory)){
	        mkdir($tmp_directory);
	    }
	    $tmp_directory .= $class;
	    $basics = new basics;
	    if($page == 0 and !isset($_REQUEST['download'])){
	        if (is_countable($_REQUEST['configuration']) and sizeOf($_REQUEST['configuration'])) {
                foreach($_REQUEST['configuration'] as $key => $value) {
                    \main::update_configuration_value($key, $value);
                    if (strstr($key,'FILE')) {
                        $file=$value;
                    }
                }
            }
            if(is_dir($tmp_directory)){
                $basics->rmdir($tmp_directory);
            }
            mkdir($tmp_directory);
	    }
        include($module_directory . $class . $file_extension);
        $module = new $class;
        $max_items_per_step = $module->max_items_per_step;
        $module->tmp_directory = $tmp_directory;
        if(!isset($file)){
            $file = '';
        }
	
        if(isset($_REQUEST['download']) and $_REQUEST['download'] == '1'){
            $module->process_header();
            $files = $basics->get_directory_content($module->tmp_directory.'/');
            if(property_exists($class,'save_as_name') and $module->save_as_name != ''){
                $filename = $module->save_as_name;
            }else{
                if(defined('MODULE_'.strtoupper($class).'_FILE')){
                    $filename = constant('MODULE_'.strtoupper($class).'_FILE');
                }else{
                    $filename = $class.'.csv';
                }
            }
            $bigfile = $module->tmp_directory.'/'.$filename;
            if(!sizeOf($files)){
                $messageStack->add_session('no data for module '.$class,'error');
                xtc_redirect(xtc_href_link(FILENAME_MODULE_EXPORT));
            }
            $content = '';
            sort($files);
            $fp = fopen($bigfile, 'w');
            foreach($files as $file){
                $content = file_get_contents($module->tmp_directory.'/'.$file);
                fwrite($fp, $content);
                unlink($module->tmp_directory.'/'.$file);
            }
            fclose($fp);
            $filepath = \main::get_exportdata_path();
            $basics->zip_file($filepath,$bigfile,$filename.'.zip',true,true);
            unlink($bigfile);
            $file_contents = $basics->read_file_content($filepath.$filename.'.zip',$mode='rb');
            unlink($filepath.$filename.'.zip');
            // send File to Browser
            $file = $filename.'_'.date('Y-m-d_H_i_s').'.zip';
            header('Content-Type: application/octet-stream');
            header('Content-Transfer-Encoding: binary');
            header('Content-disposition: attachment; filename=' . $file);
            echo $file_contents;
            exit;
        }
        
        $total_number_of_items = $module->get_total_number_of_items();
        $modulo = $total_number_of_items % $max_items_per_step;
        $steps = ($total_number_of_items-$modulo) / $max_items_per_step;
        if($modulo > 0){
            $steps++;
        }
        $module->process_page($page,$max_items_per_step);
        
        printf("<p><b>%s</b></p>",sprintf(TEXT_WORK_IN_PROCESS_EXPORT,$_REQUEST['module']));
        printf(TEXT_WORK_IN_PROCESS_STEPS,
            $total_number_of_items,
            $steps
        );
        printf('
            <script type="text/javascript">
            var steps = %s;
            var page = %s;
            $().ready(function(){
                $(\'#module_export_download_button\').click(function(){
                    window.location.href = $(\'form[name="MODULE_EXPORT_STEPWISE_FORM"]\').attr(\'action\')+\'&download=1\';
                    $(\'#module_export_download_button\').prop(\'disabled\',true);
                });
                $(\'#MODULE_EXPORT_STEPWISE_BUTTON\').click(function(){
                    $(this).prop(\'disabled\',true);
                    $(\'#MODULE_EXPORT_PAGING_DIV\').html(\'<div align="center"><img src="images/loading.gif" border="0" /></div>\');
                    $.ajax({
                        url: $(\'form[name="MODULE_EXPORT_STEPWISE_FORM"]\').attr(\'action\')+\'&page=\'+page,
                    }).done(function(response){
                        page++;
                        $(\'#MODULE_EXPORT_PAGING_DIV\').html(\'Schritt \'+page+\' / \'+steps);
                        if( page == steps){
                            $(\'#module_export_download_button\').prop(\'disabled\',false);
                            $(\'#module_export_download_button\').click(function(){
                                window.location.href = $(\'form[name="MODULE_EXPORT_STEPWISE_FORM"]\').attr(\'action\')+\'&download=1\';
                                $(\'#module_export_download_button\').prop(\'disabled\',true);
                            });
                        }else{
                            $(\'#MODULE_EXPORT_STEPWISE_BUTTON\').prop(\'disabled\',false);
                        }
                    });
                });
            });
            </script>
            <p><div id="MODULE_EXPORT_PAGING_DIV">
            %s %s / %s
            </div></p>
        ',$steps,($page+1),TEXT_WORK_IN_PROCESS_STEP,($page+1),$steps);
        echo xtc_draw_form('MODULE_EXPORT_STEPWISE_FORM',FILENAME_MODULE_EXPORT,xtc_get_all_get_params(array('page')));
        if($steps > 1){
                printf('<input id="MODULE_EXPORT_STEPWISE_BUTTON" type="button" class="ui-button ui-corner-all ui-state-default" value="%s" />',
                        TEXT_WORK_IN_PROCESS_CONTINUE
                );
        }
        echo '</form>';
        echo '<br /><input class="ui-button ui-corner-all ui-state-default" type="button" id="module_export_download_button" value="Download Export" ';
        if($steps > 1){
            echo 'disabled="disabled"';
        }
        echo ' />';
        //$module->process($file);
        
        
        exit;
        break;
    case 'save':
        if (is_array($_REQUEST['configuration'])) {
            if (is_countable($_REQUEST['configuration'])) {
                // php8 bugfix
                //while (list($key, $value) = each($_REQUEST['configuration'])) {
                
                foreach($_REQUEST['configuration'] as $key => $value ) {
                	if(is_int($key)){
                		continue;
                	}
                    main::update_configuration_value($key, $value);
                    if (strstr($key,'FILE')) {
                        $file=$value;
                    }
                }
            }
        }
      $class = basename($_REQUEST['module']);
      include($module_directory . $class . $file_extension);

      $module = new $class;
	  if(!isset($file))
		  $file = '';
      $module->process($file);
      $messageStack->add_session('Export wurde ausgef&uuml;hrt.','success');
      xtc_redirect(xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=' . $class));
      break;

    case 'install':
    case 'remove':
      $file_extension = substr($_SERVER['PHP_SELF'], strrpos($_SERVER['PHP_SELF'], '.'));
      $class = basename($_GET['module']);
      if (file_exists($module_directory . $class . $file_extension)) {
        include($module_directory . $class . $file_extension);
        $module = new $class;
        if ($_GET['action'] == 'install') {
          $module->install();
        } elseif ($_GET['action'] == 'remove') {
          $module->remove();
        }
      }
      $InstanceCache->deleteItem('configuration');
      xtc_redirect(xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=' . $class));
      break;
}
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<link rel="stylesheet" type="text/css" href="includes/javascript/spiffyCal/spiffyCal_v2_1.css">
<script type="text/javascript" src="includes/javascript/spiffyCal/spiffyCal_v2_1.js"></script>
<!-- header //-->
<?php 
if(defined('YES_PAYMODULE_CRON_EXPORT_CONFIG') and YES_PAYMODULE_CRON_EXPORT_CONFIG == 'True'){
    $buttons = array(
        array('text'=>BUTTON_CRON_EXPORT_CONFIG,
            'link'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action')).'action=cron_export_config'),
            'lbOn'=>false,
            'auth'=>true,
        ),
    );
}
$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE_MODULES_EXPORT,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons
));
$smarty->display('module_export.html');
?>

<!-- body //-->
<div id="spiffycalendar" class="text"></div>

<table border="0" width="100%" cellspacing="2" cellpadding="0">
<tr>
	<td valign="top" class="ui-widget-content">
		<table class="yes-ui-table">
			<thead>
				<tr class="ui-widget-header">
					<th><?php echo TABLE_HEADING_MODULES; ?></th>
					<th align="right"><?php echo TABLE_HEADING_ACTION; ?></th>
				</tr>
			</thead>
			<tbody>
<?php
  $file_extension = substr($_SERVER['PHP_SELF'], strrpos($_SERVER['PHP_SELF'], '.'));
  $directory_array = array();
  if ($dir = @dir($module_directory)) {
    while ($file = $dir->read()) {
      if (!is_dir($module_directory . $file)) {
        if (substr($file, strrpos($file, '.')) == $file_extension) {
          $directory_array[] = $file;
        }
      }
    }
    sort($directory_array);
    $dir->close();
  }

  $installed_modules = array();
  for ($i = 0, $n = sizeof($directory_array); $i < $n; $i++) {
    $file = $directory_array[$i];

 //   include(DIR_FS_LANGUAGES . $_SESSION['language'] . '/modules/' . $module_type . '/' . $file);
    include($module_directory . $file);

    $class = substr($file, 0, strrpos($file, '.'));
    if (xtc_class_exists($class)) {
      $module = new $class;
      if ($module->check() > 0) {
        if ($module->sort_order > 0) {
          $installed_modules[$module->sort_order] = $file;
        } else {
          $installed_modules[] = $file;
        }
      }

      if (((!isset($_GET['module'])) || ($_GET['module'] == $class)) && (!isset($mInfo))) {
        $module_info = array('code' => $module->code,
                             'title' => $module->title,
                             'description' => $module->description,
                             'status' => $module->check());

        $module_keys = $module->keys();
        $keys_extra = array();
        for ($j = 0, $k = sizeof($module_keys); $j < $k; $j++) {
          $key_value_query = xtc_db_query("select configuration_key,configuration_value, use_function, set_function from " . TABLE_CONFIGURATION . " where configuration_key = '" . $module_keys[$j] . "'");
          $key_value = xtc_db_fetch_array($key_value_query);
          if ($key_value['configuration_key'] !='')  
	      $keys_extra[$module_keys[$j]]['title'] = constant(strtoupper($key_value['configuration_key'] .'_TITLE'));
          $keys_extra[$module_keys[$j]]['value'] = $key_value['configuration_value'];
          if ($key_value['configuration_key'] !='')  
	      $keys_extra[$module_keys[$j]]['description'] = constant(strtoupper($key_value['configuration_key'] .'_DESC'));
          $keys_extra[$module_keys[$j]]['use_function'] = $key_value['use_function'];
          $keys_extra[$module_keys[$j]]['set_function'] = $key_value['set_function'];
        }

        $module_info['keys'] = $keys_extra;

        $mInfo = new objectInfo($module_info);
      }

      if ( (isset($mInfo) and is_object($mInfo)) && ($class == $mInfo->code) ) {
        if ($module->check() > 0) {
          echo '              <tr onmouseover="this.style.cursor=\'hand\'" onclick="document.location.href=\'' . xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . ((isset($_GET['set']))?$_GET['set']:'') . '&module=' . $class . '&action=edit') . '\'" class="ui-state-highlight">' . "\n";
        } else {
          echo '              <tr>' . "\n";
        }
      } else {
        echo '              <tr onmouseover="this.style.cursor=\'hand\'" onclick="document.location.href=\'' . xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . ((isset($_GET['set']))?$_GET['set']:'') . '&module=' . $class) . '\'">' . "\n";
      }
?>
                <td><?php echo $module->title; ?></td>
                <td align="right"><?php if ( (isset($mInfo) and is_object($mInfo)) && ($class == $mInfo->code) ) { echo xtc_image(DIR_WS_IMAGES . 'icon_arrow_right.gif'); } else { echo '<a href="' . xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . ((isset($_GET['set']))?$_GET['set']:'') . '&module=' . $class) . '">' . xtc_image(DIR_WS_IMAGES . 'icon_info.gif', IMAGE_ICON_INFO) . '</a>'; } ?>&nbsp;</td>
              </tr>
<?php
    }
  }

  ksort($installed_modules);
  if(main::configuration_key_exists($module_key)){
    $cv = main::get_configuration_value($module_key);
    if ($cv != implode(';', $installed_modules)) {
        main::update_configuration_value($module_key, implode(';', $installed_modules));
    }
  } else {
      main::add_configuration([
          'configuration_key'=>$module_key, 
          'configuration_value'=>implode(';', $installed_modules), 
          'configuration_group_id'=>6, 
          'sort_order'=>0, 
      ]);
  }
?>
			</tbody>
            </table></td>
<?php
$heading = array();
$contents = array();
$action = (isset($_GET['action'])) ? $_GET['action'] : '';
switch ($action) {
    case 'edit':
      $keys = '';
      reset($mInfo->keys);
      // php8 bugfix
      //while (list($key, $value) = each($mInfo->keys)) {
      foreach($mInfo->keys as $key => $value) {
	 // if($value['description']!='_DESC' && $value['title']!='_TITLE'){ 
        $keys .= '<b id="title">' . $value['title'] . '</b><br />' .  $value['description'].'<br />';
	//	}
        if ($value['set_function']) {
          eval('$keys .= ' . $value['set_function'] . "'" . $value['value'] . "', '" . $key . "');");
        } else {
	    switch($key){
		case 'MODULE_BILLIGER_PROMO_TEXT':
		case 'MODULE_YATEGO					_PROMO_TEXT':
	    $keys .= '<script type="text/javascript">'.
	    '$().ready(function(){'.
	    '	$("textarea[name=\'configuration[' . $key . ']\']").bind("input propertychange", function() {'.
	    '	    $("#conf_ta_count").text("Zeichen: " + $(this).val().length);'.
	    '	});'.

	    '});'.
	    '</script>';
		    $keys .= xtc_draw_textarea_field('configuration[' . $key . ']','virtual',25,4, $value['value']);
		    $keys .= '<div style="color: #666;" id="conf_ta_count">Zeichen: '.strlen($value['value']).'</div><br />';
		    break;
		default:
		    $keys .= xtc_draw_input_field('configuration[' . $key . ']', $value['value']);
		    break;
	    }
        }
        $keys .= '<br><br>';
      }
      $keys = substr($keys, 0, strrpos($keys, '<br><br>'));

      $heading[] = array('text' => '<b>' . $mInfo->title . '</b>');
      $class = substr($file, 0, strrpos($file, '.'));
      $module = new $_GET['module'];
      $contents = array('form' => xtc_draw_form('modules', FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=' . $_GET['module'] . '&action=save','post','enctype="multipart/form-data"'));
      $contents[] = array('text' => $keys);
      // display module fields
      $contents[] = $module->display();

      break;

    default:
	$heading[] = array('text' => '<b>' . $mInfo->title . '</b>');
      if ($mInfo->status == '1') {
        $keys = '';
        reset($mInfo->keys);
        // php8 bugfix
        //while (list(, $value) = each($mInfo->keys)) {
        foreach($mInfo->keys as $egal => $value ) {
          $keys .= '<b>' . $value['title'] . '</b><br>';
          if ($value['use_function']) {
            $use_function = $value['use_function'];
            if (ereg('->', $use_function)) {
              $class_method = explode('->', $use_function);
              if (!is_object(${$class_method[0]})) {
                include(DIR_WS_CLASSES . $class_method[0] . '.php');
                ${$class_method[0]} = new $class_method[0]();
              }
              $keys .= xtc_call_function($class_method[1], $value['value'], ${$class_method[0]});
            } else {
              $keys .= xtc_call_function($use_function, $value['value']);
            }
          } else {
		  if(strlen($value['value']) > 30) {
		  $keys .=  substr($value['value'],0,30) . ' ...';
		  } else {
            $keys .=  $value['value'];
			}
          }
          $keys .= '<br><br>';
        }
        $keys = substr($keys, 0, strrpos($keys, '<br /><br />'));
        //$contents[] = array('align' => 'center', 'text' => '<a href="' . xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . ((isset($_GET['set']))?$_GET['set']:'') . '&module=' . $mInfo->code . '&action=remove') . '">' . xtc_image_button('button_module_remove.gif', IMAGE_MODULE_REMOVE) . '</a>');
        $contents[] = array('align' => 'center', 'text' => yes_draw_href_button(IMAGE_MODULE_REMOVE, xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . ((isset($_GET['set']))?$_GET['set']:'') . '&module=' . $mInfo->code . '&action=remove'), 'width:140px;'));
	
	//$contents[] = array('align'=>'center','text'=>'<a href="' . xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . ((isset($_GET['set']))?$_GET['set']:'') . '&module=' . $mInfo->code . '&action=edit') . '">' . xtc_image_button('button_start.gif', IMAGE_START) . '</a>');
	$contents[] = array('align'=>'center','text'=>yes_draw_href_button(IMAGE_START,xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . ((isset($_GET['set']))?$_GET['set']:'') . '&module=' . $mInfo->code . '&action=edit'),'width:140px;'));
        $contents[] = array('text' => '<br />' . $mInfo->description);
        $contents[] = array('text' => '<br />' . $keys);
      } else {
        $contents[] = array('align' => 'center', 'text' => yes_draw_href_button(IMAGE_MODULE_INSTALL,xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . ((isset($_GET['set']))?$_GET['set']:'') . '&module=' . $mInfo->code . '&action=install')));
        $contents[] = array('text' => '<br />' . $mInfo->description);
      }
      break;
  }

  if ( (xtc_not_null($heading)) && (xtc_not_null($contents)) ) {
    echo '            <td width="25%" valign="top" class="ui-widget-content">' . "\n";

    $box = new box;
    echo $box->infoBox($heading, $contents);

    echo '            </td>' . "\n";
  }
?>
      </tr>
    </table></td>
<!-- body_text_eof //-->
  </tr>
</table>
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
