<?php
/* --------------------------------------------------------------
   $Id: new_product.php,v 1.206 2020/09/07 07:12:47 ssh-511548-cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(categories.php,v 1.140 2003/03/24); www.oscommerce.com
   (c) 2003  nextcommerce (categories.php,v 1.37 2003/08/18); www.nextcommerce.org

   Released under the GNU General Public License
   --------------------------------------------------------------
   Third Party contribution:
   Enable_Disable_Categories 1.3               Autor: Mikel Williams | mikel@ladykatcostumes.com
   New Attribute Manager v4b                   Autor: Mike G | mp3man@internetwork.net | http://downloads.ephing.com
   Category Descriptions (Version: 1.5 MS2)    Original Author:   Brian Lowe <blowe@wpcusrgrp.org> | Editor: Lord Illicious <shaolin-venoms@illicious.net>
   Customers Status v3.x  (c) 2002-2003 Copyright Elari elari@free.fr | www.unlockgsm.com/dload-osc/ | CVS : http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/elari/?sortby=date#dirlist

   Released under the GNU General Public License
   --------------------------------------------------------------*/
if(\main::isDev(true)){
	define('YES_PAYMODULE_PRODUCT_UN','True');
}
if ( ($_GET['pID']) && (!$_POST) ) {

      $product_query = xtc_db_query("select p.products_fsk18,
					    p.products_meldebestand,
						p.meldebestand_active,
                                            p.product_template,
                                            p.options_template,
                                            p.characteristics_template,
                                            pd.products_name,
					    pd.slave_title,
                                            p.products_ean,
                                            pd.products_description,
                                            pd.ebay_title,
                                            pd.amazon_title,
                                            pd.products_short_description,
                                            pd.products_meta_title,
                                            pd.products_meta_description,
                                            pd.products_meta_keywords,
                                            pd.products_url,
					    p.products_conditions_id,
					    p.mpn,
                                            p.products_id,
                                            p.group_ids,
                                            p.products_sort,
                                            p.products_shippingtime,
                                            p.products_quantity,
                                            p.products_model,
                                            p.products_image,
                                            p.products_price,
                                            p.products_discount_allowed,
                                            p.products_weight,
                                            p.products_weight_netto,
					    p.ebay_template,
                                            p.adma,
					    p.comments,
                                            p.storage_comments,
                                            p.products_date_added,
                                            p.products_last_modified,
                                            date_format(p.products_date_available, '%Y-%m-%d') as products_date_available,
                                            p.products_status,
                                            p.default_storage,
					    p.colli_id,
					    p.size_width,
					    p.size_height,
					    p.size_depth,
						p.units_id,
						p.products_master,
						p.products_master_status,
						p.products_listing_status,
						p.products_startpage,
						p.products_startpage_sort,
						p.ext_additionalcosts,
						p.shipping_extra_charge,
						p.price_fixing,
						p.manufacturers_id,
						p.products_vpe,p.products_vpe_status,p.products_vpe_value,p.products_vpe_base_measure,
                                                p.default_category,
						pd.amazon_flatfile,
						pd.amazon_browse_node_id,
						pd.products_description_amazon,
						p.packaging_costs,
						p.uvp,
						p.amazon_fulfillmentlatency,
						p.amazon_revise,
						p.amazon_revise_qty,
						p.packagings_id,
						p.disable_cron_update_products_status,
                                                p.no_yatego_export,
                                                p.no_google_product_feed_export,
                                                p.zollwarennummer,
                                                p.ebay_ProductReferenceID,
                                                p.cron_cancel_auctions_exclude,
                                                p.cron_cancel_auctions_max_quantity 
						from " . TABLE_PRODUCTS . " p LEFT JOIN " . TABLE_PRODUCTS_DESCRIPTION . " pd
						using(products_id) where p.products_id = '" . (int)xtc_db_input($_GET['pID']) . "'
						and pd.language_id = '" . $_SESSION['languages_id'] . "'");

      $product = xtc_db_fetch_array($product_query);

      if(is_array($product) and sizeOf($product) > 0){
      	$pInfo = new objectInfo($product);
      }else{
	  echo '<br /><div class="main">';
	  printf(MSG_ERROR_PRODUCT_NOT_EXISTS,$_REQUEST['pID']);
	  printf('<p><a href="%s">%s</a></p></div>',xtc_href_link(FILENAME_CATEGORIES),IMAGE_BACK);
	  exit;
      }
      

} elseif ($_POST) { // END IF GET[pid]
    $products_name = $_POST['products_name'];
    $slave_title = $_POST['slave_title'];
    $ebay_title = $_POST['ebay_title'];
    $amazon_title = $_POST['amazon_title'];
    $products_description = $_POST['products_description'];
    $products_short_description = $_POST['products_short_description'];
    $products_meta_title = $_POST['products_meta_title'];
    $products_meta_description = $_POST['products_meta_description'];
    $products_meta_keywords = $_POST['products_meta_keywords'];
    $products_url = $_POST['products_url'];
    $ebay_template = $_POST['ebay_template'];
} else {
      $pInfo = new objectInfo(array());
}
require_once(DIR_FS_CATALOG.'includes/classes/xtcPrice.php');
$xtPrice = new xtcPrice($_SESSION['currency'],1); // GUEST

$pInfo->comments_formatted = nl2br(xtc_db_prepare_input($pInfo->comments));
$pInfo->storage_comments_formatted = nl2br(xtc_db_prepare_input($pInfo->storage_comments));

// BOF - default_category
$allocated_categories_array = array(array('id'=>0,'text'=>TEXT_SELECT));
$allocated_categories_query = xtc_db_query(sprintf(
    "SELECT categories_id FROM products_to_categories WHERE products_id='%s' AND categories_id > 0",
    $pInfo->products_id
));
if(xtc_db_num_rows($allocated_categories_query)){
    while($allocated_categories = xtc_db_fetch_array($allocated_categories_query)){
        $category_path = array();
        foreach(explode('_',xtc_get_category_path($allocated_categories['categories_id'])) as $catID){
            $category_path[] = xtc_get_categories_name($catID);
        }
        
                
        $allocated_categories_array[] = array(
            'id'=>$allocated_categories['categories_id'],
            'text'=>$allocated_categories['categories_id'].' | '.xtc_db_prepare_input(implode(' / ',$category_path))
        );
    }
}
$pInfo->input_default_category = xtc_draw_pull_down_menu('default_category',$allocated_categories_array,$pInfo->default_category);
// EOF - default_category

$fsk18_array=array(array('id'=>0,'text'=>NO),array('id'=>1,'text'=>YES));
   
$manufacturers_array = array(array('id' => '', 'text' => TEXT_NONE));
$manufacturers_query = xtc_db_query("select manufacturers_id, manufacturers_name from " . TABLE_MANUFACTURERS . " order by manufacturers_name");
while ($manufacturers = xtc_db_fetch_array($manufacturers_query)) {
	$manufacturers_array[] = array('id' => $manufacturers['manufacturers_id'],
		'text' => $manufacturers['manufacturers_name']);
}

$units_array = array( array( 'id' => '', 'text' => TEXT_NONE ) );
$units_query = xtc_db_query("SELECT u.* FROM units u ORDER BY units_title");
while ($units = xtc_db_fetch_array($units_query)) {
	$units_array[] = array('id'=>$units['units_id'],'text'=>xtc_db_prepare_input($units['units_title']));
}
$pInfo->units_array = $units_array;

$products_storages_array = array(array('id' => '', 'text' => TEXT_NONE));
$products_storages_query = xtc_db_query("SELECT * FROM storages");
while($products_storages = xtc_db_fetch_array($products_storages_query)){
	$products_storages_array[] = array('id' => $products_storages['id'],
		'text'=>$products_storages['name']);
}
$pInfo->products_storages_array = $products_storages_array;

$products_distributors_array = array(array('id' => '', 'text' => TEXT_NONE));
$products_distributors_query = xtc_db_query("SELECT * FROM distributors");
while($products_distributors = xtc_db_fetch_array($products_distributors_query)){
		$products_distributors_array[] = array('id' => $products_distributors['id'],
										   'text'=>$products_distributors['name']);
}
$pInfo->products_distributors_array = $products_distributors_array;
$tax_class_array = array(array('id' => '0', 'text' => TEXT_NONE));
$tax_class_query = xtc_db_query("select tax_class_id, tax_class_title from " . TABLE_TAX_CLASS . " order by tax_class_title");
while ($tax_class = xtc_db_fetch_array($tax_class_query)) {
	$tax_class_array[] = array('id' => $tax_class['tax_class_id'],
		'text' => $tax_class['tax_class_title']);
}
$shipping_statuses = array();
$shipping_statuses=xtc_get_shipping_status();

$pInfo->shipping_statuses = $shipping_statuses;

$languages = xtc_get_languages();

if(!isset($pInfo->products_shippingtime)){
	$pInfo->products_shippingtime = (int)DEFAULT_SHIPPING_STATUS_ID;
}
	
//MASTER/SLAVE
if (!isset($pInfo->products_listing_status)) 
	$pInfo->products_listing_status = '1';

switch ($pInfo->products_listing_status) {
	case '0': 
		$in_listing_status = false; 
		$out_listing_status = true; 
		break;
	case '1':
	default: 
		$in_listing_status = true; 
		$out_listing_status = false;
		break;
}

if (!isset($pInfo->products_master_status)) {
	$pInfo->products_master_status = '1';
}
switch ($pInfo->products_master_status) {
	case '0': 
		$in_master_status = false; 
		$out_master_status = true; 
		break;
	case '1':
	default: 
		$in_master_status = true; 
		$out_master_status = false;
		break;
}     
// MASTER/SLAVE END
    
switch ($pInfo->products_status) {
	case '0':
		$status = false; 
		$out_status = true; 
		break;
	case '1':
	default: 
		$status = true; 
		$out_status = false;
		break;
}

if(COLLI_ACTIVE){
	$collies = xtc_get_product_collies( $pInfo->products_id );
	$pInfo->add_collie_icon = xtc_image('images/plus.gif');
	$in_collies = xtc_get_product_in_collies( $pInfo->products_id );
	for($ic=0;$ic<sizeOf($in_collies);$ic++){
		$in_collies[$ic]['name'] = xtc_get_products_name($in_collies[$ic]['products_id']);
		$in_collies[$ic]['edit_link'] = xtc_href_link('categories.php','cPath='.xtc_get_product_path($in_collies[$ic]['products_id']).'&pID='.$in_collies[$ic]['products_id'].'&action=new_product');
	}
	$pInfo->in_collies = $in_collies;
	$pInfo->in_collies_num = sizeOf($pInfo->in_collies);
	$pInfo->collies_num = sizeOf($collies);
	$pInfo->collies_edit_link = xtc_href_link('product_collies.php','pID='.$pInfo->products_id);
	if(sizeOf($collies)>0){
		for($ic=0;$ic<sizeOf($collies);$ic++){
			$collies[$ic]['weight'] = xtc_get_ext_products_weight($collies[$ic]['collie_products_id']);
			$collies[$ic]['formated_weight'] = number_format($collies[$ic]['weight'],4,',','');
			$collies[$ic]['name'] = xtc_get_products_name($collies[$ic]['collie_products_id']);
			$collies[$ic]['weight_netto'] = xtc_get_ext_products_weight_netto($collies[$ic]['collie_products_id']);
			$collies[$ic]['formated_weight_netto'] = number_format($collies[$ic]['weight_netto'],4,',','');
		}
		$pInfo->products_weight = xtc_get_ext_products_weight($pInfo->products_id);
		//$pInfo->products_weight_netto = xtc_get_ext_products_weight($pInfo->products_id);
		$pInfo->collies = $collies;
		if(xtc_is_preisbindung($pInfo->products_id)){
                    $preisbindung = xtc_get_preisbindung_value($pInfo->products_id,1,$xtPrice);
                    if (PRICE_IS_BRUTTO!='true'){
                        $tax_rate = xtc_get_product_collies_tax_value($collies, STORE_COUNTRY, 0);
                        $preisbindung = $preisbindung/(($tax_rate+100)/100);
                    }
                    $pInfo->preisbindung = $preisbindung;
                    $pInfo->preisbindung_formated = number_format($preisbindung,2,',','');
		}
	}
}
$pInfo->qty_hidden = xtc_draw_hidden_field('orig_qty',$pInfo->products_quantity);
$SQ = new products_quantity($pInfo->products_id);

$smarty = new yesSmarty;
$packagings_array = array(array('id'=>'','text'=>TEXT_SELECT));
$packagings_query = xtc_db_query(
	"SELECT packagings_id, title,weight FROM packagings ORDER BY title"
);
while($packagings = xtc_db_fetch_array($packagings_query)){
    $packagings_array[] = array(
	'id'=>$packagings['packagings_id'],
	'text'=>sprintf('%s (%s kg)',$packagings['title'],number_format($packagings['weight'],4,',','.'))
    );
}
$smarty->assign(array(
    'qty_available1'=>$SQ->get_available1_qty(),
    'qty_available2'=>$SQ->get_available2_qty(),
    'TEXT_AMAZON_FLATFILE'=>TEXT_AMAZON_FLATFILE,
    'TEXT_AMAZON_BROWSE_NODE_ID'=>TEXT_AMAZON_BROWSE_NODE_ID,
    'TEXT_PRODUCTS_DESCRIPTION_AMAZON'=>TEXT_PRODUCTS_DESCRIPTION_AMAZON,
    'JS_CONFIRM_ACTIVATE_PRODUCTS_LISTING_STATUS'=>JS_CONFIRM_ACTIVATE_PRODUCTS_LISTING_STATUS,
    'TEXT_AMAZON_REVISE'=>TEXT_AMAZON_REVISE,
    'TEXT_AMAZON_REVISE_QTY'=>TEXT_AMAZON_REVISE_QTY,
    'TEXT_PACKAGING'=>TEXT_PACKAGING,
));


$smarty->assign('PRODUCTS_ID',$pInfo->products_id);
$smarty->assign('TEXT_PRODUCTS_STATUS',TEXT_PRODUCTS_STATUS);
$smarty->assign('TEXT_PRODUCT_AVAILABLE',TEXT_PRODUCT_AVAILABLE);
$smarty->assign('TEXT_PRODUCT_NOT_AVAILABLE',TEXT_PRODUCT_NOT_AVAILABLE);
$smarty->assign('TEXT_PRODUCTS_DATE_AVAILABLE',TEXT_PRODUCTS_DATE_AVAILABLE);
$smarty->assign('TEXT_PRODUCTS_WEIGHT',TEXT_PRODUCTS_WEIGHT);
$smarty->assign('TEXT_PRODUCTS_SORT',TEXT_PRODUCTS_SORT);
$smarty->assign('EXT_POPUP_WIDTH',EXT_POPUP_WIDTH);
$smarty->assign('EXT_POPUP_HEIGHT',EXT_POPUP_HEIGHT);
$smarty->assign('EDIT_IMAGE',xtc_image('images/icons/icon_edit.gif','Editieren'));
$mfs = ini_get('upload_max_filesize');
if(ini_get('post_max_size') < $mfs){
    $mfs = ini_get('post_max_size');
}
$smarty->assign('MAX_FILEUPLOAD_SIZE',$mfs);
$smarty->assign('SEPARATOR',xtc_draw_separator('pixel_black.gif'));
$smarty->assign('TEXT_PRODUCTS_MODEL',TEXT_PRODUCTS_MODEL);
$smarty->assign('TEXT_PRODUCTS_EAN',TEXT_PRODUCTS_EAN);
$smarty->assign('TEXT_PRODUCTS_MANUFACTURER',TEXT_PRODUCTS_MANUFACTURER);
$smarty->assign('BOX_SHIPPING_STATUS',BOX_SHIPPING_STATUS);
$smarty->assign('ACTIVATE_SHIPPING_STATUS',ACTIVATE_SHIPPING_STATUS);
$smarty->assign('TEXT_FSK18',TEXT_FSK18);
$smarty->assign('TEXT_CHOOSE_INFO_TEMPLATE',TEXT_CHOOSE_INFO_TEMPLATE);
$smarty->assign('STOCK_ALLOW_CHECKOUT',STOCK_ALLOW_CHECKOUT);
$smarty->assign('TEXT_META_TITLE', TEXT_META_TITLE);
$smarty->assign('TEXT_META_DESCRIPTION', TEXT_META_DESCRIPTION);
$smarty->assign('TEXT_META_KEYWORDS', TEXT_META_KEYWORDS);
$smarty->assign('HEADING_PRODUCT_OPTIONS', HEADING_PRODUCT_OPTIONS);
$smarty->assign('ENTRY_CUSTOMERS_STATUS', ENTRY_CUSTOMERS_STATUS);
$smarty->assign('TEXT_PRODUCTS_NAME',TEXT_PRODUCTS_NAME);
$smarty->assign('TEXT_SLAVE_TITLE',TEXT_SLAVE_TITLE);
$smarty->assign(array(
    'JS_ALERT_AUTH_PRODUCTS_SIZE'=>JS_ALERT_AUTH_PRODUCTS_SIZE,
    'TEXT_PRODUCTS_COMMENTS'=>TEXT_PRODUCTS_COMMENTS,
    'TEXT_SHIPPINGS_GRADUATION_HELP'=>TEXT_SHIPPINGS_GRADUATION_HELP,
    'TEXT_INTRO_REMOVE_ACTIVE_SHIPPINGCOSTS_MATRIX'=>TEXT_INTRO_REMOVE_ACTIVE_SHIPPINGCOSTS_MATRIX,
    'TEXT_CALC_FROM_COLLIES'=>TEXT_CALC_FROM_COLLIES, // "errechnet aus den collis"
    'BUTTON_NEW_STORAGE_NUMBER'=>BUTTON_NEW_STORAGE_NUMBER,
    'BUTTON_PRIORITY'=>BUTTON_PRIORITY
));    

$pp = yes_get_products_properties_id_array((int)xtc_db_input($_REQUEST['pID']));

$pInfo->master_icon = xtc_image('images/master.gif',TEXT_PRODUCT_IS_MASTER);
$pInfo->slave_icon = xtc_image('images/slave.gif',TEXT_PRODUCT_IS_SLAVE);
$pInfo->status = $status;
$pInfo->stat_link = xtc_href_link('categories.php',xtc_get_all_get_params(array('stat')).'stat=1');
$pInfo->volume = xtc_get_volumina($pInfo->products_id,4);
if(!property_exists($pInfo,'collies') or !is_countable($pInfo->collies) or !sizeOf($pInfo->collies)){
    $pInfo->input_packaging = xtc_draw_pull_down_menu('packagings_id',$packagings_array,$pInfo->packagings_id);
}

$groups = xtc_get_product_groups($pInfo->products_id);
if(is_countable($groups) and sizeOf($groups)>0){
    $gh = new \YES4Trade\Model\group_handler($_SESSION['languages_id']);
    $js_lang = 'var groups_languages = new Array(';
    $js_lang_allocation = array();
    for ($li = 0, $n = sizeof($languages); $li < $n; $li++) {
        $js_lang .= sprintf("'%s',",$languages[$li]['code']);
        $js_lang_allocation[] = 'groups_languages[\''.$languages[$li]['code'].'\'] = new Array(\''.$languages[$li]['id'].'\',\''.$languages[$li]['directory'].'\');';
    }
    $js_lang = substr($js_lang,0,strlen($js_lang)-1);
    $pInfo->groups_js_param_languages = $js_lang.');';
    $pInfo->groups_js_param_languages_allocations = $js_lang_allocation;

    foreach($groups as $k=>$group){
        foreach($gh->groups as $g){
            if($g['groups_id'] == $group['id']){
                $cgroup = $g;
            }
        }
            
            for($gi=0;$gi<sizeOf($cgroup['characteristics']);$gi++){
                $C = $cgroup['characteristics'][$gi];
                $groups[$k]['C'][$gi]['title'] = $C['description']['title'];
                $groups[$k]['C'][$gi]['id'] = $C['products_characteristic_id'];
                $groups[$k]['C'][$gi]['multiple'] = $C['multiple'];
		if(sizeOf($C['sets'])>0){
                    $groups[$k]['C'][$gi]['SETS'] = array();
                    $default_value = '';
                    $select_options = array(0=>array('id'=>'','text'=>TEXT_SELECT));
                    foreach($C['sets'] as $kc=>$SET){
                        $allocs = \YES4Trade\Model\groups_products_characteristics::get_by_products_id($pInfo->products_id);
                        foreach($allocs as $alloc){
                            if($alloc->products_characteristic_set_id == $SET['products_characteristic_set_id']){
                                $default_value = $SET['products_characteristic_set_id'];
                            }
                        }
                        $select_options[] = array(
                            'id'=>$SET['products_characteristic_set_id'],
                            'text'=>$SET['description']['title']
                        );
                    }
                    $groups[$k]['C'][$gi]['SETS'] = xtc_draw_pull_down_menu('cset_'.$C['products_characteristic_id'],$select_options,$default_value);
		}else{
                    if($C['no_sets'] > 0){
                        $groups[$k]['C'][$gi]['NOSETS'] = array();
                        // ERMITTELN WIEVIEL TEXT MULTIPLE WERTE GESPEICHERT SIND
                        $multi_from_db = false;
                        if($C['multiple'] == 1){
                                $pInfo->languages = $languages;
                                $pInfo->languages_num = sizeOf($languages);
                                $allocs = \YES4Trade\Model\groups_characteristic_text_values::get_by_characteristic_id_and_products_id($C['products_characteristic_id'], $pInfo->products_id, $_SESSION['languages_id']);
                                $text_content_count = sizeOf($allocs);
                                if($text_content_count>0){
                                        $groups[$k]['C'][$gi]['multiple_count'] = $text_content_count;
                                        $multi_from_db = true;
                                }else{
                                        $groups[$k]['C'][$gi]['multiple_count'] = 0;
                                }
                        }
			if($multi_from_db){
                            $allocs = \YES4Trade\Model\groups_characteristic_text_values::get_by_characteristic_id_and_products_id($C['products_characteristic_id'], $pInfo->products_id);
                            $tcounter = 0;
                            foreach($allocs as $alloc){
                                $input_name = 'ctext_'.$C['products_characteristic_id'].'[M'.$tcounter.']['.$alloc->language_id.']';
				for($li=0;$li<sizeOf($languages);$li++){
                                    if($languages[$li]['id'] == $alloc->language_id){
                                        $directory = $languages[$li]['directory'];
					$image = $languages[$li]['image'];
					$lang_name = $languages[$li]['name'];
                                    }
				}
				$groups[$k]['C'][$gi]['NOSETS'][] = array(
                                    'img'=>xtc_image(DIR_WS_LANGUAGES . $directory .'/'. $image, $lang_name),
                                    'input_ctext'=>xtc_draw_input_field($input_name,
                                            xtc_db_prepare_input($alloc->content),
                                            'size="30" maxlength="255"'
                                    )
                                );
				$tcounter++;
                            }
			}else{
                            for ($li = 0, $n = sizeof($languages); $li < $n; $li++) {
                                $alloc = \YES4Trade\Model\groups_characteristic_text_values::get_by_characteristic_id_and_products_id($C['products_characteristic_id'], $pInfo->products_id, $languages[$li]['id']);
				if($C['multiple'] == 1){
                                    $input_name = 'ctext_'.$C['products_characteristic_id'].'[M0]['.$languages[$li]['id'].']';
                                    $groups[$k]['C'][$gi]['NOSETS'][] = array(
                                        'img'=>xtc_image(DIR_WS_LANGUAGES . $languages[$li]['directory'] .'/'. $languages[$li]['image'], $languages[$li]['name']),
					'input_ctext'=>xtc_draw_input_field($input_name,
                                                xtc_db_prepare_input($alloc->content),'size="30" maxlength="255"'
                                         )
                                    );
				}else{
                                    $input_name = 'ctext_'.$C['products_characteristic_id'].'['.$languages[$li]['id'].']';
                                    $groups[$k]['C'][$gi]['NOSETS'][] = array(
                                        'img'=>xtc_image(DIR_WS_LANGUAGES . $languages[$li]['directory'] .'/'. $languages[$li]['image'], $languages[$li]['name']),
                                        'input_ctext'=>xtc_draw_input_field($input_name,
                                                xtc_db_prepare_input($alloc->content),'size="30" maxlength="255"'
                                        )
                                    );
				}
                            } // end for languages
                        } // end if multi from db
                    }  // end if no_sets == 0
		} // end size of sets
            } // end foreach characteristics
	} // end foreach groups
    } // eof is countbable groups
    $pInfo->groups = $groups;
    $pInfo->groups_num = (is_countable($groups) and sizeOf($groups))?sizeOf($groups):0;
    $pInfo->alloc_link = xtc_href_link('groups_allocation.php','action=add&pID='.$pInfo->products_id);
    $pInfo->add_group_icon = xtc_image('images/plus.gif','Zu einer Produktgruppe hinzufügen');


    if ( ($_SESSION['customers_status']['customers_status_id'] == '0') ){
	if( $admin_access['f_change_products_status'] == '1'){
		$pInfo->edit_status_input1 = xtc_draw_radio_field('products_status', '1', $status);
		$pInfo->edit_status_input2 = xtc_draw_radio_field('products_status', '0', $out_status);
	}
	if( $admin_access['f_products_meldebestand'] == '1'){
		$pInfo->edit_meldebestand_input = xtc_draw_input_field('products_meldebestand',$pInfo->products_meldebestand,'size="10" maxlength="10"');
		$pInfo->edit_meldebestand_active = xtc_draw_checkbox_field('meldebestand_active', '1',$pInfo->meldebestand_active);
	}
	if( $admin_access['f_change_products_date_available'] == '1'){
		$pInfo->edit_date_available = 1;
	}
	if( $admin_access['f_change_products_size'] == '1'){
		$pInfo->edit_size_depth = xtc_draw_input_field('size_depth',$pInfo->size_depth,'size="4"');
		$pInfo->edit_size_width = xtc_draw_input_field('size_width',$pInfo->size_width,'size="4"');
		$pInfo->edit_size_height = xtc_draw_input_field('size_height',$pInfo->size_height,'size="4"');
	}
	if( $admin_access['f_change_products_weight'] == '1'){
		$pInfo->edit_weight_input = xtc_draw_input_field('products_weight', $pInfo->products_weight,'size=4');
		$pInfo->edit_weight_netto_input = xtc_draw_input_field('products_weight_netto', number_format($pInfo->products_weight_netto,4,'.',''),'size=4');
	}
	if( $admin_access['units'] == '1'){
		$pInfo->edit_units_input = xtc_draw_pull_down_menu('units_id', $units_array, $pInfo->units_id);
	}
	if( $admin_access['groups_allocation'] == '1'){
		$pInfo->edit_groups_allocation = 1;
	}
	if( $admin_access['f_change_products_sort'] == '1'){
		$pInfo->edit_sort_input = xtc_draw_input_field('products_sort', $pInfo->products_sort,'size=3');
		$pInfo->edit_startpage_input = xtc_draw_checkbox_field('products_startpage', '1',$pInfo->products_startpage );
		$pInfo->edit_startpage_sort_input = xtc_draw_input_field('products_startpage_sort', $pInfo->products_startpage_sort,'size="3"' );
	}
	if( $admin_access['f_change_products_model'] == '1'){
		$pInfo->edit_model_input = xtc_draw_input_field('products_model', $pInfo->products_model);
	}
	if( $admin_access['f_change_products_barcode'] == '1'){
		$pInfo->edit_barcode_input = xtc_draw_input_field('products_ean', $pInfo->products_ean);
	}
	if( $admin_access['f_change_products_manufacturer'] == '1'){
		$pInfo->edit_manufacturer_input = xtc_draw_pull_down_menu('manufacturers_id', $manufacturers_array, $pInfo->manufacturers_id);
	}
	if( $admin_access['f_change_products_shippingtime'] == '1'){
		if (ACTIVATE_SHIPPING_STATUS=='true') {
			$default_shipping_status = ($pInfo->products_shippingtime > 0) ? $pInfo->products_shippingtime : DEFAULT_SHIPPING_STATUS_ID;
			$pInfo->edit_shippingtime_input = xtc_draw_pull_down_menu('shipping_status', $shipping_statuses, $default_shipping_status);
		}
	}
	if( $admin_access['f_change_products_fsk18'] == '1'){
		$pInfo->edit_fsk18_input = xtc_draw_pull_down_menu('fsk18', $fsk18_array, $pInfo->products_fsk18);
	}
	if( $admin_access['f_change_products_infotemplate'] == '1'){
		$files=$basics->get_template_values(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/module/product_info/');
		$default_array=array();
		// set default value in dropdown!
		if (!isset($content['content_file']) or $content['content_file']=='') {
			$default_array[]=array('id' => 'default','text' => TEXT_SELECT);
			$default_value=$pInfo->product_template;
			$files=array_merge($default_array,$files);
		} else {
			$default_array[]=array('id' => 'default','text' => TEXT_NO_FILE);
			$default_value=$pInfo->product_template;
			$files=array_merge($default_array,$files);
		}
		$pInfo->edit_infotemplate_input = xtc_draw_pull_down_menu('info_template',$files,$default_value);
	}
	if( $admin_access['f_change_products_ebaytemplate'] == '1'){
		$files=$basics->get_template_values(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/ebay_templates/');
	 	// set default value in dropdown!
	 	$default_array=array();
		if (!isset($content['content_file']) or $content['content_file']=='') {
			$default_array[]=array('id' => 'default','text' => TEXT_SELECT);
			$default_value=$pInfo->ebay_template;
			$files=array_merge($default_array,$files);
		} else {
			$default_array[]=array('id' => 'default','text' => TEXT_NO_FILE);
			$default_value=$pInfo->ebay_template;
			$files=array_merge($default_array,$files);
		}
		$pInfo->edit_ebaytemplate_input = xtc_draw_pull_down_menu('ebay_template',$files,$default_value);

		$files=$basics->get_template_values(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/module/product_characteristics/');
	 	// set default value in dropdown!
	 	$default_array=array();
		if (!isset($content['content_file']) or $content['content_file']=='') {
			$default_array[]=array('id' => 'default','text' => TEXT_SELECT);
			$default_value=$pInfo->characteristics_template;
			$files=array_merge($default_array,$files);
		} else {
			$default_array[]=array('id' => 'default','text' => TEXT_NO_FILE);
			$default_value=$pInfo->characteristics_template;
			$files=array_merge($default_array,$files);
		}
		$pInfo->edit_chartemplate_input = xtc_draw_pull_down_menu('characteristics_template',$files,$default_value);
	}
	if($admin_access['f_change_products_defaultstorage'] == '1'){
		$query = xtc_db_query('SELECT sp.storage_id FROM storage_products sp WHERE sp.products_id='.$pInfo->products_id);
		$defaults_array = array();
		$lager_str = '';
		while($defaults = xtc_db_fetch_array($query)){
			$defaults_array[] = $defaults['storage_id'];
		}
		$pInfo->edit_default_storage = xtc_draw_pull_down_menu('default_storage',$products_storages_array,$pInfo->default_storage );
	}
	if($admin_access['distributor_products'] == '1'){
		$pInfo->dist_edit_link = xtc_href_link('distributor_products.php','pID='.$pInfo->products_id);
		$pInfo->dist_edit_icon = xtc_image('images/icon_arrow_right.gif','Lieferanten hinterlegen/bearbeiten');
	}else{
		$pInfo->dist_edit_icon_disallow = xtc_image('images/icon_arrow_right.gif','Keine Berechtigung um Lieferanten hinterlegen/bearbeiten');
	}
	if($admin_access['f_products_ext_shippingcosts'] == '1'){
		$ext_ship_query = xtc_db_query("SELECT * FROM shipping_graduation_products WHERE products_id='".$pInfo->products_id."'");
		$ext_costs_active = (xtc_db_num_rows($ext_ship_query) > 0) ? '1' : '0';
		$ext_costs = array();
		while($ext_ship = xtc_db_fetch_array($ext_ship_query)){
			$ext_costs[ $ext_ship['shipping_graduation_groups_id'] ][ $ext_ship['graduation_id'] ] = $ext_ship['value'];
		}
		$pInfo->ext_costs_active = $ext_costs_active;
		$pInfo->edit_ext_additional_cost_input = xtc_draw_input_field('ext_additionalcosts',$pInfo->ext_additionalcosts,'size="10" maxlength="15"');
		$pInfo->ext_costs_allow = 1;
	        $garray = array();
		$garray_query = xtc_db_query("SELECT * FROM shipping_graduation_groups");
		while($groups = xtc_db_fetch_array($garray_query)){
			$grad_array = array();
			$grad_query = xtc_db_query("select * from shipping_graduation order by value");
	  		while ($grad = xtc_db_fetch_array($grad_query)) {
				// hole die allg. versandkosten
				$matrix_query_raw = sprintf("SELECT sgv.grad_value,sgw.weight FROM shipping_graduation_values sgv, shipping_graduation_weights sgw WHERE sgw.shipping_graduation_weights_id=sgv.shipping_graduation_weights_id and shipping_graduation_id='%s' and shipping_graduation_groups_id='%s' order by weight DESC",
					$grad['shipping_graduation_id'],
					$groups['shipping_graduation_groups_id']);
				$matrix_query = xtc_db_query($matrix_query_raw);
				while($matrix = xtc_db_fetch_array($matrix_query)){
					if((float)$pInfo->products_weight <= (float)$matrix['weight']){
						$matrix_value = $matrix['grad_value'];
						$weight_basis = $matrix['weight'];
					}
				}
				$extval = ($ext_costs_active == '1') ? $ext_costs[$groups['shipping_graduation_groups_id']][$grad['shipping_graduation_id']]:'';
				$grad_array[] = array(
					'value'=>$grad['value'],
					'input'=>xtc_draw_input_field('shipping_price['.$groups['shipping_graduation_groups_id'].'][' . $grad['shipping_graduation_id'].']',$extval, 'size=5'),
					'price'=>number_format($matrix_value,2,',','.')
				);
			}
			$garray[] = array(
				'title'=>$groups['title'],
				'grad'=>$grad_array
			);
		}
		$pInfo->weight_basis = $weight_basis;
		$pInfo->garray = $garray;
	}
	if($admin_access['f_change_products_meta'] == '1'){
		$meta_array = array();
  		for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
			$meta_array[ $languages[$i]['name'] ] = array(
				'title_input'=>xtc_draw_input_field('products_meta_title[' . $languages[$i]['id'] . ']',((isset($products_meta_title[$languages[$i]['id']])) ? stripslashes($products_meta_title[$languages[$i]['id']]) : xtc_get_products_meta_title($pInfo->products_id, $languages[$i]['id'])), 'size=100 class="input_display_length"'),
				'desc_input'=>xtc_draw_textarea_field('products_meta_description[' . $languages[$i]['id'] . ']','virtual',99,10,((isset($products_meta_description[$languages[$i]['id']])) ? stripslashes($products_meta_description[$languages[$i]['id']]) : xtc_get_products_meta_description($pInfo->products_id, $languages[$i]['id'])),' class="input_display_length"'),
				'keyword_input'=>xtc_draw_input_field('products_meta_keywords[' . $languages[$i]['id'] . ']', ((isset($products_meta_keywords[$languages[$i]['id']])) ? stripslashes($products_meta_keywords[$languages[$i]['id']]) : xtc_get_products_meta_keywords($pInfo->products_id, $languages[$i]['id'])), 'size=100 class="input_display_length"')
			);
		}
		$pInfo->meta_array = $meta_array;
	}
	$conditions = array(array('id'=>'','text'=>TEXT_SELECT));
        $conditions_array = \YES4Trade\Model\products_conditions::get_list($_SESSION['languages_id']);
	foreach($conditions_array as $cond){
	    $conditions[] = array(
		'id'=>$cond['products_conditions_id'],
		'text'=>$cond['title']
	    );
	}
	$pInfo->edit_condition = xtc_draw_pull_down_menu('products_conditions_id', $conditions,$pInfo->products_conditions_id);
	$pInfo->edit_mpn = xtc_draw_input_field('mpn',$pInfo->mpn,'maxlength="64"');
	$pInfo->edit_ebay_productreferenceid = xtc_draw_input_field('ebay_productreferenceid',$pInfo->ebay_ProductReferenceID,'maxlength="64"');
	$desc_edit_array = array();
	for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
		$desc_edit_array[ $languages[$i]['name'] ]['icon'] = xtc_image(DIR_WS_LANGUAGES . $languages[$i]['directory'] .'/'. $languages[$i]['image'], $languages[$i]['name']);
		$desc_edit_array[ $languages[$i]['name'] ]['id'] = $languages[$i]['id'];
		
		if(defined('MODULE_OTHER_AMAZON_STATUS') and MODULE_OTHER_AMAZON_STATUS == 'True'){
		    $agk_query = xtc_db_query(sprintf(
			    "SELECT amazon_generic_keywords1,amazon_generic_keywords2,amazon_generic_keywords3,amazon_generic_keywords4,amazon_generic_keywords5 FROM products_description WHERE products_id='%s' AND language_id='%s'",
			    $pInfo->products_id,$languages[$i]['id']
		    ));
		    $agk_record = xtc_db_fetch_array($agk_query);
		    for($agk=1;$agk<=5;$agk++){
			$agk_field = 'amazon_generic_keywords'.$agk;
			$desc_edit_array[ $languages[$i]['name'] ]['edit_'.$agk_field] = array(
			    'name'=>$agk_field.'[' . $languages[$i]['id'] . ']', 
			    'value'=>$agk_record[$agk_field],
			    'size'=>90,
			    'maxlength'=>255
			);
		    }
		}
		
		$templates_array = array();
		$template_link = 'categories.php?action=get_template_content&cgID=100&lID='.$languages[$i]['id'].'&cID=';
                $items = \YES4Trade\Model\content_manager::get_by_content_group(100);
                foreach($items as $it){
                    $template = $it->toArray();
                    $templates_array[] = array(
                            'title'=>xtc_db_prepare_input($template['content_title']),
                            'description'=>xtc_db_prepare_input($template['content_heading']),
                            'file'=>$template_link . $template['content_id']
                    );
		}
		$desc_edit_array[ $languages[$i]['name'] ]['description_wysiwyg'] = xtc_draw_textarea_field( 'products_description['.$languages[$i]['id'].']','virtual', 80,60,  xtc_get_products_description($pInfo->products_id, $languages[$i]['id']),'class="tinymce" style="width:100%;height:500px;"');
		$desc_edit_array[ $languages[$i]['name'] ]['short_description_wysiwyg'] = xtc_draw_textarea_field( 'products_short_description['.$languages[$i]['id'].']','virtual', 80,60,  xtc_get_products_short_description($pInfo->products_id, $languages[$i]['id']),'class="tinymce" style="width:100%;height:500px;"');
		$desc_edit_array[ $languages[$i]['name'] ]['extratext_wysiwyg'] = xtc_draw_textarea_field( 'products_extra_text['.$languages[$i]['id'].']','virtual', 80,60, xtc_get_products_extra_text($pInfo->products_id, $languages[$i]['id']),'class="tinymce" style="width:100%;height:500px;"').xtc_wysiwyg($templates_array);
		
		
		
		
		if($admin_access['f_change_products_title'] == '1'){
		    if(isset($products_name[$languages[$i]['id']])){
			$products_name_value = stripslashes($products_name[$languages[$i]['id']]);
		    }else{
			$products_name_value = xtc_get_products_name($pInfo->products_id, $languages[$i]['id']);
		    }
		    $desc_edit_array[ $languages[$i]['name'] ]['ivalue'] = htmlspecialchars($products_name_value, ENT_QUOTES | ENT_SUBSTITUTE,CHARSET);
		    $desc_edit_array[ $languages[$i]['name'] ]['iname'] = 'products_name[' . $languages[$i]['id'] . ']';
		    $desc_edit_array[ $languages[$i]['name'] ]['imaxlength'] = 128;
		    $desc_edit_array[ $languages[$i]['name'] ]['isize'] = 90;
		}else{
			$title  = (xtc_get_products_name($pInfo->products_id, $languages[$i]['id']) != '') ?  xtc_get_products_name($pInfo->products_id, $languages[$i]['id']): '<i>Noch nicht vergeben</i>';
			$desc_edit_array[ $languages[$i]['name'] ]['edit_title'] = '<a href="#" onClick="alert(\'Keine Berechtigung f�r Titel �ndern.\');">'.$title.'</a>';
		}
		if($admin_access['f_change_products_ebaytitle'] == '1'){
			$eti_value = ((isset($ebay_title[$languages[$i]['id']])) ? stripslashes($ebay_title[$languages[$i]['id']]) : xtc_get_products_ebay_title($pInfo->products_id, $languages[$i]['id']));
			$desc_edit_array[ $languages[$i]['name'] ]['etivalue'] = htmlspecialchars($eti_value, ENT_QUOTES | ENT_SUBSTITUTE,CHARSET);
			$desc_edit_array[ $languages[$i]['name'] ]['etiname'] = 'ebay_title[' . $languages[$i]['id'] . ']';
			$desc_edit_array[ $languages[$i]['name'] ]['etisize'] = MAX_SIZE_EBAY_TITLE+10;
			$desc_edit_array[ $languages[$i]['name'] ]['etimaxlength'] = MAX_SIZE_EBAY_TITLE;
		}else{
			$etitle = (xtc_get_products_ebay_title($pInfo->products_id, $languages[$i]['id']) != '') ? xtc_get_products_ebay_title($pInfo->products_id, $languages[$i]['id']) : '<i>Noch nicht vergeben</i>';
			$desc_edit_array[ $languages[$i]['name'] ]['edit_ebaytitle'] = '<a href="#" onClick="alert(\'Keine Berechtigung f�r Ebay-Titel �ndern.\');">'.$etitle.'</a>';
		}
		$ati_value = ((isset($amazon_title[$languages[$i]['id']])) ? stripslashes($amazon_title[$languages[$i]['id']]) : xtc_get_products_amazon_title($pInfo->products_id, $languages[$i]['id']));
		$desc_edit_array[ $languages[$i]['name'] ]['ativalue'] = htmlspecialchars($ati_value, ENT_QUOTES | ENT_SUBSTITUTE,CHARSET);
		$desc_edit_array[ $languages[$i]['name'] ]['atiname'] = 'amazon_title[' . $languages[$i]['id'] . ']';
		$desc_edit_array[ $languages[$i]['name'] ]['atisize'] = 90;
		$desc_edit_array[ $languages[$i]['name'] ]['atimaxlength'] = 255;
		if($admin_access['f_change_products_desc'] == '1'){
			$desc_edit_array[ $languages[$i]['name'] ]['edit_desc_link'] = xtc_href_link('products_description.php',xtc_get_all_get_params(array('lang','pID')).'lang='.$languages[$i]['id'].'&pID='.$pInfo->products_id);
			$desc_edit_array[ $languages[$i]['name'] ]['desc_status'] = ( strlen(xtc_get_products_description($pInfo->products_id,$languages[$i]['id'])) < 1 ) ? 0 : 1;
			$desc_edit_array[ $languages[$i]['name'] ]['edit_extratext_link'] = xtc_href_link('products_extra_text.php',xtc_get_all_get_params(array('lang','pID')).'lang='.$languages[$i]['id'].'&pID='.$pInfo->products_id);
			$desc_edit_array[ $languages[$i]['name'] ]['extratext_status'] = ( strlen(xtc_get_products_extra_text($pInfo->products_id,$languages[$i]['id'])) < 1 ) ? 0 : 1;
			$desc_edit_array[ $languages[$i]['name'] ]['edit_short_link'] = xtc_href_link('products_short_description.php',xtc_get_all_get_params(array('lang','pID')).'lang='.$languages[$i]['id'].'&pID='.$pInfo->products_id);
			$desc_edit_array[ $languages[$i]['name'] ]['short_status'] = ( strlen(xtc_get_products_short_description($pInfo->products_id,$languages[$i]['id'])) < 1 ) ? 0 : 1;
		}
		if($admin_access['f_change_products_slave_title'] == '1'){
			$sti_value = ((isset($slave_title[$languages[$i]['id']])) ? stripslashes($slave_title[$languages[$i]['id']]) : xtc_get_products_slave_title($pInfo->products_id, $languages[$i]['id']));
			$desc_edit_array[ $languages[$i]['name'] ]['stivalue'] = htmlspecialchars($sti_value, ENT_QUOTES | ENT_SUBSTITUTE,CHARSET);
			$desc_edit_array[ $languages[$i]['name'] ]['stiname'] = 'slave_title[' . $languages[$i]['id'] . ']';
			$desc_edit_array[ $languages[$i]['name'] ]['stisize'] = 90;
			$desc_edit_array[ $languages[$i]['name'] ]['stimaxlength'] = 128;
		}else{
			$desc_edit_array[ $languages[$i]['name'] ]['edit_slave_title'] = ((isset($slave_title[$languages[$i]['id']])) ? stripslashes($slave_title[$languages[$i]['id']]) : xtc_get_products_slave_title($pInfo->products_id, $languages[$i]['id']));
		}
		$pInfo->desc_edit_array = $desc_edit_array;
	}
	if($admin_access['f_change_products_pics'] == '1'){
		$pInfo->allow_pics = 1;
	}
	if($admin_access['f_change_products_comments'] == '1'){
		$pInfo->edit_comments = xtc_draw_textarea_field('comments','',120,30,xtc_db_prepare_input($pInfo->comments));
		$pInfo->edit_storage_comments = xtc_draw_textarea_field('storage_comments','',60,3,xtc_db_prepare_input($pInfo->storage_comments));
	}else{
		$pInfo->edit_comments = $pInfo->comments;
		$pInfo->edit_storage_comments = $pInfo->storage_comments;
	}
    }
    if (GROUP_CHECK=='true') {
	$gc_array = array();
	$customers_statuses_array = xtc_get_customers_statuses();
	$customers_statuses_array=array_merge(array(array('id'=>'all','text'=>TXT_ALL)),$customers_statuses_array);
	for ($i=0;$n=sizeof($customers_statuses_array),$i<$n;$i++) {
		if (strstr($pInfo->group_ids,'c_'.$customers_statuses_array[$i]['id'].'_group')) {
			$checked='checked ';
		} else {
			$checked='';
		}
		$gc_array[] = array(
			'input'=>'<input type="checkbox" name="groups[]" value="'.$customers_statuses_array[$i]['id'].'"'.$checked.'>',
			'text'=>$customers_statuses_array[$i]['text']
		);
	}
	$pInfo->group_check_array = $gc_array;
    }
    $pInfo->date_added_input = xtc_draw_hidden_field('products_date_added', (($pInfo->products_date_added) ? $pInfo->products_date_added : date('Y-m-d')));

    $pInfo->edit_extra_shipping_input = xtc_draw_input_field('shipping_extra_charge',$pInfo->shipping_extra_charge);

    // GEWICHT
    if(property_exists($pInfo,'collies') and is_countable($pInfo->collies) and sizeOf($pInfo->collies) > 0){
	$pInfo->formated_weight = number_format($pInfo->products_weight,4,',','');
	//$pInfo->formated_weight_netto = number_format($pInfo->products_weight_netto,3,',','');
	$pInfo->products_weight_netto = 0;
	$pInfo->formated_packaging_weight = 0;
	foreach($pInfo->collies as $pk=>$colli){
	    $csize = xtc_get_products_size($colli['collie_products_id']);
	    $packd = yes_get_products_packaging_details($colli['collie_products_id']);
	    $pInfo->collies[$pk]['formated_packaging_weight'] = number_format( $packd['weight'],4,',','.' );
	    $pInfo->collies[$pk]['formated_weight_brutto_calc'] = number_format( $packd['weight']+$colli['weight_netto'],4,',','.' );
	    $pInfo->collies[$pk]['height'] = number_format($csize['height'],2,',','.');
	    $pInfo->collies[$pk]['width'] = number_format($csize['width'],2,',','.');
	    $pInfo->collies[$pk]['depth'] = number_format($csize['depth'],2,',','.');
	    $pInfo->collies[$pk]['volume'] = number_format(( ($csize['depth'] /100) * ($csize['width']/100) * ($csize['height'] / 100) )* $colli['quantity'],4,',','.');
	    $pInfo->products_weight_netto += $colli['weight_netto']*$colli['quantity'];
	    $pInfo->formated_packaging_weight += $packd['weight']*$colli['quantity'];
	}	
	$pInfo->formated_weight_netto = number_format($pInfo->products_weight_netto,4,',','.');
	$pInfo->formated_weight_brutto_calc = number_format($pInfo->products_weight_netto+$pInfo->formated_packaging_weight,4,',','.');
	/*
	collie.formated_weight_netto
	collie.formated_packaging_weight
	collie.formated_weight_brutto_calc
	pInfo.formated_packaging_weight
	pInfo.formated_weight_brutto_calc
	*/
	
	
    }

    $pInfo->bestand_input_link = xtc_href_link('products.php','action=bestand&edit=1&pID='.$pInfo->products_id);
    $pInfo->bestand_link = xtc_href_link('products.php','action=bestand&pID='.$pInfo->products_id);
    $pInfo->edit_master_input = xtc_draw_input_field('products_master', $pInfo->products_master, "size=6");
    $pInfo->products_master_edit_link = xtc_href_link('categories.php','action=master_slave&products_id='.$pInfo->products_id);
	$master_query = xtc_db_query(sprintf("SELECT COUNT(products_id) as anz FROM products WHERE products_master=%s",
		$pInfo->products_id
	));
	$master = xtc_db_fetch_array($master_query);
	$pInfo->number_of_slaves = (int)$master['anz'];
	$pInfo->MASTER_TEXT = sprintf(MASTER_SLAVE_STATUS_MASTER,$pInfo->number_of_slaves);
	$pInfo->SLAVE_TEXT = sprintf(MASTER_SLAVE_STATUS_SLAVE,$pInfo->products_master);
	
    //$pInfo->edit_master_select_input = xtc_draw_pull_down_menu('products_master_select', $products_master_array, ' ', 'onchange="updateProductsMaster()"');
    $pInfo->edit_listing_status_input1 = xtc_draw_radio_field('products_listing_status', '1', $in_listing_status);
    $pInfo->edit_listing_status_input2 = xtc_draw_radio_field('products_listing_status', '0', $out_listing_status);
    $pInfo->edit_master_status_input = xtc_draw_checkbox_field('products_master_status', '1',$in_master_status);
    $pInfo->products_fsk18_string = ($pInfo->products_fsk18 == 1) ? 'ja' : 'nein';
    $pInfo->shop_preview_link = HTTP_SERVER.'admin_product_info.php?products_id='.$pInfo->products_id;
    $pInfo->ebay_preview_link = xtc_catalog_href_link('admin/ebayapi_preview.php','id='.$pInfo->products_id.'&preview=1','NONSSL');
    $pInfo->shippingcosts_link = xtc_href_link('../popup_shippingcosts.php','products_id='.$pInfo->products_id);

	// BOF VPE HANDLING
	$products_vpe_values = array(0=>array('id'=>'','text'=>TEXT_SELECT));
	$query = xtc_db_query(sprintf(
		"SELECT products_vpe_id, products_vpe_name FROM %s WHERE language_id='%s' ORDER BY products_vpe_name",
		TABLE_PRODUCTS_VPE,$_SESSION['languages_id']
	));
	while($record = xtc_db_fetch_array($query)){
		$products_vpe_values[] = array(
			'id'=>$record['products_vpe_id'],
			'text'=>$record['products_vpe_name']
		);
	}
	
	$pInfo->products_vpe_input = xtc_draw_pull_down_menu('products_vpe', $products_vpe_values,$pInfo->products_vpe);
	$pInfo->products_vpe_status_input = xtc_draw_checkbox_field('products_vpe_status', '1',(($pInfo->products_vpe_status == 1)?true:false));
	$pInfo->products_vpe_value_input = xtc_draw_input_field('products_vpe_value', $pInfo->products_vpe_value);
        $pInfo->products_vpe_base_measure_input = xtc_draw_input_field('products_vpe_base_measure', $pInfo->products_vpe_base_measure);
	// EOF VPE HANDLING

	
	
    // COLLIE BESTAENDE - ETWAS WIRR, BEI GELEGENHEIT MAL AUSBAUEN
    if(sizeOf($collies)>0){
	$collie_qty_array = array();
	$p_query = xtc_db_query("SELECT p.products_quantity FROM products p WHERE p.products_id='".(int)$collies[0]['collie_products_id']."'");
	$p = xtc_db_fetch_array($p_query);
	$qty = (int)$p['products_quantity'];
	$qty_left = $qty%(int)$collies[0]['quantity'];
	if($qty < $collies[0]['quantity']){
		$qty_available = 0;
	}else{
		$qty_available = ($qty-$qty_left)/$collies[0]['quantity'];
	}
	$qty_available_final = $qty_available;
	
	$available_string = '';
	foreach($collies as $k=>$collie){
		$p_query = xtc_db_query("SELECT p.products_quantity FROM products p WHERE p.products_id='".(int)$collie['collie_products_id']."'");
		$p = xtc_db_fetch_array($p_query);
		$qty = (int)$p['products_quantity'];
		$qty_left = $qty%(int)$collie['quantity'];
		if($qty < $collie['quantity']){
			$qty_available = 0;
			$collie_qty_array[] = array(
				'pID'=>$collie['collie_products_id'],
				'edit_link'=>xtc_href_link('categories.php','cPath='.xtc_get_product_path($collie['collie_products_id']).'&pID='.$collie['collie_products_id'].'&action=new_product'),
				'name'=>xtc_get_products_name($collie['collie_products_id']),
				'qty'=>$qty,
				'collie_qty'=>$collie['quantity'],
				'qty_available'=>0
			);
		}else{
			$qty_available = ($qty-$qty_left)/$collie['quantity'];
			$collie_qty_array[] = array(
				'pID'=>$collie['collie_products_id'],
				'edit_link'=>xtc_href_link('categories.php','cPath='.xtc_get_product_path($collie['collie_products_id']).'&pID='.$collie['collie_products_id'].'&action=new_product'),
				'name'=>xtc_get_products_name($collie['collie_products_id']),
				'qty'=>$qty,
				'collie_qty'=>$collie['quantity'],
				'qty_available'=>$qty_available
			);
		}
		if($qty_available <= $qty_available_final)
			$qty_available_final = $qty_available;
	}
	$pInfo->collie_qty_array = $collie_qty_array;
	$pInfo->products_quantity = xtc_get_product_collie_qty($pInfo->products_id);
   }
   // ENDE COLLIEBESTAENDE

   $query = xtc_db_query('SELECT sp.storage_id FROM storage_products sp WHERE sp.products_id='.$pInfo->products_id);
   $defaults_array = array();
   while($defaults = xtc_db_fetch_array($query)){
	$defaults_array[] = $defaults['storage_id'];
   }
   $has_numbers = 0;
   $places_total = 0;
   if(sizeOf($products_storages_array)>0){
	$pInfo->products_storages_array = $products_storages_array;
	$ps_array = array();
	for($i=1;$i<count($products_storages_array);$i++){
		// show storage_numbers
		$query = xtc_db_query("SELECT * FROM storage_numbers WHERE storage_id='".$products_storages_array[$i]['id']."' && products_id='".$pInfo->products_id."'");
		$has_numbers += xtc_db_num_rows($query);
		$act_ps_array = array();
		while($numberdata = xtc_db_prepare_input(xtc_db_fetch_array($query))){
			$places_query = xtc_db_query("SELECT id,storage_place,storage_places_id,quantity FROM storage_products WHERE products_id='".$pInfo->products_id."' and storage_id='".$products_storages_array[$i]['id']."'");
			$places_str = '';
			$places_count = 0;
			while($places = xtc_db_prepare_input(xtc_db_fetch_array($places_query))){
			    if($places['storage_places_id'] > 0){
				$place = yes_get_storage_place_title($places['storage_places_id']);
			    }else{
				$place = $places['storage_place'];
			    }
                            
			    $places_str .= sprintf('<div class="storage_place_container" id="%d"><u>%s (<span class="stpqty">%d</span> Stk)</u></div> ',
                                $places['id'],
                                //xtc_href_link('storage_admin.php','spID='.$places['id'].'&pID='.$pInfo->products_id.'&stID='.$products_storages_array[$i]['id']),
                                $place,
                                $places['quantity']
                            );
			    $places_count++;
			    $places_total++;
			}
			$act_ps_array[] = array(
			    'id'=>$numberdata['id'],
			    'storage_id'=>$numberdata['storage_id'],
                            'number'=>$numberdata['nummer'],
                            'number_link'=>xtc_href_link('storage_numbers.php','pID='.$pInfo->products_id.'&stID='.$numberdata['storage_id'].'&sID='.$numberdata['id']),
                            'places'=>$places_str,
                        );
		}
		$ps_array[] = array(
                    'text'=>$products_storages_array[$i]['text'],
                    'add_number_link'=>xtc_href_link('storage_admin.php','stID='.$products_storages_array[$i]['id'].'&pID='.$pInfo->products_id.'&action=addproduct'),
                    'numberdata'=>$act_ps_array,
                );
	}
        $pInfo->untransferred = $SQ->get_untransferred();
	$pInfo->ps_array = $ps_array;
	$pInfo->add_place_icon = xtc_image('images/plus.gif','Weiteren Lagerplatz erzeugen');
   }
   
$pInfo->new_storage_link = xtc_href_link('storage_numbers.php','products_id='.$pInfo->products_id.'&action=ajax_add&stID='.$pInfo->default_storage);
$pInfo->allow_priority = 0;
if($places_total > 1){
    $pInfo->allow_priority = 1;
}

$pInfo_array = get_object_vars($pInfo);
$smarty->assign('pInfo',$pInfo_array);

$smarty->assign('INPUT_DEFAULT_SHIPPER',xtc_draw_pull_down_menu('default_shipper',
    \YES4Trade\Model\shipper_profiles::get_selection_list(),  
    \YES4Trade\Model\shipper_profiles::get_products_id_value( $pInfo->products_id )
).'&nbsp;'. \YES4Trade\Model\shipper_profiles::get_crud_link());
        
include(DIR_WS_MODULES.'group_prices.php');
include(DIR_WS_MODULES.'products_images.php');
$form_action = ($pInfo->products_id) ? 'update_product' : 'insert_product';


if(isset($admin_access['amazon_export'])){
    $afields = array();
    $basics = new basics;
    foreach($languages as $lang){
	$template_select_array = array();
	$ae = new amazon_export($lang['directory']);
	$amazon_flatfiles = $ae->get_amazon_flatfiles();
	$amazon_flatfile = yes_get_products_amazon_flatfile($pInfo->products_id, $lang['id']);
	if(sizeOf($amazon_flatfiles)){
	    foreach($amazon_flatfiles as $af){
		if(!is_dir(\main::get_importdata_path().'amazon_export_templates/'.$af['id'])) continue;
		$dir = $basics->get_directory_content(\main::get_importdata_path().'amazon_export_templates/'.$af['id'].'/');
		if(!sizeOf($dir)) continue;
		foreach($dir as $file){
		    $template_select_array[ $af['id'] ][] = array('id'=>$af['id'].':'.$file,'text'=>$file);
		}
	    }
	}
	if(sizeOf($template_select_array)){
	    $flat_pulldown = '<select name="amazon_flatfile['.$lang['id'].']"><option value="">'.TEXT_SELECT.'</option>';
	    foreach($template_select_array as $optGroup=>$options){
		$flat_pulldown .= '<optgroup label="'.$optGroup.'">';
		foreach($options as $opt){
		    $selected = (($amazon_flatfile == $opt['id'])?' selected':'');
		    $flat_pulldown .= '<option value="'.$opt['id'].'"'.$selected.'>'.$opt['text'].'</option>';
		}
		$flat_pulldown .= '</optgroup>';
	    }
	    $flat_pulldown .= '</select>';
	}else{
	    $flat_pulldown = 'Kein Amazon Template konfiguriert';
	}
	$amazon_browse_node_id = yes_get_products_amazon_browse_node_id($pInfo->products_id, $lang['id']);
	$afields[$lang['name']] = array(
	    'input_flatfile'=>$flat_pulldown,
	    'input_browse_node_id'=>xtc_draw_input_field('amazon_browse_node_id['.$lang['id'].']',$amazon_browse_node_id,'size="32" maxlength="32"'),
	    'input_products_description_amazon'=>  xtc_draw_textarea_field('products_description_amazon['.$lang['id'].']', 'virtual', 80, 6, yes_get_products_description_amazon($pInfo->products_id,$lang['id']), 'class="show_length"')
	);
    }
    $smarty->assign(array(
	'AMAZON_EXPORT'=>1,
	'EXT_POPUP_WIDTH' => EXT_POPUP_WIDTH,
	'EXT_POPUP_HEIGHT'=> EXT_POPUP_HEIGHT,
	'AMAZON_EXPORT_FIELDS'=>$afields
    ));
}


if(defined('MODULE_GOOGLE_PRODUCT_FEED_STATUS') and MODULE_GOOGLE_PRODUCT_FEED_STATUS == 'True'){
	$query = xtc_db_query(sprintf(
		"SELECT * FROM products_google_feed_data WHERE products_id='%s'",
		$pInfo->products_id
	));
	$gpf = xtc_db_fetch_array($query);
	$condition_array = array(
		array('id'=>'new','text'=>'Neu'),
		array('id'=>'used','text'=>'Gebraucht'),
		array('id'=>'refurbished','text'=>'Erneuert')
	);
	$availability_array = array(
		array('id'=>'in_stock','text'=>'Auf Lager'),
		array('id'=>'available for order','text'=>'Bestellbar'),
		array('id'=>'out of stock','text'=>'Vergriffen'),
		array('id'=>'preorder','text'=>'Vorbestellt')
	);

	$smarty->assign(array(
		'google_product_feed'=>1,
		'input_condition'=>xtc_draw_pull_down_menu('condition',$condition_array,$gpf['google_condition']),
		'input_availability'=>xtc_draw_pull_down_menu('availability',$availability_array,$gpf['availability']),
		'input_gtin'=>xtc_draw_input_field('gtin',$gpf['gtin'],'maxlength="16" size="16"'),
		'input_mpn'=>xtc_draw_input_field('mpn',$gpf['mpn'],'maxlength="32" size="16"'),
		'input_adwords_grouping'=>xtc_draw_input_field('adwords_grouping',$gpf['adwords_grouping'],'maxlength="32" size="32"'),
		'input_adwords_labels'=>xtc_draw_input_field('adwords_labels',$gpf['adwords_labels'],'maxlength="64" size="32"'),
	));
	if(defined('MODULE_GOOGLE_PRODUCT_FEED_APPAREL') and MODULE_GOOGLE_PRODUCT_FEED_APPAREL == 'True'){
		$fields = array();
		foreach($languages as $lang){
			$query = xtc_db_query(sprintf(
				"SELECT gender, age_group,color,size,pattern,material,description FROM products_google_feed_apparel WHERE products_id='%s' AND language_id='%s'",
				$pInfo->products_id,$lang['id']
			));
			$record = xtc_db_fetch_array($query);
			$fields[ $lang['name'] ] = array(
				'input_gender'=>'<input name="gender['.$lang['id'].']" value="'.$record['gender'].'" size="16" maxlength="16" />',
				'input_age_group'=>'<input name="age_group['.$lang['id'].']" value="'.$record['age_group'].'" size="16" maxlength="16" />',
				'input_color'=>'<input name="color['.$lang['id'].']" value="'.$record['color'].'" size="32" maxlength="64" />',
				'input_pattern'=>'<input name="pattern['.$lang['id'].']" value="'.$record['pattern'].'" size="32" maxlength="64" />',
				'input_material'=>'<input name="material['.$lang['id'].']" value="'.$record['material'].'" size="32" maxlength="64" />',
				'input_description'=>'<input name="description['.$lang['id'].']" value="'.$record['description'].'" size="32" maxlength="64" />',
				'input_size'=>'<input name="size['.$lang['id'].']" value="'.$record['size'].'" size="32" maxlength="32" />',
			);
		}
		$smarty->assign(array(
			'google_product_feed_apparel'=>1,
			'fields'=>$fields
		));
	}
}


$additional_title = '';

if($pInfo->products_master_status > 0 or (isset($_REQUEST['action']) and $_REQUEST['action'] == 'new_master')){
    $additional_title .= '<img src="images/master.gif" />';
}else if($pInfo->products_master > 0){
    $additional_title .= '<img src="images/slave.gif" />&nbsp;';
}
if($pInfo->products_name != ''){
    $additional_title .= $pInfo->products_name;
}else{
    $additional_title .= TEXT_EMPTY_DESCRIPTION;
}

$buttons = array();
if($pInfo->collies_num == 0){
    $buttons[] = array('link'=>"javascript:void(window.open('".$pInfo->bestand_input_link."','popup','width=".EXT_POPUP_WIDTH.",height=".EXT_POPUP_HEIGHT.",scrollbars=yes,resizable=yes'));",
	    'text'=>BUTTON_QTY_CHANGE,
	    'auth'=>true,
	    'lbOn'=>false
    );
}
$buttons[] = array('text'=>BUTTON_QTY_DETAILS,
    'link'=>"javascript:void(window.open('".$pInfo->bestand_link."','popup','width=".EXT_POPUP_WIDTH.",height=".EXT_POPUP_HEIGHT.",scrollbars=yes,resizable=yes'));",
    'auth'=>true,
    'lbOn'=>false
);

$product = new product($pInfo->products_id);



// eintrag in specials?
$query = xtc_db_query(sprintf(
	"SELECT specials_id FROM %s WHERE products_id='%s'",
	TABLE_SPECIALS,$pInfo->products_id
));
if(xtc_db_num_rows($query)){
    $record = xtc_db_fetch_array($query);
    $from = xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params());
    $buttons[] = array('text'=>TEXT_SPECIAL.' '.IMAGE_EDIT,
	'link'=>xtc_href_link('ajax_categories_details.php','pID='.$pInfo->products_id.'&action=edit_special&from='.urlencode($from)),
	'auth'=>true,
	'lbOn'=>true
    );
}else{
    $buttons[] = array('text'=>TEXT_SPECIAL,
	'link'=>xtc_href_link(FILENAME_CATEGORIES,'action=special_price&products_id='.$pInfo->products_id),
	'auth'=>true,
	'lbOn'=>true,
	'add_css_class'=>'special_price_button'
    );
}
if($pInfo->number_of_slaves > 0){
    $master_link_title = $pInfo->MASTER_TEXT;
}else if($pInfo->products_master > 0){
    $master_link_title = $pInfo->SLAVE_TEXT;
}else{
    $master_link_title = TEXT_MASTER_SLAVE;
}
$buttons[] = array(
    'text'=>$master_link_title,
    'link'=>$pInfo->products_master_edit_link,
    'auth'=>true,
    'lbOn'=>false
);
$pg = xtc_get_product_groups($pInfo->products_id);
$size_pg = (is_countable($pg) and sizeOf($pg))?sizeOf($pg):0;
$buttons[] = array(
    'text'=>HEADING_TITLE_GROUPS_ALLOCATION.' ('.$size_pg.')',
    'link'=>xtc_href_link('products.php','action=groups_allocation&pID='.$pInfo->products_id),
    'auth'=>true,
    'lbOn'=>true,
    'add_css_class'=>'product_groups_button bigWidth'
);
$buttons[] = array('text'=>IMAGE_COPY_TO,
    'link'=>xtc_href_link(FILENAME_CATEGORIES,'action=copy_to&products_id='.$pInfo->products_id),
    'auth'=>true,
    'lbOn'=>true
);

$buttons[] = array('text'=>TEXT_INFO_HEADING_MOVE_PRODUCT,
    'link'=>xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action')).'action=move_from_products_detail_page'),
    'lbOn'=>true,
    'auth'=>true
);
$buttons[] = array('text'=>TEXT_SHOP_PREVIEW,
    'link'=>"javascript:void(preview('".$pInfo->shop_preview_link."'));",
    'auth'=>true,
    'lbOn'=>false
);
if($pInfo->ebay_template != '' and $pInfo->ebay_template != 'default'){
    $buttons[] = array('text'=>TEXT_EBAY_PREVIEW,
	'link'=>"javascript:void(preview('".$pInfo->ebay_preview_link."'));",
	'auth'=>true,
	'lbOn'=>false
    );
}
$buttons[] = array('text'=>TEXT_PRODUCTS_HISTORY,
    'link'=>xtc_href_link('products.php','action=history&pID='.$pInfo->products_id),
    'lbOn'=>true,
    'auth'=>true
);
$buttons[] = array('text'=>TEXT_PROPERTIES.' ('.sizeOf($pp).')',
    'link'=>xtc_href_link(FILENAME_CATEGORIES,'action=product_properties&pID='.$pInfo->products_id),
    'auth'=>true,
    'lbOn'=>true
);
if(sizeOf($pp)>1){
    $xy = \YES4Trade\Model\product_properties_xy_prices::get_from_products_id($pInfo->products_id);
    $class = ($xy===false) ? '' : 'ui-state-highlight';
    $buttons[] = array('text'=>TEXT_PROPERTIES_XY_PRICES,
        'link'=>xtc_href_link(FILENAME_CATEGORIES,'action=xy_prices&pID='.$pInfo->products_id),
        'add_css_class'=>$class,
        'auth'=>true,
        'lbOn'=>false
    );
}
if($admin_access['module_export'] == 1 and defined('MODULE_YES_FILE')){
    $buttons[] = array('text'=>IMAGE_EXPORT,
	'link'=>xtc_href_link(FILENAME_MODULE_EXPORT,'set=&module=yes2&action=save&products_id_export='.$pInfo->products_id.'&configuration[MODULE_YES_FILE]='.MODULE_YES_FILE.'&export=yes'),
	'auth'=>true,
	'lbOn'=>false
    );
}

if($admin_access['ebayapi_cart'] == 1 and $SQ->get_auction_qty() > 0){
    $buttons[] = array(
	'text'=>TEXT_PRODUCTS_IN_AUCTION,
	'link'=>xtc_href_link('ebayapi_cart.php','page_type=runnings&searchword='.$pInfo->products_id.'&searchmode=pid'),
	'lbOn'=>false,
	'auth'=>true
    );
}

$buttons[] = array(
    'text'=>ADD_QUICKNOTE,
    'link'=>"javascript:toggleBox('addquicknote');",
    'lbOn'=>false,
    'auth'=>true
);
if( $pInfo->products_ean != '' and is_file(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/barcode_products.conf') and is_file(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/barcode_products.html')){
    $buttons[] = array(
	'text'=>TEXT_BARCODE_PRODUCTS,
	'link'=>xtc_href_link(FILENAME_CATEGORIES,'action=labelprint&pID='.$pInfo->products_id),
	'lbOn'=>false,
	'auth'=>true,
	'target'=>'_blank'
    );
}
if( is_file(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/barcode_products.conf') and is_file(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/product_label.html')){
    $buttons[] = array(
	'text'=>TEXT_PRODUCT_LABEL,
	'link'=>xtc_href_link('products.php','action=print_label&pID='.$pInfo->products_id),
	'lbOn'=>false,
	'auth'=>true,
	'target'=>'_blank'
    );
}
$buttons[] = array(
    'text'=>TXT_STAFFELPREIS,
    'link'=>xtc_href_link('products.php','action=group_prices_view&pID='.$pInfo->products_id),
    'lbOn'=>true,
    'auth'=>true,
);

$add_css = '';
$puc = \YES4Trade\Model\product_un_classification::get_by_products_id(intval($pInfo->products_id));
if($puc !== null and $puc->un_classifications_id > 0){
	$add_css = 'ui-state-highlight';
}
$buttons[] = array(
	'text'=>UN_CLASSIFACTIONS,
	'link'=>xtc_href_link('categories.php',xtc_get_all_get_params(['action','pID']).'action=un_classifications&pID='.$pInfo->products_id),
	'lbOn'=>true,
	'auth'=>true,
	'add_css_class'=>$add_css
);



if(defined('MODULE_OTHER_YES_HITMEISTER_API_STATUS') and MODULE_OTHER_YES_HITMEISTER_API_STATUS == 'True'){
    if(!yes_hitmeister::is_hitmeister_product($pInfo->products_id)){
        $ref = urlencode(xtc_href_link('categories.php',xtc_get_all_get_params()));
        $buttons[] = array( 
            'text'=>'Real Export',
            'link'=>xtc_href_link('hitmeister.php','action=import_yes_product&products_id='.$pInfo->products_id.'&referrer='.$ref),
            'lbOn'=>true,
            'auth'=>true,
        );
    }else{
        $smarty->assign('HITMEISTER_ID_ITEM',yes_hitmeister::get_id_item_from_products_id($pInfo->products_id));
    }
}



$product->load_shipping_extra_charges();
$input_extra_charges = array();
foreach(main::get_shipping_graduation_groups() as $sg){
    $default_extra_charge = '';
    foreach($product->shipping_extra_charges as $sec){
        if($sec->shipping_graduation_groups_id == $sg['id']){
            $default_extra_charge = number_format($sec->shipping_extra_charge,2,',','');
            break;
        }
    }
    $input_extra_charges[] = array(
        'input'=> xtc_draw_input_field('shipping_extra_charges['.$sg['id'].']',$default_extra_charge,'class="defaultText" size="8" maxlength="8" title="0,00"'),
        'text'=>$sg['text'],
        'info'=>implode(', ',main::get_shipping_graduation_groups_countries($sg['id']))
    );
}
$smarty->assign('SHIPPING_EXTRA_CHARGES', $input_extra_charges);
if(defined('YES_PAYMODULE_PRODUCTS_FAKE_SETS') and YES_PAYMODULE_PRODUCTS_FAKE_SETS == 'True'){
    $fields = $product->get_fake_sets();
    $fake_fields_num = 0;
    $fake_set_link_text = YES_PAYMODULE_PRODUCTS_FAKE_SETS_BUTTON_EDIT;
    if(sizeOf($fields)){
	for($i=1;$i<=5;$i++){
	    if(!empty($fields['artnr_'.$i]) and $fields['qty_'.$i] != 0){
		$fake_fields_num++;
	    }
	}
	if($fake_fields_num > 0){
	    $fake_set_link_text .= ' ('.$fake_fields_num.')';
	}
    }
    $smarty->assign('FAKE_SET_LINK',  yes_draw_href_link(
	$fake_set_link_text, 
	xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action')).'action=fake_sets'), 
	'lbOn', '', 'fakesetlink', true
    ));
}


$qty_info = '';
if($pInfo->collies_num == 0){
    $qty_info .= sprintf('<b>%s:</b> %s |%s ',TEXT_QTY_STAMMLAGER,$pInfo->products_quantity,$pInfo->qty_hidden);
    $qty_info .= sprintf('<b title="%s">%s:</b> %s | ',TEXT_QTY_AV1,TEXT_QTY_AV1_SHORT,$SQ->get_available1_qty());
    $qty_info .= sprintf('<b title="%s">%s:</b> %s',TEXT_QTY_AV2,TEXT_QTY_AV2_SHORT,$SQ->get_available2_qty());
}else{
    $qty_info .= sprintf('<b>%s:</b> %s',TEXT_QTY_STUECKLISTEN,$pInfo->products_quantity);
}

if(defined('PRICE_IS_BRUTTO') and PRICE_IS_BRUTTO == 'true'){
    $tax_rate = xtc_get_tax_rate($pInfo->products_tax_class_id);
    $uvp_value = xtc_oe_get_price_i_tax($pInfo->uvp, $tax_rate);
}else{
    $uvp_value = $pInfo->uvp;
}

$disable_cron_update_products_status = (isset($pInfo->disable_cron_update_products_status) and $pInfo->disable_cron_update_products_status == 1) ? true : false;
$cat_parts = (isset($_GET['cPath'])) ? explode('_',$_GET['cPath']) : array();
$current_cat = 'TOP';
foreach($cat_parts as $cat_part){
    $current_cat = xtc_get_categories_name($cat_part);
}
$heading_title_addon = '';

$p2c_query = xtc_db_query(sprintf(
        "SELECT categories_id FROM products_to_categories WHERE products_id='%s'",
        $pInfo->products_id
));
if(xtc_db_num_rows($p2c_query)>1){
    if($pInfo->default_category < 1){
        $heading_title_addon = '&nbsp;'.xtc_image('images/basicons/link61.png',TEXT_PRODUCT_HAS_MULTIPLE_CATEGORIES,20,20);
    }
}
$path = xtc_output_generated_category_path($pInfo->products_id, 'product',true);
$path = sprintf('<a href="%s" style="font-size:14px; font-family: arial,helvetica,sans-serif;color:#000000;">TOP</a>%s %s',
        xtc_href_link(FILENAME_CATEGORIES),
        ($path != '') ? ' &gt; ' : '',
        $path
);

$smarty->assign(array(
    'BREADCRUMB'=>$path,
    'SAVE_BUTTON'=>xtc_image_button('button_save.gif', IMAGE_SAVE),
    'SAVE_LINK'=>'javascript:document.forms[\'new_product\'].submit();',
    'CANCEL_LINK'=>xtc_href_link(FILENAME_CATEGORIES, 'cPath=' . $cPath . '&pID=' . $pInfo->products_id),
    'CANCEL_BUTTON'=>xtc_image_button('button_cancel.gif', IMAGE_CANCEL),
    'FORM'=>xtc_draw_form('new_product', FILENAME_CATEGORIES, 'cPath=' . $_GET['cPath'] . '&pID=' . $pInfo->products_id . '&action='.$form_action, 'post', 'onsubmit="return submitCheck();"'),
    'FORM_END'=>'</form>',
    'PAGE_HEADING'=>sprintf(PAGE_HEADING_PREFIX_NEW_PRODUCT,$current_cat,$pInfo->products_id).$heading_title_addon,
    'action'=>$_GET['action'],
    'JS_CONFIRM_REALLY_DELETE_CSET'=>JS_CONFIRM_REALLY_DELETE_CSET,
    'CSET_DELETE_BASELINK'=>xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action')).'action=delete_cset'),
    'LINK_PRODUCTS_STORAGE_SORT'=>xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action')).'action=products_storage_sort'),
    'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
    'SAVED_CONDITIONS_BASELINK'=>xtc_href_link(FILENAME_CATEGORIES,'action=saved_conditions&lID='),
    'EXT_POPUP_WIDTH'=>EXT_POPUP_WIDTH,
    'EXT_POPUP_HEIGHT'=>EXT_POPUP_HEIGHT,
    'TEXT_PRODUCTS_SIZE'=>TEXT_PRODUCTS_SIZE,
    'TEXT_SHOW_PRODUCT_IN_SHOP'=>TEXT_SHOW_PRODUCT_IN_SHOP,
    'TEXT_DEFAULT_CATEGORY'=>TEXT_DEFAULT_CATEGORY,
    'ADDITIONAL_TITLE'=>$additional_title,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'qty_info'=>$qty_info,
    'TEXT_PACKAGING_COSTS'=>TEXT_PACKAGING_COSTS,
    'INPUT_UVP'=>xtc_draw_input_field('uvp',number_format($uvp_value,2,',',''),'size="8" maxlength="10"'),
    'TEXT_DISABLE_PRODUCT_FROM_CRON_UPDATE_PRODUCTS_STATUS'=>TEXT_DISABLE_PRODUCT_FROM_CRON_UPDATE_PRODUCTS_STATUS,
    'INPUT_DISABLE_PRODUCT_FROM_CRON_UPDATE_PRODUCTS_STATUS'=>  xtc_draw_checkbox_field('disable_cron_update_products_status','1',$disable_cron_update_products_status),
    'TEXT_PRODUCTS_CONTENT_FILES'=>TEXT_PRODUCTS_CONTENT_FILES,
    'TEXT_PRODUCTS_CONTENT_FILES_ADD_LINK'=>TEXT_PRODUCTS_CONTENT_FILES_ADD_LINK,
    'TEXT_PRODUCTS_CONTENT_FILES_DELETE_CONFIRM'=>TEXT_PRODUCTS_CONTENT_FILES_DELETE_CONFIRM,
    'PRODUCTS_CONTENT'=>$product->get_products_content($_SESSION['languages_id']),
    'JS_CONFIRM_REALLY_UPDATE_CART_TITLES'=>JS_CONFIRM_REALLY_UPDATE_CART_TITLES,
    'JS_CONFIRM_REALLY_UPDATE_CART_EAN'=>JS_CONFIRM_REALLY_UPDATE_CART_EAN,
    'BUTTON_IMAGES_UPLOAD'=>BUTTON_IMAGES_UPLOAD,
    'SAMMEL_UPLOAD_LINK'=>xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action')).'action=images_upload'),
    'TEXT_DRAG_AND_DROP_PRODUCTS_IMAGES_SORT'=>TEXT_DRAG_AND_DROP_PRODUCTS_IMAGES_SORT,
    'TEXT_PRODUCTS_IMAGES_DOWNLOAD'=>TEXT_PRODUCTS_IMAGES_DOWNLOAD,
    'TEXT_DRAG_AND_DROP_PRODUCTS_IMAGES_SORT_INTRO'=>TEXT_DRAG_AND_DROP_PRODUCTS_IMAGES_SORT_INTRO,
    'DELETE_IMAGES_LINK'=>xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action')).'action=delete_images'),
    'BUTTON_DELETE_IMAGES'=>BUTTON_DELETE_IMAGES,
	'CROSS_SELLINGS'=>$product->get_cross_selling_allocations(),
	'TEXT_SHOW_ALL'=>TEXT_SHOW_ALL,
));
if(defined('PAY_MODULE_MARGE') and PAY_MODULE_MARGE == 'True'){
    $smarty->assign('INPUT_PACKAGING_COSTS',xtc_draw_input_field('packaging_costs',number_format($pInfo->packaging_costs,2,',',''),'size="8" maxlength="10"'));
}
if(isset($smarty->secure_dir)){
    $smarty->secure_dir[] = DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/';
}
$html = $smarty->fetch(DIR_FS_ADMIN.'templates/new_product.html');
echo $html;
