<?php
/* --------------------------------------------------------------
   $Id: orders_edit.php,v 1.0

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   XTC-Bestellbearbeitung:
   http://www.xtc-webservice.de / Matthias Hinsche
   info@xtc-webservice.de

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(orders.php,v 1.27 2003/02/16); www.oscommerce.com 
   (c) 2003	 nextcommerce (orders.php,v 1.7 2003/08/14); www.nextcommerce.org

   Released under the GNU General Public License 

   To do: Erweitern auf Artikelmerkmale, Rabatte und Gutscheine
   --------------------------------------------------------------*/

require_once(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');

// ERMITTELN VERSANDKOSTEN
$order = new order( xtc_db_input( $_GET['oID'] ) );
$xtPrice = $order->get_price_instance();
$gesamtsumme = 0;
foreach($order->totals as $k=>$v){
    if($v['class'] == 'ot_total'){
        $gesamtsumme = $v['value'];
    }
    if($v['class'] == 'ot_shipping'){
        $versandsumme = $v['value'];
    }
}
$country = $order->delivery['country'];
$order->delivery['country'] = array();
$order->delivery['country']['name'] = $country;
$order->delivery['country']['id'] = $order->delivery['country_id'];
$order->delivery['country']['iso_code_2'] = $order->delivery['iso_code_2'];

$total_weight = $order->show_weight();
$total_count = $order->count_contents();

if (defined('MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING') && (MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING == 'true')) {
	switch (MODULE_ORDER_TOTAL_SHIPPING_DESTINATION) {
		case 'national' :
			if ($order->delivery['country_id'] == STORE_COUNTRY)
				$pass = true;
			break;
		case 'international' :
			if ($order->delivery['country_id'] != STORE_COUNTRY)
				$pass = true;
			break;
		case 'both' :
			$pass = true;
			break;
		default :
			$pass = false;
			break;
	}

	$free_shipping = false;
	if (($pass == true) && (($gesamtsumme - $versandsumme) >= MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER ) ) {
            $free_shipping = true;
            include (DIR_WS_LANGUAGES.$_SESSION['language'].'/modules/order_total/ot_shipping.php');
	}
} else {
	$free_shipping = false;
}

if(!isset($_POST['method'])) {
    $_class = current(explode('_',$order->info['shipping_class']));
    $_class = $_class.'.php';
    for($i=0;$i<sizeOf($shipping_modules->modules);$i++){
        if($shipping_modules->modules[$i] == $_class)
            $shipping_method = $_class;
    }
    if(!$shipping_method){
        $shipping_method = $shipping_modules->modules[0];
    }
}else{
    $shipping_method = $_POST['method'];
}
$shipping_methods = array();
for($i=0;$i<sizeOf($shipping_modules->modules);$i++){
    $shipping_methods[] = array('id'=>$shipping_modules->modules[$i],'text'=>$shipping_modules->modules[$i]);
}
if ((xtc_count_shipping_modules() > 0) || ($free_shipping == true)) {
    $ship_class = current(explode('.php',$shipping_method));
    $_shipping = $ship_class.'_'.$ship_class;
    list ($module, $method) = explode('_', $_shipping);
    if (is_object($$module) || ($_shipping == 'free_free')) {
        if ($_shipping == 'free_free') {
            $quote[0]['methods'][0]['title'] = FREE_SHIPPING_TITLE;
            $quote[0]['methods'][0]['cost'] = '0';
        } else {
            $quote = $shipping_modules->quote($method, $module);
        }
        if (isset ($quote['error'])) {
            unset ($_SESSION['shipping']);
        } else {
            if ((isset ($quote[0]['methods'][0]['title'])) && (isset ($quote[0]['methods'][0]['cost']))) {
                // EU-OSS 2021/07
                $tax_class_id = $order->get_shipping_tax_class();
                
                $price = $xtPrice->xtcFormat($quote[0]['methods'][0]['cost'],$format=false,$tax_class_id,$curr=false);
                $_SESSION['shipping'] = array (
                    'id' => $_SESSION['shipping'],
                    'title' => (($free_shipping == true) ? $quote[0]['methods'][0]['title'] : $quote[0]['module'].' ('.$quote[0]['methods'][0]['title'].')'), 
                    'cost' => $price
                );
            }else{
                unset ($_SESSION['shipping']);
            }
        }
    } else {
        unset ($_SESSION['shipping']);
    }
} else {
    $_SESSION['shipping'] = false;
}
$session_shipping = $_SESSION['shipping'];
?>


<script>
<!--
function insert_calculated_costs(shipping_class,costs,title){
	document.forms['shipping_ins'].title.value=title;
	document.forms['shipping_ins'].value.value=costs;
	document.forms['shipping_ins'].shipping_class.value=shipping_class;
}

//-->
</script>
<style>
    table#set_versender_table{
        margin-top: 15px;
        width: 100%;
    }
</style>

<!-- YES ADDON - VERSENDER WAEHLEN START //-->
<table border="0" class="yesListTable_minimal" id="set_versender_table">
<?php
echo xtc_draw_form('set_versender', FILENAME_ORDERS_EDIT, 'action=set_versender', 'post');
echo xtc_draw_hidden_field('cID', $_GET['cID']);
echo xtc_draw_hidden_field('oID', $_GET['oID']);
?>
    <tbody>
        <tr>
                <td width="100%">

                &nbsp;<b>Versenderprofil Vorgabe</b>:
                <?php
                echo xtc_draw_pull_down_menu('versender',
                    \YES4Trade\Model\shipper_profiles::get_selection_list(),
                    $order->info['versender']
                );
                echo '&nbsp;'.\YES4Trade\Model\shipper_profiles::get_crud_link();
                echo '&nbsp;'.xtc_draw_input_field('saveit',ORDERS_EDIT_SHIPPING_SET_VERSENDER,'class="ui-button ui-corner-all ui-state-default"','','submit');
                ?>
                </td>
        </tr>
    </tbody>
</form>
</table>
<br />
<!-- YES ADDON - VERSENDER WAEHLEN ENDE//-->


<!-- Versandkostenbearbeitung Anfang //-->
<?php

if(defined('MODULE_ORDER_TOTAL_SHIPPING_STATUS') and MODULE_ORDER_TOTAL_SHIPPING_STATUS == 'true'){
    // komischerweise wird das hier bei aktiviertem real modul durch die
    // admin/includes/classes/yes_hitmeister.php geladen. Sei es drum, hier auch
    // nochmal manuell includet - 2021/03
    require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/order_total/ot_shipping.php');
    
    if(defined('MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER') and MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER > 0){
        printf('<div class="ui-state-highlight" style="margin-bottom: 15px;"><h3>%s: %s %s (%s)</h3></div>',
                MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER_TITLE,
            number_format( (float) MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER,2,',','.'),
            DEFAULT_CURRENCY,
            MODULE_ORDER_TOTAL_SHIPPING_DESTINATION
        );
    }
}
$saved_shipping_costs = [];
$shipping_query = xtc_db_query(sprintf(
    "select * from %s where orders_id = '%d' and class = 'ot_shipping' ",
    TABLE_ORDERS_TOTAL, $order->info['id']
));
while($shipping = xtc_db_fetch_array($shipping_query)) {
    $saved_shipping_costs[] = $shipping;
}
if(sizeOf($saved_shipping_costs)){
?>
&nbsp;<span class="smallText"><?php printf(ORDERS_EDIT_SHIPPING_COST_INFO,$order->info['shipping_class']);?></span><br />
<?php
echo xtc_draw_form('shipping_edit', FILENAME_ORDERS_EDIT, 'action=shipping_edit', 'post');
echo xtc_draw_hidden_field('cID', $_GET['cID']);
echo xtc_draw_hidden_field('oID', $_GET['oID']);
?>
<table border="0" class=""yesListTable_minimal">
    <thead>
        <tr>
            <th><?php echo TEXT_SAVED_SHIPPING_COSTS;?></th>
            <th><?php echo TEXT_VALUE;?></th>
            <th>&nbsp;</th>
        </tr>
    </thead>
    <tfoot>
        <tr>
            <th colspan="3" align="left"><input type="submit" value="<?php echo IMAGE_SAVE; ?>" class="ui-button ui-corner-all ui-state-default" /></th>
        </tr>
    </tfoot>
    <tbody>
<?php
    foreach($saved_shipping_costs as $shipping){
	if ($shipping['value'] !=''){
?>
	<tr>
<?php
	echo xtc_draw_hidden_field('otID[]', $shipping['orders_total_id']);
?>
		<td><?php echo xtc_draw_input_field('title[]', $shipping['title'], 'size="40"');?></td>
		<td><input type="text" name="value[]" value="<?php echo $shipping["value"];?>" size="10" /></td>
		<td><input type="button" onclick="window.location.href='<?php echo xtc_href_link(FILENAME_ORDERS_EDIT,'action=shipping_del&cid='.$_GET['cID'].'&oID='.$_GET['oID'].'&otID='.$shipping['orders_total_id']);?>';" class="ui-button ui-corner-all ui-state-highlight" value="<?php echo IMAGE_DELETE; ?>" /></td>
	</tr>
<?php 
	}
    } 
?>
    </tbody>
</table>
</form>
<?php
} // end if size of saved_shipping_costs
?>
<br>
<table border="0" width="100%">
<tr>
	<td align="right">
            <div class="ui-widget-content" style="width: 500px; padding: 10px;">
                <b><?php echo ORDERS_EDIT_SHIPPING_COSTS_CALCULATOR; ?></b><br />
<?php
echo xtc_draw_form('method_select','orders_edit.php',xtc_get_all_get_params());
echo ORDERS_EDIT_SHIPPING_VERSANDMODUL.': '.xtc_draw_pull_down_menu('method',$shipping_methods,$shipping_method,'onChange="this.form.submit();"');
echo '</form>';
if($session_shipping){
    
?>
                <table border="0" class="yesListTable_minimal">
                    <thead>
                        <tr>
                            <th><?php echo TEXT_TITLE; ?></th>
                            <th><?php echo $session_shipping['title']; ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><b><?php echo ORDERS_EDIT_SHIPPING_VERSANDMODUL_COSTS; ?></b></td>
                            <td><?php echo number_format($session_shipping['cost'],2,',','.'); ?>
                                &nbsp;&nbsp;<a href="javascript:insert_calculated_costs('<?php echo $session_shipping['id']; ?>',<?php echo $session_shipping['cost']; ?>,'<?php echo str_replace("'",'"',$session_shipping['title']); ?>');"><u><?php echo ORDERS_EDIT_SHIPPING_VERSANDMODUL_COSTS_ADD; ?></u></a>
                            </td>
                        </tr>   
                    </tbody>
                </table>
<?php
}else{
?>
    <p class="errorText"><?php echo ORDERS_EDIT_SHIPPING_VERSANDMODUL_COSTS_ADD_ERROR; ?></span></p>
<?php
}
?>
            </div>
	</td>
    </tr>
</table>
<br />
<?php
echo xtc_draw_form('shipping_ins', FILENAME_ORDERS_EDIT, 'action=shipping_ins', 'post');
echo xtc_draw_hidden_field('cID', $_GET['cID']);
echo xtc_draw_hidden_field('oID', $_GET['oID']);
echo xtc_draw_hidden_field('shipping_class', $order->info['shipping_class']);
?>
<table border="0" class="yesListTable_minimal" style="margin-bottom: 20px;">
    <thead>
        <tr>
            <th width="20%">&nbsp;</th>
            <th width="40%"><?php echo TEXT_SHIPPING . '&nbsp;' . TEXT_DESC;?></th>
            <th width="10%"><?php echo TEXT_VALUE;?></th>
            <th width="20%">&nbsp;</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td><?php echo TEXT_INS;?></td>
            <td><?php echo xtc_draw_input_field('title', '', 'size="50"');?></td>
            <td><input type="text" name="value" size="8"></td>
            <td>
                <input type="submit" value="<?php echo TEXT_INS; ?>" class="ui-button ui-corner-all ui-state-default" />
            </td>
        </tr>
    </tbody>
</table>
</form>

<!-- Versandkostenbearbeitung Ende //-->


<!-- Nachnahmebearbeitung Anfang //-->
<?php
if(defined('MODULE_ORDER_TOTAL_COD_STATUS')){
    $cod_status = constant('MODULE_ORDER_TOTAL_COD_STATUS');
}else{
    $cod_status = 'false';
}

if ($cod_status == 'true'){
    $cod_query = xtc_db_query("select * from " . TABLE_ORDERS_TOTAL . " where orders_id = '" . $_GET['oID'] . "' and class = 'ot_cod_fee' ");
    $cod = xtc_db_fetch_array($cod_query);
    if ($cod['value'] !=''){
?>
<table border="0" class="yesListTable_minimal" style="margin-bottom: 20px;">
    <thead>
        <tr>
            <th width="40%"><?php echo TEXT_SAVED_COD_COSTS;?></th>
            <th width="10%"><?php echo TEXT_VALUE;?></th>
            <th width="10%"><?php echo TEXT_TAX;?></th>
            <th width="20%">&nbsp;</th>
            <th width="20%">&nbsp;</th>
        </tr>
    </thead>        
    <tbody>
<?php
        echo xtc_draw_form('cod', FILENAME_ORDERS_EDIT, 'action=cod_edit', 'post');
        echo xtc_draw_hidden_field('cID', $_GET['cID']);
        echo xtc_draw_hidden_field('oID', $_GET['oID']);
        echo xtc_draw_hidden_field('otID', $cod['orders_total_id']);
?>
        <tr>
            <td><?php echo xtc_draw_input_field('title', $cod['title'], 'size="50"');?></td>
            <td><input type="text" name="value" value="<?php echo $cod['value']; ?>" size="10"></td>
            <td><?php echo xtc_draw_input_field('tax', ORDERS_EDIT_TAX_VALUE, 'size="10"');?></td>
            <td>
                <input type="submit" value="<?php echo IMAGE_SAVE; ?>" class="ui-button ui-corner-all ui-state-default" />
            </td>
            </form>
            <td>
<?php
                echo xtc_draw_form('cod_del', FILENAME_ORDERS_EDIT, 'action=cod_del', 'post');
                echo xtc_draw_hidden_field('cID', $_GET['cID']);
                echo xtc_draw_hidden_field('oID', $_GET['oID']);
                echo xtc_draw_hidden_field('otID', $cod['orders_total_id']);
                printf('<input type="submit" value="%s" class="ui-button ui-corner-all ui-state-highlight" />',
                        IMAGE_DELETE
                );
?>
                </form>
            </td>
        </tr>
    </tbody>
</table>

<?php } ?>


<table border="0" class="yesListTable_minimal" style="margin-bottom: 20px;">
    <thead>
        <tr>
            <th width="20%">&nbsp;</th>
            <th width="40%"><?php echo TEXT_COD_COSTS  . '&nbsp;' . TEXT_DESC;?></th>
            <th width="10%"><?php echo TEXT_VALUE;?></th>
            <th width="10%"><?php echo TEXT_TAX;?></th>
            <th width="20%">&nbsp;</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td><?php echo TEXT_INS;?></td>
            <?php
            echo xtc_draw_form('cod_ins', FILENAME_ORDERS_EDIT, 'action=cod_ins', 'post');
            echo xtc_draw_hidden_field('cID', $_GET['cID']);
            echo xtc_draw_hidden_field('oID', $_GET['oID']);
            ?>
            <td><?php echo xtc_draw_input_field('title', '', 'size="50"');?></td>
            <td><input type="text" name="value" size="10"></td>
            <td><?php echo xtc_draw_input_field('tax', ORDERS_EDIT_TAX_VALUE, 'size="10"');?></td>
            <td>
                <input type="submit" value="<?php echo TEXT_INS; ?>" class="ui-button ui-corner-all ui-state-default" />
            </td>
            </form>
        </tr>
    </tbody>
</table>

<br>
<?php } ?>
<!-- Nachnahmebearbeitung Ende //-->
