<?php
/* -----------------------------------------------------------------------------------------
   $Id: print_packingslip.php,v 1.45 2017/06/28 14:23:30 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2003	 nextcommerce (print_order.php,v 1.1 2003/08/19); www.nextcommerce.org
   
   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

  require('includes/application_top.php');
  // include needed functions
  require_once(DIR_FS_INC .'xtc_get_orders_ebay_seller.inc.php');
  require_once(DIR_FS_INC .'xtc_get_ebay_seller_data.inc.php');
  require_once(DIR_FS_INC .'xtc_serials.inc.php');
  require_once(DIR_FS_INC .'xtc_get_order_data.inc.php');
  require_once(DIR_FS_INC .'xtc_not_null.inc.php');
  require_once(DIR_FS_INC .'xtc_format_price_order.inc.php');
  require_once(DIR_FS_INC .'xtc_get_short_description.inc.php');
  
  if(BARCODE_PACKINGSLIP_ACTIVE == 'True'){
	require_once(DIR_FS_INC .'xtc_generate_packingslip_barcode.inc.php');
  }

  $smarty = new yesSmarty;

  $order_query_check = xtc_db_query("SELECT
  					customers_id
  					FROM ".TABLE_ORDERS."
  					WHERE orders_id='".(int)xtc_db_input($_GET['oID'])."'");
  					
  $order_check = xtc_db_fetch_array($order_query_check);
 // if ($_SESSION['customer_id'] == $order_check['customers_id'])
  //	{
  	// get order data
 	
include(DIR_WS_CLASSES . 'order.php');
$order = new order((int)xtc_db_input($_GET['oID']));
$order->info = xtc_db_prepare_input($order->info);
$xtPrice = new xtcPrice($order->info['currency'],$order->info['status']);
if(BARCODE_PACKINGSLIP_ACTIVE == 'True'){
	$smarty->assign('BARCODE',xtc_generate_packingslip_barcode((int)xtc_db_input($_GET['oID'])));
}
$smarty->assign('address_label_customer',xtc_address_format($order->customer['format_id'], $order->customer, 1, '', '<br>'));
$smarty->assign('address_label_shipping',xtc_address_format($order->delivery['format_id'], $order->delivery, 1, '', '<br>'));
$smarty->assign('address_label_payment',xtc_address_format($order->billing['format_id'], $order->billing, 1, '', '<br>'));

$smarty->assign('csID',$order->customer['csID']);
$smarty->assign(array(
    'COMMENTS_VISIBLE'=>$order->info['comments_visible'],
    'SHIPPING_COMMENTS'=>$order->info['shipping_comments']
));
// get products data
$order->add_history(intval($order->info['orders_status']),0,'Lieferschein ausgedruckt');

foreach($order->totals as $ko=>$kv){
    if(strstr($kv['class'],'shipping')){
        $smarty->assign('shippingcosts',$kv['text']);
    }
}

if($order->info['orders_status'] == ORDERS_STATUS_STORNIERT){
	$smarty->assign('IS_STORNO','1');
}


// ALLE TELEFONDATEN
$tel_query = xtc_db_query("SELECT c.mobile,c.customers_telephone,c.customers_fax FROM customers c, orders o WHERE c.customers_id='".$order->customer['ID']."'");
$tel = xtc_db_fetch_array($tel_query);
if($tel['mobile'] != '')
	$smarty->assign('C_MOBILE',$tel['mobile']);
if($tel['customers_telephone'] != '')
	$smarty->assign('C_TEL',$tel['customers_telephone']);
if($tel['customers_fax'] != '')
	$smarty->assign('C_FAX',$tel['customers_fax']);
if($order->customer['telephone'] != '')
	$smarty->assign('O_TEL',$order->customer['telephone']);
if($order->customer['mobile'] != '')
	$smarty->assign('O_MOBILE',$order->customer['mobile']);

$order_data=array();
$weight_total = 0;
$has_teillieferung = false;
$has_not_ship = false;
$order->products = xtc_db_prepare_input($order->products);
foreach($order->products as $order_data_values){
    if(!isset($_REQUEST['all_products'])){
	    if($order_data_values['not_ship'] > 0){
		    $has_not_ship = true;
	    }
	    $print_qty = $order_data_values['qty']-$order_data_values['quantity_shipped']-$order_data_values['not_ship'];
	    if($print_qty < 1){
		    continue;
	    }
    }else{
	$print_qty = $order_data_values['qty'];
    }

    $weight = xtc_get_ext_products_weight($order_data_values['id']);
    $weight_total += $weight*$print_qty;

    $collies = xtc_get_product_collies($order_data_values['id']);
    $name = $order_data_values['name'];
    $pcollies = array();
    if(sizeOf($collies)>0){
	    $name = '<b>[C]</b>&nbsp;'.$name;
	    $collie_string  = '<table border="0" cellspacing="1" cellpadding="1">';
	    $collie_string .= '<tr><td colspan="4">'.xtc_image('images/pixel_trans.gif','',1,3).'</td></tr>';
	    $collie_string .= '<tr><td><font size=1><b>[C]</b></font></td><td colspan="2"><font size=1><b>Dieses Produkt enth&auml;lt die folgenden Collis:</b></font></td><td align=right><font size=1><b>pID/Art.-Nr.</b></font></td></tr>';
	    foreach($collies as $k=>$collie){
		    // ARTIKELNR DER COLLIS
		    $art_nr_query = xtc_db_query("SELECT products_model FROM products WHERE products_id='".$collie['collie_products_id']."'");
		    $art_nr = xtc_db_fetch_array($art_nr_query);
		    if(xtc_not_null($art_nr['products_model']))
			    $model = ' <font color=green>'.xtc_db_prepare_input($art_nr['products_model']).'</font> ';
		    else
			    $model = '';
		    $collie_string .= '<tr><td><font size=1>&nbsp;</font></td><td align="right" width=5><font size=1>'.($collie['quantity']*$print_qty).'x</font></td><td><a style="font-size:10px;" href="'.xtc_href_link('categories.php','pID='.$collie['collie_products_id'].'&action=new_product&cPath='.xtc_get_path($collie['collie_products_id'])).'"><u>'.substr(xtc_get_products_name($collie['collie_products_id']),0,45).'</a></td><td class="smallText" align="right"><a style="font-size:10px;" href="'.xtc_href_link('categories.php','pID='.$collie['collie_products_id'].'&action=new_product&cPath='.xtc_get_path($collie['collie_products_id'])).'"><u><font size=1>'.$collie['collie_products_id'].' / '.$model.'</font></u></a></td></tr>';
	    }
	    $collie_string .= '</table>';
    }else{
	    $collie_string = '';
    }

    // LAGERPLAETZE
    $storage_str = '';
    if(in_array($order->info['orders_status'],array(ORDERS_STATUS_VERSENDET, ORDERS_STATUS_ABGESCHLOSSEN))){
	    $transfer_places = $order->get_transferred_places($order_data_values['id'],'Versand');
    }else{
	    $transfer_places = array();
    }
    if(sizeOf($transfer_places)){
	    foreach($transfer_places as $tp){
		$tp = xtc_db_prepare_input($tp);
		    $storage_str .= sprintf('<br />Lager &raquo;%s&laquo; / Lagerplatz &raquo;%s&laquo;: %s Stk.',
			    $tp['name'],$tp['storage_place'],$tp['quantity']
		    );
	    }
    }else{
	    $storages = array();
	    if(sizeOf($collies)>0){
		    foreach($collies as $ck=>$collie){
			    $storage_query = xtc_db_query("SELECT s.name,sp.storage_places_id,sn.nummer FROM storage_products sp LEFT JOIN storage_numbers sn USING(storage_id,products_id),storages s WHERE sp.products_id='".$collie['collie_products_id']."' and sp.storage_id=s.id");
			    while($storage = xtc_db_prepare_input(xtc_db_fetch_array($storage_query))){
				if($storage['storage_places_id'] > 0){
				    $storage['storage_place'] = yes_get_storage_place_title($storage['storage_places_id']);
				}
				    $storage['name'] = '(Colli aus pID '.$collie['collie_products_id'].') '.$storage['name'];
				    $storages[] = xtc_db_prepare_input($storage);
			    }
		    }
	    }else{
		    $storage_query = xtc_db_query("SELECT s.name,sp.storage_places_id,sn.nummer FROM storage_products sp LEFT JOIN storage_numbers sn USING(storage_id,products_id),storages s WHERE sp.products_id='".$order_data_values['id']."' and sp.storage_id=s.id");
		    while($storage = xtc_db_fetch_array($storage_query)){
			    if($storage['storage_places_id'] > 0){
				$storage['storage_place'] = yes_get_storage_place_title($storage['storage_places_id']);
			    }
			    $storages[] = xtc_db_prepare_input($storage);
		    }
	    }
	    if(sizeOf($storages)>0){
		    $storage_str = '<table border="0" cellpadding="2" cellspacing="2">';
		    foreach($storages as $sk=>$storage){
			    $storage_str .= '<tr>';
			    $storage_str .= '	<td colspan="2" class="smallText"><font size="1" face="Verdana, Arial, Helvetica, sans-serif"><b>Lager '.$storage['name'].'</b></font></td>';
			    $storage_str .= '</tr><tr>';
			    $storage_str .= '	<td class="smallText"><font size="1" face="Verdana, Arial, Helvetica, sans-serif">'.$storage['storage_place'].'</font></td>';
			    $storage_str .= '	<td class="smallText"><font size="1" face="Verdana, Arial, Helvetica, sans-serif">'.$storage['nummer'].'</font></td>';
			    $storage_str .= '</tr>';
		    }
		    $storage_str .= '</table>';
	    }
    }

    $order_data[]=array(
	    'PRODUCTS_STORAGES'=>$storage_str,
	    'PRODUCTS_MODEL' => $order_data_values['model'],
	    'PRODUCTS_NAME' => $name.$collie_string,
	    'PRODUCTS_WEIGHT'=>number_format($weight,4,',','.').'kg',
	    'PRODUCTS_WEIGHT_SUM'=>number_format(($weight*$print_qty),4,',','.').'kg',
	    'PRODUCTS_PRICE' =>  xtc_format_price_order($order_data_values['final_price'],1,$order->info['currency']),
	    'PRODUCTS_QTY' => $print_qty
    );
} // end foreach products
$smarty->assign('PART_ORDER',$order->has_part_delivery());
if($has_not_ship){
	$smarty->assign('NOT_SHIP_PRODUCTS',1);
}


    // get order_total data
    $oder_total_query=xtc_db_query("SELECT
	    title,
	    text,
	    class,
	    value,
	    sort_order
	    FROM ".TABLE_ORDERS_TOTAL."
	    WHERE orders_id='".(int)xtc_db_input($_GET['oID'])."'
	    ORDER BY sort_order ASC"
    );

    $order_total=array();
    while ($oder_total_values = xtc_db_prepare_input(xtc_db_fetch_array($oder_total_query))) {
	    $order_total[]=array(
		    'TITLE' => $oder_total_values['title'],
		    'CLASS'=> $oder_total_values['class'],
		    'VALUE'=> $oder_total_values['value'],
		    'TEXT' => $oder_total_values['text']
	    );
	    if ($oder_total_values['class']='ot_total') $total=$oder_total_values['value'];
    }

	
// assign language to template for caching
$smarty->assign('STORE',nl2br(STORE_NAME_ADDRESS));
$smarty->assign('BANK', MODULE_PAYMENT_MONEYORDER_PAYTO);
$smarty->assign('language', $_SESSION['language']);
$smarty->assign('logo_path',HTTP_SERVER  . 'templates/'.CURRENT_TEMPLATE.'/img/');
$smarty->assign('oID',$_GET['oID']);
$smarty->assign('cID',$order->customer['ID']);
$smarty->assign('YESORDER',xtc_db_prepare_input($order->get_order_positions()));
  
$ebay_seller = xtc_get_orders_ebay_seller((int)xtc_db_input($_GET['oID']));
if($ebay_seller != ''){
    $smarty->assign('EBAY_SELLER_DATA',xtc_get_ebay_seller_data($ebay_seller));
    $smarty->assign('EBAY_ID',$order->info['ebay_id']);
}


$ebay_id_array = array();
$o_ebayid = '';
if($order->info['is_parent'] == 'y'){
	$all_ebay_query = xtc_db_query("SELECT ebay_id FROM orders WHERE parent_orders_id='".(int)xtc_db_input($_GET['oID'])."'");
	while($all_ebay = xtc_db_fetch_array($all_ebay_query)){
		$o_ebayid .= $all_ebay['ebay_id'].', ';
		$ebay_id_array[] = $all_ebay['ebay_id'];
	}
	$o_ebayid = substr($o_ebayid,0,(strlen($o_ebayid)-2));
}else{
	$o_ebayid .= $order->info['ebay_id'];
	$ebay_id_array = $order->ebay_id_array;
}

// UM AUKTIONEN SEPARAT ANZUZEIGEN
if(is_countable($ebay_id_array) and sizeOf($ebay_id_array)>0){
	$smarty->assign(array(
            'auctions'=>$ebay_id_array,
            'EBAY_ID_ARRAY'=>$ebay_id_array,
            'EBAY_PLUS'=>$order->info['ebay_plus']
        ));
        
}


$smarty->assign('PAYMENT_METHOD',$order->info['payment_method']);
$smarty->assign(array(
	    'DATE'=>xtc_date_short($order->info['date_purchased']),
	    'SOURCE'=>$order->get_source()
));
if($order->info['date_shipping'] > 0)
	$smarty->assign('DATE_SHIPPING',xtc_date_short($order->info['date_shipping']));
$smarty->assign('order_data', $order_data);
$smarty->assign('order_total', $order_total);
$smarty->assign('order_weight', number_format($weight_total,4,',','.').'kg');

if(defined('MODULE_OTHER_FIBUNUMBERS_STATUS') and MODULE_OTHER_FIBUNUMBERS_STATUS == 'True'){
	$fibu_date_query = yes_db_query(sprintf(
		"SELECT date_added FROM orders_fibunumbers WHERE orders_id='%s'",
		$order->info['id']
	));
	if(yes_db_num_rows($fibu_date_query)){
		$date = current($fibu_date_query);
		$smarty->assign('fibu_date',$date['date_added']);
	}
}

$smarty->assign('STORE_WRAP',STORE_WRAP);

$smarty->display(CURRENT_TEMPLATE . '/admin/print_packingslip.html');	
