<?php
/* -----------------------------------------------------------------------------------------
   mario aspeleiter 2005
   ---------------------------------------------------------------------------------------*/

require('includes/application_top.php');

// include needed functions
require_once(DIR_FS_INC .'xtc_get_order_data.inc.php');
require_once(DIR_FS_INC .'xtc_get_attributes_model.inc.php');
require_once(DIR_FS_INC .'xtc_not_null.inc.php');
require_once(DIR_FS_INC .'xtc_format_price_order.inc.php');

$smarty = new yesSmarty;

include(DIR_WS_CLASSES . 'reclamation.php');
include(DIR_WS_CLASSES . 'rueckerstattung.php');
include(DIR_WS_CLASSES . 'order.php');
$rID = (int)xtc_db_input($_GET['rID']);
$rueckerstattung = new rueckerstattung($rID);
$insert_sql_array = array(
    'rueckerstattungen_id'=>$rID,
    'rueckerstattungen_status_id'=>$rueckerstattung->info['status'],
    'date_added'=>'now()',
    'customer_notified'=>0,
    'comments'=>HISTORY_RUECKERSTATTUNG_PRINTED,
    'editor_id'=>$_SESSION['customer_id']
);
xtc_db_perform('rueckerstattungen_status_history',$insert_sql_array);
if($rueckerstattung->info['reclamations_id']>0){
  	$reclamation = new reclamation($rueckerstattung->info['reclamations_id']);
  	$smarty->assign('address_label_customer',xtc_address_format($reclamation->customer['format_id'], $reclamation->customer, 1, '', '<br>'));
  	$smarty->assign('EBAY_ID',$reclamation->info['ebay_id']);
	foreach($reclamation->products as $k=>$prod){
		$thumbnail_image = '';
		$picture_query = yes_db_query(sprintf("SELECT products_image FROM products WHERE products_id='%s'",
				$prod['id']
		),true);
		if($picture_query){
			$picture = current($picture_query);
			$thumbnail_image = HTTP_SERVER.'images/product_images/thumbnail_images/'.$picture['products_image'];
		}
		$rueckerstattung_data[]=array(
				'PRODUCTS_ID' => $prod['id'],
				'PRODUCTS_MODEL' => $prod['model'],
				'PRODUCTS_NAME' => $prod['name'],
				'PRODUCTS_QTY' => $prod['qty'],
				'THUMBNAIL_IMAGE'=>$thumbnail_image
		);
	}
	$currency = $reclamation->info['currency'];
  }else{
  	$order = new order($rueckerstattung->info['orders_id']);
  	$smarty->assign('address_label_customer',xtc_address_format($order->customer['format_id'], $order->customer, 1, '', '<br>'));
  	$smarty->assign('EBAY_ID',$order->info['ebay_id']);
	foreach($order->products as $k=>$prod){
		$thumbnail_image = '';
		$picture_query = yes_db_query(sprintf("SELECT products_image FROM products WHERE products_id='%s'",
				$prod['id']
		),true);
		if($picture_query){
			$picture = current($picture_query);
			$thumbnail_image = HTTP_SERVER.'images/product_images/thumbnail_images/'.$picture['products_image'];
		}
		$rueckerstattung_data[]=array(
				'PRODUCTS_ID' => $prod['id'],
				'PRODUCTS_MODEL' => $prod['model'],
				'PRODUCTS_NAME' => $prod['name'],
				'PRODUCTS_QTY' => $prod['qty'],
				'THUMBNAIL_IMAGE'=>$thumbnail_image,
			'PROPERTIES'=>$prod['properties']
		);
	}
	$currency = $order->info['currency'];
  }
  
  $zep_query = xtc_db_query("SELECT ip.buchungstag,ip.betrag,po.created FROM incoming_payments ip, payment_orders po WHERE ip.id=po.payment_id and po.orders_id='".$rueckerstattung->info['orders_id']."'");
  $zep_data = array();
  if(xtc_db_num_rows($zep_query) > 0){
	$smarty->assign('ZEP','1');
	while($payment = xtc_db_fetch_array($zep_query)) {
		$zep_data[] = array('buchungstag'=>$payment['buchungstag'],
			'created'=>xtc_date_short($payment['created']),
			'betrag'=>number_format($payment['betrag'],2,',',''));
	}
	$smarty->assign('zep_data',$zep_data);
  }
  
  $smarty->assign('STATUS',xtc_get_rueckerstattungen_status_name($rueckerstattung->info['status']));
  $smarty->assign('TYPE',xtc_get_rueckerstattungen_types_name($rueckerstattung->info['type']));
  $smarty->assign('BANK',$rueckerstattung->bank['kto_bank']);
  $smarty->assign('IBAN',$rueckerstattung->bank['kto_iban']);
  $smarty->assign('SWIFT',$rueckerstattung->bank['kto_swift']);
  $smarty->assign('BLZ',$rueckerstattung->bank['kto_blz']);
  $smarty->assign('KONTO',$rueckerstattung->bank['kto_nummer']);
  $smarty->assign('INHABER',$rueckerstattung->bank['kto_inhaber']);
  $smarty->assign('BETRAG',number_format($rueckerstattung->info['betrag'],2,',','').' '.$currency);
  $smarty->assign('GRUND',$rueckerstattung->bank['kto_grund']);
  $smarty->assign('PAYMODE',$rueckerstattung->info['paymode']);

  // assign language to template for caching
  $smarty->assign('STORE', nl2br(STORE_NAME_ADDRESS));
  if($rueckerstattung->info['date_payment']>0)
  	$smarty->assign('DATE_FINISHED', xtc_date_short($rueckerstattung->info['date_payment']));
 	
  $smarty->assign('language', $_SESSION['language']);
  $smarty->assign('logo_path',DIR_WS_CATALOG.'/templates/'.CURRENT_TEMPLATE.'/img/');
	
  $smarty->assign('oID',$rueckerstattung->info['orders_id'].$o_ebayid);
  $smarty->assign('cID',$rueckerstattung->info['customers_id']);
  $smarty->assign('rID',$_GET['rID']);
  $smarty->assign('recID',$rueckerstattung->info['reclamations_id']);

  $smarty->assign('DATE',xtc_date_short($rueckerstattung->info['date_created']));
  $smarty->assign('rueckerstattung_data', $rueckerstattung_data);

  $rueckerstattungen_history_query = xtc_db_query("select * from  rueckerstattungen_status_history  where rueckerstattungen_id = '" . xtc_db_input($_GET['rID']) . "' order by date_added DESC");
  $history_array = array();
  while ($rueckerstattungen_history = xtc_db_fetch_array($rueckerstattungen_history_query)) {
	$hist = array();
	$hist['date_added'] = xtc_datetime_short($rueckerstattungen_history['date_added']);
        if ($rueckerstattungen_history['customer_notified'] == '1') {
          $hist['icon'] = xtc_image(DIR_WS_ICONS . 'tick.gif', ICON_TICK) . "</td>\n";
        } else {
          $hist['icon'] = xtc_image(DIR_WS_ICONS . 'cross.gif', ICON_CROSS) . "</td>\n";
        }
        $hist['status'] = xtc_get_rueckerstattungen_status_name($rueckerstattungen_history['rueckerstattungen_status_id']);
	$hist['comments'] = nl2br(xtc_db_output($rueckerstattungen_history['comments']));
	$hist['editor'] = xtc_get_editor_name($rueckerstattungen_history['editor_id']);
	$history_array[] = $hist;
}
$smarty->assign('history_array',$history_array);
$query = xtc_db_query(sprintf(
	"SELECT orig_amazon_orders_id FROM amazon_orders WHERE orders_id='%s' LIMIT 1",
	$rueckerstattung->info['orders_id']
));
if(xtc_db_num_rows($query)){
    $record = xtc_db_fetch_array($query);
    $smarty->assign('AMAZON_ORDERS_ID',$record['orig_amazon_orders_id']);
}
$smarty->display(CURRENT_TEMPLATE . '/admin/print_rueckerstattung.html');	
