<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                              Author M. ASPELEITER <dazze@gmx.de
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

require('includes/application_top.php');
require('includes/classes/class.yes_lister.php');    
$languages = xtc_get_languages();

$action = isset($_GET['action']) ? $_GET['action'] : '';
switch ($action) {
  	case 'delete':
            $pcID = (int)xtc_db_input($_REQUEST['pcID']);
            \YES4Trade\Model\products_conditions::delete($pcID);
            $messageStack->add_session(MSG_PRODUCTS_CONDITION_DELETED,'success');
            xtc_redirect( xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action','pcID'))) );
            break;
  	case 'save_new':
	    foreach($languages as $lang){
		if(!isset($_REQUEST['title'][$lang['id']]) or empty($_REQUEST['title'][$lang['id']])){
		    $messageStack->add_session(sprintf(MSG_ERROR_TITLE_LANG,$lang['name']),'error');
		    xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action')).'action=new'));
		}
	    }
            $new_pcd = new \YES4Trade\Model\products_conditions([
                'date_added'=>date('Y-m-d H:i:s')
            ]);
            $new_pcdID = $new_pcd->create();
	    foreach($languages as $lang){
                $new_pcdd = new \YES4Trade\Model\products_conditions_description([
		    'products_conditions_id'=>(int)$new_pcdID,
		    'title'=>$_REQUEST['title'][$lang['id']],
		    'language_id'=>(int)$lang['id'],
                ]);
                $new_pcdd->create();
	    }
	    $messageStack->add_session(MSG_SUCCESS_PRODUCTS_CONDITION_ADDED,'success');
	    xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action'))));
	    break;
  	case 'save':
	    foreach($languages as $lang){
		if(!isset($_REQUEST['title'][$lang['id']]) or empty($_REQUEST['title'][$lang['id']])){
		    $messageStack->add_session(sprintf(MSG_ERROR_TITLE_LANG,$lang['name']),'error');
		    xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action')).'action=edit'));
		}
	    }
	    $pcID = (int)xtc_db_input($_REQUEST['pcID']);
            
	    foreach($languages as $lang){
                $pcdd = \YES4Trade\Model\products_conditions_description::get_from_db_by_products_conditions_id_and_language_id(
                    $pcID, $lang['id']
                );
                $pcdd->title = $_REQUEST['title'][$lang['id']];
                $pcdd->update();
	    }
	    $messageStack->add_session(MSG_SUCCESS_PRODUCTS_CONDITION_UPDATED,'success');
	    xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action'))));
	    break;
}
yes_draw_pre_header();
yes_draw_header(TITLE);
// initiate template engine for mail
$smarty = new yesSmarty;

$listing_smarty = $smarty;

$buttons = array(
    array('text'=>LINK_ADD_CONDITION,
	'link'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action','pcID','order_by','page')).'action=new'),
	'lbOn'=>false,
	'auth'=>true
    )
);
$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons
));

$order_by = isset($_GET['order_by']) ? xtc_db_input($_GET['order_by']) : 'title';
$products_conditions_query_raw = "select pc.*,pcd.title from products_conditions pc LEFT JOIN products_conditions_description pcd USING(products_conditions_id) WHERE language_id='".$_SESSION['languages_id']."' ORDER BY ".$order_by;
$pc_split = new splitPageResults($_GET['page'], $view_limit = MAX_DISPLAY_SEARCH_RESULTS, $products_conditions_query_raw, $pc_query_numrows);

$select_field_array = array(
	0=>array(
		'field'=>'products_conditions_id',
		'heading'=>TABLE_HEADING_ID,
		'format'=>'int',
		'get_param'=>'pcID',
		'index'=>true,
		'sortable'=>1,
		'column'=>0
	),
	1=>array(
		'field'=>'title',
		'heading'=>TABLE_HEADING_TITLE,
		'format'=>'string',
		'get_param'=>'title',
		'sortable'=>1,
		'column'=>1
	)
);
$YL = new yes_lister($products_conditions_query_raw,'products_conditions',basename(__FILE__),$select_field_array);
$YL->setSmarty($listing_smarty);
$pcInfo = $YL->active_row;
$smarty->assign('LISTING',$YL->display($pc_split,$pc_query_numrows,$view_limit));

$heading = array();
$contents = array();
switch ($action) {
	case 'new':
		$heading[] = array('text' => '<b>' . LINK_ADD_CONDITION . '</b>');
		$contents = array('form' => xtc_draw_form('pc_new', basename(__FILE__), xtc_get_all_get_params(array('action')).'action=save_new') );
		$contents[] = array('align' => 'left', 'text' => INTRO_ADD_CONDITION);
		foreach($languages as $lang){
		    $contents[] = array('align' => 'left', 'text' => $lang['name'].': '.xtc_draw_input_field('title['.$lang['id'].']','','size="20" maxlength="32"') );
		}
		$contents[] = array('align' => 'center', 'text' => '<br />'.yes_draw_href_button(IMAGE_SAVE,'','width:110px;','submit').'&nbsp;'.yes_draw_href_button(IMAGE_CANCEL,xtc_href_link(basename(__FILE__), xtc_get_all_get_params(array('action')) ),'width:110px;'));
		break;
	case 'delete_confirm':
		$heading[] = array('text' => '<b>&quot;' . xtc_db_prepare_input($pcInfo->title) . '&quot; '. IMAGE_DELETE . '</b>');
		$contents = array('form' => xtc_draw_form('pc_delete', basename(__FILE__), xtc_get_all_get_params(array('action')).'action=delete') );
		$contents[] = array('align' => 'left', 'text' => INTRO_DELETE_CONDITION);
		$contents[] = array('align' => 'left', 'text' => '<b>'.TABLE_HEADING_ID.':</b> '.$pcInfo->products_conditions_id);
		$contents[] = array('align' => 'left', 'text' => '<b>'.TABLE_HEADING_TITLE.':</b> '.xtc_db_prepare_input($pcInfo->title) );
		$contents[] = array('align' => 'center', 'text' => '<br />'.yes_draw_href_button(IMAGE_DELETE,'','width:110px;','submit').'&nbsp;'.yes_draw_href_button(IMAGE_CANCEL,xtc_href_link(basename(__FILE__), xtc_get_all_get_params(array('action'))),'width:110px;'));
		break;
	case 'edit':
	    $pcID = (int)xtc_db_input($_REQUEST['pcID']);
		$heading[] = array('text' => '<b>&quot;' . xtc_db_prepare_input($pcInfo->title) . '&quot; '. IMAGE_EDIT . '</b>');
		$contents = array('form' => xtc_draw_form('pc_edit', basename(__FILE__), xtc_get_all_get_params(array('action')).'action=save') );
		$contents[] = array('align' => 'left', 'text' => INTRO_ADD_CONDITION);
		foreach($languages as $lang){
		    $query = xtc_db_query(sprintf(
			    "SELECT title FROM products_conditions_description WHERE language_id='%s' AND products_conditions_id='%s'",
			    $lang['id'],$pcID
		    ));
		    $record = xtc_db_fetch_array($query);
		    $contents[] = array('align' => 'left', 'text' => $lang['name'].': '.xtc_draw_input_field('title['.$lang['id'].']',$record['title'],'size="20" maxlength="32"') );
		}
		$contents[] = array('align' => 'center', 'text' => '<br />'.yes_draw_href_button(IMAGE_UPDATE,'','width:110px;','submit').'&nbsp;'.yes_draw_href_button(IMAGE_CANCEL,xtc_href_link(basename(__FILE__), xtc_get_all_get_params(array('action'))),'width:110px;'));
		break;
	default:
		if (is_object($pcInfo)) {
			$heading[] = array('text' => '<b>Info &quot;' . xtc_db_prepare_input($pcInfo->title).'&quot;</b>');
			$contents[] = array('align' => 'center', 'text' => yes_draw_href_button(IMAGE_EDIT,xtc_href_link(basename(__FILE__), xtc_get_all_get_params(array('action','pcID')) . 'action=edit&pcID='.$pcInfo->products_conditions_id),'width:180px;'));
			$contents[] = array('align' => 'center', 'text' => yes_draw_href_button(IMAGE_DELETE,xtc_href_link(basename(__FILE__), xtc_get_all_get_params(array('action','pcID')) . 'action=delete_confirm&pcID='.$pcInfo->products_conditions_id),'width:180px;'));
			$contents[] = array('align' => 'left', 'text' => '<b>'.TABLE_HEADING_ID.':</b> '.$pcInfo->products_conditions_id);
			$contents[] = array('align' => 'left', 'text' => '<b>'.TABLE_HEADING_TITLE.':</b> '.xtc_db_prepare_input($pcInfo->title) );
		}
		break;
}

if ( (xtc_not_null($heading)) && (xtc_not_null($contents)) ) {
	$box = new box;
	$smarty->assign('BOX', $box->infoBox($heading, $contents));
}
$smarty->display('products_conditions.html');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');