<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                              Author M. ASPELEITER <dazze@gmx.de
                                             	Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/
require('includes/application_top.php');
require_once(DIR_FS_INC . 'changedataout.inc.php');
require_once(DIR_FS_INC . 'xtc_get_parent_categories.inc.php');
require_once(DIR_FS_INC . 'yes_write_notice.inc.php');
require_once(DIR_FS_INC . 'xtc_get_product_path.inc.php');
require_once(DIR_WS_CLASSES . 'currencies.php');
require_once(DIR_WS_CLASSES . 'class.ebaymail.php');
require_once(DIR_WS_CLASSES . 'order.php');
require_once(DIR_WS_CLASSES . 'reclamation.php');
require_once(DIR_FS_CATALOG.DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');
require_once(DIR_FS_INC.'xtc_get_ebay_link.inc.php');
require_once(DIR_FS_INC.'xtc_get_auction_site.inc.php');
require_once(DIR_FS_INC . 'xtc_retoure_copy_product.inc.php');

$RETOURE_CAT = \YES4Trade\Model\categories_description::get_retoure_categories_id();
if($RETOURE_CAT < 1){
    $messageStack->add_session('Keine RETOURE Kategorie vorhanden.','error');
    xtc_redirect(xtc_href_link('start.php'));
}
$vers_array = array();
foreach($VERSENDER as $k=>$v){
	$vers_array[] = array('id'=>$v,'text'=>$v);
}

// initiate template engine for mail
$smarty = new yesSmarty;

$currencies = new currencies();

if ( (isset($_GET['action']) and $_GET['action'] == 'edit') && isset($_GET['rID']) ) {
    $rID = (int)xtc_db_input($_GET['rID']);
    $retoure_query = xtc_db_query("select retoure_id from retouren where retoure_id = '" . $rID . "'");
    $retoure_exists = true;
    if (!xtc_db_num_rows($retoure_query)) {
      $retoure_exists = false;
      $messageStack->add(sprintf(TEXT_RETOURE_NOT_EXISTS, $rID), 'error');
    }
}

require(DIR_WS_CLASSES . 'retoure.php');
if ( (isset($_GET['action']) and $_GET['action'] == 'edit') && ($retoure_exists) ) {
	$retoure = new retoure($rID);
}
$action = (isset($_GET['action']))?$_GET['action']:'';
define('TEXT_FALSE_PRODUCTS_ID_ADDED','pID %d wurde als "Falscher Artikel" für pID %d hinzugefügt.');
define('TEXT_FALSE_PRODUCTS_ID_UPDATED','[Vorherige Falsche pID: %d] pID %d wurde als "Falscher Artikel" für pID %d hinzugefügt.');
switch ($action) {
    case 'false_products_id_update':
        $rtID = (int)xtc_db_input($_GET['rtID']);
        $retoure = new retoure($rtID);
        $rpID=(int)xtc_db_input($_GET['rpID']);
        foreach($retoure->products as $retp){
            if($retp['rpID'] == $rpID){
                $orig_pid = $retp['id'];
                $orig_false_pid = $retp['false_products_id'];
            }
        }
        $false_products_id=(int)xtc_db_input($_GET['false_products_id']);
        $update_sql_array = [
            'false_products_id'=>$false_products_id
        ];
        xtc_db_perform('retoure_products',$update_sql_array,'update',"retoure_products_id='".$rpID."' AND retoure_id='".$rtID."'");
        $comments = sprintf(TEXT_FALSE_PRODUCTS_ID_UPDATED, 
            (int)$orig_false_pid, (int)$false_products_id, $orig_pid
        );
                
        $retoure->add_history($retoure->info['retoure_status'], false, $comments);
        xtc_redirect(xtc_href_link(basename(__FILE__),'action=edit&rID='.$rtID));
        break;
    case 'false_products_id_insert':
        $rtID = (int)xtc_db_input($_GET['rtID']);
        $retoure = new retoure($rtID);
        $rpID=(int)xtc_db_input($_GET['rpID']);
        foreach($retoure->products as $retp){
            if($retp['rpID'] == $rpID){
                $orig_pid = $retp['id'];
            }
        }
        $false_products_id=(int)xtc_db_input($_GET['false_products_id']);
        $update_sql_array = [
            'false_products_id'=>$false_products_id
        ];
        xtc_db_perform('retoure_products',$update_sql_array,'update',"retoure_products_id='".$rpID."' AND retoure_id='".$rtID."'");
        $comments = sprintf(TEXT_FALSE_PRODUCTS_ID_ADDED, 
            (int)$false_products_id, $orig_pid
        );
                
        $retoure->add_history($retoure->info['retoure_status'], false, $comments);
        xtc_redirect(xtc_href_link(basename(__FILE__),'action=edit&rID='.$rtID));
        break;
    case 'update_shipper_process':
        $rID = (int)xtc_db_input($_GET['rID']);
        $retoure = new retoure($rID);
        $comments = '';
        // BOF - PRUEFEN OB VERSENDER AUCH IN LISTE IST
        $exists = false;
        foreach($VERSENDER as $k=>$v){
            if($v == $_GET['versender']){
                $exists = true;
            }
        }
        if(!$exists){
            die(json_encode([
                'Invalid shipper '.$_GET['versender']
            ]));
        }
        // EOF - PRUEFEN OB VERSENDER AUCH IN LISTE IST
        
        if( $retoure->info['versender'] != $_GET['versender'] ){
            $comments .= sprintf(TEXT_VERSENDER_CHANGED,$retoure->info['versender'],$_GET['versender']);
            $new = new \YES4Trade\Model\retoure_status_history([
                'retoure_status_id'=>(int)$retoure->info['retoure_status'],
                'retoure_id'=>$rID, 
                'customer_notified'=>0, 
                'date_added'=>date('Y-m-d H:i:s'),
                'comments'=>$comments,
                'editor_id'=>(int)$_SESSION['customer_id']
            ]);
            $update_sql_array = [
                'versender'=>xtc_db_input($_GET['versender'])
            ];
            xtc_db_perform('retouren',$update_sql_array, 'update',"retoure_id='".$rID."'");
        }
        die(json_encode([
            'MSG'=>''
        ]));
        break;
    case 'update_shipper':
        $rID = (int)xtc_db_input($_REQUEST['rID']);
        $retoure = new retoure($rID);
        echo xtc_draw_form('update_shipper_form',basename(__FILE__),xtc_get_all_get_params(['action']).'action=update_shipper_process');
        printf('%s:<br />%s<br /><br /><input onclick="update_shipper(this);" type="button" class="ui-button ui-corner-all ui-state-default" id="update_shipper_button" value="%s" /></form>',
                IMAGE_EDIT_VERSAND,
                xtc_draw_pull_down_menu('versender',$vers_array,$retoure->info['versender']),
                IMAGE_SAVE
        );
        
        exit;
        break;
    case 'ajax_address_save':	    
            $rID = (int)xtc_db_input($_REQUEST['rID']);
            if($rID < 1){
                die('Missing params');
            }
            $json_array = array();
            $address_str = array();
            $retoure = new retoure($rID);
            $prefix = $retoure->get_update_address_part_prefix($_REQUEST['address_type']);
            foreach($_REQUEST as $key=>$val){
                    if(!strstr($key,$prefix) or $key == 'update_customers_name'){
                            continue;
                    }
                    $address_str[] = xtc_db_prepare_input(yes_decode_string($key.': '.$val));
            }
            $address_str = implode(',',$address_str);

            $update_sql_array = $retoure->get_address_part_sql($_REQUEST['address_type'], $_REQUEST,'',false);

            $retoure->update_address_part($update_sql_array);
            $json_array = $update_sql_array;
            if(isset($_REQUEST['update_customers_name']) and $_REQUEST['update_customers_name'] == 1){
                $lastname = '';
                $name_parts = explode(' ',$_REQUEST[$prefix.'name']);
                foreach($name_parts as $np){
                        if(!isset($firstname)){
                                $firstname = $np;
                                continue;
                        }
                        $lastname .= $np .' ';
                }
                $lastname = trim($lastname);
                $update_sql_array = array(
                    'customers_firstname'=>yes_decode_string($firstname),
                    'customers_lastname'=>yes_decode_string($lastname),
                    'customers_last_modified'=>'now()'
                );
                xtc_db_perform(TABLE_CUSTOMERS,$update_sql_array,'update',"customers_id='".$retoure->delivery['ID']."'");
                $new = new \YES4Trade\Model\customers_memo([
                    'customers_id'=>(int)$retoure->delivery['ID'],
                    'memo_date'=>date('Y-m-d H:i:s'),
                    'memo_title'=>TEXT_ADDRESS_UPDATE_TELEPHONE_MEMO_TITLE,
                    'memo_text'=>sprintf(TEXT_ADDRESS_UPDATE_CUSTOMERS_MEMO_TEXT,$retoure->info['id'],$firstname.' '.$lastname),
                    'poster_id'=>(int)$_SESSION['customer_id']
                ]);
                $new->create();
                $firstname = '';
            }


            if(isset($_REQUEST['copy_customer']) and $_REQUEST['copy_customer'] == 1){
                    $update_sql_array = $retoure->get_address_part_sql($_REQUEST['address_type'], $_REQUEST,'customer');
                    $retoure->update_address_part($update_sql_array);
                    $json_array = xtc_array_merge($json_array,$update_sql_array);
            }

            if(isset($_REQUEST['copy_shipping']) and $_REQUEST['copy_shipping'] == 1){
                    $update_sql_array = $retoure->get_address_part_sql($_REQUEST['address_type'], $_REQUEST,'shipping');
                    $retoure->update_address_part($update_sql_array);
                    $json_array = xtc_array_merge($json_array,$update_sql_array);
            }

            if(isset($_REQUEST['copy_invoice']) and $_REQUEST['copy_invoice'] == 1){
                    $update_sql_array = $retoure->get_address_part_sql($_REQUEST['address_type'], $_REQUEST,'invoice');
                    $retoure->update_address_part($update_sql_array);
                    $json_array = xtc_array_merge($json_array,$update_sql_array);
            }
            $query = xtc_db_query(sprintf(
                    "SELECT entry_gender FROM %s ab LEFT JOIN %s c ON ab.address_book_id=c.customers_default_address_id WHERE c.customers_id='%s' AND ab.customers_id=c.customers_id",
                    TABLE_ADDRESS_BOOK,TABLE_CUSTOMERS,$retoure->delivery['ID']
            ));
            $record = xtc_db_fetch_array($query);
            $entry_gender = $record['entry_gender'];
            if(isset($_REQUEST['ab_action']) and ($_REQUEST['ab_action'] == 'copy_as' or $_REQUEST['ab_action'] == 'update')){
                if(isset($_REQUEST['customers_telephone']) and !empty($_REQUEST['customers_telephone'])){
                    xtc_db_query(sprintf(
                            "UPDATE %s SET customers_telephone='%s',customers_last_modified=now() WHERE customers_id='%s'",
                            TABLE_CUSTOMERS,
                            xtc_db_input($_REQUEST['customers_telephone']),
                            $retoure->delivery['ID']
                    ));
                    $new = new \YES4Trade\Model\customers_memo([
                        'customers_id'=>(int)$retoure->delivery['ID'],
                        'memo_date'=>date('Y-m-d H:i:s'),
                        'memo_title'=>TEXT_ADDRESS_UPDATE_TELEPHONE_MEMO_TITLE,
                        'memo_text'=>TEXT_ADDRESS_UPDATE_TELEPHONE_MEMO_TEXT,
                        'poster_id'=>(int)$_SESSION['customer_id']
                    ]);
                    $new->create();
                }
            }
            switch($_REQUEST['ab_action']){
                    case 'copy_as':
                            $ab_address_class = xtc_db_input($_REQUEST['ab_address_class']);

                            if($ab_address_class != ''){
                                \YES4Trade\Model\address_book::update_address_class_to_empty_by_address_class_and_customers_id($ab_address_class, (int)$retoure->delivery['ID']);
                            }

                            $lastname = '';
                            $name_parts = explode(' ',$_REQUEST[$prefix.'name']);
                            foreach($name_parts as $np){
                                    if(!isset($firstname)){
                                            $firstname = $np;
                                            continue;
                                    }
                                    $lastname .= $np .' ';
                            }
                            $lastname = trim($lastname);
                            $iso2_query = xtc_db_query(sprintf(
                                    "SELECT countries_iso_code_2 FROM countries WHERE countries_name='%s'",
                                    xtc_db_input($_REQUEST[$prefix.'country'])
                            ));
                            if(xtc_db_num_rows($query)){
                                $iso2_record = xtc_db_fetch_array($iso2_query);
                                $iso2 = $iso2_record['countries_iso_code_2'];
                            }else{
                                $iso2 = 'DE';
                            }
                            $new = new \YES4Trade\Model\address_book([
                                'customers_id'=>(int)$retoure->delivery['ID'],
                                'entry_gender'=>$entry_gender,
                                'entry_company'=>yes_decode_string($_REQUEST[$prefix.'company']),
                                'entry_firstname'=>yes_decode_string($firstname),
                                'entry_lastname'=>yes_decode_string($lastname),
                                'entry_street_address'=>yes_decode_string($_REQUEST[$prefix.'street_address']),
                                'entry_suburb'=>yes_decode_string($_REQUEST[$prefix.'suburb']),
                                'entry_postcode'=>yes_decode_string($_REQUEST[$prefix.'postcode']),
                                'entry_city'=>yes_decode_string($_REQUEST[$prefix.'city']),
                                'entry_state'=>yes_decode_string($_REQUEST[$prefix.'state']),
                                'entry_country_id'=> (int)yes_get_country_id_from_iso2($iso2),
                                'address_class'=>$ab_address_class,
                                'address_date_added'=>date('Y-m-d H:i:s')
                            ]);
                            $new->create();
                            break;
                    case 'update':
                            $ab_address_book_id = xtc_db_input($_REQUEST['ab_address_book_id']);
                            $lastname = '';
                            $name_parts = explode(' ',$_REQUEST[$prefix.'name']);
                            foreach($name_parts as $np){
                                    if(!isset($firstname)){
                                            $firstname = $np;
                                            continue;
                                    }
                                    $lastname .= $np .' ';
                            }
                            $lastname = trim($lastname);
                            $iso2_query = xtc_db_query(sprintf(
                                    "SELECT countries_iso_code_2 FROM countries WHERE countries_name='%s'",
                                    xtc_db_input($_REQUEST[$prefix.'country'])
                            ));
                            if(xtc_db_num_rows($query)){
                                $iso2_record = xtc_db_fetch_array($iso2_query);
                                $iso2 = $iso2_record['countries_iso_code_2'];
                            }else{
                                $iso2 = 'DE';
                            }
                            $upd = new \YES4Trade\Model\address_book([
                                'address_book_id'=>(int)$ab_address_book_id,
                                'entry_gender'=>$entry_gender,
                                'entry_company'=>yes_decode_string($_REQUEST[$prefix.'company']),
                                'entry_firstname'=>yes_decode_string($firstname),
                                'entry_lastname'=>yes_decode_string($lastname),
                                'entry_street_address'=>yes_decode_string($_REQUEST[$prefix.'street_address']),
                                'entry_suburb'=>yes_decode_string($_REQUEST[$prefix.'suburb']),
                                'entry_postcode'=>yes_decode_string($_REQUEST[$prefix.'postcode']),
                                'entry_city'=>yes_decode_string($_REQUEST[$prefix.'city']),
                                'entry_state'=>yes_decode_string($_REQUEST[$prefix.'state']),
                                'entry_country_id'=> yes_get_country_id_from_iso2($iso2),
                                'address_last_modified'=>'now()'
                            ]);
                            $upd->update();
                            break;
            }


            $json = array();
            foreach($json_array as $k=>$v){
                    $json[$k]=xtc_db_prepare_input(yes_encode_string($v));
            }
            $retoure->add_history($retoure->info['retoure_status'], false, sprintf(HISTORY_ADDRESS_CHANGE,$_REQUEST['address_type'],$address_str));
            header('Content-Type: text/html; charset='.CHARSET);
            die(json_encode(array(
              'UPDATE_ARRAY'=>$json,
                'ADDRESS_TYPE'=>$_REQUEST['address_type']
            )));
            exit;
            break;
    case 'ajax_address_edit':
        require_once(DIR_FS_INC.'xtc_get_country_data_from_name.inc.php');
        $retoure = (int)xtc_db_input($_REQUEST['rID']);
?>
<script type="text/javascript">
$().ready(function(){
    var _url = window.location.pathname;
    var _filename = _url.substring(_url.lastIndexOf('/')+1);
	$('#address_update_button').click(function(){
		$.ajax({
			url: $('form#ajax_address_edit').attr('action'),
			dataType: 'json',
			data: $('form#ajax_address_edit').serialize(),
			success: function(json){
                            for(var element in json.UPDATE_ARRAY){
                                    switch(element){
                                            case 'customers_telephone':
                                            case 'customers_mobile':
                                            case 'customers_vat_id':
                                                    $('td#'+element).html(json.UPDATE_ARRAY[element]);
                                                    break;
                                            default:
                                                target_element = element.replace("shipping_", "delivery_");
                                                    $('table#address_table td#'+target_element).html(json.UPDATE_ARRAY[element]);
                                                    break;
                                    }
                            }
                            oe_help_key = json.ADDRESS_TYPE;
                            switch(json.ADDRESS_TYPE){
                                case 'shipping':
                                    oe_help_key = 'delivery';
                                    break;
                                case 'invoice':
                                    oe_help_key = 'billing';
                                    break;
                                case 'customer':
                                    oe_help_key = 'customers';
                                    break;
                            }
                            $('table#address_table td#'+oe_help_key+'_postcode_city').html(json.UPDATE_ARRAY[json.ADDRESS_TYPE+'_postcode']+' '+json.UPDATE_ARRAY[json.ADDRESS_TYPE+'_city']);
			    $('#modal_window').dialog('destroy');
			},
			error: function(xhr, ajaxOptions, thrownError){
				alert(xhr+' '+thrownError);
			}
		});
	});
});
</script>
<?php
	$copy_list = array(
		'customer'=>TEXT_ADDRESS_BOOK_CLASS_CUSTOMER,
		'shipping'=>TEXT_ADDRESS_BOOK_CLASS_DELIVERY,
		'invoice'=>TEXT_ADDRESS_BOOK_CLASS_BILLING
	);
	echo '<div class="main">';
	echo xtc_draw_form('ajax_address_edit',basename(__FILE__),xtc_get_all_get_params(array('action')).'action=ajax_address_save','POST','onsubmit="return false;" id="ajax_address_edit"');
	echo '<fieldset>';
	printf('<legend>%s</legend>',TEXT_EDIT_ADDRESS);
	switch($_REQUEST['address_type']){
		case 'customer':
			$sql_prefix = 'customers_';
			break;
		case 'shipping':
			$sql_prefix = 'shipping_';
			break;
		case 'invoice':
			$sql_prefix = 'billing_';
			break;
	}
	$fields = array(
		$sql_prefix.'company',
		$sql_prefix.'name',
		$sql_prefix.'street',
		$sql_prefix.'street2',
		$sql_prefix.'postcode',
		$sql_prefix.'city',
		$sql_prefix.'country'
	);
	switch($_REQUEST['address_type']){
		case 'customer':
			$fields[] = $sql_prefix.'vat_id';
			$fields[] = $sql_prefix.'telephone';
//			$fields[] = $sql_prefix.'mobile';
			break;
	}
	
	
	$query = xtc_db_query(sprintf("SELECT %s FROM %s WHERE retoure_id='%s'",
			implode(',',$fields),'retouren',xtc_db_input($_REQUEST['rID'])
	));
	$record = xtc_db_prepare_input(xtc_db_fetch_array($query));
	$countries = xtc_get_countries( $default='',$utf8=true );
        $db_ini = yes_get_database_table_ini();
	foreach($record as $key=>$value){
		$label = constant('TEXT_FIELD_'.strtoupper( substr($key,strlen($sql_prefix),strlen($key)) ));
		$size = 32;
		switch($key){
			case 'customers_country':
			case 'delivery_country':
			case 'billing_country':
				$country_data = xtc_get_country_data_from_name($value);
				$field = xtc_draw_pull_down_menu($key, $countries, $country_data['countries_id'], 'id="'.$key.'"');
				break;
			case 'customers_postcode':
			case 'shipping_postcode':
			case 'billing_postcode':
				$size = 6;
				$field = xtc_draw_input_field($key,yes_encode_string($value),'id="'.$key.'" size="'.$size.'"');
				break;
			default:
                            $current_size = $size;
                            $max_length = $current_size;
                            if(yes_get_database_table_field_length($db_ini, 'retouren', $key) > $size){
                                $current_size = yes_get_database_table_field_length($db_ini, 'retouren', $key);
                                if($current_size > 64){
                                    $max_length = $current_size;
                                    $current_size = 64;
                                }
                            }
                            $field = xtc_draw_input_field($key,$value,'id="'.$key.'" size="'.$current_size.'" maxlength="'.$max_length.'"');
                            break;
		}
		printf('<label for="%s"><b>%s:</b></label><br />%s<br />',$key,$label,$field);
	}
	$query = xtc_db_query(sprintf(
            "SELECT customers_default_address_id FROM %s WHERE customers_id='%s'",
            TABLE_CUSTOMERS,
            $retoure->delivery['ID']
	));
	$record = xtc_db_fetch_array($query);
	$customers_default_address_id = $record['customers_default_address_id'];
        $items = \YES4Trade\Model\address_book::get_by_customers_id((int)$retoure->delivery['ID']);
	$ab_entries = array();
	$ab_classes = array(
		array('id'=>'','text'=>yes_decode_string(TEXT_NONE)),
		array('id'=>'customer','text'=>TEXT_ADDRESS_BOOK_CLASS_CUSTOMER),
		array('id'=>'delivery','text'=>TEXT_ADDRESS_BOOK_CLASS_DELIVERY),
		array('id'=>'billing','text'=>TEXT_ADDRESS_BOOK_CLASS_BILLING)
	);
        foreach($items as $it){
            $text = yes_encode_string($it->entry_firstname.' '.$it->entry_lastname.', '.$it->entry_city);
            if(!empty($it->address_class)){
                switch($it->address_class){
                    case 'customer':
                        $aclass = TEXT_ADDRESS_BOOK_CLASS_CUSTOMER;
                        break;
                    case 'delivery':
                        $aclass = TEXT_ADDRESS_BOOK_CLASS_DELIVERY;
                        break;
                    case 'delivery':
                        $aclass = TEXT_ADDRESS_BOOK_CLASS_BILLING;
                        break;

                }
                $text = $aclass.': '.$text;
            }
            if($customers_default_address_id == $it->address_book_id){
                $text .= ' (Default)';
            }
            $ab_entries[] = array(
                    'id'=>$it->address_book_id,
                    'text'=>$text
            );
	}
	
	printf('<hr noshade="noshade" /><p>%s<br />',TEXT_COPY_ADDRESSBOOK_INTRO);
	echo xtc_draw_radio_field('ab_action','',true).' '.TEXT_COPY_ADDRESSBOOK_NO_ACTION.'<br />';
	$default_ab_address_class = '';
	switch($_REQUEST['address_type']){
		default:
			$default_ab_address_class = $_REQUEST['address_type'];
			break;
		case 'shipping':
			$default_ab_address_class = 'delivery';
			break;
		case 'invoice':
			$default_ab_address_class = 'billing';
			break;
	}
	
	if(KASSE_USER != $retoure->delivery['ID']){
	    $select = xtc_draw_pull_down_menu('ab_address_class', $ab_classes, $default_ab_address_class);
            echo xtc_draw_radio_field('ab_action','copy_as',false).' '.TEXT_COPY_ADDRESSBOOK_COPY_AS.' '.$select.'<br />';
            $select = xtc_draw_pull_down_menu('ab_address_book_id', $ab_entries,$customers_default_address_id);
            echo xtc_draw_radio_field('ab_action','update',false).' '.TEXT_COPY_ADDRESSBOOK_REPLACE.' '.$select.'<br />';
	    echo '</p>';
	    echo '<hr noshade="noshade" />';
	    echo xtc_draw_checkbox_field('update_customers_name', 1, false).' '.TEXT_UPDATE_CUSTOMERS_NAME.'<br />';
	}
	echo '<hr noshade="noshade" />';
	echo '<input type="button" class="ui-button ui-corner-all ui-state-default" value="'.IMAGE_SAVE.'" id="address_update_button" />';
	echo '</fieldset>';
	echo '</form>';
	echo '</div>';
	exit;
        break;
    case 'set_now':
        $rID = (int)xtc_db_input($_GET['rID']);
        $retoure = new retoure($rID);
        $status = xtc_db_input($_GET['rstatus']);
        if($retoure->info['reclamations_id'] > 0){
                $recl_status_query = xtc_db_query("SELECT reclamations_type,reclamations_status FROM reclamations WHERE reclamations_id='".$retoure->info['reclamations_id']."'");
                $recl_status_res = xtc_db_fetch_array($recl_status_query);
                $recl_status = $recl_status_res['reclamations_status'];
                $recl_type = $recl_status_res['reclamations_type'];
        }else{
                $recl_type = 0;
                $recl_status = 0;
        }

        $order_status_query = xtc_db_query("SELECT orders_status FROM orders WHERE orders_id='".$retoure->info['orders_id']."'");
        $order_status_res = xtc_db_fetch_array($order_status_query);
        $order_status = $order_status_res['orders_status'];

        if( xtc_not_null($rID) && $rID > 0 && xtc_not_null($status) && $status > 0) {
                if($status == '3'){ // rueckbuchung
                        $defect_comment = false;
                                $errors = 0;
                                for($i=0;$i<count($retoure->products);$i++){
                                        $collies = xtc_get_product_collies( $retoure->products[$i]['id'] );
                                        if( sizeOf($collies) == 0 ){
                                                if($_POST['qty_defekt_'.$retoure->products[$i]['id']]>0){
                                                        if(($_POST['comments_defekt_'.$retoure->products[$i]['id']]) and $_POST['comments_defekt_'.$retoure->products[$i]['id']] != ''){
                                                        }else{
                                                                $defect_comment = true;
                                                        }
                                                }
                                        }else{
                                                foreach($collies as $ck=>$collie){
                                                        if($_POST['qty_defekt_collie_'.$retoure->products[$i]['id'].'_'.$collie['collie_products_id']]>0){
                                                                if(($_POST['comments_defekt_collie_'.$retoure->products[$i]['id'].'_'.$collie['collie_products_id']]) and $_POST['comments_defekt_collie_'.$retoure->products[$i]['id'].'_'.$collie['collie_products_id']] != ''){
                                                                }else{
                                                                        $defect_comment = true;
                                                                }
                                                        }
                                                }
                                        }
                                }
                                if($defect_comment){
                                        $messageStack->add('Es muss zu jedem Produkt dass als Defekt angelegt wird ein kurzer Zustandsbericht hinterlegt werden','error');
                                        $errors++;
                                }
                                // --------------------------------------------------------------
                                // PRUEFUNG DER VARIABLEN OK
                                // ERZEUGE DATEN
                                // --------------------------------------------------------------
                                if($errors == 0){

                                        for($i=0;$i<count($retoure->products);$i++){
                                                $collies = xtc_get_product_collies( $retoure->products[$i]['id'] );
                                                if( sizeOf($collies) == 0 ){
                                                        if($_POST['qty_rueckbuch_'.$retoure->products[$i]['id']]>0){ // bestand rueckbuchen
                                                                if($recl_type == 3 or $recl_type == 2 or $recl_type == 0){
                                                                        $SQ = new products_quantity($retoure->products[$i]['id']);
                                                                        $new_qty = xtc_db_input( $_POST['qty_rueckbuch_'.$retoure->products[$i]['id']] );
                                                                        $qty_total = $SQ->get_products_total_qty();
                                                                        $SQ->update_qty( $new_qty, $SQ->get_default_storage_id(),$qty_total,'Retoure Nr '.$rID.' -> Rueckbuchung '.$new_qty.' Stk.'
                                                                        );
                                                                        $retoure->add_history($retoure->info['retoure_status'],$notified='0',"Wareneingang pID ".$retoure->products[$i]['id']." OK, Rueckbuchung ".$new_qty." Stk.");
                                                                }else{
                                                                        $retoure->add_history($retoure->info['retoure_status'],$notified='0',"Wareneingang pID ".$retoure->products[$i]['id']." OK, Keine Rueckbuchung.");
                                                                }

                                                        }
                                                        if(isset($_POST['qty_defekt_'.$retoure->products[$i]['id']]) and $_POST['qty_defekt_'.$retoure->products[$i]['id']]>0){ // defekt erzeugen
                                                            $products_id = xtc_db_prepare_input($retoure->products[$i]['id']);
                                                            $def_com = xtc_db_prepare_input($_POST['comments_defekt_'.$retoure->products[$i]['id']]);
                                                            $categories_id = $RETOURE_CAT;
                                                            $cat_ids = array('0'=>$categories_id);
                                                            $qty = $_POST['qty_defekt_'.$retoure->products[$i]['id']];
                                                            $comments = "Retoure ".$rID." aus Re-Nr ".$retoure->info['orders_id']." -> Defekte Ware als Produkt mit Bestand ".$qty." in Kategorie RETOURE dupliziert. Sehen Sie in die Produkthistorie des Originalprodukts um Infos zu den erzeugten Retoureprodukten einzusehen. Zustandsbeschreibung: ".$def_com;
                                                            xtc_retoure_copy_product(
                                                                $products_id,
                                                                $cat_ids,
                                                                $qty,
                                                                $comments,
                                                                $def_com
                                                            );
                                                            $status_comments = "Wareneingang [pID ".$retoure->products[$i]['id']."] ".$qty." Stk. Defekt, Zustandsbeschreibung:\r\n\r\n".$def_com."\r\n\r\nWurden als Retoure Produkte gespeichert.";
                                                            $retoure->add_history($retoure->info['retoure_status'],$notified='0',$status_comments);
                                                        }
                                                }else{
                                                        die('FEHLER: RETOUREN KOENNEN KEINE COLLIES ENTHALTEN. INFORMIEREN SIE DAS YES TEAM');
                                                }
                                        } // end foreach retoure products
                                        xtc_db_query("UPDATE retouren SET retoure_status='3',date_finished=now() WHERE retoure_id='".$rID."'");
                                        $retoure->add_history(3,$notified='0',"Wareneingang wurde gebucht.");
                                        if($retoure->info['reclamations_id'] > 0){
                                                $reclamation = new reclamation($retoure->info['reclamations_id']);
                                                $reclamation->add_history($recl_status,false,"Der Wareneingang der Retoure ".$rID." wurde gebucht.");
                                                $orderadd = ' aus Reklamation Nr '.$retoure->info['reclamations_id'];
                                        }else{
                                                $orderadd = '';
                                        }
                                        $order = new order($retoure->info['orders_id']);
                                        $order->add_history($order_status,'n',"Der Wareneingang der Retoure ".$rID.$orderadd." wurde gebucht.");

                                        // COMMENT AN BERECHTIGTE
                                        if(is_array($_POST['notice_to'])){
                                                $recipients_array = array();
                                                $note = 'Die <a href="retoure.php?menugroup=customers&action=edit&rID='.$rID.'"><u>Retoure Nr: '.$rID.'</u></a> ist eingetroffen und gebucht worden.<br><br>';
                                                if( $retoure->info['reclamations_id'] > 0){
                                                        $note .= 'Die dazu geh&ouml;rende <a href="reclamations.php?menugroup=customers&action=edit&rID='.$retoure->info['reclamations_id'].'"><u>Reklamation Nr. '.$retoure->info['reclamations_id'].'</u></a> kann nun gegebenenfalls abgeschlossen werden.';
                                                }else{
                                                        $note .= 'Die Retoure geh&ouml;rte zur <a href="orders.php?menugroup=customers&action=edit&oID='.$retoure->info['orders_id'].'"><u>Rechnung Nr. '.$retoure->info['orders_id'].'</u></a>.';
                                                }
                                                foreach($_POST['notice_to'] as $k=>$admID){
                                                        $recipients_array[] = xtc_db_input($admID);
                                                }
                                                yes_write_notice("Retoure eingetroffen",$note,0,$recipients_array);
                                        }

                                }else{
                                        $_GET['action'] = 'edit';
                                }
                }else if($status == '2'){ // abholung
                        xtc_db_query("UPDATE retouren SET retoure_status='".$status."',date_initiated=now() WHERE retoure_id='".$rID."'");

                        if($retoure->info['reclamations_id']>0){
                                $reclamation = new reclamation($retoure->info['reclamations_id']);
                                $smarty->assign('address_label_customer',xtc_address_format($reclamation->customer['format_id'], $reclamation->customer, 1, '', '<br>'));
                        }
                        $order = new order($retoure->info['orders_id']);
                        $smarty->assign('address_label_customer',xtc_address_format($order->customer['format_id'], $order->customer, 1, '', '<br>'));

                        $cID = $retoure->delivery['ID'];
                        $oID = $retoure->info['orders_id'];
                        $email_address = $order->customer['email_address'];

                        foreach($retoure->products as $k=>$prod){
                                $retoure_data[]=array(
                                        'PRODUCTS_MODEL' => $prod['model'],
                                        'PRODUCTS_NAME' => $prod['name'],
                                        'PRODUCTS_QTY' => $prod['qty'],
                                        'PROPERTIES'=>$prod['properties']
                                );
                        }

                        $retoure_string = ($retoure->delivery['company'] != '')?$retoure->delivery['company'].'<br>':'';
                        $retoure_string .= ($retoure->delivery['name'] != '')?$retoure->delivery['name'].'<br>':'';
                        $retoure_string .= ($retoure->delivery['street_address'] != '')?$retoure->delivery['street_address'].'<br>':'';
                        $retoure_string .= ($retoure->delivery['suburb'] != '')?$retoure->delivery['suburb'].'<br>':'';
                        $retoure_string .= ($retoure->delivery['postcode'] != '')?$retoure->delivery['postcode'].' ':'';
                        $retoure_string .= ($retoure->delivery['city'] != '')?$retoure->delivery['city'].'<br>':'';
                        $retoure_string .= ($retoure->delivery['country'] != '')?$retoure->delivery['country'].'<br>':'';


                        $smarty->assign('ABHOLUNG_ADDRESS',$retoure_string);
                        $smarty->assign('VERSENDER',$retoure->info['versender']);
                        $smarty->assign('COSTS',number_format($retoure->info['costs'],2,',',''));
                        $smarty->assign('STATUS',xtc_get_retoure_status_name($retoure->info['retoure_status']));

                        // assign language to template for caching
                        $smarty->assign('STORE', nl2br(STORE_NAME_ADDRESS));
                        if($retoure->info['date_initiated']>0)
                                $smarty->assign('DATE_INITIATED', xtc_date_long($retoure->info['date_initiated']));
                        if($retoure->info['date_finished']>0)
                                $smarty->assign('DATE_FINISHED', xtc_date_long($retoure->info['date_finished']));

                        $smarty->assign('language', $_SESSION['language']);
                        $smarty->assign('logo_path',HTTP_SERVER.'yes/templates/'.CURRENT_TEMPLATE.'/img/');

                        $smarty->assign('oID',$retoure->info['orders_id'].$o_ebayid);
                        $smarty->assign('rID',$rID);
                        if(!function_exists('xtc_get_payment_method_title'))
                          require_once(DIR_FS_INC.'xtc_get_payment_method_title.inc.php');
                        $smarty->assign(array(
                            'recID'=>$retoure->info['reclamations_id'],
                            'PAYMENT_METHOD'=>xtc_get_payment_method_title($order->info['payment_method']),
                            'NAME'=>$retoure->delivery['name'],
                            'COMPANY'=>$retoure->delivery['company'],
                            'cID'=>$cID
                        ));

                        $smarty->assign('DATE',xtc_date_long($retoure->info['date_created']));
                        $smarty->assign('retoure_data', $retoure_data);
                        if($_GET['sendmail'] == '1'){

                                $html_mail=$smarty->fetch(CURRENT_TEMPLATE . '/admin/mail/german/send_retoure.html');
                                $txt_mail=$smarty->fetch(CURRENT_TEMPLATE . '/admin/mail/german/send_retoure.txt');

                                // **** EMAILCLIENT - ADDON *****
                                $dbMail = new DBmail('0');
                                $subject = RETOURE_EMAIL_SUBJECT.': Rechnung Nr. '.$order->info['id'].(($order->info['ebay_id']!='') ? ' ('.$order->info['ebay_id'].')':'');
                                $dbMail->save_mail($subject,$email_address,EMAIL_BILLING_REPLY_ADDRESS_NAME,EMAIL_BILLING_REPLY_ADDRESS,$html_mail,date('Y-m-d H:i:s'), $order->info['ebay_id'],$cID,$oID);

                                $retoure->add_history($status='2',$notified='1',"Retoureinfo per Email an ".$email_address." versendet");

                                xtc_php_mail(EMAIL_BILLING_REPLY_ADDRESS, EMAIL_BILLING_REPLY_ADDRESS_NAME, $email_address, $email_address, '', EMAIL_BILLING_REPLY_ADDRESS, EMAIL_BILLING_REPLY_ADDRESS_NAME, $path_to_attachement='', $path_to_more_attachements='', $subject, $html_mail,$txt_mail);
                                $messageStack->add_session('Retoure eingeleitet. Der Kunde erhielt per Email die Retouredaten','success');
                        }else{
                                $retoure->add_history($status='2',$notified='0',"Neuer Status. Keine Retoureinfo per Email versendet");
                                $messageStack->add_session('Retoure eingeleitet. Der Kunde erhielt KEINE Email.','success');
                        }
                        if($retoure->info['reclamations_id'] > 0){
                                $reclamation = new reclamation($retoure->info['reclamations_id']);
                                $reclamation->add_history($recl_status,false,"Die Retoure ".$rID." hat neuen Status ".xtc_get_retoure_status_name($status));

                                $orderadd = ' aus Reklamation Nr '.$retoure->info['reclamations_id'];
                                $orderlink = ' aus <a href="'.xtc_href_link('reclamations.php','action=edit&rID='.$retoure->info['reclamations_id']).'"><u>Reklamation Nr '.$retoure->info['reclamations_id'].'</u></a>';
                        }else{
                                $orderadd = '';
                                $orderlink = ' aus <a href="'.xtc_href_link('orders.php','action=edit&oID='.$retoure->info['orders_id']).'"><u>Re-Nr '.$retoure->info['orders_id'].'</u></a>';
                        }
                        $order = new order($retoure->info['orders_id']);
                        $order->add_history($order_status,'n',"Die Retoure ".$rID.$orderadd." hat neuen Status ".xtc_get_retoure_status_name($status));

                        xtc_redirect(xtc_href_link('retoure.php','rID='.$rID.'&action=edit'));

                }else if($status == '4'){ // fehlgeschlagen
                        xtc_db_query("UPDATE retouren SET retoure_status='".$status."',date_finished=now() WHERE retoure_id='".$rID."'");
                        if($_POST['create_new'] == '1'){
                                $sql_array = array('orders_id'=>$retoure->info['orders_id'],
                                        'reclamations_id'=>$retoure->info['reclamations_id'],
                                        'customers_id'=>$retoure->delivery['ID'],
                                        'shipping_company'=>$retoure->delivery['company'],
                                        'shipping_name'=>$retoure->delivery['name'],
                                        'shipping_street'=>$retoure->delivery['street_address'],
                                        'shipping_street2'=>$retoure->delivery['suburb'],
                                        'shipping_postcode'=>$retoure->delivery['postcode'],
                                        'shipping_city'=>$retoure->delivery['city'],
                                        'shipping_country'=>$retoure->delivery['country'],
                                        'date_created'=>"now()",
                                        'retoure_status'=>'1',
                                        'costs'=>(float)xtc_db_input($_POST['costs']),
                                        'versender'=>xtc_db_input($_POST['versender']));
                                xtc_db_perform('retouren',$sql_array);
                                $new_retoure = xtc_db_insert_id();

                                $retoure_products_query = xtc_db_query("SELECT * FROM retoure_products WHERE retoure_id='".$rID."'");
                                while($retoure_products = xtc_db_fetch_array($retoure_products_query)){
                                        $insert_sql = array('retoure_id'=>$new_retoure,
                                                'products_id'=>$retoure_products['products_id'],
                                                'products_model'=>xtc_db_input($retoure_products['products_id']),
                                                'products_name'=>xtc_db_input($retoure_products['products_name']),
                                                'products_quantity'=>$retoure_products['products_quantity']);
                                        xtc_db_perform('retoure_products',$insert_sql	);

                                        $newrpID = xtc_db_insert_id();
                                        $query = xtc_db_query(sprintf(
                                                "SELECT * FROM retoure_products_properties WHERE retoure_products_id='%s'",
                                                $retoure_products['retoure_products_id']
                                        ));
                                        while($record = xtc_db_fetch_array($query)){
                                                $insert_sql_array = $record;
                                                unset($insert_sql_array['retoure_products_properties_id']);
                                                $insert_sql_array['retoure_products_id'] = $newrpID;
                                                xtc_db_perform('retoure_products_properties',$insert_sql_array);
                                        }
                                }

                                $retoure->add_history($retoure->info['retoure_status'],false,"Die Retoure ".$new_retoure." wurde aus dieser Retoure heraus erstellt, da fehlgeschlagen.");

                                $new_retoure_id = $new_retoure;
                                $new_retoure = new retoure($new_retoure);
                                $new_retoure->add_history($new_retoure->info['retoure_status'],false,"Aus fehlgeschlagener Retoure ".$rID." heraus angelegt.");

                                if($retoure->info['reclamations_id']>0){
                                        $reclamation = new reclamation( $retoure->info['reclamations_id'] );
                                        $history_string = "Die Retoure ".$new_retoure_id." wurde aus der fehlgeschlagenen Retoure ".$rID." erzeugt.";
                                        $reclamation->add_history($recl_status,false,$history_string);
                                }
                                if($retoure->info['orders_id']>0){
                                        $order = new order($retoure->info['orders_id']);
                                        $order->add_history($order_status,'n',"Die Retoure ".$new_retoure_id." wurde aus der fehlgeschlagenen Retoure ".$rID." erzeugt.");
                                }
                        }

                        // COMMENT AN BERECHTIGTE
                        if(is_array($_POST['notice_to'])){
                                $recipients_array = array();
                                $note = 'Die <a href="retoure.php?menugroup=customers&action=edit&rID='.$rID.'"><u>Retoure Nr: '.$rID.'</u></a> ist <b><font color="red">Fehlgeschlagen.</b><br><br>';
                                if( $retoure->info['reclamations_id'] > 0){
                                        $note .= 'Die dazu geh&ouml;rende <a href="reclamations.php?menugroup=customers&action=edit&rID='.$retoure->info['reclamations_id'].'"><u>Reklamation Nr. '.$retoure->info['reclamations_id'].'</u></a> kann nun gegebenenfalls abgeschlossen werden.';
                                }else{
                                        $note .= 'Die Retoure geh&ouml;rte zur <a href="orders.php?menugroup=customers&action=edit&oID='.$retoure->info['orders_id'].'"><u>Rechnung Nr. '.$retoure->info['orders_id'].'</u></a>.';
                                }
                                foreach($_POST['notice_to'] as $k=>$admID){
                                        $recipients_array[] = xtc_db_input($admID);
                                }
                                yes_write_notice("Retoure fehlgeschlagen",$note,0,$recipients_array);
                        }
                }

                if($retoure->info['reclamations_id'] > 0){
                        $reclamation = new reclamation($retoure->info['reclamations_id']);
                        $reclamation->add_history($recl_status,false,sprintf(TEXT_HISTORY_ORDER_STATUS_UPDATE,$rID,xtc_get_retoure_status_name($status)));

                        $orderadd = ' aus Reklamation Nr '.$retoure->info['reclamations_id'];
                        $orderlink = ' aus <a href="'.xtc_href_link('reclamations.php','action=edit&rID='.$retoure->info['reclamations_id']).'"><u>Reklamation Nr '.$retoure->info['reclamations_id'].'</u></a>';
                }else{
                        $orderadd = '';
                        $orderlink = ' aus <a href="'.xtc_href_link('orders.php','action=edit&oID='.$retoure->info['orders_id']).'"><u>Re-Nr '.$retoure->info['orders_id'].'</u></a>';
                }

                $order = new order($retoure->info['orders_id']);
                $order->add_history($order_status,false,sprintf(TEXT_HISTORY_ORDER_STATUS_UPDATE,$rID.$orderadd,xtc_get_retoure_status_name($status)));

                $retoure->add_history($status,false,TEXT_HISTORY_STATUS_UPDATE);
                $messageStack->add_session(sprintf(MSG_SUCCESS_STATUS_UPDATE,$rID.$orderlink),'success');
        }else{
                $messageStack->add_session(sprintf(MSG_ERROR_NO_STATUS_UPDATE,$rID),'error');
        }
        xtc_redirect(xtc_href_link('retoure.php','action=edit&rID='.$rID));
        break;
    case 'set':
        $rID = (int)xtc_db_input($_GET['rID']);
        $retoure = new retoure($rID);
        $retoure_currency_query = xtc_db_query("SELECT currency FROM reclamations WHERE reclamations_id='".$retoure->info['reclamations_id']."'");
        $retoure_currency = xtc_db_fetch_array($retoure_currency_query);
        $js = [];
        $submit_btn = '';
        for ($i = 0, $n = sizeof($retoure->products); $i < $n; $i++) {
            // collies anzeigen
            $collies = xtc_get_product_collies($retoure->products[$i]['id']);
            if(sizeOf($collies)>0){
                foreach($collies as $kc=>$collie){
                    $cqty = ($retoure->products[$i]['qty']*$collie['quantity']);
                    $js[] = sprintf("var qty_%s = %d;",
                            'collie_'.$retoure->products[$i]['id'].'_'.$collie['collie_products_id'],
                            (int)$cqty
                    );
                }
            }
            $js[] = sprintf("var qty_%s = %d;",
                $retoure->products[$i]['id'],
                (int)$retoure->products[$i]['qty']
            );
        }
        $buttons = array(
            array('text'=>IMAGE_BACK,
                'link'=>xtc_href_link('retoure.php', xtc_get_all_get_params(array('action'))),
                'lbOn'=>false,
                'auth'=>true
            )
        );
        function _get_textbausteine( int $retoure_products_id ){
            $textbausteine = '';
            $textbaustein_query = xtc_db_query(sprintf(
                "SELECT et.* FROM ebay_textitems et,ebay_textitems_user eu WHERE et.module='retoure' and et.id=eu.ebay_textitems_id and eu.customers_id='%d'",
                $_SESSION['customer_id']
            ));
            if(xtc_db_num_rows($textbaustein_query) == 0){
                $textbausteine = sprintf('<br /><i><a href="ebayapi_textitems.php" target="_blank">%s</a></i>',TEXT_NO_RETOURE_TEXTITEMS);
            }else{
                $table = new tableBlock();
                $table->table_parameters = 'class="yesListTable_minimal" style="width: auto;"';
                $contents = [[
                    ['text'=>TEXT_RETOURE_TEXTITEMS,'th'=>true],
                ]];
                while( $textbaustein = xtc_db_fetch_array($textbaustein_query) ){
                    $contents[] = [
                        ['text'=>sprintf('<a href="javascript:;" onClick="textitem(\'%d\',\'%d\');"><u>%s</u></a>%s',
                            $retoure_products_id,
                            $textbaustein['id'],
                            $textbaustein['class'],
                            sprintf('<div style=\'width=1px;height=1px;visibility:hidden;position:absolute; top:-10;left:-40;\'><textarea name="text_%d_%d">%s</textarea></div>',
                                $retoure_products_id,$textbaustein['id'],
                                $textbaustein['text']
                            )
                        )]
                    ];
                }
                $textbausteine = $table->tableBlock_draw($contents);
            }
            return $textbausteine;
        }
        $recla_recs = main::get_notice_recipients('reclamations_update');
        $recipients_select = '';
        $retSmarty = new yesSmarty;
        if( is_countable($recla_recs) and sizeOf($recla_recs) ){
            $table = new tableBlock();
            $table->table_parameters = 'class="yesListTable_minimal" style="width: auto;"';
            $contents = [[
                ['text'=>'&nbsp;'],
                ['text'=>TEXT_NOTICE_RECIPIENTS,'th'=>true],
            ]];
            foreach( $recla_recs as $rcid ){
                $contents[] = [
                    ['text'=>xtc_draw_checkbox_field('notice_to[]',$rcid,false)],
                    ['text'=>xtc_get_editor_name($rcid)]
                ];
            }
            $recipients_select = $table->tableBlock_draw($contents);
        }
        
        $products = [];
        $stk_products = [];
	if($_GET['rstatus'] == '3'){
            $form = xtc_draw_form('update_retoure_status','retoure.php',xtc_get_all_get_params(array('action')).'action=set_now');
            if($retoure->info['reclamations_type'] == '4'){ // FALSCHLIEFERUNG/AUSTAUSCH
                // keine bestand buchungen
            }else{
                for ($i = 0, $n = sizeof($retoure->products); $i < $n; $i++) {
                    $collies = xtc_get_product_collies($retoure->products[$i]['id']);
                    if(!sizeOf($collies)){
                        $rueckbuch_array = array(0=>array('id'=>0,'text'=>TEXT_SELECT_NO_RUECKBUCH));
			$def_array = array(0=>array('id'=>0,'text'=>TEXT_SELECT_NO_DEFECTS));
					
                        for($rb=0;$rb<$retoure->products[$i]['qty'];$rb++){
                            $rueckbuch_array[] = array('id'=>($rb+1),'text'=>($rb+1).' '.TEXT_PCS);
                        }
                        for($rf=0;$rf<$retoure->products[$i]['qty'];$rf++){
                            $def_array[] = array('id'=>($rf+1),'text'=>($rf+1).' '.TEXT_PCS);
                        }
					
                        $products_name = $retoure->products[$i]['name'];
                        if(sizeOf($retoure->products[$i]['properties'])){
                            $products_name .= '<br />'.TEXT_PROPERTIES.'<br />';
                            foreach($retoure->products[$i]['properties'] as $property){
                                $products_name .= sprintf('%s: %s<br />',
                                    $property['property_title'], 
                                    $property['property_value']
                                );
                                if( $property['input_span']>0 ){
                                    $products_name .= sprintf(' - %s: %s',
                                        INPUT_SPAN_USERVALUE,
                                        $property['input_span']
                                    );
                                }
                            }
			}
                        $products[] = [
                            'products_name'=>$products_name,
                            'input_rueckbuch'=>[
                                'field'=>xtc_draw_pull_down_menu('qty_rueckbuch_'.$retoure->products[$i]['id'],$rueckbuch_array,(($_POST)?$_POST['qty_rueckbuch_'.$retoure->products[$i]['id'] ]:$retoure->products[$i]['qty']),'onChange="change_defekts(\''.$rID.'\',\''.$retoure->products[$i]['id'].'\');"'),
                                'label'=>TEXT_QUANTITY_RUECKBUCHEN,
                            ],
                            'input_defect'=>[
                                'label'=>TEXT_QUANTITY_DEFECT,
                                'field'=>xtc_draw_pull_down_menu('qty_defekt_'.$retoure->products[$i]['id'],$def_array,$_POST['qty_defekt_'.$retoure->products[$i]['id']],'onChange="change_rueckbuch(\''.$rID.'\',\''.$retoure->products[$i]['id'].'\');"'),
                            ],
                            'input_comments_defect'=>[
                                'label'=>TEXT_RUECKBUCH_SCHAEDEN,
                                'field'=>xtc_draw_textarea_field('comments_defekt_'.$retoure->products[$i]['id'],'virtual','60','5')
                                    ._get_textbausteine($retoure->products[$i]['id'])
                            ]
                        ];
                    }else{
                        $collies_array = [];
                        $products_name = $retoure->products[$i]['name'];
			foreach($collies as $kc=>$collie){
                            $rueckbuch_array = array(0=>array('id'=>0,'text'=>TEXT_SELECT_NO_RUECKBUCH));
                            $def_array = array(0=>array('id'=>0,'text'=>TEXT_SELECT_NO_DEFECTS));
                            $retoure_qty = $retoure->products[$i]['qty'] * $collie['quantity'];
                            for($rb=0;$rb<$retoure_qty;$rb++){
                                $rueckbuch_array[] = array('id'=>($rb+1),'text'=>($rb+1).' '.TEXT_PCS);
                            }
                            for($rf=0;$rf<$retoure_qty;$rf++){
                                $def_array[] = array('id'=>($rf+1),'text'=>($rf+1).' '.TEXT_PCS);
                            }
                            $collies_array[] = [
                                'products_name'=>'<b>[C]</b> '.xtc_get_products_name( $collie['collie_products_id'] ),
                                'input_rueckbuch'=>[
                                    'field'=>xtc_draw_pull_down_menu('qty_rueckbuch_collie_'.$retoure->products[$i]['id'].'_'.$collie['collie_products_id'],$rueckbuch_array,(($_POST)?$_POST['qty_rueckbuch_collie_'.$retoure->products[$i]['id'].'_'.$collie['collie_products_id'] ]:($collie['quantity']*$retoure->products[$i]['qty']) ),'onChange="change_defekts(\''.$rID.'\',\'collie_'.$retoure->products[$i]['id'].'_'.$collie['collie_products_id'].'\');"'),
                                    'label'=>TEXT_QUANTITY_RUECKBUCHEN,
                                ],
                                'input_defect'=>[
                                    'label'=>TEXT_QUANTITY_DEFECT,
                                    'field'=>xtc_draw_pull_down_menu('qty_defekt_collie_'.$retoure->products[$i]['id'].'_'.$collie['collie_products_id'],$def_array,$_POST['qty_defekt_collie_'.$retoure->products[$i]['id'].'_'.$collie['collie_products_id']],'onChange="change_rueckbuch(\''.$rID.'\',\'collie_'.$retoure->products[$i]['id'].'_'.$collie['collie_products_id'].'\');"'),
                                ],
                                'input_comments_defect'=>[
                                    'label'=>TEXT_RUECKBUCH_SCHAEDEN,
                                    'field'=>xtc_draw_textarea_field('comments_defekt_collie_'.$retoure->products[$i]['id'].'_'.$collie['collie_products_id'],'virtual','60','5'),
                                ]
                            ];
			} // eof foreach collies
                        $stk_products[] = [
                            'products_name'=>$products_name,
                            'qty'=>$retoure->products[$i]['qty'],
                            'collies'=>$collies_array,
                        ];
                    } // end if is collie
		} // end foreach products
            } // end if !falschliefrg/austausch
            $submit_btn = xtc_draw_input_field('anweisen',TEXT_SET_STATUS,'style="width:200px;" onClick="doSubmit();" class="ui-button ui-corner-all ui-state-default"','','button');
	}else if($_GET['rstatus'] == '4'){
            $form = xtc_draw_form('new','retoure.php',xtc_get_all_get_params(array('action')).'action=set_now');
            $input_fields = [
                [
                    'label'=>TEXT_FAILED_CONFIRM_RETOURE,
                    'field'=>xtc_draw_checkbox_field("create_new","1",true)
                ],
                [
                    'label'=>TEXT_NEW_RETOURE_COSTS,
                    'field'=>xtc_draw_input_field('costs',number_format($retoure->info['costs'],2,'.',''))
                ],
                [
                    'label'=>TEXT_NEW_RETOURE_VERSENDER,
                    'field'=>xtc_draw_pull_down_menu('versender',$vers_array,$retoure->info['versender'])
                ]
            ];
            $retSmarty->assign('INPUT_FIELDS',$input_fields);
            $submit_btn = xtc_draw_input_field('anweisen',TEXT_SET_STATUS,'style="width:200px;" onClick="window.location.href=\''.xtc_href_link('retoure.php', xtc_get_all_get_params(array('action','rstatus')).'action=set_now&rstatus=4').'\';" class="ui-button ui-corner-all ui-state-default"','','submit');
	}elseif($_GET['rstatus'] == '2'){
                $submit_btn = xtc_draw_input_field('anweisen',TEXT_SET_STATUS.' / '.TEXT_SET_STATUS_EMAIL,'onClick="window.location.href=\''.xtc_href_link('retoure.php', xtc_get_all_get_params(array('action','rstatus')).'action=set_now&rstatus=2&sendmail=1').'\';" class="ui-button ui-corner-all ui-state-default"','','button'); 
                $submit_btn .= '&nbsp;&nbsp;&nbsp;&nbsp;';
                $submit_btn .= xtc_draw_input_field('anweisen2',TEXT_SET_STATUS.' / '.TEXT_SET_STATUS_NO_EMAIL,'onClick="window.location.href=\''.xtc_href_link('retoure.php', xtc_get_all_get_params(array('action','rstatus')).'action=set_now&rstatus=2').'\';" class="ui-button ui-corner-all ui-state-default"','','button'); 
        }else{
                $submit_btn = xtc_draw_input_field('anweisen',TEXT_SET_STATUS,'onClick="window.location.href=\''.xtc_href_link('retoure.php', xtc_get_all_get_params(array('action','rstatus')).'action=set_now&rstatus=2').'\';" class="ui-button ui-corner-all ui-state-default"','','button'); 
        } 
        $retSmarty->assign([
            'language_path' => DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
            'SET_MODE'=>1,
            'PRODUCTS_AND_COLLIES_JS'=>implode("\n",$js),
            'TEXT_UPDATE_RETOURE_STATUS'=>sprintf(TEXT_UPDATE_RETOURE_STATUS,
                    xtc_get_retoure_status_name($_GET['rstatus'])
            ),
            'FORM'=>$form,
            'TEXT_FALSCHLIEFERUNG_KEINE_BESTANDSKORREKTUR'=>TEXT_FALSCHLIEFERUNG_KEINE_BESTANDSKORREKTUR,
            'RETOURE_TARGET_STATUS'=>(isset($_GET['rstatus']) and $_GET['rstatus'] != '') ? (int)$_GET['rstatus']:0,
            'RETOURE_TARGET_RECLAMATION_TYPE'=>$retoure->info['reclamations_type'],
            'TEXT_RUECKBUCHUNG_WARENBESTAND'=>TEXT_RUECKBUCHUNG_WARENBESTAND,
            'TEXT_QUANTITY_RUECKBUCHEN'=>TEXT_QUANTITY_RUECKBUCHEN,
            'TEXT_STUECKLISTENPRODUKT'=>TEXT_STUECKLISTENPRODUKT,
            'STKLISTEN_PRODUCTS'=>$stk_products,
            'PRODUCTS'=>$products,
            'NOTICE_RECIPIENTS'=>$recipients_select,
            'SUBMIT'=>$submit_btn,
            'CURRENT_STATUS'=>xtc_get_retoure_status_name($retoure->info['retoure_status']),
            'TEXT_CURRENT_STATUS'=>TEXT_CURRENT_STATUS,
        ]);
        $retSmarty->display('retoure.html');
        exit;
}
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<script type="text/javascript"><!--
// PROTOTYPE ONLOAD FUNCTION INIT
var ONLOADPAGE = 'retoure';
<?php 
if(!isset($_GET['action'])){?> 
var ONLOADFUNC = "ajax_onload";
var ONLOADFUNCPARAM = 'change_retoure'; // FORMNAME AJAXLISTING
<?php }else if($_GET['action'] == 'edit'){?>
// NOT ACTIVE
var ONLOADFUNC = "";
//var ONLOADFUNCPARAM = "info";
<?php } ?>
//-->
</script>
<?php
if(isset($_REQUEST['action']) and $_REQUEST['action'] != ''){
    $buttons = array(
	array('text'=>IMAGE_BACK,
	    'link'=>xtc_href_link('retoure.php', xtc_get_all_get_params(array('action'))),
	    'lbOn'=>false,
	    'auth'=>true
	),
	array('text'=>IMAGE_CRM,
	    'link'=>xtc_href_link(FILENAME_CUSTOMERS, 'cID=' . $retoure->delivery['ID'].'&action=crm'),
	    'lbOn'=>false,
	    'auth'=>true
	),
	array('text'=>ADD_QUICKNOTE,
	    'link'=>"javascript:toggleBox('addquicknote');",
	    'lbOn'=>false,
	    'auth'=>true
	),
    );
    $add_title = 'Status '.xtc_get_retoure_status_name($retoure->info['retoure_status']).' - ';
    $add_title .= TEXT_ORDER.' '.$retoure->info['orders_id'].(($retoure->info['reclamations_id'] > 0)? ' / '.TEXT_RECLAMATION.' '.$retoure->info['reclamations_id'] : '');
    $smarty->assign(array(
        'language_path' => DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
	'HEADING_TITLE' => sprintf(HEADING_TITLE,$rID,xtc_date_short($retoure->info['date_created'])),
	'ADDITIONAL_HEADING_TITLE' => $add_title,
	'PAGE_HEADING_MENU_BUTTONS'=>$buttons
    ));
    $smarty->display('retoure.html');
}
yes_draw_quicknote();
  /* * * * * * * * * * * * * * * * * * * * * * * * * * *
  Retoure EDIT
  * * * * * * * * * * * * * * * * * * * * * * * * * * */
  if ( (isset($_GET['action']) and $_GET['action'] == 'edit') && ($retoure_exists) ) {
      $rID = (int)xtc_db_input($_GET['rID']);
	$retoure = new retoure($rID);
	$retoure_currency_query = xtc_db_query("SELECT currency,reclamations_type FROM reclamations WHERE reclamations_id='".$retoure->info['reclamations_id']."'");
  	$retoure_currency = xtc_db_fetch_array($retoure_currency_query);
        $reclamations_type = $retoure_currency['reclamations_type'];
	$order = new order($retoure->info['orders_id']);
        $smarty = new yesSmarty();
        $anz = \YES4Trade\Model\customers_memo::count_by_customers_id((int)$retoure->delivery['ID']);
        
        if($reclamations_type == '4'){ // falschlieferung neuversand
            $smarty->assign('FALSCHLIEFERUNGNEUVERSAND',1);
            if($retoure->info['retoure_status'] == '1'){
                $smarty->assign('FALSCHLIEFERUNGNEUVERSAND_ALLOW_EDIT',1);
            }
        }
        
        $customers_query = xtc_db_query("select c.kto_nummer,c.kto_inhaber,c.kto_blz,c.kto_bank,c.customers_ebay_userid,c.customers_id,c.customers_cid, c.customers_gender, c.customers_firstname, c.customers_lastname, c.customers_dob, c.customers_email_address, a.entry_company, a.entry_street_address, a.entry_suburb, a.entry_postcode, a.entry_city, a.entry_state, a.entry_zone_id, a.entry_country_id, c.customers_telephone, c.customers_fax, c.customers_newsletter, c.customers_default_address_id from " . TABLE_CUSTOMERS . " c left join " . TABLE_ADDRESS_BOOK . " a on c.customers_default_address_id = a.address_book_id where a.customers_id = c.customers_id and c.customers_id = '" . $retoure->delivery['ID'] . "'");
        $customers = xtc_db_prepare_input(xtc_db_fetch_array($customers_query));
        $cInfo = new objectInfo($customers);
        for ($i = 0, $n = sizeof($retoure->products); $i < $n; $i++) {
            $retoure->products[$i] = xtc_db_prepare_input($retoure->products[$i]);
        }
        $page_buttons = array();
        switch($retoure->info['retoure_status']){
                case '1':
                    $page_buttons[] = yes_draw_href_button(BUTTON_ABHOLUNG_ANGEWIESEN, 
                       xtc_href_link('retoure.php', xtc_get_all_get_params(array('action')).'action=set&rstatus=2'),
                       'width:200px;',
                       'button',
                       'lbOn ui-button ui-corner-all ui-state-default'
                    );
                    break;
                case '2':
                    $page_buttons[] = yes_draw_href_button(BUTTON_ABHOLUNG_OK, 
                        xtc_href_link('retoure.php', xtc_get_all_get_params(array('action')).'action=set&rstatus=3'),
                        'width:200px;',
                        'button',
                        'lbOn ui-button ui-corner-all ui-state-default'
                    );
                    $page_buttons[] = yes_draw_href_button(BUTTON_ABHOLUNG_FAILED, 
                        xtc_href_link('retoure.php', 
                        xtc_get_all_get_params(array('action')).'action=set&rstatus=4'),
                        'width:200px;',
                        'button',
                        'lbOn ui-button ui-corner-all ui-state-default'
                    );
                    break;
        }
        $page_buttons[] = yes_draw_href_button(
                TEXT_RETOURE.' '.TEXT_PRINT, 
                'javascript:window.open(\''.xtc_href_link('print_retoure.php','rID='.$rID).'\', \'popup\', \'toolbar=0, width=640, height=600, resizable=1,scrollbars=1\');',
                '',
                'button',
                'ui-button ui-corner-all ui-state-default'
        );
        $page_buttons[] = yes_draw_href_button(
                TEXT_ADD_COMMENT, 
                xtc_href_link('retoure_update.php',xtc_get_all_get_params()),
                '',
                'button',
                'lbOn ui-button ui-corner-all ui-state-default add_comment_link'
        );
        
        $history = array();
        $rh = \YES4Trade\Model\retoure_status_history::get_by_retoure_id( (int)$rID );
        $table = new tableBlock();
        $table->table_parameters = 'class="yesListTable_minimal" style="width: auto;"';
        $contents = [[
            ['text'=>TEXT_DATE_CREATED,'th'=>true],
            ['text'=>TEXT_CUSTOMER_NOTIFIED,'th'=>true],
            ['text'=>'Status','th'=>true],
            ['text'=>TEXT_COMMENT,'th'=>true],
            ['text'=>'Editor','th'=>true],
        ]];
        foreach($rh as $rhi){
            $contents[] = [
                ['text'=>$rhi->date_added->format('Y-m-d H:i:s')],
                ['text'=>($rhi->customer_notified == 1)?'&#x2610;':'&#x2611;'],
                ['text'=>xtc_get_retoure_status_name($rhi->retoure_status_id)],
                ['text'=>xtc_get_editor_name($rhi->editor_id)],
                ['text'=>nl2br(xtc_db_output($rhi->comments))]
            ];
        }
        $history_table = $table->tableBlock_draw($contents);
        
        $admin_access = main::get_admin_access();
        $smarty->assign(array(
            'ADDRESS'=>$retoure->delivery,
            'LINK_EDIT_ADDRESS'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action','address_type')).'action=ajax_address_edit&address_type=shipping'),
            'TEXT_SHIPPING_ADDRESS'=>TEXT_SHIPPING_ADDRESS,
            'EDIT_MODE'=>true,
            'language_path' => DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
            'TEXT_MEMOS'=>TEXT_MEMOS,
            'MEMO_COUNT'=>$anz,
            'DISPLAY_MEMOS'=>DISPLAY_MEMOS,
            'EXT_POPUP_HEIGHT'=>EXT_POPUP_HEIGHT,
            'EXT_POPUP_WIDTH'=>EXT_POPUP_WIDTH,
            'POPUP_MEMO_LINK'=>xtc_href_link(FILENAME_CUSTOMERS,'action=memo&cID='.$retoure->delivery['ID']),
            'TEXT_CUSTOMERS_ID'=>TEXT_CUSTOMERS_ID,
            'TEXT_COSTS'=>TEXT_COSTS,
            'COSTS'=>number_format($retoure->info['costs'],2,',','').' '.$retoure_currency['currency'],
            'TEXT_RETOURE_SHIPPER'=>TEXT_RETOURE_SHIPPER,
            'TEXT_DATE_CREATED'=>TEXT_DATE_CREATED,
            'TEXT_DATE_FINISHED'=>TEXT_DATE_FINISHED,
            'TEXT_ORDER'=>TEXT_ORDER,
            'TEXT_RECLAMATION'=>TEXT_RECLAMATION,
            'INFO'=>$retoure->info,
            'DATE_CREATED'=>xtc_date_long($retoure->info['date_created']),
            'DATE_FINISHED'=>($retoure->info['date_finished'] > 0) ? xtc_date_long($retoure->info['date_finished']) : '',
            'ORDER_LINK'=>xtc_href_link('orders.php','action=edit&oID='.$retoure->info['orders_id']),
            'RECLAMATION_LINK'=>xtc_href_link('reclamations.php','action=edit&rID='.$retoure->info['reclamations_id']),
            'RECLAMATION_TYPE'=>xtc_get_reclamations_types_name($retoure->info['reclamations_type']),
            'CRM_LINK'=>xtc_href_link('customers.php','action=edit&cID='.$retoure->delivery['ID']),
            'cInfo'=>(array)$cInfo,
            'CINFO_COUNTRY'=>xtc_get_country_name($cInfo->entry_country_id),
            'TEXT_PRODUCT'=>TEXT_PRODUCT,
            'TEXT_PRODUCTS_MODEL'=>TEXT_PRODUCTS_MODEL,
            'products'=>$retoure->products,
            'TEXT_PROPERTIES'=>TEXT_PROPERTIES,
            'page_buttons'=>$page_buttons,
            'TEXT_ADD_COMMENT'=>TEXT_ADD_COMMENT,
            'TEXT_DATE_CREATED'=>TEXT_DATE_CREATED,
            'TEXT_CUSTOMER_NOTIFIED'=>TEXT_CUSTOMER_NOTIFIED,
            'TEXT_COMMENT'=>TEXT_COMMENT,
            'TEXT_NO_HISTORY'=>TEXT_NO_HISTORY,
            'history'=>$history,
            'ALLOW_ADDRESS_EDIT'=>true,
            'HISTORY_TABLE'=>$history_table
        ));
        $smarty->display('retoure.html');
} else {
	include('retoure_listing.php');
}
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');