<?php
/* --------------------------------------------------------------
   $Id: stats_kasse.php,v 1.100 2020/06/19 05:48:59 ssh-511548-cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(stats_products_purchased.php,v 1.27 2002/11/18); www.oscommerce.com 
   (c) 2003	 nextcommerce (stats_products_purchased.php,v 1.9 2003/08/18); www.nextcommerce.org

   Released under the GNU General Public License 
   --------------------------------------------------------------*/

require('includes/application_top.php');
require(DIR_FS_INC.'xtc_get_customer_status_value.inc.php');
require(DIR_WS_CLASSES . 'currencies.php');
require(DIR_WS_CLASSES . 'order.php');
require(DIR_WS_CLASSES . 'rueckerstattung.php');
require(DIR_WS_CLASSES . 'yes_lister_table_heading_sort.php');
$currencies = new currencies();
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');

$action = $_GET['action'] ?? null;

if($action == 'tagesabschluss_confirm'){
    $branches = array(array(
        'id'=>'',
        'text'=>'-- Filialauswahl --'
    ));
    if(defined('YES_BRANCHES_COUNT') and YES_BRANCHES_COUNT > 0){
        $branches_query = xtc_db_query("select * from branches ORDER by title");
        while($branch = xtc_db_fetch_array($branches_query)){
            $text = xtc_db_prepare_input($branch['title']);
            $branches[] = array(
                'id'=>$branch['branches_id'],
                'text'=>$text
            );
        }
    }else{
        $branches[] = array(
            'id'=>'0',
            'text'=>TEXT_MAIN_STORAGE
        );
    }
    if(!stristr(CHARSET,'utf-8')){
        header('content-type: text/html; charset=utf-8');
    }
    $default_branches_id = (isset($_SESSION['allocated_branches_id'])) ? $_SESSION['allocated_branches_id'] : '';
    printf('<p>%s</p>%s',
            TEXT_TAGESABSCHLUSS_CONFIRMATION, 
            xtc_draw_pull_down_menu('branches_id', $branches,$default_branches_id,'id="tagesabschluss_branches_id"')
    );
    exit;
}
if($action == 'tagesabschluss'){
    require_once('counter_history.php');
    exit;
}


define('KASSE_DEFAULT_CUSTOMER',KASSE_USER);
  
// yes accounting  
$admin_access = main::get_admin_access();
// default detail no detail
$srDefaultDetail = 0;
// default view (daily)
$srDefaultView = 2;
// default export
$srDefaultExp = 0;
// default sort
$srDefaultSort = 4;


$report = $_GET['report'] ?? null;
$detail = $_GET['detail'] ?? null;
$export = $_GET['export'] ?? null;
$max = $_GET['max'] ?? null;
$status = $_GET['status'] ?? null;
$oID = $_GET['oID'] ?? null;
// report views (1: yearly 2: monthly 3: weekly 4: daily)
if ( $report !== null ){
    $srView = (int)xtc_db_input($report);
    if($srView < 1 || $srView > 4){
        $srView = $srDefaultView;
    }
}

// detail
if ($detail !== null){
    $srDetail = (int)xtc_db_input($detail);
    if ($srDetail < 0 || $srDetail > 2) {
        $srDetail = $srDefaultDetail;
    }
}
  
// report views (1: yearly 2: monthly 3: weekly 4: daily)
if ( $export !== null ){
    $srExp = (int)xtc_db_input($export);
    if ($srExp < 0 || $srExp > 2) {
        $srExp = $srDefaultExp;
    }
}
  
// item_level
$srMax = 0;
if ( $max !== null ) {
    $srMax = (int)xtc_db_input($max);
}
     
// order status
$srStatus = 0;
if ( $status !== null ){
    $srStatus = (int)xtc_db_input($status);
}

$startDate = $_REQUEST['startDate'] ?? date('Y-m-d', strtotime('-7 days'));
$startDateAsTime = strtotime($startDate);

$endDate = $_REQUEST['endDate'] ?? date('Y-m-d');
$endDateAsTime = strtotime($endDate);

if($action == 'set_paydate'){
    if( $oID === null ){
        $messageStack->add_session(MSG_ERROR_NO_ORDERS_ID,'error');
        xtc_redirect(xtc_href_link('stats_kasse.php',xtc_get_all_get_params(array('action','oID'))));
    }
}else if($action == 'set_branch'){
    if( $oID === null ){
        $messageStack->add_session(MSG_ERROR_NO_ORDERS_ID,'error');
        xtc_redirect(xtc_href_link('stats_kasse.php',xtc_get_all_get_params(array('action','oID'))));
    }
}else if($action == 'save_paydate'){
    if( $oID !== null ){
        $oID = (int)xtc_db_input($oID);
        // yes accounting
        if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_kasse_change_paydate'] == '1')) {
            if(isset($_POST['new_date']) and strlen($_POST['new_date']) == 10){
                $new = xtc_db_input($_POST['new_date']).' '.date('H:s');
                $update_sql_array = [
                    'date_purchased'=>$new
                ];
                xtc_db_perform('kasse',$update_sql_array,'update',
                    "orders_id='".$oID."'"
                );
                $order = new order($oID);
                $comments = sprintf(HISTORY_CHANGE_PAYDATE,$new);
                $order->add_history($order->info['orders_status'], false, $comments);
				
                $comments = sprintf(MSG_SUCCESS_CHANGE_PAYDATE, $oID, $new);
		$messageStack->add_session($comments,'success');
            }else{
                $messageStack->add_session(MSG_ERROR_DATE_FORMAT,'error');
            }
	}else{
            $messageStack->add_session(MSG_ERROR_AUTH,'error');
	}
    }else{
	$messageStack->add_session(MSG_ERROR_NO_ORDERS_ID,'error');
    }
    xtc_redirect(xtc_href_link('stats_kasse.php',xtc_get_all_get_params(array('action','oID'))));
}else if($action == 'save_branch'){
    if( $oID !== null ){
        $oID = (int)xtc_db_input($oID);
        // yes accounting
        if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_kasse_change_branch'] == '1')) {
            $new = (int)xtc_db_input($_POST['branches_id']);
            $update_sql_array = [
                'branches_id'=>$new
            ];
            xtc_db_perform('kasse',$update_sql_array,'update',
                "orders_id='".$oID."'"
            );
            $order = new order($oID);
            $comments = sprintf(HISTORY_CHANGE_BRANCH,xtc_get_branch_title($new));
            $order->add_history($order->info['orders_status'],false,$comments);
            $messageStack->add_session(MSG_SUCCESS_CHANGE_BRANCH,'success');
        }else{
            $messageStack->add_session(MSG_ERROR_AUTH,'error');
        }
    }else{
        $messageStack->add_session(MSG_ERROR_NO_ORDERS_ID,'error');
    }
    xtc_redirect(xtc_href_link('stats_kasse.php',xtc_get_all_get_params(array('action','oID'))));
}else{
    $select_field_array = array(
        0=>array(
            'field'=>'orders_id',
            'heading'=>TABLE_HEADING_ORDER,
            'format'=>'string',
            'get_param'=>'orders_id',
            'sortable'=>1,
            'index'=>true,
            'column'=>0
        ),
        1=>array(
            'field'=>'products_id',
            'heading'=>TABLE_HEADING_PRODUCTS,
            'format'=>'string',
            'get_param'=>'',
            'sortable'=>0,
            'function'=>'',
            'column'=>1
        ),
        2=>array(
            'field'=>'ot_total',
            'heading'=>TABLE_HEADING_TOTAL,
            'format'=>'string',
            'get_param'=>'',
            'sortable'=>0,
            'function'=>'',
            'column'=>2
        ),
        3=>array(
            'field'=>'customers_id',
            'heading'=>TABLE_HEADING_CUSTOMER,
            'format'=>'string',
            'get_param'=>'',
            'sortable'=>0,
            'column'=>3
        ),
        4=>array(
            'field'=>'k.date_purchased',
            'heading'=>TABLE_HEADING_DATE,
            'format'=>'date',
            'get_param'=>'k.date_purchased',
            'sortable'=>1,
            'column'=>4
        ),
        5=>array(
            'field'=>'paymode',
            'heading'=>TABLE_HEADING_PAYMENTMETHOD,
            'format'=>'string',
            'get_param'=>'paymode',
            'sortable'=>1,
            'column'=>5
        ),
        6=>array(
            'field'=>'send',
            'heading'=>TABLE_HEADING_SHIPPING,
            'format'=>'string',
            'get_param'=>'send',
            'sortable'=>1,
            'column'=>6
        ),
        7=>array(
            'field'=>'editor',
            'heading'=>TABLE_HEADING_EDITOR,
            'format'=>'string',
            'get_param'=>'',
            'sortable'=>0,
            'column'=>7
        )
    );
    $YLTHS = new yes_lister_table_heading_sort($select_field_array,'stats_kasse.php');
    $headings = $YLTHS->getHeadingRows($smarty);
    $branches_id = $_GET['branches_id'] ?? null;
    $branches_sql_filter = '';
    if($branches_id !== null){
        $branches_sql_filter = " AND k.branches_id='".intval($branches_id)."' ";
    }

    $order_by = 'o.orders_id DESC';
    $order_by_param = $_REQUEST['order_by']??null;
    if($order_by_param !== null){
        $parts = explode(' ',$order_by_param);
        $db_field = $parts[0];
        $direction = $parts[1];
        $order_by = xtc_db_input(strtolower($db_field.' '.$direction));
    }
	
    $saved_orders = array();  
    $query_raw = "select k.send,k.orders_id,DATE_FORMAT(k.date_purchased,'%d.%m.%Y %H:%i:%s') as date,k.paymode,k.branches_id "
        ."    from kasse k LEFT JOIN orders o USING(orders_id) "
        ."where UNIX_TIMESTAMP(k.date_purchased) > $startDateAsTime "
        ." AND UNIX_TIMESTAMP(k.date_purchased) < $endDateAsTime "
        ." AND k.paymode != 'BANK' $branches_sql_filter "
        ." AND o.orders_status != ".ORDERS_STATUS_STORNIERT
        ." order by $order_by";
    $cust_query = xtc_db_query($query_raw);
	while($order = xtc_db_fetch_array($cust_query)){
            $editor_query = xtc_db_query("SELECT editor_id FROM orders_status_history WHERE orders_id='".$order['orders_id']."' and (orders_status_id='".ORDERS_STATUS_ABGESCHLOSSEN."' or orders_status_id='".ORDERS_STATUS_BEZAHLT."') ORDER BY orders_status_id DESC LIMIT 1");
            $editor = xtc_db_fetch_array($editor_query);
            $editor_id = $editor['editor_id'];
            if(!in_array($order['orders_id'],$saved_orders)){ // doppelte verhindern
                $order_data[] = array('send'=>$order['send'],
                    'oID'=>$order['orders_id'],
                    'date_purchased'=>$order['date'],
                    'paymode'=>strtoupper($order['paymode']),
                    'editor'=>xtc_get_editor_name($editor_id),
                    'branches_id'=>$order['branches_id'] 
                );
                $saved_orders[] = $order['orders_id'];
            }
	}

	$saved_storno_orders = array();  
	$query_storno_raw = "select o.orders_date_storno,k.send,k.orders_id,DATE_FORMAT(k.date_purchased,'%d.%m.%Y %H:%i:%s') as date,k.paymode,k.branches_id 
		from kasse k,orders o 
		where UNIX_TIMESTAMP(o.orders_date_storno) > $startDateAsTime 
			and UNIX_TIMESTAMP(o.orders_date_storno) < $endDateAsTime 
			and o.orders_id=k.orders_id and o.orders_status = '".ORDERS_STATUS_STORNIERT."' and k.paymode != 'BANK' ".$branches_sql_filter." 
		order by k.customers_id DESC";

	$cust_storno_query = xtc_db_query($query_storno_raw);
	while($storno_order = xtc_db_fetch_array($cust_storno_query)){
		$editor_query = xtc_db_query("SELECT editor_id FROM orders_status_history WHERE orders_id='".$storno_order['orders_id']."' and orders_status_id='".ORDERS_STATUS_STORNIERT."' LIMIT 1");
		$editor = xtc_db_fetch_array($editor_query);
		$editor_id = $editor['editor_id'];
		if(!in_array($storno_order['orders_id'],$saved_storno_orders)){ // doppelte verhindern
			$order_storno_data[] = array('send'=>$storno_order['send'],'oID'=>$storno_order['orders_id'],
				'date_purchased'=>$storno_order['date'],
				'date_storno'=>(($storno_order['orders_date_storno']>0)?xtc_date_long($storno_order['orders_date_storno']):$storno_order['date']),
				'paymode'=>strtoupper($storno_order['paymode']),'editor'=>xtc_get_editor_name($editor_id),'branches_id'=>$storno_order['branches_id'] 
			);
			$saved_storno_orders[] = $storno_order['orders_id'];
		}
	}
	
	$rueckerstattungen_array = array();  
	$rueckerstattungen_data = array();
	$query_rueckerstattungen_raw = "select r.*,DATE_FORMAT(r.date_payment,'%d.%m.%Y %H:%i:%s') as datepayment,DATE_FORMAT(r.date_created,'%d.%m.%Y %H:%i:%s') as datecreated from rueckerstattungen r 
		where UNIX_TIMESTAMP(r.date_payment) > $startDateAsTime 
			and UNIX_TIMESTAMP(r.date_payment) < $endDateAsTime 
			and r.status=2 and r.type=3 
			order by r.customers_id,r.date_payment DESC";

	$rueckerstattungen_query = xtc_db_query($query_rueckerstattungen_raw);
	$_rueck = array();
	while($rueckerstattungen = xtc_db_fetch_array($rueckerstattungen_query)){
	    $_rueck[] = $rueckerstattungen;
	}
	foreach($_rueck as $rueckerstattungen){
		if(!in_array($rueckerstattungen['rueckerstattungs_id'],$rueckerstattungen_array)){ // doppelte verhindern
		    $editor_query_raw = sprintf(
			    "SELECT editor_id FROM rueckerstattungen_status_history WHERE rueckerstattungen_id='%s' AND rueckerstattungen_status_id='2' ORDER BY date_added DESC",
			    $rueckerstattungen['rueckerstattungs_id']
		    );
		    $editor_query = xtc_db_query($editor_query_raw);
		    $editor_record = xtc_db_fetch_array($editor_query);
		    $rueckerstattungen_data[] = array(
			'send'=>0,
			'rID'=>$rueckerstattungen['rueckerstattungs_id'],
			'date_purchased'=>$rueckerstattungen['datecreated'],
			'date_storno'=>$rueckerstattungen['datepayment'],
			'paymode'=>$rueckerstattungen['paymode'],
			'editor'=>xtc_get_editor_name($editor_record['editor_id']),
			'branches_id'=>0
		    );
		    $rueckerstattungen_array[] = $storno_order['orders_id'];
		}
	}
}

$smarty->assign(array(
	'DEFAULT_CURRENCY'=>DEFAULT_CURRENCY,
	'HEADING_TITLE'=>HEADING_TITLE,
	'TEXT_REPORT_STARTDATE'=>TEXT_REPORT_STARTDATE,
	'srExp'=>((isset($srExp))?$srExp:''),
	'view'=>((isset($_GET['view']))?$_GET['view']:''),
	'action'=>($action === null)?'':$action,
	'details'=>((isset($_GET['details']))?$_GET['details']:''),
	'LINK_BACK'=>xtc_href_link('stats_kasse.php'),
	'TEXT_LINK_BACK'=>LINK_BACK,
	'TEXT_STATS_FROM'=>sprintf(TEXT_STATS_FROM_TO,$startDate,$endDate),
	'TEXT_CHANGE_BRANCHCOUNTER'=>TEXT_CHANGE_BRANCHCOUNTER,
	'SEPARATOR'=>xtc_draw_separator('pixel_black.gif'),
	'TEXT_NO_RESULTS'=>TEXT_NO_RESULTS,
	'IMAGE_SAVE'=>IMAGE_SAVE,
	'HEADINGS'=>$headings,
	'TEXT_RUECKERSTATTUNGEN_FOR_TIMEFRAME'=>TEXT_RUECKERSTATTUNGEN_FOR_TIMEFRAME
));
if (!isset($srExp) or $srExp < 1) {
	$smarty->assign(array(
		'startDate'=>$startDate,
		'endDate'=>$endDate,
		'TEXT_DETAILS_HIDE'=>TEXT_DETAILS_HIDE,
		'INPUT_DETAILS'=>xtc_draw_checkbox_field('details',1,((isset($_GET['details']) and $_GET['details'] == '1') ? 1:0)),
		'TEXT_REPORT_ENDDATE'=>TEXT_REPORT_ENDDATE,
		'INPUT_SUBMIT'=>IMAGE_SHOW,
		'INPUT_REPORT'=>IMAGE_PRINTVIEW,
		'IMAGE_EXPORT_CSV'=>IMAGE_EXPORT_CSV,
		'REPORT_LINK'=>'../templates/'.CURRENT_TEMPLATE.'/admin/kassenbericht.html',
		'LINK_PRINT_TEMPLATE'=>LINK_PRINT_TEMPLATE,
		'INPUT_VIEW'=>xtc_draw_hidden_field('view',''),
		'IMAGE_EDIT'=>IMAGE_EDIT,
		'SEPARATOR'=>xtc_draw_separator('pixel_black.gif'),
		'TEXT_STORNO_FOR_TIMEFRAME'=>TEXT_STORNO_FOR_TIMEFRAME,
		'TEXT_SUM_TOTAL'=>TEXT_SUM_TOTAL,
		'TEXT_SUM_TOTAL_FOR_TIMEFRAME'=>TEXT_SUM_TOTAL_FOR_TIMEFRAME,
	    'TEXT_DISCOUNT_FOR_TIMEFRAME'=>TEXT_DISCOUNT_FOR_TIMEFRAME
	));
	// FILIALHANDLING
	$branches_array = array(0=>array('id'=>'','text'=>TEXT_ALL_BRANCHES));
	$branches_query = xtc_db_query("SELECT * FROM branches");
	if(xtc_db_num_rows($branches_query)){
		$branches_array[] = array('id'=>'0','text'=>TEXT_MAINSTORAGE);
	}
	while($branches = xtc_db_fetch_array($branches_query)){
		$branches_array[] = array('id'=>$branches['branches_id'],'text'=>$branches['title']);
	}
	if(sizeOf($branches_array)>1){
		$smarty->assign('INPUT_BRANCHES_ID',xtc_draw_pull_down_menu('branches_id',$branches_array,((isset($_GET['branches_id']))?$_GET['branches_id']:'')));
	}
} // end of ($srExp < 1)

$different_tax_titles = array();
$tax_stats = array();
if($action === null or ($action != 'set_paydate' and $action != 'set_branch')){
	if(isset($_GET['view']) and $_GET['view'] == 'raw') $tr = ''; else $tr = ' class="dataTableRow"';
	if(isset($order_data) and sizeOf($order_data)>0){
		$gesamt = 0;
		$discount = 0;
		$kasse_gesamt = array();
		$diffpay = array();
		$kasse_diffpay = array();
		$items = array();
		foreach ($order_data as $k=>$kasse) {
			$oID = $kasse['oID'];
			$date = $kasse['date_purchased'];
			$paymode = $kasse['paymode'];
			$versand = ($kasse['send'] > 0) ? 'ja':'nein';
			$order=new order($oID);	
			$number = '';
			if( defined('MODULE_OTHER_FIBUNUMBERS_STATUS') and MODULE_OTHER_FIBUNUMBERS_STATUS == 'True'){
				$number = $order->get_fibunumber();
			}
			foreach($order->totals as $k=>$total){
				if($total['class']=='ot_total' and $paymode != 'BANK'){
					$gesamt += $total['value'];
					if(!isset($kasse_gesamt[ $kasse['branches_id'] ]))
						$kasse_gesamt[ $kasse['branches_id'] ] = 0;
					$kasse_gesamt[ $kasse['branches_id'] ] += $total['value'];
					$paymode_str = ($paymode == '') ? 'Bar' : $paymode;
					if(!isset($diffpay[$paymode_str]))
						$diffpay[$paymode_str] = 0;
					$diffpay[$paymode_str] += $total['value'];
					if(!isset($kasse_diffpay[ $kasse['branches_id'] ][ $paymode_str ]))
						$kasse_diffpay[ $kasse['branches_id'] ][ $paymode_str ] = 0;
					$kasse_diffpay[ $kasse['branches_id'] ][ $paymode_str ] += $total['value'];
				}
				if($total['class'] == 'ot_tax'){
				    $different_tax_titles[ $total['title'] ] = true;
				}
				if($total['class'] == 'ot_discount'){
				    $discount += $total['value'];
				}
                                if($total['class'] == 'ot_tax'){
                                    $trp = number_format($total['tax_rate_percent'],1,'.','');
                                    if(!isset($tax_stats[$trp] )){
                                        $tax_stats[$trp] = 0;
                                    }
                                    $tax_stats[$trp] += $total['value'];
                                }
			}
			if(!isset($_GET['details']) or $_GET['details'] != '1'){
				if($order->customer['ID'] != KASSE_DEFAULT_CUSTOMER ) { 
					$cstatus_query = xtc_db_query("select cs.customers_status_name FROM customers as c left join customers_status as cs on customers_status = customers_status_id where c.customers_id='".$order->customer['ID']."' and cs.language_id = '".$_SESSION['languages_id']."'");
					$cstatus = xtc_db_fetch_array($cstatus_query);
					$customer_status = $cstatus['customers_status_name'];
					$cInfo = xtc_address_format($order->customer['format_id'], $order->customer, 1, '', '<br />');
				}else{
					$customer_status = '';
					$cInfo = TEXT_COUNTER_SALE;
				}
				$set_paydate_link = '';
				if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_kasse_change_paydate'] == '1')) {
					$set_paydate_link = xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action','oID','from')).'action=change_paydate&oID='.$oID.'&from='.urlencode(xtc_href_link(basename(__FILE__),xtc_get_all_get_params())) );
				}
				if($kasse['branches_id'] > 0)
					$branch = xtc_get_branch_title($kasse['branches_id']);
				else
					$branch = TEXT_MAINSTORAGE;
				$set_branch_link = '';
				if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_kasse_change_branch'] == '1')) {
					$set_branch_link = xtc_href_link('stats_kasse.php',xtc_get_all_get_params(array('action','oID')).'action=set_branch&oID='.$oID);
				}
                                $cashier = '';
                                if(defined('MODULE_OTHER_FIBUNUMBERS_STATUS') and MODULE_OTHER_FIBUNUMBERS_STATUS == 'True'){
                                    $cashier = $order->get_cashier();
                                }
				$items[] = array(
					'tr_param'=>$tr,
					'link_order'=>xtc_href_link('orders.php','action=edit&oID='.$oID.'&cID='.$order->customer['ID']),
					'oID'=>$oID,
					'orders_status_name'=>xtc_get_orders_status_name($order->info['orders_status']),
					'number'=>$number,
					'products'=>$order->products,
					'totals'=>$order->totals,
					'cinfo'=>$cInfo,
					'customer_status'=>$customer_status,
					'date'=>$date,
					'set_paydate_link'=>$set_paydate_link,
					'paymode'=>$paymode,
					'versand'=>$versand,
					'editor'=>$kasse['editor'],
					'branch'=>TEXT_BRANCH.' '.$branch,
					'set_branch_link'=>$set_branch_link,
                                    'cashier'=>$cashier
				);
			} // end details
		} // end foreach
		$smarty->assign('items',$items);
	}
	$gesamt_storno = 0.00;
	$kasse_gesamt_storno = array();
	$smarty->assign('items_storno_size',((isset($order_storno_data))?sizeOf($order_storno_data):0));
	$diffpay_storno = array();
	$kasse_diffpay_storno = array();
	$storno_items = array();
	if(isset($order_storno_data) and sizeOf($order_storno_data) > 0){
		foreach ($order_storno_data as $k=>$kasse) {
			$oID = $kasse['oID'];
			$date = $kasse['date_storno'];
			$paymode = $kasse['paymode'];
			$versand = ($kasse['send'] > 0) ? 'ja':'nein';
			$order=new order($oID);		
			foreach($order->totals as $k=>$total){
				if($total['class']=='ot_total'){
					$gesamt_storno -= $total['value'];
					$paymode_str = ($paymode == '') ? 'Bar' : $paymode;
					$kasse_gesamt_storno[ $kasse['branches_id'] ] -= $total['value'];
					if(!isset($diffpay_storno[$paymode_str]))
						$diffpay_storno[$paymode_str] = 0;
					$diffpay_storno[$paymode_str] += $total['value'];
					if(!isset($kasse_diffpay_storno[ $kasse['branches_id'] ][ $paymode_str ]))
						$kasse_diffpay_storno[ $kasse['branches_id'] ][ $paymode_str ] = 0;
					$kasse_diffpay_storno[ $kasse['branches_id'] ][ $paymode_str ] += $total['value'];
				}
                                if($total['class'] == 'ot_tax'){
                                    $trp = number_format($total['tax_rate_percent'],1,'.','');
                                    if(!isset($tax_stats[$trp] )){
                                        $tax_stats[$trp] = 0;
                                    }
                                    $tax_stats[$trp] -= $total['value'];
                                }
			}
			if($_GET['details'] != '1'){
				if($order->customer['ID'] != KASSE_DEFAULT_CUSTOMER ) { 
					$cstatus_query = xtc_db_query("select cs.customers_status_name FROM customers as c left join customers_status as cs on customers_status = customers_status_id where c.customers_id='".$order->customer['ID']."' and cs.language_id = '".$_SESSION['languages_id']."'");
					$cstatus = xtc_db_fetch_array($cstatus_query);
					$cInfo = xtc_address_format($order->customer['format_id'], $order->customer, 1, '', '<br />');
					$customer_status = $cstatus['customers_status_name'];
				} else {
					$cInfo = TEXT_COUNTER_SALE;
					$customer_status = '';
				}
				$set_paydate_link = '';
				if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_kasse_change_paydate'] == '1')) {
					$set_paydate_link = xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action','oID','from')).'action=change_paydate&oID='.$oID.'&from='.urlencode(xtc_href_link(basename(__FILE__),xtc_get_all_get_params())) );
				}
				if($kasse['branches_id'] > 0)
					$branch = xtc_get_branch_title($kasse['branches_id']);
				else
					$branch = 'Standard';
                                $cashier = '';
                                if(defined('MODULE_OTHER_FIBUNUMBERS_STATUS') and MODULE_OTHER_FIBUNUMBERS_STATUS == 'True'){
                                    $cashier = $order->get_cashier();
                                }
				$storno_items[] = array(
					'link_order'=>xtc_href_link('orders.php','action=edit&oID='.$oID.'&cID='.$order->customer['ID']),
					'oID'=>$oID,
					'orders_status_name'=>xtc_get_orders_status_name($order->info['orders_status']),
					'number'=>$number,
					'products'=>$order->products,
					'totals'=>$order->totals,
					'cinfo'=>$cInfo,
					'customer_status'=>$customer_status,
					'date'=>$date,
					'set_paydate_link'=>$set_paydate_link,
					'paymode'=>$paymode,
					'versand'=>$versand,
					'editor'=>$kasse['editor'],
					'branch'=>TEXT_BRANCH.': '.$branch,
                                    'cashier'=>$cashier
				);
			} // end details
		} // end foreach storno
	}
	$smarty->assign('storno_items',$storno_items);
	
	$gesamt_rueckerstattungen = 0.00;
	$kasse_gesamt_rueckerstattungen = array();
	$smarty->assign('items_rueckerstattungen_size',((isset($rueckerstattungen_data))?sizeOf($rueckerstattungen_data):0));
	$rueckerstattungen_items = array();
	if(isset($rueckerstattungen_data) and sizeOf($rueckerstattungen_data)){
		foreach ($rueckerstattungen_data as $k=>$kasse) {
			$rID = $kasse['rID'];
			$date = $kasse['date_storno'];
			$paymode = $kasse['paymode'];
			$versand = ($kasse['send'] > 0) ? 'ja':'nein';
			$rueckerstattung = new rueckerstattung($rID);
			$gesamt_rueckerstattungen -= $rueckerstattung->info['betrag'];
			$paymode_str = 'Bar';
			$kasse_gesamt_rueckerstattungen[ $kasse['branches_id'] ] -= $rueckerstattung->info['betrag'];
			$kasse_gesamt[ $kasse['branches_id'] ] -= $rueckerstattung->info['betrag'];
			
			if($_GET['details'] != '1'){
				if($rueckerstattung->info['customers_id'] != KASSE_DEFAULT_CUSTOMER ) { 
					$cstatus_query = xtc_db_query("select cs.customers_status_name FROM customers as c left join customers_status as cs on customers_status = customers_status_id where c.customers_id='".$rueckerstattung->info['customers_id']."' and cs.language_id = '".$_SESSION['languages_id']."'");
					$cstatus = xtc_db_fetch_array($cstatus_query);
					$order = new order($rueckerstattung->info['orders_id']);
					$cInfo = $order->customer['name'];
					$customer_status = $cstatus['customers_status_name'];
				} else {
					$cInfo = TEXT_COUNTER_SALE;
					$customer_status = '';
				}
				$set_paydate_link = '';
				if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_kasse_change_paydate'] == '1')) {
					$set_paydate_link = xtc_href_link('rueckerstattungen.php',xtc_get_all_get_params(array('action','rID','from')).'action=change_paydate&rID='.$rID.'&from='.urlencode(xtc_href_link(basename(__FILE__),xtc_get_all_get_params())) );
				}
				if($kasse['branches_id'] > 0)
					$branch = xtc_get_branch_title($kasse['branches_id']);
				else
					$branch = 'Standard';
                                $cashier = '';
				$rueckerstattungen_items[] = array(
					'link_order'=>xtc_href_link('rueckerstattungen.php','action=edit&rID='.$rID),
					'oID'=>$rID,
					'orders_status_name'=>  xtc_get_rueckerstattungen_status_name($rueckerstattung->info['status']),
					'number'=>$number,
					'products'=>'',
					'betrag'=> number_format($rueckerstattung->info['betrag'], 2, ',','.').' '.DEFAULT_CURRENCY,
					'cinfo'=>$cInfo,
					'customer_status'=>$customer_status,
					'date'=>$date,
					'set_paydate_link'=>$set_paydate_link,
					'paymode'=>$paymode,
					'versand'=>$versand,
					'editor'=>$kasse['editor'],
					'branch'=>TEXT_BRANCH.': '.$branch,
                                    'cashier'=>$cashier
				);
			} // end details
		} // end foreach storno
	}
	$smarty->assign('rueckerstattungen_items',$rueckerstattungen_items);
	
	
	
	// DIFFPAY
	if(isset($diffpay))
		$x = array_keys($diffpay);
	else
		$x = array();
	$bank = 0;
	$payment_types_array = array();
	for($dp=0;$dp<sizeOf($x);$dp++){
		$values = '';
		if(sizeOf($kasse_diffpay)>0){
			foreach( $kasse_diffpay as $branches_id => $payment_array ){
				if($branches_id > 0)
					$branch = xtc_get_branch_title($branches_id);
				else
					$branch = TEXT_MAINSTORAGE;
			}
			$values .= '<i>'.$branch.'</i>: '.number_format($payment_array[ $x[$dp] ],2,'.','').' '.DEFAULT_CURRENCY.'<br />';
		}
		$payment_types_array[] = array(
			'title'=>sprintf(TEXT_SALES_PER_POSITION,$x[$dp],number_format($diffpay[ $x[$dp] ],2,',',''),DEFAULT_CURRENCY),
			'values'=>$values
		);
	}
	$smarty->assign('PAYMENT_TYPES',$payment_types_array);
	$smarty->assign('GESAMT_STORNO', number_format($gesamt_storno,2,',','.'));
	$values = '';
	if(sizeOf($kasse_gesamt_storno)>0){ 
		foreach($kasse_gesamt_storno as $branches_id => $total){
			if($branches_id > 0)
				$branch = xtc_get_branch_title($branches_id);
			else
				$branch = TEXT_MAINSTORAGE;
			$values .= '<i style="font-size: inherit;">'.TEXT_BRANCHCOUNTER.': '.$branch.':</i> '. number_format($total,2,',','').' '.DEFAULT_CURRENCY.'<br />';
			foreach( $kasse_diffpay_storno[$branches_id] as $payment_str => $payment_value ){
			    $values .= '<span style="font-style: italic; color: #666;font-size: inherit;">'.$payment_str.': -'.number_format($payment_value,2,',','.').' '.DEFAULT_CURRENCY.'</span><br />';
			}
			
		}
	}
	$smarty->assign('STORNO_BRANCHES',$values);
	
	$smarty->assign('GESAMT_RUECKERSTATTUNGEN', number_format($gesamt_rueckerstattungen,2,',','.'));
	$values = '';
	if(sizeOf($kasse_gesamt_rueckerstattungen)>0){ 
		foreach($kasse_gesamt_rueckerstattungen as $branches_id => $total){
			if($branches_id > 0)
				$branch = xtc_get_branch_title($branches_id);
			else
				$branch = TEXT_MAINSTORAGE;
			$values .= '<i style="font-size: inherit;">'.TEXT_BRANCHCOUNTER.': '.$branch.':</i> '. number_format($total,2,',','').' '.DEFAULT_CURRENCY.'<br />';
		}
	}
	$smarty->assign('RUECKERSTATTUNGEN_BRANCHES',$values);
	
        $smarty->assign('TAX_STATS',$tax_stats);
	$gesamt = (isset($gesamt)) ? $gesamt : 0;
	$smarty->assign('SUM_TOTAL', number_format($gesamt + $gesamt_storno + $gesamt_rueckerstattungen,2,',','').' '.DEFAULT_CURRENCY);
	
	$smarty->assign('GESAMT_TOTAL', number_format($gesamt+$gesamt_rueckerstattungen,2,',','').' '.DEFAULT_CURRENCY);
	$smarty->assign('DISCOUNT_TOTAL', number_format($discount,2,',','').' '.DEFAULT_CURRENCY);
	$values = '';
	if(isset($kasse_gesamt) and sizeOf($kasse_gesamt)>0){ 
		foreach($kasse_gesamt as $branches_id => $total){
			if($branches_id > 0)
				$branch = xtc_get_branch_title($branches_id);
			else
				$branch = TEXT_MAINSTORAGE;
			$values .= '<i>'.TEXT_BRANCHCOUNTER.': '.$branch.':</i> '. number_format($total,2,',','').' '.DEFAULT_CURRENCY	.'</b><br />';
		}
		$smarty->assign('BRANCHCOUNTER_VALUES',$values);
	}
}else if($action == 'set_paydate'){
	$date_query = xtc_db_query("SELECT date_purchased FROM kasse WHERE orders_id='".xtc_db_input($_GET['oID'])."'");
	$date_res = xtc_db_fetch_array($date_query);
	$smarty->assign(array(
		'TEXT_CHANGE_PAYDATE_INTRO'=>sprintf(TEXT_CHANGE_PAYDATE_INTRO,$_GET['oID']),
		'TEXT_NEW_PAYDATE'=>TEXT_NEW_PAYDATE,
		'FORM'=>xtc_draw_form('paydate','stats_kasse.php',xtc_get_all_get_params(array('action')).'action=save_paydate'),
		'TEXT_NEW_PAYDATE'=>TEXT_NEW_PAYDATE,
		'date_purchased'=>yes_strftime('%Y-%m-%d',strtotime($date_res['date_purchased'])),
		'FORM_END'=>'</form>'
	));
} else if($action == 'set_branch'){
	$orig_branch_query = xtc_db_query("SELECT branches_id FROM kasse WHERE orders_id='".xtc_db_input($_GET['oID'])."'");
	$orig_branch = xtc_db_fetch_array($orig_branch_query);
	$branches_array = array();
	$branches_query = xtc_db_query("SELECT * FROM branches");
	if(xtc_db_num_rows($branches_query)){
		$branches_array[] = array('id'=>'0','text'=>TEXT_MAINSTORAGE);
	}
	while($branches = xtc_db_fetch_array($branches_query)){
		$branches_array[] = array('id'=>$branches['branches_id'],'text'=>$branches['title']);
	}
	$smarty->assign(array(
		'TEXT_CHANGE_BRANCHCOUNTER_INTRO'=>sprintf(TEXT_CHANGE_BRANCHCOUNTER_INTRO,$_GET['oID']),
		'FORM'=>xtc_draw_form('branch','stats_kasse.php',xtc_get_all_get_params(array('action')).'action=save_branch'),
		'TEXT_SALE_FROM_BRANCH'=>TEXT_SALE_FROM_BRANCH,
		'INPUT_BRANCHED_ID'=>xtc_draw_pull_down_menu('branches_id',$branches_array,$orig_branch['branches_id'])
	));
}
if(isset($_REQUEST['view']) and $_REQUEST['view'] == 'csv'){
	require(DIR_WS_CLASSES.'class.csv.php');
	$filename = sprintf('kassenstatistik-%s_-_%s.csv',
		str_replace('.','_',$startDate),str_replace('.','_',$endDate)
	);
	$fh = fopen(\main::get_exportdata_path().$filename,'a+') or die("Kann ".$filename." nicht anlegen.");
	fclose($fh);
	$CSV = new CSVfile(\main::get_exportdata_path().$filename);
	$CSV->delimiter = "\t";
	$CSV->open('w');
	$headings = array(
		TABLE_HEADING_ORDER,
		TABLE_HEADING_PRODUCTS,
		TEXT_PRODUCTS_ID,
		TABLE_HEADING_TOTAL,
		TABLE_HEADING_ORDER_TOTAL
	);
	foreach($different_tax_titles as $title => $true){
	    $headings[] = $title;
	}
	$headings[] = TABLE_HEADING_CUSTOMER;
	$headings[] = TABLE_HEADING_DATE;
	$headings[] = TABLE_HEADING_PAYMENTMETHOD;
	$headings[] = TABLE_HEADING_SHIPPING;
	$headings[] = TABLE_HEADING_EDITOR;
	$CSV->addRow($headings);
        $text_rows = [$headings]; // zb fuer pdf export
	for($i=0;$i<sizeOf($items);$i++){
		$products = array();
		$products_id_array = array();
		for($ip=0;$ip<sizeOf($items[$i]['products']);$ip++){
			$products[] = sprintf('%s x %s %s',
				$items[$i]['products'][$ip]['qty'],
				$items[$i]['products'][$ip]['name'],
				number_format($items[$i]['products'][$ip]['price'],2,',','.')
			);
			$products_id_array[] = $items[$i]['products'][$ip]['id'];
		}
		$totals = array();
		$total = 0;
		for($it=0;$it<sizeOf($items[$i]['totals']);$it++){
			$totals[] = sprintf('%s: %s',
				strip_tags($items[$i]['totals'][$it]['title']),
				strip_tags($items[$i]['totals'][$it]['text'])
			);
			if($items[$i]['totals'][$it]['class'] == 'ot_total'){
			    $total = $items[$i]['totals'][$it]['value'];
			}
		}
		$data = array(
			$items[$i]['oID'],
			implode(';',$products),
			implode(';',$products_id_array),
			implode(';',$totals),
			number_format($total,2,'.','')
		);
		foreach($different_tax_titles as $title => $true){
			$found = false;
			$found_text = '';
			for($it=0;$it<sizeOf($items[$i]['totals']);$it++){
			    switch($items[$i]['totals'][$it]['class']){
				case 'ot_tax':
				    if($items[$i]['totals'][$it]['title'] == $title){
					$found = true;
					$found_text = $items[$i]['totals'][$it]['text'];
				    }
				    break;
			    }
			}
			if($found){
			    $data[] = $found_text;
			}else{
			    $data[] = 0;
			}
		}
		$data[] = $items[$i]['cinfo'];
		$data[] = $items[$i]['date'];
		$data[] = $items[$i]['paymode'];
		$data[] = $items[$i]['versand'];
		$data[] = $items[$i]['editor'];
		$CSV->addRow($data);
                $text_rows[] = $data;
	}
	$CSV->close();
	$content = file_get_contents(\main::get_exportdata_path().$filename);
	unlink(\main::get_exportdata_path().$filename);
        
        /* BOF FUER TICKET 3041 ... ABER DA WIRD ES KEIN GUTES HTML FUER GEBEN
        if(isset($_GET['nodownload']) and $_GET['nodownload'] == 1){
            if(!sizeOf($items)){
                exit;
            }
            if(isset($_GET['as_pdf']) and $_GET['as_pdf'] == 1){
                if(!defined('USE_DOMPDF') or USE_DOMPDF != 'True'){
                    throw Exception('DOMPDF is not enabled');
                }
                $style = "
            @page {
                margin: 100px 25px;
            }
            .column_header, .column{
                display: inline-block;
                border: 1px solid black;
            }
            .row{
                border: 1px solid black;
            }
            clearfix:after {
                content: ".";
                clear: both;
                display: block;
                visibility: hidden;
                height: 0px;
            }
            header {
                position: fixed;
                top: -60px;
                left: 0px;
                right: 0px;
                height: 30px;
                text-align: center;
            }

            footer {
                position: fixed; 
                bottom: -30px; 
                left: 0px; 
                right: 0px;
                height: 20px; 
                text-align: center;
            }
            ";
                $str = sprintf(
                        "<html><head><style>%s</style></head><body><header>%s %s</header><main>",
                        $style,HEADING_TITLE, $_GET['startDate'].' - '.$_GET['endDate']
                );
                foreach($text_rows as $nr=>$row){
                    echo '<div class="row">';
                    if($nr == 0){
                        $str .= sprintf("<div class=\"column_header\">%s</div>",
                                implode('</div><div class="column_header">',$row)
                        );
                        $str .= '<div class="clearfix"></div>';
                        continue;
                    }
                    $row[3] = str_replace(';','<br />',$row[3]);
                    $str .= sprintf("<div class=\"column\">%s</div>",
                            implode('</div><div class="column">',$row)
                    );
                    $str .= '<div class="clearfix"></div>';
                    echo '</div>';
                }
                $str .= '<footer>Test</footer></main></body></html>';
                die($str);
                $headerandfooter=(strstr(HTTP_SERVER,'localhost')) ? true : false;
$headerandfooter=true;
                $pdf = new yes_pdf($headerandfooter);
                $pdf->set_landscape();
                $pdf->set_html($str);
                $pdf->save(\main::get_exportdata_path().'stats_kasse.pdf');
                exit;
            }
            die($content); // CSV TEXT AUSGABE
            exit;
        } EOF FUER TICKET 3041 */
        // CVS FILE DOWNLOAD
	$len = strlen($content);
	header("Content-type: text/csv");
	header("Content-Disposition: attachment; filename=".$filename);
	header("Content-Length: ".$len);
	echo $content;
	exit;
}
yes_draw_pre_header();
if(!isset($_GET['view']) or $_GET['view'] != 'raw') {
    yes_draw_header(TITLE);
    $buttons = array(
        array('text'=>BUTTON_TAGESABSCHLUSS,
            'link'=>xtc_href_link(basename(__FILE__),'action=tagesabschluss'),
            'lbOn'=>true,
            'auth'=>true
        ),
    );
    $smarty->assign(array(
	'HEADING_TITLE'=>HEADING_TITLE,
	'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
	'TEXT_CHANGE_PAYDATE_INTRO'=>TEXT_CHANGE_PAYDATE_INTRO,
	'TEXT_STATS_STATUS_FILTER'=>TEXT_STATS_STATUS_FILTER
    ));
}
$smarty->assign('JQUERY_SOURCE',  yes_get_cdn_link('jquery', '1.4.2'));
$smarty->display('stats_kasse.html');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
