<?php
use YES4Trade\Model;
include('includes/application_top.php');
require_once(DIR_WS_CLASSES.'order.php');

$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');

$U = new \YES4Trade\Model\umsatzstatistik();
if(isset($_GET['startDate'])){
    $stats = $U->get_stats();
    if($U->getDefault_values('srExp') == 2){
        $UC = new \YES4Trade\Model\umsatzstatistik_csv( $stats );
        $cs = ($U->getDefault_values('csID') != '') ? '_'.xtc_get_customers_status_name($U->getDefault_values('csID')) : '';
        $os = ($U->getDefault_values('srStatus') > 0) ? '_Status'.xtc_get_orders_status_name($U->getDefault_values('srStatus')) : '';
        $CSV_STRING = $UC->get_csv();
	$len = strlen($CSV_STRING);
        $filename = sprintf('sales_report_%s_%s%s%s.csv',
                $U->getSrViewName(),
                str_replace('.','',$U->getDefault_values('endDateValue').'-'.$U->getDefault_values('startDateValue')),
                $cs,$os
        );
	header("Content-type: text/csv");
	header("Content-Disposition: attachment; filename=".$filename);
	header("Content-Length: ".$len);
	echo $CSV_STRING;
	exit;
    }
    $smarty->assign([
        'STATS'=>$stats,
        'STATS_JSON'=>json_encode($stats),
        'ACTION'=>'view',
        'STATS_SOURCES'=>$U->get_sources_total_from_stats($stats),
        'STATS_SOURCES_JSON'=>json_encode($U->get_sources_total_from_stats($stats)),
        'STATS_PAYMENT'=>$U->get_payments_from_stats( $stats ),
        'TOTALS'=>$U->get_stats_total($stats),
        'SOURCES_NAMES'=>$U->getSources_names(),
        'GROUPS'=> xtc_get_customers_statuses(),
        'STATS_GROUPS'=>$U->get_customers_groups_total_from_stats($stats),
    ]);
}else{
    $smarty->assign([
        'STATS_JSON'=>json_encode([]),
        'STATS_SOURCES_JSON'=>json_encode([])
    ]);
}


$smarty->assign('FORM_END','</form>');
$customers_statuses = xtc_get_customers_statuses();
$customers_statuses = array_merge(array(array('id'=>'','text'=>TEXT_SELECT)),$customers_statuses);
$fibu = ((int)$U->getDefault_values('fibu') === 1 or !isset($_GET['report']));
$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE,
    'TABLE_HEADING_DATE'=>TABLE_HEADING_DATE,
    'TABLE_HEADING_ORDERS'=>TABLE_HEADING_ORDERS,
    'TABLE_HEADING_ITEMS'=>TABLE_HEADING_ITEMS,
    'TABLE_HEADING_REVENUE'=>TABLE_HEADING_REVENUE,
    'TABLE_HEADING_SHIPPING'=>TABLE_HEADING_SHIPPING,
    'TABLE_HEADING_RUECKERSTATTUNGEN'=>TABLE_HEADING_RUECKERSTATTUNGEN,
    'REPORT_START_DATE'=>REPORT_START_DATE,
    'REPORT_STATUS_FILTER'=>REPORT_STATUS_FILTER,
    'REPORT_EXP'=>REPORT_EXP,
    'REPORT_END_DATE'=>REPORT_END_DATE,
    'STATS_WEBSHOP'=>STATS_WEBSHOP,
    'STATS_EBAY'=>STATS_EBAY,
    'STATS_COUNTER'=>STATS_COUNTER,
    'STATS_SERVICE'=>STATS_SERVICE,
    'STATS_AMAZON'=>STATS_AMAZON,
    'STATS_HITMEISTER'=>STATS_HITMEISTER,
    'TEXT_STATS_INTRO'=>TEXT_STATS_INTRO,
    'TEXT_FORM_FILTER'=>TEXT_FORM_FILTER,
    'INPUT_CUSTOMERS_STATUS'=>xtc_draw_pull_down_menu('customers_status_id',$customers_statuses,$U->getDefault_values('csID')),
    'TEXT_ZEITRAUM'=>TEXT_ZEITRAUM,
    'TEXT_BRUTTO'=>TEXT_BRUTTO,
    'TEXT_NETTO'=>TEXT_NETTO,
    'TEXT_STEUERN'=>TEXT_STEUERN,
    'TEXT_DETAILS_UMSATZ_QUELLE'=>TEXT_DETAILS_UMSATZ_QUELLE,
    'TEXT_UMSATZ_NACH_BEZAHLART'=>TEXT_UMSATZ_NACH_BEZAHLART,
    'TEXT_BEZAHLART'=>TEXT_BEZAHLART,
    'TEXT_WERT'=>TEXT_WERT,
    'TEXT_QUELLE'=>TEXT_QUELLE,
    'TEXT_NETTO_UMSATZ'=>TEXT_NETTO_UMSATZ,
    'TEXT_UMSATZ_NACH_QUELLEN'=>TEXT_UMSATZ_NACH_QUELLEN,
    'TEXT_GESAMT'=>TEXT_GESAMT,
    'TEXT_UMSATZ_NACH_KUNDENGRUPPE'=>TEXT_UMSATZ_NACH_KUNDENGRUPPE,
    'TEXT_FIBU_FILTER'=>TEXT_FIBU_FILTER,
    'INPUT_FIBU'=> xtc_draw_checkbox_field('fibu',1,$fibu),
    'FIBU_ACTIVE'=>(defined('MODULE_OTHER_FIBUNUMBERS_STATUS') && MODULE_OTHER_FIBUNUMBERS_STATUS == 'True')?1:0,
));
yes_draw_pre_header();
yes_draw_header(TITLE);

$smarty->assign('FORMATTED_ENDDATE',$U->getDefault_values('endDateValue'));
$smarty->assign('FORMATTED_STARTDATE',$U->getDefault_values('startDateValue'));

$smarty->assign('action','view_form');
$smarty->assign('input_report_types',array(
        array(
                'input'=>xtc_draw_radio_field('report',1,(($U->getDefault_values('srView') == 1)?true:false)),
                'text'=>REPORT_TYPE_YEARLY
        ),
        array(
                'input'=>xtc_draw_radio_field('report',2,(($U->getDefault_values('srView') == 2)?true:false)),
                'text'=>REPORT_TYPE_MONTHLY
        ),
        array(
                'input'=>xtc_draw_radio_field('report',3,(($U->getDefault_values('srView') == 3)?true:false)),
                'text'=>REPORT_TYPE_WEEKLY
        ),
        array(
                'input'=>xtc_draw_radio_field('report',4,(($U->getDefault_values('srView') == 4)?true:false)),
                'text'=>REPORT_TYPE_DAILY
        )
));

$status_array = array(
        array('id'=>0,'text'=>REPORT_ALL)
);
$orders_statuses = xtc_get_orders_status();
foreach ($orders_statuses as $os) {
        $status_array[] = array(
                'id'=>$os["id"],'text'=>$os["text"]
        );
}
$smarty->assign('INPUT_REPORT_STATUS',xtc_draw_pull_down_menu('status',$status_array,$U->getDefault_values('srStatus')));

$export_array = array(
        array('id'=>0,'text'=>EXP_NORMAL),
        array('id'=>2,'text'=>EXP_CSV)
);
$smarty->assign('INPUT_EXPORT',xtc_draw_pull_down_menu('export',$export_array,'','id="export"'));

$smarty->display('stats_sales_report.html');
