<?php
require_once(DIR_WS_CLASSES.'product.php');
$id = (isset($_REQUEST['id']) and $_REQUEST['id'] > 0) ? (int)xtc_db_input($_REQUEST['id']) : 0;
$storages_data = array();
$storages_query = xtc_db_query("SELECT id,name FROM storages ORDER BY name");
while($record = xtc_db_prepare_input(xtc_db_fetch_array($storages_query))){
    $storages_data[] = array('id'=>$record['id'],'text'=>$record['name']);
}
$storage = new storage($id);
if(isset($_REQUEST['storage_place_action'])){
    switch($_REQUEST['storage_place_action']){
        case 'add_product_to_storage_place':
            $msg = '';
            $pID = (int)xtc_db_input($_GET['pID']);
            $stpID = (int)xtc_db_input($_GET['stpID']);
            $query = xtc_db_query(sprintf(
                    "SELECT id FROM storage_products WHERE storage_places_id='%d' AND products_id='%d'",
                    $stpID,$pID
            ));
            if(xtc_db_num_rows($query)){
                $msg = sprintf(ADD_PRODUCT_TO_STORAGE_PLACE_ERROR_EXISTS,
                        $pID
                );
                die(json_encode(array(
                    'MSG'=>$msg,
                    'CREATE_STORAGENUMBER'=>0
                )));
            }
            $query = xtc_db_query(sprintf(
                    "SELECT storage_id FROM storage_places WHERE storage_places_id='%d'",
                    $stpID
            ));
            if(!xtc_db_num_rows($query)){
                die(json_encode(array(
                    'MSG'=>'Unknown storage place ID',
                    'CREATE_STORAGENUMBER'=>0
                )));
            }
            $record = xtc_db_fetch_array($query);
            $storage = new storage($record['storage_id']);
            if($storage->getStorage_number_by_products_id($pID) < 0){
                
                die(json_encode(array(
                    'MSG'=>sprintf(ADD_PRODUCT_TO_STORAGE_PLACE_ERROR_NO_STORAGE_NUMBER,
                            $pID, $storage->getName()
                    ),
                    'CREATE_STORAGENUMBER'=>1,
                    'STORAGE_ID'=>$storage->getId()
                )));
            }
            $insert_sql_array = array(
                'products_id'=>$pID,
                'created'=>'now()',
                'storage_places_id'=>$stpID,
                'storage_id'=>$storage->getId()
            );
            xtc_db_perform('storage_products',$insert_sql_array);
            die(json_encode(array(
                'MSG'=>'',
            )));
            break;
	case 'delete':
	    $msg = '';
	    $stpID = (int)xtc_db_input($_REQUEST['stpID']);
	    xtc_db_query(sprintf(
		    "DELETE FROM storage_places WHERE storage_places_id='%s'",
		    $stpID
	    ));
		$query = xtc_db_query(sprintf(
			"SELECT * FROM storage_products WHERE storage_places_id='%s'",
			$stpID
		));
		while($record = xtc_db_fetch_array($query)){
			$product = new product($record['products_id']);
			$product->add_history(sprintf(
				TEXT_HISTORY_STORAGE_ALLOCATION_DELETED,
				xtc_get_storage_name($record['storage_id']),
				yes_get_storage_place_title($stpID),
				$record['quantity']
			));
		}

	    xtc_db_query(sprintf(
		    "DELETE FROM storage_products WHERE storage_places_id='%s'",
		    $stpID
	    ));
	    die(json_encode(array(
		'MSG'=>$msg
	    )));
	    exit;
	    break;
	case 'get_storage_place_allocations':
	    $stpID = (int)xtc_db_input($_REQUEST['stpID']);
	    $query = xtc_db_query(sprintf(
		    "SELECT sp.*,pd.products_name FROM storage_products sp LEFT JOIN products_description pd USING(products_id) WHERE storage_places_id='%s' AND pd.language_id='%s'",
		    $stpID,$_SESSION['languages_id']
	    ));
	    $products = array();
	    while($record = xtc_db_prepare_input(xtc_db_fetch_array($query))){
		$products[] = $record;
	    }
	    $smarty->assign(array(
		'PRODUCTS'=>$products
	    ));
	    header('Content-Type: text/html; charset='.CHARSET);
	    $smarty->display('storage_places_allocation_products.tpl');
	    exit;
	    break;
	case 'insert_storage_place':
	    $msg = '';
	    $stpID = (isset($_REQUEST['stpID'])) ? (int)xtc_db_input($_REQUEST['stpID']) : 0;
	    if(!isset($_REQUEST['title']) or empty($_REQUEST['title'])){
		$msg = MSG_ERROR_STORAGE_PLACE_TITLE_MISSING;
	    }else{
		$check_query = xtc_db_query(sprintf(
			"SELECT storage_places_id FROM storage_places WHERE storage_id='%s' AND title='%s' AND storage_places_id != '%s'",
			$id,yes_decode_string(xtc_db_input($_REQUEST['title'])),$stpID
		));
		if(xtc_db_num_rows($check_query)){
		    $msg = MSG_ERROR_STORAGE_PLACE_TITLE_EXISTS;
		}else{
		    if($stpID > 0){
			$update_sql_array = array(
			    'title'=>yes_decode_string($_REQUEST['title']),
			    'description'=>yes_decode_string($_REQUEST['description']),
			    'storage_id'=>$id
			);
			xtc_db_perform('storage_places',$update_sql_array,'update',"storage_places_id='".$stpID."'");
		    }else{
			$insert_sql_array = array(
			    'title'=>yes_decode_string($_REQUEST['title']),
			    'description'=>yes_decode_string($_REQUEST['description']),
			    'storage_id'=>$id
			);
			xtc_db_perform('storage_places',$insert_sql_array);
			$stpID = xtc_db_insert_id();
		    }
		}
	    }
	    die(json_encode(array(
		'MSG'=>$msg,
		'STPID'=>$stpID
	    )));
	    break;
	case 'get_storage_place_details':
	    $stpID = (int)xtc_db_input($_REQUEST['stpID']);
	    $query = xtc_db_query(sprintf(
		    "SELECT * FROM storage_places WHERE storage_places_id='%s'",
		    $stpID
	    ));
	    $data = xtc_db_prepare_input(xtc_db_fetch_array($query));
	    foreach($data as $k=>$v){
		$data[$k] = yes_encode_string($v);
	    }
	    header('Content-Type: text/html; charset=utf-8');
	    die(json_encode(array(
		'DATA'=>$data
	    )));
	    break;
    }
}


$storage_places = array();
$query = xtc_db_query(sprintf(
	"SELECT * FROM storage_places WHERE storage_id='%s' ORDER BY title",
	$id
));	
while($record = xtc_db_prepare_input(xtc_db_fetch_array($query))){
    $storage_places[] = $record;
}
foreach($storage_places as $k=>$place){
    $query = xtc_db_query(sprintf(
	    "SELECT COUNT(products_id) as summary FROM storage_products WHERE storage_places_id='%s'",
	    $place['storage_places_id']
    ));
    $record = xtc_db_fetch_array($query);
    $storage_places[ $k ]['summary'] = sprintf(TEXT_STORAGE_PLACES_PLACE_SUMMARY,$record['summary']);
    $storage_places[ $k ]['summary_num'] = $record['summary'];
    $storage_places[ $k ]['summary_details'] = 'a<br />a<br />a<br />a<br />a<br />a<br />a<br />';
    
}

$buttons = array(
    array('text'=>IMAGE_BACK,
	'link'=>xtc_href_link('storage.php'),
	'lbOn'=>false,
	'auth'=>true
    ),
);
if(isset($_GET['id']) and $_GET['id']>0){
    $buttons[] = array('text'=>EXPORT_STORAGE_PRODUCTS_CSV,
	'link'=>xtc_href_link('storage.php?action=module_export_products_storages&stID='.$_GET['id']),
	'lbOn'=>true,
	'auth'=>true
    );
}

$smarty->assign(array(
    'JS_BASELINK'=>xtc_href_link('storage.php','action=storage_places&id='.$id),
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'HEADING_TITLE'=>TEXT_STORAGE_PLACES_HEADING_TITLE,
    'STORAGE_SELECT_FORM'=>xtc_draw_form('storage_select','storage.php','','GET').xtc_draw_hidden_field('action','storage_places'),
    'INPUT_STORAGE_SELECT'=>xtc_draw_pull_down_menu('id',$storages_data,$id),
    'INPUT_STORAGE_SELECT_SUBMIT'=>yes_draw_href_button(IMAGE_SELECT, '', '', 'submit'),
    'BESCHREIBUNG'=>$storage->getBeschreibung(),
    'DEFAULT_STORAGE'=>$storage->getDefault_storage(),
    'NAME'=>$storage->getName(),
    'PLACES'=>$storage_places,
    'ID'=>$id,
    'TEXT_STORAGE_PLACES_UPDATE_TITLE'=>TEXT_STORAGE_PLACES_UPDATE_TITLE,
    'SEARCH'=>IMAGE_SEARCH,
    'ADD'=>TEXT_ADD_NEW_STORAGE_PLACE,
    'IMAGE_SAVE'=>IMAGE_SAVE,
    'INPUT_NEW_STORAGE_PLACE_TITLE'=>INPUT_NEW_STORAGE_PLACE_TITLE,
    'INPUT_NEW_STORAGE_PLACE_DESCRIPTION'=>INPUT_NEW_STORAGE_PLACE_DESCRIPTION,
    'ADD_STORAGE_PLACE_FORM'=>xtc_draw_form('addstorageform','storage.php','action=storage_places&id='.$id.'&storage_place_action=insert_storage_place'),
    'DEFAULT_SUMMARY'=>sprintf(TEXT_STORAGE_PLACES_PLACE_SUMMARY,0),
    'TEXT_STORAGE_PLACES_PLACE_SUMMARY'=>TEXT_STORAGE_PLACES_PLACE_SUMMARY,
    'TEXT_STORAGE_PLACE_PRODUCTS'=>TEXT_STORAGE_PLACE_PRODUCTS,
    'TEXT_REALLY_DELETE_STORAGE_PLACE_ALLOCATION'=>TEXT_REALLY_DELETE_STORAGE_PLACE_ALLOCATION,
    'TEXT_FILTER_ONLY_EMPTY_STORAGE_PLACES'=>TEXT_FILTER_ONLY_EMPTY_STORAGE_PLACES,
    'INPUT_ONLY_EMPTY'=>  xtc_draw_checkbox_field('only_empty',1,(isset($_REQUEST['only_empty']) and $_REQUEST['only_empty'] == 1)?true:false )
));
yes_draw_pre_header();
yes_draw_header(TITLE);
$smarty->display('storage_places_allocation.html');
include('includes/application_bottom.php');
include('includes/footer.php');
exit;
