<?php
define('CRON_AMAZON_FEEDS_DEBUG','1');
require (DIR_FS_INC . 'yes_write_notice.inc.php');
require (DIR_FS_INC . 'xtc_encrypt_password.inc.php');
require (DIR_FS_INC . 'xtc_get_customer_status_value.inc.php');
require (DIR_FS_INC . 'xtc_get_serial_number.inc.php');
require (DIR_FS_CATALOG . 'lang/'.$_SESSION['language'].'/modules/order_total/ot_subtotal.php');
require (DIR_FS_CATALOG . 'lang/'.$_SESSION['language'].'/modules/order_total/ot_total.php');
require_once('includes/classes/amz_Helper.php');
require_once('includes/classes/amz_ReportList.php');
require_once('includes/classes/amz_Service.php');
require_once('includes/classes/amz_Feedhandler.php');
require_once('includes/classes/amz_SubmitFeed.php');
require_once('includes/classes/amz_Sync.php');
require_once('includes/classes/product.php');
require_once('includes/classes/class.basics.php');
require_once('includes/classes/order.php');
include_once('includes/classes/reclamation.php');
include_once('includes/classes/yes_shipping.php');
include_once(DIR_FS_CATALOG.'includes/classes/xtcPrice.php');
include_once(DIR_FS_CATALOG.DIR_WS_CLASSES.'class.phpmailer.php');
require_once('includes/config.amazonmws.inc.php');
$exportdata_path = \main::get_exportdata_path();
define('AMAZON_SAVE_PATH',$exportdata_path.'amazon/');
define('AMAZON_REPORTLIST_MAX_COUNT',80);
define('AMAZON_ADDRESS_FORMAT_ID',5);
define('MARKETPLACE_ID',MODULE_OTHER_AMAZON_MARKETPLACE_ID);
define('MERCHANT_ID',MODULE_OTHER_AMAZON_MERCHANT_ID);
$A = new amazon_helper();
$basics = new basics;
function amazon_get_request_error_msg($ex){
	return sprintf("Caught Exception: %s<br />Response Status Code: %s<br />Error Code: %s<br />Error Type: %s<br />Request ID: %s<br /><pre>%s</pre>",
			$ex->getMessage(),
			$ex->getStatusCode(),
			$ex->getErrorCode(),
			$ex->getErrorType(),
			$ex->getRequestId(),
			htmlentities($ex->getXML())
	);
}

$action = '';
$toggle_user_file = \main::get_exportdata_path().basename(__FILE__).'.CURRENT_USER';
if(!is_file($toggle_user_file)){
	$basics->create_file($toggle_user_file,'0');
}
$merchants_array = $A->get_auth_user_array();
if(!isset($_REQUEST['merchant_id'])){
	$merchant_id = current($merchants_array);
}else{
	$merchant_id = $_REQUEST['merchant_id'];
}
$merchants_array_input = array();
foreach($merchants_array as $m){
	$merchants_array_input[] = array('id'=>$m,'text'=>$m);
}
$smarty = new yesSmarty;
$auth_params = $A->get_auth_data_array($merchant_id);
$parameters = array (
    'Marketplace' => $auth_params['marketplace_id'],
    'Merchant' => $auth_params['merchant_id'],
);
if(!empty($auth_params['mwsauthtoken'])){
	$parameters['MWSAuthToken'] = $auth_params['mwsauthtoken'];
}
$AS = new amazon_service();
$service = $AS->get_service();

function dbg_getfeedsubmissionlist($service, $mercID){
	global $A;
	$auth_params = $A->get_auth_data_array($mercID);
	$parameters = array (
	    'Marketplace' => $auth_params['marketplace_id'],
	    'Merchant' => $auth_params['merchant_id'],
		'MaxCount'=>25
	);
	if(!empty($auth_params['mwsauthtoken'])){
		$parameters['MWSAuthToken'] = $auth_params['mwsauthtoken'];
	}
	$request = new MarketplaceWebService_Model_GetFeedSubmissionListRequest($parameters);
	$response = $service->getFeedSubmissionList($request);
//	$list = $response->getGetFeedSubmissionListResult();
	$GetFeedSubmissionListResult = $response->GetFeedSubmissionListResult;
        yes_debug($GetFeedSubmissionListResult);
	$return = array();
	foreach($GetFeedSubmissionListResult->getFeedSubmissionInfoList() as $fsi){
		$return[] = array(
			'ID'=>$fsi->getFeedSubmissionId(),
			'TYPE'=>$fsi->getFeedType(),
			'STATUS'=>$fsi->getFeedProcessingStatus(),
			'DATE_SUBMITTED'=>$fsi->getSubmittedDate()->format('d.m.y H:i:s'),
			'DATE_COMPLETED'=>(($fsi->getCompletedProcessingDate() > 0)?$fsi->getCompletedProcessingDate()->format('d.m.y H:i:s'):'')
		);
	}
	return $return;
}
if(isset($_REQUEST['id'])){
			$feed_id = $_REQUEST['id'];
			$parameters['FeedSubmissionId'] = $feed_id;
			$request = new MarketplaceWebService_Model_GetFeedSubmissionResultRequest($parameters);
			$request->setFeedSubmissionResult(@fopen('php://memory', 'rw+'));
			$response = $service->getFeedSubmissionResult($request);
			$handle = $request->getFeedSubmissionResult();
			$xml = stream_get_contents($handle);
			$smarty->assign(array(
				'FEED_CONTENT'=>htmlspecialchars("$xml"),
				'ID'=>$feed_id
			));
}
$feeds = dbg_getfeedsubmissionlist($service,$merchant_id);
$smarty->assign(array(
	'INPUT_MERCHANT_ID'=>xtc_draw_pull_down_menu('merchant_id',$merchants_array_input,$merchant_id),
	'CURRENT_MERCHANT_ID'=>$merchant_id,
	'FEEDS'=>$feeds
));
$smarty->display(DIR_FS_CATALOG.'admin/templates/system.amazon_feed_status.tpl');

exit;


// BOF - 111
function dbg_get_submitfeed_from_itemcode($item_code,$trackingnumber = ''){
	global $A;
	$SF = new SubmitFeed();
	$query = yes_db_query(sprintf(
		"SELECT ao.orders_id,ao.orig_amazon_orders_id,ao.merchant_id,aop.* FROM amazon_orders ao LEFT JOIN amazon_orders_products aop USING(amazon_orders_id) WHERE aop.yes_shipping_status=1 AND aop.order_fulfillment_send=0 and amazon_order_item_code='%s' ORDER BY ao.merchant_id",
		xtc_db_input($item_code)
	));
	if(!yes_db_num_rows($query)){
		die($item_code.' not exists in db');
	}
	$record = current($query);
	$order = new order($record['orders_id']);
	$fulfillment = array();
	$fulfillment['merchant_orders_id'] = $order->info['id'];
	$fulfillment['amazon_orders_id'] = $record['orig_amazon_orders_id'];
	$fulfillment['shipping_method_service_level'] = $A->get_amazon_shipping_method_name($record['shipping_method']);
	if($record['carrier_code'] != 'Other' and $record['carrier_code'] != ''){
		$fulfillment['carrier_code'] = $record['carrier_code'];
	}else{
		$fulfillment['carrier_name'] = $record['carrier_name'];
	}
	if($trackingnumber != '')
		$fulfillment['shipper_tracking_number'] = $_REQUEST['shipper_tracking_number'][$item_code];
	$fulfillment['items'][] = array(
		'amazon_order_item_code'=>$record['amazon_order_item_code'],
		'merchant_id'=>$record['merchant_id'],
		//'quantity'=>$item['quantity'],
		'merchant_fulfillment_item_id'=>$record['shippings_id'],
		'shipper_tracking_number'=>((isset($_REQUEST['shipper_tracking_number'][$item_code]) ) ? $_REQUEST['shipper_tracking_number'][$item_code] : '')
	);
	return $SF->get_order_fulfillment_feed(array($fulfillment));
}
$trackingnumber = (isset($_REQUEST['shipper_tracking_number'][$item_code])) ? $_REQUEST['shipper_tracking_number'][$item_code] : '';
$xml = dbg_get_submitfeed_from_itemcode('47933249429659');
echo $xml->asXML();
exit;
