<?php
use GuzzleHttp\Client;
$inputFile = 'deutsch.php';   // Eingabedatei mit Konstanten
$outputFile = 'englisch.php'; // Zieldatei mit Übersetzungen
function containsWord(string $str): bool {
    return preg_match('/\b[a-zA-ZäöüÄÖÜß]{2,}\b/u', $str) === 1;
}
$apiKey = '066d1f0d-2cc7-453f-bff6-6ffd41147286'; // DeepL API Key
$glossary_id = '8b9d752f-5eb2-4dad-a43c-88ec14ea6321';
$sourceLang = 'DE';
$targetLang = 'EN';
$client = new Client([
    'base_uri' => 'https://api.deepl.com/v2/',
]);


$entries = [
    'EAN'=>'GTIN',
    'Sofortkaufpreis'=>'BIN price',
    'Sofortkauf-Preis'=>'BIN Price',
    'LB'=>'Distributor order',
    'LB-Nr'=>'Distributor order no',
    'ZAHLUNGSERINNERUNG' => 'Dunning letter',
    '1.MAHNUNG'=>'First Dunning letter',
    '2.MAHNUNG'=>'Second Dunning letter',
    'Lagerwarnung'=>'Stock alert',
    'Kasse User'=>'Cashier User',
    'Kasseuser'=>'Cashier User',
    'Variante'=>'Variation',
    'Varianten'=>'Variations',
    'Variantenmerkmal'=>'Variation specific',
    'Variantenmerkmals'=>'Variation specific',
    'Variantenmerkmale'=>'Variation specifics',
    'Variantenbilder'=>'Variation images',
    'Variantenbilderzuweisung'=>'Variation images allocation',
    'Variantenset'=>'Variation Set',
    'Variantenauktionen'=>'auctions with variations',
    'Variantenauktion'=>'auction with variations',
    'Bewert.-reminder'=>'Feedback Reminder',
    'EK-Preis'=>'Purchase price',
    'EK-Preise'=>'Purchase prices',
    'Rekla-Nr'=>'Complaint No',
    'Reklamationsnummer'=>'Complaint No',
    'Seteintrag'=>'Set item',
    'Seteintrags'=>'Set item',
    'Seteinträge'=>'Set items',
    'Rundschreiben'=>'Newsletter',
    'Rundbrief'=>'Newsletter',
    'SammlerID'=>'eBay Lister ID',
    'SammlerIDs'=>'eBay Lister IDs',
    'Sammler-ID'=>'Lister ID',
    'Sammler-IDs'=>'Lister IDs',
    'Re-Nr'=>'Invoice No',
    'RE-Nr'=>'Invoice No',
    'Auftragsnr.'=>'Order No',
    'Bestell-Nr'=>'Order No',
    'Bestellnr.'=>'Order No',
    'ReNr'=>'Order No',
    'Kd-Nr.'=>'cID',
    'Sammler'=>'eBay Lister',
    'Sammlers'=>'eBay Lister',
    'Ebaysammler'=>'eBay Lister',
    'Ebaysammlers'=>'eBay Lister',
    'Sammlerprodukt'=>'eBay Lister Item',
    'Sammlerprodukts'=>'eBay Lister Item',
    'Sammlerproduktes'=>'eBay Lister Item',
    'Sammlerprodukte'=>'eBay Lister Items',
    'Sammlerprodukten'=>'eBay Lister Items',
    'Sammlerartikel'=>'eBay Lister Item',
    'Sammlerartikels'=>'eBay Lister Item',
    'Sammlerartikeln'=>'eBay Lister Items',
    'Stklistenprodukt'=>'SET',
    'Stklistenprodukts'=>'SET',
    'Stklistenproduktes'=>'SET',
    'Stücklistenprodukt'=>'SET',
    'Stücklistenprodukte'=>'SETS',
    'Stklistenartikel'=>'SET',
    'Stklistenartikels'=>'SET',
    'Stücklistenartikel'=>'SET',
    'Stücklistenartikels'=>'SET',
];


if(isset($_GET['glossaries'])){

    $gclient = new Client([
        'base_uri' => 'https://api.deepl.com/v3/',
    ]);

    $glossary_action = $_GET['glossary_action']??'';
    switch($glossary_action){
        case 'delete':
            $gid = $_GET['gid']??null;
            if($gid === null){
                throw new Exception('No glossary id for deletion');
            }
            $response = $gclient->request('DELETE', 'glossaries/'.$gid, [
                'headers'=>[
                    'Authorization'=>'DeepL-Auth-Key '.$apiKey,
                ],
            ]);
            $messageStack->add_session('deepl glossar '.$gid.' wurde gelöscht','success');
            xtc_redirect(xtc_href_link('system.php',xtc_get_all_get_params(array('glossaries','glossary_action','gid'))));
            break;
        case 'create':
            $entries_array = [];
            foreach($entries as $ke=>$kv){
                $entries_array[] = sprintf("%s\t%s",$ke,$kv);
            }
            $tsv = implode("\n",$entries_array);
            $response = $gclient->request('POST', 'glossaries', [
                'headers'=>[
                    'Authorization'=>'DeepL-Auth-Key '.$apiKey,
                    'Content-Type'=> 'application/json',
                ],
                'json'=>[
                    'name' => 'yes4trade-glossar',
                    'dictionaries'=>[
                        [
                            'source_lang' => $sourceLang,
                            'target_lang' => $targetLang,
                            'entries_format' => 'tsv',
                            'entries' => $tsv
                        ]
                    ]
                ]
            ]);
            $glossary = json_decode($response->getBody(), true);
            $glossaryId = $glossary['glossary_id'];
            $messageStack->add_session('deepl glossar '.$glossaryId.' wurde erzeugt','success');
            xtc_redirect(xtc_href_link('system.php',xtc_get_all_get_params(array('glossaries'))));
            break;
    }

    $response = $gclient->request('GET', 'glossaries', [
        'headers'=>[
            'Authorization'=>'DeepL-Auth-Key '.$apiKey,
        ]
    ]);
    $glossaries = json_decode($response->getBody(), true);
    echo '<ul style="list-style-type:none;">';
    foreach($glossaries['glossaries'] as $g){
        printf('<li>%s vom %s (%s to %s)&nbsp;<button onclick="window.location.href=\'%s\'">Löschen</button>&nbsp;<i style="color:#666;">%s</i></li>',
            $g['name'],yes_date_short($g['creation_time']),
            $g['dictionaries'][0]['source_lang']??'-',
            $g['dictionaries'][0]['target_lang']??'-',
            xtc_href_link('system.php',xtc_get_all_get_params(array('glossary_action','gid')).'glossary_action=delete&gid='.$g['glossary_id']),
            $g['glossary_id']
        );
    }
    echo '</ul>';
    printf('<br /<br /><a href="%s"><button>Neuen Glossaries Eintrag erstellen</button></a>',
        xtc_href_link('system.php',xtc_get_all_get_params(array('glossary_action')).'glossary_action=create'),
    );

    exit;
}


/*
// Dann beim Übersetzen:
$response = $client->post('https://api.deepl.com/v2/translate', [
    'form_params' => [
        'auth_key' => $apiKey,
        'text' => 'eBay Sammler für Briefmarken',
        'source_lang' => 'DE',
        'target_lang' => 'EN',
        'glossary_id' => $glossaryId
    ]
]);

*/














//https://www.deepl.com/de/home
//agri@yes-websolutions.de
//hgf-D9_:LKjca/%3_pq/k7
//Name: DeepL API Key
//API-Schlüssel:066d1f0d-2cc7-453f-bff6-6ffd41147286

if(isset($_GET['query']) and !empty($_GET['query'])){
    // DeepL API aufrufen
    $find = [];
    $replace = [];
    if(isset($_GET['replaces'])){
        $replace_parts = explode('|',$_GET['replaces']);
        foreach($replace_parts as $repl){
            $rep_parts = explode(':',$repl);
            $find[] = $rep_parts[1];
            $replace[] = $rep_parts[0];
        }
    }
    $str = mb_convert_encoding($_GET['query'], 'UTF-8', 'auto');
    foreach($find as $r){
        $search = $r;
        $replace_str = '<keep>'.$r.'</keep>';
        $pos = strpos($str, $search); // Position des ersten Vorkommens finden
        if ($pos !== false) {
            $str = substr_replace($str, $replace_str, $pos, strlen($search));
        }
    }
    try {
        $response = $client->post('translate', [
            'form_params' => [
                'auth_key' => $apiKey,
                'text' => $str,
                'source_lang' => $sourceLang,
                'target_lang' => $targetLang,
                'tag_handling' => 'xml',
                'ignore_tags' => 'keep',
                'glossary_id'=>$glossary_id
            ],
        ]);

        $result = json_decode($response->getBody(), true);
        $translated = $result['translations'][0]['text'] ?? '';
        $translation = strip_tags($result['translations'][0]['text']) ?? 'Keine deepl Übersetzung erhalten';
        $str = $translation;
        foreach($find as $rk=>$r){
            $search = $r;
            $replace_str = $replace[$rk];
            $pos = strpos($str, $search); // Position des ersten Vorkommens finden
            if ($pos !== false) {
                $str = substr_replace($str, $replace_str, $pos, strlen($search));
            }
        }
        die(json_encode([
            'MSG'=>'',
            'TRANSLATION'=>$translation,
            'TRANSLATION_REPLACE'=>$str
        ]));
    } catch (Exception $e) {
        die(json_encode([
            'MSG'=>"Fehler bei Übersetzung: " . $e->getMessage()
        ]));
    }

}
if(!is_dir(DIR_FS_CATALOG.'lang/english_temp/')){
    mkdir(DIR_FS_CATALOG.'lang/english_temp');
}
if(!is_dir(DIR_FS_CATALOG.'lang/english_temp/admin/')){
    mkdir(DIR_FS_CATALOG.'lang/english_temp/admin');
}
$todo_list = [];
$src_dir = DIR_FS_CATALOG.'lang/german/admin/';
$src_dir_files = scandir($src_dir);

$target_dir = DIR_FS_CATALOG.'lang/english_temp/admin/';
if(isset($_POST['contents']) and isset($_POST['file'])){
    $new_file = $target_dir.basename($_POST['file']);
    if(is_file($new_file)){
        unlink($new_file);
    }
    file_put_contents($new_file,'<?php'."\n".str_replace(';',";\n",stripslashes($_POST['contents'])));
    die('OK');
}
$target_dir_files = scandir($target_dir);
$current_todo_file_nr = 0;
foreach($src_dir_files as $sf){
    if(in_array($sf,['.','..'])){
        continue;
    }
    if(in_array($sf,$target_dir_files) or substr($sf,-3,3)!=='php'){
        continue;
    }
    $todo_list[] = $sf;
}
$filename = $_GET['file'] ?? current($todo_list);
foreach($todo_list as $k=>$v){
    if($v == $filename){
        $current_todo_file_nr = $k;
    }
}
$filename = DIR_FS_CATALOG.'lang/german/admin/'.$filename;

$content = file_get_contents($filename);

// Regulärer Ausdruck für define()
$pattern = '/define\s*\(\s*[\'"]([^\'"]+)[\'"]\s*,\s*[\'"]((?:\\\\.|[^\'"\\\\])*)[\'"]\s*\)\s*;/';
// Ergebnis-Array
$defines = [];

if (preg_match_all($pattern, $content, $matches, PREG_SET_ORDER)) {
    foreach ($matches as $match) {
        // Unescape mögliche escaped quotes etc.
        $key = stripslashes($match[1]);
        $value = stripslashes( html_entity_decode($match[2]) );
        $defines[$key] = str_replace('"','\"',$value);
    }
}
$one_words = 0;
$more_words = 0;
$regexp_items = 0;
$one_words_array = [];
$more_words_array = [];
$regexp_array = [];
foreach($defines as $key=>$def){
    if(str_word_count($def)==1 and containsWord($def)){
        $one_words++;
        $one_words_array[] = ['key'=>$key,'value'=>$def];
    }else{
        if(strpos($def,'%s') > -1 or strpos($def,'%d') > -1){
            $regexp_array[] = ['key'=>$key,'value'=>$def];
            $regexp_items++;
        }else{
            $more_words_array[] = ['key'=>$key,'value'=>$def];
            $more_words++;
        }
    }

}
if(sizeOf($one_words_array)){
    // mehrere text[]= Einträge hinzufügen
    $owa_counter = 0;
    $chunks = array_chunk($one_words_array, 50); // Aufteilen in 10er-Blöcke
    foreach($chunks as $chunk){
        $txt_array = [];
        foreach ($chunk as $ch) {
            $txt_array[] = mb_convert_encoding($ch['value'], 'UTF-8', 'auto');
        }
        try{
            $response = $client->post('translate',[
            	'headers'=>[
            		 'Content-Type' => 'application/json; charset=utf-8'
            	],
                'json' => [
                    'auth_key' => $apiKey,
                    'text' => $txt_array,
                    'source_lang' => $sourceLang,
                    'target_lang' => $targetLang,
                    'glossary_id'=>$glossary_id
                ],
            ]);
            $result = json_decode($response->getBody(), true);
            foreach($result['translations'] as $tr){
                $one_words_array[$owa_counter]['value']=$tr['text'];
                $owa_counter++;
            }
        }catch(Exception $e){
            yes_debug($txt_array);
            echo 'Da ist noch ein Fehler. Vermutlich einer der Werte die übersetzt werden sollen mit falschem Charset.';
            exit;
        }

    }
}
if(sizeOf($more_words_array)){
    // mehrere text[]= Einträge hinzufügen
    $owa_counter = 0;
    $chunks = array_chunk($more_words_array, 50); // Aufteilen in 10er-Blöcke
    foreach($chunks as $chunk){
        $txt_array = [];
        foreach ($chunk as $ch) {
            $txt_array[] = mb_convert_encoding($ch['value'], 'UTF-8', 'auto');
        }
        try{
            $response = $client->post('translate',[
            	'headers'=>[
            		 'Content-Type' => 'application/json; charset=utf-8'
            	],
                'json' => [
                    'auth_key' => $apiKey,
                    'text' => $txt_array,
                    'source_lang' => $sourceLang,
                    'target_lang' => $targetLang,
                    'glossary_id'=>$glossary_id
                ],
            ]);
            $result = json_decode($response->getBody(), true);
            foreach($result['translations'] as $tr){
                $more_words_array[$owa_counter]['value']=$tr['text'];
                $owa_counter++;
            }
        }catch(Exception $e){
            yes_debug($txt_array);
            echo 'Da ist noch ein Fehler bei morewords. Vermutlich einer der Werte die übersetzt werden sollen mit falschem Charset.';
            exit;
        }

    }
}

yes_draw_pre_header();
yes_draw_header(TITLE);
?>

<style>
    .morewords{
        color: green;
        cursor: pointer;
    }
    .oneword{
        color: darkblue;
        cursor: pointer;
    }
    .regexp_translated{
        color: red;
        font-style: italic;
        cursor: pointer;

    }
    button {
        background-color: darkolivegreen;
        color:white;
        padding: 4px;
        margin-right: 4px;

    }
    button.yep{
        background-color: black;
        color:rgb(255, 243, 173);
        font-family: monospace, system;
    }
    #platzhalter{
        display: none;
    }
    #platzhalter .actions{
        font-size: 0.8em;
    }
    #platzhalter input{
        margin-top: 10px;
        padding: 4px;
        font-size: 1.2em;
    }
    #platzhalter .ph{
        border: 1px dashed #666;
        padding:2px;
        color:#FFF;
    }
    #platzhalter .current{
        font-weight: bold;
        border: 1px dashed #FFF;
        padding:2px;
        color:#FFF;
    }
    #replace_string_preview{
        color: lime;
        background-color: black;
        font-family: monospace, system;
        padding-top: 10px;
        padding-bottom: 10px;
        padding-left: 10px;
        font-size: 1.2em;
    }
    #replace_string_preview_deepl_intro{
        display: none;
    }
    #replace_string_preview_deepl{
        color: lime;
        background-color: black;
        font-family: monospace, system;
        padding: 10px;
        padding-left: 20px;
        margin-bottom: 10px;
        display: none;
        border: 1px solid #000;
    }
    #replace_string_preview_yes{
        background-color:rgb(255, 243, 173);
        font-family: monospace, system;
        color: black;
        display: none;
        border: 1px solid #000;
        padding-top: 10px;
        padding-bottom: 10px;
        margin-bottom: 5px;
        padding-left: 10px;
        font-size: 1.2em;
    }
    #replace_string_preview_nav{
        display: flex;
        margin-bottom: 14px;
    }
    #replace_string_preview_nav a{
        color: black;
        font-size: 0.9em;
        margin-right: 25px;
    }
    .current_constant_name{
        margin-left: 30px;
    }
    .translated{
        background-color: green;
        color: white;
    }
    #filepreview{
        background-color: beige;
        padding: 2px;
    }
    #save_file{
        padding: 10px;
        display: none;
    }
</style>
<script>

    var CURRENT_REPLACE_STRING = '';
    var CURRENT_REPLACE_STRING_PH = '';
    var CURRENT_REPLACES_CURRENT = 0;
    var CURRENT_REPLACES_NUM = 0;
    var CURRENT_TRANSLATED_VALUE = '';
    var CURRENT_TRANSLATED_CONSTANT = '';
    var current_regexp_entry_nr = 0; // laufende nummer fuer aktuelle konstante
    function ph_draw_current(){
        console.log('ph_draw_current()');
        $('#replace_string_preview_nav').html('');
        $('#replace_string_preview .ph').removeClass('current');
        $('#replace_string_preview .ph:nth-child('+(CURRENT_REPLACES_CURRENT+1)+')').addClass('current');
        if(CURRENT_REPLACES_CURRENT == CURRENT_REPLACES_NUM){
            cur = CURRENT_REPLACES_NUM;
        }else{
            cur = (CURRENT_REPLACES_CURRENT+1);
        }
        $('#replace_string_status').html('Platzhalter '+cur+'/'+CURRENT_REPLACES_NUM);
        if(CURRENT_REPLACES_NUM > 1 && CURRENT_REPLACES_CURRENT>0){
            $('#replace_string_preview_nav').append('<div><a href="javascript:ph_last();">&#129144; Voriger Platzhalter</a></div>');
        }
        if(CURRENT_REPLACES_NUM > 1 && (CURRENT_REPLACES_CURRENT+1) < CURRENT_REPLACES_NUM){
            $('#replace_string_preview_nav').append('<div><a href="javascript:ph_next();">Nächster Platzhalter  &#129146;</a></div>');
        }
    }

    function ph_next(){
        console.log('ph_next() CURRENT_REPLACES_NUM: '+CURRENT_REPLACES_NUM+' / CURRENT_REPLACES_CURRENT: '+CURRENT_REPLACES_CURRENT);
        if(CURRENT_REPLACES_NUM > CURRENT_REPLACES_CURRENT){
            CURRENT_REPLACES_CURRENT++;
            ph_draw_current();
        }
    }
    function ph_last(){
        console.log('ph_last() CURRENT_REPLACES_NUM: '+CURRENT_REPLACES_NUM+' / CURRENT_REPLACES_CURRENT: '+CURRENT_REPLACES_CURRENT);
        if(CURRENT_REPLACES_NUM > 0 && CURRENT_REPLACES_CURRENT > 0){
            CURRENT_REPLACES_CURRENT--;
            ph_draw_current();
        }
    }

    function ph_save(){
        console.log('ph_save()');
        $('#translated_key_'+CURRENT_TRANSLATED_CONSTANT).text(CURRENT_TRANSLATED_VALUE.replaceAll('\\"','')).parent().addClass('translated');
        if($('.regexp_translated:not(.translated)').length>0){
            yesDeeplVorschlag($('.regexp_translated:not(.translated)').first());
        }else{
            $('#platzhalter').dialog('destroy');
            $('#filepreview .oneword,#filepreview .morewords').show();
            $('#save_file').show();
        }
    }
    function ph_query(){
        console.log('ph_query()',$('#replace_string_preview').text());
        $('#replace_string_preview_deepl_intro').hide();
        $('#replace_string_preview_deepl').hide().text('');
        $('#replace_string_preview_yes').hide().text('');
        var str = $('#replace_string_preview').text();
        var replaces = new Array();
        $('.ph').each(function(){
            replaces.push( $(this).data('regexp')+':'+$(this).text() );
        });
        showPreloader();
        $.ajax({
            url: '?action=lang&query='+encodeURIComponent(str)+'&replaces='+encodeURIComponent(replaces.join('|')),
            dataType: 'json',
            async: false,
            success: function(json){
                hidePreloader();
                if(json.MSG != ''){
                    alert(json.MSG);
                    return;
                }
                $('#replace_string_preview_deepl_intro').show();
                $('#replace_string_preview_deepl').show().html(json.TRANSLATION);
                $('#replace_string_preview_yes').show().html('<button onclick="ph_save()" class="yep">&#128190;</button> '+json.TRANSLATION_REPLACE);
                CURRENT_TRANSLATED_VALUE = json.TRANSLATION_REPLACE;
                CURRENT_TRANSLATED_CONSTANT = $('.current_constant_name').text();
            },
            error: function( xhr ){
                hidePreloader();
                alert('deepl Query fehlgeschlagen');
            }
        })
    }

    function ph_replace(value){
        console.log('ph_replace(value)',value);
        var child_nr = (CURRENT_REPLACES_CURRENT < CURRENT_REPLACES_NUM)?(CURRENT_REPLACES_CURRENT+1):CURRENT_REPLACES_NUM;
        $('.ph:nth-child('+child_nr+')').text(value);
        if(CURRENT_REPLACES_CURRENT < CURRENT_REPLACES_NUM){
            ph_next();
        }
        if(CURRENT_REPLACES_CURRENT === CURRENT_REPLACES_NUM){
            ph_draw_current();
            ph_query();
        }
    }

    function yesDeeplVorschlag( dentry ){
        console.log('yesDeeplVorschlag(dentry)',$(dentry).data('dvalue'));

        $('#replace_string_preview_deepl_intro').hide();
        $('#replace_string_preview_deepl').hide().text('');
        $('#replace_string_preview_yes').hide().text('');
        CURRENT_REPLACES_CURRENT = 0;
        CURRENT_REPLACE_STRING = $(dentry).data('dvalue');
        CURRENT_REPLACE_STRING_PH = CURRENT_REPLACE_STRING.replace(/%[sd]/g, match => `<span class="ph" data-regexp="${match}">${match}</span>`);
        $('#replace_string_preview').html(CURRENT_REPLACE_STRING_PH);
        CURRENT_REPLACES_NUM = $('#replace_string_preview .ph').length;

        var total_num_regexps = $('.regexp_translated').length; // die angezeigten regexps in der file preview
        $('.current_constant_name').text( $(dentry).data('dkey') );
        current_regexp_entry_nr++;
        $('#platzhalter').dialog({
            modal:true,
            title: 'Platzhalter Sprachkonstante '+current_regexp_entry_nr+'/'+total_num_regexps+' ersetzen',
            width: 'auto',
            open: ph_draw_current()
        });
    }

    $(function(){
        CURRENT_REPLACES_CURRENT = 0;
        $('#platzhalter button').each(function(){
            $(this).on('click',function(){
                if($(this).text() == ''){
                    return;
                }
                ph_replace($(this).text());
            });
        });
        if($('.regexp_translated').length<1){
            $('#save_file').show();
        }else{
            $('#filepreview .oneword,#filepreview .morewords').hide();
        }

    });
    function ph_start(){
        console.log('ph_start()',$('.regexp_translated').length);
        if($('.regexp_translated').length>0){
            yesDeeplVorschlag($('.regexp_translated').first());
        }else{
            $('#filepreview .oneword,#filepreview .morewords').show();
            $('#save_file').show();
        }
    }

    function save_lang_file(){
        showPreloader();
        $.ajax({
            url: '<?php echo xtc_href_link('system.php',xtc_get_all_get_params());?>',
            data: {
                contents: $('.phpcode').text(),
                file: '<?php echo basename($filename); ?>',
            },
            method: 'POST',
            success:function(response){
                hidePreloader();
                if(response == 'OK'){
                    $('#filepreview').html('<h2>&nbsp;✅ Übersetzte Datei gespeichert.</h2>');
                }
            },
            error: function(xhr){
                hidePreloader();
                alert('Cant save lang file');
            }
        });
    }

</script>
<div style="margin-left: 20px;">
    <h1><img align="left" style="padding-right: 20px;" src="https://static.deepl.com/img/logo/deepl-logo-blue.svg" alt="DeepL Logo" width="30"> yes DeepL Converter</h1>
    <nav>

<?php
if($current_todo_file_nr > 0){
?>

        <a href="<?php echo xtc_href_link('system.php',xtc_get_all_get_params(array('file')).'file='.$todo_list[$current_todo_file_nr-1]); ?>"><button>Vorige Datei</button></a>

<?php } ?>

    <b>Datei <?php echo $current_todo_file_nr+1;?> / <?php echo sizeOf($todo_list); ?></b>

<?php
if($current_todo_file_nr < sizeOf($todo_list)){
?>

        <a href="<?php echo xtc_href_link('system.php',xtc_get_all_get_params(array('file')).'file='.$todo_list[$current_todo_file_nr+1]); ?>"><button>Nächste Datei</button></a>

<?php } ?>        

    </nav> 

    <div class="ui-widget">
        <h2>🇩🇪 Aktuelle Datei: <?php echo basename($filename); ?></h2>
        <div style="font-size: 1.2em;"><?php echo sizeOf($defines); ?> Language defines gefunden</div>

        <?php if($one_words>0){ ?>
        <div><?php echo $one_words; ?> davon haben <span class="oneword" onclick="javascript:void($('#filepreview .oneword').toggle());">einzelne Wörter</span></div>
        <?php } ?>

        <?php if($more_words>0){ ?>
        <div><?php echo $more_words; ?> davon enthalten <span class="morewords" onclick="javascript:void($('#filepreview .morewords').toggle());">mehr als ein Wort</span></div>
        <?php } ?>

        <?php if($regexp_items>0){ ?>
        <div><?php echo $regexp_items; ?> davon <span class="regexp">enthalten Platzhalter und <a href="javascript:void(ph_start());">müssen manuell erzeugt werden</a></span></div>
        <?php } ?>
    </div>

    <div class="ui-widget-content" style="margin-top: 15px;">
        <div id="platzhalter">
            <div style="margin-bottom: 10px; font-size: 1.4em;text-decoration: italic;">&raquo;<?php echo basename($filename); ?>&laquo;<span class="current_constant_name"></div>
            <div style="margin-bottom: 10px; font-size: 1.2em;" id="replace_string_status"></div>
            <div class="actions">
                <div>Wähle einen Dummy Platzhalter für den fett markierten Platzhalter</div>
                <div style="display:flex;">
                    <div><button>11.03.2023</button></div>
                    <div><button>17</button></div>
                    <div><button>17,83 EUR</button></div>
                    <div><button>Offen</button></div>
                    <div><button>Hamburg</button></div>
                    <div><button>Otto Schmidt</button></div>
                    <div><button>Auto123</button></div>
                    <div><button>Test</button></div>
                </div>
            </div>
            <div style="margin-top:20px;"><span style="font-family: system, monospace; color:#666;font-size:0.7em;">Dieser zusammengesetzte String wird an deepl gesendet um eine zum Kontext passende Übersetzung zu erhalten.<span></div>
            <div id="replace_string_preview"></div>
            <div id="replace_string_preview_nav"></div>
            <div id="replace_string_preview_deepl_intro" style="margin-top:20px;"><span style="font-family: system, monospace; color:#666;font-size:0.7em;">Das hat uns DeepL als Übersetzung zurückgegeben<span></div>
            <div id="replace_string_preview_deepl"></div>
            <div id="replace_string_preview_yes"></div>
        </div>
    </div>
    <!-- BOF FILE PREVIEW //-->
<div id="filepreview">
    <div class="ui-state-highlight" id="save_file"><button onclick="save_lang_file();">🇬🇧 Speichern</button>&nbsp;<?php echo str_replace('/german/','/english_tmp/',$filename); ?></div>
    <pre><code>&lt;?php<span class="phpcode"><?php 
    foreach($one_words_array as $v){
        $class = 'oneword';
        echo "<div class=\"$class\">define('".$v['key']."', '".htmlentities($v['value'])."');</div>";
    }
    foreach($more_words_array as $v){
        $class = 'morewords';
        echo "<div class=\"$class\">define('".$v['key']."', '".htmlentities($v['value'])."');</div>";
    }
    foreach($regexp_array as $v){
        $class = 'regexp_translated';
        echo "<div class=\"$class\" data-dvalue=\"".htmlentities(stripslashes(str_replace('"','',$v['value'])))."\" data-dkey=\"".$v['key']."\">define('".$v['key']."', '<span id=\"translated_key_".$v['key']."\">".htmlentities(stripslashes($v['value']))."</span>');</div>";
    }
    ?></span></pre></code></div>
    <!-- EOF FILE PREVIEW //-->
</div>
<br /><br /><hr noshade="noshade" />
<a class="lbOn" id="system.php?action=lang&glossaries" href="javascript:;" title="DeepL Glossaries">Glossaries</a>
<?php






exit;
